<?php 
require_once __DIR__ . '/../../init.php';
require __DIR__ . '/vendor/autoload.php';
use chillerlan\QRCode\QRCode;
use chillerlan\QRCode\QROptions;
use WHMCS\Database\Capsule;

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Credentials: true");
header("Access-Control-Max-Age: 1000");
header("Access-Control-Allow-Headers: X-Requested-With, Content-Type, Origin, Cache-Control, Pragma, Authorization, Accept, Accept-Encoding");
header("Access-Control-Allow-Methods: PUT, POST, GET, OPTIONS, DELETE");
 

// echo '<pre>';
// print_r($GLOBALS);
// die;

define('WHMCS_FOLDER', 'abhishek_whmcs');
define('MODULE_NAME', 'multi_vision');

$data = json_decode(file_get_contents('php://input'),true);

$errors = [];
$errors['status'] = 'success';
$mac_pattern = '/^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$|^([0-9A-Fa-f]{4}\.){2}([0-9A-Fa-f]{4})$/';

if(!isset($data['action']) || empty(trim($data['action']))){
    $errors['status'] = 'error';
    $errors['message']['action'] = 'Action field is required';
    echo json_encode($errors);
    die;  
    
}

$action = trim($data['action']);

switch ($action) {
    
    //Register device
    case "register_device":

        
        if (!isset($data['api_key']) || (isset($data['api_key']) && trim($data['api_key']) == '')) {
            $errors['status'] = 'error';
            $errors['message']['api_key'] = 'Api key is required';           
        }
        if (!isset($data['api_secret']) || (isset($data['api_secret']) && trim($data['api_secret']) == '')) {
            $errors['status'] = 'error';
            $errors['message']['api_secret'] = 'Api secret key is required';           
        }
        if(!preg_match($mac_pattern, trim($data['mac_address']))){
            $errors['status'] = 'error';
            $errors['message']['mac_address'] = 'Please enter a valid mac address';           
        }

        if (!isset($data['device_details']) || !is_array($data['device_details'])) {
            $errors['status'] = 'error';
            $errors['message']['device_details'] = "Device details field is required.";
        }
        else {

            $allEmpty = true;
            foreach($data['device_details'] as $key => $value){
                if(trim($key) !='' && trim($value) != ''){
                    $allEmpty = false;
                }
            }
            if($allEmpty) {
                $errors['status'] = 'error';
                $errors['message']['device_details'] = "Please enter atleast one property of device.";
            }

        }

        if(trim($errors['status']) == 'error'){
            echo json_encode($errors);
            die;  
        }


        $result = authenticate($data['api_key'],$data['api_secret']);
        if(isset($result['status']) && $result['status'] == 'error'){
            $errors['status'] = $result['status'];
            $errors['message'] = $result['message'];
        }

        if(trim($errors['status']) == 'error'){
            echo json_encode($errors);
            die;  
        }

        
       
       
        if(trim($errors['status']) == 'success'){

            $folder = dirname(dirname(__DIR__)) . '/modules/addons/' . MODULE_NAME . '/images/qr_images/';  
            if (is_dir($folder)) {
                $files = glob($folder . "*");
                foreach ($files as $f) {
                    if (is_file($f)) unlink($f);
                }

                rmdir($folder);
            }

            if (!is_dir($folder)) {
                mkdir($folder, 0777, true);
            }

            

            $fileName = "qr_" . time() . ".png";
            $filePath = $folder . $fileName;
           
            $options = new QROptions([
                'outputType' => QRCode::OUTPUT_IMAGE_PNG,
                'eccLevel'   => QRCode::ECC_L,
                'imageBase64' => false
            ]);

            
            $encmac = md5($data['mac_address']);
            $baseUrl = (isset($_SERVER['HTTPS']) ? "https://" : "http://") . $_SERVER['HTTP_HOST'];
            $redirectUrl = $baseUrl . '/' . WHMCS_FOLDER .'/index.php?m=' . MODULE_NAME . '&action=playlist_list&mid=' . $encmac;
            $qrImage = (new QRCode($options))->render($redirectUrl);
            file_put_contents($filePath, $qrImage);
            $imageURL = $baseUrl . '/' . WHMCS_FOLDER .'/modules/addons/' . MODULE_NAME . '/images/qr_images/' . $fileName;

            if(Capsule::table('tbl_devices')->where('mac_id',$data['mac_address'])->count() == 1){

                $result = Capsule::table('tbl_devices')->where('mac_id',$data['mac_address'])->first();
                echo json_encode([
                    'status' => 'success',
                    'message' => 'Device already exists',
                    'mac_address' => $data['mac_address'],
                    'device_key' => decrypt($result->shareable_device_key),
                    'qr_image_url' => $imageURL,
                    'login_url' => $redirectUrl
                ]);
                     
            }else{
                $device_key = generateUniqueKey();
                Capsule::table('tbl_devices')->insert([
                    'mac_id' => $data['mac_address'],
                    'md5_mac_id' => md5($data['mac_address']),
                    'device_key' => password_hash($device_key, PASSWORD_DEFAULT),
                    'shareable_device_key' => encrypt($device_key),
                    'device_details' => json_encode($data['device_details']),
                    'created_at' => date('Y-m-d,H:i:s'),
                    'updated_at' => date('Y-m-d,H:i:s')
                ]);
                $device_id = Capsule::table('tbl_devices')->where('mac_id',$data['mac_address'])->first()->id;
                Capsule::table('tbl_subscriptions')->insert([
                    'device_id' => $device_id,
                    'product_id' => '',
                    'package_type' => 'trial',
                    'registered_date' => date('Y-m-d'),
                    'expiry_date'     => date('Y-m-d', strtotime('+7 days')),
                    'status' => 'active',
                    'created_at' => date("Y-m-d H:i:s"),
                    'updated_at' => date("Y-m-d H:i:s")
                ]);

                echo json_encode([
                    'status' => 'success',
                    'message' => 'Device registered successfully',
                    'mac_address' => $data['mac_address'],
                    'device_key' => $device_key,
                    'qr_image_url' => $imageURL,
                    'login_url' => $redirectUrl
                ]);
              
            }

        }

        break;
       //Register device
     
    //Add playlist
    case "add_playlist":
       

        if (!isset($data['api_key']) || (isset($data['api_key']) && trim($data['api_key']) == '')) {
            $errors['status'] = 'error';
            $errors['message']['api_key'] = 'Api key is required';           
        }
        if (!isset($data['api_secret']) || (isset($data['api_secret']) && trim($data['api_secret']) == '')) {
            $errors['status'] = 'error';
            $errors['message']['api_secret'] = 'Api secret key is required';           
        }
        if(!preg_match($mac_pattern, trim($data['mac_address']))){
            $errors['status'] = 'error';
            $errors['message']['mac_address'] = 'Please enter a valid mac address';           
        }
        if (!isset($data['device_key']) || (isset($data['device_key']) && trim($data['device_key']) == '')) {
            $errors['status'] = 'error';
            $errors['message']['device_key'] = "Device key field is required.";
        } 
        if (!isset($data['playlist_name']) || (isset($data['playlist_name']) && trim($data['playlist_name']) == '')) {
            $errors['status'] = 'error';
            $errors['message']['playlist_name'] = "Playlist name field is required.";
        } 
        if (!isset($data['playlist_type']) || (isset($data['playlist_type']) && trim($data['playlist_type']) == '')) {
            $errors['status'] = 'error';
            $errors['message']['playlist_type'] = "Playlist type field is required.";
        } 
        if (!isset($data['playlist_value']) || (isset($data['playlist_value']) && trim($data['playlist_value']) == '')) {
            $errors['status'] = 'error';
            $errors['message']['playlist_data'] = "Playlist field is required.";
        } 
        if (!isset($data['username']) || (isset($data['username ']) && trim($data['username ']) == '')) {
            $errors['status'] = 'error';
            $errors['message']['username '] = "Username field is required.";
        } 
        if (!isset($data['password']) || (isset($data['password ']) && trim($data['password ']) == '')) {
            $errors['status'] = 'error';
            $errors['message']['password '] = "Password field is required.";
        } 
        
        
        if(trim($errors['status']) == 'error'){
            echo json_encode($errors);
            die;  
        }


        $result = authenticate($data['api_key'],$data['api_secret']);
        if(isset($result['status']) && $result['status'] == 'error'){
            $errors['status'] = $result['status'];
            $errors['message'] = $result['message'];
        }

        if(trim($errors['status']) == 'error'){
            echo json_encode($errors);
            die;  
        }


       
        $device_id = '';
        if(Capsule::table('tbl_devices')->where('mac_id', $data['mac_address'])->count() == 0){
              $errors['status'] = 'error';
              $errors['message'] = "Mac address does not exists.";
              echo json_encode($errors);
              die;  
        }else{
            $device_id = Capsule::table('tbl_devices')->where('mac_id', $data['mac_address'])->first()->id;
        }

        $record = Capsule::table('tbl_devices')->where('mac_id', $data['mac_address'])->first();
        if(!password_verify($data['device_key'], $record->device_key)){
              $errors['status'] = 'error';
              $errors['message'] = "Invalid device key.";
        }

        if(trim($errors['status']) == 'error'){
            echo json_encode($errors);
            die;  
        }

        if(Capsule::table('tbl_playlists')->where('device_id',$device_id)->where('any_name',trim($data['playlist_name']))->first()){
               $errors['status'] = 'error';
               $errors['message'] = "Playlist name already taken.";
               echo json_encode($errors);
               die; 
        }



        if(trim($errors['status']) == 'success'){
                
                $playlist_code = generateUniqueKey();
                $subscription_id = Capsule::table('tbl_subscriptions')->where('device_id', $device_id)->first()->id;
                Capsule::table('tbl_playlists')->insert([
                    'device_id' => $device_id,
                    'subscription_id' => $subscription_id ?? '',
                    'type' => $data['playlist_type'],
                    'playlists' => $data['playlist_value'],
                    'username' => $data['username'],
                    'password' => password_hash($data['password'], PASSWORD_DEFAULT),
                    'shareable_password' => encrypt($data['password']),
                    'any_name' => $data['playlist_name'],
                    'playlist_code' => $playlist_code,
                    'status' => 'active',
                    'created_at' => date('Y-m-d,H:i:s'),
                    'updated_at' => date('Y-m-d,H:i:s')
                ]);

                echo json_encode([
                    'status' => 'success',
                    'message' => 'Playlist added successfully',
                ]);
                die;   
            
        }

        break;
        //Add playlist

    //Get subscriptions
    case "get_subscriptions":
       

        if (!isset($data['api_key']) || (isset($data['api_key']) && trim($data['api_key']) == '')) {
            $errors['status'] = 'error';
            $errors['message']['api_key'] = 'Api key is required';           
        }
        if (!isset($data['api_secret']) || (isset($data['api_secret']) && trim($data['api_secret']) == '')) {
            $errors['status'] = 'error';
            $errors['message']['api_secret'] = 'Api secret key is required';           
        }
        if(!preg_match($mac_pattern, trim($data['mac_address']))){
            $errors['status'] = 'error';
            $errors['message']['mac_address'] = 'Please enter a valid mac address';           
        }
        if (!isset($data['device_key']) || (isset($data['device_key']) && trim($data['device_key']) == '')) {
            $errors['status'] = 'error';
            $errors['message']['device_key'] = "Device key field is required.";
        } 
       
        if(trim($errors['status']) == 'error'){
            echo json_encode($errors);
            die;  
        }


        $result = authenticate($data['api_key'],$data['api_secret']);
        if(isset($result['status']) && $result['status'] == 'error'){
            $errors['status'] = $result['status'];
            $errors['message'] = $result['message'];
        }

        if(trim($errors['status']) == 'error'){
            echo json_encode($errors);
            die;  
        }


        if(Capsule::table('tbl_devices')->where('mac_id',$data['mac_address'])->count() == 0){
              $errors['status'] = 'error';
              $errors['message'] = "Mac address does not exists.";
              echo json_encode($errors);
              die;  
        }

        $record = Capsule::table('tbl_devices')->where('mac_id',$data['mac_address'])->first();
        if(!password_verify($data['device_key'], $record->device_key)){
              $errors['status'] = 'error';
              $errors['message'] = "Invalid device key.";
              echo json_encode($errors);
              die;

        }

        //scanner code
        $folder = dirname(dirname(__DIR__)) . '/modules/addons/' . MODULE_NAME . '/images/qr_subs_images/';  
        if (is_dir($folder)) {
            $files = glob($folder . "*");
            foreach ($files as $f) {
                if (is_file($f)) unlink($f);
            }

            rmdir($folder);
        }

        if (!is_dir($folder)) {
            mkdir($folder, 0777, true);
        }

          

        $files = glob($folder . "*");
        foreach ($files as $f) {
            if (is_file($f)) unlink($f);
        }

        $fileName = "qr_" . time() . ".png";
        $filePath = $folder . $fileName;
        
        $options = new QROptions([
            'outputType' => QRCode::OUTPUT_IMAGE_PNG,
            'eccLevel'   => QRCode::ECC_L,
            'imageBase64' => false
        ]);

        $baseUrl = (isset($_SERVER['HTTPS']) ? "https://" : "http://") . $_SERVER['HTTP_HOST'];
        $redirectUrl = $baseUrl . '/' . WHMCS_FOLDER .'/cart.php?a=add&pid=4&cf_macaddress=' . $data['mac_address'];
        $qrImage = (new QRCode($options))->render($redirectUrl);
        file_put_contents($filePath, $qrImage);
        $imageURL = $baseUrl . '/' . WHMCS_FOLDER .'/modules/addons/' . MODULE_NAME . '/images/qr_subs_images/' . $fileName;
        //scanner code

        $response_data = [];
        $response_data['status'] = 'success';
        $response_data['mac_id'] = $data['mac_address'];
        $response_data['device_key'] = $data['device_key'];
        $response_data['message'] = 'Playlists fetched successfully';
       
        
        if (Capsule::table('tbl_playlists')->where('device_id', $record->id)->count() > 0) {

            $results = Capsule::table('tbl_playlists')
                        ->leftJoin('tbl_subscriptions', 'tbl_playlists.subscription_id', '=', 'tbl_subscriptions.id')
                        ->where('tbl_playlists.device_id', $record->id)
                        ->select(
                            'tbl_playlists.any_name',
                            'tbl_playlists.type',
                            'tbl_playlists.playlists',
                            'tbl_playlists.username',
                            'tbl_playlists.shareable_password',
                            'tbl_playlists.playlist_code',
                            'tbl_playlists.status as playlist_status',
                            'tbl_subscriptions.package_type',
                            'tbl_subscriptions.product_id',
                            'tbl_subscriptions.status as subscription_status',
                            'tbl_subscriptions.registered_date',
                            'tbl_subscriptions.expiry_date'
                        )
                        ->get();

            $response_data['playlists'] = [];
    
            foreach ($results as $result) {

               
                $hasSubscription =
                    $result->package_type !== null ||
                    $result->product_id !== null ||
                    $result->status !== null ||
                    $result->registered_date !== null ||
                    $result->expiry_date !== null;

                if($result->subscription_status == 'inactive'){
                    $subscriptionData = $hasSubscription ? [
                        'package_type' => $result->package_type,
                        'product_id' => $result->product_id,
                        'status' => $result->subscription_status,
                        'registered_date' => $result->registered_date,
                        'expiry_date' => $result->expiry_date,
                        'payment_url' => $redirectUrl,
                        'payment_image_url' => $imageURL

                    ] : (object)[]; 
                }else{

                    $subscriptionData = $hasSubscription ? [
                        'package_type' => $result->package_type,
                        'product_id' => $result->product_id,
                        'status' => $result->subscription_status,
                        'registered_date' => $result->registered_date,
                        'expiry_date' => $result->expiry_date,

                    ] : (object)[]; 
                }

                $response_data['subscription'] = $subscriptionData;

                $response_data['playlists'][] = [
                    'playlist_name' => $result->any_name,
                    'playlist_type' => $result->type,
                    'playlist_url' => $result->playlists,
                    'username' => $result->username,
                    'password' => decrypt($result->shareable_password),
                    'playlist_code' => $result->playlist_code,
                    'playlist_status' => $result->playlist_status,
                ];
            }

        } else {
            $response_data['message'] = 'No playlists found';
        }

        echo json_encode($response_data);
        break;
        //Get subscriptions
    default:
        $errors['status'] = 'error';
        $errors['message']['action'] = 'Invalid Action';
        echo json_encode($errors);
        die;  
}



function generateUniqueKey()
{
        $plainKey = rand(00000000,99999999);
        $encryptedKey = encrypt($plainKey);
        $exists = Capsule::table('tbl_devices')
            ->where('shareable_device_key', $encryptedKey)
            ->exists();
        if ($exists) {
            return generateUniqueKey();
        }
        return $plainKey;
}


function authenticate($api_key,$api_secret){

    $errors = [];
    if($api_record = Capsule::table('tbl_api_details')->first()){
        if(($api_key != decrypt($api_record->api_key)) || !password_verify($api_secret,$api_record->api_secret)){
            $errors['status'] = 'error';
            $errors['message'] = "Invalid api key or secret key";
            return $errors;
        }
    }else{
        $errors['status'] = 'error';
        $errors['message'] = "Invalid api key or secret key";
    }

    return $errors;
}

?>