<?php

header('Content-Type: application/json');
include_once('../../init.php');

use WHMCS\Database\Capsule;

$action = $_POST['action'] ?? '';

$email = $_POST['email'] ?? '';
$api_key = $_POST['api_key'] ?? '';
$sc = $_POST['sc'] ?? '';
$random = $_POST['random'] ?? '';

$salt = $_POST['salt'] ?? '';;

$int = $email . "*" . $salt . "-" . $api_key . "-" . $random;
$intsc = md5($int);

$validate = validateSc($email, $api_key, $sc, $random, $intsc);

// echo $intsc;
// die;

function validateSc($email, $api_key, $sc, $random, $intsc) {
    if($intsc == $sc) {
        return 'success';
    } else {
        return 'failure';
    }
}

if ($validate == 'failure') {
    echo json_encode([
        'status' => 'error',
        'data' => [],
        'message' => 'Invalid sc!'
    ]);
} else {
    switch ($action) {
        case 'getProducts':
            $pids = Capsule::table('mod_whmcs_subscription_setting')
                ->where('name', 'products')
                ->value('value');
            
            $command = 'GetProducts';
            $postData = array(
                'pid' => $pids,
            );

            $results = localAPI($command, $postData);

            echo json_encode([
                'status' => 'success',
                'data' => $results['products']['product'] ?? '',
                'sc' => $intscs
            ]);
            
            exit;

        case 'addOrder':
            storeOrder($_POST);
        exit;

        case 'validateLogin':

            if (isset($_POST['email']) && isset($_POST['password2'])) {
                validateLogin($_POST['email'], $_POST['password2']);
            } else {
                echo json_encode([
                    'status' => 'error',
                    'data' => [],
                    'message' => 'email and password2 are required fields'
                ]);
                die;
            }
        exit;
        default:
            echo json_encode([
                'status' => 'error',
                'data' => [],
                'message' => 'Invalid action!'
            ]);

        exit;

    }
}

function storeOrder($postdata) {

    if (!$postdata['firstname'] || !$postdata['lastname'] || !$postdata['email'] || !$postdata['password2'] || !$postdata['product_id']) {    
        echo json_encode([
            'status' => 'error',
            'data'   => [],
            'message'   => 'firstname, lastname, email, product_id and password2 is required!',
        ]);
        exit;  
    }

    $data = array(
        'firstname' => $postdata['firstname'],
        'lastname' => $postdata['lastname'],
        'email' => $postdata['email'],
        'password2' => $postdata['password2'],
        'skipvalidation' => true
    );

    $response = localAPI('AddClient', $data);

    if ($response['result'] !== 'success') {
        echo json_encode([
            'status' => 'error',
            'data'   => $response,
            'message'   => 'AddClient Api response is failed!',
        ]);
        exit;
    }

    $command = 'AddOrder';
    $postData = array(
        'clientid' => $response['clientid'],
        'pid' => $postdata['product_id'],
        'paymentmethod' => 'mailin',
    );

    $results = localAPI($command, $postData);

    if ($results['result'] !== 'success') {
        echo json_encode([
            'status' => 'error',
            'data'   => $results,
            'message'   => 'AddOrder Api response is failed!',
        ]);
        exit;
    }

    $invoiceId = $results['invoiceid'];

    $postDatas = array(
        'client_id' => $response['clientid'],
        'destination' => 'sso:custom_redirect',
        'sso_redirect_path' => 'viewinvoice.php?id=' . $invoiceId,
    );

    $resultss = localAPI('CreateSsoToken', $postDatas);

    echo json_encode([
        'status' => 'success',
        'invoice_url' => $resultss['redirect_url'],
        'message' => 'Order created successfully!'
    ]);

    exit;
}

function validateLogin($email, $password) {

    $command = 'ValidateLogin';
    $postData = array(
        'email' => $email,
        'password2' => $password,
    );  

    $results = localAPI($command, $postData);

    if ($results['result'] !== 'success') {
        echo json_encode([
            'status' => 'error',
            'data'   => $results,
            'message'   => 'ValidateLogin Api response is failed!',
        ]);
        exit;
    }

    $userid = $results['userid'];
    
    $postDatas = array(
        'clientid' => '34',
    );

    $results = localAPI('GetClientsProducts', $postDatas);

    $productIds = Capsule::table('mod_whmcs_subscription_setting')
        ->where('name', 'products')
        ->value('value');
    
    
    $productIdsArray = array_map('intval', explode(',', $productIds));

    $matched = false;

    if (!empty($results['products']['product'])) {
        foreach ($results['products']['product'] as $product) {
            $status = $product['status'];
            if (in_array((int)$product['pid'], $productIdsArray, true) && $status === 'Active') {
                $matched = true;
                break;
            }
        }
    }   

    if ($matched) {
        echo json_encode([
            'status' => 'success',
            'data' => [],
            'message' => 'login successfully!',
        ]);
    } else {
        echo json_encode([
            'status' => 'error',
            'data' => [],
            'message' => 'Product service is not active',
        ]);
    }

}






