
<?php
// TEMP DEBUG (remove after)
if (headers_sent($file, $line)) {
    die("Headers already sent in: $file on line: $line");
}
ob_start(); // also helps avoid immediate crash while debugging
/**
 * WHMCS SDK Sample Addon Module
 *
 * An addon module allows you to add additional functionality to WHMCS. It
 * can provide both client and admin facing user interfaces, as well as
 * utilise hook functionality within WHMCS.
 *
 * This sample file demonstrates how an addon module for WHMCS should be
 * structured and exercises all supported functionality.
 *
 * Addon Modules are stored in the /modules/addons/ directory. The module
 * name you choose must be unique, and should be all lowercase, containing
 * only letters & numbers, always starting with a letter.
 *
 * Within the module itself, all functions must be prefixed with the module
 * filename, followed by an underscore, and then the function name. For this
 * example file, the filename is "addonmodule" and therefore all functions
 * begin "addonmodule_".
 *
 * For more information, please refer to the online documentation.
 *
 * @see https://developers.whmcs.com/addon-modules/
 *
 * @copyright Copyright (c) WHMCS Limited 2017
 * @license http://www.whmcs.com/license/ WHMCS Eula
 */

/**
 * Require any libraries needed for the module to function.
 * require_once __DIR__ . '/path/to/library/loader.php';
 *
 * Also, perform any initialization required by the service's library.
 */

use WHMCS\Database\Capsule;
use WHMCS\Module\Addon\MultiVision\Admin\AdminDispatcher;
use WHMCS\Module\Addon\MultiVision\Client\ClientDispatcher;

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

if (!defined("MODULE_NAME")) {
    define('MODULE_NAME', basename(__DIR__));
}



/**
 * Define addon module configuration parameters.
 *
 * Includes a number of required system fields including name, description,
 * author, language and version.
 *
 * Also allows you to define any configuration parameters that should be
 * presented to the user when activating and configuring the module. These
 * values are then made available in all module function calls.
 *
 * Examples of each and their possible configuration parameters are provided in
 * the fields parameter below.
 *
 * @return array
 */
function multi_vision_config()
{
    return [
      
        'name' => 'Multi Vision',
        'description' => 'This module provides an example WHMCS Addon Module'
            . ' which can be used as a basis for building a custom addon module.',
        'author' => 'Your name goes here',
        'language' => 'english',
        'version' => '1.0',
       
    ];
}

/**
 * Activate.
 *
 * Called upon activation of the module for the first time.
 * Use this function to perform any database and schema modifications
 * required by your module.
 *
 * This function is optional.
 *
 * @see https://developers.whmcs.com/advanced/db-interaction/
 *
 * @return array Optional success/failure message
 */
function multi_vision_activate()
{
    // Create custom tables and schema required by your module
    try {
        if (!Capsule::schema()->hasTable('tbl_devices')) {
                Capsule::schema()->create(
                        'tbl_devices',
                        function ($table) {
                            /** @var \Illuminate\Database\Schema\Blueprint $table */
                            $table->increments('id');
                            $table->string('mac_id');
                            $table->text('md5_mac_id');
                            $table->string('user_id');
                            $table->string('device_key');
                            $table->string('shareable_device_key');
                            $table->text('device_details');
                            $table->timestamps();  
                            
                        }
                );
        }
        if (!Capsule::schema()->hasTable('tbl_subscriptions')) {
                Capsule::schema()->create(
                        'tbl_subscriptions',
                        function ($table) {
                            /** @var \Illuminate\Database\Schema\Blueprint $table */
                            $table->increments('id');
                            $table->string('device_id');
                            $table->string('product_id');
                            $table->string('package_type');
                            $table->string('status');
                            $table->string('registered_date');
                            $table->string('expiry_date');
                            $table->timestamps();  
                            
                        }
                );
        }
        if (!Capsule::schema()->hasTable('tbl_playlists')) {
                Capsule::schema()->create(
                        'tbl_playlists',
                        function ($table) {
                            /** @var \Illuminate\Database\Schema\Blueprint $table */
                            $table->increments('id');
                            $table->string('device_id');
                            $table->string('subscription_id');
                            $table->string('type');
                            $table->string('playlists');
                            $table->string('username');
                            $table->string('password');
                            $table->string('shareable_password');
                            $table->string('any_name');
                            $table->string('playlist_code');
                            $table->string('status');
                            $table->timestamps();  
                            
                        }
                );
        }

         if (!Capsule::schema()->hasTable('tbl_api_details')) {
                Capsule::schema()->create(
                        'tbl_api_details',
                        function ($table) {
                            /** @var \Illuminate\Database\Schema\Blueprint $table */
                            $table->increments('id');
                            $table->string('api_key');
                            $table->string('api_secret');
                            $table->timestamps();  
                            
                        }
                );
        }

        return [
            'status' => 'success',
            'description' => 'All required tables created successfully.',
        ];
    } catch (\Exception $e) {
        return [
            // Supported values here include: success, error or info
            'status' => "error",
            'description' => 'Unable to create mod_addonexample: ' . $e->getMessage(),
        ];
    }
}

/**
 * Deactivate.
 *
 * Called upon deactivation of the module.
 * Use this function to undo any database and schema modifications
 * performed by your module.
 *
 * This function is optional.
 *
 * @see https://developers.whmcs.com/advanced/db-interaction/
 *
 * @return array Optional success/failure message
 */
function multi_vision_deactivate()
{
    // Undo any database and schema modifications made by your module here
    try {
        Capsule::schema()
            ->dropIfExists('tbl_devices');
        Capsule::schema()
            ->dropIfExists('tbl_subscriptions');
        Capsule::schema()
            ->dropIfExists('tbl_playlists');
        Capsule::schema()
            ->dropIfExists('tbl_api_details');

        return [
            'status' => 'success',
            'description' => 'All tables removed successfully.',
        ];
    } catch (\Exception $e) {
        return [
            // Supported values here include: success, error or info
            "status" => "error",
            "description" => "Unable to drop mod_addonexample: {$e->getMessage()}",
        ];
    }
}



/**
 * Admin Area Output.
 *
 * Called when the addon module is accessed via the admin area.
 * Should return HTML output for display to the admin user.
 *
 * This function is optional.
 *
 * @see AddonModule\Admin\Controller::index()
 *
 * @return string
 */
function multi_vision_output($vars)
{
    // Get common module parameters
    $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
    $version = $vars['version']; // eg. 1.0
    $_lang = $vars['_lang']; // an array of the currently loaded language variables

    // Get module configuration parameters
    $configTextField = $vars['Text Field Name'];
    $configPasswordField = $vars['Password Field Name'];
    $configCheckboxField = $vars['Checkbox Field Name'];
    $configDropdownField = $vars['Dropdown Field Name'];
    $configRadioField = $vars['Radio Field Name'];
    $configTextareaField = $vars['Textarea Field Name'];

    // Dispatch and handle request here. What follows is a demonstration of one
    // possible way of handling this using a very basic dispatcher implementation.

    $action = isset($_REQUEST['action']) ? $_REQUEST['action'] : '';

    $dispatcher = new AdminDispatcher();
    $response = $dispatcher->dispatch($action, $vars);
    echo $response;
}



/**
 * Client Area Output.
 *
 * Called when the addon module is accessed via the client area.
 * Should return an array of output parameters.
 *
 * This function is optional.
 *
 * @see AddonModule\Client\Controller::index()
 *
 * @return array
 */
function multi_vision_clientarea($vars)
{

    $action = isset($_REQUEST['action']) ? $_REQUEST['action'] : '';

    $dispatcher = new ClientDispatcher();
    return $dispatcher->dispatch($action, $vars);
}
