<style>
/* loader css */
    #preloader {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: #fff; 
        display: flex;
        justify-content: center;
        align-items: center;
        z-index: 9999; 
    }

    .loader-spinner {
        border: 8px solid #f3f3f3; 
        border-top: 8px solid #3498db; 
        border-radius: 50%;
        width: 50px;
        height: 50px;
        animation: spin 1s linear infinite; 
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
/* loader css */
</style>
<div class="container">
    <div id="preloader">
        <div class="loader-spinner"></div> 
    </div>
    <div class="row">
        <div class="col-md-6">
         <button class="btn btn-success add_new_playlist" style="margin-bottom:-80px;">New Playlist</button>
        </div>
        <div class="col-md-6">
            <table class="table table-borderless">
                <thead>
                    <th>MAC ADDRESS</th>
                    <th>SUBSCRIPTION</th>
                    <th>NEXT DUE DATE</th>
                </thead>
                <tbody>
                    <tr>
                        <td>
                            {$data['macId']}
                        </td>
                        <td>
                            {if $data.package_type == 'PAID'}
                                <span class="badge badge-success">{$data.package_type}</span>
                            {else}
                                <span class="badge badge-warning">{$data.package_type}</span>
                            {/if}
                        </td>
                        <td>
                            {$data['next_due_date']}
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    {if $data['success'] != ''}
    <div class="alert alert-success mt-4">{$data['success']}</div>
    {/if}
    {if $data['error'] != ''}
    <div class="alert alert-danger mt-4">{$data['error']}</div>
    {/if}
    <table class="table table-hover table-bordered" id="myTable">
        <thead>
            <tr>
                <th>ID</th>
                <th>Name</th>
                <th>Mac ID</th>
                <th>Subscription</th>
                <th>Playlist Url</th>
                <th>Username</th>
                <th>Password</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            {foreach $data['records'] as $record}
                <tr>
                    <td>{$record->id}</td>
                    <td>{$record->any_name}</td>
                    <td>{$record->mac_id}</td>
                    <td> 
                        {if $record->package_type == ''}
                            <span>Not Available</span>
                        {elseif $record->package_type == 'paid'}
                            <span class="badge badge-success">PAID</span>
                        {elseif $record->package_type == 'trial'}
                            <span class="badge badge-warning">TRIAL</span>
                        {/if}

                    </td>
                    <td>{$record->playlists}</td>
                    <td>{$record->username}</td>
                    <td>{decrypt($record->shareable_password)}</td>
                    <td>{($record->status == 'active')?'<span class="badge bg-success text-white">Active</span>':'<span class="badge bg-danger text-white">Inactive</span>'}</td>
                    <td><button class="btn btn-success edit_playlist" data-id="{$record->id}"><i class="fa fa-edit"></i></button><button class="btn btn-danger delete_playlist" data-id="{$record->id}"><i class="fa fa-trash"></i></button></td>
                </tr>
            {/foreach}
        </tbody>
    </table>
</div>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="modules/addons/{MODULE_NAME}/assets/js/script.js"></script>


<link rel="stylesheet" href="https://cdn.datatables.net/2.3.5/css/dataTables.dataTables.css" />
<script src="https://cdn.datatables.net/2.3.5/js/dataTables.js"></script>
<script>
 let table = new DataTable('#myTable');
</script>