 <style>
/* loader css */
    #preloader {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: #fff; 
        display: flex;
        justify-content: center;
        align-items: center;
        z-index: 9999; 
    }

    .loader-spinner {
        border: 8px solid #f3f3f3; 
        border-top: 8px solid #3498db; 
        border-radius: 50%;
        width: 50px;
        height: 50px;
        animation: spin 1s linear infinite; 
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
/* loader css */
</style>
 
<div class="container-fluid">
    <div id="preloader">
        <div class="loader-spinner"></div> 
    </div>
    <div class="row">
        <div class="col-md-6">
         <button class="btn btn-success list_playlist" style="margin-bottom:-40px;">Playlist List</button>
        </div>
        <div class="col-md-6">
            <table class="table table-borderless">
                <thead>
                    <th>MAC ADDRESS</th>
                    <th>SUBSCRIPTION</th>
                    <th>NEXT DUE DATE</th>
                </thead>
                <tbody>
                    <tr>
                        <td>
                            {$data['macId']}
                        </td>
                        <td>
                            {if $data.package_type == 'PAID'}
                                <span class="badge badge-success">{$data.package_type}</span>
                            {else}
                                <span class="badge badge-warning">{$data.package_type}</span>
                            {/if}
                        </td>
                        <td>
                            {$data['next_due_date']}
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    {if !$data['validated'] }
        <div class="alert alert-danger">
            {foreach $data['errors'] as $error }
             {$error}
            {/foreach}
        </div>
    {/if}
    <form method="POST">
        <div class="form-group">
            <label>Name:</label>
            <input type="text" class="form-control {(isset($data['errors']['playlist_name']))?'border-danger':''}" placeholder="Enter playlist name" name="playlist_name" value="{$data['playlist_name']}">
        </div>
        <div class="form-group">
            <label>Playlist Url:</label>
            <input type="text" class="form-control {(isset($data['errors']['playlist']))?'border-danger':''}" placeholder="Enter playlist" name="playlist" value="{$data['playlist']}">
        </div>
        <div class="form-group">
            <label>Username:</label>
            <input type="text" class="form-control {(isset($data['errors']['username']))?'border-danger':''}" placeholder="Enter username" name="username" value="{$data['username']}">
        </div>
        <div class="form-group">
            <label>Password:</label>
            <input type="text" class="form-control {(isset($data['errors']['password']))?'border-danger':''}" placeholder="Enter password" name="password" value="{$data['password']}">
        </div>
            <div class="form-group">
                <label>Status:</label>
                <select class="form-control {(isset($data['errors']['status']))?'border-danger':''}" name="status">
                    <option value="active" {($data['status'] == 'active')?'selected':''}>Active</option>
                    <option value="inactive" {($data['status'] == 'inactive')?'selected':''}>Inactive</option>
                </select>
            </div>
        <div class="form-group">
            <button class="btn btn-primary" name="submit">Submit</button>
            <input type="hidden" name="id" value="{$data['id']}">
        </div>
    </form>
</div>
<script src="modules/addons/{MODULE_NAME}/assets/js/script.js"></script>