document.addEventListener('DOMContentLoaded',function(){
    let add_new_playlist_btn =  document.querySelector('.add_new_playlist');
    if(add_new_playlist_btn){
        add_new_playlist_btn.addEventListener('click',function(){
            let queryString = window.location.search; 
            let urlParams = new URLSearchParams(queryString); 
            window.location.href = window.location.href.split('&')[0] + `&action=playlist_manage&mid=${urlParams.get('mid')}`;
        });
    }
   
    let edit_playlist_btns =  document.querySelectorAll('.edit_playlist');
    if(edit_playlist_btns){
        edit_playlist_btns.forEach((ele)=>{
            ele.addEventListener('click',function(e){
                e.preventDefault();
                let id = ele.getAttribute('data-id');
                let queryString = window.location.search; 
                let urlParams = new URLSearchParams(queryString); 
                window.location.href = window.location.href.split('&')[0] + `&action=playlist_manage&id=${id}&mid=${urlParams.get('mid')}`;
            });
        });
    }

    let delete_playlist_btns =  document.querySelectorAll('.delete_playlist');
    if(delete_playlist_btns){
        delete_playlist_btns.forEach((ele)=>{
            ele.addEventListener('click',function(e){
                e.preventDefault();
                let id = ele.getAttribute('data-id');
                let queryString = window.location.search; 
                let urlParams = new URLSearchParams(queryString); 
                //Sweet alert
                Swal.fire({
                    title: "Are you sure want to delete?",
                    text: "You won't be able to revert this!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#3085d6",
                    cancelButtonColor: "#d33",
                    confirmButtonText: "Yes, delete it!"
                    }).then((result) => {
                    if (result.isConfirmed) {
                        window.location.href = window.location.href.split('&')[0] + `&action=playlist_delete&id=${id}&mid=${urlParams.get('mid')}`;
                    }
                });
                //Sweet alert
            });
        });
    }
    
   
    let list_playlist_btn =  document.querySelector('.list_playlist')
    if(list_playlist_btn){
        list_playlist_btn.addEventListener('click',function(){
            let queryString = window.location.search; 
            let urlParams = new URLSearchParams(queryString); 
            window.location.href = window.location.href.split('&')[0] + '&action=playlist_list&mid=' + urlParams.get('mid');
        });
    }
    
});


window.addEventListener('load', function() {
    const preloader = document.getElementById('preloader');
    if (preloader) {
        preloader.style.display = 'none';
    }
});
