<?php
use WHMCS\Database\Capsule;

/**
 * WHMCS SDK Sample Addon Module Hooks File
 *
 * Hooks allow you to tie into events that occur within the WHMCS application.
 *
 * This allows you to execute your own code in addition to, or sometimes even
 * instead of that which WHMCS executes by default.
 *
 * @see https://developers.whmcs.com/hooks/
 *
 * @copyright Copyright (c) WHMCS Limited 2017
 * @license http://www.whmcs.com/license/ WHMCS Eula
 */

// Require any libraries needed for the module to function.
// require_once __DIR__ . '/path/to/library/loader.php';
//
// Also, perform any initialization required by the service's library.

/**
 * Register a hook with WHMCS.
 *
 * This sample demonstrates triggering a service call when a change is made to
 * a client profile within WHMCS.
 *
 * For more information, please refer to https://developers.whmcs.com/hooks/
 *
 * add_hook(string $hookPointName, int $priority, string|array|Closure $function)
 */
add_hook('ClientEdit', 1, function(array $params) {
    try {
        // Call the service's function, using the values provided by WHMCS in
        // `$params`.
    } catch (Exception $e) {
        // Consider logging or reporting the error.
    }
});

// add_hook('InvoicePaid', 1, function ($vars) {

//     $command = 'GetInvoice';
//     $postData = [
//         'invoiceid' => $vars['invoiceid'],
//     ];

//     $adminUsername = 'Admin';
//     $invoices = localAPI($command, $postData, $adminUsername);
   

//     $command = 'GetClientsProducts';
//     $postData = [
//         'clientid' => $invoices['userid'],
//         'serviceid' => $invoices['items']['item'][0]['relid'],
//         'stats'    => true,   
//     ];

//     $adminUsername = 'Admin'; 

//     $products = localAPI($command, $postData, $adminUsername);

//     if($products['result'] == 'success' && isset($products['products']['product'])){
//         if($products['products']['product'][0]['customfields']['customfield'][0]['name'] == 'MAC Address'){
//             $custom_field_value = $products['products']['product'][0]['customfields']['customfield'][0]['value'];
//             $device  = Capsule::table('tbl_devices')->where('mac_id',$custom_field_value)->first();
//             Capsule::table('tbl_subscriptions')
//                         ->where('device_id', $device->id)       
//                         ->update([
//                             'product_id' => $products['products']['product'][0]['id'],
//                             'package_type'  => 'paid',
//                             'status'  => 'active',
//                             'registered_date' => $products['products']['product'][0]['regdate'],
//                             'expiry_date' => $products['products']['product'][0]['nextduedate'],
//             ]);

//             Capsule::table('tbl_devices')
//                         ->where('mac_id', $custom_field_value)       
//                         ->update([
//                             'user_id' => $products['products']['product'][0]['clientid'],
//                             'updated_at' => date('Y-m-d H:i:s')

//             ]);
//         }
//     }
// });


add_hook('AfterModuleCreate', 1, function($vars) {  
    $requestParam = array();
        if(isset($vars["params"]["customfields"]["MacAddress"]) && $vars["params"]["customfields"]["MacAddress"] != "")
    {   
        $service = $vars['params']['model']; 

        $nextDueDate = $service->nextduedate;
        $billingcycle = $service->billingcycle;
        
        $productId    = $vars['params']['pid'];           // Product ID
        $userid    = $vars['params']['userid'];           // Userid ID
        $requestParam["userid"] = $userid;
        $requestParam["productId"] = $productId;
        $requestParam["nextDueDate"] = $nextDueDate;
        $requestParam["billingcycle"] = $billingcycle;
        $requestParam["MacAddress"] = $vars["params"]["customfields"]["MacAddress"];
        $requestParam["status"] = strtolower($vars["params"]["status"]);
        //Making request to update in our custom table tbl_devices,tbl_subscriptions
        $requestdata = manupulationinscustomtable($requestParam);
        logModuleCall("multi_vision" ,"Updating Subscription On Service Actions", $requestParam, $requestdata, "", "");
    }
});

add_hook('AfterModuleSuspend', 1, function($vars) {
         
    $requestParam = array();
        if(isset($vars["params"]["customfields"]["MacAddress"]) && $vars["params"]["customfields"]["MacAddress"] != "")
    {   
        $service = $vars['params']['model']; 

        $nextDueDate = $service->nextduedate;
        $billingcycle = $service->billingcycle;
        
        $productId    = $vars['params']['pid'];           // Product ID
        $userid    = $vars['params']['userid'];           // Userid ID
        $requestParam["userid"] = $userid;
        $requestParam["productId"] = $productId;
        $requestParam["nextDueDate"] = $nextDueDate;
        $requestParam["billingcycle"] = $billingcycle;
        $requestParam["MacAddress"] = $vars["params"]["customfields"]["MacAddress"];
        $requestParam["status"] = strtolower($vars["params"]["status"]);
        //Making request to update in our custom table tbl_devices,tbl_subscriptions
        $requestdata = manupulationinscustomtable($requestParam);
        logModuleCall("multi_vision" ,"Updating Subscription On Service Actions", $requestParam, $requestdata, "", "");
    }
});

add_hook('AfterModuleUnsuspend', 1, function($vars) {
         
    $requestParam = array();
        if(isset($vars["params"]["customfields"]["MacAddress"]) && $vars["params"]["customfields"]["MacAddress"] != "")
    {   
        $service = $vars['params']['model']; 

        $nextDueDate = $service->nextduedate;
        $billingcycle = $service->billingcycle;
        
        $productId    = $vars['params']['pid'];           // Product ID
        $userid    = $vars['params']['userid'];           // Userid ID
        $requestParam["userid"] = $userid;
        $requestParam["productId"] = $productId;
        $requestParam["nextDueDate"] = $nextDueDate;
        $requestParam["billingcycle"] = $billingcycle;
        $requestParam["MacAddress"] = $vars["params"]["customfields"]["MacAddress"];
        $requestParam["status"] = strtolower("active");
        //Making request to update in our custom table tbl_devices,tbl_subscriptions
        $requestdata = manupulationinscustomtable($requestParam);
        logModuleCall("multi_vision" ,"Updating Subscription On Service Actions", $requestParam, $requestdata, "", "");
    }
});

add_hook('AfterModuleTerminate', 1, function($vars) {
         
    $requestParam = array();
        if(isset($vars["params"]["customfields"]["MacAddress"]) && $vars["params"]["customfields"]["MacAddress"] != "")
    {   
        $service = $vars['params']['model']; 

        $nextDueDate = $service->nextduedate;
        $billingcycle = $service->billingcycle;
        
        $productId    = $vars['params']['pid'];           // Product ID
        $userid    = $vars['params']['userid'];           // Userid ID
        $requestParam["userid"] = $userid;
        $requestParam["productId"] = $productId;
        $requestParam["nextDueDate"] = $nextDueDate;
        $requestParam["billingcycle"] = $billingcycle;
        $requestParam["MacAddress"] = $vars["params"]["customfields"]["MacAddress"];
        $requestParam["status"] = strtolower($vars["params"]["status"]);
        //Making request to update in our custom table tbl_devices,tbl_subscriptions
        $requestdata = manupulationinscustomtable($requestParam);
        logModuleCall("multi_vision" ,"Updating Subscription On Service Actions", $requestParam, $requestdata, "", "");
    }
});


function manupulationinscustomtable($data = array())
{
    //    echo "<pre>";print_r($data);die();
    $return = array();
    $return["result"] = "error";
    $return["message"] = "unable to update data";
    $device  = Capsule::table('tbl_devices')->where('mac_id',$data["MacAddress"])->first();
    if(!empty($device))
        {
            //First Updating user id in tbl_devices
            Capsule::table('tbl_devices')->where('id', $device->id)->update(['user_id' => $data['userid']]);

            // Second Updating in another table tbl_subscriptions
            Capsule::table('tbl_subscriptions')
                ->where('device_id', $device->id)
                ->update([
                            'product_id' => $data['productId'],
                            'package_type' => $data['billingcycle'],
                            'status' => $data['status'],
                            'expiry_date' => $data['nextDueDate']
                        ]);

                $return = array();
                $return["result"] = "success";
                $return["message"] = "Subscription Updated Successfully";
        }
    return $return;
}