<?php

namespace WHMCS\Module\Addon\MultiVision\Admin;

/**
 * Sample Admin Area Dispatch Handler
 */
class AdminDispatcher {

    /**
     * Dispatch request.
     *
     * @param string $action
     * @param array $parameters
     *
     * @return string
     */
    public function dispatch($action, $parameters)
    {
       
        switch ($action) {
            case "device_manage":
                $action = "manage_device";
                break;
            case "device_delete":
                $action = "delete_device";
                break;
            case "playlist_list":
                $action = 'list_playlist';
                break;
            case "playlist_manage":
                $action = "manage_playlist";
                break;
            case "playlist_delete":
                $action = "delete_playlist";
                break;

            case "subscription_list":
                $action = 'list_subscription';
                break;
            case "subscription_manage":
                $action = "manage_subscription";
                break;
            case "subscription_delete":
                $action = "delete_subscription";
                break;
           
            default:
                $action = 'index';
        }


        $controller = new Controller();

        if (is_callable(array($controller, $action))) {
            return $controller->$action($parameters);
        }

        return '<p>Invalid action requested. Please go back and try again.</p>';
    }
}
