<?php

namespace WHMCS\Module\Addon\MultiVision\Admin;
use WHMCS\Database\Capsule;

/**
 * Sample Admin Area Controller
 */
class Controller {


    public function __construct(){
        session_start();
        ?>
            <style>
                .container{
                    margin-top:10px;
                }
                .mt-5{
                    margin-top:10px;
                }
                .bg-success{
                    background: #5cb85c;
                }
                .bg-danger{
                    background: #c9302c;
                }
                #myDeviceTable_wrapper{
                    width:95%;
                }
                #myPlaylistTable_wrapper{
                    width:95%;
                }
                #mySubscriptionTable_wrapper{
                    width:95%;
                }
                .d-flex{
                    display:flex;
                }
                .mx-3{
                    margin-left:3px;
                }
            </style>
            <link rel="stylesheet" href="https://cdn.datatables.net/2.3.5/css/dataTables.dataTables.css" />
            <script src="https://cdn.datatables.net/2.3.5/js/dataTables.js"></script>
            <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <?php
    }

    /**
     * Index action.
     *
     * @param array $vars Module configuration parameters
     *
     * @return string
     */
    public function index($vars)
    {
        $results =  Capsule::table('tbl_devices')->orderBy('id','DESC')->get();
        
        ?>

       
        <div class="container">
            <?= $this->loader(); ?>
            <?= $this->navbar();  ?>
            <?php if(isset($_SESSION['success'])): ?>
             <div class="alert alert-success"><?= $_SESSION['success']; ?></div>
            <?php endif; 
                if(isset($_SESSION['success'])){
                   unset($_SESSION['success']);
                }
            ?>
            <div class="d-flex justify-content-start">
              <button class="btn btn-success add_new_device">New Device</button>
            </div>
            <table class="table table-hover table-bordered mt-5" id="myDeviceTable">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Mac ID</th>
                        <th style="text-align:left;">Device Key</th>
                        <th>Device Details</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(isset($results) && count($results) > 0): 
                      foreach($results as $result):
                    ?>
                    <tr>
                        <td><?= $result->id; ?></td>
                        <td><?= $result->mac_id; ?></td>
                        <td style="text-align:left;"><?= decrypt($result->shareable_device_key); ?></td>
                        <td>
                        <?php
                         foreach(json_decode($result->device_details,true) as $key => $value){
                            echo '<b>' . $key . '</b>' .':&nbsp' . $value . '<br>';
                         }
                        ?>
                        </td>
                        <td><button class="btn btn-success edit_device" data-id="<?=  $result->id; ?>"><i class="fa fa-edit"></i></button><button class="btn btn-danger delete_device" data-id="<?=  $result->id; ?>"><i class="fa fa-trash"></i></button></td>
                    </tr>
                    <?php 
                     endforeach;
                     endif
                     ?>
                </tbody>
            </table>
        </div>
        <script>
            document.addEventListener('DOMContentLoaded',function(){
                document.querySelector('.add_new_device').addEventListener('click',function(){
                    window.location.href = window.location.href + '&action=device_manage';
                });
                document.querySelectorAll('.edit_device').forEach((ele)=>{
                     ele.addEventListener('click',function(e){
                        e.preventDefault();
                        let id = ele.getAttribute('data-id');
                        window.location.href = window.location.href.split('&')[0] + `&action=device_manage&id=${id}`;
                    });
                });
                document.querySelectorAll('.delete_device').forEach((ele)=>{
                    ele.addEventListener('click',function(e){
                        e.preventDefault();
                        let id = ele.getAttribute('data-id');
                        Swal.fire({
                            title: "Are you sure want to delete?",
                            text: "You won't be able to revert this!",
                            icon: "warning",
                            showCancelButton: true,
                            confirmButtonColor: "#3085d6",
                            cancelButtonColor: "#d33",
                            confirmButtonText: "Yes, delete it!"
                            }).then((result) => {
                            if (result.isConfirmed) {
                                window.location.href = window.location.href.split('&')[0] + `&action=device_delete&id=${id}`;
                            }
                        });
                    });
                });
            });
       </script>
        <script>
              let myDeviceTable = new DataTable('#myDeviceTable');
        </script>
        <?php
        
    }

    public function manage_device(){

        $id = '';
        $mac_address = '';
        $device_key = '';
        $device_details = [];

        if(isset($_GET['id']) && $_GET['id'] != ''){
             $result =  Capsule::table('tbl_devices')->where('id',$_GET['id'])->first();

             $id = $result->id;
             $mac_address = $result->mac_id;
             $device_key = decrypt($result->shareable_device_key);
             $device_details = json_decode($result->device_details,true);
        }

         $errors = '';
         $mac_error = '';
         $device_key_error = '';
         $device_details_error = '';
    
        if(isset($_POST['submit'])){

             $id = $_POST['id'];
             $mac_address = trim($_POST['mac_address']);
             $device_key = trim($_POST['device_key']);
             $device_details = [];
             if(isset($_POST['key']) && isset($_POST['value']) ){
                for($i=0;$i<count($_POST['key']);$i++){
                   if(!empty(trim($_POST['key'][$i])) && !empty(trim($_POST['value'][$i]))){
                      $device_details[$_POST['key'][$i]] = $_POST['value'][$i];
                   }
                 
                }
             }
            
            $mac_pattern = '/^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$|^([0-9A-Fa-f]{4}\.){2}([0-9A-Fa-f]{4})$/';
            if(!preg_match($mac_pattern, trim($_POST['mac_address']))){
                    $errors .= 'Please enter a valid mac address<br>';
                    $mac_error = 'border-danger';
                    
            }
            if(trim($_POST['device_key']) == ''){
                $errors .= 'Please enter device key<br>';
                $device_key_error = 'border-danger';
            }
            if(count($device_details) == 0){
                $errors .= 'Please enter atleast one property of device<br>';
                $device_details_error = 'border-danger';
            }

            // Unique mac address validation
            if($_POST['id'] == ''){
                $mac_count = Capsule::table('tbl_devices')->where('mac_id',$mac_address)->count();
            }else{
                $mac_count = Capsule::table('tbl_devices')->where('id','!=',$id)->where('mac_id',$mac_address)->count();
            }

            if($mac_count == 1){
                 $errors .= 'Mac address already taken<br>';
                 $mac_error = 'border-danger';
            }



            if(trim($errors) == ''){
               
                try{

                
                    if($_POST['id'] == ''){
                        Capsule::table('tbl_devices')->insert([
                            'mac_id' => trim($_POST['mac_address']),
                            'user_id' => '',
                            'device_key' => password_hash($device_key, PASSWORD_DEFAULT),
                            'shareable_device_key' => encrypt(trim($_POST['device_key'])),
                            'device_details' => json_encode($device_details),
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s")
                        ]);
                        $_SESSION['success'] = 'Devices saved successfully';
                        ?>
                        <script>
                            window.location.href = window.location.href.split('&')[0] + '&action=index';
                        </script>
                        <?php
                    }else{
                        Capsule::table('tbl_devices')->where('id',$_POST['id'] )->update([
                            'mac_id' => trim($_POST['mac_address']),
                            'user_id' => '',
                            'device_key' => password_hash($device_key, PASSWORD_DEFAULT),
                            'shareable_device_key' => encrypt(trim($_POST['device_key'])),
                            'device_details' => json_encode($device_details),
                            'updated_at' => date("Y-m-d H:i:s")
                        ]);
                        $_SESSION['success'] = 'Device updated successfully';
                        ?>
                            <script>
                                window.location.href = window.location.href.split('&')[0] + '&action=index';
                            </script>
                        <?php
                    }
                
                }
                catch(Exception $e){
                    $error_messages =  $e->getMessage();
                }
                
              
            }
        }

        ?>
        <style>
            .border-danger{
                border:1px solid red;
            }
        </style>
        <div class="container-fluid">
            <?= $this->loader(); ?>
            <?= $this->navbar();  ?>
            <?php if(trim($errors) != ''):  ?>
            <div class="alert alert-danger"><?= $errors; ?></div>
            <?php endif;  ?>
            <form method="POST">
                <div class="form-group">
                    <label>MAC ADDRESS:</label>
                    <input type="text" class="form-control <?= $mac_error;  ?>" placeholder="Enter mac address" name="mac_address" value="<?= $mac_address; ?>">
                </div>
                 <div class="form-group">
                    <label>DEVICE KEY:</label>
                    <input type="text" class="form-control <?= $device_key_error; ?>" placeholder="Enter device key" name="device_key" value="<?=  $device_key; ?>">
                </div>
                <div class="form-group">
                    <label>DEVICE DETAILS:</label>
                    <?php 
                    if(count($device_details) == 0):
                    ?>
                    <div class="row dynamic-row d-flex w-100">
                        <div class="col-md-5">
                            <input type="text" class="form-control <?= $device_details_error; ?>" placeholder="Enter key" name="key[]" value="">&nbsp
                        </div>
                        <div class="col-md-5">
                            <input type="text" class="form-control <?= $device_details_error; ?>" placeholder="Enter value" name="value[]" value="">&nbsp
                        </div>
                        <div class="col-md-2">
                            <button type="button" class="btn <?= 'btn-success add_more' ?>">+</button>
                        </div>
                    </div>
                    <?php
                    endif;
                    $count = 0;
                    foreach($device_details as $key => $value):
                    ?>
                    <div class="row dynamic-row d-flex w-100">
                        <div class="col-md-5">
                            <input type="text" class="form-control <?= $device_details_error; ?>" placeholder="Enter key" name="key[]" value="<?= $key; ?>">&nbsp
                        </div>
                        <div class="col-md-5">
                            <input type="text" class="form-control <?= $device_details_error; ?>" placeholder="Enter value" name="value[]" value="<?= $value; ?>">&nbsp
                        </div>
                        <div class="col-md-2">
                            <button type="button" class="btn <?= ($count == 0)?'btn-success add_more':'btn-danger remove_more' ?>"><?= ($count == 0)?'+':'-' ?></button>
                        </div>
                    </div>
                    <?php 
                    $count ++;
                    endforeach;
                    ?>
                </div>
                <div class="form-group">
                    <button class="btn btn-primary" name="submit">Submit</button>
                    <input type="hidden" name="id" value="<?= $id; ?>">
                </div>
            </form>
        </div>
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                let new_html = `
                                    <div class="row dynamic-row d-flex w-100">
                                        <div class="col-md-5">
                                            <input type="text" class="form-control" placeholder="Enter key" name="key[]">&nbsp
                                        </div>
                                        <div class="col-md-5">
                                            <input type="text" class="form-control" placeholder="Enter value" name="value[]">&nbsp
                                        </div>
                                        <div class="col-md-2">
                                            <button type="button" class="btn btn-danger remove_more">-</button>&nbsp
                                        </div>
                                    </div>
                                    `;
                document.querySelector('.add_more').addEventListener('click', (e) => {
                    e.preventDefault();
                    if (e.target.classList.contains('add_more')) {
                        document.querySelectorAll('.dynamic-row')[document.querySelectorAll('.dynamic-row').length-1].insertAdjacentHTML("afterend", new_html);
                    }
                });
                document.addEventListener('click', function (e) {
                    if (e.target.classList.contains('remove_more')) {
                        e.preventDefault();
                        e.target.closest('.dynamic-row').remove();
                    }
                });
            });

        </script>
    <?php
    }

     public function delete_device(){
        Capsule::table('tbl_playlists')->where('device_id', $_GET['id'])->delete();
        Capsule::table('tbl_subscriptions')->where('device_id', $_GET['id'])->delete();
        Capsule::table('tbl_devices')->where('id', $_GET['id'])->delete();
        $_SESSION['success'] = 'Device deleted successfully';
        ?>
            <script>
                window.location.href = window.location.href.split('&')[0] + '&action=device_list';
            </script>
        <?php

    }



    public function list_playlist(){
    
             $results = Capsule::table('tbl_playlists')
                                ->leftjoin('tbl_devices', 'tbl_playlists.device_id', '=', 'tbl_devices.id')
                                ->leftjoin('tbl_subscriptions', 'tbl_playlists.subscription_id', '=', 'tbl_subscriptions.id')
                                ->select(
                                    'tbl_playlists.*',
                                    'tbl_devices.mac_id',
                                    'tbl_subscriptions.package_type'  
                                )->orderBy('id','DESC')->get();
           
        ?>
            <div class="container">
                <?= $this->loader(); ?>
                <?= $this->navbar();  ?>
                <?php if(isset($_SESSION['success'])): ?>
                <div class="alert alert-success"><?= $_SESSION['success']; ?></div>
                <?php endif; 
                    if(isset($_SESSION['success'])){
                    unset($_SESSION['success']);
                    }
                ?>
                <div class="d-flex justify-content-start">
                    <button class="btn btn-success add_new_playlist">New Playlist</button>
                </div>
                <table class="table table-hover table-bordered mt-5" id="myPlaylistTable">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Mac ID</th>
                            <th>Subscription</th>
                            <!-- <th>Type</th> -->
                            <th>Playlist Url</th>
                            <th>Playlist Code</th>
                            <th>Username</th>
                            <th>Password</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(isset($results) && count($results) > 0): 
                
                        foreach($results as $result):
                        ?>
                        <tr>
                            <td><?= $result->id; ?></td>
                            <td><?= $result->any_name; ?></td>
                            <td><?= $result->mac_id; ?></td>
                            <td>
                                <?php 
                                if ($result->package_type == ''):
                                    echo '<span>Not Available</span>';
                                elseif ($result->package_type == 'paid'):
                                    echo "<span class='badge bg-success'>" . strtoupper($result->package_type) . "</span>";
                                elseif ($result->package_type == 'trial'):
                                    echo "<span class='badge bg-warning'>" . strtoupper($result->package_type) . "</span>";
                                endif;
                                ?>
                            </td>
                            <!-- <td><?= $result->type; ?></td> -->
                            <td><?= $result->playlists; ?></td>
                            <td><?= $result->playlist_code; ?></td>
                            <td><?= $result->username; ?></td>
                            <td><?= decrypt($result->shareable_password); ?></td>
                            <td><?= ($result->status == 'active')?'<span class="badge bg-success">Active</span>':'<span class="badge bg-danger">Inactive</span>'; ?></td>
                            <td class="d-flex"><button class="btn btn-success edit_playlist" data-id="<?=  $result->id; ?>"><i class="fa fa-edit"></i></button><button class="btn btn-danger mx-3 delete_playlist" data-id="<?=  $result->id; ?>"><i class="fa fa-trash"></i></button></td>
                        </tr>
                        <?php 
                        endforeach;
                        endif;
                        ?>
                    </tbody>
                </table>
            </div>
            <script>
                document.addEventListener('DOMContentLoaded',function(){
                    document.querySelector('.add_new_playlist').addEventListener('click',function(){
                        window.location.href = window.location.href.split('&')[0] + `&action=playlist_manage`;
                    });
                    document.querySelectorAll('.edit_playlist').forEach((ele)=>{
                        ele.addEventListener('click',function(e){
                            e.preventDefault();
                            let id = ele.getAttribute('data-id');
                            window.location.href = window.location.href.split('&')[0] + `&action=playlist_manage&id=${id}`;
                        });
                    });
                    document.querySelectorAll('.delete_playlist').forEach((ele)=>{
                        ele.addEventListener('click',function(e){
                            e.preventDefault();
                            let id = ele.getAttribute('data-id');
                            Swal.fire({
                                title: "Are you sure want to delete?",
                                text: "You won't be able to revert this!",
                                icon: "warning",
                                showCancelButton: true,
                                confirmButtonColor: "#3085d6",
                                cancelButtonColor: "#d33",
                                confirmButtonText: "Yes, delete it!"
                                }).then((result) => {
                                if (result.isConfirmed) {
                                    window.location.href = window.location.href.split('&')[0] + `&action=playlist_delete&id=${id}`;
                                }
                            });
                        });
                    });
                
                    
                });
           </script>
            <script>
              let myPlaylistTable = new DataTable('#myPlaylistTable');
            </script>
       <?php
    }


    public function manage_playlist(){

        // Php functionality
        $id = '';
        $playlist_name = '';
        $mac_address = '';
        $subscription_id = '';
        $playlist_type = '';
        $playlist = '';
        $username = '';
        $password = '';
        $status = '';

        $errors = '';
        $playlist_name_error = '';
        $mac_error = '';
        $subscription_id_error = '';
        $playlist_type_error = '';
        $playlist_error = '';
        $username_error = '';
        $password_error = '';
        $status_error = '';

        $mac_devices =  Capsule::table('tbl_devices')->get();
        $subscriptions =  Capsule::table('tbl_subscriptions')->get();
        if(isset($_GET['id']) && $_GET['id'] != ''){

            $result =  Capsule::table('tbl_playlists')->where('id',$_GET['id'])->first();
            

            $id = $result->id;
            $playlist_name = $result->any_name;
            $mac_address = $result->device_id;
            $subscription_id = $result->subscription_id;
            $playlist_type = $result->type;
            $playlist = $result->playlists;
            $username = $result->username;
            $password = decrypt($result->shareable_password);
            $status =   $result->status;
        }

           

        if(isset($_POST['submit'])){
 
            $id = $_POST['id'];
            $playlist_name = trim($_POST['playlist_name']);
            $mac_address = trim($_POST['mac_address']);
            $subscription_id = trim($_POST['subscription_id']);
            $playlist_type = trim($_POST['playlist_type']);
            $playlist = trim($_POST['playlist']);
            $username = trim($_POST['username']);
            $password = trim($_POST['password']);
            $status = trim($_POST['status']);
           
           
            if($playlist_name == ''){
                $errors .= 'Please enter playlist name<br>';
                $playlist_name_error = 'border-danger';

            }
            if($mac_address == ''){
                $errors .= 'Please enter mac address<br>';
                $mac_error = 'border-danger';

            }
            if($subscription_id == ''){
                $errors .= 'Please choose subscription<br>';
                $subscription_id_error = 'border-danger';
            }
            if($playlist_type == ''){
                $errors .= 'Please enter playlist type<br>';
                $playlist_type_error = 'border-danger';
            }
            if($playlist == ''){
                $errors .= 'Please enter playlist<br>';
                $playlist_error = 'border-danger';
            }
            if($username == ''){
                $errors .= 'Please enter username<br>';
                $username_error = 'border-danger';
            }
            if($password == ''){
                $errors .= 'Please enter password<br>';
                $password_error = 'border-danger';
            }
            if($status == ''){
                $errors .= 'Please select status<br>';
                $status_error = 'border-danger';
            }

            if($id == ''){
                if(Capsule::table('tbl_playlists')->where('device_id',$mac_address)->where('any_name',$playlist_name)->first()){
                    $errors .= 'Playlist name already taken<br>';
                    $playlist_name_error = 'border-danger';
                }
            }else{
                if(Capsule::table('tbl_playlists')->where('id','!=',$id)->where('device_id',$mac_address)->where('any_name',$playlist_name)->first()){
                    $errors .= 'Playlist name already taken<br>';
                    $playlist_name_error = 'border-danger';
                }
            }
           
           
           

            if(trim($errors) == ''){
               
                try{

                
                    if($_POST['id'] == ''){
                        $playlist_code = $this->generateUniqueKey();
                        Capsule::table('tbl_playlists')->insert([
                            'device_id' => $mac_address,
                            'subscription_id' => $subscription_id,
                            'type' => $playlist_type,
                            'playlists' => $playlist,
                            'username' => $username,
                            'password' => password_hash($password, PASSWORD_DEFAULT),
                            'shareable_password' => encrypt($password),
                            'any_name' => $playlist_name,
                            'playlist_code' => $playlist_code,
                            'status' => $status,
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s")
                        ]);
                        $_SESSION['success'] = 'Playlist saved successfully';
                        ?>
                        <script>
                            window.location.href = window.location.href.split('&')[0] + '&action=playlist_list';
                        </script>
                        <?php
                    }else{
                        Capsule::table('tbl_playlists')->where('id',$_POST['id'])->update([
                            'device_id' => $mac_address,
                            'subscription_id' => $subscription_id,
                            'type' => $playlist_type,
                            'playlists' => $playlist,
                            'username' => $username,
                            'password' => password_hash($password, PASSWORD_DEFAULT),
                            'shareable_password' => encrypt($password),
                            'any_name' => $playlist_name,
                            'status' => $status,
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s")
                        ]);
                        $_SESSION['success'] = 'Playlist updated successfully';
                        ?>
                            <script>
                                window.location.href = window.location.href.split('&')[0] + '&action=playlist_list';
                            </script>
                        <?php
                    }
                
                }
                catch(Exception $e){
                    $error_messages =  $e->getMessage();
                }
                
              
            }
        }
        // Php functionality


        ?>

            <style>
            .border-danger{
                border:1px solid red;
            }
            </style>
            <div class="container-fluid">
                <?= $this->loader(); ?>
                <?= $this->navbar();  ?>
                <?php if(trim($errors) != ''):  ?>
                <div class="alert alert-danger"><?= $errors; ?></div>
                <?php endif;  ?>
                <form method="POST">
                    <div class="form-group">
                        <label>Name:</label>
                        <input type="text" class="form-control <?= $playlist_name_error; ?>" placeholder="Enter playlist name" name="playlist_name" value="<?= $playlist_name; ?>">
                    </div>
                    <div class="form-group">
                        <label>Mac Address:</label>
                        <select class="form-control <?= $mac_error;  ?>" name="mac_address">
                            <option value="">Choose mac device</option>
                            <?php 
                              if(isset($mac_devices) && count($mac_devices) > 0):
                              foreach($mac_devices as $mac_device): 
                            ?>
                            <option value="<?=  $mac_device->id;  ?>" <?= ($mac_address == $mac_device->id)?'selected':'';  ?>><?= $mac_device->mac_id; ?></option>
                            <?php 
                              endforeach; 
                              endif;
                            ?>
                        </select>
                        <input type="hidden" name="id" value="<?= $id; ?>">
                    </div>
                    <div class="form-group">
                        <label>Subscription:</label>
                        <select class="form-control <?= $subscription_id_error;  ?>" name="subscription_id">
                            <option value="">Choose subscription</option>
                            <?php 
                            if(isset($subscriptions) && count($subscriptions) > 0):
                              foreach($subscriptions as $subscription): 
                            ?>
                            <option value="<?=  $subscription->id;  ?>" <?= ($subscription_id == $subscription->id)?'selected':'';  ?>><?= $subscription->package_type; ?></option>
                            <?php 
                              endforeach; 
                            endif;
                            ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <!-- <label>Type:</label> -->
                        <input type="hidden" class="form-control" name="playlist_type" value="url">
                    </div>
                    <div class="form-group">
                        <label>Playlist Url:</label>
                        <input type="text" class="form-control <?= $playlist_error; ?>" placeholder="Enter playlist url" name="playlist" value="<?= $playlist; ?>">
                    </div>
                    <div class="form-group">
                        <label>Username:</label>
                        <input type="text" class="form-control <?= $username_error; ?>" placeholder="Enter username" name="username" value="<?= $username; ?>">
                    </div>
                    <div class="form-group">
                        <label>Password:</label>
                        <input type="text" class="form-control <?= $password_error; ?>" placeholder="Enter password" name="password" value="<?= $password; ?>">
                    </div>
                     <div class="form-group">
                        <label>Status:</label>
                        <select class="form-control <?= $status_error;  ?>" name="status">
                            <option value="active" <?= ($status == 'active')?'selected':'';  ?> ?>Active</option>
                            <option value="inactive" <?= ($status == 'inactive')?'selected':'';  ?> ?>Inactive</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <button class="btn btn-primary" name="submit">Submit</button>
                    </div>
                </form>
            </div>

        <?php
    }



    public function delete_playlist(){
        Capsule::table('tbl_playlists')->where('id', $_GET['id'])->delete();
        $_SESSION['success'] = 'Playlist deleted successfully';
        ?>
            <script>
                window.location.href = window.location.href.split('&')[0] + '&action=playlist_list';
            </script>
        <?php

    }


    public function list_subscription(){
           
             $results = Capsule::table('tbl_subscriptions')->leftjoin('tbl_devices', 'tbl_subscriptions.device_id', '=', 'tbl_devices.id')->select(
                            'tbl_subscriptions.*',
                            'tbl_devices.mac_id'
                        )->orderBy('id','DESC')->get();
        ?>
            <div class="container">
                <?= $this->loader(); ?>
                <?= $this->navbar();  ?>
                <?php if(isset($_SESSION['success'])): ?>
                <div class="alert alert-success"><?= $_SESSION['success']; ?></div>
                <?php endif; 
                    if(isset($_SESSION['success'])){
                    unset($_SESSION['success']);
                    }
                ?>
                <div class="d-flex justify-content-start">
                    <button class="btn btn-success add_new_subscription">New Subscription</button>
                </div>
                <table class="table table-hover table-bordered mt-5" id="mySubscriptionTable">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Mac ID</th>
                            <th>Product ID</th>
                            <th>Package Type</th>
                            <th>Registered Date</th>
                            <th>Expiry Date</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(isset($results) && count($results) > 0): 
                        foreach($results as $result):
                        ?>
                        <tr>
                            <td><?= $result->id; ?></td>
                            <td><?= $result->mac_id; ?></td>
                            <td><?= (isset($result->product_id) && $result->product_id != '')?$result->product_id:'Not available'; ?></td>
                            <td>
                                <?php 
                                if ($result->package_type == ''):
                                    echo '<span>Not Available</span>';
                                elseif ($result->package_type == 'paid'):
                                    echo "<span class='badge bg-success'>" . strtoupper($result->package_type) . "</span>";
                                elseif ($result->package_type == 'trial'):
                                    echo "<span class='badge bg-warning'>" . strtoupper($result->package_type) . "</span>";
                                endif;
                                ?>
                            </td>
                            <td><?= date("jS-F-Y", strtotime($result->registered_date)); ?></td>
                            <td><?= date("jS-F-Y", strtotime($result->expiry_date)); ?></td>
                            <td><?= ($result->status == 'active')?'<span class="badge bg-success">Active</span>':'<span class="badge bg-danger">Inactive</span>'; ?></td>
                            <td><button class="btn btn-success edit_subscription" data-id="<?=  $result->id; ?>"><i class="fa fa-edit"></i></button><button class="btn btn-danger delete_subscription" data-id="<?=  $result->id; ?>"><i class="fa fa-trash"></i></button></td>
                        </tr>
                        <?php 
                        endforeach;
                        endif;
                        ?>
                    </tbody>
                </table>
            </div>
            <script>
                document.addEventListener('DOMContentLoaded',function(){
                    document.querySelector('.add_new_subscription').addEventListener('click',function(){
                        window.location.href = window.location.href.split('&')[0] + `&action=subscription_manage`;
                    });
                    document.querySelectorAll('.edit_subscription').forEach((ele)=>{
                        ele.addEventListener('click',function(e){
                            e.preventDefault();
                            let id = ele.getAttribute('data-id');
                            window.location.href = window.location.href.split('&')[0] + `&action=subscription_manage&id=${id}`;
                        });
                    });
                    document.querySelectorAll('.delete_subscription').forEach((ele)=>{
                        ele.addEventListener('click',function(e){
                            e.preventDefault();
                            let id = ele.getAttribute('data-id');
                            Swal.fire({
                                title: "Are you sure want to delete?",
                                text: "You won't be able to revert this!",
                                icon: "warning",
                                showCancelButton: true,
                                confirmButtonColor: "#3085d6",
                                cancelButtonColor: "#d33",
                                confirmButtonText: "Yes, delete it!"
                                }).then((result) => {
                                if (result.isConfirmed) {
                                    window.location.href = window.location.href.split('&')[0] + `&action=subscription_delete&id=${id}`;
                                }
                            });
                        });
                    });
                });
           </script>
            <script>
              let mySubscriptionTable = new DataTable('#mySubscriptionTable');
            </script>
       <?php
    }


     public function manage_subscription(){

        // Php functionality
        $id = '';
        $mac_address = '';
        $package_type = '';
        $registered_date = '';
        $expiry_date = '';
        $status = '';

        $errors = '';
        $mac_address_error = '';
        $package_type_error = '';
        $registered_date_error = '';
        $expiry_date_error = '';
        $status_error = '';

        $mac_devices =  Capsule::table('tbl_devices')->get();

        if(isset($_GET['id']) && $_GET['id'] != ''){

            $result =  Capsule::table('tbl_subscriptions')->where('id',$_GET['id'])->first();

            $id = $result->id;
            $mac_address = $result->device_id;
            $package_type = $result->package_type;
            $registered_date = $result->registered_date;
            $expiry_date = $result->expiry_date;
            $status = $result->status;
        }

           

        if(isset($_POST['submit'])){

            $id = $_POST['id'];
            $mac_address = trim($_POST['mac_address']);
            $package_type = trim($_POST['package_type']);
            $registered_date = trim($_POST['registered_date']);
            $expiry_date = trim($_POST['expiry_date']);
            $status = trim($_POST['status']);
        
           
        
            if($mac_address == ''){
                $errors .= 'Please choose mac address<br>';
                $mac_error = 'border-danger';

            }
            if($package_type == ''){
                $errors .= 'Please enter package type<br>';
                $package_type_error = 'border-danger';
            }
            if($registered_date == ''){
                $errors .= 'Please choose registered date<br>';
                $registered_date_error = 'border-danger';
            }
            if($expiry_date == ''){
                $errors .= 'Please choose expiry date<br>';
                $expiry_date_error = 'border-danger';
            }
            if($status == ''){
                $errors .= 'Please select status<br>';
                $status_error = 'border-danger';
            }
           
           
           

            if(trim($errors) == ''){
               
                try{

                
                    if($_POST['id'] == ''){
                        Capsule::table('tbl_subscriptions')->insert([
                            'device_id' => $mac_address,
                            'package_type' => $package_type,
                            'registered_date' => $registered_date,
                            'expiry_date' => $expiry_date,
                            'status' => $status,
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s")
                        ]);
                        $_SESSION['success'] = 'Subscription saved successfully';
                        ?>
                        <script>
                            window.location.href = window.location.href.split('&')[0] + '&action=subscription_list';
                        </script>
                        <?php
                    }else{
                        Capsule::table('tbl_subscriptions')->where('id',$_POST['id'])->update([
                            'device_id' => $mac_address,
                            'package_type' => $package_type,
                            'registered_date' => $registered_date,
                            'expiry_date' => $expiry_date,
                            'status' => $status,
                            'updated_at' => date("Y-m-d H:i:s")
                        ]);
                        $_SESSION['success'] = 'Subscription updated successfully';
                        ?>
                            <script>
                                window.location.href = window.location.href.split('&')[0] + '&action=subscription_list';
                            </script>
                        <?php
                    }
                
                }
                catch(Exception $e){
                    $error_messages =  $e->getMessage();
                }
                
              
            }
        }
        // Php functionality


        ?>

            <style>
            .border-danger{
                border:1px solid red;
            }
            </style>
            <div class="container-fluid">
                <?= $this->loader(); ?>
                <?= $this->navbar();  ?>
                <?php if(trim($errors) != ''):  ?>
                <div class="alert alert-danger"><?= $errors; ?></div>
                <?php endif;  ?>
                <form method="POST">
                    <div class="form-group">
                        <label>Mac Address:</label>
                        <select class="form-control <?= $mac_error;  ?>" name="mac_address">
                            <option value="">Choose mac device</option>
                            <?php 
                              if(isset($mac_devices) && count($mac_devices) > 0):
                              foreach($mac_devices as $mac_device): 
                            ?>
                              <option value="<?=  $mac_device->id;  ?>" <?= ($mac_address == $mac_device->id)?'selected':'';  ?>><?= $mac_device->mac_id; ?></option>
                            <?php 
                              endforeach; 
                              endif;
                            ?>
                        </select>
                        <input type="hidden" name="id" value="<?= $id; ?>">
                    </div>
                    <div class="form-group">
                        <label>Package Type:</label>
                        <input type="text" class="form-control <?= $package_type_error; ?>" placeholder="Enter package type" name="package_type" value="<?= $package_type; ?>">
                    </div>
                    <div class="form-group">
                        <label>Registration Date:</label>
                        <input type="date" class="form-control <?= $registered_date_error; ?>" name="registered_date" value="<?= $registered_date; ?>">
                    </div>
                     <div class="form-group">
                        <label>Expiry Date:</label>
                        <input type="date" class="form-control <?= $expiry_date_error; ?>" name="expiry_date" value="<?= $expiry_date; ?>">
                    </div>
                     <div class="form-group">
                        <label>Status:</label>
                        <select class="form-control <?= $status_error;  ?>" name="status">
                            <option value="active" <?= ($status == 'active')?'selected':'';  ?> ?>Active</option>
                            <option value="inactive" <?= ($status == 'inactive')?'selected':'';  ?> ?>Inactive</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <button class="btn btn-primary" name="submit">Submit</button>
                    </div>
                </form>
            </div>

        <?php
    }


    public function delete_subscription(){
        Capsule::table('tbl_subscriptions')->where('id', $_GET['id'])->delete();
        $_SESSION['success'] = 'Subscription deleted successfully';
        ?>
            <script>
                window.location.href = window.location.href.split('&')[0] + '&action=subscription_list';
            </script>
        <?php

    }


     public function navbar(){
    ?>
        <style>
            
            .custom-module-tabs .nav-tabs > li > a {
                font-size: 12px !important;
                padding: 6px 10px !important;
            }

            .custom-module-tabs .dropdown-menu > li > a {
                font-size: 12px !important;
                padding: 6px 12px !important;
            }

            .custom-module-tabs .nav-tabs {
                margin-bottom: 20px;
            }
        </style>

        <div class="custom-module-tabs">
            <ul class="nav nav-tabs mt-4">
                <li class="<?= (isset($_GET['action']) && ($_GET['action'] == '' || $_GET['action'] == 'device_list'))?'active' : '' ?>">
                    <a href="javascript:void(0)" class="device_list">Devices</a>
                </li>
                <li class="<?= (isset($_GET['action']) && ($_GET['action'] == 'playlist_list' || $_GET['action'] == 'playlist_manage'))?'active' : '' ?>">
                    <a href="javascript:void(0)" class="playlist_list">Playlists</a>
                </li>
                <li class="<?= (isset($_GET['action']) && ($_GET['action'] == 'subscription_list' || $_GET['action'] == 'subscription_manage'))?'active' : '' ?>">
                    <a href="javascript:void(0)" class="subscription_list">Subscriptions</a>
                </li>
            </ul>
        </div>

        <script>
            document.addEventListener('DOMContentLoaded', function() {
                document.querySelector('.device_list').addEventListener('click',function(){
                 window.location.href = window.location.href.split('&')[0] + '&action=device_list';
                });
                document.querySelector('.playlist_list').addEventListener('click',function(){
                 window.location.href = window.location.href.split('&')[0] + '&action=playlist_list';
                });
                document.querySelector('.subscription_list').addEventListener('click',function(){
                 window.location.href = window.location.href.split('&')[0] + '&action=subscription_list';
                });

            });
        </script>

    <?php
    }


    public function loader(){
    ?>
       <style>
         /* loader css */
        #preloader {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: #fff; 
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 9999; 
        }

        .loader-spinner {
            border: 8px solid #f3f3f3; 
            border-top: 8px solid #3498db; 
            border-radius: 50%;
            width: 50px;
            height: 50px;
            animation: spin 1s linear infinite; 
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        /* loader css */
       </style>
       <div id="preloader">
         <div class="loader-spinner"></div> 
        </div>
        <script>
            window.addEventListener('load', function() {
                const preloader = document.getElementById('preloader');
                if (preloader) {
                    preloader.style.display = 'none';
                }
            });
        </script>
    <?php
    }

    function generateUniqueKey()
    {
        $playlist_code = rand(00000000,99999999);
        $exists = Capsule::table('tbl_playlists')
            ->where('playlist_code', $playlist_code)
            ->exists();
        if ($exists) {
            return $this->generateUniqueKey();
        }
        return $playlist_code;
    }
}
