<?php

namespace WHMCS\Module\Addon\MultiVision\Client;

/**
 * Sample Client Area Dispatch Handler
 */
class ClientDispatcher {

    /**
     * Dispatch request.
     *
     * @param string $action
     * @param array $parameters
     *
     * @return array
     */
    public function dispatch($action, $parameters)
    {
        
        switch ($action) {
 
            case 'playlist_manage':
                    $action = "manage_playlist";
                    break;
            case 'playlist_delete':
                    $action = "delete_playlist";
                    break;

            case 'playlist_list':
                    $action = "list_playlist";
                    break;
            default:
                    $action = 'list_playlist';    
        }
       
        if (!$action) {
            $action = 'list_playlist';
        }

        $controller = new Controller();
        if (is_callable(array($controller, $action))) {
            return $controller->$action($parameters);
        }
    }
}
