<?php

namespace WHMCS\Module\Addon\MultiVision\Client;
use WHMCS\Database\Capsule;


/**
 * Sample Client Area Controller
 */
class Controller {


    /**
     * Index action.
     *
     * @param array $vars Module configuration parameters
     *
     * @return array
     */
    public function list_playlist($vars)
    {
        
        
        if(isset($_GET['mid'])){
            $md5_mac_id = $_GET['mid'];
            if(!Capsule::table('tbl_devices')->where('md5_mac_id',$md5_mac_id)->first()){
                die('Not found');
            }else{
                 $device_id = Capsule::table('tbl_devices')->where('md5_mac_id',$md5_mac_id)->first()->id;
                 $_SESSION['device_id'] = $device_id;
            }
        }else{
            die('Not found');
        }

        
        $data['macId'] = Capsule::table('tbl_devices')->where('id',$_SESSION['device_id'])->first()->mac_id;
        $data['package_type'] = strtoupper(Capsule::table('tbl_subscriptions')->where('device_id',$_SESSION['device_id'] )->first()->package_type);
        $data['next_due_date'] = date('jS F Y', strtotime(Capsule::table('tbl_subscriptions')->where('device_id',$_SESSION['device_id'] )->first()->expiry_date));
       
        $data['records'] = $precords  = Capsule::table('tbl_playlists')
                                ->leftjoin('tbl_devices', 'tbl_playlists.device_id', '=', 'tbl_devices.id')
                                ->leftjoin('tbl_subscriptions', 'tbl_playlists.subscription_id', '=', 'tbl_subscriptions.id')
                                ->select(
                                    'tbl_playlists.*',
                                    'tbl_devices.mac_id',
                                    'tbl_subscriptions.package_type'  
                                )->orderBy('id','DESC')
                                ->where('tbl_playlists.device_id',$_SESSION['device_id'])
                                ->get();
       
    
        $data['$modulelink'] = $vars['modulelink']; 
        $data['version'] = $vars['version']; 
        $data['LANG'] = $vars['_lang']; 
        $data['MODULE_NAME'] = MODULE_NAME;
        $data['success'] = '';
        if(isset($_SESSION['success'])){
            $data['success'] = $_SESSION['success'];
            unset($_SESSION['success']);
        }
        $data['error'] = '';
        if(isset($_SESSION['error'])){
            $data['error'] = $_SESSION['error'];
            unset($_SESSION['error']);
        }
       
        return array(
            'pagetitle' => 'Multi Vision Module',
            'breadcrumb' => array(
                'index.php?m=multi_vision' => 'Multi Vision Module'),
            'templatefile' => 'clientarea/playlist_list',
            'requirelogin' => false, 
            'forcessl' => false, 
            'vars' => array(
                'data' => $data,
            ),
        );
    }

    public function manage_playlist($vars){

        if(!isset($_SESSION['device_id'])){
            die('Not found');
        }
        $data = [];
        $data['validated'] = true;
        if(isset($_GET['id']) && $_GET['id'] != ''){

            $data['result'] = $record =  Capsule::table('tbl_playlists')->where('id',$_GET['id'])->where('device_id',$_SESSION['device_id'])->first();
            if(!$record){
               die('Not found');
            }

            $data['id'] = trim($data['result']->id);
            $data['playlist_name'] = trim($data['result']->any_name);
            $data['playlist_type'] = trim($data['result']->type);
            $data['playlist'] = trim($data['result']->playlists);
            $data['username'] = trim($data['result']->username);
            $data['password'] = trim(decrypt($data['result']->shareable_password));
            $data['status'] = trim($data['result']->status);
        }
     
      
        if(isset($_POST['submit'])){
            $subscription_is = Capsule::table('tbl_subscriptions')->where('device_id', $_SESSION['device_id'])->first()->id;
            $data['id'] = $_POST['id'];
            $data['playlist_name'] = trim($_POST['playlist_name']);
            $data['mac_address'] =     $_SESSION['device_id'];
            $data['subscription_id'] = $subscription_is;
            $data['playlist_type'] = 'url';
            $data['playlist'] = trim($_POST['playlist']);
            $data['username'] = trim($_POST['username']);
            $data['password'] = trim($_POST['password']);
            $data['status'] = trim($_POST['status']);
           
           
            if($data['playlist_name'] == ''){
                $data['errors']['playlist_name'] = 'Please enter playlist name<br>';
                $data['validated'] = false;
            }
            if($data['playlist'] == ''){
                $data['errors']['playlist'] = 'Please enter playlist<br>';
                $data['validated'] = false;
            }
            if($data['username'] == ''){
                $data['errors']['username'] = 'Please enter username<br>';
                $data['validated'] = false;
            }
            if($data['password'] == ''){
                $data['errors']['password'] = 'Please enter password<br>';
                $data['validated'] = false;
            }

            if($data['id'] == ''){
                if(Capsule::table('tbl_playlists')->where('any_name',trim($data['playlist_name']))->first()){
                    $data['errors']['playlist_name'] = 'Playlist name already taken<br>';
                    $data['validated'] = false;
                }
            }else{
                if(Capsule::table('tbl_playlists')->where('id','!=',$data['id'])->where('any_name',trim($data['playlist_name']))->first()){
                    $data['errors']['playlist_name'] = 'Playlist name already taken<br>';
                    $data['validated'] = false;
                }
            }
           
            if($data['validated']){
               
                try{

                    if($_POST['id'] == ''){
                        $playlist_code = $this->generateUniqueKey();
                        Capsule::table('tbl_playlists')->insert([
                            'device_id' => $data['mac_address'],
                            'subscription_id' => $data['subscription_id'],
                            'type' => $data['playlist_type'],
                            'playlists' => $data['playlist'],
                            'username' => $data['username'],
                            'password' => password_hash($data['password'], PASSWORD_DEFAULT),
                            'shareable_password' => encrypt($data['password']),
                            'any_name' => $data['playlist_name'],
                            'playlist_code' => $playlist_code,
                            'status' => $data['status'],
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s")
                        ]);
                        $_SESSION['success'] = 'Playlist saved successfully';
                        ?>
                        <script>
                            let queryString = window.location.search; 
                            let urlParams = new URLSearchParams(queryString); 
                            window.location.href = window.location.href.split('&')[0] + '&action=playlist_list&mid=' + urlParams.get('mid');
                        </script>
                        <?php
                        exit();
                    }else{
                        if(Capsule::table('tbl_playlists')->where('id',$_POST['id'])->where('device_id',$_SESSION['device_id'])->update([
                            'device_id' => $data['mac_address'],
                            'subscription_id' => $data['subscription_id'],
                            'type' => $data['playlist_type'],
                            'playlists' => $data['playlist'],
                            'username' => $data['username'],
                            'password' => password_hash($data['password'], PASSWORD_DEFAULT),
                            'shareable_password' => encrypt($data['password']),
                            'any_name' => $data['playlist_name'],
                            'status' => $data['status'],
                            'updated_at' => date("Y-m-d H:i:s")
                        ])){
                            $_SESSION['success'] = 'Playlist updated successfully';
                        }else{
                            $_SESSION['error'] = 'Unable to update the record something went wrong';
                        }
                        ?>
                            <script>
                                queryString = window.location.search; 
                                urlParams = new URLSearchParams(queryString); 
                                let url = window.location.href = window.location.href.split('&')[0] + '&action=playlist_list&mid=' + urlParams.get('mid');
                            </script>
                        <?php
                        exit();
                    }
                
                }
                catch(Exception $e){
                    $error_messages =  $e->getMessage();
                }
                
              
            }
        }

        $data['macId'] = Capsule::table('tbl_devices')->where('id',$_SESSION['device_id'])->first()->mac_id;
        $data['package_type'] = strtoupper(Capsule::table('tbl_subscriptions')->where('device_id',$_SESSION['device_id'] )->first()->package_type);
        $data['next_due_date'] = date('jS F Y', strtotime(Capsule::table('tbl_subscriptions')->where('device_id',$_SESSION['device_id'] )->first()->expiry_date));

        $data['modulelink'] = $vars['modulelink']; 
        $data['version'] = $vars['version']; 
        $data['LANG'] = $vars['_lang']; 

         $data['MODULE_NAME'] = MODULE_NAME;
       
        return array(
            'pagetitle' => 'Multi Vision Module',
            'breadcrumb' => array(
                'index.php?m=multi_vision' => 'Multi Vision Module',
            ),
            'templatefile' => 'clientarea/playlist_manage',
            'requirelogin' => false, 
            'forcessl' => false, 
            'vars' => array(
                'data' => $data
            ),
        );
       
    }


    public function delete_playlist(){

        if(!isset($_SESSION['device_id'])){
            die('Not found');
        }
        if(Capsule::table('tbl_playlists')->where('id', $_GET['id'])->where('device_id',$_SESSION['device_id'])->delete()){
             $_SESSION['success'] = 'Playlist deleted successfully';
        }else{
            $_SESSION['error'] = 'Unable to delete the record something went wrong';
        }
       
        ?>
            <script>
                queryString = window.location.search; 
                urlParams = new URLSearchParams(queryString); 
                window.location.href = window.location.href.split('&')[0] + '&action=playlist_list&mid=' + urlParams.get('mid');
            </script>
           
        <?php
        exit();
    }



    function generateUniqueKey()
    {
        $playlist_code = rand(00000000,99999999);
        $exists = Capsule::table('tbl_playlists')
            ->where('playlist_code', $playlist_code)
            ->exists();
        if ($exists) {
            return $this->generateUniqueKey();
        }
        return $playlist_code;
    }

}
