<?php

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

use Illuminate\Database\Capsule\Manager as Capsule;

require_once 'hooks.php';

if ((include_once '' . __DIR__ . '/../NXT/NXT.php') == TRUE) {
    include_once '' . __DIR__ . '/../NXT/NXT.php';
    include_once '' . __DIR__ . '/../vpnservernoapi/vpnservernoapi.php';
} else if ((include_once '../NXT/NXT.php') == TRUE) {
    include_once '../NXT/NXT.php';
    include_once '../vpnservernoapi/vpnservernoapi.php';
} else {
    include_once '' . __DIR__ . '/../NXT/NXT.php';
    include_once '' . __DIR__ . '/../vpnservernoapi/vpnservernoapi.php';
}

function ownervpncombination_MetaData()
{
    return array(
        'DisplayName' => 'Combination VPN + NXT Owner Panel',
        'APIVersion' => '1.3.0',
        'RequiresServer' => true
    );
}

function ownervpncombination_ConfigOptions()
{
    $licenseinfo = NXTXtreamCodeCheckLicenseByKey();
    if ($licenseinfo['status'] == 'Active') {
        $moduledetails = Capsule::table('tbladdonmodules')
            ->where('module', '=', 'nxtdashboard')
            ->where('setting', '=', 'version')
            ->get();
        if (empty($moduledetails)) {
            return array('serverstatus' => array(
                'FriendlyName' => 'Module Status',
                'Description' => "<span style='color:red;'>Addon Module is not Activated Please Active it from Admin Area > Setup > Addon Modules > NXT Dashboard<span>",
                'Size' => 80
            ));
        }
        $moduleversion = $moduledetails[0]->value;
        if (basename($_SERVER['SCRIPT_NAME']) == "configaddons.php") {
            $serverdetails = Capsule::table('tbladdons')
                ->join('tblservergroupsrel', 'tbladdons.server_group_id', '=', 'tblservergroupsrel.groupid')
                ->join('tblservers', 'tblservergroupsrel.serverid', '=', 'tblservers.id')
                ->where('tbladdons.id', '=', $_REQUEST['id'])
                ->select('tblservers.*')
                ->get();
        } else {
            $serverdetails = Capsule::table('tblproducts')
                ->join('tblservergroupsrel', 'tblproducts.servergroup', '=', 'tblservergroupsrel.groupid')
                ->join('tblservers', 'tblservergroupsrel.serverid', '=', 'tblservers.id')
                ->where('tblproducts.id', '=', $_REQUEST['id'])
                ->select('tblservers.*')
                ->get();
        }
        if (isset($serverdetails) && !empty($serverdetails)) {
            $con = NXTXtreamCodeTestConnection($_REQUEST['id']);
            $result = mysqli_query($con, "SELECT * FROM groups");
            $grps = array();
            $grps[''] = 'Select Group';
            while ($membergrp = mysqli_fetch_assoc($result)) {
                $grps[$membergrp['group_id']] = NXTtransliteratestring(utf8_encode($membergrp['group_name']));
            }
            $regusers = mysqli_query($con, "SELECT * FROM members");
            $members = array();
            while ($reg_usersgrp = mysqli_fetch_assoc($regusers)) {
                $grpsreg[$reg_usersgrp['id']] = NXTtransliteratestring(utf8_encode($reg_usersgrp['username']));
            }
            NXT_WHMCSReconnect();
            // XUIONE_WHMCSReconnect();
            $description = '<div class="col-sm-12" ><div class="col-sm-8">NXT Panel Version v3.0 </div><div class="col-sm-4" style="margin-top: -5px;margin-left: -25px;
"><div class="progress" style="margin-bottom: 0px; margin-top:5px"><div class="progress-bar progress-bar-success" role="progressbar" aria-valuenow="40" aria-valuemin="0" aria-valuemax="100" style="width: 100%">
              Up to date!
             </div></div></div></div>';
            return array(
                // a text field type allows for single line text input
                'Module Version' => array(
                    'Description' => $description,
                ),
                'Product' => array(
                    'Type' => 'dropdown',
                    'Options' => array(
                        'streamlineonly' => 'Streaming Line',
                        'magdevice' => 'MAG Device',
                        'reselleraccount' => 'Reseller Account',
                        'resellercredits' => 'Reseller Credits',
                        'superreselleraccount' => 'Super-Reseller Account',
                        'addonpackage' => 'Package',
                    ),
                    'Description' => 'What type is this product?',
                    'Size' => 80
                ),
                'Fill Credits' => array(
                    'Type' => 'text',
                    'Size' => '20',
                    'Description' => 'How many credits this product gives? ( For "Reseller Credits Products", Leave empty for other product\'s type)',
                ),
                'Max Con.' => array(
                    'Type' => 'text',
                    'Size' => '20',
                    'Default' => '1',
                    'Description' => 'Maximum connections you allow for this product.',
                ),
                'Trial Package' => array(
                    'Type' => 'radio',
                    'Options' => 'Yes,No',
                    'Default' => 'No',
                    'Description' => 'Is this trial package? (For `Yes` see the text box for entering trial period)',
                ),
                'ISP Lock' => array(
                    'Type' => 'radio',
                    'Options' => 'Yes,No',
                    'Default' => 'Yes',
                    'Description' => 'Set ISP lock for streaming lines?',
                ),
                'Restreamer?' => array(
                    'Type' => 'radio',
                    'Options' => 'Yes,No',
                    'Default' => 'No',
                    'Description' => 'Is Reastreamer?',
                ),
                'M3U link' => array(
                    'Type' => 'yesno',
                    'Description' => 'Tick to Show M3U link in clientarea?',
                ),
                'Assign The Account To A Member' => array(
                    'Type' => 'dropdown',
                    'Size' => 80,
                    'Options' => $grpsreg,
                    'Description' => 'Select the specific User in the NXT Panel who the streamlines belong to',
                ),
                "Bouquets" => array(
                    "Name" => "Bouquets",
                    "Type" => "text",
                    "Size" => "20",
                    "Description" => '<br><a id="load-storm-tariff" onclick="tariffPlan()" href="javascript:;" class="load-configuration">Assign Bouquet to this product here</a>'
                ),
                'Watch Streams!' => array(
                    'Type' => 'yesno',
                    'Default' => 'yes',
                    'Description' => 'Tick to show NXT Codes’s client area link for watching streams online.',
                ),
                'Select NXT Reseller Group' => array(
                    'Type' => 'dropdown',
                    'Options' => $grps,
                    'Description' => 'Choose one',
                ),
                'Select NXT Super-Reseller Group' => array(
                    'Type' => 'dropdown',
                    'Options' => $grps,
                    'Description' => 'Choose one',
                ),
                'Start up Credits for Resellers' => array(
                    'Type' => 'text',
                    'Size' => '20',
                    'Default' => '0',
                    'Description' => 'Enter Number of credits to the reseller/super-reseller account as soon as they get enrolled',
                ),
                'MAG Portal link' => array(
                    'Type' => 'yesno',
                    'Default' => 'yes',
                    'Description' => 'Show MAG Portal link in Client Area',
                ),
                '' => array(
                    "Description" => '<center><a id="load-storm-tariff-custom-field" href="javascript:;" onclick="customfield()" class="load-configuration-custom-field"><span style="color:red">Recommended</span> - Click Here to Create Required Custom Fields</a></center>',
                    'Size' => 80
                ),
                'Expiry date' => array(
                    'Type' => 'yesno',
                    'Default' => 'yes',
                    "Description" => "Tick to sync expiry date in NXT Panel  ( Leave it unchecked to let our billing panel handles the billing period (Recommend))",
                    'Size' => 80
                ),
                'Trial Hours' => array(
                    'Type' => 'text',
                    'Size' => '20',
                    'Default' => '24',
                    'Description' => 'hour(s) ( Enter the number of hours for the trial period - leave it empty for 24 hours trial Period )',
                ),
                'AutoScript Section' => array(
                    'Type' => 'yesno',
                    'Description' => 'Tick to show <b><a target="_blank" href="https://drive.google.com/file/d/0Bxdm-R-xZmjYalpQY2FuME9PRXc/view?usp=drivesdk">AutoScript Section</a></b> on the Client Area. <a href="addonmodules.php?module=nxtdashboard&action=xtreamautoscript">Edit Section here</a>',
                    'Default' => 'off',
                ),
                'Other Device Section' => array(
                    'Type' => 'yesno',
                    'Description' => 'Tick to show <b><a style="text-decoration:underline" target="_blank" href="https://drive.google.com/file/d/0Bxdm-R-xZmjYX2hfa0RPNDNHaGM/view?usp=drivesdk">Other Device Section</a></b> on the Client Area.',
                    'Default' => 'on',
                ),
                'Product Type' => array(
                    'Type' => 'dropdown',
                    'Options' => ['member' => 'VPN Account', 'resellerCredits' => 'Reseller Credits', 'resellerAccount' => 'Reseller Account', 'superresellerAccount' => 'Super Reseller Account'],
                    'Description' => 'Select Product Type',
                ),
                'Assign Credits' => array(
                    'Type' => 'text',
                    'Description' => 'Assign Credits to Reseller',
                ),
                'Max Connecton' => array(
                    "Type" => "text", # Dropdown Choice of Options
                    'Description' => 'Max connection allow to per user.',
                ),
                'Set Server' => array(
                    'Type' => 'text',
                    'Description' => '<p class="showserverlist" onclick="showserverlist()">Click Here to select server to assign to this product</p>',
                )
            );
        } else {
            return array('serverstatus' => array(
                'FriendlyName' => 'Server Status',
                'Description' => "<span style='color:red;'>Please select the Server Group and Click on Save Changes.<span>",
                'Size' => 80
            ));
        }
    } else {
        return array('licenseKeyStatus' => array(
            'FriendlyName' => 'License Key Status',
            'Description' => "<span style='color:red;'>Invalid or Expired license key.<span>",
            'Size' => 80
        ),);
    }
}

function ownervpncombination_CreateAccount(array $params)
{
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    if (isset($_SESSION['vpncreate']) && $_SESSION['vpncreate'] == 'vpncreate') {
        $params['username'] = $_SESSION['username'];
        $params['password'] = $_SESSION['password'];

        unset($_SESSION['vpncreate'], $_SESSION['username'], $_SESSION['password']);

        $params['configoption1'] = $params['configoption21'];
        $params['configoption2'] = $params['configoption22'];
        $params['configoption3'] = $params['configoption23'];
        $params['configoption4'] = $params['configoption24'];

        return vpnservernoapi_CreateAccount($params);
    } else {
        $lovey1 = $params['configoption1'];
        $lovey2 = $params['configoption2'];
        $lovey3 = $params['configoption3'];
        $lovey4 = $params['configoption4'];

        $params['configoption1'] = $params['configoption21'];
        $params['configoption2'] = $params['configoption22'];
        $params['configoption3'] = $params['configoption23'];
        $params['configoption4'] = $params['configoption24'];
        vpnservernoapi_CreateAccount($params);

        $details = Capsule::table('tblhosting')
            ->where('id', $params["serviceid"])
            ->get();
        $username = $details[0]->username;
        $password = $details[0]->password;
        $command = 'DecryptPassword';
        $postData = array(
            'password2' => $password,
        );
        $decPassword = localAPI($command, $postData, '');
        $params['username'] = $username;
        $params['password'] = $decPassword['password'];
        $params['configoption1'] = $lovey1;
        $params['configoption2'] = $lovey2;
        $params['configoption3'] = $lovey3;
        $params['configoption4'] = $lovey4;
        $params['configoption21'] = $params['configoption20'];

        $response = NXT_CreateAccount($params);
        return 'success';
    }
    return 'success';
}

function ownervpncombination_SuspendAccount(array $params)
{
    NXT_SuspendAccount($params);
    $params['configoption1'] = $params['configoption21'];
    $params['configoption2'] = $params['configoption22'];
    $params['configoption3'] = $params['configoption23'];
    $params['configoption4'] = $params['configoption24'];

    vpnservernoapi_SuspendAccount($params);
    return 'success';
}
function ownervpncombination_ChangePackage(array $params)
{
    NXT_ChangePackage($params);
    return 'success';
}
function ownervpncombination_UnsuspendAccount(array $params)
{
    NXT_UnsuspendAccount($params);
    $params['configoption1'] = $params['configoption21'];
    $params['configoption2'] = $params['configoption22'];
    $params['configoption3'] = $params['configoption23'];
    $params['configoption4'] = $params['configoption24'];

    vpnservernoapi_UnsuspendAccount($params);
    return 'success';
}

function ownervpncombination_TerminateAccount(array $params)
{
    NXT_TerminateAccount($params);
    $params['configoption1'] = $params['configoption21'];
    $params['configoption2'] = $params['configoption22'];
    $params['configoption3'] = $params['configoption23'];
    $params['configoption4'] = $params['configoption24'];

    vpnservernoapi_TerminateAccount($params);
    return 'success';
}

function ownervpncombination_Renew(array $params)
{
    return NXT_Renew($params);
}

function ownervpncustom_randomchar($limit = 10)
{
    $permitted_chars = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    return substr(str_shuffle($permitted_chars), 0, $limit);
}

function ownervpncombination_ClientArea(array $params)
{
    $qrcode_image = "";
    // Determine the requested action and set service call parameters based on
    // the action.
    $requestedAction = isset($_REQUEST['customAction']) ? $_REQUEST['customAction'] : '';

    if ($requestedAction == 'downloadcert') {
        $serviceAction = 'get_usage';
        $templateFile = 'templates/downloadcert.tpl';
    } else {
        $serviceAction = 'get_stats';
        $templateFile = 'templates/overview.tpl';
    }

    $allserversData = Capsule::table('server_list')->where('mainserver', 0)->get();
    $allserver = array();
    $s = 0;
    foreach ($allserversData as $server) {
        if ($server->server_category == 'openvpn-ikev2') {
            $allserver[$s]['file'] = array('ovpn', 'pem');
        }
        if ($server->server_category == 'openvpn') {
            $allserver[$s]['file'] = array('ovpn');
        }
        if ($server->server_category == 'ikev2') {
            $allserver[$s]['file'] = array('pem');
        }
        $allserver[$s]['name'] = $server->server_name;
        $allserver[$s]['ip'] = $server->server_ip;
        $allserver[$s]['flag'] = $server->flag;

        $s++;
    }


    if (isset($_POST["generate_code"])) {
        $ServiceIDtoch = $params['serviceid'];
        $FolderTOsaveQrCode = "downloads/";

        //Delete OLD qr Codes images
        $getFiles = glob($FolderTOsaveQrCode . "*.png");
        if (!empty($getFiles)) {
            foreach ($getFiles as $imagesname) {
                $onlyfilename = str_replace($FolderTOsaveQrCode, "", $imagesname);
                if (preg_match(strtoupper('/' . $ServiceIDtoch . 'test/'), strtoupper($onlyfilename))) {
                    unlink($imagesname);
                }
            }
        }
        //Deleting process ends here

        if (file_exists("modules/servers/vpnservernoapi/lib/qr_code/qrlib.php")) {
            $start_digits = ownervpncustom_randomchar(11);
            $end_digits = ownervpncustom_randomchar(7);

            $C_Data = Capsule::table('tblclients')
                ->where('id', '=', $_SESSION["uid"])
                ->get();
            $ApiData = Capsule::table('mod_vpn_api')->where("setting", "=", "apikey")->get();
            $a = (isset($ApiData[0]->value) && !empty($ApiData[0]->value)) ? $ApiData[0]->value : "";
            $e = (isset($C_Data[0]->email) && !empty($C_Data[0]->email)) ? $C_Data[0]->email : "";
            $clientid = (isset($C_Data[0]->id) && !empty($C_Data[0]->id)) ? $C_Data[0]->id : "";
            $r = rand(00000000, 99999999);
            $salt = "KJHGFkugu345*&^klih";
            $tempsc = $e . "*" . $salt . "-" . $a . "-" . $r . "-";
            $mysc = md5($tempsc);


            $returnData = array(
                "sc" => $mysc,
                "e" => $e,
                "r" => $r,
                "u" => $clientid
            );
            $semifinal = json_encode($returnData);
            $finalData = $start_digits . base64_encode($semifinal) . $end_digits;
            include_once("modules/servers/vpnservernoapi/lib/qr_code/qrlib.php");
            $PNG_TEMP_DIR = $FolderTOsaveQrCode;
            $PNG_WEB_DIR = 'temp/';
            if (!file_exists($PNG_TEMP_DIR)) {
                mkdir($PNG_TEMP_DIR, 0777);
            }

            $filename = $PNG_TEMP_DIR . 'test.png';

            $errorCorrectionLevel = "H";
            $matrixPointSize = 6;

            $CodeDATAis = $finalData;
            $filename = $PNG_TEMP_DIR . $ServiceIDtoch . 'test' . md5($CodeDATAis . '|' . $errorCorrectionLevel . '|' . $matrixPointSize) . '.png';
            QRcode::png($CodeDATAis, $filename, $errorCorrectionLevel, $matrixPointSize, 2);
            $qrcode_image = $FolderTOsaveQrCode . basename($filename);
        }
    }
    $downloadovpn = 0;
    $downloadcert = 0;


    try {
        // Call the service's function based on the request action, using the
        // values provided by WHMCS in `$params`.
        $response = array();
        $appdata = array();
        $appdata1 = Capsule::table('mod_vpn_applinks')->get();
        // print_r($appdata); die();
        foreach ($appdata1 as $app) {
            if ($app->appfor == 'android') {
                $appdata['android'] = $app->applink;
            }
            if ($app->appfor == 'windows') {
                $appdata['windows'] = $app->applink;
            }
            if ($app->appfor == 'ios') {
                $appdata['ios'] = $app->applink;
            }
            if ($app->appfor == 'linux') {
                $appdata['linux'] = $app->applink;
            }
            if ($app->appfor == 'macos') {
                $appdata['macos'] = $app->applink;
            }
        }
        /* $extraVariable1 = 'abc';
          $extraVariable2 = '123'; */

        $serviceUsername = $params['username'];
        $servicePassword = $params['password'];
        $downloadovpnbuttonData = Capsule::table('tbladdonmodules')->where('module', '=', 'vpnpanel')->where('setting', 'downloadbutton')->get();
        $downloadovpnbutton = $downloadovpnbuttonData[0]->value;
        $data = Capsule::table('mod_vpn_settings')->get();
        $settings = array();
        foreach ($data as $val) {
            $settings[$val->settings] = $val->value;
        }
        $variabledata = array(
            'extracustomfields' => $params['customfields'],
            'appdata' => $appdata,
            'systemURL' => ownervpngetSystemURL(),
            'serviceid' => $params['serviceid'],
            'vpnusername' => $serviceUsername,
            'vpnpassword' => $servicePassword,
            'qrcode_image' => $qrcode_image,
            'allservers' => $allserver,
            'downloadovpn' => $downloadovpn,
            'downloadcert' => $downloadcert,
            'settings' => $settings,
            'downloadovpnbutton' => $downloadovpnbutton,
            'clientEmail' => $params['clientsdetails']['email'],
        );

        // return array(
        //     'tabOverviewReplacementTemplate' => $templateFile,
        //     'templateVariables' => $variabledata,
        // );
    } catch (Exception $e) {
        // Record the error in WHMCS's module log.
        logModuleCall(
            'vpnservernoapi',
            __FUNCTION__,
            $params,
            $e->getMessage(),
            $e->getTraceAsString()
        );

        // In an error condition, display an error page.
        return array(
            'tabOverviewReplacementTemplate' => 'error.tpl',
            'templateVariables' => array(
                'usefulErrorHelper' => $e->getMessage(),
            ),
        );
    }













    /* $params['ServerHostName'] = $params['templatevars']['moduleParams']['serverhostname'];
      //Condition to check hostname is exists or not
      if ($params['templatevars']['moduleParams']['serverhostname'] == "") {
      $GetPackageID = Capsule::table('tblhosting')
      ->where('id', $params['serviceid'])
      ->select('packageid')
      ->get();
      if (!empty($GetPackageID)) {
      $PackaeID = $GetPackageID[0]->packageid;
      $params['ServerHostName'] = NXT_GetServerHostname($PackaeID);
      }
      } */

    // Determine the requested action and set service call parameters based on
    // the action.

    $response = '';
    $access_outputdata = array();
    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    $portURL = $returndata['portalurl'];


    /* $bar = "/";
      echo substr($portURL, -1);

      if(substr($portURL, -1) == "/")
      {
      $bar =  "";
      }
      $portURL = $portURL.$bar; */




    $params['ServerHostName'] = $portURL;
    $removecustomfields = array($returndata['custom_field_mag'], $returndata['checkmagdevice'], $returndata['custom_field_eng'], $returndata['checkengdevice'], 'Username', 'Password');
    $customfieldfrontend = $params['customfields'];
    foreach ($removecustomfields as $removefield) {
        unset($customfieldfrontend[$removefield]);
    }
    $con = NXTXtreamCodeTestConnection($params['pid']);
    $reseller_notes = $returndata['common_identifier'] . $params["serviceid"];
    $requestedAction = isset($_REQUEST['customAction']) ? $_REQUEST['customAction'] : '';

    if ($requestedAction == 'addMAG') {
        if (!preg_match('/([0-9A-Fa-f]{2}[:]){5}([0-9A-Fa-f]{2})/', $_POST['newMAC'])) {
            $response = 'error';
            $result = 'MAC Address is not Valid!';
        } else {
            $macexists = NXT_CheckMAG($_POST['newMAC'], $con);
            if (empty($macexists)) {
                $response = NXT_AddMAG($params, $_POST['newMAC']);
                if ($response == 'success') {
                    $result = $returndata['mac_add_success'] . ' ' . $_POST['newMAC'];
                }
            } elseif ($macexists == 'macexists') {
                $response = 'error';
                $result = $returndata['mac_error'];
            }
        }
    } elseif ($requestedAction == 'changeMAG') {
        if (isset($params['configoptions'][$returndata['configoption_field_name']]) && !empty($params['configoptions'][$returndata['configoption_field_name']])) {
            if (isset($_POST['savechanges']) && !empty($_POST['savechanges'])) {
                if (!preg_match('/([0-9A-Fa-f]{2}[:]){5}([0-9A-Fa-f]{2})/', $_POST['newMAC'])) {
                    $response = 'error';
                    $result = 'MAC Address is not Valid!';
                } else {
                    $response = NXT_ChangeMAG($params, $_POST['newMAC'], $_POST['oldmag']);
                    if ($response == 'success') {
                        $result = $returndata['mac_change_success'];
                    } elseif ($response == 'macexists') {
                        $result = $returndata['mac_error'];
                    }
                }
            } elseif (isset($_POST['delete']) && !empty($_POST['delete'])) {
                $response = NXT_DeleteMAG($params, $_POST['oldmag']);
                if ($response == 'success') {
                    $result = "MAC Address Deleted Successfully!!";
                } elseif ($response == 'macnotexists') {
                    $result = "MAC Address doesn't exist!";
                }
            }
        } else {
            if (!preg_match('/([0-9A-Fa-f]{2}[:]){5}([0-9A-Fa-f]{2})/', $_POST['newMAC'])) {
                $response = 'error';
                $result = 'MAC Address is not Valid!';
            } else {
                $response = NXT_ChangeMAGSingle($params, $_POST['newMAC']);
                if ($response == 'success') {
                    $result = $returndata['mac_change_success'];
                } elseif ($response == 'macexists') {
                    $result = $returndata['mac_error'];
                }
            }
        }
    } elseif ($requestedAction == 'addENG') {
        $response = NXT_AddENG($params, $_POST['newMAC']);
        if ($response == 'success') {
            $magdata = $_POST['newMAC'];
            $result = $returndata['mac_add_success'] . ' ' . $_POST['newMAC'];
        }
    } elseif ($requestedAction == 'changeENG') {
        $response = NXT_ChangeENG($params, $_POST['newMAC']);
        if ($response == 'success') {
            $magdata = $_POST['newMAC'];
            $result = $returndata['mac_change_success'];
        } elseif ($response == 'macexists') {
            $result = $returndata['mac_error'];
        }
    } elseif ($requestedAction == 'changePassword') {
        $response = NXT_PasswordChange($params, $_POST['newPassword']);
        if ($response == 'success') {
            $newPassword = $_POST['newPassword'];
            $result = 'Password Changed successfully';
        } elseif ($response == 'error') {
            $result = 'Error Occurr while updateing password!';
        }
    }
    if ($params['configoption2'] == 'magdevice') {
        $responsedata = NXTXtreamMAGDevice($params, $returndata, $response, $result);
        $templateFile = $responsedata['templateFile'];
        $variabledata = $responsedata['variabledata'];
        if ($requestedAction == "jass") {
            $templateFile = 'templates/custommagtemplate.tpl';
        }
    } elseif ($params['configoption2'] == 'engdevice') {
        $responsedata = NXTXtreamENGDevice($params, $returndata, $magdata, $response, $result);
        $templateFile = $responsedata['templateFile'];
        $variabledata = $responsedata['variabledata'];
    } elseif ($params['configoption2'] == 'streamlineonly') {
        $xtreamautoscipt = Capsule::table('mod_xtreamautoscript')->get();
        foreach ($xtreamautoscipt as $value) {
            $autoscript[$value->name] = $value->value;
        }
        $autoscriptconfig = ($params['configoption19'] == 'on') ? "on" : "";
        $otherdevicesconfig = ($params['configoption20'] == 'on') ? "on" : "";
        if ($requestedAction == 'manage') {
            //Get Access Output Code'
            $access_output = mysqli_query($con, "SELECT * FROM access_output");
            while ($output = mysqli_fetch_assoc($access_output)) {
                if ($output['output_name'] == 'MPEGTS') {
                    $outputfirst = $output['output_key'];
                }
                $access_outputdata[] = $output;
            }
            if (empty($outputfirst)) {
                $outputfirst = array_values($access_outputdata)[0]['output_key'];
            }
            // Collecting parameters 
            $serviceAction = 'get_usage';
            $templateFile = 'templates/manage.tpl';
        } else {
            $iptvusername = $params["username"];
            $con = NXTXtreamCodeTestConnection($params['pid']);

            $usersresult = mysqli_query($con, "SELECT id, exp_date FROM users WHERE username='$iptvusername' ");
            if (!$usersresult) {
                $radiussqlerror = mysqli_error($con);
                NXT_WHMCSReconnect();
                return "NXT Database Query Error: " . $radiussqlerror;
            }
            if (mysqli_num_rows($usersresult) > 0) {
                $userid = mysqli_fetch_assoc($usersresult);
                $serviceAction = 'get_stats';
                $templateFile = 'templates/overview.tpl';
            } else {
                $error = 'User Not found!';
                $templateFile = 'templates/error.tpl';
            }
        }

        $variabledata += array(
            'iptv_username' => $params['username'],
            'iptv_password' => $params['password'],
            'ServerHostName' => $params['ServerHostName'],
            'response' => $response,
            'message' => isset($result) && !empty($result) ? $result : $response,
            'lang' => $returndata,
            'autoscript' => $autoscript,
            'autoscriptconfig' => $autoscriptconfig,
            'otherdevicesconfig' => $otherdevicesconfig,
            'm3ulink' => $params['configoption8'],
            'watchstream' => $params['configoption11'],
            'mag_portal' => $params['configoption15'],
            'usefulErrorHelper' => isset($error) && !empty($error) ? $error : '',
            'accessoutput' => $access_outputdata,
            'outputfirst' => $outputfirst,
            'm3ulinkoutput' => (isset($outputfirst) && !empty($outputfirst) ? $outputfirst : 'xxx'),
            'status' => $params['status'],
            'exp_date' => isset($userid['exp_date']) && !empty($userid['exp_date']) ? date('Y-m-d H:i:s', $userid['exp_date']) : ''
        );
    } elseif ($params['configoption2'] == 'streamline' || $params['configoption2'] == 'streamlineeng') {
        $xtreamautoscipt = Capsule::table('mod_xtreamautoscript')->get();
        foreach ($xtreamautoscipt as $value) {
            $autoscript[$value->name] = $value->value;
        }
        $autoscriptconfig = ($params['configoption19'] == 'on') ? "on" : "";
        $otherdevicesconfig = ($params['configoption20'] == 'on') ? "on" : "";

        $checkmagdevice = $params['customfields'][$returndata['checkmagdevice']];
        $checkengdevice = $params['customfields'][$returndata['checkengdevice']];
        if (isset($checkmagdevice) && !empty($checkmagdevice)) {
            if ($checkmagdevice == 'on') {
                $responsedata = NXTXtreamMAGDevice($params, $returndata, $response, $result);
                $templateFile = $responsedata['templateFile'];
                $variabledata = $responsedata['variabledata'];
            }
        } elseif (isset($checkengdevice) && !empty($checkengdevice)) {
            if ($checkengdevice == 'on') {
                $responsedata = NXTXtreamENGDevice($params, $returndata, $magdata, $response, $result);
                $templateFile = $responsedata['templateFile'];
                $variabledata = $responsedata['variabledata'];
            }
        } else {
            if ($requestedAction == 'manage') {

                $MAC = 'None';
                $con = NXTXtreamCodeTestConnection($params['pid']);
                //Get Access Output Code'
                $access_output = mysqli_query($con, "SELECT * FROM access_output");

                while ($output = mysqli_fetch_assoc($access_output)) {
                    if ($output['output_name'] == 'MPEGTS') {
                        $outputfirst = $output['output_key'];
                    }
                    $access_outputdata[] = $output;
                }
                if (empty($outputfirst)) {
                    $outputfirst = array_values($access_outputdata)[0]['output_key'];
                }
                // Collecting parameters
                $iptvusername = $params["username"];
                $iptvusernameresult = mysqli_query($con, "SELECT * FROM users WHERE username='$iptvusername' ");
                // $iptvusernameresult = mysqli_query($con, "SELECT * FROM users WHERE username='$iptvusername'");
                if (mysqli_num_rows($iptvusernameresult) == 0) {
                    NXT_WHMCSReconnect();
                    return "User Not Found!!";
                } else {
                    $pairid = mysqli_fetch_assoc($iptvusernameresult);
                    if (isset($pairid['pair_id']) && !empty($pairid['pair_id'])) {
                        $mag_devices = mysqli_query($con, "SELECT * FROM `mag_devices` WHERE user_id='" . $pairid['pair_id'] . "'");
                        if (mysqli_num_rows($mag_devices) == 0) {
                            $eng_devices = mysqli_query($con, "SELECT * FROM `enigma2_devices` WHERE user_id='" . $pairid['pair_id'] . "'");
                            if (mysqli_num_rows($eng_devices) == 0) {
                                $MAC = 'None';
                            } else {
                                $engdetails = mysqli_fetch_assoc($eng_devices);
                                if (isset($engdetails) && !empty($engdetails)) {
                                    $MAC = $engdetails['mac'];
                                }
                            }
                        } else {
                            $mag_details = mysqli_fetch_assoc($mag_devices);
                            if (isset($mag_details) && !empty($mag_details)) {
                                $MAC = base64_decode($mag_details['mac']);
                            }
                        }
                    } else {
                        $MAC = 'None';
                    }
                }
                $serviceAction = 'get_usage';
                $templateFile = 'templates/manage.tpl';
            } else {
                $iptvusername = $params["username"];
                $con = NXTXtreamCodeTestConnection($params['pid']);
                $usersresult = mysqli_query($con, "SELECT id, exp_date FROM users WHERE username='$iptvusername' ");
                if (!$usersresult) {
                    $radiussqlerror = mysqli_error($con);
                    NXT_WHMCSReconnect();
                    return "NXT Database Query Error: " . $radiussqlerror;
                }
                if (mysqli_num_rows($usersresult) > 0) {
                    $userid = mysqli_fetch_assoc($usersresult);
                    $serviceAction = 'get_stats';
                    $templateFile = 'templates/overview.tpl';
                } else {
                    $error = 'User Not found!';
                    $templateFile = 'templates/error.tpl';
                }
            }
            $engima = ($params['configoption2'] == 'streamlineeng') ? 'yes' : 'no';
            $variabledata += array(
                'iptv_username' => $params['username'],
                'iptv_password' => $params['password'],
                'ServerHostName' => $params['ServerHostName'],
                'mag' => $MAC,
                'option' => 'streammag',
                'engma' => $engima,
                'response' => $response,
                'message' => isset($result) && !empty($result) ? $result : $response,
                'lang' => $returndata,
                'm3ulink' => $params['configoption8'],
                'watchstream' => $params['configoption11'],
                'mag_portal' => $params['configoption15'],
                'usefulErrorHelper' => isset($error) && !empty($error) ? $error : '',
                'accessoutput' => $access_outputdata,
                'autoscript' => $autoscript,
                'autoscriptconfig' => $autoscriptconfig,
                'otherdevicesconfig' => $otherdevicesconfig,
                'outputfirst' => $outputfirst,
                'm3ulinkoutput' => (isset($outputfirst) && !empty($outputfirst) ? $outputfirst : 'xxx'),
                'status' => $params['status'],
                'exp_date' => isset($userid['exp_date']) && !empty($userid['exp_date']) ? date('Y-m-d H:i:s', $userid['exp_date']) : ''
            );
        }
    } elseif ($params['configoption2'] == 'streamlineengmag') {
        $xtreamautoscipt = Capsule::table('mod_xtreamautoscript')->get();
        foreach ($xtreamautoscipt as $value) {
            $autoscript[$value->name] = $value->value;
        }
        $autoscriptconfig = ($params['configoption19'] == 'on') ? "on" : "";
        $otherdevicesconfig = ($params['configoption20'] == 'on') ? "on" : "";

        $checkmagdevice = $params['customfields'][$returndata['checkmagdevice']];
        $checkengdevice = $params['customfields'][$returndata['checkengdevice']];
        if (isset($checkmagdevice) && !empty($checkmagdevice)) {
            if ($checkmagdevice == 'on') {
                $responsedata = NXTXtreamMAGDevice($params, $returndata, $response, $result);
                $templateFile = $responsedata['templateFile'];
                $variabledata = $responsedata['variabledata'];
            }
        } elseif (isset($checkengdevice) && !empty($checkengdevice)) {
            if ($checkengdevice == 'on') {
                $responsedata = NXTXtreamENGDevice($params, $returndata, $magdata, $response, $result);
                $templateFile = $responsedata['templateFile'];
                $variabledata = $responsedata['variabledata'];
            }
        } else {
            if ($requestedAction == 'manage') {
                $eng_MAC = 'None';
                $mag_MAC = 'None';
                $con = NXTXtreamCodeTestConnection($params['pid']);
                //Get Access Output Code'
                $access_output = mysqli_query($con, "SELECT * FROM access_output");

                while ($output = mysqli_fetch_assoc($access_output)) {
                    if ($output['output_name'] == 'MPEGTS') {
                        $outputfirst = $output['output_key'];
                    }
                    $access_outputdata[] = $output;
                }
                if (empty($outputfirst)) {
                    $outputfirst = array_values($access_outputdata)[0]['output_key'];
                }
                // Collecting parameters
                $iptvusername = $params["username"];
                $iptvusernameresult = mysqli_query($con, "SELECT * FROM users WHERE username='$iptvusername' ");
                // $iptvusernameresult = mysqli_query($con, "SELECT * FROM users WHERE username='$iptvusername'");
                if (mysqli_num_rows($iptvusernameresult) == 0) {
                    NXT_WHMCSReconnect();
                    return "User Not Found!!";
                } else {
                    $eng_MAC = 'None';
                    $mag_MAC = 'None';
                    $pairid = mysqli_fetch_assoc($iptvusernameresult);
                    if (isset($pairid['pair_id']) && !empty($pairid['pair_id'])) {
                        if (isset($params['customfields'][$returndata['custom_field_mag']]) && !empty($params['customfields'][$returndata['custom_field_mag']])) {
                            $mag_MAC = $params['customfields'][$returndata['custom_field_mag']];
                            $mag_devices = mysqli_query($con, "SELECT * FROM `mag_devices` WHERE mac ='" . base64_encode($mag_MAC) . "'");
                            if (mysqli_num_rows($mag_devices) == 0) {
                                $mag_MAC = 'None';
                            }
                        }
                        if (isset($params['customfields'][$returndata['custom_field_eng']]) && !empty($params['customfields'][$returndata['custom_field_eng']])) {
                            $eng_MAC = $params['customfields'][$returndata['custom_field_eng']];
                            $eng_devices = mysqli_query($con, "SELECT * FROM `enigma2_devices` WHERE mac='" . $eng_MAC . "'");
                            if (mysqli_num_rows($eng_devices) == 0) {
                                $eng_MAC = 'None';
                            }
                        }
                    }
                }
                $serviceAction = 'get_usage';
                $templateFile = 'templates/manage.tpl';
            } else {
                $iptvusername = $params["username"];
                $con = NXTXtreamCodeTestConnection($params['pid']);
                $usersresult = mysqli_query($con, "SELECT id, exp_date FROM users WHERE username='$iptvusername' ");
                if (!$usersresult) {
                    $radiussqlerror = mysqli_error($con);
                    NXT_WHMCSReconnect();
                    return "NXT Database Query Error: " . $radiussqlerror;
                }
                if (mysqli_num_rows($usersresult) > 0) {
                    $userid = mysqli_fetch_assoc($usersresult);
                    $serviceAction = 'get_stats';
                    $templateFile = 'templates/overview.tpl';
                } else {
                    $error = 'User Not found!';
                    $templateFile = 'templates/error.tpl';
                }
            }
            $engima = ($params['configoption2'] == 'streamlineeng') ? 'yes' : 'no';
            $variabledata += array(
                'iptv_username' => $params['username'],
                'iptv_password' => $params['password'],
                'ServerHostName' => $params['ServerHostName'],
                'engmac' => $eng_MAC,
                'magmac' => $mag_MAC,
                'option' => 'streammageng',
                'engma' => $engima,
                'response' => $response,
                'message' => isset($result) && !empty($result) ? $result : $response,
                'lang' => $returndata,
                'm3ulink' => $params['configoption8'],
                'watchstream' => $params['configoption11'],
                'mag_portal' => $params['configoption15'],
                'usefulErrorHelper' => isset($error) && !empty($error) ? $error : '',
                'accessoutput' => $access_outputdata,
                'autoscript' => $autoscript,
                'autoscriptconfig' => $autoscriptconfig,
                'otherdevicesconfig' => $otherdevicesconfig,
                'outputfirst' => $outputfirst,
                'm3ulinkoutput' => (isset($outputfirst) && !empty($outputfirst) ? $outputfirst : 'xxx'),
                'status' => $params['status'],
                'exp_date' => isset($userid['exp_date']) && !empty($userid['exp_date']) ? date('Y-m-d H:i:s', $userid['exp_date']) : ''
            );
        }
    } else {
        $templateFile = 'templates/overview.tpl';
        $variabledata = array('reseller' => 'yes');
    }

    $checkupgrade = Capsule::table('tblhosting')
        ->join('tblproducts', 'tblhosting.packageid', '=', 'tblproducts.id')
        ->join('tblproduct_upgrade_products', 'tblproducts.id', '=', 'tblproduct_upgrade_products.product_id')
        ->select('tblproduct_upgrade_products.*')
        ->where('tblhosting.id', $params['serviceid'])
        ->count();
    $checkupgrade = ($checkupgrade > 0) ? '1' : '0';
    $is_trial = ($params['configoption5'] == 'Yes') ? '1' : '0';
    $variabledata['is_trial'] = $is_trial;
    $variabledata['checkupgrade'] = $checkupgrade;
    $variabledata['service_id'] = $params['serviceid'];
    $variabledata['extracustomfields'] = $customfieldfrontend;

    if ($requestedAction == 'downloadcert') {
        $serviceAction = 'get_usage';
        $templateFile = 'templates/downloadcert.tpl';
    }

    try {
        $serverList = Capsule::table('server_list')->where('mainserver', '0')->where('status', 1)->get();
        $selected_servers =  explode(',', trim($params['configoption24']));
        $servers = array();
        foreach ($serverList as $val) {
            if (in_array($val->server_id, $selected_servers)) {
                $servers[$val->server_id] = $val->server_name;
            }
        }
        foreach ($variabledata['allservers'] as $key => $val) {
            if (!in_array($val['name'], $servers)) {
                unset($variabledata['allservers'][$key]);
            }
        }
        NXT_WHMCSReconnect();
        return array(
            'tabOverviewReplacementTemplate' => $templateFile,
            'templateVariables' => $variabledata,
        );
    } catch (Exception $e) {
        // Record the error in WHMCS's module log.
        logModuleCall(
            'NXT',
            __FUNCTION__,
            $params,
            $e->getMessage(),
            $e->getTraceAsString()
        );

        // In an error condition, display an error page.
        return array(
            'tabOverviewReplacementTemplate' => 'error.tpl',
            'templateVariables' => array(
                'usefulErrorHelper' => $e->getMessage(),
            ),
        );
    }
}

function ownervpngetSystemURL()
{
    $configData = Capsule::table('tblconfiguration')->where('setting', 'SystemURL')->select('value')->get();
    return $configData[0]->value;
}

function ownervpncombination_TestConnection(array $params)
{

    try {

        $sqlusername = $params["serverusername"];
        $sqlpassword = $params["serverpassword"];

        $sqlhost = $params["serverip"];

        list($sqldbname, $sqlport) = explode(':', $params["serveraccesshash"]);
        if (isset($sqlport) && !empty($sqlport))
            $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname, $sqlport);
        else
            $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname);

        // Check connection
        if (mysqli_connect_errno()) {
            $success = false;
            $errorMsg = "Failed to connect to MySQL: " . mysqli_connect_error();
        } else {
            $success = true;
            $errorMsg = '';
        }
    } catch (Exception $e) {
        // Record the error in WHMCS's module log.
        logModuleCall(
            'ownervpncombination',
            __FUNCTION__,
            $params,
            $e->getMessage(),
            $e->getTraceAsString()
        );

        $success = false;
        $errorMsg = $e->getMessage();
    }
    NXT_WHMCSReconnect();
    // XUIONE_WHMCSReconnect();
    return array(
        'success' => $success,
        'error' => $errorMsg,
    );
}
