<?php
if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

require_once __DIR__ . '/lib/Admin/Autobackup_AdminDispatcher2.php';
require_once __DIR__ . '/lib/Admin/Autobackup_Controller2.php';

use WHMCS\Database\Capsule;



function AutoBackupV2_config()
{
    $configarray = array(
        'name' => 'Auto Backup WHMCS V2 .0',
        'description' => 'This module provides ability take automatic backup',
        'author' => "<a href='https://www.whmcssmarters.com/' target='_blank'><img src='../modules/addons/AutoBackupV2/whmcssmarters.png' alt='WHMCS SMARTER'></a>",
        'language' => 'english',
        'version' => '2.0',
        'fields' => array(
            "licenseregto" => array(
                "FriendlyName" => "License Registered To",
                "Description" => "Not Available"
            ),
            "licenseregmail" => array(
                "FriendlyName" => "License Registered Email",
                "Description" => "Not Available"
            ),
            "licenseduedate" => array(
                "FriendlyName" => "License Due Date",
                "Description" => "Not Available"
            ),
            "licensestatus" => array(
                "FriendlyName" => "License Status",
                "Description" => "Not Available"
            ),
            "license" => array(
                "FriendlyName" => "License",
                "Type" => "text",
                "Size" => "35"
            ), 
            "salt" => array(
                "FriendlyName" => "Salt",
                "Type" => "text",
                "Default" => "SMARTERSSHOP",
                "Description" => "Insert any string for security",
            ),
            "autobackup_table" => array(
                "FriendlyName" => "Auto Backup Tables",
                "Type" => "yesno",
                "Description" => "while activing mode option to delete tables check.",
            )
        )
    );
    $licenseinfo = AutoBackupV2_doCheckLicense();
    if ($licenseinfo['status'] != 'licensekeynotfound') {
        if ($licenseinfo['status'] == 'Active') {
        }
        if ($licenseinfo['registeredname']) {
            $configarray['fields']['licenseregto']['Description'] = $licenseinfo['registeredname'];
        }
        if ($licenseinfo['email']) {
            $configarray['fields']['licenseregmail']['Description'] = $licenseinfo['email'];
        }
        if ($licenseinfo['nextduedate']) {
            $configarray['fields']['licenseduedate']['Description'] = $licenseinfo['nextduedate'];
        }
        $configarray['fields']['licensestatus']['Description'] = $licenseinfo['status'];
        $configarray['fields']['license']['Value'] = $licenseinfo['licensekey'];
    }
    return $configarray;
}





function AutoBackupV2_doCheckLicense()
{
    $result = Capsule::table('tbladdonmodules')->where('module', '=', 'AutoBackupV2')->get();
    foreach ($result as $row) {
        $settings[$row->setting] = $row->value;
    }
    if ($settings['license']) {
        $localkey = $settings['localkey'];
        $licenseinfo = $result = AutoBackupV2_checkLicense($settings['license'], $localkey);
        if (isset($licenseinfo['localkey']) && !empty($licenseinfo['localkey'])) {
            $checklocal = Capsule::table('tbladdonmodules')->where('module', '=', 'AutoBackupV2')->where('setting', '=', 'localkey')->count();
            if ($checklocal > 0) {
                Capsule::table('tbladdonmodules')->where('module', '=', 'AutoBackupV2')->where('setting', '=', 'localkey')->delete();
            }
            Capsule::table('tbladdonmodules')->insert(
                ['setting' => 'localkey', 'value' => $licenseinfo['localkey'], 'module' => 'AutoBackupV2']
            );
        }
        $result['licensekey'] = $settings['license'];
    } else {
        $result['status'] = 'licensekeynotfound';
    }
    return $result;
}


function AutoBackupV2_checkLicense($licensekey, $localkey = '')
{
    $whmcsurl = "https://www.whmcssmarters.com/clients/";
    $licensing_secret_key = "autobackup";
    $localkeydays = 14;
    $allowcheckfaildays = 5;
    $check_token = time() . md5(mt_rand(1000000000, 9999999999) . $licensekey);
    $checkdate = date("Ymdhis");
    $domain = $_SERVER['SERVER_NAME'];
    $usersip = isset($_SERVER['SERVER_ADDR']) ? $_SERVER['SERVER_ADDR'] : $_SERVER['LOCAL_ADDR'];
    $dirpath = dirname(__FILE__);
    $verifyfilepath = 'modules/servers/licensing/verify.php';
    $localkeyvalid = false;
    if ($localkey) {
        $localkey = str_replace("\n", '', $localkey); # Remove the line breaks
        $localdata = substr($localkey, 0, strlen($localkey) - 32); # Extract License Data
        $md5hash = substr($localkey, strlen($localkey) - 32); # Extract MD5 Hash
        if ($md5hash == md5($localdata . $licensing_secret_key)) {
            $localdata = strrev($localdata); # Reverse the string
            $md5hash = substr($localdata, 0, 32); # Extract MD5 Hash
            $localdata = substr($localdata, 32); # Extract License Data
            $localdata = base64_decode($localdata);
            $localkeyresults = unserialize($localdata);
            $originalcheckdate = $localkeyresults['checkdate'];
            if ($md5hash == md5($originalcheckdate . $licensing_secret_key)) {
                $localexpiry = date("Ymdhis", mktime(date("h"), date("i"), date("s"), date("m"), date("d") - $localkeydays, date("Y")));
                if ($originalcheckdate > $localexpiry) {
                    $localkeyvalid = true;
                    $results = $localkeyresults;
                    $validdomains = explode(',', $results['validdomain']);
                    if (!in_array($_SERVER['SERVER_NAME'], $validdomains)) {
                        $localkeyvalid = false;
                        $localkeyresults['status'] = "Invalid";
                        $results = array();
                    }
                    $validips = explode(',', $results['validip']);
                    if (!in_array($usersip, $validips)) {
                        $localkeyvalid = false;
                        $localkeyresults['status'] = "Invalid";
                        $results = array();
                    }
                    $validdirs = explode(',', $results['validdirectory']);
                    if (!in_array($dirpath, $validdirs)) {
                        $localkeyvalid = false;
                        $localkeyresults['status'] = "Invalid";
                        $results = array();
                    }
                }
            }
        }
    }
    if (!$localkeyvalid) {
        $responseCode = 0;
        $postfields = array(
            'licensekey' => $licensekey,
            'domain' => $domain,
            'ip' => $usersip,
            'dir' => $dirpath
        );
        if ($check_token)
            $postfields['check_token'] = $check_token;
        $query_string = '';
        foreach ($postfields as $k => $v) {
            $query_string .= $k . '=' . urlencode($v) . '&';
        }
        if (function_exists('curl_exec')) {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $whmcsurl . $verifyfilepath);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $query_string);
            curl_setopt($ch, CURLOPT_TIMEOUT, 30);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            $data = curl_exec($ch);
            $responseCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
        } else {
            $responseCodePattern = '/^HTTP\/\d+\.\d+\s+(\d+)/';
            $fp = @fsockopen($whmcsurl, 80, $errno, $errstr, 5);
            if ($fp) {
                $newlinefeed = "\r\n";
                $header = "POST " . $whmcsurl . $verifyfilepath . " HTTP/1.0" . $newlinefeed;
                $header .= "Host: " . $whmcsurl . $newlinefeed;
                $header .= "Content-type: application/x-www-form-urlencoded" . $newlinefeed;
                $header .= "Content-length: " . @strlen($query_string) . $newlinefeed;
                $header .= "Connection: close" . $newlinefeed . $newlinefeed;
                $header .= $query_string;
                $data = $line = '';
                @stream_set_timeout($fp, 20);
                @fputs($fp, $header);
                $status = @socket_get_status($fp);
                while (!@feof($fp) && $status) {
                    $line = @fgets($fp, 1024);
                    $patternMatches = array();
                    if (!$responseCode && preg_match($responseCodePattern, trim($line), $patternMatches)) {
                        $responseCode = (empty($patternMatches[1])) ? 0 : $patternMatches[1];
                    }
                    $data .= $line;
                    $status = @socket_get_status($fp);
                }
                @fclose($fp);
            }
        }
        if ($responseCode != 200) {
            $localexpiry = date("Ymdhis", mktime(date("h"), date("i"), date("s"), date("m"), date("d") - ($localkeydays + $allowcheckfaildays), date("Y")));
            if ($originalcheckdate > $localexpiry) {
                $results = $localkeyresults;
            } else {
                $results = array();
                $results['status'] = "Invalid";
                $results['description'] = "Remote Check Failed";
                return $results;
            }
        } else {
            preg_match_all('/<(.*?)>([^<]+)<\/\\1>/i', $data, $matches);
            $results = array();
            foreach ($matches[1] as $k => $v) {
                $results[$v] = $matches[2][$k];
            }
        }
        if (!is_array($results)) {
            die("Invalid License Server Response");
        }
        if ($results['md5hash']) {
            if ($results['md5hash'] != md5($licensing_secret_key . $check_token)) {
                $results['status'] = "Invalid";
                $results['description'] = "MD5 Checksum Verification Failed";
                return $results;
            }
        }
        if ($results['status'] == "Active") {
            $results['checkdate'] = $checkdate;
            $data_encoded = serialize($results);
            $data_encoded = base64_encode($data_encoded);
            $data_encoded = md5($checkdate . $licensing_secret_key) . $data_encoded;
            $data_encoded = strrev($data_encoded);
            $data_encoded = $data_encoded . md5($data_encoded . $licensing_secret_key);
            $data_encoded = wordwrap($data_encoded, 80, "\n", true);
            $results['localkey'] = $data_encoded;
        }
        $results['remotecheck'] = true;
    }
    unset($postfields, $data, $matches, $whmcsurl, $licensing_secret_key, $checkdate, $usersip, $localkeydays, $allowcheckfaildays, $md5hash);
    return $results;
}


function AutoBackupV2_activate()
{
    // Create custom tables and schema required by your module
    if (!Capsule::schema()->hasTable('ab_billingdb')) {
        Capsule::schema()->create(
            'ab_billingdb',
            function ($table) {
                $table->increments('id');
                $table->string('time');
                $table->string('backup_file');
                $table->timestamp('create_on');
            }
        );
    }

    if (!Capsule::schema()->hasTable('ab_externaldb')) {
        Capsule::schema()->create(
            'ab_externaldb',
            function ($table) {
                $table->increments('id');
                $table->string('time');
                $table->string('backup_file');
                $table->timestamp('create_on');
            }
        );
    }

    return array('status' => 'success', 'description' => 'Acivated Successfully');
    return array('status' => 'error', 'description' => 'There was a problem activating the module');
}


function AutoBackupV2_deactivate()
{
    $settings = array();
    $results = Capsule::table('tbladdonmodules')->where('module', '=', 'AutoBackupV2')->get();
    foreach ($results as $row) {
        $settings[$row->setting] = $row->value;
    }


    if (isset($settings['autobackup_table']) && !empty($settings['autobackup_table'])) {
        if ($settings['autobackup_table'] == 'on') {
            Capsule::schema()->dropIfExists('ab_billingdb');
            Capsule::schema()->dropIfExists('ab_externaldb');
        }
    }

    # Return Result

    return array('status' => 'success', 'description' => 'Deactivated Successfully');

    return array('status' => 'error', 'description' => 'There was a problem deactivating the module');
}




function AutoBackupV2_output($vars)
{

    $licenseinfo = AutoBackupV2_doCheckLicense();
    if ($licenseinfo["status"] == "Active") {
        // Get common module parameters
        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
        $version = $vars['version']; // eg. 1.0
        $_lang = $vars['_lang']; // an array of the currently loaded language variables

        include_once 'tabs.php';

        // Dispatch and handle request here. What follows is a demonstration of one
        // possible way of handling this using a very basic dispatcher implementation.

        $action = isset($_REQUEST['action']) ? $_REQUEST['action'] : '';

        $dispatcher = new Autobackup_AdminDispatcher2();
        $response = $dispatcher->dispatch($action, $vars);
        echo $response;
    } else {
?>
        <div class="gracefulexit">
            Invalid License Key
        </div>
<?php
    }
}




function AutoBackupV2_clientarea($vars)
{
    echo "sorry there is not out for this module for clients";
}
