<?php
use WHMCS\Database\Capsule;
use \WHMCS\Module\GatewaySetting;


if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

function custompaypalgateway_MetaData() {
    return array(
        'DisplayName' => 'Custom Paypal Gateway',
        'APIVersion' => '1.0', // Use API Version 1.1 
    );
}

function custompaypalgateway_config() {

    $configarray = array();    
    $configarray['FriendlyName'] = array("Type" => "System","Value" => "Custom Paypal Gateway");    
    $gatewayConfig = GatewaySetting::where('gateway', '=', 'custompaypalgateway')->get();
    $Gatewaydata = array();
    if(!empty($gatewayConfig))
    {
        foreach ($gatewayConfig as $gatewayDetails)
        {
            $Gatewaydata[$gatewayDetails->setting] = $gatewayDetails->value;
        }
    }
    $license = "";
    $localkey = "";
    $checklicense = custompaypalgateway_doCheckLicense();
    if ($checklicense['status'] == 'Active')
    {   
        /*$configarray['bussinessemail'] = array(
                                            "FriendlyName" => "Bussiness Email",
                                            "Type" => "text",
                                            "Size" => "25"
                                            );*/
        $configarray['hostingurl'] = array(
                                            "FriendlyName" => "Hosting Url",
                                            "Type" => "text",
                                            "Size" => "25",
                                             'Description' => 'Enter your Hosting Site URL- http://yourwebsite.com',
                                            );

        $impdesc = '<div class="alert alert-danger clearfix" role="alert" style="margin:0;"><i class="fas fa-info-circle fa-3x pull-left fa-fw"></i><div style="margin-left: 56px;"><p><strong>Important.</strong> You need to add Hosting Url to get your IPN link.</p> </div></div>';
        if(isset($Gatewaydata["hostingurl"]) && !empty($Gatewaydata["hostingurl"]))
        {
            $bar = "/";
            if(substr($Gatewaydata["hostingurl"], -1) == "/")
            {
                $bar =  "";
            }
            $Gatewaydata["hostingurl"] = $Gatewaydata["hostingurl"].$bar;
            $impdesc =  '<div class="alert alert-info clearfix" role="alert" style="margin:0;"><i class="fas fa-info-circle fa-3x pull-left fa-fw"></i><div style="margin-left: 56px;"><p><strong>Important.</strong> Make sure you have setup the IPN on paypal account.</p> <div class="input-group"><span class="input-group-addon">IPN URL</span><input type="text" id="qbcronPhp" value="'.$Gatewaydata["hostingurl"].'paypalcallbckhandler.php" class="form-control" readonly="readonly"><span class="input-group-btn"><button class="btn btn-default copy-to-clipboard" data-clipboard-target="#qbcronPhp" type="button"><i class="fal fa-copy" title="Copy to clipboard"></i><span class="sr-only">Copy to clipboard&gt;</span></button></span></div> </div></div>';
        }                       
                        
        $configarray['importantnote'] = array(
                                             'Description' => $impdesc,
                                            );
        /*$configarray['paypaltest'] = array(                                            
                                            'FriendlyName' => 'Development',
                                            'Type' => 'yesno',
                                            'Default' => 'on',
                                            'Size' => '100',
                                            'Description' => 'Click for development',                                        
                                        );    */
        $configarray['licenseStatus'] = array(
                                        "FriendlyName" => "License Status",
                                        "Description" => "<span style='color:green'><b>{$checklicense['status']}</span></b>"
                                        );
        $configarray['registeredname'] = array(
                                            "FriendlyName" => "License Registered With",
                                            "Description" => $checklicense["registeredname"]
                                            );
        $configarray['registeredemail'] = array(
                                            "FriendlyName" => "License Registered Email",
                                            "Description" => $checklicense["email"]
                                            );
        $configarray['nextduedate'] = array(
                                            "FriendlyName" => "License Expire On",
                                            "Description" => $checklicense["nextduedate"]
                                            );
    }
    else
    {
        $configarray['licenseStatus'] = array(
                                            "FriendlyName" => "License Status",
                                            "Description" => "<span style='color:red'><b>{$checklicense['status']}</span></b>"
                                            );
        
    }
	$configarray['license'] = array(
                                "FriendlyName" => "license",
                                "Type" => "text",
                                "Size" => "25",
                                "Value" => $license
                                );

	

    return $configarray;

}

function custompaypalgateway_doCheckLicense() {

    $gatewayConfig = GatewaySetting::where('gateway', '=', 'custompaypalgateway')->get();
    $settings = array();
    if(!empty($gatewayConfig))
    {
        foreach ($gatewayConfig as $gatewayDetails)
        {
             if ($gatewayDetails->setting == "license") 
            {
                $settings['license'] = $gatewayDetails->value;
            }  
            if ($gatewayDetails->setting == "localkey") 
            {
                $settings['localkey'] = $gatewayDetails->value;
            }
        }
    }

    if ($settings['license']) {
        $localkey = $settings['localkey'];
        $result = custompaypalgateway_checkLicense($settings['license'], $localkey);
        //echo "<pre>";print_r($result);die();
        if (isset($result['localkey']) && !empty($result['localkey'])) {
            $newlocalkey = $result['localkey'];
            $checklocalkeyexists = GatewaySetting::where('gateway', '=', 'custompaypalgateway')->where('setting', '=', "localkey")->count();
            if($checklocalkeyexists > 0)
            {
               $gatewayConfig = GatewaySetting::where('gateway', '=', 'custompaypalgateway')->where('setting', '=', "localkey")->update(['value' => $newlocalkey]); 
            }
            else
            {
                $gatewayConfig = GatewaySetting::insert(
                        ['gateway' => 'custompaypalgateway', 'setting' => "localkey", 'value' => $newlocalkey]
                );
            }
        }
        $result['licensekey'] = $settings['license'];
    } else {
        $result['status'] = 'License is required';
    }
    return $result;
}


function custompaypalgateway_checkLicense($licensekey, $localkey = '')
{    
    $whmcsurl = "https://www.whmcssmarters.com/clients/";
    $licensing_secret_key = "PaypalCross";
    $localkeydays = 14;
    $allowcheckfaildays = 5;
    $check_token = time() . md5(mt_rand(1000000000, 9999999999) . $licensekey);
    $checkdate = date("Ymdhis");
    $domain = $_SERVER['SERVER_NAME'];
    $usersip = isset($_SERVER['SERVER_ADDR']) ? $_SERVER['SERVER_ADDR'] : $_SERVER['LOCAL_ADDR'];
    $dirpath = dirname( dirname( __DIR__ ) ).'/modules/addons/cross_connection_setup';
    $verifyfilepath = 'modules/servers/licensing/verify.php';
    $localkeyvalid = false;
    if ($localkey) {
        $localkey = str_replace("\n", '', $localkey); # Remove the line breaks
        $localdata = substr($localkey, 0, strlen($localkey) - 32); # Extract License Data
        $md5hash = substr($localkey, strlen($localkey) - 32); # Extract MD5 Hash
        if ($md5hash == md5($localdata . $licensing_secret_key)) {
            $localdata = strrev($localdata); # Reverse the string
            $md5hash = substr($localdata, 0, 32); # Extract MD5 Hash
            $localdata = substr($localdata, 32); # Extract License Data
            $localdata = base64_decode($localdata);
            $localkeyresults = unserialize($localdata);
            $originalcheckdate = $localkeyresults['checkdate'];
            if ($md5hash == md5($originalcheckdate . $licensing_secret_key)) {
                $localexpiry = date("Ymdhis", mktime(date("h"), date("i"), date("s"), date("m"), date("d") - $localkeydays, date("Y")));
                if ($originalcheckdate > $localexpiry) {
                    $localkeyvalid = true;
                    $results = $localkeyresults;
                    $validdomains = explode(',', $results['validdomain']);
                    if (!in_array($_SERVER['SERVER_NAME'], $validdomains)) {
                        $localkeyvalid = false;
                        $localkeyresults['status'] = "Invalid";
                        $results = array();
                    }
                    $validips = explode(',', $results['validip']);
                    if (!in_array($usersip, $validips)) {
                        $localkeyvalid = false;
                        $localkeyresults['status'] = "Invalid";
                        $results = array();
                    }
                    $validdirs = explode(',', $results['validdirectory']);
                    if (!in_array($dirpath, $validdirs)) {
                        $localkeyvalid = false;
                        $localkeyresults['status'] = "Invalid";
                        $results = array();
                    }
                }
            }
        }
    }
    if (!$localkeyvalid) {
        $responseCode = 0;
        $postfields = array(
            'licensekey' => $licensekey,
            'domain' => $domain,
            'ip' => $usersip,
            'dir' => $dirpath,
        );
        if ($check_token)
            $postfields['check_token'] = $check_token;
        $query_string = '';
        foreach ($postfields AS $k => $v) {
            $query_string .= $k . '=' . urlencode($v) . '&';
        }
        if (function_exists('curl_exec')) {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $whmcsurl . $verifyfilepath);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $query_string);
            curl_setopt($ch, CURLOPT_TIMEOUT, 30);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            $data = curl_exec($ch);
            $responseCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
        } else {
            $responseCodePattern = '/^HTTP\/\d+\.\d+\s+(\d+)/';
            $fp = @fsockopen($whmcsurl, 80, $errno, $errstr, 5);
            if ($fp) {
                $newlinefeed = "\r\n";
                $header = "POST " . $whmcsurl . $verifyfilepath . " HTTP/1.0" . $newlinefeed;
                $header .= "Host: " . $whmcsurl . $newlinefeed;
                $header .= "Content-type: application/x-www-form-urlencoded" . $newlinefeed;
                $header .= "Content-length: " . @strlen($query_string) . $newlinefeed;
                $header .= "Connection: close" . $newlinefeed . $newlinefeed;
                $header .= $query_string;
                $data = $line = '';
                @stream_set_timeout($fp, 20);
                @fputs($fp, $header);
                $status = @socket_get_status($fp);
                while (!@feof($fp) && $status) {
                    $line = @fgets($fp, 1024);
                    $patternMatches = array();
                    if (!$responseCode && preg_match($responseCodePattern, trim($line), $patternMatches)
                    ) {
                        $responseCode = (empty($patternMatches[1])) ? 0 : $patternMatches[1];
                    }
                    $data .= $line;
                    $status = @socket_get_status($fp);
                }
                @fclose($fp);
            }
        }
        if ($responseCode != 200) {
            $localexpiry = date("Ymdhis", mktime(date("h"), date("i"), date("s"), date("m"), date("d") - ($localkeydays + $allowcheckfaildays), date("Y")));
            if ($originalcheckdate > $localexpiry) {
                $results = $localkeyresults;
            } else {
                $results = array();
                $results['status'] = "Invalid";
                $results['description'] = "Remote Check Failed";
                return $results;
            }
        } else {
            preg_match_all('/<(.*?)>([^<]+)<\/\\1>/i', $data, $matches);
            $results = array();
            foreach ($matches[1] AS $k => $v) {
                $results[$v] = $matches[2][$k];
            }
        }
        if (!is_array($results)) {
            die("Invalid License Server Response");
        }
        if ($results['md5hash']) {
            if ($results['md5hash'] != md5($licensing_secret_key . $check_token)) {
                $results['status'] = "Invalid";
                $results['description'] = "MD5 Checksum Verification Failed";
                return $results;
            }
        }
        if ($results['status'] == "Active") {
            $results['checkdate'] = $checkdate;
            $data_encoded = serialize($results);
            $data_encoded = base64_encode($data_encoded);
            $data_encoded = md5($checkdate . $licensing_secret_key) . $data_encoded;
            $data_encoded = strrev($data_encoded);
            $data_encoded = $data_encoded . md5($data_encoded . $licensing_secret_key);
            $data_encoded = wordwrap($data_encoded, 80, "\n", true);
            $results['localkey'] = $data_encoded;
        }
        $results['remotecheck'] = true;
    } 
    unset($postfields, $data, $matches, $whmcsurl, $licensing_secret_key, $checkdate, $usersip, $localkeydays, $allowcheckfaildays, $md5hash);
    return $results;
}




function custompaypalgateway_link($params)
{
    global $CONFIG;
    $checklicense = custompaypalgateway_doCheckLicense();
    if ($checklicense['status'] == 'Active')
    {   


        //$paypaltest = (isset($params["paypaltest"]) && $params["paypaltest"] == "on")?"on":"";
        //$bussinessemail = (isset($params["bussinessemail"]) && !empty($params["bussinessemail"]))?$params["bussinessemail"]:"";
        $hostinglink = (isset($params["hostingurl"]) && !empty($params["hostingurl"]))?$params["hostingurl"]:"";
        $bar = "/";
        if(substr($hostinglink, -1) == "/")
        {
            $bar =  "";
        }
        $hostinglink = $hostinglink.$bar;

        //Invoice Parameters
        $invoiceid = (isset($params["invoiceid"]) && !empty($params["invoiceid"]))?$params["invoiceid"]:"";
        $amount = (isset($params["amount"]) && !empty($params["amount"]))?$params["amount"]:"";
        $description = (isset($params["description"]) && !empty($params["description"]))?$params["description"]:"";
        $CurrencyCode = (isset($params["currency"]) && !empty($params["currency"]))?$params["currency"]:"";

        $firstname = $params['clientdetails']['firstname'];
        $lastname = $params['clientdetails']['lastname'];
        $email = $params['clientdetails']['email'];
        $address1 = $params['clientdetails']['address1'];
        $address2 = $params['clientdetails']['address2'];
        $city = $params['clientdetails']['city'];
        $state = $params['clientdetails']['state'];
        $postcode = $params['clientdetails']['postcode'];
        $country = $params['clientdetails']['country'];
        $phone = $params['clientdetails']['phonenumber'];




        if(!empty($invoiceid))
        {
           
            $newteamwillbe = "Invoice #".$invoiceid;


            $htmlOutput = '<form method="post" action="'.$hostinglink.'paypalhandler.php" id="PayPalFrom">';
            $htmlOutput.= '<input type="hidden" value="_xclick" name="cmd">';
            //$htmlOutput.= '<input type="hidden" value="'.$bussinessemail.'" name="business">';
            $htmlOutput.= '<input type="hidden" value="'.$newteamwillbe.'" name="item_name">';
            //$htmlOutput.= '<input type="hidden" value="NA" name="item_number">';
            $htmlOutput.= '<input type="hidden" value="'.$amount.'" name="amount">';
            $htmlOutput.= '<input type="hidden" value="'.$firstname.'" name="first_name">';
            $htmlOutput.= '<input type="hidden" value="'.$lastname.'" name="last_name">';
            $htmlOutput.= '<input type="hidden" value="'.$email.'" name="email">';
            $htmlOutput.= '<input type="hidden" value="'.$address1.'" name="address1">';
            $htmlOutput.= '<input type="hidden" value="'.$city.'" name="city">';
            $htmlOutput.= '<input type="hidden" value="'.$state.'" name="state">';
            $htmlOutput.= '<input type="hidden" value="'.$postcode.'" name="zip">';
            $htmlOutput.= '<input type="hidden" value="'.$country.'" name="country">';
            $htmlOutput.= '<input type="hidden" value="'.$phone.'" name="night_phone_a">';
            $htmlOutput.= '<input type="hidden" value="'.$phone.'" name="night_phone_b">';
            $htmlOutput.= '<input type="hidden" name="charset" value="utf-8">';
            $htmlOutput.= '<input type="hidden" value="'.$CurrencyCode.'" name="currency_code">';
            $htmlOutput.= '<input type="hidden" value="'.$hostinglink.'paypalcallbckhandler.php?invoiceid='.$invoiceid.'" name="return">';
            $htmlOutput.= '<input type="hidden" value="'.$hostinglink.'paypalcallbckhandler.php?invoiceid='.$invoiceid.'" name="cancel_return">';
            $htmlOutput.= '<input type="hidden" value="'.$invoiceid.'" name="custom">';
            //$htmlOutput.= '<input type="hidden" value="'.$paypaltest.'" name="paypalfinallink">';
            $htmlOutput.= '<input type="hidden" value="US" name="lc">';
            $htmlOutput.= '<input type="hidden" value="PP-BuyNowBF" name="bn">';
            $htmlOutput.= '<input type="hidden" value="2" name="rm">';

            // print_r(getcwd());
            // die();
            $htmlOutput.="<button type='submit'style='padding: 0px;'><img src='/modules/gateways/custompaypalgateway/images/x-click-but03.gif'></button>";
            // $htmlOutput.="<button type='submit'style='padding: 0px;'>Pay Check</button>";
                            
            $htmlOutput.= '</form>';
        }
        else
        {
            $htmlOutput = "Invalid Request";
        }
        return $htmlOutput;





        echo("<pre>");
        print_r($params);
        die();

       $CLientDetails = paypalreceiver_GetClientDetails($params['clientdetails']['userid']);



        $HostingUrl=$params['HostingUrl'];

        $bar = "/";
        if(substr($params['HostingUrl'], -1) == "/")
        {
            $bar =  "";
        }
         $params['HostingUrl'] = $params['HostingUrl'].$bar;
         $SiteUrl = $params['HostingUrl']."paypalHandler.php";



        $htmlOutput.="<form method='POST' action='".$SiteUrl."'>";
        $htmlOutput.="<input type='hidden' name='invoiceid' value='".$params['invoiceid']."'>";
        $htmlOutput.="<input type='hidden' name='mainamount' value='".$params['amount']."'>";
        $htmlOutput.="<input type='hidden' name='product' value='single web hosting'>";
       
        $htmlOutput.="<input type='hidden' name='AddPayment' value=''>";
        $htmlOutput.="<button type='submit' name='AddPayment2' style='padding: 0px;'><img src='https://www.paypal.com/en_US/i/btn/x-click-but03.gif'></button>";
        $htmlOutput.="</form>"; 

            return $htmlOutput;
    }
    else
    {
        logModuleCall('Custom Paypal Gateway', "License error", $checklicense, $checklicense);
        return "Sorry something went wrong please try again later";
    }
}



function paypalreceiver_GetAdminID() {
    try {
        $records = Capsule::table('tbladmins')->where("roleid", 1)->select("id")->get();
        return ['status' => 'success', 'records' => $records[0]->id];
    } catch (\Exception $e) {
        return ['status' => 'error', 'message' => "There is error while getting the record.Error :- {$e->getMessage()}"];
    }
}
?>