<?php

include_once("../../../../../init.php");

use WHMCS\Database\Capsule;

function XtremeDashboard_Ajax_AddClient($params)
{
    $adminUser = XtremeDashboard_Ajax_AdminDetails();
    $result = localAPI("AddClient", $params, $adminUser);
    return $result;
}

function XtremeDashboard_Ajax_AddChannel($params)
{

    $data = Capsule::table('mod_xtreamchannelsList')->where('channel_list', '=', $params['channel_list'])->get();
    if (count($data) > 0) {
        return 'Existing';
    } else {
        $data = Capsule::table('mod_xtreamchannelsList')->insert(['categoryId' => $params['catID'], 'channel_category' => $params['channel_category'], 'channel_list' => $params['channel_list']]);
        if ($data == 1) {
            return 'Success';
        } else {
            return 'Failed';
        }
    }
}

function XtremeDashboard_Ajax_DeleteChannel($params)
{

    $data = Capsule::table('mod_xtreamchannelsList')->where('channel_list', '=', $params['channel_list'])->delete();
    if ($data == 1) {
        return 'Success';
    } else {
        return 'Failed';
    }
}

function XtremeDashboard_Ajax_AddOrder($params)
{
    $adminUser = XtremeDashboard_Ajax_AdminDetails();
    $result = localAPI("AddOrder", $params, $adminUser);
    return $result;
}

function XtremeDashboard_Ajax_UpdateClientProduct($params)
{
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }
    $_SESSION["vpncreate"] = "vpncreate";
    $command = 'ModuleCreate';
    $postData = array(
        'serviceid' => $params['serviceid'],
    );
    $results = localAPI($command, $postData);

    $adminUser = XtremeDashboard_Ajax_AdminDetails();
    $result = localAPI("UpdateClientProduct", $params, $adminUser);
    return $result;
}

function XtremeDashboard_Ajax_AdminDetails()
{
    $result_admin = Capsule::table('tbladmins')->where('roleid', '=', '1')->get();
    $adminUsername = $result_admin[0]->username;
    return $adminUsername;
}

function XtremeDashboard_Ajax_GetProductDetails($pid)
{
    $result = Capsule::table('tblproducts')->where('id', '=', $pid)->get(array('configoption2'));
    $configoption = $result[0]->configoption2;
    return $configoption;
}

function XtremeDashboard_Ajax_GetClientGroups()
{
    $adminUser = XtremeDashboard_Ajax_AdminDetails();
    $result = localAPI("GetClientGroups", "", $adminUser);
    return $result;
}

function XtremeDashboard_Ajax_AffiliateActivate($params)
{
    $adminUser = XtremeDashboard_Ajax_AdminDetails();
    $result = localAPI("AffiliateActivate", $params, $adminUser);
    return $result;
}

function XtremeDashboard_Ajax_PaymentGateway()
{
    $adminUser = XtremeDashboard_Ajax_AdminDetails();
    $result = localAPI("GetPaymentMethods", "", $adminUser);
    return $result;
}

function XtremeDashboard_Ajax_AddCredit($params)
{
    $adminUser = XtremeDashboard_Ajax_AdminDetails();
    $result = localAPI("AddCredit", $params, $adminUser);
    return $result;
}

function XtremeDashboard_getWHMCSaffid($clientid)
{
    $adminUser = XtremeDashboard_Ajax_AdminDetails();
    $command = 'getaffiliates';
    $values['userid'] = $clientid;
    $affdetails = localAPI($command, $values, $adminUser);
    if ($affdetails['result'] === 'success' && $affdetails['totalresults'] == 1) {
        $affdetails = $affdetails['affiliates']['affiliate'][0];
    }
    return $affdetails['id'];
}

function XtremeDashboard_getClientByAffID($affiliateID)
{
    $clientdata = Capsule::table('tblaffiliates')->where('id', '=', $affiliateID)->select('clientid')->get();
    if (!empty($clientdata[0]->clientid)) {
        $clientdata = Capsule::table('tblclients')->where('id', '=', $clientdata[0]->clientid)->select('firstname', 'lastname', 'email')->get();
        $returndata = json_decode(json_encode($clientdata[0]), true);
        return $returndata;
    }
}

function XtreamDashboard_TestConnection()
{
    $servers = Capsule::table('tblservers')
        ->where('tblservers.type', '=', 'XtreamCode')
        ->select('tblservers.*')
        ->get();
    if (isset($servers) && !empty($servers)) {
        foreach ($servers as $server) {

            $sqlusername = $server->username;
            $sqlpassword = decrypt($server->password);
            $sqldbname = $server->accesshash;
            $sqlhost = $server->ipaddress;
            list($sqldbname, $sqlport) = explode(':', $sqldbname);
            if (isset($sqlport) && !empty($sqlport))
                $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname, $sqlport);
            else
                $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname);
        }
        if (!$con) {
            $result = array("status" => "error");
        } else {
            $result = array("status" => "success", "link" => $con);
        }
        return $result;
    }
}

function XtreamDashboard_WHMCSReconnect()
{
    require(ROOTDIR . "/configuration.php");
    $whmcsmysql = mysqli_connect($db_host, $db_username, $db_password, $db_name);
}

function XtremeDashboard_UpdateResellerNote($note, $resellerID)
{
    $testConnectionResult = XtreamDashboard_TestConnection();
    if ($testConnectionResult['status'] == "success") {
        mysqli_query($testConnectionResult['link'], "UPDATE members SET notes='$note' WHERE id='$resellerID'");
        mysqli_close($testConnectionResult['link']);
        XtreamDashboard_WHMCSReconnect();
    }
}

if (isset($_POST['action']) && $_POST['action'] == "import_reseller") {
    //    $returnResponse = array();
    //    $returnResponse['result'] = "success";
    //    $returnResponse['data'] = "14";
    //    echo json_encode($returnResponse);
    //    exit;
    if (!empty($_POST['resellerData'])) {
        $decodedData = base64_decode($_POST['resellerData']);
        $pid = $_POST['selectedProduct'];
        $configoption = XtremeDashboard_Ajax_GetProductDetails($pid);
        $clientGroupsResult = XtremeDashboard_Ajax_GetClientGroups();
        if (!empty($configoption)) {
            if ($configoption == "reselleraccount") {
                $groupName = "Reseller";
            }
            if ($configoption == "superreselleraccount") {
                $groupName = "Super-Reseller";
            }
        }

        if ($clientGroupsResult['result'] == "success" && count($clientGroupsResult['totalresults']) > 0) {
            foreach ($clientGroupsResult['groups']['group'] as $group) {
                if ($group['groupname'] == $groupName) {
                    $groupid = $group['id'];
                    break;
                }
            }
        }
        $unserializedData = unserialize($decodedData);
        $addClient = array();
        $addClient['firstname'] = $unserializedData['username'];
        $addClient['email'] = $unserializedData['email'];
        $addClient['password2'] = $unserializedData['username'];
        $addClient['noemail'] = true;
        $addClient['skipvalidation'] = true;
        if (!empty($groupid)) {
            $addClient['groupid'] = $groupid;
        }

        $AddClientResult = XtremeDashboard_Ajax_AddClient($addClient);

        if (isset($AddClientResult['result']) && $AddClientResult['result'] == "success") {
            $addCredit = array();
            $addCredit['clientid'] = $AddClientResult['clientid'];
            $addCredit['description'] = "Import Credits";
            $addCredit['amount'] = $unserializedData['credits'];
            XtremeDashboard_Ajax_AddCredit($addCredit);
            $addOrder['clientid'] = $AddClientResult['clientid'];
            $addOrder['pid'][0] = $pid;
            $addOrder['noinvoiceemail'] = true;
            $addOrder['noemail'] = true;
            $PaymentGateways = XtremeDashboard_Ajax_PaymentGateway();
            $paymentGateway = $PaymentGateways['paymentmethods']['paymentmethod'][0]['module'];
            $addOrder['paymentmethod'] = $paymentGateway;
            $AddOrderResult = XtremeDashboard_Ajax_AddOrder($addOrder);
            if (isset($AddOrderResult['result']) && $AddOrderResult['result'] == "success") {
                $updateService = array();
                $updateService['serviceid'] = $AddOrderResult['productids'];
                $updateService['serviceusername'] = $unserializedData['email'];
                $updateService['status'] = "Active";
                XtremeDashboard_Ajax_UpdateClientProduct($updateService);
                $activateAffliate = array();
                $activateAffliate['userid'] = $AddClientResult['clientid'];
                XtremeDashboard_Ajax_AffiliateActivate($activateAffliate);
                $affliateID = XtremeDashboard_getWHMCSaffid($AddClientResult['clientid']);

                $command = 'GetPaymentMethods';
                $postData = array();
                $results = localAPI($command, $postData);
                if ($results['totalresults'] > 0) {
                    $module = $results['paymentmethods']['paymentmethod']['module'];
                    $invoiceid = $AddOrderResult['invoiceid'];
                    //Change Status to Paid
                    Capsule::table('tblinvoices')->where('id', $invoiceid)->update(['status' => 'Paid', 'paymentmethod' => $module]);
                }

                if (isset($_POST['affid']) && !empty($_POST['affid'])) {
                    Capsule::table('mod_xtreamAffs_clients')
                        ->insert(array(
                            'affiliatesid' => $_POST['affid'],
                            'clientid' => $AddClientResult['clientid']
                        ));
                    $resellerdata = XtremeDashboard_getClientByAffID($_POST['affid']);
                    if (isset($resellerdata) && !empty($resellerdata) && is_array($resellerdata)) {
                        $customfieldid = XtremeDashboard_getCustomFieldId("Reseller");
                        XtremeDashboard_insertCustomFieldsValues($customfieldid, $AddClientResult['clientid'], $resellerdata['firstname'] . " " . $resellerdata['lastname'] . " (" . $resellerdata['email'] . ")");
                    }
                }


                $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
                $returndata = array();
                if (isset($xtreamConfig) && !empty($xtreamConfig)) {
                    foreach ($xtreamConfig as $config) {
                        $returndata[$config->setting] = $config->value;
                    }
                }
                $note = $returndata['common_identifier'] . "" . $AddClientResult['clientid'];
                XtremeDashboard_UpdateResellerNote($note, $unserializedData['id']);
                $returnResponse['result'] = "success";
                $returnResponse['data'] = $affliateID;
                echo json_encode($returnResponse);
                exit;
            } else {
                $returnResponse['result'] = "failed";
                echo json_encode($returnResponse);
                exit;
            }
        } else {
            $returnResponse['result'] = "failed";
            echo json_encode($returnResponse);
            exit;
        }
    } else {
        $returnResponse['result'] = "alreadyImported";
        echo json_encode($returnResponse);
        exit;
    }
}


if (isset($_POST['action']) && $_POST['action'] == "import_channels") {
    if (!empty($_POST['channelData'])) {

        $categories = $_POST['channelData'];
        $channels = $_POST['selectedchannels'];
        $categ_id = $_POST['channel_ID'];

        // $unserializedData = unserialize($decodedData);
        $addChannel = array();
        $addChannel['channel_category'] = $categories;
        $addChannel['channel_list'] = $channels;
        $addChannel['catID'] = $categ_id;
        $AddChannelResult = XtremeDashboard_Ajax_AddChannel($addChannel);
        echo $AddChannelResult;
    }
}

if (isset($_POST['action']) && $_POST['action'] == "delete_channels") {
    if (!empty($_POST['channelData'])) {

        $categories = $_POST['channelData'];
        $channels = $_POST['selectedchannels'];
        $categ_id = $_POST['channel_ID'];

        // $unserializedData = unserialize($decodedData);
        $DeleteChannel = array();
        $DeleteChannel['channel_category'] = $categories;
        $DeleteChannel['channel_list'] = $channels;
        $DeleteChannel['catID'] = $categ_id;
        $DeleteChannelResult = XtremeDashboard_Ajax_DeleteChannel($DeleteChannel);
        echo $DeleteChannelResult;
    }
}

function XtremeDashboard_getCustomFieldId($customFieldName)
{
    $id = Capsule::table('tblcustomfields')
        ->where('type', 'client')
        ->where('relid', '0')
        ->where('fieldname', $customFieldName)
        ->value('id');
    return $id;
}

function XtremeDashboard_insertCustomFieldsValues($customfieldid, $clientid, $newvalue)
{
    Capsule::table('tblcustomfieldsvalues')
        ->insert(array('fieldid' => $customfieldid, 'relid' => $clientid, 'value' => $newvalue));
}

if (isset($_POST['action']) && $_POST['action'] == "import_stream") {

    if (!empty($_POST['streamData'])) {
        $decodedData = base64_decode($_POST['streamData']);
        $pid = $_POST['selectedProduct'];
        $unserializedData = unserialize($decodedData);
        $admimnotes =  $unserializedData['admin_notes'];
        $addClient = array();
        $addClient['firstname'] = $unserializedData['username'];
        $addClient['lastname'] = $unserializedData['username'];
        $addClient['email'] = $unserializedData['username'] . "@" . $_SERVER['HTTP_HOST'];
        $addClient['password2'] = $unserializedData['username'];
        $addClient['noemail'] = true;
        $addClient['skipvalidation'] = true;

        $AddClientResult = XtremeDashboard_Ajax_AddClient($addClient);

        if (isset($AddClientResult['result']) && $AddClientResult['result'] == "success") {
            if (isset($_POST['affid']) && !empty($_POST['affid'])) {
                Capsule::table('mod_xtreamAffs_clients')
                    ->insert(array(
                        'affiliatesid' => $_POST['affid'],
                        'clientid' => $AddClientResult['clientid']
                    ));
                $resellerdata = XtremeDashboard_getClientByAffID($_POST['affid']);
                if (isset($resellerdata) && !empty($resellerdata) && is_array($resellerdata)) {
                    $customfieldid = XtremeDashboard_getCustomFieldId("Reseller");
                    XtremeDashboard_insertCustomFieldsValues($customfieldid, $AddClientResult['clientid'], $resellerdata['firstname'] . " " . $resellerdata['lastname'] . " (" . $resellerdata['email'] . ")");
                }
            }
            $addOrder['clientid'] = $AddClientResult['clientid'];
            $addOrder['pid'][0] = $pid;
            $addOrder['noinvoiceemail'] = true;
            $addOrder['noemail'] = true;
            $PaymentGateways = XtremeDashboard_Ajax_PaymentGateway();
            $paymentGateway = $PaymentGateways['paymentmethods']['paymentmethod'][0]['module'];
            $addOrder['paymentmethod'] = $paymentGateway;
            $AddOrderResult = XtremeDashboard_Ajax_AddOrder($addOrder);
            if (isset($AddOrderResult['result']) && $AddOrderResult['result'] == "success") {

                $command = 'GetPaymentMethods';
                $postData = array();
                $results = localAPI($command, $postData);
                if ($results['totalresults'] > 0) {
                    $module = $results['paymentmethods']['paymentmethod']['module'];
                    $invoiceid = $AddOrderResult['invoiceid'];
                    //Change Status to Paid
                    Capsule::table('tblinvoices')->where('id', $invoiceid)->update(['status' => 'Paid', 'paymentmethod' => $module]);
                }

                Capsule::table('tblhosting')->where('id', $AddOrderResult['serviceids'])->update(['notes' => $admimnotes,]);
                $updateService = array();
                $updateService['serviceid'] = $AddOrderResult['productids'];
                $updateService['serviceusername'] = $unserializedData['username'];
                $updateService['servicepassword'] = $unserializedData['password'];
                $updateService['nextduedate'] = !empty($unserializedData['exp_date']) ? date('Y-m-d', $unserializedData['exp_date']) : "";
                $updateService['status'] = "Active";
                XtremeDashboard_Ajax_UpdateClientProduct($updateService);
                echo "Success";
            } else {
                echo "Failed";
            }
        } else {
            echo "Failed";
        }
    } else {
        echo "AlreadyImported";
    }
}
