<?php

use WHMCS\View\Menu\Item as MenuItem;
use Illuminate\Database\Capsule\Manager as Capsule;

/* -------------------------------------------------Creating Credits Menu-------------------------------------------------------------- */

function hook_viewcredits_usage_menu(MenuItem $secondaryNavbar) {
    global $smarty;
    $clientid = $smarty->get_template_vars('loggedin');
    if ($clientid) {
        $abc = $secondaryNavbar->getChild("Account");
        $abc->addChild(
                Lang::trans('CreditsHistoryMenu'), array(
            'name' => 'Home',
            'label' => Lang::trans('CreditsHistoryMenu'),
            'uri' => 'credits.php',
            'order' => 50,
                )
        );
    }
}

/* ------------------------------------------------------Fetching Credits Details---------------------------------------------------------------- */

function hook_viewcredits_usage() {
    global $smarty;
    if ($_SESSION['uid']) {
        $hook_getCreditBalance = hook_getCreditBalance();
        $smarty->assign('creditDetails', $hook_getCreditBalance['creditDetails']);
        $smarty->assign('totalcredits', $hook_getCreditBalance['totalcredits']);
    }
}

/* --------------------------------------------------------Changing Object to Array ------------------------------------------------------------- */

function objectToArray($object) {
    if (!is_object($object) && !is_array($object)) {
        return $object;
    }
    if (is_object($object)) {
        $object = get_object_vars($object);
    }
    return array_map('objectToArray', $object);
}

function hook_getCreditBalance() {
    $clientid = $_SESSION['uid'];
    $rows = Capsule::table('tblcredit')->where('clientid', '=', $clientid)->orderBy('date', 'desc')->get(array('date', 'description', 'amount'));
    $total = 0;
    $data = array();
    foreach ($rows as $key => $row) {
        $data[] = array('date' => fromMySQLDate($row->date, false, true), 'amount' => formatCurrency($row->amount), 'description' => $row->description);
        $total += $row->amount;
    }
    return array("creditDetails" => $data, "totalcredits" => formatCurrency($total));
} 

function clientareasecondary($secondarySidebar) {
    // determine if we are on a page containing Billing
    if (!is_null($secondarySidebar->getChild('Billing'))) {
        $secondarySidebar->getChild('Billing')->removeChild('Quotes');
        $secondarySidebar->getChild('Billing')->addChild(
                'My Credit History', array(
            'uri' => 'credits.php',
            'order' => 10,
                )
        );
    }
}

function clientareaprimary($primarySidebar) {
    if (isset($_SESSION['uid']) && !empty($_SESSION['uid'])) {
        $hook_getCreditBalance = hook_getCreditBalance();
        $primarySidebar->addChild('Credits History', array(
            'label' => 'Credit Balance',
            'uri' => '#',
            'order' => '1',
            'icon' => 'fa-money'
        ));


        $primarySidebar->getChild('Credits History')
                ->setBodyHtml(
                        '<center>Your current credit balance<br><b style="font-size:20px;">' . $hook_getCreditBalance['totalcredits'] . '</b></center>'
                )
                ->setFooterHtml(
                        '<a href="credits.php" class="btn btn-success btn-sm btn-block">
        View Credit History
    </a>'
        );
    }
}

?>