<?php

namespace WHMCS\Module\Addon\AddonModule\Admin;

use WHMCS\Database\Capsule;

/**
 * Xtream Code Admin Area Controller
 */
class Controller {

    /**
     * Index action.
     *
     * @param array $vars Module configuration parameters
     *
     * @return string
     */
    public function index($vars) { 
        if (isset($_POST['save_changes'])) {
            $result = 'success';
            if ($_POST['passwordformat'] == 'static') {
                if (empty($_POST['staticPassword'])) {
                    $response['status'] = 'error';
                    $response['msg'] = 'For Static/Same Password Please enter the password!';
                    $result = 'error';
                }
            }
            if ($result == 'success') {
                unset($_POST['token'], $_POST['save_changes']);
                foreach ($_POST as $name => $value) {
                    $data[] = array('setting' => $name, 'value' => trim($value));
                }
                Capsule::table('mod_xtreamConfig')->delete();
                try {
                    Capsule::table('mod_xtreamConfig')->insert($data);
                    # Deleting existing Data before inserting new data because values shouldn't be repeated. 
                    $response['status'] = 'success';
                    $response['msg'] = 'Saved Successfully!';
                } catch (\Exception $e) {
                    $response['status'] = 'error';
                    $response['msg'] = 'A problem has been occurred while submitting your data.';
                    $response['sql_err'] = mysql_error();
                }
            }
        }
        $config = Capsule::table('mod_xtreamConfig')->get();
        foreach ($config as $value) {
            $row[$value->setting] = $value->value;
        }
        $tblproductgroups = Capsule::table('tblproductgroups')->get();
        $reselleroption = '';
        $reselleroption .= '<option value="">Select Group</option>';
        foreach ($tblproductgroups as $groups) {
            $reselleroption .= '<option ' . (($row['rid'] == $groups->id) ? 'selected' : '') . ' value="' . $groups->id . '">' . $groups->name . '</option>';
        }
        $option = '';
        $option .= '<option value="">Select Group</option>';
        foreach ($tblproductgroups as $groups) {
            $option .= '<option ' . (($row['srid'] == $groups->id) ? 'selected' : '') . ' value="' . $groups->id . '">' . $groups->name . '</option>';
        }
        if (isset($response) && !empty($response)) {
            if ($response['status'] == 'success') {
                ?><div class="alert alert-success fade in">
                    <a href="#" class="close" data-dismiss="alert">&times;</a>
                    <strong>Success!</strong> <?php echo $response['msg']; ?>
                </div>
            <?php } elseif ($response['status'] == 'error') {
                ?> 
                <div class="alert alert-danger fade in">
                    <a href="#" class="close" data-dismiss="alert">&times;</a>
                    <strong>Error!</strong> <?php echo $response['msg']; ?>
                </div>
                <?php
            }
        }



        return ' 
  <script>
            $(document).ready(function () {
                $("#eventcommonidentifier").click(function (e) {
                    e.preventDefault();
                    if ($(this).data("currentstatus") == 1)
                    {
                        $(this).data("currentstatus", 2);
                        $("#input_common_identifier").attr("readonly", false);
                        $("#faiconlock").removeClass("fa-lock");
                        $("#faiconlock").addClass("fa-unlock");
                    } else
                    {
                        $(this).data("currentstatus", 1);
                        $("#input_common_identifier").attr("readonly", true);
                        $("#faiconlock").removeClass("fa-unlock");
                        $("#faiconlock").addClass("fa-lock");
                    }
                });
                var activation_code=jQuery("input[name=activationcode]:checked").val();
                if(activation_code=="off"){
                jQuery(\'.activationcode\').show(); 
                jQuery(\'.activationcodedigits\').hide();
                }else{
                jQuery(\'.activationcodedigits\').show();
                jQuery(\'.activationcode\').hide();
                }
                 var passwordformat=jQuery("input[name=passwordformat]:checked").val();
                 if(passwordformat=="static"){
                jQuery(\'#showstaticfield\').show();}
            });
        </script>
        <style>
        .psw_custom {
 margin-top: -10px;
}
        .format_custom {
 position: relative;
 left: 150px;
 top: 4px;
 display: flex;
}
.sub_formta_custom {
 position: relative;
 top: 5px;
 left: 10px;
}
.radio_custom {
 float: left;
} 
        </style>
<form method="POST">
<h2>Common Identifier</h2>
<div style="width:100%;">  
            <table class="form" width="100%" border="0" cellspacing="2" cellpadding="3">  
                <tbody> 
                    <tr><td style="width: 25%;" class="fieldlabel">Common Identifier</td><td class="fieldarea"><input id="input_common_identifier" class="form-control input-200"  type="text" name="common_identifier" value="' . (isset($row['common_identifier']) ? $row['common_identifier'] : '') . '" readonly style="float: left; margin-right: 10px;"><a style="float: left;" id="eventcommonidentifier" data-currentstatus="1" href=""><i id="faiconlock" class="fa fa-lock" aria-hidden="true" style="display: block;padding-bottom: 10px;position: relative;font-size: 26px;top: 4px;"></i></a><br><i style="padding-top: 18px;display: block;">it\'s linking variable between billng panel and xtream codes. It needs to change only if you are using our more than one billing panel with the single xtream codes</i></td></tr>

                    <tr>
                        <td style="width: 25%;" class="fieldlabel">Hostname/PortalUrl</td>
                        <td><input id="input_portalurl" class="form-control input-200"  type="text" name="portalurl" value="' . (isset($row['portalurl']) ? $row['portalurl'] : '') . '" style="float: left; margin-right: 10px;"></td>
                    </tr>
                </tbody>
            </table> 
        </div>
<h2>Custom Fields</h2>
<h3>- Our system has setup with the default values you might need to change only if you make changes in our default system otherwise it don\'t need to change settings anymore  </h3>
    <div style="width:100%;">  
            <table class="form" width="100%" border="0" cellspacing="2" cellpadding="3">  
                <tbody> 
                    <tr><td style="width: 25%;" class="fieldlabel">Custom Field MAG Device</td><td class="fieldarea"><input class="form-control input-200"  type="text" name="custom_field_mag" value="' . (isset($row['custom_field_mag']) ? $row['custom_field_mag'] : '') . '"> <i>Enter the same name of customer field that created for product for inputting MAC Address from end-users while ordering</i></td></tr>
                    <tr><td style="width: 25%;" class="fieldlabel">Custom Field Check MAG Device</td><td class="fieldarea"><input class="form-control input-400"  type="text" name="checkmagdevice" value="' . (isset($row['checkmagdevice']) ? $row['checkmagdevice'] : '') . '"> <span><i>Enter the same name of customer field that created for product under ‘custom fields’ tab</i></span></td></tr>
                    <tr><td style="width: 25%;" class="fieldlabel">Custom Field Enigma2 Device</td><td class="fieldarea"><input class="form-control input-200"  type="text" name="custom_field_eng" value="' . (isset($row['custom_field_eng']) ? $row['custom_field_eng'] : '') . '"><i>Enter the same name of customer field that created for product under ‘custom fields’ tab</i></td></tr>
                    <tr><td style="width: 25%;" class="fieldlabel">Custom Field Check Enigma2 Device</td><td class="fieldarea"><input class="form-control input-400"  type="text" name="checkengdevice" value="' . (isset($row['checkengdevice']) ? $row['checkengdevice'] : '') . '"> <span><i>Enter the same name of customer field that created for product under ‘custom fields’ tab</i></span></td></tr>
                    <tr><td style="width: 25%;" class="fieldlabel">Configurable Option Field Name</td><td class="fieldarea"><input class="form-control input-200"  type="text" name="configoption_field_name" value="' . (isset($row['configoption_field_name']) ? $row['configoption_field_name'] : '') . '"> <span>(Enter the configurable option name if you change the name of this configurable option for Extra Connections)</span></td></tr>
                </tbody>
            </table> 
        </div>
        <h2>Settings</h2>
<h3>- Our system has setup with the default values you might need to change only if you make changes in our default system otherwise it don\'t need to change settings anymore  </h3>
    <div style="width:100%;">  
            <table class="form" width="100%" border="0" cellspacing="2" cellpadding="3">  
                <tbody>
                    <tr>
                        <td style="width: 25%;" class="fieldlabel">If there is any time difference you can add here.</td>
                        <td class="fieldarea">
                            <input type="number" name="HourDiff" min="-12" max="" value="' . $row['HourDiff'] . '"> Hour(s)
                        </td>
                    </tr>
                    <tr><td style="width: 25%;" class="fieldlabel">Do you want to sync Credit to X.C Panel?</td><td class="fieldarea"><label class="checkbox-inline"><input name="syncredit" ' . (isset($row['syncredit']) && ($row['syncredit'] == 'on') ? 'checked=checked' : '') . ' type="checkbox"> It will maintain credits balance in both sides ( Billing Portal and Xtream Codes )</label></td></tr>
                    <tr><td style="width: 25%;" class="fieldlabel">Apply Reseller Credits</td><td class="fieldarea"><label class="checkbox-inline"><input name="creditapply" ' . (isset($row['creditapply']) && ($row['creditapply'] == 'on') ? 'checked=checked' : '') . ' type="checkbox"> Tick to use reseller Credits for the client registered by the reseller</label></td></tr>
                    <tr><td style="width: 25%;" class="fieldlabel">Parent Password</td><td class="fieldarea"><input class="form-control input-400" name="parentpassword" value="' . $row['parentpassword'] . '" type="text"> Parent Password for the MAG Device</td></tr>
                    <tr><td style="width: 25%;" class="fieldlabel">Remove Credits</td><td class="fieldarea"><label class="checkbox-inline"><input name="removecredits" ' . (isset($row['removecredits']) && ($row['removecredits'] == 'on') ? 'checked=checked' : '') . ' type="checkbox"> Tick to use Remove Reseller Credits on Automatically on <b>Cancel Order</b> from both panel (billing panel and Xtream codes Panel)</label></td></tr>
                </tbody>
            </table> 
        </div> 
<h2 style="margin-top:15px;">Success & Error Messages</h2>
<h3> - It\'s success & error messages text that shows when we save something or remove something. So, here you can change the text and use your language as well</h3>
<div style="width:100%;">  
            <table class="form" width="100%" border="0" cellspacing="2" cellpadding="3">  
                <tbody>
                    <tr><td style="width: 25%;" class="fieldlabel">Mac Not Valid</td><td class="fieldarea"><input class="form-control input-400"  type="text" name="mac_not_valid" value="' . (isset($row['mac_not_valid']) ? $row['mac_not_valid'] : '') . '"></label></td></tr>
                    <tr><td style="width: 25%;" class="fieldlabel">Mac Change Success</td><td class="fieldarea"><input class="form-control input-400"  type="text" name="mac_change_success" value="' . (isset($row['mac_change_success']) ? $row['mac_change_success'] : '') . '"></label></td></tr>
                    <tr><td style="width: 25%;" class="fieldlabel">Mac Add Success</td><td class="fieldarea"><input class="form-control input-400"  type="text" name="mac_add_success" value="' . (isset($row['mac_add_success']) ? $row['mac_add_success'] : '') . '"></label></td></tr>
                    <tr><td style="width: 25%;" class="fieldlabel">Mac Error</td><td class="fieldarea"><input class="form-control input-400"  type="text" name="mac_error" value="' . (isset($row['mac_error']) ? $row['mac_error'] : '') . '"></label></td></tr>
                </tbody>
            </table> 
</div>
           
   <h2 style="margin-top:15px;">Buttons & Links</h2>
<div style="width:100%;">  
            <table class="form" width="100%" border="0" cellspacing="2" cellpadding="3">  
                <tbody>
                    <tr><td style="width: 25%;" class="fieldlabel">Iptv Service Details</td><td class="fieldarea"><input class="form-control input-200"  type="text" name="iptv_service_details" value="' . (isset($row['iptv_service_details']) ? $row['iptv_service_details'] : '') . '"></label>  </td></tr>
                    <tr><td style="width: 25%;" class="fieldlabel">Devices</td><td class="fieldarea"><input class="form-control input-200"  type="text" name="devices" value="' . (isset($row['devices']) ? $row['devices'] : '') . '"></label>  </td></tr>
                    <tr><td style="width: 25%;" class="fieldlabel">Back to overview</td><td class="fieldarea"><input class="form-control input-200"  type="text" name="back_to_overview" value="' . (isset($row['back_to_overview']) ? $row['back_to_overview'] : '') . '"></label>  </td></tr>
                </tbody>
             </table> 
        </div>
        <h2 style="margin-top:15px;">Service Details Page</h2>
<div style="width:100%;">  
            <table class="form" width="100%" border="0" cellspacing="2" cellpadding="3">  
                <tbody>
                    <tr><td style="width: 25%;" class="fieldlabel">Product/Service</td><td class="fieldarea"><input class="form-control input-200"  type="text" name="product_service" value="' . (isset($row['product_service']) ? $row['product_service'] : '') . '"></label>  </td></tr>
                    <tr><td style="width: 25%;" class="fieldlabel">Username</td><td class="fieldarea"><input class="form-control input-200"  type="text" name="username" value="' . (isset($row['username']) ? $row['username'] : '') . '"></label>  </td></tr>
                    <tr><td style="width: 25%;" class="fieldlabel">Password</td><td class="fieldarea"><input class="form-control input-200"  type="text" name="password" value="' . (isset($row['password']) ? $row['password'] : '') . '"></label>  </td></tr>
                    <tr><td style="width: 25%;" class="fieldlabel">M3U Playlist</td><td class="fieldarea"><input class="form-control input-200"  type="text" name="playlist" value="' . (isset($row['playlist']) ? $row['playlist'] : '') . '"></label>  </td></tr>
 <tr><td style="width: 25%;" class="fieldlabel">MAG Portal</td><td class="fieldarea"><input class="form-control input-200"  type="text" name="mag_portal" value="' . (isset($row['mag_portal']) ? $row['mag_portal'] : '') . '"></label>  </td></tr>
             </tbody></table> 
        </div>
        <h2 style="margin-top:15px;">Permission to Reseller</h2>
<div style="width:100%;">  
            <table class="form" width="100%" border="0" cellspacing="2" cellpadding="3">  
                <tbody>
                    <tr><td style="width: 25%;" class="fieldlabel">Reseller</td>
                    <td class="fieldarea">
<label class="checkbox-inline"><input type="checkbox" name="reseller_susp" ' . (isset($row['reseller_susp']) && ($row['reseller_susp'] == 'on') ? 'checked="checked"' : '') . '> Tick to enable - Suspend Account </label><label class="checkbox-inline"><input type="checkbox" name="reseller_unsusp" ' . (isset($row['reseller_unsusp']) && ($row['reseller_unsusp'] == 'on') ? 'checked="checked"' : '') . '> Tick to enable - Unsuspend Account </label><label class="checkbox-inline"><input type="checkbox" name="reseller_term" ' . (isset($row['reseller_term']) && ($row['reseller_term'] == 'on') ? 'checked="checked"' : '') . '> Tick to enable - Terminate Account</label><label class="checkbox-inline"><input type="checkbox" name="reseller_remove" ' . (isset($row['reseller_remove']) && ($row['reseller_remove'] == 'on') ? 'checked="checked"' : '') . '> Tick to enable - Remove Service</label></td>
    </tr>
                    <tr><td style="width: 25%;" class="fieldlabel">Super Reseller</td><td class="fieldarea">
<label class="checkbox-inline"><input type="checkbox" name="supreseller_susp" ' . (isset($row['supreseller_susp']) && ($row['supreseller_susp'] == 'on') ? 'checked="checked"' : '') . '> Tick to enable - Suspend Account </label><label class="checkbox-inline"><input type="checkbox" name="supreseller_unsusp" ' . (isset($row['supreseller_unsusp']) && ($row['supreseller_unsusp'] == 'on') ? 'checked="checked"' : '') . '> Tick to enable - Unsuspend Account </label><label class="checkbox-inline"><input type="checkbox" name="supreseller_term" ' . (isset($row['supreseller_term']) && ($row['supreseller_term'] == 'on') ? 'checked="checked"' : '') . '> Tick to enable - Terminate Account</label><label class="checkbox-inline"><input type="checkbox" name="supreseller_remove" ' . (isset($row['supreseller_remove']) && ($row['supreseller_remove'] == 'on') ? 'checked="checked"' : '') . '> Tick to enable - Remove Service</label></td>
   </tr></tbody></table> 
        </div>
        <h2 style="margin-top:15px;">Auto-Generation Settings</h2>
<div style="width:100%;">  
            <table class="form" width="100%" border="0" cellspacing="2" cellpadding="3">  
                <tbody> 
                 <tr><td style="width: 5%;" class="fieldlabel"><input onclick="jQuery(\'.activationcode\').show(1000);jQuery(\'.activationcodedigits\').hide(500);"  name="activationcode" ' . (isset($row['activationcode']) && ($row['activationcode'] == 'off') ? 'checked="checked"' : '') . ' value="off" type="radio"></td><td colspan="2" class="fieldarea"><b>Random Username/ Password Format</b> - While creating streamline, our system generates random username and password if customer leaves it blank. So, generated format should be as below type </td></tr>
                    <tr class="activationcode" style="display:none;"><td style="width: 5%;"></td><td style="width: 25%;" class="fieldlabel">Username Format </td><td class="fieldarea">
                     <div class="radio_custom">  <input type="radio" name="usernameformat" ' . (isset($row['usernameformat']) && ($row['usernameformat'] == 'onlydigits') ? 'checked="checked"' : '') . ' value="onlydigits"> Only Digits<br>
  <input type="radio" name="usernameformat" value="digits_alphabet" ' . (isset($row['usernameformat']) && ($row['usernameformat'] == 'digits_alphabet') ? 'checked="checked"' : '') . '> Digit + Alphabet</div>
      <span class="format_custom"><input name="usernamedigits" class="form-control input-100" value="' . (isset($row['usernamedigits']) ? $row['usernamedigits'] : '') . '" type="text"><span class="sub_formta_custom">(Number of  Only Digits Default 10 )</span> </span>
  </td></tr> <tr class="activationcode" style="display:none;"><td style="width: 5%;"></td><td style="width: 25%;" class="fieldlabel">Password Format </td><td class="fieldarea">
                     <input type="radio" onclick="jQuery(\'#showstaticfield\').hide(500);" name="passwordformat" ' . (isset($row['passwordformat']) && ($row['passwordformat'] == 'onlydigits') ? 'checked="checked"' : '') . ' value="onlydigits"> Only Digits <br>
  <div class="radio_custom">  <input type="radio" name="passwordformat" onclick="jQuery(\'#showstaticfield\').hide(500);" value="digits_alphabet" ' . (isset($row['passwordformat']) && ($row['passwordformat'] == 'digits_alphabet') ? 'checked="checked"' : '') . ' > Digit + Alphabet </div>
      <div class="format_custom" style="top: -15px;"><input type="text" name="passworddigits" class="form-control input-100" value="' . (isset($row['passworddigits']) ? $row['passworddigits'] : '') . '"><span class="sub_formta_custom">(Number of  Only Digits Default 10 )</span> </div>
      <div class="psw_custom" style="margin-top: -10px;">  <input type="radio" name="passwordformat" onclick="jQuery(\'#showstaticfield\').show(1000);" value="static" ' . (isset($row['passwordformat']) && ($row['passwordformat'] == 'static') ? 'checked="checked"' : '') . ' > Static/Same Password for every streaming line created<br><div id="showstaticfield" style="display:none;"><input type="text" name="staticPassword" class="form-control input-200"  value="' . (isset($row['staticPassword']) ? $row['staticPassword'] : '') . '"> <b>Enter Password here</b> </div></div>
  </td>
  </tr>                  
  <tr>
  <td style="width: 5%;" class="fieldlabel"><input onclick="jQuery(\'.activationcode\').hide(500);jQuery(\'.activationcodedigits\').show(1000);" name="activationcode" ' . (isset($row['activationcode']) && ($row['activationcode'] == 'on') ? 'checked="checked"' : '') . ' value="on" type="radio"></td><td class="fieldarea" colspan="2" ><b>Select this option if you want to generate activation code instead of username and password (Most used  in the case of Android APP)</b>
      </td> 
      </tr><tr class="activationcodedigits" style="display:none;"><td style="width: 5%;"></td><td style="width: 25%;" class="fieldlabel">Enter the Number of Digits </td><td class="fieldarea">
                     <input class="form-control input-150" style="float: left;" name="activationdigits" value=' . (isset($row['activationdigits']) && !empty($row['activationdigits']) ? '"' . $row['activationdigits'] . '"' : '""') . ' type="text"><span style="float: left;margin-top: 5px;margin-left: 10px;">( By default 8 digits)</span>
   
  </td></tr>
  <tr>
    <td style="width: 5%;" class="fieldlabel">
        <input type="checkbox" name="CreateResellerUserNameRandom" ' . (isset($row['CreateResellerUserNameRandom']) && ($row['CreateResellerUserNameRandom'] == 'on') ? 'checked="checked"' : '') . '>
        </td>
        <td class="fieldarea" colspan="2" >
            <b>Select this option if you want to generate random username for Reseller/Super-Reseller.</b>
        </td>
  </tr>

                     </tbody></table> 
        </div>
        <h2 style="margin-top:15px;">Other Setting</h2>
<div style="width:100%;">  
            <table class="form" width="100%" border="0" cellspacing="2" cellpadding="3">  
                <tbody>
                    <tr><td style="width: 34%;" class="fieldlabel">Select TopUp Group (Reseller Credits Group)</td><td class="fieldarea"> <select name="rid" class="form-control select-inline"> 
' . $reselleroption . '                    
</select></td></tr> 
<tr><td style="width: 34%;" class="fieldlabel">Select TopUp Group (Super-Reseller Credits Group)</td><td class="fieldarea"> <select name="srid" class="form-control select-inline"> 
' . $option . '                    
</select></td></tr> 
                     </tbody></table> 
        </div>
         <h2 style="margin-top:15px;">Devices Page</h2>
<div style="width:100%;">  
            <table class="form" width="100%" border="0" cellspacing="2" cellpadding="3">  
                <tbody>
                    <tr><td style="width: 25%;" class="fieldlabel">Devices Desc</td><td class="fieldarea"><input class="form-control input-200"  type="text" name="devices_desc" value="' . (isset($row['devices_desc']) ? $row['devices_desc'] : '') . '"></label>  </td></tr>
                    <tr><td style="width: 25%;" class="fieldlabel">Enigma2 Desc</td><td class="fieldarea"><input class="form-control input-200"  type="text" name="enigma2_devices" value="' . (isset($row['enigma2_devices']) ? $row['enigma2_devices'] : '') . '"></label>  </td></tr>
                    <tr><td style="width: 25%;" class="fieldlabel">Mag Desc</td><td class="fieldarea"><input class="form-control input-200"  type="text" name="mag_desc" value="' . (isset($row['mag_desc']) ? $row['mag_desc'] : '') . '"></label>  </td></tr>
                    <tr><td style="width: 25%;" class="fieldlabel">Current Device</td><td class="fieldarea"><input class="form-control input-200"  type="text" name="current_mag" value="' . (isset($row['current_mag']) ? $row['current_mag'] : '') . '"></label>  </td></tr>
                    <tr><td style="width: 25%;" class="fieldlabel">New Device</td><td class="fieldarea"><input class="form-control input-200"  type="text" name="new_mag" value="' . (isset($row['new_mag']) ? $row['new_mag'] : '') . '"></label>  </td></tr>
                    <tr><td style="width: 25%;" class="fieldlabel">Change Mag Button</td><td class="fieldarea"><input class="form-control input-200"  type="text" name="change_mag_button" value="' . (isset($row['change_mag_button']) ? $row['change_mag_button'] : '') . '"></label>  </td></tr>
                    <tr><td style="width: 25%;" class="fieldlabel">Add Mag Button</td><td class="fieldarea"><input class="form-control input-200"  type="text" name="add_mag_button" value="' . (isset($row['add_mag_button']) ? $row['add_mag_button'] : '') . '"></label>  </td></tr>
                    <tr><td style="width: 25%;" class="fieldlabel">Other Devices Desc</td><td class="fieldarea"><input class="form-control input-200"  type="text" name="other_devices" value="' . (isset($row['other_devices']) ? $row['other_devices'] : '') . '"></label>  </td></tr>
                    <tr><td style="width: 25%;" class="fieldlabel">Autoscripts</td><td class="fieldarea"><input class="form-control input-200"  type="text" name="autoscripts" value="' . (isset($row['autoscripts']) ? $row['autoscripts'] : '') . '"></label>  </td></tr>
                    <tr><td style="width: 25%;" class="fieldlabel">Stream Output</td><td class="fieldarea"><input class="form-control input-200"  type="text" name="stream_output" value="' . (isset($row['stream_output']) ? $row['stream_output'] : '') . '"></label>  </td></tr>
                    <tr><td style="width: 25%;" class="fieldlabel">Dropdown Name</td><td class="fieldarea"><input class="form-control input-200"  type="text" name="dropdown_name" value="' . (isset($row['dropdown_name']) ? $row['dropdown_name'] : '') . '"></label>  </td></tr>
                    <tr><td style="width: 25%;" class="fieldlabel">Choose Device</td><td class="fieldarea"><input class="form-control input-200"  type="text" name="dropdown_action" value="' . (isset($row['dropdown_action']) ? $row['dropdown_action'] : '') . '"></label>  </td></tr>

             </tbody></table> 
        </div>
          
     <div style="width:100%;">  <tr><td colspan="4"><center><input type="submit" name="save_changes" class="btn btn-primary" value="Save Changes"></center></td></tr>
        </tbody>
    </table>  </div>
</form>';
    }

    /**
     * Show action.
     *
     * @param array $vars Module configuration parameters
     *
     * @return string
     */
    public function configuration($vars) {
        // Get common module parameters
        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
        $version = $vars['version']; // eg. 1.0

        if (isset($_GET['page']) && $_GET['page'] == 'reseller') {
            if (isset($_POST['save_changes'])) {
                unset($_POST['token'], $_POST['save_changes']);
                foreach ($_POST as $name => $value) {
                    $data[] = array('setting' => $name, 'value' => $value);
                }
                Capsule::table('mod_xtreamresellersetting')->delete();
                if (isset($data) && !empty($data)) {
                    try {
                        Capsule::table('mod_xtreamresellersetting')->insert($data);
                        # Deleting existing Data before inserting new data because values shouldn't be repeated. 
                        $response['status'] = 'success';
                        $response['msg'] = 'Saved Successfully!';
                    } catch (\Exception $e) {
                        $response['status'] = 'error';
                        $response['msg'] = 'A problem has been occurred while submitting your data. ';
                        $response['sql_err'] = mysql_error();
                    }
                } else {
                    $response['status'] = 'success';
                    $response['msg'] = 'Saved Successfully!';
                }
            }
            $config = Capsule::table('mod_xtreamresellersetting')->get();
            foreach ($config as $value) {
                $row[$value->setting] = $value->value;
            }
            if (isset($response) && !empty($response)) {
                if ($response['status'] == 'success') {
                    ?><div class="alert alert-success fade in">
                        <a href="#" class="close" data-dismiss="alert">&times;</a>
                        <strong>Success!</strong> <?php echo $response['msg']; ?>
                    </div>
                <?php } elseif ($response['status'] == 'error') {
                    ?> 
                    <div class="alert alert-danger fade in">
                        <a href="#" class="close" data-dismiss="alert">&times;</a>
                        <strong>Error!</strong>  <?php echo $response['msg']; ?>
                    </div>
                    <?php
                }
            }
            return '
<style>  
.page-item > * {
    border: none;
}

.custom-checkbox {
  min-height: 1rem;
  padding-left: 0;
  margin-right: 0;
  cursor: pointer; 
}
  .custom-checkbox .custom-control-indicator {
    content: "";
    display: inline-block;
    position: relative;
    width: 30px;
    height: 10px;
    background-color: #818181;
    border-radius: 15px;
    margin-right: 10px;
    -webkit-transition: background .3s ease;
    transition: background .3s ease;
    vertical-align: middle;
    margin: 0 16px;
    box-shadow: none; 
  }
    .custom-checkbox .custom-control-indicator:after {
      content: "";
      position: absolute;
      display: inline-block;
      width: 18px;
      height: 18px;
      background-color: #f1f1f1;
      border-radius: 21px;
      box-shadow: 0 1px 3px 1px rgba(0, 0, 0, 0.4);
      left: -2px;
      top: -4px;
      -webkit-transition: left .3s ease, background .3s ease, box-shadow .1s ease;
      transition: left .3s ease, background .3s ease, box-shadow .1s ease; 
    }
  .custom-checkbox .custom-control-input:checked ~ .custom-control-indicator {
    background-color: #84c7c1;
    background-image: none;
    box-shadow: none !important; 
  }
    .custom-checkbox .custom-control-input:checked ~ .custom-control-indicator:after {
      background-color: #84c7c1;
      left: 15px; 
    }
  .custom-checkbox .custom-control-input:focus ~ .custom-control-indicator {
    box-shadow: none !important; 
  }
        .custom-control-input {
         display:none;   
   }
        </style>
<h2> Reseller Configuration</h2>
Tick any of the fields below to make them options for Super-reseller while adding a Reseller<br><br>
<form method="POST">  
    <table class="form" width="100%" border="0" cellspacing="2" cellpadding="3">
        <tbody> 
            <tr><td style="width: 20%;" class="fieldlabel">Client Name</td>
                <td class="fieldarea">
                                <label class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="clientname" ' . (($row['clientname'] == 'on') ? "checked=checked" : '') . '>
                                    <span class="custom-control-indicator"></span>
                                </label>
                            </td>
                <td style="width: 20%;" class="fieldlabel">Company Name</td>
                <td class="fieldarea">
                                <label class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="companyname" ' . (($row['companyname'] == 'on') ? "checked=checked" : '') . '>
                                    <span class="custom-control-indicator"></span>
                                </label>
                            </td>
            </tr> 
            <tr><td style="width: 20%;" class="fieldlabel">Login</td>
                <td class="fieldarea">
                                <label class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="login" ' . (($row['login'] == 'on') ? "checked=checked" : '') . '>
                                    <span class="custom-control-indicator"></span>
                                </label>
                            </td>
                <td style="width: 20%;" class="fieldlabel">City</td><td class="fieldarea">
                                <label class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="city" ' . (($row['city'] == 'on') ? "checked=checked" : '') . '>
                                    <span class="custom-control-indicator"></span>
                                </label>
                            </td>
            </tr>

            <tr><td style="width: 20%;" class="fieldlabel">Password</td>
                <td class="fieldarea">
                                <label class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="password" ' . (($row['password'] == 'on') ? "checked=checked" : '') . '>
                                    <span class="custom-control-indicator"></span>
                                </label>
                            </td>
                <td style="width: 20%;" class="fieldlabel">Country</td>
                <td class="fieldarea">
                                <label class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="country" ' . (($row['country'] == 'on') ? "checked=checked" : '') . '>
                                    <span class="custom-control-indicator"></span>
                                </label>
                            </td>
            </tr>
            <tr><td style="width: 20%;" class="fieldlabel">Confirm Password</td>
                <td class="fieldarea">
                                <label class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="confirmpassword" ' . (($row['confirmpassword'] == 'on') ? "checked=checked" : '') . '>
                                    <span class="custom-control-indicator"></span>
                                </label>
                            </td><td style="width: 20%;" class="fieldlabel">Address 1</td>
                                <td class="fieldarea">
                                <label class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="address1" ' . (($row['address1'] == 'on') ? "checked=checked" : '') . '>
                                    <span class="custom-control-indicator"></span>
                                </label>
                            </td> 
            </tr>

            <tr><td style="width: 20%;" class="fieldlabel">State/Region</td><td class="fieldarea">
                                <label class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="state" ' . (($row['state'] == 'on') ? "checked=checked" : '') . '>
                                    <span class="custom-control-indicator"></span>
                                </label>
                            </td><td style="width: 20%;" class="fieldlabel">Address 2</td><td class="fieldarea">
                                <label class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="address2" ' . (($row['address2'] == 'on') ? "checked=checked" : '') . '>
                                    <span class="custom-control-indicator"></span>
                                </label>
                            </td>
            </tr> 
            <tr> 
                <td style="width: 20%;" class="fieldlabel">Add Credit</td><td class="fieldarea">
                                <label class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="addcredit" ' . (($row['addcredit'] == 'on') ? "checked=checked" : '') . '>
                                    <span class="custom-control-indicator"></span>
                                </label>
                            </td>  <td style="width: 20%;" class="fieldlabel">Postcode</td><td class="fieldarea">
                                <label class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="postcode" ' . (($row['postcode'] == 'on') ? "checked=checked" : '') . '>
                                    <span class="custom-control-indicator"></span>
                                </label>
                            </td>
            </tr> 
            <tr> 
                <td style="width: 20%;" class="fieldlabel">Phone Number</td><td class="fieldarea">
                                <label class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="phonenumber" ' . (($row['phonenumber'] == 'on') ? "checked=checked" : '') . '>
                                    <span class="custom-control-indicator"></span>
                                </label>
                            </td> <td style="width: 20%;" class="fieldlabel">Promo code</td><td class="fieldarea">
                                <label class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="promocode" ' . (($row['promocode'] == 'on') ? "checked=checked" : '') . '>
                                    <span class="custom-control-indicator"></span>
                                </label>
                            </td>
            </tr> 
        </tbody>
    </table>
<center><input type="submit" name="save_changes" class="btn btn-primary" value="Save Changes"></center>
</form>  
<p>
    <a href=' . $modulelink . ' class="btn btn-info">
        <i class="fa fa-arrow-left"></i>
        Back to home
    </a>
</p>

';
        } else {
            if (isset($_POST['save_changes'])) {
                unset($_POST['token'], $_POST['save_changes']);
                foreach ($_POST as $name => $value) {
                    $data[] = array('setting' => $name, 'value' => $value);
                }
                Capsule::table('mod_xtreamsetting')->delete();
                if (isset($data) && !empty($data)) {
                    try {
                        Capsule::table('mod_xtreamsetting')->insert($data);
                        # Deleting existing Data before inserting new data because values shouldn't be repeated. 
                        $response['status'] = 'success';
                        $response['msg'] = 'Saved Successfully!';
                    } catch (\Exception $e) {
                        $response['status'] = 'error';
                        $response['msg'] = 'A problem has been occurred while submitting your data.';
                        $response['sql_err'] = mysql_error();
                    }
                } else {
                    $response['status'] = 'success';
                    $response['msg'] = 'Saved Successfully!';
                }
            }
            $config = Capsule::table('mod_xtreamsetting')->get();
            foreach ($config as $value) {
                $row[$value->setting] = $value->value;
            }
            if (isset($response) && !empty($response)) {
                if ($response['status'] == 'success') {
                    ?><div class="alert alert-success fade in">
                        <a href="#" class="close" data-dismiss="alert">&times;</a>
                        <strong>Success!</strong> <?php echo $response['msg']; ?>
                    </div>
                <?php } elseif ($response['status'] == 'error') {
                    ?> 
                    <div class="alert alert-danger fade in">
                        <a href="#" class="close" data-dismiss="alert">&times;</a>
                        <strong>Error!</strong> <?php echo $response['msg']; ?>
                    </div>
                    <?php
                }
            }
            return '
<style>  
.page-item > * {
    border: none;
}

.custom-checkbox {
  min-height: 1rem;
  padding-left: 0;
  margin-right: 0;
  cursor: pointer; 
}
  .custom-checkbox .custom-control-indicator {
    content: "";
    display: inline-block;
    position: relative;
    width: 30px;
    height: 10px;
    background-color: #818181;
    border-radius: 15px;
    margin-right: 10px;
    -webkit-transition: background .3s ease;
    transition: background .3s ease;
    vertical-align: middle;
    margin: 0 16px;
    box-shadow: none; 
  }
    .custom-checkbox .custom-control-indicator:after {
      content: "";
      position: absolute;
      display: inline-block;
      width: 18px;
      height: 18px;
      background-color: #f1f1f1;
      border-radius: 21px;
      box-shadow: 0 1px 3px 1px rgba(0, 0, 0, 0.4);
      left: -2px;
      top: -4px;
      -webkit-transition: left .3s ease, background .3s ease, box-shadow .1s ease;
      transition: left .3s ease, background .3s ease, box-shadow .1s ease; 
    }
  .custom-checkbox .custom-control-input:checked ~ .custom-control-indicator {
    background-color: #84c7c1;
    background-image: none;
    box-shadow: none !important; 
  }
    .custom-checkbox .custom-control-input:checked ~ .custom-control-indicator:after {
      background-color: #84c7c1;
      left: 15px; 
    }
  .custom-checkbox .custom-control-input:focus ~ .custom-control-indicator {
    box-shadow: none !important; 
  }
        .custom-control-input {
         display:none;   
   }
        </style>
<h2>User Configuration</h2>
Tick any of the fields below to make them options for Reseller while adding a user<br><br>
<form method="POST">  
    <table class="form" width="100%" border="0" cellspacing="2" cellpadding="3">
        <tbody> 
            <tr><td style="width: 20%;" class="fieldlabel">Client Name</td>
                <td class="fieldarea">
                                <label class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="clientname" ' . (($row['clientname'] == 'on') ? "checked=checked" : '') . '>
                                    <span class="custom-control-indicator"></span>
                                </label>
                            </td>
                <td style="width: 20%;" class="fieldlabel">Company Name</td>
                <td class="fieldarea">
                                <label class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="companyname" ' . (($row['companyname'] == 'on') ? "checked=checked" : '') . '>
                                    <span class="custom-control-indicator"></span>
                                </label>
                            </td>
            </tr> 
            <tr><td style="width: 20%;" class="fieldlabel">Login</td>
                <td class="fieldarea">
                                <label class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="login" ' . (($row['login'] == 'on') ? "checked=checked" : '') . '>
                                    <span class="custom-control-indicator"></span>
                                </label>
                            </td>
                <td style="width: 20%;" class="fieldlabel">City</td><td class="fieldarea">
                                <label class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="city" ' . (($row['city'] == 'on') ? "checked=checked" : '') . '>
                                    <span class="custom-control-indicator"></span>
                                </label>
                            </td>
            </tr>

            <tr><td style="width: 20%;" class="fieldlabel">Password</td>
                <td class="fieldarea">
                                <label class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="password" ' . (($row['password'] == 'on') ? "checked=checked" : '') . '>
                                    <span class="custom-control-indicator"></span>
                                </label>
                            </td>
                <td style="width: 20%;" class="fieldlabel">Country</td>
                <td class="fieldarea">
                                <label class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="country" ' . (($row['country'] == 'on') ? "checked=checked" : '') . '>
                                    <span class="custom-control-indicator"></span>
                                </label>
                            </td>
            </tr>
            <tr><td style="width: 20%;" class="fieldlabel">Confirm Password</td>
                <td class="fieldarea">
                                <label class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="confirmpassword" ' . (($row['confirmpassword'] == 'on') ? "checked=checked" : '') . '>
                                    <span class="custom-control-indicator"></span>
                                </label>
                            </td><td style="width: 20%;" class="fieldlabel">Address 1</td>
                                <td class="fieldarea">
                                <label class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="address1" ' . (($row['address1'] == 'on') ? "checked=checked" : '') . '>
                                    <span class="custom-control-indicator"></span>
                                </label>
                            </td> 
            </tr>

            <tr><td style="width: 20%;" class="fieldlabel">State/Region</td><td class="fieldarea">
                                <label class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="state" ' . (($row['state'] == 'on') ? "checked=checked" : '') . '>
                                    <span class="custom-control-indicator"></span>
                                </label>
                            </td><td style="width: 20%;" class="fieldlabel">Address 2</td><td class="fieldarea">
                                <label class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="address2" ' . (($row['address2'] == 'on') ? "checked=checked" : '') . '>
                                    <span class="custom-control-indicator"></span>
                                </label>
                            </td>
            </tr> 
            <tr> 
                <td style="width: 20%;" class="fieldlabel">Add Credit</td><td class="fieldarea">
                                <label class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="addcredit" ' . (($row['addcredit'] == 'on') ? "checked=checked" : '') . '>
                                    <span class="custom-control-indicator"></span>
                                </label>
                            </td>  <td style="width: 20%;" class="fieldlabel">Postcode</td><td class="fieldarea">
                                <label class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="postcode" ' . (($row['postcode'] == 'on') ? "checked=checked" : '') . '>
                                    <span class="custom-control-indicator"></span>
                                </label>
                            </td>
            </tr> 
            <tr> 
                <td style="width: 20%;" class="fieldlabel">Phone Number</td><td class="fieldarea">
                                <label class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="phonenumber" ' . (($row['phonenumber'] == 'on') ? "checked=checked" : '') . '>
                                    <span class="custom-control-indicator"></span>
                                </label>
                            </td> <td style="width: 20%;" class="fieldlabel">Promo code</td><td class="fieldarea">
                                <label class="custom-control custom-checkbox">
                                    <input type="checkbox" class="custom-control-input" name="promocode" ' . (($row['promocode'] == 'on') ? "checked=checked" : '') . '>
                                    <span class="custom-control-indicator"></span>
                                </label>
                            </td>
            </tr> 
        </tbody>
    </table>
<center><input type="submit" name="save_changes" class="btn btn-primary" value="Save Changes"></center>
</form>  
<p>
    <a href=' . $modulelink . ' class="btn btn-info">
        <i class="fa fa-arrow-left"></i>
        Back to home
    </a>
</p>

';
        }
    }

    public function reseller($vars) {
        if (isset($_GET['page']) && $_GET['page'] == 'resellergrp') {
            include_once 'XtreamResellerGrp.php';
        } else {
            include_once 'XtreamReseller.php';
        }
    }

    public function managereseller($vars) {
        include_once 'XtreamResellerManage.php';
    }

    public function manageresellergrp($vars) {
        $clientgrop = Capsule::table('tblclientgroups')->where('id', '=', $_GET['id'])->get();
        if ($clientgrop[0]->groupname == 'Super-Reseller') {
            include_once 'XtreamSupperResellerManageGrp.php';
        } elseif ($clientgrop[0]->groupname == 'Reseller') {
            include_once 'XtreamResellerManageGrp.php';
        }
    }

    public function managesuperresellergrp($vars) {
        include_once 'XtreamResellerManageGrp.php';
    }

    public function managesuperresellergrpuser($vars) {
        include_once 'XtreamResellerManageGrpuser.php';
    }

    public function superreseller($vars) {
        include_once 'XtreamSuperReseller.php';
    }

    public function supermanagereseller($vars) {
        include_once 'XtreamSuperResellerManage.php';
    }

    public function import($vars) {
        if (isset($_GET['page']) && $_GET['page'] == 'import_stream_line') {
            include_once 'XtreamImportStreamLine.php';
        } elseif (isset($_GET['page']) && $_GET['page'] == 'import_channels') {
            include_once 'XtreamImportchannels.php';
        } elseif (isset($_GET['page']) && $_GET['page'] == 'import_sub_reseller') {
            include_once 'XtreamImportSubReseller.php';
        } else {
            include_once 'XtreamImportReseller.php';
        }
    }

    public function logs() {
        include_once 'logs.php';
    }

    public function XtreamDashboard_TestConnection() {
        $serverscount = Capsule::table('tblservers')
                ->where('tblservers.type', '=', 'ownervpncombination')
                ->select('tblservers.*')
                ->count();
        if (isset($serverscount) && !empty($serverscount)) {
            $servers = Capsule::table('tblservers')
                    ->where('tblservers.type', '=', 'ownervpncombination')
                    ->select('tblservers.*')
                    ->get();
            foreach ($servers as $server) {
                $sqlusername = $server->username;
                $sqlpassword = decrypt($server->password);
                $sqldbname = $server->accesshash;
                $sqlhost = $server->ipaddress;
                list($sqldbname, $sqlport) = explode(':', $sqldbname);
                if (isset($sqlport) && !empty($sqlport))
                    $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname, $sqlport);
                else
                    $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname);
            }
            if (!$con) {
                $result = array("status" => "error");
            } else {
                $result = array("status" => "success", "link" => $con);
            }
            return $result;
        }
    }

    public function XtremeDashboard_GetResellers($ids) {
        $testConnectionResult = self::XtreamDashboard_TestConnection();
        if ($testConnectionResult['status'] == "success") {
            $result = mysqli_query($testConnectionResult['link'], "SELECT username,email,member_group_id,credits,id FROM members WHERE member_group_id IN ($ids)");
 
            if (!$result) {
                $radiussqlerror = mysqli_error($testConnectionResult['link']);
                mysqli_close($testConnectionResult['link']);
                self::XtreamDashboard_WHMCSReconnect();
                return array("status" => "error", "msg" => $radiussqlerror);
            }
            $data = array();
            if (mysqli_num_rows($result) > 0) {
                while ($resellerdata = mysqli_fetch_assoc($result)) {
                    $data[] = $resellerdata;
                }
            } 
            return array("status" => "success", "data" => $data);
        }
    }

    public function XtremeDashboard_TotalUsers($memberid) {
        $testConnectionResult = self::XtreamDashboard_TestConnection();
        $totalCount = "0";
        if ($testConnectionResult['status'] == "success") {
            $streamline_total_query = mysqli_query($testConnectionResult['link'], "SELECT COUNT(id) as total FROM users WHERE member_id='$memberid'");
            if (mysqli_num_rows($streamline_total_query) > 0) {
                $streamsDataTotal = mysqli_fetch_assoc($streamline_total_query);
                $totalCount = $streamsDataTotal['total'];
            }
        }
        return $totalCount;
    }

    public function XtremeDashboard_ChannelsCategories() {
        $testConnectionResult = self::XtreamDashboard_TestConnection();
        if ($testConnectionResult['status'] == "success") {
            $result = mysqli_query($testConnectionResult['link'], "SELECT * FROM stream_categories");

            if (!$result) {
                $radiussqlerror = mysqli_error($testConnectionResult['link']);
                mysqli_close($testConnectionResult['link']);
                self::XtreamDashboard_WHMCSReconnect();
                return array("status" => "error", "msg" => $radiussqlerror);
            }
            $data = array();
            if (mysqli_num_rows($result) > 0) {
                while ($resellerdata = mysqli_fetch_assoc($result)) {
                    $data[] = $resellerdata;
                }
            }
            return array("status" => "success", "data" => $data);
        }
    }

    public function XtremeDashboard_ChannelsList($ids) {
        $testConnectionResult = self::XtreamDashboard_TestConnection();
        if ($testConnectionResult['status'] == "success") {
            $Channelsresult = mysqli_query($testConnectionResult['link'], "SELECT * FROM streams WHERE category_id IN ($ids)");

            if (!$Channelsresult) {
                $radiussqlerror = mysqli_error($testConnectionResult['link']);
                mysqli_close($testConnectionResult['link']);
                self::XtreamDashboard_WHMCSReconnect();
                return array("status" => "error", "msg" => $radiussqlerror);
            }
            $data = array();
            if (mysqli_num_rows($Channelsresult) > 0) {
                while ($resellerdata = mysqli_fetch_assoc($Channelsresult)) {
                    $data[] = $resellerdata;
                }
            }
            return array("status" => "success", "data" => $data);
        }
    }

    public function XtreamDashboard_WHMCSReconnect() {
        require( ROOTDIR . "/configuration.php" );
        $whmcsmysql = mysqli_connect($db_host, $db_username, $db_password, $db_name);
    }

    public function XtremeDashboard_CheckWHMCSUser($ResellerUser) {
        self::XtreamDashboard_WHMCSReconnect();
        $clientdata = Capsule::table('tblclients')->where('email', '=', $ResellerUser['email'])->count(array('id'));
        if($clientdata == 0){ 
            return array($ResellerUser);
        }
    }

    public function XtremeDashboard_AdminDetails() {
        $result_admin = Capsule::table('tbladmins')->where('roleid', '=', '1')->get();
        $adminUsername = $result_admin[0]->username;
        return $adminUsername;
    }

    public function XtremeDashboard_GetProducts() {
        $adminUser = self::XtremeDashboard_AdminDetails();
        $result = localAPI("GetProducts", "", $adminUser);
        return $result;
    }

    public function XtremeDashboard_GetMemberGroups() {
        $testConnectionResult = self::XtreamDashboard_TestConnection();
        if ($testConnectionResult['status'] == "success") {
            $result = mysqli_query($testConnectionResult['link'], "SELECT group_id,group_name FROM groups");
            if (!$result) {
                $radiussqlerror = mysqli_error($testConnectionResult['link']);
                mysqli_close($testConnectionResult['link']);
                self::XtreamDashboard_WHMCSReconnect();
                return array("status" => "error", "msg" => $radiussqlerror);
            }
            $data = array();
            if (mysqli_num_rows($result) > 0) {
                while ($member_groups = mysqli_fetch_assoc($result)) {
                    $data[] = $member_groups;
                }
            }
            return array("status" => "success", "data" => $data);
        }
    }

    public function XtremeDashboard_GetStreamLines($type, $member_id, $usernameToSearch = "") {
        $testConnectionResult = self::XtreamDashboard_TestConnection();
        if ($testConnectionResult['status'] == "success") {
            if ($type == "streamline") {
                if (!empty($member_id)) {
                    $streamline_query = mysqli_query($testConnectionResult['link'], "SELECT pair_id FROM users WHERE is_mag='0' AND is_e2='0' AND member_id='$member_id' AND pair_id IS NOT NULL");
                } else {
                    $streamline_query = mysqli_query($testConnectionResult['link'], "SELECT pair_id FROM users WHERE is_mag='0' AND is_e2='0' AND pair_id IS NOT NULL");
                }
                $data = array();
                if (mysqli_num_rows($streamline_query) > 0) {
                    while ($streamsdata = mysqli_fetch_assoc($streamline_query)) {
                        if (!empty($member_id)) {
                            $streamline_query2 = mysqli_query($testConnectionResult['link'], "SELECT username,exp_date,password FROM users WHERE id='" . $streamsdata['pair_id'] . "' AND member_id='$member_id' AND is_mag='1' AND is_e2='0' AND pair_id IS NOT NULL");
                        } else {
                            $streamline_query2 = mysqli_query($testConnectionResult['link'], "SELECT username,exp_date,password FROM users WHERE id='" . $streamsdata['pair_id'] . "' AND is_mag='1' AND is_e2='0' AND pair_id IS NOT NULL");
                        }
                        $result = $streamline_query2;
                        $streamsdata1 = mysqli_fetch_assoc($streamline_query2);
                        if (!empty($streamsdata1)) {
                            $data[] = $streamsdata1;
                        }
                    }
                }
            }
            if ($type == "streamlineeng") {
                if (!empty($member_id)) {
                    $streamline_query = mysqli_query($testConnectionResult['link'], "SELECT pair_id FROM users WHERE is_mag='0' AND is_e2='0' AND member_id='$member_id' AND pair_id IS NOT NULL");
                } else {
                    $streamline_query = mysqli_query($testConnectionResult['link'], "SELECT pair_id FROM users WHERE is_mag='0' AND is_e2='0' AND pair_id IS NOT NULL");
                }
                $data = array();
                $result = $streamline_query;
                if (mysqli_num_rows($streamline_query) > 0) {
                    while ($streamsdata = mysqli_fetch_assoc($streamline_query)) {
                        if (!empty($member_id)) {
                            $result = $streamline_query2 = mysqli_query($testConnectionResult['link'], "SELECT username,exp_date,password FROM users WHERE id='" . $streamsdata['pair_id'] . "' AND is_mag='0' AND is_e2='1' AND member_id='$member_id' AND pair_id IS NOT NULL");
                        } else {
                            $result = $streamline_query2 = mysqli_query($testConnectionResult['link'], "SELECT username,exp_date,password FROM users WHERE id='" . $streamsdata['pair_id'] . "' AND is_mag='0' AND is_e2='1' AND pair_id IS NOT NULL");
                        }
                        $streamsdata1 = mysqli_fetch_assoc($streamline_query2);
                        if (!empty($streamsdata1)) {
                            $data[] = $streamsdata1;
                        }
                    }
                }
            }
            if ($type == "streamlineonly") {
                if (!empty($member_id)) {
                    $streamline_query = mysqli_query($testConnectionResult['link'], "SELECT username,exp_date,password,admin_notes FROM users WHERE is_mag='0' AND is_e2='0' AND member_id = '$member_id' AND pair_id IS NULL AND username LIKE '%$usernameToSearch%'");
                } else {
                    $streamline_query = mysqli_query($testConnectionResult['link'], "SELECT username,exp_date,password,admin_notes FROM users WHERE is_mag='0' AND is_e2='0' AND pair_id IS NULL AND username LIKE '%$usernameToSearch%'");
                }
                $data = array();
                $result = $streamline_query;
                if (mysqli_num_rows($streamline_query) > 0) {
                    while ($streamsdata = mysqli_fetch_assoc($streamline_query)) {
                        $data[] = $streamsdata;
                    }
                }
            }
            if ($type == "magdevice") {
                if (!empty($member_id)) {
                    $streamline_query = mysqli_query($testConnectionResult['link'], "SELECT username,exp_date,password FROM users WHERE is_mag='1' AND is_e2='0' AND member_id = '$member_id' AND pair_id IS NULL");
                } else {
                    $streamline_query = mysqli_query($testConnectionResult['link'], "SELECT username,exp_date,password FROM users WHERE is_mag='1' AND is_e2='0' AND pair_id IS NULL");
                }
                $data = array();
                $result = $streamline_query;
                if (mysqli_num_rows($streamline_query) > 0) {
                    while ($streamsdata = mysqli_fetch_assoc($streamline_query)) {
                        $data[] = $streamsdata;
                    }
                }
            }
            if ($type == "engdevice") {
                if (!empty($member_id)) {
                    $streamline_query = mysqli_query($testConnectionResult['link'], "SELECT username,exp_date,password FROM users WHERE is_mag='0' AND is_e2='1' AND member_id = '$member_id' AND pair_id IS NULL");
                } else {
                    $streamline_query = mysqli_query($testConnectionResult['link'], "SELECT username,exp_date,password FROM users WHERE is_mag='0' AND is_e2='1' AND pair_id IS NULL");
                }
                $result = $streamline_query;
                $data = array();
                if (mysqli_num_rows($streamline_query) > 0) {
                    while ($streamsdata = mysqli_fetch_assoc($streamline_query)) {
                        $data[] = $streamsdata;
                    }
                }
            }
            return array("status" => "success", "data" => $data, "totalrecords" => mysqli_num_rows($result));
        }
    }

    public function XtremeDashboard_CheckWHMCSUserStream($StreamUser) {
        self::XtreamDashboard_WHMCSReconnect();
        $clientdata = Capsule::table('tblclients')->where('email', '=', $StreamUser['username'] . "@" . $_SERVER['HTTP_HOST'])->count();
        if ($clientdata == 0) {
            return array($StreamUser);
        }
    }

    public function XtremeDashboard_getSubResellers($id) {
        $testConnectionResult = self::XtreamDashboard_TestConnection();
        if ($testConnectionResult['status'] == "success") {
            $result = mysqli_query($testConnectionResult['link'], "SELECT username,email,member_group_id,credits,id FROM members WHERE owner_id = $id");

            if (!$result) {
                $radiussqlerror = mysqli_error($testConnectionResult['link']);
                mysqli_close($testConnectionResult['link']);
                self::XtreamDashboard_WHMCSReconnect();
                return array("status" => "error", "msg" => $radiussqlerror);
            }
            $data = array();
            if (mysqli_num_rows($result) > 0) {
                while ($resellerdata = mysqli_fetch_assoc($result)) {
                    $data[] = $resellerdata;
                }
            }
            return array("status" => "success", "data" => $data);
        }
    }

    public function XtremdoLogin($vars) {
        include_once 'customvalues.php';
    }

    public function Xtreamautoscript($vars) {
        include_once 'AutoScript.php';
    }

    public function resellersinfo() {
        include_once 'XtreamResellersInfo.php';
    }

    public function superresellersinfo() {
        include_once 'XtreamSuperResellersInfo.php';
    }

}
