<?php

namespace WHMCS\Module\Addon\AddonModule\Client;

use WHMCS\Database\Capsule;

/**
 * Sample Client Area Dispatch Handler
 */
class ClientDispatcher {

    /**
     * Dispatch request.
     *
     * @param string $action
     * @param array $parameters
     *
     * @return array
     */
    public function dispatch($action, $parameters, $zip) {
        if (empty($_SESSION['xtreamuserid'])) {
            $_SESSION['xtreamuserid'] = $_SESSION['uid'];
            $_SESSION['xtreampasswordhash'] = $_SESSION['upw'];
        }

        if ($_SESSION['xtreamuserid'] != $_SESSION['uid']) {
            $GetUserGruopType = Capsule::table('tblclients')
                    ->join('tblclientgroups', 'tblclients.groupid', '=', 'tblclientgroups.id')
                    ->where('tblclients.id', $_SESSION['uid'])
                    ->select('tblclientgroups.groupname')
                    ->get();
            if (!empty($GetUserGruopType)) {
                $_SESSION['xtreamuserid'] = $_SESSION['uid'];
                $_SESSION['xtreampasswordhash'] = $_SESSION['upw'];
            }
        }

        if (!$action) {
            // Default to index if no action specified
            $action = 'index';
        }
        $controller = new Controller();
        // Verify requested action is valid and callable
        if (is_callable(array($controller, $action))) {
            $parameters['zip'] = $zip;  
            return $controller->$action($parameters);
        }
    }

}
