<?php

use WHMCS\Database\Capsule;

global $CONFIG;

if (file_exists(ROOTDIR . "/modules/addons/AutoBackupV2/lib/Admin/function.php")) {
  include_once(ROOTDIR . "/modules/addons/AutoBackupV2/lib/Admin/function.php");
} else {
  echo 'Please verify that functions file exists';
}
$clients_id = Capsule::table('tbladdonmodules')
  ->select('value')
  ->where('module', '=', 'AutoBackupV2')
  ->where('setting', '=', 'DropboxKey')
  ->get();

$client_id = (isset($clients_id[0]->value) && !empty($clients_id[0]->value)) ? $clients_id[0]->value : "";

$redirect_uri = $CONFIG['SystemURL'] . "/modules/addons/AutoBackupV2/response.php";

if (isset($_POST['save_changes'])) {
  if (isset($_POST['dropbox_key']) && !empty($_POST['dropbox_key'])) {
    // echo "<pre>";
    // print_r($_POST);die();
    Capsule::table('tbladdonmodules')
      ->where('module', '=', 'AutoBackupV2')
      ->where('setting', '=', 'AB_Mode')
      ->delete();
    Capsule::table('tbladdonmodules')
      ->where('module', '=', 'AutoBackupV2')
      ->where('setting', '=', 'keeplastbackups')
      ->delete();
    Capsule::table('tbladdonmodules')
      ->where('module', '=', 'AutoBackupV2')
      ->where('setting', '=', 'set_hours')
      ->delete();
    $db_ins_mode = Capsule::table('tbladdonmodules')->insert([
      'module' => 'AutoBackupV2',
      'setting' => 'AB_Mode',
      'value' => $_POST["ab_mode"]
    ]);
    $keeplastbackups_query = Capsule::table('tbladdonmodules')->insert([
      'module' => 'AutoBackupV2',
      'setting' => 'keeplastbackups',
      'value' => $_POST["keeplastbackups"]
    ]);
    $set_hours_query = Capsule::table('tbladdonmodules')->insert([
      'module' => 'AutoBackupV2',
      'setting' => 'set_hours',
      'value' => $_POST["set_hours"]
    ]);


    $dropbox_key = $_POST['dropbox_key'];
    // echo $dropbox_key;die();
    if ($dropbox_key == $client_id) {
      Capsule::table('tbladdonmodules')
        ->where('module', '=', 'AutoBackupV2')
        ->where('setting', '=', 'DropboxKey')
        ->delete();
      $db_ins_appkey = Capsule::table('tbladdonmodules')->insert([
        'module' => 'AutoBackupV2',
        'setting' => 'DropboxKey',
        'value' => $dropbox_key,
      ]);
      Capsule::table('tbladdonmodules')
        ->where('module', '=', 'AutoBackupV2')
        ->where('setting', '=', 'secretKey')
        ->delete();
      Capsule::table('tbladdonmodules')->insert([
        'module' => 'AutoBackupV2',
        'setting' => 'secretKey',
        'value' => $_POST['secret_key'],
      ]);
    } else {
      Capsule::table('tbladdonmodules')
        ->where([
          ['module', '=', 'AutoBackupV2'],
          ['setting', '=', 'DropboxKey'],
        ])
        ->delete();
      Capsule::table('tbladdonmodules')
        ->where([
          ['module', '=', 'AutoBackupV2'],
          ['setting', '=', 'access_token'],
        ])
        ->delete();
      $db_ins_appkey = Capsule::table('tbladdonmodules')->insert([
        'module' => 'AutoBackupV2',
        'setting' => 'DropboxKey',
        'value' => $dropbox_key,
      ]);
      Capsule::table('tbladdonmodules')
        ->where('module', '=', 'AutoBackupV2')
        ->where('setting', '=', 'secretKey')
        ->delete();
      Capsule::table('tbladdonmodules')->insert([
        'module' => 'AutoBackupV2',
        'setting' => 'secretKey',
        'value' => $_POST['secret_key'],
      ]);
    }
  } else {
    echo "Please Enter Dropbox App Key!!";
  }
}
?>
<script type="text/javascript">
  setTimeout(function() {

    // Closing the alert 
    $('.settalert').alert('close');
  }, 3000);
</script>
<?php


$clientapp_id = Capsule::table('tbladdonmodules')
  ->select('value')
  ->where('module', '=', 'AutoBackupV2')
  ->where('setting', '=', 'DropboxKey')
  ->get();
$clientApp_id = $clientapp_id[0]->value;

$clientapp_id = Capsule::table('tbladdonmodules')
  ->select('value')
  ->where('module', '=', 'AutoBackupV2')
  ->where('setting', '=', 'secretKey')
  ->get();
$secretKey = $clientapp_id[0]->value;

$AllconfigData = array();
$GetAllConfig = Capsule::table('tbladdonmodules')
  ->where('module', '=', 'AutoBackupV2')
  ->count();
if ($GetAllConfig > 0) {
  $GetAllConfig = Capsule::table('tbladdonmodules')
    ->where('module', '=', 'AutoBackupV2')
    ->get();
  foreach ($GetAllConfig as $datais) {
    $AllconfigData[$datais->setting] = $datais->value;
  }
}

$access_token = (isset($AllconfigData["access_token"]) && !empty($AllconfigData["access_token"])) ? $AllconfigData["access_token"] : "";
$ab_mode = (isset($AllconfigData["AB_Mode"]) && !empty($AllconfigData["AB_Mode"])) ? $AllconfigData["AB_Mode"] : "daily";
$set_hoursGt = (isset($AllconfigData["set_hours"]) && !empty($AllconfigData["set_hours"])) ? $AllconfigData["set_hours"] : "1";
$KeepLastBackUp = (isset($AllconfigData["keeplastbackups"]) && !empty($AllconfigData["keeplastbackups"])) ? $AllconfigData["keeplastbackups"] : "10";


if (isset($_SERVER['HTTPS'])) {
  if (strpos($redirect_uri, "http://") !== false) {
    $redirect_uri = preg_replace("/^http:/i", "https:", $redirect_uri);
  }

  $url = "https://www.dropbox.com/oauth2/authorize?response_type=code&client_id=" . $client_id . "&token_access_type=offline&redirect_uri=$redirect_uri";
  if (isset($_POST['connect_dropbox'])) {
    header('location:' . $url);
  }
  $bearer_code = $access_token;
  $CheckConnection = check_connection_still_enable($bearer_code);
  //echo $CheckConnection; die();  
  if ($CheckConnection) {
?><br />
    <div class="alert alert-success alert-dismissable">
      <strong> Your are connected to Dropbox.
      </strong>
    </div>
  <?php
  } else {
  ?><br />
    <div class="alert alert-danger alert-dismissable">
      <!-- <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a> -->
      <strong>Your are not connected to Dropbox!</strong> 
    </div>
  <?php
  }
  ?>

  <div class="form_set">
    <form method="POST" class="form-horizontal" id="contact-form">
      <table class="form" action="addonmodules.php?module=AutoBackup&page=configuration" border="0" cellpadding="3" cellspacing="2" width="100%" style="margin-top: 1%">
        <tbody>
          <tr>
            <td class="fieldlabel"><b>Dropbox App Key:</b></td>
            <td class="fieldarea">
              <input type="text" name="dropbox_key" value="<?php echo $clientApp_id; ?>" id="dropbox_key" placeholder="Dropbox App Key "><br /> Click <a target="_blank" href="https://www.whmcssmarters.com/clients/index.php?rp=/knowledgebase/29/AutoBackup-WHMCS--Setup-Guide-.html">here</a> to see how we can get an App key
            </td>
          </tr>
          <tr>
            <td class="fieldlabel"><b>Dropbox Secret Key:</b></td>
            <td class="fieldarea">
              <input type="text" name="secret_key" value="<?php echo $secretKey; ?>" id="dropbox_key" placeholder="Dropbox Secret Key "><br /> Click <a target="_blank" href="https://www.whmcssmarters.com/clients/index.php?rp=/knowledgebase/29/AutoBackup-WHMCS--Setup-Guide-.html">here</a> to see how we can get an Secret key
            </td>
          </tr>
          <tr>
            <td class="fieldlabel" width="20%"><b>Redirect URL:</b></td>
            <td class="fieldarea">
              <input type="text" class="redirect_uri" value="<?php echo $redirect_uri ?>" placeholder="" disabled=""><br />Copy redirect url given below and paste in dropbox app settings.
            </td>
          </tr>
          <tr>
            <td class="fieldlabel" width="20%">Auto Backup Mode</td>
            <td class="fieldarea">
              <label class="radio-inline">
                <input class="ab_mode_cl" type="radio" name="ab_mode" checked="<?php echo $select = ($ab_mode == "daily") ? "checked" : "" ?>" value="daily">&nbsp;Daily
              </label>
              <label class="radio-inline">
                <input class="ab_mode_cl" type="radio" name="ab_mode" <?php echo $select = ($ab_mode == "weekly") ? "checked" : "" ?> value="weekly">&nbsp;&nbsp;Weekly
              </label>
              <label class="radio-inline">
                <input class="ab_mode_cl" type="radio" name="ab_mode" <?php echo $select = ($ab_mode == "monthly") ? "checked" : "" ?> value="monthly">&nbsp;&nbsp;Monthly
              </label>
            </td>
          </tr>
          <tr class="showondaily">
            <td class="fieldlabel" width="20%"></td>
            <td class="fieldarea">
              <label class="radio-inline">
                Set Hours
                &nbsp;
                <select name="set_hours" class="set_hours">
                  <?php
                  for ($xhr = 1; $xhr <= 24; $xhr++) {
                  ?>
                    <option value="<?php echo $xhr; ?>" <?php
                                                        if (isset($set_hoursGt) && $set_hoursGt == $xhr) {
                                                          echo 'selected="selected"';
                                                        }
                                                        ?>>
                      <?php echo $xhr; ?></option>
                  <?php
                  }
                  ?>
                </select>
              </label>

            </td>
          </tr>
          <tr>
            <td class="fieldlabel" width="20%"></td>
            <td class="fieldarea">
              <label class="radio-inline">
                Keep only last
                &nbsp;
                <select name="keeplastbackups">
                  <?php
                  for ($i = 1; $i <= 31; $i++) {
                  ?>
                    <option value="<?php echo $i; ?>" <?php
                                                      if (isset($KeepLastBackUp) && $KeepLastBackUp == $i) {
                                                        echo 'selected="selected"';
                                                      }
                                                      ?>>
                      <?php echo $i; ?>
                    </option>
                  <?php
                  }
                  ?>
                </select>
                &nbsp;
                number of backups
              </label>
            </td>
          </tr>
          <tr>
            <td class="fieldlabel" width="20%"><b>Cron Command:</b></td>
            <td class="fieldarea">
              <input type="text" class="input-cron" readonly value="<?php echo "php -q " . ROOTDIR . "/modules/addons/AutoBackupV2/autocron.php"; ?>" style="width:100%;" disabled>
              <!-- <small>Copy the Above Cron command and Paste in your Cpanel set cron</small> -->
            </td>
          </tr>
        </tbody>
      </table>
      <div class="btn-container">
        <?php
        if (!empty($client_id)) {
        ?>
          <button type="submit" name="save_changes" class="btn btn-primary">Save Changes</button>
          <button type="submit" name="connect_dropbox" class="btn btn-primary">Connect to Dropbox &#x2192;</button>
        <?php
        } else {
        ?>
          <button type="submit" name="save_changes" class="btn btn-primary">Save App Key</button>
        <?php
        }
        ?>
      </div>
    </form>
  </div>
  <!-- select backup database table........................................... -->
  <div class="form_set">
    <?php
    if (isset($_POST["tables"])) {
      $tosve = json_encode($_POST["tables"]);
      Capsule::table('tbladdonmodules')
        ->where([
          ['module', '=', 'AutoBackupV2'],
          ['setting', '=', 'selectedtable'],
        ])
        ->delete();
      $db_inssert = Capsule::table('tbladdonmodules')->insert([
        'module' => 'AutoBackupV2',
        'setting' => 'selectedtable',
        'value' => $tosve,
      ]);
      if ($db_inssert) {
    ?>
        <br />
        <div style="scroll-behavior: smooth;" class="alert settalert alert-success " role="alert">
          <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
          <strong>Success!</strong> Your backup tables saved successfully!
        </div>

      <?php
        // echo "Settings saved successfully";
      } else {
      ?>
        <br />
        <div class="alert settalert alert-danger" role="alert">
          <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
          <strong>Error!</strong> Please minimum one table selected!
        </div>
    <?php
      }
    }
    ?>
    <form method="POST" class="form-horizontal" id="contact-form">
      <table class="form" action="" border="0" cellpadding="3" cellspacing="2" width="100%" style="margin-top: 1%">
        <tbody>
          <tr>
            <td class="fieldlabel"><b>Select Database Tables for AutoBackup</b></td>
            <td class="fieldarea">
              <button type="button" id="getTables" class="btn btn-primary" data-toggle="modal" data-target="#myModal">
                <i class="fa fa-database" aria-hidden="true"></i> Select Tables for backup
              </button>
            </td>
          </tr>
        </tbody>
      </table>
    </form>
  </div>
<?php
} else {
?>
  <div class="alert alert-danger alert-dismissable">
    <!-- <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a> -->
    <strong>Error!</strong>
    Connection Error ! Your server must have installed SSL Certificate ( HTTPS Secure )
  </div>
<?php
}
?>
<!-- modal end -->
<style>
  .input-cron {
    background: #f8f8f8;
    border: 1px solid #ccc;
  }

  .form_set {
    width: 100%;
    text-align: center;
    margin-bottom: 10px;
  }

  #dropbox_key,
  .form_set input {
    width: 50%;
    padding: 6px 10px;
  }

  .app_key {
    padding-top: 20px;
    line-height: 30px;
  }

  .fieldarea a {
    color: blue;
    text-decoration: underline;
  }

  h1.custom-h1 {
    margin-top: 20px;
    text-align: left;
    padding-left: 15px;
    margin-bottom: 0px;
  }

  img#loaderimage {
    display: none;
    width: 10%;
    position: absolute;
    top: 132px;
    left: 0;
    right: 0;
    opacity: 0.4;
    margin: 0 auto;
  }

  img#loaderimage123 {
    display: none;
    width: 10%;
    position: absolute;
    top: 15px;
    left: 0;
    right: 0;
    opacity: 0.4;
    margin: 0 auto;
  }

  .custom-row {
    position: relative;
  }

  .redirect_uri {
    width: 100% !important;
  }

  #response_display {
    display: none;
  }

  .makehide {
    display: none;
  }

  .btn-primary {
    color: #fff;
    background-color: #424040;
    border-color: #444241;
  }

  .btn-primary:hover {
    color: #fff;
    background-color: #565352;
    border-color: #565352;
  }

  .btn-primary:active {
    color: #fff;
    background-color: #565352;
    border-color: #565352;
  }

  td.fieldarea {
    width: 54%;
  }
</style>

<!-- confirm modal-->
<div class="modal fade" id="modalforconfirm" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">
          Database Tables List
        </h4>
      </div>
      <div class="modal-body ">
        <img id="loaderimage123" src="../modules/addons/AutoBackupV2/lib/Admin/assets/img/loaderimage.gif">
        <div id="tableShow">
          <!-- <center>
                 Loading Data...
              </center> -->
        </div>
      </div>
      <div class="modal-footer tablefooter">
        <a class="btn btn-success saveselected hideonload" data-codeid="" href="#">Save Selected</a>
        <button type="button" class="btn btn-default" data-dismiss="modal">
          Cancel
        </button>
      </div>
    </div>
  </div>
</div>


<script type="text/javascript">
  $(document).ready(function() {
    $("#getTables").click(function(e) {
      e.preventDefault();
      $("#modalforconfirm").modal("show");
      $('#loaderimage123').show();
      $('#tableShow').html('');
      jQuery.ajax({
        type: "POST",
        url: "../modules/addons/AutoBackupV2/lib/Admin/db_connection.php",
        dataType: "text",
        data: {
          action: 'getconnectDBTables',
        },
        success: function(response) {
          //console.log(response);                             
          $('#tableShow').html(response);
          $('#loaderimage123').hide();
          $(".saveselected").click(function(ev) {
            ev.preventDefault();
            $("#savetableform").submit();
          });
        }
      });
    });
    if ($('.ab_mode_cl:checked').val() == "" || $('.ab_mode_cl:checked').val() == "daily") {
      $('.showondaily').removeClass('makehide');
    } else {
      $('.showondaily').addClass('makehide');
    }
    //alert($('.ab_mode_cl:checked').val());
    $('.ab_mode_cl').change(function() {
      if ($(this).val() != "daily") {
        $('.showondaily').addClass('makehide');
      } else {
        $('.showondaily').removeClass('makehide');
      }
    });

  });
</script>