<?php
require_once(dirname(__FILE__) . '/../../../../../init.php');

use WHMCS\Database\Capsule;

global $CONFIG;

// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

function findbearer_code()
{
    $count = Capsule::table('tbladdonmodules')
        ->where([
            ['module', '=', 'AutoBackupV2'],
            ['setting', '=', 'refresh_token'],
        ])
        ->count();
    if ($count > 0) {
        $getdata = Capsule::table('tbladdonmodules')->where([['module', 'AutoBackupV2']])->get();
        foreach ($getdata  as $val) {
            if ($val->setting == "refresh_token") {
                $refresh_token = $val->value;
            }
            if ($val->setting == "DropboxKey") {
                $appKey = $val->value;
            }
            if ($val->setting == "secretKey") {
                $secretKey = $val->value;
            }
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://api.dropbox.com/oauth2/token');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=refresh_token&refresh_token=$refresh_token");
        curl_setopt($ch, CURLOPT_USERPWD, $appKey . ':' . $secretKey);

        $headers = array();
        $headers[] = 'Content-Type: application/x-www-form-urlencoded';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close($ch);
        $result = json_decode($result);
        if (isset($result->access_token) && !empty($result->access_token)) {
            Capsule::table('tbladdonmodules')
                ->where('module', '=', 'AutoBackupV2')
                ->where('setting', '=', 'access_token')
                ->delete();
            Capsule::table('tbladdonmodules')->insert([
                'module' => 'AutoBackupV2',
                'setting' => 'access_token',
                'value' => $result->access_token,
            ]);
        }
    }
    $data_connection = Capsule::table('tbladdonmodules')
        ->select('value')
        ->where('setting', 'access_token')
        ->get();
    $bearer_code = $data_connection[0]->value;
    return $bearer_code;
}

function AutoBackupV2_getallconfigdata()
{
    $AllconfigData = array();
    $GetAllConfig = Capsule::table('tbladdonmodules')
        ->where('module', '=', 'AutoBackupV2')
        ->count();
    if ($GetAllConfig > 0) {
        $GetAllConfig = Capsule::table('tbladdonmodules')
            ->where('module', '=', 'AutoBackupV2')
            ->get();
        foreach ($GetAllConfig as $datais) {
            $AllconfigData[$datais->setting] = $datais->value;
        }
    }
    return $AllconfigData;
}

function check_connection_still_enable($BearerCode = "")
{
    $BearerCode = findbearer_code();
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://api.dropboxapi.com/2/users/get_current_account");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, "null");
    curl_setopt($ch, CURLOPT_POST, 1);

    $headers = array();
    $headers[] = "Authorization: Bearer $BearerCode";
    $headers[] = "Content-Type: application/json";
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);
    if (curl_errno($ch)) {
        return 'Error:' . curl_error($ch);
    }
    curl_close($ch);
    $json_decode = json_decode($result);
    $FinalArrayResult = json_decode(json_encode($json_decode), TRUE);
    if (isset($FinalArrayResult['account_id'])) {
        return true;
    } else {
        return false;
    }
}

function backup_tables($host, $user, $pass, $dbname, $tables = array())
{

    $directory_exists = ROOTDIR . "/downloads/AutoBackup-temp/";
    if (!file_exists($directory_exists)) {
        mkdir($directory_exists);
    }

    $link = mysqli_connect($host, $user, $pass, $dbname);

    // Check connection
    if (mysqli_connect_errno()) {
        return "Failed to connect to MySQL: " . mysqli_connect_error();
        exit;
    }

    mysqli_query($link, "SET NAMES 'utf8'");

    //get all of the tables
    if (empty($tables)) {
        $tables = array();
        $result = mysqli_query($link, 'SHOW TABLES');
        while ($row = mysqli_fetch_row($result)) {
            $tables[] = $row[0];
        }
    } else {
        $tables = is_array($tables) ? $tables : explode(',', $tables);
    }


    $return = '';
    //cycle through
    foreach ($tables as $table) {
        $result = mysqli_query($link, 'SELECT * FROM ' . $table);
        $num_fields = mysqli_num_fields($result);
        $num_rows = mysqli_num_rows($result);

        $return .= 'DROP TABLE IF EXISTS ' . $table . ';';
        $row2 = mysqli_fetch_row(mysqli_query($link, 'SHOW CREATE TABLE ' . $table));
        $return .= "\n\n" . $row2[1] . ";\n\n";
        $counter = 1;

        //Over tables
        for ($i = 0; $i < $num_fields; $i++) {   //Over rows
            while ($row = mysqli_fetch_row($result)) {
                if ($counter == 1) {
                    $return .= 'INSERT INTO ' . $table . ' VALUES(';
                } else {
                    $return .= '(';
                }

                //Over fields
                for ($j = 0; $j < $num_fields; $j++) {
                    $row[$j] = addslashes($row[$j]);
                    $row[$j] = str_replace("\n", "\\n", $row[$j]);
                    if (isset($row[$j])) {
                        $return .= '"' . $row[$j] . '"';
                    } else {
                        $return .= '""';
                    }
                    if ($j < ($num_fields - 1)) {
                        $return .= ',';
                    }
                }

                if ($num_rows == $counter) {
                    $return .= ");\n";
                } else {
                    $return .= "),\n";
                }
                ++$counter;
            }
        }
        $return .= "\n\n\n";
    }


    // echo "<pre>";
    // print_r($return);
    // exit;

    //save file
    $date = date("Y-m-d-H-i-s");
    $mysqlfilename = $dbname . '-' . $date;
    $fileLocation = ROOTDIR . "/downloads/AutoBackup-temp/" . $mysqlfilename . ".sql";
    $file = fopen($fileLocation, "w");

    fwrite($file, $return);
    if (fclose($file)) {
        if (file_exists($fileLocation)) {
            return $mysqlfilename . ".sql";
        } else {
            return false;
        }
    } else {
        return false;
    }
}


function selectTables()
{
    //echo "yess";die();
    $selectedTables = array();
    $getsecl = Capsule::table('tbladdonmodules')
        ->where([
            ['module', '=', 'AutoBackupV2'],
            ['setting', '=', 'selectedtable'],
        ])
        ->count();
    if ($getsecl > 0) {
        $getdata = Capsule::table('tbladdonmodules')
            ->where([
                ['module', '=', 'AutoBackupV2'],
                ['setting', '=', 'selectedtable'],
            ])
            ->get();
        $fromtbale = (isset($getdata[0]->value) && !empty($getdata[0]->value)) ? $getdata[0]->value : "";
        if ($fromtbale != "") {
            $selectedTables = json_decode($fromtbale);
        }
    }
    return $selectedTables;
    // echo "<pre>";
    //   print_r($selectedTables);die();

}



function AutoBackup2_getlastbackuptime($type = "timestamp")
{
    $returndatetime = "";
    $lbackupdate = Capsule::table('ab_externaldb')->orderBy('create_on', 'desc')->first();
    $returndatetime = $lastworkon = (isset($lbackupdate->create_on) && !empty($lbackupdate->create_on)) ? $lbackupdate->create_on : "";
    if ($type == "timestamp" && !empty($lastworkon)) {
        $returndatetime = strtotime($lastworkon);
    }
    return $returndatetime;
}


function AutoBackupV2_deleteoldbackups()
{
    $bearer_code = findbearer_code();
    $getAllConfig = AutoBackupV2_getallconfigdata();
    $keeplastbackups = (isset($getAllConfig["keeplastbackups"]) && !empty($getAllConfig["keeplastbackups"])) ? $getAllConfig["keeplastbackups"] : "10";
    $totalexistingbackup = Capsule::table('ab_externaldb')->count();
    if ($totalexistingbackup > $keeplastbackups) {
        $lbackupdate = Capsule::table('ab_externaldb')->orderBy('create_on', 'asc')->limit(1)->get();
        if (count($lbackupdate) > 0) {
            foreach ($lbackupdate as $val) {
                $selectfilename = $val->backup_file;
                $deletefileonDropbox = dropboxdelfileID($selectfilename, $bearer_code);
                Capsule::table('ab_externaldb')->where('backup_file', '=', $selectfilename)->delete();
                logModuleCall('AutoBackupV2', "Delete Files By Cron", $selectfilename, "Deleted Successfully", '', '');
                AutoBackupV2_deleteoldbackups();
            }
        } else {
            return "Complete";
        }
    } else {
        return "Complete";
    }
}

function AutoBackup2_workornotacctosettings()
{
    $return = "";
    $getAllConfig = AutoBackupV2_getallconfigdata();
    $lastbacktimestamp = AutoBackup2_getlastbackuptime();

    if ($lastbacktimestamp == "") {
        return "yes";
    }
    $AB_Mode = (isset($getAllConfig["AB_Mode"]) && !empty($getAllConfig["AB_Mode"])) ? $getAllConfig["AB_Mode"] : "daily";

    if ($AB_Mode == "daily") {
        $set_hours = (isset($getAllConfig["set_hours"]) && !empty($getAllConfig["set_hours"])) ? $getAllConfig["set_hours"] : "24";
        $Hoursdiff = AutoBackup2_GetLastBackupDiffernece($lastbacktimestamp, "hours");

        if ($Hoursdiff > $set_hours) {
            return "yes";
        }
    } elseif ($AB_Mode == "weekly") {
        $daysdiff = AutoBackup2_GetLastBackupDiffernece($lastbacktimestamp, "days");
        if ($daysdiff > 7) {
            return "yes";
        }
    } elseif ($AB_Mode == "monthly") {
        $daysdiff = AutoBackup2_GetLastBackupDiffernece($lastbacktimestamp, "days");
        if ($daysdiff >= 30) {
            return "yes";
        }
    }
}


function AutoBackup2_GetLastBackupDiffernece($lastbacktimestamp = "", $diffencetype = "hours")
{
    $reutn = "";
    if ($lastbacktimestamp != "") {
        $currentTime = time();
        if ($diffencetype == "hours") {
            $reutn = ceil(abs($currentTime - $lastbacktimestamp) / (60 * 60));
        } elseif ($diffencetype == "days") {
            $reutn = ceil(abs($currentTime - $lastbacktimestamp) / (60 * 60 * 24));
        }
    }
    return $reutn;
}



function AutoBackupV2_takefinalbackup($type = "manual")
{
    //If manaul then no need to validate time and weeksettings 
    $commonPermission = "yes";
    if ($type == "cron") {
        $cronpermission = AutoBackup2_workornotacctosettings();
        $commonPermission = (isset($cronpermission) && $cronpermission == "yes") ? "yes" : "";
    }
    if ($commonPermission == "yes") {
        logModuleCall('AutoBackupV2', "Start " . $type . " backup", date("d F Y g:i A"), date("d F Y g:i A"), '', '');
        if (file_exists(ROOTDIR . "/configuration.php")) {
            include(ROOTDIR . "/configuration.php");
        }
        $db_host = (isset($db_host) && !empty($db_host)) ? $db_host : "";
        $db_username = (isset($db_username) && !empty($db_username)) ? $db_username : "";
        $db_password = (isset($db_password) && !empty($db_password)) ? $db_password : "";
        $db_name = (isset($db_name) && !empty($db_name)) ? $db_name : "";

        if ($db_host != "" && $db_username != "" && $db_password != "" && $db_name != "") {
            $bearer_code = findbearer_code();
            $seletable = selectTables();
            $backupsqlfile = backup_tables($db_host, $db_username, $db_password, $db_name, $seletable);
            if (preg_match(strtoupper('/.sql/'), strtoupper($backupsqlfile))) {
                $uploadfileD = fileuploadDropbox($bearer_code, $backupsqlfile);
                if ($uploadfileD == "success") {
                    Capsule::table('ab_externaldb')->insert([
                        'time' =>  date("Y-m-d-H-i-s"),
                        'backup_file' => $backupsqlfile,
                        'create_on' => date("Y-m-d H:i:s"),
                    ]);
                    $FullFIlePath = ROOTDIR . "/downloads/AutoBackup-temp/" . $backupsqlfile;
                    if (!unlink($FullFIlePath)) {
                        logModuleCall('AutoBackupV2', 'deleteing file while uploading', 'error', 'Auto Backup has an Error deleting ' . $backupsqlfile . ' after manual upload', '', '');
                    }
                    AutoBackupV2_deleteoldbackups();
                    logModuleCall('AutoBackupV2', "Backup " . $type, "success", $backupsqlfile, '', '');
                    return "success";
                } else {
                    $FullFIlePath = ROOTDIR . "/downloads/AutoBackup-temp/" . $backupsqlfile;
                    if (!unlink($FullFIlePath)) {
                        logModuleCall('AutoBackupV2', 'deleteing file while uploading', 'error', 'Auto Backup has an Error deleting ' . $backupsqlfile . ' after manual upload', '', '');
                    }
                    logModuleCall('AutoBackupV2', "Backup " . $type, $uploadfileD, $uploadfileD, '', '');
                    return "Something went wrong please check logs";
                }
            } else {
                logModuleCall('AutoBackupV2', "Backup " . $type, "Unable to create SQL file Must be memory issue", "Unable to create SQL file Must be memory issue", '', '');
                return "Something went wrong please check logs";
            }
        } else {
            logModuleCall('AutoBackupV2', "Backup " . $type, "Unable to conenct with db", "Unable to conenct with db", '', '');
            return "Unable to conenct with db";
        }
    }
}

function fileuploadDropbox($bearer_code, $upload_filename)
{
    $directory_exists = ROOTDIR . "/downloads/AutoBackup-temp/";
    if (!file_exists($directory_exists)) {
        mkdir($directory_exists);
    }
    // if ($fileLocation) {
    //     echo $fileLocation;die();
    // }
    // die()
    $access_tocken = $bearer_code;

    $filename = $upload_filename;

    $ccontent = file_get_contents(ROOTDIR . '/downloads/AutoBackup-temp/' . $filename);
    //     echo "<pre>";
    //     print_r($ccontent); die();
    $YourString = $ccontent;
    $stream = fopen('php://memory', 'r+');
    fwrite($stream, $YourString);
    $dataLength = ftell($stream);
    rewind($stream);
    $ch = curl_init();
    curl_setopt_array($ch, array(
        CURLOPT_URL => "https://content.dropboxapi.com/2/files/upload",
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_HTTPHEADER => array(
            "Authorization: Bearer $access_tocken",
            "Content-Type:application/octet-stream",
            "Dropbox-API-Arg:{\"path\":\"/Backups-by Auto Backup WHMCS module/" . $filename . "\",\"mode\":{\".tag\":\"add\"},\"autorename\":true,\"mute\":false}"
        ),
        CURLOPT_INFILE => $stream,
        CURLOPT_INFILESIZE => $dataLength,
    ));
    curl_setopt($ch, CURLOPT_HEADER, 1);
    curl_setopt($ch, CURLOPT_UPLOAD, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 1);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_BINARYTRANSFER, 1);
    $curl_response_res = curl_exec($ch);
    // echo "<pre>";
    // print_r($curl_response_res);
    // exit;
    if (preg_match(strtoupper('/error_summary/'), strtoupper($curl_response_res))) {
        return $curl_response_res;
    }
    return "success";
}

function dropboxdelfileID($selectfilename, $bearer_code)
{
    $access_tocken = $bearer_code;
    //return $access_tocken; 

    //Delete file from dropbox.....................................
    $file_name = $selectfilename;
    $FullPath = 'Backups-by Auto Backup WHMCS module/' . $file_name;

    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, "https://api.dropboxapi.com/2/files/delete");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"path\":\"/" . $FullPath . "\"}");
    curl_setopt($ch, CURLOPT_POST, 1);

    $headers = array();
    $headers[] = "Authorization: Bearer $access_tocken";
    $headers[] = "Content-Type: application/json";
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);
    if (curl_errno($ch)) {
        return 'Error:' . curl_error($ch);
    }
    curl_close($ch);
    $deleteFile = json_decode($result, true);
    return $deleteFile['name'];
    //return 'success';
}



function dropboxdownlodfileID($selectfilename, $bearer_code)
{
    $access_tocken = $bearer_code;

    //get uploadfile link on dropbox................................
    $file_name = $selectfilename;
    $ch = curl_init();
    //    $file = $_POST['file'];    
    curl_setopt($ch, CURLOPT_URL, "https://api.dropboxapi.com/2/sharing/create_shared_link");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"path\":\"/Backups-by Auto Backup WHMCS module/" . $file_name . "\"}");
    curl_setopt($ch, CURLOPT_POST, 1);

    $headers = array();
    $headers[] = "Authorization: Bearer " . $access_tocken;
    $headers[] = "Content-Type: application/json";
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);
    if (curl_errno($ch)) {
        $response = 'Error:' . curl_error($ch);
    }
    // echo "<pre>";
    // print_r($result);
    // exit;
    curl_close($ch);
    //echo $result;
    $dwn_link = json_decode($result, true);
    $FinalArrayResult = json_decode(json_encode($dwn_link), TRUE);
    $OrignalUrl = $FinalArrayResult['url'];
    $EditedUrl = str_replace("?dl=0", "?dl=1", $OrignalUrl);
    if (!empty($EditedUrl)) {
        $response =  $EditedUrl;
        return $response;
    } else {
        $response = "";
        return $response;
    }

    //return print_r($EditedUrl);
    // echo "<pre>";
    // print_r($FinalArrayResult); die();
}
