<?php

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

// Also, perform any initialization required by the service's library.
require_once 'hooks.php';
require_once __DIR__ . '/lib/Admin/AdminDispatcher.php';
require_once __DIR__ . '/lib/Admin/Controller.php';
require_once __DIR__ . '/lib/Client/ClientDispatcher.php';
require_once __DIR__ . '/lib/Client/Controller.php';

use WHMCS\Module\Addon\AddonModule\Admin\AdminDispatcher;
use WHMCS\Module\Addon\AddonModule\Client\ClientDispatcher;
use WHMCS\Database\Capsule;

function nxtdashboard_config()
{
    $configarray = array(
        'name' => 'NXT Dashboard', // Display name for your module
        'description' => 'The module provide the  NXT Panel User Management and Reseller Program as well.', // Description displayed within the admin interface
        'author' => '<a href="https://whmcssmarters.com/" target="_blank"><img style="width: 90%;" src="../modules/addons/nxtdashboard/whmcssmarters.png"></a>',
        'language' => 'english', // Default language
        'version' => '1.3.0', // Version number 
        "fields" => array(
            "licenseregto" => array("FriendlyName" => "License Registered To", "Description" => "Not Available"),
            "licenseregmail" => array("FriendlyName" => "License Registered Email", "Description" => "Not Available"),
            "licenseduedate" => array("FriendlyName" => "License Due Date", "Description" => "Not Available"),
            "licensestatus" => array("FriendlyName" => "License Status", "Description" => "Not Available"),
            "license" => array("FriendlyName" => "License", "Type" => "text", "Size" => "35"),
            "deletetables" => array(
                "FriendlyName" => "Delete Records", "Type" => "yesno", "Size" => "25",
                "Description" => "Tick to check it should delete all the tables relative to this module on deactivation",
            ),
        )
    );
    $licenseinfo = XtreamCode_doCheckLicense();
    if ($licenseinfo['status'] != 'licensekeynotfound') {
        if ($licenseinfo['status'] == 'Active') {
            if (isset($licenseinfo['localkey']) && !empty($licenseinfo['localkey'])) {
                $moduledatacount = Capsule::table('tbladdonmodules')
                    ->where('module', '=', 'nxtdashboard')
                    ->where('setting', '=', 'localkey')
                    ->count();
                if (isset($moduledatacount) && !empty($moduledatacount)) {
                    Capsule::table('tbladdonmodules')
                        ->where('setting', 'localkey')
                        ->where('module', 'nxtdashboard')
                        ->update(['value' => $licenseinfo['localkey']]);
                } else {
                    Capsule::table('tbladdonmodules')->insert(
                        ['setting' => 'localkey', 'value' => $licenseinfo['localkey'], 'module' => 'nxtdashboard']
                    );
                }
            }
        }
        if ($licenseinfo['registeredname']) {
            $configarray['fields']['licenseregto']['Description'] = $licenseinfo['registeredname'];
        }
        if ($licenseinfo['email']) {
            $configarray['fields']['licenseregmail']['Description'] = $licenseinfo['email'];
        }
        if ($licenseinfo['nextduedate']) {
            $configarray['fields']['licenseduedate']['Description'] = $licenseinfo['nextduedate'];
        }
        $configarray['fields']['licensestatus']['Description'] = $licenseinfo['status'];
        $configarray['fields']['license']['Value'] = $licenseinfo['licensekey'];
    }

    return $configarray;
}

function XtreamCode_doCheckLicense()
{
    $result = Capsule::table('tbladdonmodules')
        ->where('module', '=', 'nxtdashboard')
        ->get();
    foreach ($result as $row) {
        $settings[$row->setting] = $row->value;
    }
    if ($settings['license']) {
        $localkey = $settings['localkey'];
        $result = Xtream_checkLicense($settings['license'], $localkey);
        $result['licensekey'] = $settings['license'];
    } else {
        $result['status'] = 'licensekeynotfound';
    }
    return $result;
}

function Xtream_checkLicense($licensekey, $localkey = '')
{
    $whmcsurl = "https://www.whmcssmarters.com/clients/";
    $licensing_secret_key = "cloudtvmedia";
    $localkeydays = 14;
    $allowcheckfaildays = 5;
    $check_token = time() . md5(mt_rand(1000000000, 9999999999) . $licensekey);
    $checkdate = date("Ymdhis");
    $domain = $_SERVER['SERVER_NAME'];
    $usersip = isset($_SERVER['SERVER_ADDR']) ? $_SERVER['SERVER_ADDR'] : $_SERVER['LOCAL_ADDR'];
    $dirpath = dirname(__FILE__);
    $verifyfilepath = 'modules/servers/licensing/verify.php';
    $localkeyvalid = false;
    if ($localkey) {
        $localkey = str_replace("\n", '', $localkey); # Remove the line breaks
        $localdata = substr($localkey, 0, strlen($localkey) - 32); # Extract License Data
        $md5hash = substr($localkey, strlen($localkey) - 32); # Extract MD5 Hash
        if ($md5hash == md5($localdata . $licensing_secret_key)) {
            $localdata = strrev($localdata); # Reverse the string
            $md5hash = substr($localdata, 0, 32); # Extract MD5 Hash
            $localdata = substr($localdata, 32); # Extract License Data
            $localdata = base64_decode($localdata);
            $localkeyresults = unserialize($localdata);
            $originalcheckdate = $localkeyresults['checkdate'];
            if ($md5hash == md5($originalcheckdate . $licensing_secret_key)) {
                $localexpiry = date("Ymdhis", mktime(date("h"), date("i"), date("s"), date("m"), date("m"), date("d") - $localkeydays, date("Y")));
                if ($originalcheckdate > $localexpiry) {
                    $localkeyvalid = true;
                    $results = $localkeyresults;
                    $validdomains = explode(',', $results['validdomain']);
                    if (!in_array($_SERVER['SERVER_NAME'], $validdomains)) {
                        $localkeyvalid = false;
                        $localkeyresults['status'] = "Invalid";
                        $results = array();
                    }
                    $validips = explode(',', $results['validip']);
                    if (!in_array($usersip, $validips)) {
                        $localkeyvalid = false;
                        $localkeyresults['status'] = "Invalid";
                        $results = array();
                    }
                    $validdirs = explode(',', $results['validdirectory']);
                    if (!in_array($dirpath, $validdirs)) {
                        $localkeyvalid = false;
                        $localkeyresults['status'] = "Invalid";
                        $results = array();
                    }
                }
            }
        }
    }
    if (!$localkeyvalid) {
        $responseCode = 0;
        $postfields = array(
            'licensekey' => $licensekey,
            'domain' => $domain,
            'ip' => $usersip,
            'dir' => $dirpath,
        );
        if ($check_token)
            $postfields['check_token'] = $check_token;
        $query_string = '';
        foreach ($postfields as $k => $v) {
            $query_string .= $k . '=' . urlencode($v) . '&';
        }
        if (function_exists('curl_exec')) {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $whmcsurl . $verifyfilepath);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $query_string);
            curl_setopt($ch, CURLOPT_TIMEOUT, 30);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            $data = curl_exec($ch);
            $responseCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
        } else {
            $responseCodePattern = '/^HTTP\/\d+\.\d+\s+(\d+)/';
            $fp = @fsockopen($whmcsurl, 80, $errno, $errstr, 5);
            if ($fp) {
                $newlinefeed = "\r\n";
                $header = "POST " . $whmcsurl . $verifyfilepath . " HTTP/1.0" . $newlinefeed;
                $header .= "Host: " . $whmcsurl . $newlinefeed;
                $header .= "Content-type: application/x-www-form-urlencoded" . $newlinefeed;
                $header .= "Content-length: " . @strlen($query_string) . $newlinefeed;
                $header .= "Connection: close" . $newlinefeed . $newlinefeed;
                $header .= $query_string;
                $data = $line = '';
                @stream_set_timeout($fp, 20);
                @fputs($fp, $header);
                $status = @socket_get_status($fp);
                while (!@feof($fp) && $status) {
                    $line = @fgets($fp, 1024);
                    $patternMatches = array();
                    if (
                        !$responseCode && preg_match($responseCodePattern, trim($line), $patternMatches)
                    ) {
                        $responseCode = (empty($patternMatches[1])) ? 0 : $patternMatches[1];
                    }
                    $data .= $line;
                    $status = @socket_get_status($fp);
                }
                @fclose($fp);
            }
        }
        if ($responseCode != 200) {
            $localexpiry = date("Ymdhis", mktime(date("h"), date("i"), date("s"), date("m"), date("m"), date("d") - ($localkeydays + $allowcheckfaildays), date("Y")));
            if ($originalcheckdate > $localexpiry) {
                $results = $localkeyresults;
            } else {
                $results = array();
                $results['status'] = "Invalid";
                $results['description'] = "Remote Check Failed";
                return $results;
            }
        } else {
            preg_match_all('/<(.*?)>([^<]+)<\/\\1>/i', $data, $matches);
            $results = array();
            foreach ($matches[1] as $k => $v) {
                $results[$v] = $matches[2][$k];
            }
        }
        if (!is_array($results)) {
            die("Invalid License Server Response");
        }
        if ($results['md5hash']) {
            if ($results['md5hash'] != md5($licensing_secret_key . $check_token)) {
                $results['status'] = "Invalid";
                $results['description'] = "MD5 Checksum Verification Failed";
                return $results;
            }
        }
        if ($results['status'] == "Active") {
            $results['checkdate'] = $checkdate;
            $data_encoded = serialize($results);
            $data_encoded = base64_encode($data_encoded);
            $data_encoded = md5($checkdate . $licensing_secret_key) . $data_encoded;
            $data_encoded = strrev($data_encoded);
            $data_encoded = $data_encoded . md5($data_encoded . $licensing_secret_key);
            $data_encoded = wordwrap($data_encoded, 80, "\n", true);
            $results['localkey'] = $data_encoded;
        }
        $results['remotecheck'] = true;
    }
    unset($postfields, $data, $matches, $whmcsurl, $licensing_secret_key, $checkdate, $usersip, $localkeydays, $allowcheckfaildays, $md5hash);
    return $results;
}

function nxtdashboard_upgrade($vars)
{
    $version = $vars['version'];
    if ($version < 1.0) {
        $reseller = array(
            'fieldname' => 'Reseller',
            'fieldtype' => 'text',
            'description' => '',
            'regexpr' => "",
            'required' => '',
            'adminonly' => 'on',
            'showorder' => 'on',
            'showinvoice' => 'on',
        );
        $custom_fields = array('Reseller' => $reseller);
        foreach ($custom_fields as $field_name => $field_value) {
            $customfield = Capsule::table('tblcustomfields')
                ->where('fieldname', '=', $field_name)
                ->count();
            if ($customfield == 0) {
                Capsule::table('tblcustomfields')->insert(
                    [
                        'type' => 'client',
                        'relid' => '0',
                        'fieldname' => $field_name,
                        'fieldtype' => $field_value['fieldtype'],
                        'description' => $field_value['description'],
                        'fieldoptions' => '',
                        'regexpr' => $field_value['regexpr'],
                        'adminonly' => $field_value['adminonly'],
                        'required' => $field_value['required'],
                        'showorder' => $field_value['showorder'],
                        'showinvoice' => $field_value['showinvoice'],
                        'sortorder' => 0
                    ]
                );
            }
        }
    }
    if ($version < 1.1) {
        try {
            if (!Capsule::schema()->hasTable('mod_xtreamsuper_reseller')) {
                Capsule::schema()->create(
                    'mod_xtreamsuper_reseller',
                    function ($table) {
                        /** @var \Illuminate\Database\Schema\Blueprint $table */
                        $table->increments('id');
                        $table->string('client_id');
                        $table->string('product_id');
                    }
                );
            }
        } catch (\Exception $e) {
            echo "Unable to create my_table: {$e->getMessage()}";
        }
        try {
            if (!Capsule::schema()->hasTable('mod_xtreamreseller')) {
                Capsule::schema()->create(
                    'mod_xtreamreseller',
                    function ($table) {
                        /** @var \Illuminate\Database\Schema\Blueprint $table */
                        $table->increments('id');
                        $table->string('client_id');
                        $table->string('product_id');
                    }
                );
            }
        } catch (\Exception $e) {
            echo "Unable to create my_table: {$e->getMessage()}";
        }
        try {
            if (!Capsule::schema()->hasTable('mod_xtreamresellergrp')) {
                Capsule::schema()->create(
                    'mod_xtreamresellergrp',
                    function ($table) {
                        /** @var \Illuminate\Database\Schema\Blueprint $table */
                        $table->increments('id');
                        $table->string('client_id');
                        $table->string('product_id');
                    }
                );
            }
        } catch (\Exception $e) {
            echo "Unable to create mod_xtreamresellergrp: {$e->getMessage()}";
        }
        try {
            if (!Capsule::schema()->hasTable('mod_xtreamresellergrpuser')) {
                Capsule::schema()->create(
                    'mod_xtreamresellergrpuser',
                    function ($table) {
                        /** @var \Illuminate\Database\Schema\Blueprint $table */
                        $table->increments('id');
                        $table->string('client_id');
                        $table->string('product_id');
                    }
                );
            }
        } catch (\Exception $e) {
            echo "Unable to create mod_xtreamresellergrpuser: {$e->getMessage()}";
        }

        try {
            if (!Capsule::schema()->hasTable('mod_xtreamchannelsList')) {
                Capsule::schema()->create(
                    'mod_xtreamchannelsList',
                    function ($table) {
                        /** @var \Illuminate\Database\Schema\Blueprint $table */
                        $table->increments('id');
                        $table->string('categoryId');
                        $table->string('channel_category');
                        $table->string('channel_list');
                    }
                );
            }
        } catch (\Exception $e) {
            echo "Unable to create mod_xtreamresellergrpuser: {$e->getMessage()}";
        }
    }
}

function nxtdashboard_activate()
{
    // Create custom tables and schema required by your module
    try {
        if (!Capsule::schema()->hasTable('tblxtreampaymentgateways')) {
            Capsule::schema()->create(
                'tblxtreampaymentgateways',
                function ($table) {
                    $table->string('uid');
                    $table->text('gateway');
                    $table->text('setting');
                    $table->text('value');
                    $table->integer('order');
                }
            );
        }

        if (!Capsule::schema()->hasTable('xtreamDomainVerify')) {
            Capsule::schema()->create(
                'xtreamDomainVerify',
                function ($table) {
                    $table->increments('id');
                    $table->string('uid');
                    $table->string('verifyCode');
                    $table->string('status');
                }
            );
        }

        if (!Capsule::schema()->hasTable('xtreamMywebsite')) {
            Capsule::schema()->create(
                'xtreamMywebsite',
                function ($table) {
                    $table->increments('id');
                    $table->string('uid');
                    $table->string('logo');
                    $table->string('companyName');
                    $table->string('tagline');
                    $table->string('domainURL');
                    $table->string('tandc');
                    $table->string('privacy');
                    $table->string('websiteURL');
                    $table->string('headColor');
                    $table->string('textColor');
                    $table->string('products');
                    $table->string('gateways');
                    $table->string('status');
                }
            );
        }

        if (!Capsule::schema()->hasTable('xtreamPackagePrice')) {
            Capsule::schema()->create(
                'xtreamPackagePrice',
                function ($table) {
                    $table->increments('id');
                    $table->string('uid');
                    $table->string('products');
                    $table->string('priceMonthly');
                    $table->string('priceQuarterly');
                    $table->string('priceSemiannually');
                    $table->string('priceAnnually');
                    $table->string('priceBiennially');
                    $table->string('priceTriennially');
                }
            );
        }
        if (!Capsule::schema()->hasTable('mod_xtreamConfig')) {
            Capsule::schema()->create(
                'mod_xtreamConfig',
                function ($table) {
                    $table->string('setting');
                    $table->string('value');
                }
            );
            $configuration = array(
                'custom_field_mag' => 'MAG Address',
                'custom_field_eng' => 'XtreamTV ID',
                'common_identifier' => 'WHMCS:',
                'configoption_field_name' => 'Extra Connections',
                'checkmagdevice' => 'MAG Device',
                'checkengdevice' => 'Enigma Device',
                'syncredit' => 'on',
                'mac_not_valid' => 'This MAC address is not valid!',
                'mac_change_success' => 'MAG Box network address(MAC) is changed',
                'mac_add_success' => 'Added new MAG box with address:',
                'mac_error' => 'MAC Address already exists! Please contact support!',
                'iptv_service_details' => 'IPTV Service Details',
                'devices' => 'Devices',
                'back_to_overview' => 'Back to overview',
                'product_service' => 'Product/Service',
                'username' => 'Username',
                'password' => 'Password',
                'playlist' => 'M3U Playlist',
                'mag_portal' => 'MAG Portal',
                'devices_desc' => 'You can manage your streaming devices here!',
                'mag_desc' => 'MAG Box',
                'enigma2_devices' => 'Enigma2 Device',
                'current_mag' => 'Current',
                'new_mag' => 'New',
                'change_mag_button' => 'Change',
                'add_mag_button' => 'Add new MAG device',
                'other_devices' => 'Other Devices',
                'autoscripts' => 'Auto-Scripts',
                'stream_output' => 'Stream output:',
                'dropdown_name' => 'Playlist/Script',
                'dropdown_action' => 'Choose Device',
                'creditapply' => 'on',
                'reseller_susp' => 'on',
                'reseller_unsusp' => 'on',
                'reseller_term' => 'on',
                'reseller_remove' => 'on',
                'supreseller_unsusp' => 'on',
                'supreseller_term' => 'on',
                'supreseller_susp' => 'on',
                'activationcode' => 'off',
                'usernameformat' => 'digits_alphabet',
                'passwordformat' => 'digits_alphabet',
                'activationdigits' => '8',
                'usernamedigits' => '10',
                'passworddigits' => '10',
            );
            foreach ($configuration as $name => $value) {
                $configurationdata[] = array('setting' => $name, 'value' => $value);
            }
            Capsule::table('mod_xtreamConfig')->delete();
            try {
                Capsule::table('mod_xtreamConfig')->insert($configurationdata);
            } catch (\Exception $e) {
                return array('status' => 'error', 'description' => $e->getMessage() . '. There is an error while activating this module');
            }
        }
        try {
            if (!Capsule::schema()->hasTable('mod_xtreamchannelsList')) {
                Capsule::schema()->create(
                    'mod_xtreamchannelsList',
                    function ($table) {
                        /** @var \Illuminate\Database\Schema\Blueprint $table */
                        $table->increments('id');
                        $table->string('categoryId');
                        $table->string('channel_category');
                        $table->string('channel_list');
                    }
                );
            }
        } catch (\Exception $e) {
            echo "Unable to create mod_xtreamresellergrpuser: {$e->getMessage()}";
        }

        /*
            * Setting Table
            */
        if (!Capsule::schema()->hasTable('mod_xtreamresellersetting')) {
            Capsule::schema()->create(
                'mod_xtreamresellersetting',
                function ($table) {
                    $table->string('setting');
                    $table->string('value');
                }
            );
            $mod_xtreamresellersetting = array(
                'login' => 'on',
                'password' => 'on',
                'clientname' => 'on',
                'confirmpassword' => 'on',
            );
            foreach ($mod_xtreamresellersetting as $name => $value) {
                $settingdata[] = array('setting' => $name, 'value' => $value);
            }
            Capsule::table('mod_xtreamresellersetting')->delete();
            try {
                Capsule::table('mod_xtreamresellersetting')->insert($settingdata);
            } catch (\Exception $e) {
                return array('status' => 'error', 'description' => $e->getMessage() . '. There is an error while activating this module');
            }
        }
        /*
            * Setting Table
            */
        if (!Capsule::schema()->hasTable('mod_xtreamsetting')) {
            Capsule::schema()->create(
                'mod_xtreamsetting',
                function ($table) {
                    $table->string('setting');
                    $table->string('value');
                }
            );
        }
        $clientgrp = Capsule::table('tblclientgroups')->get();
        $returndata = array();
        if (isset($clientgrp) && !empty($clientgrp)) {
            foreach ($clientgrp as $grp) {
                $returndata[] = $grp->groupname;
            }
        }
        $clientGroups = array_diff(array(
            '#F77B7B' => 'Reseller',
            '#FEC6C6' => 'Super-Reseller',
        ), $returndata);
        foreach ($clientGroups as $name => $value) {
            $data[] = array('groupname' => $value, 'groupcolour' => $name, 'discountpercent' => '0.00', 'susptermexempt' => '', 'separateinvoices' => '');
        }
        if (isset($data) && !empty($data))
            Capsule::table('tblclientgroups')->insert($data);
        /*
            * Extra Config field
            */
        $productconfiggroups = Capsule::table('tblproductconfiggroups')->get();
        $return = array();
        if (isset($productconfiggroups) && !empty($productconfiggroups)) {
            foreach ($productconfiggroups as $configgroups) {
                $return[] = $configgroups->name;
            }
        }
        $productGroups = array_diff(array('Extra Connections'), $return);
        foreach ($productGroups as $valuegrp) {
            $datagrp = array('name' => $valuegrp);
        }
        if (isset($datagrp) && !empty($datagrp)) {
            $id = Capsule::table('tblproductconfiggroups')->insertGetId($datagrp);

            $productconfiggroupsoption = Capsule::table('tblproductconfigoptions')->get();
            $returnoption = array();
            if (isset($productconfiggroupsoption) && !empty($productconfiggroupsoption)) {
                foreach ($productconfiggroupsoption as $configgroupsoption) {
                    $returnoption[] = $configgroupsoption->optionname;
                }
            }
            $productGroupsoption = array_diff(array(
                'Extra Connections',
            ), $returnoption);
            foreach ($productGroupsoption as $value) {
                $dataoption = array('optionname' => $value, 'gid' => $id, 'optiontype' => 4, 'qtyminimum' => 0, 'qtymaximum' => 0, 'order' => 0, 'hidden' => 0);
            }
            if (isset($dataoption) && !empty($dataoption)) {
                $extraconnectionid = Capsule::table('tblproductconfigoptions')->insertGetId($dataoption);
                $dataoptionsub = array('configid' => $extraconnectionid, 'optionname' => 'Extra Connections', 'sortorder' => 0, 'hidden' => 0);
                $extraconnectionsubid = Capsule::table('tblproductconfigoptionssub')->insertGetId($dataoptionsub);
                $tblcurrencies = Capsule::table('tblcurrencies')
                    ->select('id', 'rate', 'default')
                    ->get();
                foreach ($tblcurrencies as $currencies) {
                    $price = 10 * $currencies->rate;
                    $amount = number_format((float) $price, 2, '.', '');
                    Capsule::table('tblpricing')
                        ->insert(
                            array(
                                'type' => 'configoptions',
                                'currency' => $currencies->id,
                                'relid' => $extraconnectionsubid,
                                'monthly' => $amount
                            )
                        );
                }
            }
        }
        if (!Capsule::schema()->hasTable('mod_xtreamAffs_clients')) {
            Capsule::schema()->create(
                'mod_xtreamAffs_clients',
                function ($table) {
                    /** @var \Illuminate\Database\Schema\Blueprint $table */
                    $table->increments('id');
                    $table->integer('affiliatesid');
                    $table->integer('clientid');
                }
            );
        }
        $reseller = array(
            'fieldname' => 'Reseller',
            'fieldtype' => 'text',
            'description' => '',
            'regexpr' => "",
            'required' => '',
            'adminonly' => 'on',
            'showorder' => 'on',
            'showinvoice' => 'on',
        );
        $logincode = array(
            'fieldname' => 'logincode',
            'fieldtype' => 'text',
            'description' => '',
            'regexpr' => "",
            'required' => '',
            'adminonly' => 'on',
            'showorder' => '',
            'showinvoice' => '',
        );
        $custom_fields = array('Reseller' => $reseller, 'logincode' => $logincode);
        foreach ($custom_fields as $field_name => $field_value) {
            $customfield = Capsule::table('tblcustomfields')
                ->where('fieldname', '=', $field_name)
                ->count();
            if ($customfield == 0) {
                Capsule::table('tblcustomfields')->insert(
                    [
                        'type' => 'client',
                        'relid' => 0,
                        'fieldname' => $field_name,
                        'fieldtype' => $field_value['fieldtype'],
                        'description' => $field_value['description'],
                        'fieldoptions' => '',
                        'regexpr' => $field_value['regexpr'],
                        'adminonly' => $field_value['adminonly'],
                        'required' => $field_value['required'],
                        'showorder' => $field_value['showorder'],
                        'showinvoice' => $field_value['showinvoice'],
                        'sortorder' => 0
                    ]
                );
            }
        }
        /*
            * Add Email Templates in WHMCS 
            * IPTV Service Details
            * IPTV Client Details
            */

        $emailtemplates = Capsule::table('tblemailtemplates')->get();
        $emailtemplatesreturn = array();
        if (isset($emailtemplates) && !empty($emailtemplates)) {
            foreach ($emailtemplates as $emailtemplate) {
                $emailtemplatesreturn[] = $emailtemplate->name;
            }
        }
        $emailtemplatesoption = array_diff(array(
            'IPTV Client Details', 'IPTV Service Details'
        ), $emailtemplatesreturn);
        foreach ($emailtemplatesoption as $emailvalue) {
            if ($emailvalue == 'IPTV Client Details') {
                $emailvaluedataoption[] = array('type' => 'general', 'name' => 'IPTV Client Details', 'subject' => 'IPTV Client Info', 'message' => '   
                Dear {$client_name},<br /><br />You have created a new user with following details<br /><br /><br />User name : {$iptv_client_name}<br /><br />Service name :  {$iptv_client_service}<br /><br />User email : {$iptv_client_email}<br /><br />User Password : {$iptv_client_password}<br /><br />User Service username : {$iptv_service_username} <br /><br />User service password : {$iptv_service_password},<br /><br /><br /><br />Regards<br />{$signature}   
                ', 'disabled' => 0, 'custom' => 1, 'plaintext' => 0);
            }
            if ($emailvalue == 'IPTV Service Details') {
                $emailvaluedataoption[] = array('type' => 'product', 'name' => 'IPTV Service Details', 'subject' => 'Your IPTV Service Info', 'message' => '<span style="font-size: small;">Dear {$client_name},</span><br /><span style="font-size: small;"><br />Thanks for buying our service. Your service {$service_product_name} has now activated.</span><br /><span style="font-size: small;">Please use the following to details to use your service. </span><br /><br /><span style="font-size: small;"><strong>Your IPTV Service Details are:</strong> <br /></span><br /><span style="font-size: small;"><strong>Your Username :</strong> {$service_username}</span><br /><br /><span style="font-size: small;"><strong>Your Password :</strong> {$service_password}<br /><br /><strong>M3u Playlist URL :</strong> <span style="font-size: small;">{$service_server_hostname}/get.php?username={$service_username}&amp;password={$service_password}&amp;type=m3u&amp;output=ts</span><br /><br /></span><span style="font-size: small;"><strong>M3u Plus Playlist URL :</strong> <span style="font-size: small;">{$service_server_hostname}/get.php?username={$service_username}&amp;password={$service_password}&amp;type=m3u_plus&amp;output=ts</span></span><br /><br /><span style="font-size: small;"><span style="font-size: small;"><strong>Enigma2 OE 2.0 Auto Script :</strong> wget -O /etc/enigma2/iptv.sh "{$service_server_hostname}/get.php?username=<span>{$service_username}</span>&amp;password=<span>{$service_password}</span>&amp;type=enigma22_script&amp;output=ts" &amp;&amp; chmod 777 /etc/enigma2/iptv.sh &amp;&amp; /etc/enigma2/iptv.sh </span></span><span style="font-size: small;">&amp;&amp; cd /etc/enigma2/ &amp;&amp; cp iptv.sh /usr/script/ &amp;&amp; cd /usr/script/ &amp;&amp; chmod 775 iptv.sh</span>
    <p><span style="font-size: small;">Then on your box:</span></p>
    <p><span style="font-size: small;">Press Menu, Timers, Cron Timers.</span></p>
    <p><span style="font-size: small;">Green Button to "add"</span></p>
    <p><span style="font-size: small;">Run how often?: daily</span><br /><span style="font-size: small;">Time to execute Command or Script: 06:00 (your Preference of time)</span><br /><span style="font-size: small;">Command Type: Predefined</span><br /><span style="font-size: small;">Command To Run: iptv.sh</span></p>
    <p><span style="font-size: small;">Green Button to save.<br /><br /></span></p>
    <span style="font-size: small;"><strong>MAG Portal URL :</strong> {$service_server_hostname}/c</span><br /><br /><span style="font-size: small;"><span style="font-size: small;"><a href="{$company_domain}/clientarea.php?action=productdetails&amp;id={$service_id}" target="_blank">Get or Download your m3u Playlist here<br /><br /></a></span></span><hr />
    <p><span style="font-size: small;"><strong>Billing Info: </strong></span></p>
    <p><span style="font-size: small;">Product/Service: {$service_product_name}</span><br /><span style="font-size: small;">Payment Method: {$service_payment_method}</span><br /><span style="font-size: small;">Amount: {$service_recurring_amount}</span><br /><span style="font-size: small;">Billing Cycle: {$service_billing_cycle}</span><br /><span style="font-size: small;">Next Due Date: {$service_next_due_date}</span></p>
    <p><span style="font-size: small;">Thank you for choosing us.</span></p>
    <p><span style="font-size: small;">{$signature}</span></p>  
                ', 'disabled' => 0, 'custom' => 1, 'plaintext' => 0);
            }
        }
        if (isset($emailvaluedataoption) && !empty($emailvaluedataoption))
            Capsule::table('tblemailtemplates')->insert($emailvaluedataoption);
    } catch (\Exception $e) {
        return array('status' => 'error', 'description' => $e->getMessage() . '. There is an error while activating this module');
    }
    try {
        if (!Capsule::schema()->hasTable('mod_xtreamsuper_reseller')) {
            Capsule::schema()->create(
                'mod_xtreamsuper_reseller',
                function ($table) {
                    /** @var \Illuminate\Database\Schema\Blueprint $table */
                    $table->increments('id');
                    $table->string('client_id');
                    $table->string('product_id');
                }
            );
        }
    } catch (\Exception $e) {
        return array('status' => 'error', 'description' => "Unable to create mod_xtreamsuper_reseller: {$e->getMessage()}");
    }
    try {
        if (!Capsule::schema()->hasTable('mod_xtreamreseller')) {
            Capsule::schema()->create(
                'mod_xtreamreseller',
                function ($table) {
                    /** @var \Illuminate\Database\Schema\Blueprint $table */
                    $table->increments('id');
                    $table->string('client_id');
                    $table->string('product_id');
                }
            );
        }
    } catch (\Exception $e) {
        return array('status' => 'error', 'description' => "Unable to create mod_xtreamreseller: {$e->getMessage()}");
    }
    try {
        if (!Capsule::schema()->hasTable('mod_xtreamresellergrp')) {
            Capsule::schema()->create(
                'mod_xtreamresellergrp',
                function ($table) {
                    /** @var \Illuminate\Database\Schema\Blueprint $table */
                    $table->increments('id');
                    $table->string('client_id');
                    $table->string('product_id');
                }
            );
        }
    } catch (\Exception $e) {
        return array('status' => 'error', 'description' => "Unable to create mod_xtreamresellergrp: {$e->getMessage()}");
    }
    try {
        if (!Capsule::schema()->hasTable('mod_xtreamresellergrpuser')) {
            Capsule::schema()->create(
                'mod_xtreamresellergrpuser',
                function ($table) {
                    /** @var \Illuminate\Database\Schema\Blueprint $table */
                    $table->increments('id');
                    $table->string('client_id');
                    $table->string('product_id');
                }
            );
        }
    } catch (\Exception $e) {
        return array('status' => 'error', 'description' => "Unable to create mod_xtreamresellergrpuser: {$e->getMessage()}");
    }
    /**
     * Auto Script 
     */
    if (!Capsule::schema()->hasTable('mod_xtreamautoscript')) {
        Capsule::schema()->create(
            'mod_xtreamautoscript',
            function ($table) {
                $table->string('name');
                $table->string('value');
            }
        );
        $autoscript = array(
            'Enigma 2 OE 1.6' => 'wget -O /etc/enigma2/iptv.sh \'{$serverhostname}/get.php?username={$iptv_username}&password={$iptv_password}&type=enigma216_script&output={$outputfirst}\' && chmod 777 /etc/enigma2/iptv.sh && /etc/enigma2/iptv.sh',
            'Enigma 2 OE 2.0' => 'wget -O /etc/enigma2/iptv.sh \'{$serverhostname}/get.php?username={$iptv_username}&password={$iptv_password}&type=enigma22_script&output={$outputfirst}\' && chmod 777 /etc/enigma2/iptv.sh && /etc/enigma2/iptv.sh',
            'Octagon Script' => 'wget -qO /var/bin/iptv \'{$serverhostname}/get.php?username={$iptv_username}&password={$iptv_password}&type=octagon_script&output={$outputfirst}\'',
        );
        foreach ($autoscript as $name => $value) {
            $configurationautoscript[] = array('name' => $name, 'value' => $value);
        }
        Capsule::table('mod_xtreamautoscript')->delete();
        try {
            Capsule::table('mod_xtreamautoscript')->insert($configurationautoscript);
        } catch (\Exception $e) {
            return array('status' => 'error', 'description' => $e->getMessage() . '. There is an error while activating this module');
        }
    }
    /**
     * Disable Auto Credit Applying
     */
    Capsule::table('tblconfiguration')
        ->where('setting', 'noautoapplycredit')
        ->update(['value' => 1]);
    return array(
        'status' => 'success', // Supported values here include: success, error or info
        'description' => 'Xtream Coder Dashboard Module Activated Successfully!',
    );
}

function nxtdashboard_deactivate()
{
    $results = Capsule::table('tbladdonmodules')->where('module', '=', 'nxtdashboard')->get();
    foreach ($results as $row) {
        $settings[$row->setting] = $row->value;
    }
    if (isset($settings['deletetables']) && !empty($settings['deletetables'])) {
        if ($settings['deletetables'] == 'on') {
            // Undo any database and schema modifications made by your module here
            Capsule::schema()->dropIfExists('xtreamMywebsite');
            Capsule::schema()->dropIfExists('xtreamPackagePrice');
            Capsule::schema()->dropIfExists('tblxtreampaymentgateways');
            Capsule::schema()->dropIfExists('xtreamDomainVerify');
            Capsule::schema()->dropIfExists('mod_xtreamConfig');
            Capsule::schema()->dropIfExists('mod_xtreamchannelsList');
            Capsule::schema()->dropIfExists('mod_xtreamsetting');
            Capsule::schema()->dropIfExists('mod_xtreamresellersetting');
            Capsule::schema()->dropIfExists('mod_xtreamAffs_clients');
            Capsule::schema()->dropIfExists('mod_xtreamreseller');
            Capsule::schema()->dropIfExists('mod_xtreamresellergrp');
            Capsule::schema()->dropIfExists('mod_xtreamresellergrpuser');
            Capsule::schema()->dropIfExists('mod_xtreamsuper_reseller');
            Capsule::schema()->dropIfExists('mod_xtreamautoscript');
        }
    }
    return array(
        'status' => 'success', // Supported values here include: success, error or info
        'description' => 'Xtream Coder Dashboard modules deactivated successfully!',
    );
}

function nxtdashboard_output($vars)
{
    $licenseinfo = XtreamCode_doCheckLicense();
    if ($licenseinfo['status'] == 'Active') {
        // Get common module parameters
        $modulelink = $vars['modulelink'];
        $version = $vars['version'];
        $_lang = $vars['_lang'];
        include_once 'xtreamtabs.php';
        $action = isset($_REQUEST['action']) ? $_REQUEST['action'] : '';
        $dispatcher = new AdminDispatcher();
        $response = $dispatcher->dispatch($action, $vars);
        echo $response;
    } else {
        echo "License Key not found.";
    }
}

function nxtdashboard_clientarea($vars)
{
    // Dispatch and handle request here. What follows is a demonstration of one
    // possible way of handling this using a very basic dispatcher implementation.

    $action = isset($_REQUEST['action']) ? $_REQUEST['action'] : '';
    $clientgroip = Capsule::table('tblclients')->where('id', '=', $_SESSION['uid'])->get();
    $clientgroup = Capsule::table('tblclientgroups')->where('id', '=', $clientgroip[0]->groupid)->get();
    if ($clientgroup[0]->groupname == 'Reseller') {
        $group['checkgroup'] = 'reseller';
    } elseif ($clientgroup[0]->groupname == 'Super-Reseller') {
        $group['checkgroup'] = 'superreseller';
    }
    $zip = new ZipArchive;
    $dispatcher = new ClientDispatcher();
    $response = $dispatcher->dispatch($action, $vars, $zip);
    $affdetails = $dispatcher->dispatch('CheckAffCredit', $vars, $zip);
    $group['totalcredit'] = $affdetails->credit;
    $response['vars'] = array_merge($response['vars'], $group);

    return $response;
}
