<div class="container">
   <div class="row">
      <div class="col-lg-4 col-xl-3">
         <div class="sidebar">
            <div menuitemname="Upgrade Downgrade" class="mb-3 card card-sidebar">
               <div class="card-header">
                  <h3 class="card-title m-0">
                     <i class="fas fa-expand"></i>&nbsp;                Up/Downgrade
                     <i class="fas fa-chevron-up card-minimise float-right"></i>
                  </h3>
               </div>
               <div class="collapsable-card-body">
                  <div class="list-group list-group-flush d-md-flex" role="tablist">
                     <div menuitemname="Product-Service" class="list-group-item list-group-item-action" id="Primary_Sidebar-Upgrade_Downgrade-Product-Service">
                        Product/Service:<br><strong>{$upgradedata.current.groupname} - {$upgradedata.current.name}</strong>
                     </div>
                  </div>
               </div>
               <div class="card-footer clearfix">
                  <form method="post" action="clientarea.php?action=productdetails">
                     <input type="hidden" name="id" value="{$upgradedata.hostingid}">
                     <button type="submit" class="btn btn-block btn-primary">
                     	<i class="fas fa-arrow-circle-left"></i> 
                     	Back to Service Details
                     </button>
                  </form>
               </div>
            </div>
         </div>
      </div>
      <div class="col-lg-8 col-xl-9 primary-content">
         <div class="card">
            <div class="card-body">
               {if !empty($upgradedata.promocodeerrror)}
                  <div class="alert alert-block alert-danger text-center">
                     {$upgradedata.promocodeerrror}        
                  </div>
               {/if}
               {if !empty($upgradedata.invoiceerror)}
                  <div class="alert alert-block alert-danger text-center">
                     {$upgradedata.invoiceerror}        
                  </div>
               {/if}
               <div class="alert alert-block alert-info text-center">
                  Current Configuration: <strong>{$upgradedata.current.groupname} - {$upgradedata.current.name}</strong>        
               </div>
               <table class="table table-striped">
                  <thead>
                     <tr>
                        <th width="60%">Description</th>
                        <th width="40%" class="text-center">Price</th>
                     </tr>
                  </thead>
                  <tbody>
                     <tr>
                        <td>
                        	{$upgradedata.current.name} =&gt; {$upgradedata.newproduct.name} ({$upgradedata.newproduct.billingcycle})
                        </td>
                        <td class="text-center">{$upgradedata.clientcurrencyprefix}{$upgradedata.newproduct.newprice} {$upgradedata.clientcurrencycode}</td>
                     </tr>
                     <tr class="masspay-total">
                        <td class="text-right">Subtotal:</td>
                        <td class="text-center">{$upgradedata.clientcurrencyprefix}{$upgradedata.newproduct.newprice}  {$upgradedata.clientcurrencycode}</td>
                     </tr>
                     {if isset($upgradedata.procodesuccessdata.totaldiscount)}
                        <tr class="masspay-total">
                           <td class="text-right">{$upgradedata.procodesuccessdata.message}:</td>
                           <td class="text-center">{$upgradedata.clientcurrencyprefix}{$upgradedata.procodesuccessdata.totaldiscount} {$upgradedata.clientcurrencycode}</td>
                        </tr>
                     {/if}

                     <tr class="masspay-total">
                        <td class="text-right">Total Due Today:</td>
                        <td class="text-center">
                           
                           {if isset($upgradedata.procodesuccessdata.afterpromofinalprice)}
                              {$upgradedata.clientcurrencyprefix}{$upgradedata.procodesuccessdata.afterpromofinalprice}  
                           {else}
                              {$upgradedata.clientcurrencyprefix}{$upgradedata.newproduct.newprice}  
                           {/if}
                           {$upgradedata.clientcurrencycode}
                        </td>
                     </tr>
                  </tbody>
               </table>
               {if isset($upgradedata.totalpendingdays)}
                  {if !empty($upgradedata.totalpendingdays)}
                  <div class="alert alert-warning text-center">
                     Upgrade price is calculated from a credit of the unused portion of the current plan and billing of the new plan for the same period ({$upgradedata.totalpendingdays} Days)
                  </div>
                  {/if}
               {/if}
               <div class="row">
                  <div class="col-sm-6">
                     <form method="post" action="" role="form">
                         <input type="hidden" name="step" value="2">
                        <input type="hidden" name="type" value="package">
                        <input type="hidden" name="id" value="{$upgradedata.hostingid}">
                        <input type="hidden" name="newpid" value="{$upgradedata.newproduct.id}">
                        <input type="hidden" name="billingcycle" value="{$upgradedata.newproduct.billingcycle}">
                        {if ! isset($upgradedata.procodesuccessdata.promosuccess)}
                           <input type="hidden" name="recalculatebypromotioncode" value="true">
                        {/if}
                        <h2>Promotional Code</h2>
                        <div class="input-group">
                           <input class="form-control" type="text" name="promocode" placeholder="Promotional Code" value="{$upgradedata.enteredpromo}" width="40" {if isset($upgradedata.procodesuccessdata.promosuccess)}disabled{/if} required>
                           <div class="input-group-append">
                              {if isset($upgradedata.procodesuccessdata.promosuccess)}
                                 <button type="submit" name="removepromo" class="btn btn-danger">
                                    Don't use Promotional Code
                                 </button>
                              {else}
                                 <button type="submit" class="btn btn-success">
                                    Validate Code
                                 </button>
                              {/if}
                           </div>
                        </div>
                     </form>
                  </div>
                  <div class="col-sm-6">
                     <form method="post" action="" id="formtoupgrade">
                        <input type="hidden" name="step" value="2">
                        <input type="hidden" name="type" value="package">
                        <input type="hidden" name="id" value="{$upgradedata.hostingid}">
                        <input type="hidden" name="newpid" value="{$upgradedata.newproduct.id}">
                        <input type="hidden" name="billingcycle" value="{$upgradedata.newproduct.billingcycle}">
                        <input type="hidden" name="createinvoice" value="true">
                        {if isset($upgradedata.procodesuccessdata.returnpromo)}
                           <input type="hidden" name="promoforfinal" value="{$upgradedata.procodesuccessdata.returnpromo}">
                        {/if}
                        <h2>Payment Method</h2>
                        <div class="form-group">
                           <select name="paymentmethod" id="inputPaymentMethod" class="form-control custom-select">
                           	{if !empty($upgradedata.gateways)}
                           		{foreach from=$upgradedata.gateways item=getwaydata}
                           			<option value="{$getwaydata.module}">{$getwaydata.displayname}</option>
                           		{/foreach}
                           	{else}
                           		<option value="">No Gateway Found!!</option>
                           	{/if}
                           </select>
                        </div>
                     </form>
                  </div>
               </div>
               <div class="form-group text-center">
                  <button type="submit" class="btn btn-primary" id="btnOrderContinue">
                  Continue <i class="fas fa-arrow-right"></i>
                  </button>
               </div>
            </div>
         </div>
      </div>
   </div>
   <div class="clearfix"></div>
</div>

<script type="text/javascript">
$(document).ready(function(){
	$("#btnOrderContinue").click(function(s){
		s.preventDefault();
		$("#formtoupgrade").submit();
	});
});
</script>