<?php

use Illuminate\Database\Capsule\Manager as Capsule;

function NXT_ProductAddonsPack($params, $Bouquets = "")
{
    $ReturnData = "";
    $AddonsBouquets = Capsule::table('tblhosting')
        ->join('tblhostingaddons', 'tblhosting.id', '=', 'tblhostingaddons.hostingid')
        ->join('tbladdons', 'tblhostingaddons.addonid', '=', 'tbladdons.id')
        ->join('tblmodule_configuration', 'tbladdons.id', '=', 'tblmodule_configuration.entity_id')
        ->where('tblhosting.id', $params['serviceid'])
        ->where('tblmodule_configuration.setting_name', 'configoption22')
        ->select('tblmodule_configuration.value')
        ->get();

    if (!empty($AddonsBouquets)) {
        foreach ($AddonsBouquets as $AddonsBouquet) {
            $Bouquets = "[" . NXTreplaceBraces($Bouquets) . "," . NXTreplaceBraces($AddonsBouquet->value) . "]";
        }
        $ReturnData = $Bouquets;
    }
    return $ReturnData;
}

/* StreamMAG to other */

function NXTStreamlinetoStreamline($params)
{
    $maxconnection = $params['configoption4'];
    $is_trial = ($params['configoption5'] == 'Yes') ? '1' : '0';
    $is_isplock = ($params['configoption6'] == 'Yes') ? '1' : '0';
    $is_restreamer = ($params['configoption7'] == 'Yes') ? '1' : '0';
    $Bouquets = isset($params['customfields']['Select Bouquets']) && !empty($params['customfields']['Select Bouquets']) ? trim($params['customfields']['Select Bouquets']) : $params['configoption10'];
    $CheckBouquets = NXT_ProductAddonsPack($params, $Bouquets);
    if ($CheckBouquets != "") {
        $Bouquets = $CheckBouquets;
    }
    $syn_expiry = $params['configoption17'];
    $trial_period = ($params['configoption18'] != 0) ? '+' . $params['configoption18'] . ' hours' : '+24 hours';
    $billing_months = $params['configoption21'];
    $tblhostingdetails = Capsule::table('tblhosting')->where('id', '=', $params["serviceid"])->get();
    $nextduedate = $tblhostingdetails[0]->nextduedate;
    $serviceid = $tblhostingdetails[0]->id;

    $con = NXTXtreamCodeTestConnection($params['pid']);

    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    if (isset($returndata['configoption_field_name']) && !empty($returndata['configoption_field_name'])) {
        if (isset($params['configoptions']) && !empty($params['configoptions'])) {
            foreach ($params['configoptions'] as $configname => $configvalue) {
                if ($configname == $returndata['configoption_field_name']) {
                    $maxconnection += $configvalue;
                }
            }
        }
    }
    // Collecting parameters
    $username = $params["username"];
    $password = $params["password"];
    $reseller_notes = $returndata['common_identifier'] . $serviceid;

    // First checking if user already exist with reqeuest username  
    $result = mysqli_query($con, "SELECT username,id FROM users WHERE username='$username' ");
    if (!$result) {
        $radiussqlerror = mysqli_error($con);
        NXT_WHMCSReconnect();
        return "XtreamCode Database Query Error: " . $radiussqlerror;
    }
    if (mysqli_num_rows($result) > 0) {
        $xcuser = mysqli_fetch_assoc($result);
        $xtreamuserid = $xcuser['id'];
        $checkmagdevice = $params['customfields'][$returndata['checkmagdevice']];
        if (isset($checkmagdevice) && !empty($checkmagdevice) && $checkmagdevice == 'on') {
            if (!empty($params['customfields'][$returndata['custom_field_mag']])) {
                //Check If the MAG Exists in X.C Panel 
                $macexists = NXT_CheckMAG($params['customfields'][$returndata['custom_field_mag']], $con);
                if (isset($macexists) && !empty($macexists)) {
                    return NXT_UpdateMAG($params);
                } else {
                    return NXT_AddMAG($params, $params['customfields'][$returndata['custom_field_mag']]);
                }
            } else {
                logModuleCall(
                    'XtreamCode',
                    __FUNCTION__,
                    'MAG Address field is requied for (Only MAG and Check MAG)',
                    'error'
                );
                return 'MAG Address field required, if you choose only MAG device';
            }
        } else {
            $expdate = 'NULL';
            if ($is_trial == 1 && $nextduedate != '0000-00-00') {
                $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
            } else {
                if ($syn_expiry == 'on' && $nextduedate != '0000-00-00') {
                    $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
                } elseif ($is_trial == 1) {
                    $expdate = strtotime(date("Y-m-d H:i:s", strtotime($trial_period)));
                } elseif ($is_trial == 0 && $nextduedate == '0000-00-00' && $billing_months != "" && $billing_months != 0) {
                    $usersresult = mysqli_query($con, "SELECT id, exp_date FROM users WHERE username='$username' ");
                    $userxtremcode = mysqli_fetch_assoc($usersresult);
                    $expdatefromxtreamcode = date('Y-m-d H:i:s', $userxtremcode['exp_date']);
                    if (strtotime(date('Y-m-d H:i:s')) > $userxtremcode['exp_date']) {
                        $effectiveDate = date('Y-m-d H:i:s', strtotime("+" . $billing_months . " months", strtotime(date('Y-m-d H:i:s'))));
                    } else {
                        $effectiveDate = date('Y-m-d H:i:s', strtotime("+" . $billing_months . " months", strtotime($expdatefromxtreamcode)));
                    }
                    $expdate = strtotime($effectiveDate);
                }
            }
            if (NXTGetConfigXtreamDetailsHourDiff() != "" && $expdate != "NULL") {
                $expdate = $expdate + 60 * 60 * NXTGetConfigXtreamDetailsHourDiff();
            }
            $query = "UPDATE users SET `bouquet`='$Bouquets',`exp_date`=$expdate,enabled='1',`is_trial`='$is_trial',`max_connections`='$maxconnection',`is_restreamer`='$is_restreamer',`is_isplock`='$is_isplock' WHERE id='$xtreamuserid'";
            $result = mysqli_query($con, $query);
            if (!$result) {
                $radiussqlerror = mysqli_error($con);
                NXT_WHMCSReconnect();
                return "XtreamCode Database Query Error: " . $radiussqlerror;
            }
            if (!empty($params['customfields'][$returndata['custom_field_mag']])) {
                //Check If the MAG Exists in X.C Panel 
                $macexists = NXT_CheckMAG($params['customfields'][$returndata['custom_field_mag']], $con);
                if (isset($macexists) && !empty($macexists)) {
                    return NXT_UpdateMAG($params);
                } else {
                    return NXT_AddMAG($params, $params['customfields'][$returndata['custom_field_mag']]);
                }
            } else {
                $result = mysqli_query($con, "SELECT * FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1'");
                $pairid = mysqli_fetch_assoc($result);
                $xtreamuserid = $pairid['id'];
                if (isset($pairid['id']) && !empty($pairid['id'])) {
                    mysqli_query($con, "DELETE FROM `mag_devices` WHERE user_id='" . $pairid['id'] . "'");
                    $result = mysqli_query($con, "DELETE FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1'");
                    mysqli_query($con, "UPDATE users SET pair_id='' WHERE reseller_notes='$reseller_notes'");
                }
            }
            NXT_WHMCSReconnect();
            logModuleCall(
                'XtreamCode',
                __FUNCTION__,
                'Upgrade Account: ' . $username,
                'success'
            );
            return "success";
        }
    } else {
        $checkmagdevice = $params['customfields'][$returndata['checkmagdevice']];
        if (isset($checkmagdevice) && !empty($checkmagdevice) && $checkmagdevice == 'on') {
            if (!empty($params['customfields'][$returndata['custom_field_mag']])) {
                //Check If the MAG Exists in X.C Panel 
                $macexists = NXT_CheckMAG($params['customfields'][$returndata['custom_field_mag']], $con);
                if (isset($macexists) && !empty($macexists)) {
                    return NXT_UpdateMAG($params);
                } else {
                    return NXT_AddMAG($params, $params['customfields'][$returndata['custom_field_mag']]);
                }
            } else {
                logModuleCall(
                    'XtreamCode',
                    __FUNCTION__,
                    'Streamline not found in X.C panel',
                    'error'
                );
            }
        } else {
            return NXT_CreateAccount($params);
        }
    }
    return "success";
}

function NXTStreamlinetoStreamlineonly($params)
{
    $maxconnection = $params['configoption4'];
    $is_trial = ($params['configoption5'] == 'Yes') ? '1' : '0';
    $is_isplock = ($params['configoption6'] == 'Yes') ? '1' : '0';
    $is_restreamer = ($params['configoption7'] == 'Yes') ? '1' : '0';
    $Bouquets = isset($params['customfields']['Select Bouquets']) && !empty($params['customfields']['Select Bouquets']) ? trim($params['customfields']['Select Bouquets']) : $params['configoption10'];
    $CheckBouquets = NXT_ProductAddonsPack($params, $Bouquets);
    if ($CheckBouquets != "") {
        $Bouquets = $CheckBouquets;
    }
    $syn_expiry = $params['configoption17'];
    $trial_period = ($params['configoption18'] != 0) ? '+' . $params['configoption18'] . ' hours' : '+24 hours';
    $billing_months = $params['configoption21'];
    $tblhostingdetails = Capsule::table('tblhosting')->where('id', '=', $params["serviceid"])->get();
    $nextduedate = $tblhostingdetails[0]->nextduedate;
    $serviceid = $tblhostingdetails[0]->id;
    $username = $params["username"];
    $password = $params["password"];

    $con = NXTXtreamCodeTestConnection($params['pid']);

    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    if (isset($returndata['configoption_field_name']) && !empty($returndata['configoption_field_name'])) {
        if (isset($params['configoptions']) && !empty($params['configoptions'])) {
            foreach ($params['configoptions'] as $configname => $configvalue) {
                if ($configname == $returndata['configoption_field_name']) {
                    $maxconnection += $configvalue;
                }
            }
        }
    }
    $reseller_notes = $returndata['common_identifier'] . $serviceid;
    /*
     * Check the MAG for the Stream 
     * If exists then remove MAG Device first then update streamline
     */

    $result = mysqli_query($con, "SELECT * FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1'");
    // First checking if user already exist with reqeuest username   
    if (mysqli_num_rows($result) != 0) {
        $pairid = mysqli_fetch_assoc($result);
        if (isset($pairid['id']) && !empty($pairid['pair_id'])) {
            mysqli_query($con, "DELETE FROM `mag_devices` WHERE user_id='" . $pairid['id'] . "'");
            $result = mysqli_query($con, "DELETE FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1'");
            mysqli_query($con, "UPDATE users SET pair_id='' WHERE reseller_notes='$reseller_notes'");
        }
    }
    /* Update Streamline */
    $users = mysqli_query($con, "SELECT username,id FROM users WHERE username='$username' ");
    if (mysqli_num_rows($users) != 0) {
        $userspairid = mysqli_fetch_assoc($users);
        $xtreamuserid = $userspairid['id'];
        $expdate = 'NULL';
        if ($is_trial == 1 && $nextduedate != '0000-00-00') {
            $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
        } else {
            if ($syn_expiry == 'on' && $nextduedate != '0000-00-00') {
                $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
            } elseif ($is_trial == 1) {
                $expdate = strtotime(date("Y-m-d H:i:s", strtotime($trial_period)));
            } elseif ($is_trial == 0 && $nextduedate == '0000-00-00' && $billing_months != "" && $billing_months != 0) {
                $usersresult = mysqli_query($con, "SELECT id, exp_date FROM users WHERE username='$username' ");
                $userxtremcode = mysqli_fetch_assoc($usersresult);
                $expdatefromxtreamcode = date('Y-m-d H:i:s', $userxtremcode['exp_date']);
                if (strtotime(date('Y-m-d H:i:s')) > $userxtremcode['exp_date']) {
                    $effectiveDate = date('Y-m-d H:i:s', strtotime("+" . $billing_months . " months", strtotime(date('Y-m-d H:i:s'))));
                } else {
                    $effectiveDate = date('Y-m-d H:i:s', strtotime("+" . $billing_months . " months", strtotime($expdatefromxtreamcode)));
                }
                $expdate = strtotime($effectiveDate);
            }
        }
        if (NXTGetConfigXtreamDetailsHourDiff() != "" && $expdate != "NULL") {
            $expdate = $expdate + 60 * 60 * NXTGetConfigXtreamDetailsHourDiff();
        }
        $query = "UPDATE users SET `bouquet`='$Bouquets',`exp_date`=$expdate,enabled='1',`is_trial`='$is_trial',`max_connections`='$maxconnection',`is_restreamer`='$is_restreamer',`is_isplock`='$is_isplock' WHERE id='$xtreamuserid'";
        $result = mysqli_query($con, $query);
        if (!$result) {
            $radiussqlerror = mysqli_error($con);
            NXT_WHMCSReconnect();
            return "XtreamCode Database Query Error: " . $radiussqlerror;
        }
        NXT_WHMCSReconnect();
        logModuleCall(
            'XtreamCode',
            __FUNCTION__,
            'Upgrade Account: ' . $username,
            'success'
        );
    }
    return "success";
}

function NXTStreamlinetoMagdevice($params)
{
    $serviceid = $params["serviceid"];
    $username = $params["username"];
    $con = NXTXtreamCodeTestConnection($params['pid']);

    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    if (isset($returndata['configoption_field_name']) && !empty($returndata['configoption_field_name'])) {
        if (isset($params['configoptions']) && !empty($params['configoptions'])) {
            foreach ($params['configoptions'] as $configname => $configvalue) {
                if ($configname == $returndata['configoption_field_name']) {
                    $maxconnection += $configvalue;
                }
            }
        }
    }
    $reseller_notes = $returndata['common_identifier'] . $serviceid;

    $result = mysqli_query($con, "SELECT * FROM users WHERE username='$username' ");

    if (mysqli_num_rows($result) != 0) {
        /*
         * Update table MAG devie and User for the MAG to make is non pair device Means only MAG device
         */
        $result = mysqli_query($con, "DELETE FROM users WHERE username='$username' ");
        mysqli_query($con, "UPDATE users SET pair_id='' WHERE reseller_notes='$reseller_notes' AND is_mag='1'");

        if (!$result) {
            NXT_WHMCSReconnect();
            return "XtreamCode Database Query Error: " . mysqli_error($con);
        }
    }
    if (!empty($params['customfields'][$returndata['custom_field_mag']])) {
        //Check If the MAG Exists in X.C Panel 
        $macexists = NXT_CheckMAG($params['customfields'][$returndata['custom_field_mag']], $con);
        if (isset($macexists) && !empty($macexists)) {
            return NXT_UpdateMAG($params);
        } else {
            return NXT_AddMAG($params, $params['customfields'][$returndata['custom_field_mag']]);
        }
    } else {
        logModuleCall(
            'XtreamCode',
            __FUNCTION__,
            'MAG Address field is requied for (Only MAG and Check MAG)',
            'error'
        );
        return 'MAG Address field required, if you choose only MAG device';
    }
    return 'success';
}

function NXTStreamlinetoStreamlineeng($params)
{
    $maxconnection = $params['configoption4'];
    $is_trial = ($params['configoption5'] == 'Yes') ? '1' : '0';
    $is_isplock = ($params['configoption6'] == 'Yes') ? '1' : '0';
    $is_restreamer = ($params['configoption7'] == 'Yes') ? '1' : '0';
    $Bouquets = isset($params['customfields']['Select Bouquets']) && !empty($params['customfields']['Select Bouquets']) ? trim($params['customfields']['Select Bouquets']) : $params['configoption10'];
    $CheckBouquets = NXT_ProductAddonsPack($params, $Bouquets);
    if ($CheckBouquets != "") {
        $Bouquets = $CheckBouquets;
    }
    $syn_expiry = $params['configoption17'];
    $trial_period = ($params['configoption18'] != 0) ? '+' . $params['configoption18'] . ' hours' : '+24 hours';
    $billing_months = $params['configoption21'];
    $tblhostingdetails = Capsule::table('tblhosting')->where('id', '=', $params["serviceid"])->get();
    $nextduedate = $tblhostingdetails[0]->nextduedate;
    $serviceid = $tblhostingdetails[0]->id;

    $con = NXTXtreamCodeTestConnection($params['pid']);

    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    if (isset($returndata['configoption_field_name']) && !empty($returndata['configoption_field_name'])) {
        if (isset($params['configoptions']) && !empty($params['configoptions'])) {
            foreach ($params['configoptions'] as $configname => $configvalue) {
                if ($configname == $returndata['configoption_field_name']) {
                    $maxconnection += $configvalue;
                }
            }
        }
    }
    // Collecting parameters
    $username = $params["username"];
    $password = $params["password"];
    $reseller_notes = $returndata['common_identifier'] . $serviceid;

    $result = mysqli_query($con, "SELECT * FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1'");
    // First checking if user already exist with reqeuest username   
    if (mysqli_num_rows($result) != 0) {
        $pairid = mysqli_fetch_assoc($result);
        if (isset($pairid['id']) && !empty($pairid['id'])) {
            mysqli_query($con, "DELETE FROM `mag_devices` WHERE user_id='" . $pairid['id'] . "'");
            $result = mysqli_query($con, "DELETE FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1'");
            mysqli_query($con, "UPDATE users SET pair_id='' WHERE reseller_notes='$reseller_notes'");
        }
    }

    // First checking if user already exist with reqeuest username  
    $result = mysqli_query($con, "SELECT username,id FROM users WHERE username='$username' ");
    if (!$result) {
        $radiussqlerror = mysqli_error($con);
        NXT_WHMCSReconnect();
        return "XtreamCode Database Query Error: " . $radiussqlerror;
    }
    if (mysqli_num_rows($result) > 0) {
        $xcuser = mysqli_fetch_assoc($result);
        $xtreamuserid = $xcuser['id'];
        $checkengdevice = $params['customfields'][$returndata['checkengdevice']];
        if (isset($checkengdevice) && !empty($checkengdevice) && $checkengdevice == 'on') {
            if (!empty($params['customfields'][$returndata['custom_field_eng']])) {
                //Check If the MAG Exists in X.C Panel 
                $macexists = NXT_CheckENG($params['customfields'][$returndata['custom_field_eng']], $con);
                if (isset($macexists) && !empty($macexists)) {
                    return NXT_UpdateENG($params);
                } else {
                    return NXT_AddENG($params, $params['customfields'][$returndata['custom_field_eng']]);
                }
            } else {
                logModuleCall(
                    'XtreamCode',
                    __FUNCTION__,
                    'MAG Address field is requied for (Only E2 Device and Check E2 Device)',
                    'error'
                );
                return 'MAG Address field required, if you choose only MAG device';
            }
        } else {
            $expdate = 'NULL';
            if ($is_trial == 1 && $nextduedate != '0000-00-00') {
                $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
            } else {
                if ($syn_expiry == 'on' && $nextduedate != '0000-00-00') {
                    $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
                } elseif ($is_trial == 1) {
                    $expdate = strtotime(date("Y-m-d H:i:s", strtotime($trial_period)));
                } elseif ($is_trial == 0 && $nextduedate == '0000-00-00' && $billing_months != "" && $billing_months != 0) {
                    $usersresult = mysqli_query($con, "SELECT id, exp_date FROM users WHERE username='$username' ");
                    $userxtremcode = mysqli_fetch_assoc($usersresult);
                    $expdatefromxtreamcode = date('Y-m-d H:i:s', $userxtremcode['exp_date']);
                    if (strtotime(date('Y-m-d H:i:s')) > $userxtremcode['exp_date']) {
                        $effectiveDate = date('Y-m-d H:i:s', strtotime("+" . $billing_months . " months", strtotime(date('Y-m-d H:i:s'))));
                    } else {
                        $effectiveDate = date('Y-m-d H:i:s', strtotime("+" . $billing_months . " months", strtotime($expdatefromxtreamcode)));
                    }
                    $expdate = strtotime($effectiveDate);
                }
            }
            if (NXTGetConfigXtreamDetailsHourDiff() != "" && $expdate != "NULL") {
                $expdate = $expdate + 60 * 60 * NXTGetConfigXtreamDetailsHourDiff();
            }
            $query = "UPDATE users SET `bouquet`='$Bouquets',`exp_date`=$expdate,enabled='1',`is_trial`='$is_trial',`max_connections`='$maxconnection',`is_restreamer`='$is_restreamer',`is_isplock`='$is_isplock' WHERE id='$xtreamuserid'";
            $result = mysqli_query($con, $query);
            if (!$result) {
                $radiussqlerror = mysqli_error($con);
                NXT_WHMCSReconnect();
                return "XtreamCode Database Query Error: " . $radiussqlerror;
            }
            if (!empty($params['customfields'][$returndata['custom_field_eng']])) {
                //Check If the MAG Exists in X.C Panel 
                $macexists = NXT_CheckENG($params['customfields'][$returndata['custom_field_eng']], $con);
                if (isset($macexists) && !empty($macexists)) {
                    return NXT_UpdateENG($params);
                } else {
                    return NXT_AddENG($params, $params['customfields'][$returndata['custom_field_eng']]);
                }
            }
            NXT_WHMCSReconnect();
            logModuleCall(
                'XtreamCode',
                __FUNCTION__,
                'Upgrade Account: ' . $username,
                'success'
            );
            return "success";
        }
    } else {
        if (!empty($params['customfields'][$returndata['custom_field_eng']])) {
            //Check If the MAG Exists in X.C Panel 
            $macexists = NXT_CheckENG($params['customfields'][$returndata['custom_field_eng']], $con);
            if (isset($macexists) && !empty($macexists)) {
                return NXT_UpdateENG($params);
            } else {
                return NXT_AddENG($params, $params['customfields'][$returndata['custom_field_eng']]);
            }
        }
        logModuleCall(
            'XtreamCode',
            __FUNCTION__,
            'Streamline not found in X.C panel',
            'error'
        );
    }
    return "success";
}

function NXTStreamlinetoEngdevice($params)
{
    $serviceid = $params["serviceid"];
    $username = $params["username"];
    $con = NXTXtreamCodeTestConnection($params['pid']);

    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }

    $reseller_notes = $returndata['common_identifier'] . $serviceid;
    $result = mysqli_query($con, "SELECT * FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1'");
    // First checking if user already exist with reqeuest username   
    if (mysqli_num_rows($result) != 0) {
        $pairid = mysqli_fetch_assoc($result);
        if (isset($pairid['id']) && !empty($pairid['id'])) {
            mysqli_query($con, "DELETE FROM `mag_devices` WHERE user_id='" . $pairid['id'] . "'");
            $result = mysqli_query($con, "DELETE FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1'");
            mysqli_query($con, "UPDATE users SET pair_id='' WHERE reseller_notes='$reseller_notes'");
        }
    }

    $result = mysqli_query($con, "SELECT * FROM users WHERE username='$username' ");

    if (mysqli_num_rows($result) != 0) {
        /*  Update table MAG devie and User for the MAG to make is non pair device Means only MAG device */
        $result = mysqli_query($con, "DELETE FROM users WHERE username='$username' ");
        /* It will update e2device pair id if exists */
        mysqli_query($con, "UPDATE users SET pair_id='' WHERE reseller_notes='$reseller_notes' AND is_e2='1'");

        if (!$result) {
            NXT_WHMCSReconnect();
            return "XtreamCode Database Query Error: " . mysqli_error($con);
        }
    }
    if (!empty($params['customfields'][$returndata['custom_field_eng']])) {
        //Check If the MAG Exists in X.C Panel 
        $macexists = NXT_CheckENG($params['customfields'][$returndata['custom_field_eng']], $con);
        if (isset($macexists) && !empty($macexists)) {
            return NXT_UpdateENG($params);
        } else {
            return NXT_AddENG($params, $params['customfields'][$returndata['custom_field_eng']]);
        }
    } else {
        logModuleCall(
            'XtreamCode',
            __FUNCTION__,
            'MAG Address field is requied for (Only E2 Device)',
            'error'
        );
        return 'E2 Device Address field required, if you choose only E2 device';
    }
    return 'success';
}

/* Streamlineonly to other */

function NXTStreamlineonlytoStreamlineonly($params)
{
    $maxconnection = $params['configoption4'];
    $is_trial = ($params['configoption5'] == 'Yes') ? '1' : '0';
    $is_isplock = ($params['configoption6'] == 'Yes') ? '1' : '0';
    $is_restreamer = ($params['configoption7'] == 'Yes') ? '1' : '0';
    $Bouquets = isset($params['customfields']['Select Bouquets']) && !empty($params['customfields']['Select Bouquets']) ? trim($params['customfields']['Select Bouquets']) : $params['configoption10'];
    $CheckBouquets = NXT_ProductAddonsPack($params, $Bouquets);
    if ($CheckBouquets != "") {
        $Bouquets = $CheckBouquets;
    }
    $syn_expiry = $params['configoption17'];

    if ($is_trial == 1) {
        $trial_period = ($params['configoption18'] != 0) ? '+' . $params['configoption18'] . ' hours' : '+24 hours';
    } else {
        $day_period = ($params['configoption18'] != 0) ? '+' . $params['configoption18'] . ' days' : '+30 days';
    }

    $billing_months = $params['configoption21'];
    $tblhostingdetails = Capsule::table('tblhosting')->where('id', '=', $params["serviceid"])->get();
    $nextduedate = $tblhostingdetails[0]->nextduedate;
    $serviceid = $tblhostingdetails[0]->id;
    $username = $params["username"];
    $password = $params["password"];

    $con = NXTXtreamCodeTestConnection($params['pid']);

    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    if (isset($returndata['configoption_field_name']) && !empty($returndata['configoption_field_name'])) {
        if (isset($params['configoptions']) && !empty($params['configoptions'])) {
            foreach ($params['configoptions'] as $configname => $configvalue) {
                if ($configname == $returndata['configoption_field_name']) {
                    $maxconnection += $configvalue;
                }
            }
        }
    }
    $reseller_notes = $returndata['common_identifier'] . $serviceid;

    $result = mysqli_query($con, "SELECT * FROM users WHERE username='$username'  ");

    if (mysqli_num_rows($result) != 0) {

        $pairid = mysqli_fetch_assoc($result);
        $xtreamuserid = $pairid['id'];
        $expdate = 'NULL';
        if ($is_trial == 1 && $nextduedate != '0000-00-00') {
            $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
        } else {
            if ($syn_expiry == 'on' && $nextduedate != '0000-00-00') {
                $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
                if ($is_trial == 0) {
                    $usersresult = mysqli_query($con, "SELECT id, exp_date FROM users WHERE username='$username' ");
                    $userxtremcode = mysqli_fetch_assoc($usersresult);
                    $expdatefromxtreamcode = date('Y-m-d H:i:s', $userxtremcode['exp_date']);
                    if (strtotime(date('Y-m-d H:i:s')) > $userxtremcode['exp_date']) {
                        $effectiveDate = date('Y-m-d H:i:s', strtotime($day_period, strtotime(date('Y-m-d H:i:s'))));
                    } else {
                        $effectiveDate = date('Y-m-d H:i:s', strtotime($day_period, strtotime($expdatefromxtreamcode)));
                    }
                    $expdate = strtotime($effectiveDate);
                }
            } elseif ($is_trial == 1) {
                $expdate = strtotime(date("Y-m-d H:i:s", strtotime($trial_period)));
            } elseif ($is_trial == 0 && $nextduedate == '0000-00-00' && $billing_months != "" && $billing_months != 0) {
                $usersresult = mysqli_query($con, "SELECT id, exp_date FROM users WHERE username='$username' ");
                $userxtremcode = mysqli_fetch_assoc($usersresult);
                $expdatefromxtreamcode = date('Y-m-d H:i:s', $userxtremcode['exp_date']);
                if (strtotime(date('Y-m-d H:i:s')) > $userxtremcode['exp_date']) {
                    $effectiveDate = date('Y-m-d H:i:s', strtotime("+" . $billing_months . " months", strtotime(date('Y-m-d H:i:s'))));
                } else {
                    $effectiveDate = date('Y-m-d H:i:s', strtotime("+" . $billing_months . " months", strtotime($expdatefromxtreamcode)));
                }
                $expdate = strtotime($effectiveDate);
            } elseif ($is_trial == 0 && $nextduedate != '0000-00-00') {

                $usersresult = mysqli_query($con, "SELECT id, exp_date FROM users WHERE username='$username' ");
                $userxtremcode = mysqli_fetch_assoc($usersresult);
                $expdatefromxtreamcode = date('Y-m-d H:i:s', $userxtremcode['exp_date']);
                if (strtotime(date('Y-m-d H:i:s')) > $userxtremcode['exp_date']) {
                    $effectiveDate = date('Y-m-d H:i:s', strtotime($day_period, strtotime(date('Y-m-d H:i:s'))));
                } else {
                    $effectiveDate = date('Y-m-d H:i:s', strtotime($day_period, strtotime($expdatefromxtreamcode)));
                }
                $expdate = strtotime($effectiveDate);
            }
        }

        if (NXTGetConfigXtreamDetailsHourDiff() != "" && $expdate != "NULL") {
            $expdate = $expdate + 60 * 60 * NXTGetConfigXtreamDetailsHourDiff();
        }

        if ($is_trial == 0 && $params['configoption18'] > 0 && !empty($params['configoption18'])) {
            Capsule::table('tblhosting')->where('id', $serviceid)->update(['nextduedate' => date("Y-m-d", $expdate), 'nextinvoicedate' => date("Y-m-d", $expdate),]);
        }

        $query = "UPDATE users SET `bouquet`='$Bouquets',`exp_date`=$expdate,enabled='1',`is_trial`='$is_trial',`max_connections`='$maxconnection',`is_restreamer`='$is_restreamer',`is_isplock`='$is_isplock' WHERE id='$xtreamuserid'";
        $result = mysqli_query($con, $query);
        
        if (!$result) {
            $radiussqlerror = mysqli_error($con);
            NXT_WHMCSReconnect();
            return "XtreamCode Database Query Error: " . $radiussqlerror;
        }
        NXT_WHMCSReconnect();
        logModuleCall(
            'XtreamCode',
            __FUNCTION__,
            'Upgrade Account: ' . $username,
            'success'
        );
        return "success";
    } else {
        NXT_WHMCSReconnect();
        /* Run Create function */
        return NXT_CreateAccount($params);
    }
}

function NXTStreamlineonlytoStreamline($params)
{
    $maxconnection = $params['configoption4'];
    $is_trial = ($params['configoption5'] == 'Yes') ? '1' : '0';
    $is_isplock = ($params['configoption6'] == 'Yes') ? '1' : '0';
    $is_restreamer = ($params['configoption7'] == 'Yes') ? '1' : '0';
    $Bouquets = isset($params['customfields']['Select Bouquets']) && !empty($params['customfields']['Select Bouquets']) ? trim($params['customfields']['Select Bouquets']) : $params['configoption10'];
    $CheckBouquets = NXT_ProductAddonsPack($params, $Bouquets);
    if ($CheckBouquets != "") {
        $Bouquets = $CheckBouquets;
    }
    $syn_expiry = $params['configoption17'];
    $trial_period = ($params['configoption18'] != 0) ? '+' . $params['configoption18'] . ' hours' : '+24 hours';
    $billing_months = $params['configoption21'];
    $tblhostingdetails = Capsule::table('tblhosting')->where('id', '=', $params["serviceid"])->get();
    $nextduedate = $tblhostingdetails[0]->nextduedate;
    $serviceid = $tblhostingdetails[0]->id;

    $con = NXTXtreamCodeTestConnection($params['pid']);

    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    if (isset($returndata['configoption_field_name']) && !empty($returndata['configoption_field_name'])) {
        if (isset($params['configoptions']) && !empty($params['configoptions'])) {
            foreach ($params['configoptions'] as $configname => $configvalue) {
                if ($configname == $returndata['configoption_field_name']) {
                    $maxconnection += $configvalue;
                }
            }
        }
    }
    // Collecting parameters
    $username = $params["username"];
    $password = $params["password"];
    $reseller_notes = $returndata['common_identifier'] . $serviceid;

    // First checking if user already exist with reqeuest username  
    $result = mysqli_query($con, "SELECT username,id FROM users WHERE username='$username' ");
    if (!$result) {
        $radiussqlerror = mysqli_error($con);
        NXT_WHMCSReconnect();
        return "XtreamCode Database Query Error: " . $radiussqlerror;
    }
    if (mysqli_num_rows($result) > 0) {
        $xcuser = mysqli_fetch_assoc($result);
        $xtreamuserid = $xcuser['id'];
        $checkmagdevice = $params['customfields'][$returndata['checkmagdevice']];
        if (isset($checkmagdevice) && !empty($checkmagdevice) && $checkmagdevice == 'on') {
            if (!empty($params['customfields'][$returndata['custom_field_mag']])) {
                //Check If the MAG Exists in X.C Panel 
                $macexists = NXT_CheckMAG($params['customfields'][$returndata['custom_field_mag']], $con);
                if (isset($macexists) && !empty($macexists)) {
                    return NXT_UpdateMAG($params);
                } else {
                    return NXT_AddMAG($params, $params['customfields'][$returndata['custom_field_mag']]);
                }
            } else {
                logModuleCall(
                    'XtreamCode',
                    __FUNCTION__,
                    'MAG Address field is requied for (Only MAG and Check MAG)',
                    'error'
                );
                return 'MAG Address field required, if you choose only MAG device';
            }
        } else {
            $expdate = 'NULL';
            if ($is_trial == 1 && $nextduedate != '0000-00-00') {
                $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
            } else {
                if ($syn_expiry == 'on' && $nextduedate != '0000-00-00') {
                    $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
                } elseif ($is_trial == 1) {
                    $expdate = strtotime(date("Y-m-d H:i:s", strtotime($trial_period)));
                } elseif ($is_trial == 0 && $nextduedate == '0000-00-00' && $billing_months != "" && $billing_months != 0) {
                    $usersresult = mysqli_query($con, "SELECT id, exp_date FROM users WHERE username='$username' ");
                    $userxtremcode = mysqli_fetch_assoc($usersresult);
                    $expdatefromxtreamcode = date('Y-m-d H:i:s', $userxtremcode['exp_date']);
                    if (strtotime(date('Y-m-d H:i:s')) > $userxtremcode['exp_date']) {
                        $effectiveDate = date('Y-m-d H:i:s', strtotime("+" . $billing_months . " months", strtotime(date('Y-m-d H:i:s'))));
                    } else {
                        $effectiveDate = date('Y-m-d H:i:s', strtotime("+" . $billing_months . " months", strtotime($expdatefromxtreamcode)));
                    }
                    $expdate = strtotime($effectiveDate);
                }
            }
            if (NXTGetConfigXtreamDetailsHourDiff() != "" && $expdate != "NULL") {
                $expdate = $expdate + 60 * 60 * NXTGetConfigXtreamDetailsHourDiff();
            }
            $query = "UPDATE users SET `bouquet`='$Bouquets',`exp_date`=$expdate,enabled='1',`is_trial`='$is_trial',`max_connections`='$maxconnection',`is_restreamer`='$is_restreamer',`is_isplock`='$is_isplock' WHERE id='$xtreamuserid'";
            $result = mysqli_query($con, $query);
            if (!$result) {
                $radiussqlerror = mysqli_error($con);
                NXT_WHMCSReconnect();
                return "XtreamCode Database Query Error: " . $radiussqlerror;
            }
            if (!empty($params['customfields'][$returndata['custom_field_mag']])) {
                //Check If the MAG Exists in X.C Panel 
                $macexists = NXT_CheckMAG($params['customfields'][$returndata['custom_field_mag']], $con);
                if (isset($macexists) && !empty($macexists)) {
                    return NXT_UpdateMAG($params);
                } else {
                    return NXT_AddMAG($params, $params['customfields'][$returndata['custom_field_mag']]);
                }
            }
            NXT_WHMCSReconnect();
            logModuleCall(
                'XtreamCode',
                __FUNCTION__,
                'Upgrade Account: ' . $username,
                'success'
            );
            return "success";
        }
    } else {
        logModuleCall(
            'XtreamCode',
            __FUNCTION__,
            'Streamline not found in X.C panel',
            'error'
        );
    }
    return "success";
}

function NXTStreamlineonlytoMagdevice($params)
{
    /* First remove the Streamlineonly */
    $serviceid = $params["serviceid"];
    $username = $params["username"];

    $con = NXTXtreamCodeTestConnection($params['pid']);

    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    $reseller_notes = $returndata['common_identifier'] . $serviceid;
    $result = mysqli_query($con, "SELECT * FROM users WHERE username='$username' ");

    if (mysqli_num_rows($result) != 0) {
        $result = mysqli_query($con, "DELETE FROM users WHERE username='$username' ");
        if (!$result) {
            NXT_WHMCSReconnect();
            return "XtreamCode Database Query Error: " . mysqli_error($con);
        }
    }
    NXT_WHMCSReconnect();
    /* Run Create function */
    if (!empty($params['customfields'][$returndata['custom_field_mag']])) {
        $magaddress = $params['customfields'][$returndata['custom_field_mag']];
    } else {
        $magaddress = '00:00:00:00:00:00';
    }
    return NXT_AddMAG($params, $magaddress);
}

function NXTStreamlineonlytoStreamlineeng($params)
{
    $maxconnection = $params['configoption4'];
    $is_trial = ($params['configoption5'] == 'Yes') ? '1' : '0';
    $is_isplock = ($params['configoption6'] == 'Yes') ? '1' : '0';
    $is_restreamer = ($params['configoption7'] == 'Yes') ? '1' : '0';
    $Bouquets = isset($params['customfields']['Select Bouquets']) && !empty($params['customfields']['Select Bouquets']) ? trim($params['customfields']['Select Bouquets']) : $params['configoption10'];
    $CheckBouquets = NXT_ProductAddonsPack($params, $Bouquets);
    if ($CheckBouquets != "") {
        $Bouquets = $CheckBouquets;
    }
    $syn_expiry = $params['configoption17'];
    $trial_period = ($params['configoption18'] != 0) ? '+' . $params['configoption18'] . ' hours' : '+24 hours';
    $billing_months = $params['configoption21'];
    $tblhostingdetails = Capsule::table('tblhosting')->where('id', '=', $params["serviceid"])->get();
    $nextduedate = $tblhostingdetails[0]->nextduedate;
    $serviceid = $tblhostingdetails[0]->id;

    $con = NXTXtreamCodeTestConnection($params['pid']);

    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    if (isset($returndata['configoption_field_name']) && !empty($returndata['configoption_field_name'])) {
        if (isset($params['configoptions']) && !empty($params['configoptions'])) {
            foreach ($params['configoptions'] as $configname => $configvalue) {
                if ($configname == $returndata['configoption_field_name']) {
                    $maxconnection += $configvalue;
                }
            }
        }
    }
    // Collecting parameters
    $username = $params["username"];
    $password = $params["password"];
    $reseller_notes = $returndata['common_identifier'] . $serviceid;

    // First checking if user already exist with reqeuest username  
    $result = mysqli_query($con, "SELECT username,id FROM users WHERE username='$username' ");
    if (!$result) {
        $radiussqlerror = mysqli_error($con);
        NXT_WHMCSReconnect();
        return "XtreamCode Database Query Error: " . $radiussqlerror;
    }
    if (mysqli_num_rows($result) > 0) {
        $xcuser = mysqli_fetch_assoc($result);
        $xtreamuserid = $xcuser['id'];
        $checkengdevice = $params['customfields'][$returndata['checkengdevice']];
        if (isset($checkengdevice) && !empty($checkengdevice) && $checkengdevice == 'on') {
            if (!empty($params['customfields'][$returndata['custom_field_eng']])) {
                //Check If the MAG Exists in X.C Panel 
                $macexists = NXT_CheckENG($params['customfields'][$returndata['custom_field_eng']], $con);
                if (isset($macexists) && !empty($macexists)) {
                    return NXT_UpdateENG($params);
                } else {
                    return NXT_AddENG($params, $params['customfields'][$returndata['custom_field_eng']]);
                }
            } else {
                logModuleCall(
                    'XtreamCode',
                    __FUNCTION__,
                    'MAG Address field is requied for (Only E2 Device and Check E2 Device)',
                    'error'
                );
                return 'MAG Address field required, if you choose only MAG device';
            }
        } else {
            $expdate = 'NULL';
            if ($is_trial == 1 && $nextduedate != '0000-00-00') {
                $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
            } else {
                if ($syn_expiry == 'on' && $nextduedate != '0000-00-00') {
                    $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
                } elseif ($is_trial == 1) {
                    $expdate = strtotime(date("Y-m-d H:i:s", strtotime($trial_period)));
                } elseif ($is_trial == 0 && $nextduedate == '0000-00-00' && $billing_months != "" && $billing_months != 0) {
                    $usersresult = mysqli_query($con, "SELECT id, exp_date FROM users WHERE username='$username' ");
                    $userxtremcode = mysqli_fetch_assoc($usersresult);
                    $expdatefromxtreamcode = date('Y-m-d H:i:s', $userxtremcode['exp_date']);
                    if (strtotime(date('Y-m-d H:i:s')) > $userxtremcode['exp_date']) {
                        $effectiveDate = date('Y-m-d H:i:s', strtotime("+" . $billing_months . " months", strtotime(date('Y-m-d H:i:s'))));
                    } else {
                        $effectiveDate = date('Y-m-d H:i:s', strtotime("+" . $billing_months . " months", strtotime($expdatefromxtreamcode)));
                    }
                    $expdate = strtotime($effectiveDate);
                }
            }
            if (NXTGetConfigXtreamDetailsHourDiff() != "" && $expdate != "NULL") {
                $expdate = $expdate + 60 * 60 * NXTGetConfigXtreamDetailsHourDiff();
            }
            $query = "UPDATE users SET `bouquet`='$Bouquets',`exp_date`=$expdate,enabled='1',`is_trial`='$is_trial',`max_connections`='$maxconnection',`is_restreamer`='$is_restreamer',`is_isplock`='$is_isplock' WHERE id='$xtreamuserid'";
            $result = mysqli_query($con, $query);
            if (!$result) {
                $radiussqlerror = mysqli_error($con);
                NXT_WHMCSReconnect();
                return "XtreamCode Database Query Error: " . $radiussqlerror;
            }
            if (!empty($params['customfields'][$returndata['custom_field_eng']])) {
                //Check If the MAG Exists in X.C Panel 
                $macexists = NXT_CheckENG($params['customfields'][$returndata['custom_field_eng']], $con);
                if (isset($macexists) && !empty($macexists)) {
                    return NXT_UpdateENG($params);
                } else {
                    return NXT_AddENG($params, $params['customfields'][$returndata['custom_field_eng']]);
                }
            }
            NXT_WHMCSReconnect();
            logModuleCall(
                'XtreamCode',
                __FUNCTION__,
                'Upgrade Account: ' . $username,
                'success'
            );
            return "success";
        }
    } else {
        logModuleCall(
            'XtreamCode',
            __FUNCTION__,
            'Streamline not found in X.C panel',
            'error'
        );
    }
    return "success";
}

function NXTStreamlineonlytoEngdevice($params)
{
    /* First remove the Streamlineonly */
    $serviceid = $params["serviceid"];
    $username = $params["username"];

    $con = NXTXtreamCodeTestConnection($params['pid']);

    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    $reseller_notes = $returndata['common_identifier'] . $serviceid;
    $result = mysqli_query($con, "SELECT * FROM users WHERE username='$username' ");

    if (mysqli_num_rows($result) != 0) {
        $result = mysqli_query($con, "DELETE FROM users WHERE username='$username' ");
        if (!$result) {
            NXT_WHMCSReconnect();
            return "XtreamCode Database Query Error: " . mysqli_error($con);
        }
    }
    NXT_WHMCSReconnect();
    /* Run Create function */
    if (!empty($params['customfields'][$returndata['custom_field_eng']])) {
        $magaddress = $params['customfields'][$returndata['custom_field_eng']];
    } else {
        $magaddress = '00:00:00:00:00:00';
    }
    return NXT_AddENG($params, $magaddress);
}

/* Magdevice to other */

function NXTMagdevicetoStreamline($params)
{
    $serviceid = $params["serviceid"];
    $con = NXTXtreamCodeTestConnection($params['pid']);
    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    $reseller_notes = $returndata['common_identifier'] . $serviceid;

    $result = mysqli_query($con, "SELECT * FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1'");
    if (mysqli_num_rows($result) != 0) {
        $pairid = mysqli_fetch_assoc($result);
        if (isset($pairid['id']) && !empty($pairid['id'])) {
            $mag_devices = mysqli_query($con, "DELETE FROM `mag_devices` WHERE user_id='" . $pairid['id'] . "'");
        }
        $result = mysqli_query($con, "DELETE FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1'");
        if (!$result) {
            NXT_WHMCSReconnect();
            return "XtreamCode Database Query Error: " . mysqli_error($con);
        }
    }
    NXT_WHMCSReconnect();
    /* Run Create function */
    return NXT_CreateAccount($params);
}

function NXTMagdevicetoStreamlineonly($params)
{
    return NXTMagdevicetoStreamline($params);
}

function NXTMagdevicetoMagdevice($params)
{
    $serviceid = $params["serviceid"];
    $con = NXTXtreamCodeTestConnection($params['pid']);
    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    $reseller_notes = $returndata['common_identifier'] . $serviceid;
    $result = mysqli_query($con, "SELECT * FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1'");
    if (mysqli_num_rows($result) != 0) {
        if (!empty($params['customfields'][$returndata['custom_field_mag']])) {
            //Check If the MAG Exists in X.C Panel 
            $macexists = NXT_CheckMAG($params['customfields'][$returndata['custom_field_mag']], $con);
            if (isset($macexists) && !empty($macexists)) {
                return NXT_UpdateMAG($params);
            } else {
                return NXT_AddMAG($params, $params['customfields'][$returndata['custom_field_mag']]);
            }
        } else {
            logModuleCall(
                'XtreamCode',
                __FUNCTION__,
                'MAG Address field is requied for (Only MAG and Check MAG)',
                'error'
            );
            return 'MAG Address field required, if you choose only MAG device';
        }
    } else {
        NXT_WHMCSReconnect();
        /* Run Create function */
        return NXT_CreateAccount($params);
    }

    return 'success';
}

function NXTMagdevicetoStreamlineeng($params)
{
    return NXTMagdevicetoStreamline($params);
}

function NXTMagdevicetoEngdevice($params)
{
    return NXTMagdevicetoStreamline($params);
}

/* Streamlineeng to other */

function NXTStreamlineengtoStreamline($params)
{
    $maxconnection = $params['configoption4'];
    $is_trial = ($params['configoption5'] == 'Yes') ? '1' : '0';
    $is_isplock = ($params['configoption6'] == 'Yes') ? '1' : '0';
    $is_restreamer = ($params['configoption7'] == 'Yes') ? '1' : '0';
    $Bouquets = isset($params['customfields']['Select Bouquets']) && !empty($params['customfields']['Select Bouquets']) ? trim($params['customfields']['Select Bouquets']) : $params['configoption10'];
    $CheckBouquets = NXT_ProductAddonsPack($params, $Bouquets);
    if ($CheckBouquets != "") {
        $Bouquets = $CheckBouquets;
    }
    $syn_expiry = $params['configoption17'];
    $trial_period = ($params['configoption18'] != 0) ? '+' . $params['configoption18'] . ' hours' : '+24 hours';
    $billing_months = $params['configoption21'];
    $tblhostingdetails = Capsule::table('tblhosting')->where('id', '=', $params["serviceid"])->get();
    $nextduedate = $tblhostingdetails[0]->nextduedate;
    $serviceid = $tblhostingdetails[0]->id;

    $con = NXTXtreamCodeTestConnection($params['pid']);

    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }

    /* Remove Eng device first then add mag is needed */
    $reseller_notes = $returndata['common_identifier'] . $serviceid;
    $result = mysqli_query($con, "SELECT * FROM users WHERE reseller_notes='$reseller_notes' AND is_e2='1'");

    if (mysqli_num_rows($result) != 0) {
        $pairid = mysqli_fetch_assoc($result);
        if (isset($pairid['id']) && !empty($pairid['id'])) {
            $mag_devices = mysqli_query($con, "DELETE FROM `enigma2_devices` WHERE user_id='" . $pairid['id'] . "'");
        }
        $result = mysqli_query($con, "DELETE FROM users WHERE reseller_notes='$reseller_notes' AND is_e2='1' ");
        mysqli_query($con, "UPDATE users SET pair_id='' WHERE reseller_notes='$reseller_notes'");

        if (!$result) {
            NXT_WHMCSReconnect();
            return "XtreamCode Database Query Error: " . mysqli_error($con);
        }
    }
    if (isset($returndata['configoption_field_name']) && !empty($returndata['configoption_field_name'])) {
        if (isset($params['configoptions']) && !empty($params['configoptions'])) {
            foreach ($params['configoptions'] as $configname => $configvalue) {
                if ($configname == $returndata['configoption_field_name']) {
                    $maxconnection += $configvalue;
                }
            }
        }
    }
    // Collecting parameters
    $username = $params["username"];
    $password = $params["password"];
    $reseller_notes = $returndata['common_identifier'] . $serviceid;

    // First checking if user already exist with reqeuest username  
    $result = mysqli_query($con, "SELECT username,id FROM users WHERE username='$username' ");
    if (!$result) {
        $radiussqlerror = mysqli_error($con);
        NXT_WHMCSReconnect();
        return "XtreamCode Database Query Error: " . $radiussqlerror;
    }
    if (mysqli_num_rows($result) > 0) {
        $xcuser = mysqli_fetch_assoc($result);
        $xtreamuserid = $xcuser['id'];
        $checkmagdevice = $params['customfields'][$returndata['checkmagdevice']];
        if (isset($checkmagdevice) && !empty($checkmagdevice) && $checkmagdevice == 'on') {
            if (!empty($params['customfields'][$returndata['custom_field_mag']])) {
                //Check If the MAG Exists in X.C Panel 
                $macexists = NXT_CheckMAG($params['customfields'][$returndata['custom_field_mag']], $con);
                if (isset($macexists) && !empty($macexists)) {
                    return NXT_UpdateMAG($params);
                } else {
                    return NXT_AddMAG($params, $params['customfields'][$returndata['custom_field_mag']]);
                }
            } else {
                logModuleCall(
                    'XtreamCode',
                    __FUNCTION__,
                    'MAG Address field is requied for (Only MAG and Check MAG)',
                    'error'
                );
                return 'MAG Address field required, if you choose only MAG device';
            }
        } else {
            $expdate = 'NULL';
            if ($is_trial == 1 && $nextduedate != '0000-00-00') {
                $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
            } else {
                if ($syn_expiry == 'on' && $nextduedate != '0000-00-00') {
                    $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
                } elseif ($is_trial == 1) {
                    $expdate = strtotime(date("Y-m-d H:i:s", strtotime($trial_period)));
                } elseif ($is_trial == 0 && $nextduedate == '0000-00-00' && $billing_months != "" && $billing_months != 0) {
                    $usersresult = mysqli_query($con, "SELECT id, exp_date FROM users WHERE username='$username' ");
                    $userxtremcode = mysqli_fetch_assoc($usersresult);
                    $expdatefromxtreamcode = date('Y-m-d H:i:s', $userxtremcode['exp_date']);
                    if (strtotime(date('Y-m-d H:i:s')) > $userxtremcode['exp_date']) {
                        $effectiveDate = date('Y-m-d H:i:s', strtotime("+" . $billing_months . " months", strtotime(date('Y-m-d H:i:s'))));
                    } else {
                        $effectiveDate = date('Y-m-d H:i:s', strtotime("+" . $billing_months . " months", strtotime($expdatefromxtreamcode)));
                    }
                    $expdate = strtotime($effectiveDate);
                }
            }
            if (NXTGetConfigXtreamDetailsHourDiff() != "" && $expdate != "NULL") {
                $expdate = $expdate + 60 * 60 * NXTGetConfigXtreamDetailsHourDiff();
            }
            $query = "UPDATE users SET `bouquet`='$Bouquets',`exp_date`=$expdate,enabled='1',`is_trial`='$is_trial',`max_connections`='$maxconnection',`is_restreamer`='$is_restreamer',`is_isplock`='$is_isplock' WHERE id='$xtreamuserid'";
            $result = mysqli_query($con, $query);
            if (!$result) {
                $radiussqlerror = mysqli_error($con);
                NXT_WHMCSReconnect();
                return "XtreamCode Database Query Error: " . $radiussqlerror;
            }
            if (!empty($params['customfields'][$returndata['custom_field_mag']])) {
                //Check If the MAG Exists in X.C Panel 
                $macexists = NXT_CheckMAG($params['customfields'][$returndata['custom_field_mag']], $con);
                if (isset($macexists) && !empty($macexists)) {
                    return NXT_UpdateMAG($params);
                } else {
                    return NXT_AddMAG($params, $params['customfields'][$returndata['custom_field_mag']]);
                }
            }
            NXT_WHMCSReconnect();
            logModuleCall(
                'XtreamCode',
                __FUNCTION__,
                'Upgrade Account: ' . $username,
                'success'
            );
            return "success";
        }
    } else {
        logModuleCall(
            'XtreamCode',
            __FUNCTION__,
            'Streamline not found in X.C panel',
            'error'
        );
    }
    return "success";
}

function NXTStreamlineengtoStreamlineeng($params)
{
    $maxconnection = $params['configoption4'];
    $is_trial = ($params['configoption5'] == 'Yes') ? '1' : '0';
    $is_isplock = ($params['configoption6'] == 'Yes') ? '1' : '0';
    $is_restreamer = ($params['configoption7'] == 'Yes') ? '1' : '0';
    $Bouquets = isset($params['customfields']['Select Bouquets']) && !empty($params['customfields']['Select Bouquets']) ? trim($params['customfields']['Select Bouquets']) : $params['configoption10'];
    $CheckBouquets = NXT_ProductAddonsPack($params, $Bouquets);
    if ($CheckBouquets != "") {
        $Bouquets = $CheckBouquets;
    }
    $syn_expiry = $params['configoption17'];
    $trial_period = ($params['configoption18'] != 0) ? '+' . $params['configoption18'] . ' hours' : '+24 hours';
    $billing_months = $params['configoption21'];
    $tblhostingdetails = Capsule::table('tblhosting')->where('id', '=', $params["serviceid"])->get();
    $nextduedate = $tblhostingdetails[0]->nextduedate;
    $serviceid = $tblhostingdetails[0]->id;

    $con = NXTXtreamCodeTestConnection($params['pid']);

    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    if (isset($returndata['configoption_field_name']) && !empty($returndata['configoption_field_name'])) {
        if (isset($params['configoptions']) && !empty($params['configoptions'])) {
            foreach ($params['configoptions'] as $configname => $configvalue) {
                if ($configname == $returndata['configoption_field_name']) {
                    $maxconnection += $configvalue;
                }
            }
        }
    }
    // Collecting parameters
    $username = $params["username"];
    $password = $params["password"];
    $reseller_notes = $returndata['common_identifier'] . $serviceid;

    // First checking if user already exist with reqeuest username  
    $result = mysqli_query($con, "SELECT username,id FROM users WHERE username='$username' ");
    if (!$result) {
        $radiussqlerror = mysqli_error($con);
        NXT_WHMCSReconnect();
        return "XtreamCode Database Query Error: " . $radiussqlerror;
    }
    if (mysqli_num_rows($result) > 0) {
        $xcuser = mysqli_fetch_assoc($result);
        $xtreamuserid = $xcuser['id'];
        $checkengdevice = $params['customfields'][$returndata['checkengdevice']];
        if (isset($checkengdevice) && !empty($checkengdevice) && $checkengdevice == 'on') {
            if (!empty($params['customfields'][$returndata['custom_field_eng']])) {
                //Check If the MAG Exists in X.C Panel 
                $macexists = NXT_CheckENG($params['customfields'][$returndata['custom_field_eng']], $con);
                if (isset($macexists) && !empty($macexists)) {
                    return NXT_UpdateENG($params);
                } else {
                    return NXT_AddENG($params, $params['customfields'][$returndata['custom_field_eng']]);
                }
            } else {
                logModuleCall(
                    'XtreamCode',
                    __FUNCTION__,
                    'MAG Address field is requied for (Only E2 Device and Check E2 Device)',
                    'error'
                );
                return 'MAG Address field required, if you choose only MAG device';
            }
        } else {
            $expdate = 'NULL';
            if ($is_trial == 1 && $nextduedate != '0000-00-00') {
                $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
            } else {
                if ($syn_expiry == 'on' && $nextduedate != '0000-00-00') {
                    $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
                } elseif ($is_trial == 1) {
                    $expdate = strtotime(date("Y-m-d H:i:s", strtotime($trial_period)));
                } elseif ($is_trial == 0 && $nextduedate == '0000-00-00' && $billing_months != "" && $billing_months != 0) {
                    $usersresult = mysqli_query($con, "SELECT id, exp_date FROM users WHERE username='$username' ");
                    $userxtremcode = mysqli_fetch_assoc($usersresult);
                    $expdatefromxtreamcode = date('Y-m-d H:i:s', $userxtremcode['exp_date']);
                    if (strtotime(date('Y-m-d H:i:s')) > $userxtremcode['exp_date']) {
                        $effectiveDate = date('Y-m-d H:i:s', strtotime("+" . $billing_months . " months", strtotime(date('Y-m-d H:i:s'))));
                    } else {
                        $effectiveDate = date('Y-m-d H:i:s', strtotime("+" . $billing_months . " months", strtotime($expdatefromxtreamcode)));
                    }
                    $expdate = strtotime($effectiveDate);
                }
            }
            if (NXTGetConfigXtreamDetailsHourDiff() != "" && $expdate != "NULL") {
                $expdate = $expdate + 60 * 60 * NXTGetConfigXtreamDetailsHourDiff();
            }
            $query = "UPDATE users SET `bouquet`='$Bouquets',`exp_date`=$expdate,enabled='1',`is_trial`='$is_trial',`max_connections`='$maxconnection',`is_restreamer`='$is_restreamer',`is_isplock`='$is_isplock' WHERE id='$xtreamuserid'";
            $result = mysqli_query($con, $query);
            if (!$result) {
                $radiussqlerror = mysqli_error($con);
                NXT_WHMCSReconnect();
                return "XtreamCode Database Query Error: " . $radiussqlerror;
            }
            if (!empty($params['customfields'][$returndata['custom_field_eng']])) {
                //Check If the MAG Exists in X.C Panel 
                $macexists = NXT_CheckENG($params['customfields'][$returndata['custom_field_eng']], $con);
                if (isset($macexists) && !empty($macexists)) {
                    return NXT_UpdateENG($params);
                } else {
                    return NXT_AddENG($params, $params['customfields'][$returndata['custom_field_eng']]);
                }
            }
            NXT_WHMCSReconnect();
            logModuleCall(
                'XtreamCode',
                __FUNCTION__,
                'Upgrade Account: ' . $username,
                'success'
            );
            return "success";
        }
    } else {
        if (!empty($params['customfields'][$returndata['custom_field_eng']])) {
            //Check If the MAG Exists in X.C Panel 
            $macexists = NXT_CheckENG($params['customfields'][$returndata['custom_field_eng']], $con);
            if (isset($macexists) && !empty($macexists)) {
                return NXT_UpdateENG($params);
            } else {
                return NXT_AddENG($params, $params['customfields'][$returndata['custom_field_eng']]);
            }
        }
        logModuleCall(
            'XtreamCode',
            __FUNCTION__,
            'Streamline not found in X.C panel',
            'error'
        );
    }
    return "success";
}

function NXTStreamlineengtoStreamlineonly($params)
{
    $maxconnection = $params['configoption4'];
    $is_trial = ($params['configoption5'] == 'Yes') ? '1' : '0';
    $is_isplock = ($params['configoption6'] == 'Yes') ? '1' : '0';
    $is_restreamer = ($params['configoption7'] == 'Yes') ? '1' : '0';
    $Bouquets = isset($params['customfields']['Select Bouquets']) && !empty($params['customfields']['Select Bouquets']) ? trim($params['customfields']['Select Bouquets']) : $params['configoption10'];
    $CheckBouquets = NXT_ProductAddonsPack($params, $Bouquets);
    if ($CheckBouquets != "") {
        $Bouquets = $CheckBouquets;
    }
    $syn_expiry = $params['configoption17'];
    $trial_period = ($params['configoption18'] != 0) ? '+' . $params['configoption18'] . ' hours' : '+24 hours';
    $billing_months = $params['configoption21'];
    $tblhostingdetails = Capsule::table('tblhosting')->where('id', '=', $params["serviceid"])->get();
    $nextduedate = $tblhostingdetails[0]->nextduedate;
    $serviceid = $tblhostingdetails[0]->id;
    $username = $params["username"];

    $con = NXTNXTXtreamCodeTestConnection($params['pid']);

    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }

    /* Remove Eng device first */
    $reseller_notes = $returndata['common_identifier'] . $serviceid;
    $resulte2 = mysqli_query($con, "SELECT * FROM users WHERE reseller_notes='$reseller_notes' AND is_e2='1'");
    if (mysqli_num_rows($resulte2) != 0) {
        $pairid = mysqli_fetch_assoc($resulte2);
        if (isset($pairid['id']) && !empty($pairid['id'])) {
            $mag_devices = mysqli_query($con, "DELETE FROM `enigma2_devices` WHERE user_id='" . $pairid['id'] . "'");
        }
        $result = mysqli_query($con, "DELETE FROM users WHERE reseller_notes='$reseller_notes' AND is_e2='1' ");
        mysqli_query($con, "UPDATE users SET pair_id='' WHERE username='$username' ");

        if (!$result) {
            NXT_WHMCSReconnect();
            return "XtreamCode Database Query Error: " . mysqli_error($con);
        }
    }

    $result = mysqli_query($con, "SELECT * FROM users WHERE username='$username'  ");

    if (mysqli_num_rows($result) != 0) {
        $pairid = mysqli_fetch_assoc($result);
        $xtreamuserid = $pairid['id'];
        $expdate = 'NULL';
        if ($is_trial == 1 && $nextduedate != '0000-00-00') {
            $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
        } else {
            if ($syn_expiry == 'on' && $nextduedate != '0000-00-00') {
                $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
            } elseif ($is_trial == 1) {
                $expdate = strtotime(date("Y-m-d H:i:s", strtotime($trial_period)));
            } elseif ($is_trial == 0 && $nextduedate == '0000-00-00' && $billing_months != "" && $billing_months != 0) {
                $usersresult = mysqli_query($con, "SELECT id, exp_date FROM users WHERE username='$username' ");
                $userxtremcode = mysqli_fetch_assoc($usersresult);
                $expdatefromxtreamcode = date('Y-m-d H:i:s', $userxtremcode['exp_date']);
                if (strtotime(date('Y-m-d H:i:s')) > $userxtremcode['exp_date']) {
                    $effectiveDate = date('Y-m-d H:i:s', strtotime("+" . $billing_months . " months", strtotime(date('Y-m-d H:i:s'))));
                } else {
                    $effectiveDate = date('Y-m-d H:i:s', strtotime("+" . $billing_months . " months", strtotime($expdatefromxtreamcode)));
                }
                $expdate = strtotime($effectiveDate);
            }
        }
        if (NXTGetConfigXtreamDetailsHourDiff() != "" && $expdate != "NULL") {
            $expdate = $expdate + 60 * 60 * NXTGetConfigXtreamDetailsHourDiff();
        }
        $query = "UPDATE users SET `bouquet`='$Bouquets',`exp_date`=$expdate,enabled='1',`is_trial`='$is_trial',`max_connections`='$maxconnection',`is_restreamer`='$is_restreamer',`is_isplock`='$is_isplock' WHERE id='$xtreamuserid'";
        $result = mysqli_query($con, $query);
        if (!$result) {
            $radiussqlerror = mysqli_error($con);
            NXT_WHMCSReconnect();
            return "XtreamCode Database Query Error: " . $radiussqlerror;
        }
        NXT_WHMCSReconnect();
        logModuleCall(
            'XtreamCode',
            __FUNCTION__,
            'Upgrade Account: ' . $username,
            'success'
        );
        return "success";
    }
}

function NXTStreamlineengtoMagdevice($params)
{
    $serviceid = $params["serviceid"];
    $username = $params["username"];
    $con = NXTXtreamCodeTestConnection($params['pid']);

    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    $reseller_notes = $returndata['common_identifier'] . $serviceid;
    $resulte2 = mysqli_query($con, "SELECT * FROM users WHERE reseller_notes='$reseller_notes' AND is_e2='1'");
    // First checking if user already exist with reqeuest username   
    if (mysqli_num_rows($resulte2) != 0) {
        $pairid = mysqli_fetch_assoc($resulte2);
        if (isset($pairid['id']) && !empty($pairid['id'])) {
            mysqli_query($con, "DELETE FROM `enigma2_devices` WHERE user_id='" . $pairid['id'] . "'");
            mysqli_query($con, "DELETE FROM users WHERE reseller_notes='$reseller_notes' AND is_e2='1'");
            mysqli_query($con, "UPDATE users SET pair_id='' WHERE username='$username' ");
        }
    }

    $result = mysqli_query($con, "SELECT * FROM users WHERE username='$username' ");

    if (mysqli_num_rows($result) != 0) {
        /*  Update table MAG devie and User for the MAG to make is non pair device Means only MAG device */
        $result = mysqli_query($con, "DELETE FROM users WHERE username='$username' ");

        if (!$result) {
            NXT_WHMCSReconnect();
            return "XtreamCode Database Query Error: " . mysqli_error($con);
        }
    }
    /* Run Create function */
    if (!empty($params['customfields'][$returndata['custom_field_mag']])) {
        $magaddress = $params['customfields'][$returndata['custom_field_mag']];
    } else {
        $magaddress = '00:00:00:00:00:00';
    }
    return NXT_AddMAG($params, $magaddress);
}

function NXTStreamlineengtoEngdevice($params)
{
    $serviceid = $params["serviceid"];
    $username = $params["username"];
    $con = NXTXtreamCodeTestConnection($params['pid']);

    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    $reseller_notes = $returndata['common_identifier'] . $serviceid;

    $result = mysqli_query($con, "SELECT * FROM users WHERE username='$username' ");

    if (mysqli_num_rows($result) != 0) {
        /*
         * Update table MAG devie and User for the MAG to make is non pair device Means only MAG device
         */
        $result = mysqli_query($con, "DELETE FROM users WHERE username='$username' ");
        mysqli_query($con, "UPDATE users SET pair_id='' WHERE reseller_notes='$reseller_notes' AND is_e2='1'");

        if (!$result) {
            NXT_WHMCSReconnect();
            return "XtreamCode Database Query Error: " . mysqli_error($con);
        }
    }
    if (!empty($params['customfields'][$returndata['custom_field_eng']])) {
        //Check If the MAG Exists in X.C Panel 
        $macexists = NXT_CheckMAG($params['customfields'][$returndata['custom_field_eng']], $con);
        if (isset($macexists) && !empty($macexists)) {
            return NXT_UpdateMAG($params);
        } else {
            return NXT_AddMAG($params, $params['customfields'][$returndata['custom_field_eng']]);
        }
    } else {
        logModuleCall(
            'XtreamCode',
            __FUNCTION__,
            'MAG Address field is requied for (Only Engima Device)',
            'error'
        );
        return 'MAG Address field required, if you choose only Engima device';
    }
    return 'success';
}

/* Engdevice to other */

function NXTEngdevicetoStreamline($params)
{
    $serviceid = $params["serviceid"];
    $con = NXTXtreamCodeTestConnection($params['pid']);
    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    $reseller_notes = $returndata['common_identifier'] . $serviceid;

    $result = mysqli_query($con, "SELECT * FROM users WHERE reseller_notes='$reseller_notes' AND is_e2='1'");

    if (mysqli_num_rows($result) != 0) {
        $pairid = mysqli_fetch_assoc($result);
        if (isset($pairid['id']) && !empty($pairid['id'])) {
            $mag_devices = mysqli_query($con, "DELETE FROM `enigma2_devices` WHERE user_id='" . $pairid['id'] . "'");
        }
        $result = mysqli_query($con, "DELETE FROM users WHERE reseller_notes='$reseller_notes' AND is_e2='1' ");

        if (!$result) {
            NXT_WHMCSReconnect();
            return "XtreamCode Database Query Error: " . mysqli_error($con);
        }
    }
    NXT_WHMCSReconnect();
    /* Run Create function */
    return NXT_CreateAccount($params);
}

function NXTEngdevicetoStreamlineonly($params)
{
    return NXTEngdevicetoStreamline($params);
}

function NXTEngdevicetoMagdevice($params)
{
    return NXTEngdevicetoStreamline($params);
}

function NXTEngdevicetoStreamlineeng($params)
{
    return NXTEngdevicetoStreamline($params);
}

function NXTEngdevicetoEngdevice($params)
{
    $serviceid = $params["serviceid"];

    $con = NXTXtreamCodeTestConnection($params['pid']);

    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    $reseller_notes = $returndata['common_identifier'] . $serviceid;

    $result = mysqli_query($con, "SELECT * FROM users WHERE reseller_notes='$reseller_notes' AND is_e2='1'");
    if (mysqli_num_rows($result) != 0) {
        if (!empty($params['customfields'][$returndata['custom_field_eng']])) {
            //Check If the MAG Exists in X.C Panel 
            $macexists = NXT_CheckENG($params['customfields'][$returndata['custom_field_eng']], $con);
            if (isset($macexists) && !empty($macexists)) {
                return NXT_UpdateENG($params);
            } else {
                return NXT_AddENG($params, $params['customfields'][$returndata['custom_field_eng']]);
            }
        } else {
            logModuleCall(
                'XtreamCode',
                __FUNCTION__,
                'MAG Address field is requied for (Only ENG)',
                'error'
            );
            return 'MAG Address field required, if you choose only ENG device';
        }
    } else {
        NXT_WHMCSReconnect();
        /* Run Create function */
        return NXT_CreateAccount($params);
    }
    return 'success';
}

function NXTGetConfigXtreamDetailsHourDiff()
{
    $config = Capsule::table('mod_xtreamConfig')->get();
    foreach ($config as $value) {
        $row[$value->setting] = $value->value;
    }
    return $row['HourDiff'];
}

function NXTStreamlineMAGENGtoStreamlineMAGENG($params)
{
    $maxconnection = $params['configoption4'];
    $is_trial = ($params['configoption5'] == 'Yes') ? '1' : '0';
    $is_isplock = ($params['configoption6'] == 'Yes') ? '1' : '0';
    $is_restreamer = ($params['configoption7'] == 'Yes') ? '1' : '0';
    $Bouquets = isset($params['customfields']['Select Bouquets']) && !empty($params['customfields']['Select Bouquets']) ? trim($params['customfields']['Select Bouquets']) : $params['configoption10'];
    $CheckBouquets = NXT_ProductAddonsPack($params, $Bouquets);
    if ($CheckBouquets != "") {
        $Bouquets = $CheckBouquets;
    }
    $syn_expiry = $params['configoption17'];
    $trial_period = ($params['configoption18'] != 0) ? '+' . $params['configoption18'] . ' hours' : '+24 hours';
    $billing_months = $params['configoption21'];
    $tblhostingdetails = Capsule::table('tblhosting')->where('id', '=', $params["serviceid"])->get();
    $nextduedate = $tblhostingdetails[0]->nextduedate;
    $serviceid = $tblhostingdetails[0]->id;

    $con = NXTXtreamCodeTestConnection($params['pid']);

    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    if (isset($returndata['configoption_field_name']) && !empty($returndata['configoption_field_name'])) {
        if (isset($params['configoptions']) && !empty($params['configoptions'])) {
            foreach ($params['configoptions'] as $configname => $configvalue) {
                if ($configname == $returndata['configoption_field_name']) {
                    $maxconnection += $configvalue;
                }
            }
        }
    }
    // Collecting parameters
    $username = $params["username"];
    $password = $params["password"];
    $reseller_notes = $returndata['common_identifier'] . $serviceid;

    // First checking if user already exist with reqeuest username  
    $result = mysqli_query($con, "SELECT username,id FROM users WHERE username='$username' ");
    if (!$result) {
        $radiussqlerror = mysqli_error($con);
        NXT_WHMCSReconnect();
        return "XtreamCode Database Query Error: " . $radiussqlerror;
    }
    if (mysqli_num_rows($result) > 0) {
        $xcuser = mysqli_fetch_assoc($result);
        $xtreamuserid = $xcuser['id'];
        $checkmagdevice = $params['customfields'][$returndata['checkmagdevice']];
        $checkengdevice = $params['customfields'][$returndata['checkengdevice']];
        if (isset($checkmagdevice) && !empty($checkmagdevice) && $checkmagdevice == 'on') {
            if (!empty($params['customfields'][$returndata['custom_field_mag']])) {
                //Check If the MAG Exists in X.C Panel 
                $macexists = NXT_CheckMAG($params['customfields'][$returndata['custom_field_mag']], $con);
                if (isset($macexists) && !empty($macexists)) {
                    return NXT_UpdateMAG($params);
                } else {
                    return NXT_AddMAG($params, $params['customfields'][$returndata['custom_field_mag']]);
                }
            } else {
                logModuleCall(
                    'XtreamCode',
                    __FUNCTION__,
                    'MAG Address field is requied for (Only MAG and Check MAG)',
                    'error'
                );
                return 'MAG Address field required, if you choose only MAG device';
            }
        } elseif (isset($checkengdevice) && !empty($checkengdevice) && $checkengdevice == 'on') {
            if (!empty($params['customfields'][$returndata['custom_field_eng']])) {
                //Check If the MAG Exists in X.C Panel 
                $macexists = NXT_CheckENG($params['customfields'][$returndata['custom_field_eng']], $con);
                if (isset($macexists) && !empty($macexists)) {
                    return NXT_UpdateENG($params);
                } else {
                    return NXT_AddENG($params, $params['customfields'][$returndata['custom_field_eng']]);
                }
            } else {
                logModuleCall(
                    'XtreamCode',
                    __FUNCTION__,
                    'MAG Address field is requied for (Only E2 Device and Check E2 Device)',
                    'error'
                );
                return 'MAG Address field required, if you choose only MAG device';
            }
        } else {
            $expdate = 'NULL';
            if ($is_trial == 1 && $nextduedate != '0000-00-00') {
                $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
            } else {
                if ($syn_expiry == 'on' && $nextduedate != '0000-00-00') {
                    $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
                } elseif ($is_trial == 1) {
                    $expdate = strtotime(date("Y-m-d H:i:s", strtotime($trial_period)));
                } elseif ($is_trial == 0 && $nextduedate == '0000-00-00' && $billing_months != "" && $billing_months != 0) {
                    $usersresult = mysqli_query($con, "SELECT id, exp_date FROM users WHERE username='$username' ");
                    $userxtremcode = mysqli_fetch_assoc($usersresult);
                    $expdatefromxtreamcode = date('Y-m-d H:i:s', $userxtremcode['exp_date']);
                    if (strtotime(date('Y-m-d H:i:s')) > $userxtremcode['exp_date']) {
                        $effectiveDate = date('Y-m-d H:i:s', strtotime("+" . $billing_months . " months", strtotime(date('Y-m-d H:i:s'))));
                    } else {
                        $effectiveDate = date('Y-m-d H:i:s', strtotime("+" . $billing_months . " months", strtotime($expdatefromxtreamcode)));
                    }
                    $expdate = strtotime($effectiveDate);
                }
            }
            if (NXTGetConfigXtreamDetailsHourDiff() != "" && $expdate != "NULL") {
                $expdate = $expdate + 60 * 60 * NXTGetConfigXtreamDetailsHourDiff();
            }
            $query = "UPDATE users SET `bouquet`='$Bouquets',`exp_date`=$expdate,enabled='1',`is_trial`='$is_trial',`max_connections`='$maxconnection',`is_restreamer`='$is_restreamer',`is_isplock`='$is_isplock' WHERE id='$xtreamuserid'";
            $result = mysqli_query($con, $query);
            if (!$result) {
                $radiussqlerror = mysqli_error($con);
                NXT_WHMCSReconnect();
                return "XtreamCode Database Query Error: " . $radiussqlerror;
            }
            if (!empty($params['customfields'][$returndata['custom_field_mag']])) {
                //Check If the MAG Exists in X.C Panel 
                $macexists = NXT_CheckMAG($params['customfields'][$returndata['custom_field_mag']], $con);
                if (isset($macexists) && !empty($macexists)) {
                    return NXT_UpdateMAG($params);
                } else {
                    return NXT_AddMAG($params, $params['customfields'][$returndata['custom_field_mag']]);
                }
            } else {
                $result = mysqli_query($con, "SELECT * FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1'");
                $pairid = mysqli_fetch_assoc($result);
                $xtreamuserid = $pairid['id'];
                if (isset($pairid['id']) && !empty($pairid['id'])) {
                    mysqli_query($con, "DELETE FROM `mag_devices` WHERE user_id='" . $pairid['id'] . "'");
                    $result = mysqli_query($con, "DELETE FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1'");
                    mysqli_query($con, "UPDATE users SET pair_id='' WHERE reseller_notes='$reseller_notes'");
                }
            }
            if (!empty($params['customfields'][$returndata['custom_field_eng']])) {
                //Check If the MAG Exists in X.C Panel 
                $macexists = NXT_CheckENG($params['customfields'][$returndata['custom_field_eng']], $con);
                if (isset($macexists) && !empty($macexists)) {
                    return NXT_UpdateENG($params);
                } else {
                    return NXT_AddENG($params, $params['customfields'][$returndata['custom_field_eng']]);
                }
            } else {
                $username = 'WHMCSENG:' . $returndata['common_identifier'] . $serviceid;
                if (!empty($params['customfields'][$returndata['custom_field_eng']])) {
                    $con = NXTXtreamCodeTestConnection($params['pid']);
                    $reseller_notes = $returndata['common_identifier'] . $serviceid;
                    $result = mysqli_query($con, "SELECT * FROM users WHERE reseller_notes='$reseller_notes' AND is_e2='1'");
                }
                if (mysqli_num_rows($result) != 0) {
                    $pairid = mysqli_fetch_assoc($result);
                    if (isset($pairid['id']) && !empty($pairid['id'])) {
                        $enigma2_devices = mysqli_query($con, "DELETE FROM `enigma2_devices` WHERE user_id='" . $pairid['id'] . "'");
                    }
                    $result = mysqli_query($con, "DELETE FROM users WHERE reseller_notes='$reseller_notes' AND is_e2='1' ");

                    if (!$result) {
                        NXT_WHMCSReconnect();
                        return "XtreamCode Database Query Error: " . mysqli_error($con);
                    }
                }
            }
            NXT_WHMCSReconnect();
            logModuleCall(
                'XtreamCode',
                __FUNCTION__,
                'Upgrade Account: ' . $username,
                'success'
            );
            return "success";
        }
    } else {
        $checkmagdevice = $params['customfields'][$returndata['checkmagdevice']];
        if (isset($checkmagdevice) && !empty($checkmagdevice) && $checkmagdevice == 'on') {
            if (!empty($params['customfields'][$returndata['custom_field_mag']])) {
                //Check If the MAG Exists in X.C Panel 
                $macexists = NXT_CheckMAG($params['customfields'][$returndata['custom_field_mag']], $con);
                if (isset($macexists) && !empty($macexists)) {
                    return NXT_UpdateMAG($params);
                } else {
                    return NXT_AddMAG($params, $params['customfields'][$returndata['custom_field_mag']]);
                }
            } else {
                logModuleCall(
                    'XtreamCode',
                    __FUNCTION__,
                    'Streamline not found in X.C panel',
                    'error'
                );
            }
        } else {
            return NXT_CreateAccount($params);
        }
    }
    return "success";
}
