<?php

//include_once '../../../init.php';
include_once '../../../includes/vpnapi/serverstatus.php';

use Illuminate\Database\Capsule\Manager as Capsule;

function createServer($serverIP, $serversshport, $serverPass, $systemURL, $api, $reconfig, $category, $pskkey, $servername)
{
    $createserver = createovpnServer($serverIP, $serversshport, $serverPass, $systemURL, $api, $reconfig, $pskkey, $category, $servername);

    return $createserver;
}

function addProductMapping($data)
{
    try {
        Capsule::table('mod_vpn_product_mapping')->insert($data);
        return 'success';
    } catch (Exception $th) {
        return $th->getMessage();
    }
    
}

function updateProductMapping($data)
{
    try {
        Capsule::table('mod_vpn_product_mapping')->where('id',$data['id'])->update($data);
        return 'success';
    } catch (Exception $th) {
        return $th->getMessage();
    }
    
}


function deletemappedProduct($id)
{
    try {
        Capsule::table('mod_vpn_product_mapping')->where('id', $id)->delete();
        return 'success';
    } catch (Exception $th) {
        return $th->getMessage();
    }
}

function getMappedProducts()
{
    $mappedproducts = Capsule::table('mod_vpn_product_mapping')->get();

    return $mappedproducts;
}

function encryptPass($pass)
{
    $salt = 'TeFrg&65TY!23Olk(';
    $qEncoded = base64_encode(mcrypt_encrypt(MCRYPT_RIJNDAEL_256, md5($salt), $pass, MCRYPT_MODE_CBC, md5(md5($salt))));
    return ($qEncoded);
}

function decryptPass($pass)
{
    $salt = 'TeFrg&65TY!23Olk(';
    $qDecoded = rtrim(mcrypt_decrypt(MCRYPT_RIJNDAEL_256, md5($salt), base64_decode($pass), MCRYPT_MODE_CBC, md5(md5($salt))), "\0");
    return ($qDecoded);
}

function getonlineusers()
{
    $Onlinecount = Capsule::select("SELECT * FROM radacct WHERE (radacct.AcctStopTime IS NULL OR radacct.AcctStopTime = '0000-00-00 00:00:00')");
    return count($Onlinecount);
}

function saveSetting($data)
{
    Capsule::table('mod_vpn_settings')->where('settings', '!=', 'signupproduct')->delete();
    foreach ($data as $post) {
        $updateSettings = Capsule::table('mod_vpn_settings')->insert($post);
    }
    return $updateSettings;
}

function testcfcon($api, $email, $token)
{
    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, 'https://api.cloudflare.com/client/v4/user/tokens/verify');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

    $headers = array();
    $headers[] = 'Authorization: Bearer ' . $token;
    $headers[] = 'Content-Type: application/json';
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);
    if (curl_errno($ch)) {
        return 'Error:' . curl_error($ch);
    }
    curl_close($ch);
    return json_decode($result);
}

function updatecfapi($api, $email, $secret, $cfaccount = "", $cfdomain = "", $cfenabled)
{
    try {
        if (Capsule::table('mod_vpn_settings')->where('settings', '=', 'cfapi')->count() > 0) {

            Capsule::table('mod_vpn_settings')->where('settings', '=', 'cfapi')->update(['value' => $api]);
        } else {
            Capsule::table('mod_vpn_settings')->insert(['settings' => 'cfapi', 'value' => $api]);
        }

        if (Capsule::table('mod_vpn_settings')->where('settings', '=', 'cfemail')->count() > 0) {
            Capsule::table('mod_vpn_settings')->where('settings', '=', 'cfemail')->update(['value' => $email]);
        } else {
            Capsule::table('mod_vpn_settings')->insert(['settings' => 'cfemail', 'value' => $email]);
        }

        if (Capsule::table('mod_vpn_settings')->where('settings', '=', 'cfsecret')->count() > 0) {

            Capsule::table('mod_vpn_settings')->where('settings', '=', 'cfsecret')->update(['value' => $secret]);
        } else {
            Capsule::table('mod_vpn_settings')->insert(['settings' => 'cfsecret', 'value' => $secret]);
        }
        if (Capsule::table('mod_vpn_settings')->where('settings', '=', 'cfaccount')->count() > 0) {
            Capsule::table('mod_vpn_settings')->where('settings', '=', 'cfaccount')->update(['value' => $cfaccount]);
        } else {
            Capsule::table('mod_vpn_settings')->insert(['settings' => 'cfaccount', 'value' => $cfaccount]);
        }
        if (Capsule::table('mod_vpn_settings')->where('settings', '=', 'cfdomain')->count() > 0) {
            Capsule::table('mod_vpn_settings')->where('settings', '=', 'cfdomain')->update(['value' => $cfdomain]);
        } else {
            Capsule::table('mod_vpn_settings')->insert(['settings' => 'cfdomain', 'value' => $cfdomain]);
        }
        if (Capsule::table('mod_vpn_settings')->where('settings', '=', 'cfenabled')->count() > 0) {
            Capsule::table('mod_vpn_settings')->where('settings', '=', 'cfenabled')->update(['value' => $cfenabled]);
        } else {
            Capsule::table('mod_vpn_settings')->insert(['settings' => 'cfenabled', 'value' => $cfenabled]);
        }

        return 'success';
    } catch (\Throwable $th) {
        return $th->getMessage();
    }
}

function getcfdetails()
{
    $cfapi = Capsule::table('mod_vpn_settings')->where('settings', '=', 'cfapi')->first();
    $cfemail = Capsule::table('mod_vpn_settings')->where('settings', '=', 'cfemail')->first();
    $cfsecret = Capsule::table('mod_vpn_settings')->where('settings', '=', 'cfsecret')->first();
    $cfaccount = Capsule::table('mod_vpn_settings')->where('settings', '=', 'cfaccount')->first();
    $cfdomain = Capsule::table('mod_vpn_settings')->where('settings', '=', 'cfdomain')->first();
    $cfenabled = Capsule::table('mod_vpn_settings')->where('settings', '=', 'cfenabled')->first();
    return array('cfapi' => decryptpass($cfapi->value), 'cfemail' => $cfemail->value, 'cfsecret' => decryptpass($cfsecret->value), 'cfaccount' => $cfaccount->value, 'cfdomain' => $cfdomain->value, 'cfenabled' => $cfenabled->value);
}

function getSettings()
{
    $data = Capsule::table('mod_vpn_settings')->get();
    $settings = array();
    foreach ($data as $val) {
        $settings[$val->settings] = $val->value;
    }
    return $settings;
}

function restartService($serverIP, $serversshport, $serverPass)
{
    $ssh = new Net_SSH2($serverIP, $serversshport);
    if (!$ssh->login('root', $serverPass)) {
        logActivity('**VPN Panel - Server - ' . $serverIP . ' - Server Login Failed**', 0);
        return 'LoginFailed';
    }
    $ssh->exec('curl -O -H "Authorization: token 194f07247ea811f481b76c7c79f32a88dd3ba399" https://raw.githubusercontent.com/whmcs-smarters/installscripts/master/resart-all-servers.sh'); // get script file on server
    $ssh->exec('chmod +x resart-all-servers.sh'); // set permission to script file
    $process = $ssh->exec("./resart-all-servers.sh > /dev/null 2>&1 &"); // 
    return 'success';
}

function restartradiusService($serverIP, $serversshport, $serverPass)
{
    $ssh = new Net_SSH2($serverIP, $serversshport);
    if (!$ssh->login('root', $serverPass)) {
        logActivity('**VPN Panel - Server - ' . $serverIP . ' - Server Login Failed**', 0);
        return 'LoginFailed';
    }
    $ssh->exec('sudo service freeradius restart'); // get script file on server
    return 'success';
}

function rebootServer($serverIP, $serversshport, $serverPass)
{
    $ssh = new Net_SSH2($serverIP, $serversshport);
    if (!$ssh->login('root', $serverPass)) {
        logActivity('**VPN Panel - Server - ' . $serverIP . ' - Server Login Failed**', 0);
        return 'LoginFailed';
    }
    $ssh->exec('reboot');
    return 'success';
}

function viewlogs($serverIP, $serversshport, $serverPass)
{
    $ssh = new Net_SSH2($serverIP, $serversshport);
    if (!$ssh->login('root', $serverPass)) {
        logActivity('**VPN Panel - Server - ' . $serverIP . ' - Server Login Failed**', 0);
        return 'LoginFailed';
    }
    $logs = $ssh->exec('cat /root/new.log');
    return $logs;
}

function restartallservice()
{
    $servers = getallserver();
    //echo '<pre>';print_r(decryptPass($servers['MainServer'][0]->sshpass)); die();
    $serverIP = $servers['MainServer'][0]->server_ip;
    $serversshport = $servers['MainServer'][0]->sshport;
    $serverPass = decryptPass($servers['MainServer'][0]->sshpass);
    $response = restartradiusService($serverIP, $serversshport, $serverPass);
    if ($response == 'success') {
        logModuleCall('VPN Panel', 'Restart Service (Main Server)', $serverIP, 'Success', '', '');
    } else {
        logModuleCall('VPN Panel', 'Restart Service (Main Server) Error', $servers['MainServer'][0], $response, '', '');
    }



    foreach ($servers['Servers'] as $server) {
        if ($server->mainserver == 0) {
            $serverIP = $server->server_ip;
            $serversshport = $server->sshport;
            $serverPass = decryptPass($server->sshpass);
            $response = restartService($serverIP, $serversshport, $serverPass);
            logModuleCall('VPN Panel', 'Restart Service', $serverIP, 'Success', '', '');
        }
    }
    foreach ($servers['lbServers'] as $server) {
        $serverIP = $server->server_ip;
        $serversshport = $server->sshport;
        $serverPass = decryptPass($server->sshpass);
        $response = restartService($serverIP, $serversshport, $serverPass);
        logModuleCall('VPN Panel', 'Restart Service', $serverIP, 'Success', '', '');
    }

    return 'success';
}

function randompsk()
{
    $alphabet = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
    $pass = array(); //remember to declare $pass as an array
    $alphaLength = strlen($alphabet) - 1; //put the length -1 in cache
    for ($i = 0; $i < 10; $i++) {
        $n = rand(0, $alphaLength);
        $pass[] = $alphabet[$n];
    }
    return implode($pass);
}
function getcfaccounts()
{
    $cfapidetails = getcfdetails();

    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, 'https://api.cloudflare.com/client/v4/accounts?page=1&per_page=20&direction=desc');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');


    $headers = array();
    $headers[] = 'X-Auth-Email: ' . $cfapidetails['cfemail'] . '';
    $headers[] = 'X-Auth-Key: ' . $cfapidetails['cfapi'] . '';
    $headers[] = 'Content-Type: application/json';
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);
    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
    }
    curl_close($ch);
    return json_decode($result);
}

function getcfdomains()
{
    $cfapidetails = getcfdetails();
    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, 'https://api.cloudflare.com/client/v4/zones?account.id=' . $cfapidetails['cfaccount'] . '');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

    //curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"subdomain\":\"$subdomain\"}");

    $headers = array();
    $headers[] = 'X-Auth-Email: ' . $cfapidetails['cfemail'] . '';
    $headers[] = 'X-Auth-Key: ' . $cfapidetails['cfapi'] . '';
    $headers[] = 'Content-Type: application/json';
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $result = curl_exec($ch);
    return json_decode($result);
    if (curl_errno($ch)) {
        echo 'Error:' . curl_error($ch);
    }
    curl_close($ch);
}

function RandomString($length)
{
    $keys = array_merge(range(0, 9), range('a', 'z'));

    $key = "";
    for ($i = 0; $i < $length; $i++) {
        $key .= $keys[mt_rand(0, count($keys) - 1)];
    }
    return $key;
}

function createovpnServer($serverIP, $serversshport, $serverPass, $systemURL, $api, $reconfig, $pskkey, $category, $servername)
{
    $fulldomain = $serverIP;
    $subdomain = $serverIP;
    if (!$reconfig) {

        $cfapidetails = getcfdetails();

        $isIP = preg_match('/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}\z/', $serverIP);
        if ($isIP == 1) {
            if (isset($cfapidetails['cfenabled']) && $cfapidetails['cfenabled'] == 'on') {
                if ($cfapidetails['cfapi'] == '' || $cfapidetails['cfsecret'] == '') {
                    return 'Please enter Cloudflare API Details to create server';
                }
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, 'https://api.cloudflare.com/client/v4/zones/' . $cfapidetails['cfdomain'] . '');
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
                $headers = array();
                $headers[] = 'X-Auth-Email: ' . $cfapidetails['cfemail'] . '';
                $headers[] = 'X-Auth-Key: ' . $cfapidetails['cfapi'] . '';
                $headers[] = 'Content-Type: application/json';
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                $result = json_decode(curl_exec($ch));
                $zonename = '';
                if ($result->success) {
                    $zonename = $result->result->name;
                }
                if (curl_errno($ch)) {
                    echo 'Error:' . curl_error($ch);
                }
                curl_close($ch);
                $subdomain = str_replace(' ', '', strtolower($servername));
                $count = 0;
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, 'https://api.cloudflare.com/client/v4/zones/' . $cfapidetails['cfdomain'] . '/dns_records');
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
                $headers = array();
                $headers[] = 'X-Auth-Email: ' . $cfapidetails['cfemail'] . '';
                $headers[] = 'X-Auth-Key: ' . $cfapidetails['cfapi'] . '';
                $headers[] = 'Content-Type: application/json';
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                $result1 = json_decode(curl_exec($ch));
                if (curl_errno($ch)) {
                    echo 'Error:' . curl_error($ch);
                }
                curl_close($ch);
                foreach ($result1->result as $record) {
                    if (strpos($record->name, $subdomain) !== false) {
                        $count++;
                    }
                }
                if ($count > 0) {
                    $count = intval($count) + 1;
                    $subdomain = $subdomain . $count;
                }
                $fulldomain = $subdomain . '.' . $zonename;
                $ch = curl_init();

                curl_setopt($ch, CURLOPT_URL, 'https://api.cloudflare.com/client/v4/zones/' . $cfapidetails['cfdomain'] . '/dns_records');
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, "{\"type\":\"A\",\"name\":\"$subdomain\",\"content\":\"$serverIP\",\"ttl\":1,\"priority\":10,\"proxied\":false}");

                $headers = array();
                $headers[] = 'X-Auth-Email: ' . $cfapidetails['cfemail'] . '';
                $headers[] = 'X-Auth-Key: ' . $cfapidetails['cfapi'] . '';
                $headers[] = 'Content-Type: application/json';
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

                $result2 = json_decode(curl_exec($ch));

                if (curl_errno($ch)) {
                    echo 'Error:' . curl_error($ch);
                }
                curl_close($ch);
                if ($result2->success != 1) {
                    logModuleCall('VPN Panel', 'Creating sub domain', $serverIP.' - '.$subdomain, $result2->errors, '', '');
                    echo $result2->errors[0]->message;
                    exit;
                }
            }
        }
    }
    $configdata = getserverconfig();

    $ipv6 = $configdata['ipv6']['value'];
    $port = $configdata['port']['value'];
    $explodeport = explode('|', $port);
    $port = $explodeport[0];
    $customport = $configdata['customport']['value'];
    $protocol = $configdata['protocol']['value'];
    $dns = $configdata['dns']['value'];
    $logging = $configdata['logging']['value'];

    switch ($dns) {
        case "1":
            $dns1 = '';
            $dns2 = '';
            break;
        case "2":
            $dns1 = " -x '10.8.0.1'";
            $dns2 = '';
            break;
        case "3":
            $dns1 = " -x '1.0.0.1'";
            $dns2 = " -y '1.1.1.1'";
            break;
        case "4":
            $dns1 = " -x '9.9.9.9'";
            $dns2 = " -y '149.112.112.112'";
            break;
        case "5":
            $dns1 = " -x '9.9.9.10'";
            $dns2 = " -y '149.112.112.10'";
            break;
        case "6":
            $dns1 = " -x '80.67.169.40'";
            $dns2 = " -y '80.67.169.12'";
            break;
        case "7":
            $dns1 = " -x '84.200.69.80'";
            $dns2 = " -y '84.200.70.40'";
            break;
        case "8":
            $dns1 = " -x '208.67.222.222'";
            $dns2 = " -y '208.67.220.220'";
            break;
        case "9":
            $dns1 = " -x '8.8.8.8'";
            $dns2 = " -y '8.8.4.4'";
            break;
        case "10":
            $dns1 = " -x '77.88.8.8'";
            $dns2 = " -y '77.88.8.1'";
            break;
        case "11":
            $dns1 = " -x '176.103.130.130'";
            $dns2 = " -y '176.103.130.131'";
            break;
        case "12":
            $dns1 = (!empty($configdata['dns1']['value'])) ? " -x '" . $configdata['dns1']['value'] . "'" : '';
            $dns2 = (!empty($configdata['dns2']['value'])) ? " -y '" . $configdata['dns2']['value'] . "'" : '';
            break;
        default:
            $dns1 = '';
            $dns2 = '';
    }


    /*$dns1 = (!empty($configdata['dns1']['value'])) ? " -x '" . $configdata['dns1']['value'] . "'" : '';
    $dns2 = (!empty($configdata['dns2']['value'])) ? " -y '" . $configdata['dns2']['value'] . "'" : '';*/
    $installscriptfile = 'install-vpn-proxy.sh';
    #$compression = $configdata['compression'];
    #$encryption = $configdata['encryption'];

    $enableProxy = (isset($configdata['enableProxy']) && !empty($configdata['enableProxy']['value'])) ? $configdata['enableProxy']['value'] : '';
    $proxyserver = $configdata['proxyserver']['value'];
    $proxyport = $configdata['proxyport']['value'];
    $proxyretry = $configdata['proxyretry']['value'];

    $proxycustomheaderen1 = $configdata['customheaderenb1']['value'];
    $proxycustomheader1 = $configdata['customheader1']['value'];
    $proxycustomheaderen2 = $configdata['customheaderenb2']['value'];
    $proxycustomheader2 = $configdata['customheader2']['value'];

    $customheaders = '';

    if ($proxycustomheaderen1 == 'on') {
        $customheaders .= 'http-proxy-option ' . $proxycustomheader1 . '\n';
    }
    if ($proxycustomheaderen2 == 'on') {
        $customheaders .= 'http-proxy-option ' . $proxycustomheader2 . '\n';
    }
    $portval = (!empty($customport)) ? $customport : '1194';
    //echo '<pre>'; print_r($portval); die();

    $serverCount = Capsule::table('server_list')->where('server_ip', $serverIP)->count();

    if ($serverCount == 0) {
        $serverCount = Capsule::table('lb_server_list')->where('server_ip', $serverIP)->count();
        Capsule::table('lb_server_list')->where('server_ip', $serverIP)->update(['server_port' => $portval]);
    } else {
        Capsule::table('server_list')->where('server_ip', $serverIP)->update(['server_port' => $portval]);
    }

    $mainserverData = Capsule::table('server_list')->where('mainserver', 1)->get();
    $mainserverIP = $mainserverData[0]->server_ip;



    $ssh = new Net_SSH2($serverIP, $serversshport);
    if (!$ssh->login('root', $serverPass)) {
        logActivity('**Server ' . $serverIP . ' - ' . $serverPass . ' Error - Login Failed.**', 0);
        return 'LoginFailed';
    }
    if (!$reconfig) {

        $ssh->exec('apt-get install curl -y'); //Installing cURL
        //$ssh->exec('sudo lshw -html > lshw.html');//creating server info html
        $ssh->exec('curl -O -H "Authorization: token 194f07247ea811f481b76c7c79f32a88dd3ba399" https://raw.githubusercontent.com/whmcs-smarters/installscripts/master/checkServerCompatibility.sh');
        $ssh->exec('chmod +x checkServerCompatibility.sh');
        $servercheck = $ssh->exec("./checkServerCompatibility.sh");
        if (!empty($servercheck)) {
            logActivity('**VPN Panel - Server Check Before Install ' . $serverIP . ' - ' . $servercheck . '**', 0);
            logModuleCall('VPN Panel', 'Server Check Before Install', $serverIP, $servercheck, '', '');
            return $servercheck;
        }

        if ($serverCount >= 1) {
            return 'server_exists';
        }
    }
    if ($reconfig) {
        // Capsule::table('mod_server_certs')->where('server_ip', $serverIP)->delete();
        Capsule::table('mod_server_certs')->where('server_ip', $fulldomain)->delete();
    }
    $configuration = Capsule::table('tblconfiguration')->where('setting', '=', 'email')->get();
    $adminEmail = $configuration[0]->value;
    $randRadiusSec = randompsk();
    $ssh->exec('curl -O -H "Authorization: token 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" https://raw.githubusercontent.com/whmcs-smarters/vpn-scripts/main/' . $installscriptfile . ''); // get script file on server
    $ssh->exec('chmod +x ' . $installscriptfile . ''); // set permission to script file

    // $scriptParams = " -h '" . $systemURL . "' -a '" . $api . "'  -p '" . $portval . "' -i '" . $ipv6 . "' -d '" . $dns . "'" . $dns1 . $dns2 . " -s '" . $randRadiusSec . "' -m '" . $mainserverIP . "'  -v '" . $category . "' -l '" . $protocol . "' -n '" . $serverIP . "' -u '" . $adminEmail . "' ";
    $scriptParams = " -h '" . $systemURL . "' -a '" . $api . "'  -p '" . $portval . "' -i '" . $ipv6 . "' -d '" . $dns . "'" . $dns1 . $dns2 . " -s '" . $randRadiusSec . "' -m '" . $mainserverIP . "'  -v '" . $category . "' -l '" . $protocol . "' -n '" . $fulldomain . "' -u '" . $adminEmail . "' ";
    if (!empty($logging)) {
        $scriptParams .= " -g '" . $logging . "'";
    }
    if ($enableProxy == 'on') {
        $scriptParams .= " -w '" . $proxyserver . "' -z '" . $proxyport . "' -e '" . $proxyretry . "'";
        if (!empty($customheaders)) {
            $scriptParams .= " -f '" . $customheaders . "'";
        }
    }
    //echo '<pre>'; print_r($scriptParams); die();
    if ($reconfig) {
        $process = $ssh->exec("./" . $installscriptfile . " " . $scriptParams . " -c 'yes' > /dev/null 2>&1 &");
        $serverconfigvars = "./" . $installscriptfile . " " . $scriptParams . " -c 'yes'  > /dev/null 2>&1 &";
    } else {
        $process = $ssh->exec("./" . $installscriptfile . "  " . $scriptParams . " > /dev/null 2>&1 &");
        $serverconfigvars = "./" . $installscriptfile . " " . $scriptParams . "  > /dev/null 2>&1 &";
    }



    // $nasCount = Capsule::table('nas')->where('nasname', $serverIP)->count();
    $nasCount = Capsule::table('nas')->where('nasname', $fulldomain)->count();
    if ($nasCount >= 1) {
        // Capsule::table('nas')->where('nasname', $serverIP)->update(['secret' => $randRadiusSec]);
        Capsule::table('nas')->where('nasname', $fulldomain)->update(['secret' => $randRadiusSec]);
    } else {
        // Capsule::table('nas')->insert(['secret' => $randRadiusSec, 'shortname' => 'vpnserver', 'nasname' => $serverIP]);
        Capsule::table('nas')->insert(['secret' => $randRadiusSec, 'shortname' => 'vpnserver', 'nasname' => $fulldomain]);
    }

    //    $process = $ssh->exec("./openvpn-install.sh -h '" . $systemURL . "' -a '" . $api . "' > /dev/null 2>&1 &");

    logActivity('**VPN Panel - Server Install ' . $serverIP . ' - Server Installation Started**', 0);
    logModuleCall('VPN Panel', 'Install Server', $serverIP, 'Server Installation Started', '', '');
    logModuleCall('VPN Panel', 'Server Config define vars', $serverIP, $serverconfigvars, '', '');

    if ($cfapidetails['cfapi'] == '' || $cfapidetails['cfsecret'] == '') {
        return array('success' => true, 'subdomain' => $serverIP);
    } else {
        return array('success' => true, 'subdomain' => $fulldomain);
    }
}

/* function createipsecServer($serverIP, $serversshport, $serverPass, $systemURL, $api, $reconfig, $pskkey) {

  $ssh = new Net_SSH2($serverIP, $serversshport);
  if (!$ssh->login('root', $serverPass)) {
  logActivity('**VPN Panel - Server - '.$serverIP.' - Server Login Failed**',0);
  return 'LoginFailed';
  }

  $ssh->exec('apt-get install curl -y'); //Installing cURL
  $ssh->exec('sudo lshw -html > lshw.html');//creating server info html
  $ssh->exec('curl -O https://raw.githubusercontent.com/amansmarters/setup-ipsec-vpn/master/vpnsetup.sh'); // get script file on server
  $ssh->exec('chmod +x vpnsetup.sh'); // set permission to script file
  $process = $ssh->exec("./vpnsetup.sh -k '" . $pskkey . "' > /dev/null 2>&1 &");//
  $serverconfigvars = "./vpnsetup.sh -k '" . $pskkey . "' > /dev/null 2>&1 &";
  logActivity('**VPN Panel - Server - '.$serverIP.' - Server Installation Started**',0);
  logModuleCall('VPN Panel', 'Server Config define vars', $serverIP, $serverconfigvars, '', '');
  $serevrsData = Capsule::table('server_list')->where('server_ip', $serverIP)->count();
  $serverPort = Capsule::table('mod_vpn_serverconfig')->where('setting', 'port')->get();
  $serverportval = '';
  if ($serverPort[0]->value == '1|1194') {
  $serverportval = '1194';
  } else if ($serverPort[0]->value == '2') {
  $customserverPort = Capsule::table('mod_vpn_serverconfig ')->where('setting', 'customport')->get();
  $serverportval = $customserverPort[0]->value;
  } else if ($serverPort[0]->value == '3') {
  $serverportval = rand(49152, 65535);
  } else {
  logModuleCall('VPN Panel', 'Port not identified ', 'Server Status', 'ERROR', '', '');
  }
  if ($serevrsData > 0) {

  $editserver = Capsule::table('server_list')->where('server_ip', $serverIP)->update(['status' => 1, 'server_port' => $serverportval]);
  logActivity('**VPN Panel - Server - '.$serverIP.' - Server Status Changed from "Processing" to "Online"**',0);
  logModuleCall('VPN Panel', 'Update Server Status after install start', 'Server Status', $editserver, '', '');
  }
  else
  {
  $editserver = Capsule::table('lb_server_list')->where('server_ip', $serverIP)->update(['status' => 1, 'server_port' => $serverportval]);
  logActivity('**VPN Panel - Server - '.$serverIP.' - Server Status Changed from "Processing" to "Online"**',0);
  logModuleCall('VPN Panel', 'Update Server Status after install start', 'Server Status', $editserver, '', '');
  }

  return 'success';
  } */
function grouplist($id = '')
{
    if (!empty($id)) {
        $data = Capsule::table('mod_vpn_groups')->where('id', $id)->get();
    } else {
        $data = Capsule::table('mod_vpn_groups')->get();
    }

    return $data;
}
function saveGroup($data)
{
    $groupname = $data['groupname'];
    $postData = array('groupName' => $groupname);
    $count = Capsule::table('mod_vpn_groups')->where('groupName', $groupname)->count();

    if (isset($data['gid'])) {
        $updateGroup = Capsule::table('mod_vpn_groups')->where('id', $data['gid'])->update($postData);
        if ($updateGroup) {
            return 'success';
        }
    } else {
        if ($count > 0) {
            return 'GroupExists';
        }
        $ddGroup = Capsule::table('mod_vpn_groups')->insert($postData);
        if ($ddGroup) {
            return 'success';
        }
    }
    return 'error';
}
function getServerInfo($serverid)
{
    $servercount = Capsule::table('server_list')->where('server_id', $serverid)->count();
    if ($servercount > 0) {
        $serverdata = Capsule::table('server_list')->where('server_id', $serverid)->get();
        $serverip = $serverdata[0]->server_ip;
        $serversshport = $serverdata[0]->sshport;
        $serversshpass = decryptPass($serverdata[0]->sshpass);
        $servername = $serverdata[0]->server_name;
        $ssh = new Net_SSH2($serverip, $serversshport);
        if (!$ssh->login('root', $serversshpass)) {
            logActivity('**VPN Panel - Server Info - ' . $serverIP . ' - Server Login Failed**', 0);
            return 'LoginFailed';
        }

        //$serverinfohtml = $ssh->exec('cat /root/lshw.html');
        $serverinfohtml = $ssh->exec('cat /etc/*release');

        $serverinfoarray = explode(PHP_EOL, $serverinfohtml);
        $servrinfosingle = array();
        $serverinfohtml = '';
        foreach ($serverinfoarray as $info) {
            $servrinfosingle = explode('=', $info);
            if ($servrinfosingle[0] == 'PRETTY_NAME') {
                break;
            }
            $serverinfohtml .= '<tr><th>' . $servrinfosingle[0] . '</th><td>' . $servrinfosingle[1] . '</td>';
        }

        $ssh->enablePTY();

        $ssh->exec("top -bn 2 -d 0.01 | grep '^%Cpu' | tail -n 1 | gawk '{print $2+$4+$6}'");
        $CPU = $ssh->read();

        $ssh->exec("top -b -o +%MEM | head -n 22");
        $MEM = $ssh->read();
        $memdata = explode(PHP_EOL, $MEM);
        $memdata = explode(' ', $memdata[3]);
        $memdata = array('total' => $memdata[4], 'free' => $memdata[8], 'used' => $memdata[12]);
        $serverInfodata = array('serverip' => $serverip, 'servername' => $servername, 'osinfo' => $serverinfohtml, 'cpu' => $CPU, 'mem' => $memdata);
        return $serverInfodata;
    } else {

        $serverdata = Capsule::table('lb_server_list')->where('server_id', $serverid)->get();
        $serverip = $serverdata[0]->server_ip;
        $serversshport = $serverdata[0]->sshport;
        $serversshpass = decryptPass($serverdata[0]->sshpass);

        $ssh = new Net_SSH2($serverip, $serversshport);
        if (!$ssh->login('root', $serversshpass)) {
            logActivity('**VPN Panel - Server Info - ' . $serverIP . ' - Server Login Failed**', 0);
            return 'LoginFailed';
        }

        //$serverinfohtml = $ssh->exec('cat /root/lshw.html');
        $serverinfohtml = $ssh->exec('cat /etc/*release');

        $serverinfoarray = explode(PHP_EOL, $serverinfohtml);
        $servrinfosingle = array();
        $serverinfohtml = '';
        foreach ($serverinfoarray as $info) {
            $servrinfosingle = explode('=', $info);
            $serverinfohtml .= '<tr><th>' . $servrinfosingle[0] . '</th><td>' . $servrinfosingle[1] . '</td>';
        }
    }

    return $serverinfoarray;
}

function setserverconfig($post)
{
    Capsule::table('mod_vpn_serverconfig')->delete();
    foreach ($post as $key => $data) {
        $serverconfig = Capsule::table('mod_vpn_serverconfig')->insert(['setting' => $key, 'value' => $data]);
        logActivity('**VPN Panel - Server Configuration Settings Saved Successfully**', 0);
    }
    return 'success';
}

function getserverconfig()
{
    $serverconfig = Capsule::table('mod_vpn_serverconfig')->get();
    $configData = array();
    foreach ($serverconfig as $config) {
        $configvalue = explode('|', $config->value);
        $value = $configvalue[0];
        $text = $configvalue[1];
        $configData[$config->setting]['value'] = $value;
        $configData[$config->setting]['text'] = $text;
    }
    return $configData;
}

function getAppLinks()
{
    $moduledata = Capsule::table('mod_vpn_applinks')->get();
    return $moduledata;
}

function systemURL()
{

    $moduledata = Capsule::table('tblconfiguration')->where('setting', 'SystemURL')->select('value')->get();
    $pathdata = parse_url($moduledata[0]->value);
    $proto = 'http';
    if (isset($_SERVER['HTTP_X_FORWARDED_PROTO'])) {
        $proto = $_SERVER['HTTP_X_FORWARDED_PROTO'];
    } else {
        $proto = $_SERVER['REQUEST_SCHEME'];
    }

    return $proto . '://' . $_SERVER['HTTP_HOST'] . $pathdata['path']; //$moduledata[0]->value;
}

function addapp($data)
{
    $appname = $data['appname'];
    $applink = $data['applink'];
    $appfor = $data['appfor'];

    $insertresult = Capsule::table('mod_vpn_applinks')->insert(['appfor' => $appfor, 'appname' => $appname, 'applink' => $applink]);
    if ($insertresult) {
        logActivity('**VPN Panel - New App download link added.**', 0);
        return 'success';
    } else {
        logActivity('**VPN Panel - Error Adding New App download link.**', 0);
        return 'error';
    }
}

function deleteapp($data)
{
    $appid = $data['appid'];

    $insertresult = Capsule::table('mod_vpn_applinks')->where('id', $appid)->delete();
    if ($insertresult) {
        logActivity('**VPN Panel - App Link Deleted.**', 0);
        return 'success';
    } else {
        logActivity('**VPN Panel - Error Deleting app link.**', 0);
        return 'error';
    }
}

function deleteGroup($gid = '')
{
    $deleteGroup = Capsule::table('mod_vpn_groups')->where('id', $gid)->delete();
    if ($deleteGroup) {
        logActivity('**VPN Panel - Server Group Deleted.**', 0);
        return 'success';
    } else {
        logActivity('**VPN Panel - Error Deleting server group.**', 0);
        return 'error';
    }
}

function addserver($post)
{
    $insertServer = Capsule::table('server_list')->insert($post);
    if ($insertServer) {
        $serverIP = $post['server_ip'];
        try {
            $serverid = Capsule::table('server_list')->where('server_ip', $serverIP)->get();
            if (isset($serverid[0]->server_id)) {
                $serversidsdata = Capsule::table('tblproducts')->where('servertype', 'vpnservernoapi')->get();
                foreach ($serversidsdata as $serversiddata) {
                    $serverids = explode(',', $serversiddata->configoption4);

                    array_push($serverids, $serverid[0]->server_id);

                    //$serverids[] = $serverid[0]->server_id;
                    Capsule::table('tblproducts')->where('id', $serversiddata->id)->update(['configoption4' => implode(',', $serverids)]);
                }
                logModuleCall('VPN Panel', 'Install Server', $serverIP, 'Server added to products', '', '');
            } else {
                logModuleCall('VPN Panel', 'Install Server', $serverIP, 'Server not found', '', '');
            }
        } catch (\Throwable $th) {
            logModuleCall('VPN Panel', 'Install Server', $serverIP, 'Error' . $th->getMessage(), '', '');
        }
        return 'success';
    } else {
        return 'error';
    }
}

function editserver($post, $serverid)
{

    $editServer = Capsule::table('server_list')->where('server_id', $serverid)->update($post);

    if ($editServer) {
        logActivity('**VPN Panel - Server Updated Successfully.**', 0);
        return 'success';
    } else {
        logActivity('**VPN Panel - Server Updated failed.**', 0);
        return 'error';
    }
}

function deleteserver($id = '')
{
    $cfapidetails = getcfdetails();
    if (!empty($id)) {
        $serverData = Capsule::table('server_list')->where('server_id', $id)->select('server_ip')->get();
        $server_ip = $serverData[0]->server_ip;

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, 'https://api.cloudflare.com/client/v4/zones/' . $cfapidetails['cfdomain'] . '/dns_records?type=A&name=' . $server_ip . '&match=All');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');


        $headers = array();
        $headers[] = 'X-Auth-Email: ' . $cfapidetails['cfemail'] . '';
        $headers[] = 'X-Auth-Key: ' . $cfapidetails['cfapi'] . '';
        $headers[] = 'Content-Type: application/json';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        $zoneid = '';
        $result = json_decode(curl_exec($ch));
        logModuleCall('VPN Panel', 'Server Record Zone Data', $server_ip . ' Delete',  $result, '', '');
        if ($result->success) {
            $zoneid = $result->result[0]->id;
            logModuleCall('VPN Panel', 'Server Record', $server_ip . ' Zone ID', $zoneid, '', '');
            
            $ch = curl_init();

            curl_setopt($ch, CURLOPT_URL, 'https://api.cloudflare.com/client/v4/zones/' . $cfapidetails['cfdomain'] . '/dns_records/' . $zoneid . '');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'DELETE');


            $headers = array();
            $headers[] = 'X-Auth-Email: ' . $cfapidetails['cfemail'] . '';
            $headers[] = 'X-Auth-Key: ' . $cfapidetails['cfapi'] . '';
            $headers[] = 'Content-Type: application/json';
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

            $result = json_decode(curl_exec($ch));

            if (curl_errno($ch)) {
                echo 'Error:' . curl_error($ch);
            }
            curl_close($ch);
        }

        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close($ch);

        $deleteServer = Capsule::table('server_list')->where('server_id', $id)->delete();

        $deleteServerFiles = Capsule::table('mod_server_certs')->where('server_ip', $server_ip)->delete();
        $deleteNas = Capsule::table('nas')->where('nasname', $server_ip)->delete();
        $disconnectusers = Capsule::table('radacct')->where('nasipaddress', $server_ip)->update(array('acctstoptime' => date("Y-m-d H:i:s")));
        logActivity('**VPN Panel - Server Deleted Successfully.**', 0);
        return $deleteServer;
    } else {
        logActivity('**VPN Panel - Unable to delete server. Server ID not found.**', 0);
        echo 'noserverid';
    }
}

function resetonlineusers()
{
    Capsule::table('radacct')->where('acctstoptime', NULL)->orWhere('acctstoptime', '0000-00-00 00:00:00')->update(array('acctstoptime' => date("Y-m-d H:i:s")));
    return 'success';
}

function resetserverconfig()
{
    Capsule::table('mod_vpn_serverconfig')->delete();
    Capsule::table('mod_vpn_serverconfig')->insert([
        ['setting' => 'token', 'value' => "7cf0ed77a6c9a8388d21e43e760baba07ad86d61"],
        ['setting' => 'ipv6', 'value' => "n|No"],
        ['setting' => 'port', 'value' => "1|1194"],
        ['setting' => 'customport', 'value' => ""],
        ['setting' => 'protocol', 'value' => "udp|UDP"],
        ['setting' => 'dns', 'value' => "3|Cloudflare (Anycast: worldwide)"],
        ['setting' => 'dns1', 'value' => ""],
        ['setting' => 'dns2', 'value' => ""],
        ['setting' => 'logging', 'value' => "on"],
        ['setting' => 'saveconfig', 'value' => "Save Changes"],
    ]);
    return 'success';
}

function deleteallServer()
{
    //$deleteallServer = Capsule::table('server_list')->where('mainserver',0)->join('mod_server_certs','mod_server_certs.server_ip','=','server_list.server_ip')->delete();
    $serversData = Capsule::table('server_list')->where('mainserver', 0)->get();
    foreach ($serversData as $server) {
        Capsule::table('server_list')->where('server_ip', $server->server_ip)->delete();
        Capsule::table('mod_server_certs')->where('server_ip', $server->server_ip)->delete();
        $deleteNas = Capsule::table('nas')->where('nasname', $server->server_ip)->delete();
    }
    //$deletealllbServer = Capsule::table('lb_server_list')->delete();
    //$deletecert = Capsule::table('mod_server_certs')->delete();
    $deleteclientcert = Capsule::table('mod_clients_cert')->delete();
    Capsule::table('mod_vpn_serverconfig')->delete();
    Capsule::table('mod_vpn_serverconfig')->insert([
        ['setting' => 'token', 'value' => "7cf0ed77a6c9a8388d21e43e760baba07ad86d61"],
        ['setting' => 'ipv6', 'value' => "n|No"],
        ['setting' => 'port', 'value' => "1|1194"],
        ['setting' => 'customport', 'value' => ""],
        ['setting' => 'protocol', 'value' => "udp|UDP"],
        ['setting' => 'dns', 'value' => "3|Cloudflare (Anycast: worldwide)"],
        ['setting' => 'dns1', 'value' => ""],
        ['setting' => 'dns2', 'value' => ""],
        ['setting' => 'saveconfig', 'value' => "Save Changes"],
    ]);
    logActivity('**VPN Panel - All Servers Deleted Successfully.**', 0);
    return 'success';
}

function getMainServer()
{
    $mainserverData = Capsule::table('server_list')->where('mainserver', 1)->get();

    return $mainserverData;
}

/* -----------------------LOAD BALANCER SERVER FUNCTIONS-------------------------- */

function addLBserver($post)
{

    $insertServer = Capsule::table('lb_server_list')->insert($post);
    if ($insertServer) {
        logActivity('**VPN Panel - LB Server Added Successfully.**', 0);
        return 'success';
    } else {
        logActivity('**VPN Panel - LB Server Adding Failed.**', 0);
        return 'error';
    }
}

function editLBserver($post, $serverid)
{
    $editServer = Capsule::table('lb_server_list')->where('server_id', $serverid)->update($post);
    if ($editServer) {
        logActivity('**VPN Panel - LB Server Updated Successfully.**', 0);
        return 'success';
    } else {
        logActivity('**VPN Panel - LB Server Update Failed.**', 0);
        return 'error';
    }
}

function deleteLBserver($id = '')
{
    if (!empty($id)) {
        $serverData = Capsule::table('lb_server_list')->where('server_id', $id)->select('server_ip')->get();
        $server_ip = $serverData[0]->server_ip;
        $deleteServer = Capsule::table('lb_server_list')->where('server_id', $id)->delete();

        $deleteServerFiles = Capsule::table('mod_server_certs')->where('server_ip', $server_ip)->delete();
        $deleteNas = Capsule::table('nas')->where('nasname', $server_ip)->delete();
        logActivity('**VPN Panel - LB Server Deleted Successfully.**', 0);
        return $deleteServer;
    } else {
        logActivity('**VPN Panel - LB Server Delete Failed.**', 0);
        echo 'noserverid';
    }
}

function getlbserver($serverid = '', $relid = '')
{
    $Servers = '';
    if (!empty($serverid)) {
        $Servers = Capsule::table('lb_server_list')
            ->where('server_id', $serverid)
            ->orderBy('server_id', 'ASC')
            ->get();
    } else if (!empty($relid)) {
        $Servers = Capsule::table('lb_server_list')
            ->where('relid', $relid)
            ->orderBy('server_id', 'ASC')
            ->get();
    } else {
        $Servers = Capsule::table('lb_server_list')->orderBy('server_id', 'ASC')->get();
    }

    return $Servers;
}

function getallserver()
{
    $lbServers = Capsule::table('lb_server_list')->orderBy('server_id', 'ASC')->get();
    $Servers = Capsule::table('server_list')->orderBy('server_id', 'ASC')->where('mainserver', 0)->get();
    $MainServers = Capsule::table('server_list')->where('mainserver', 1)->get();
    return array('lbServers' => $lbServers, 'Servers' => $Servers, 'MainServer' => $MainServers);
}

function reconfigAll()
{
    $systemURL = systemURL();
    $api = getapi();
    $servers = getallserver();
    Capsule::table('mod_server_certs')->delete();
    Capsule::table('mod_clients_cert')->delete();
    //Capsule::table('server_list')->update(['mainserver' => 0]);
    foreach ($servers['Servers'] as $server) {

        $id = $server->server_id;
        $serverip = $server->server_ip;
        $sshpass = decryptPass($server->sshpass);
        $sshport = $server->sshport;
        $pskkey = $server->pskkey;
        $category = $server->server_category;
        $serverName = $server->server_name;
        $createserver = createServer($serverip, $sshport, $sshpass, $systemURL, $api, 1, $category, $pskkey, $serverName);
        logActivity('**VPN Panel - Server - ' . $serverip . ' Re-config Started.**', 0);
        sleep(2);
        if ($createserver == 'success') {
            if ($server->status !== 2) {
                $status = 2;
                $postdata = array('status' => $status);
                $addserver = editserver($postdata, $id);
                logActivity('**VPN Panel - Server - ' . $serverip . ' Status Changed to processing.**', 0);
                logModuleCall('VPN Panel', 'Server status', $serverip . ' Re-config Start', ': ' . $addserver, '');
            } else {
                logActivity('**VPN Panel - Server - ' . $serverip . ' Status Not Changed to processing. (Already in Processing)**', 0);
                logModuleCall('VPN Panel', 'Server status', $serverip . ' Re-config Start', ': ' . $addserver, '');
            }
        } else {
            logActivity('**VPN Panel - Server - ' . $serverip . ' Re-config Error. (' . $createserver . ')**', 0);
            logModuleCall('VPN Panel', 'Server status', $serverip . ' Re-config Error', 'Response: ' . $createserver, '');
        }
    }
    foreach ($servers['lbServers'] as $server) {
        $id = $server->server_id;
        $serverip = $server->server_ip;
        $sshpass = decryptPass($server->sshpass);
        $sshport = $server->sshport;
        $pskkey = $server->pskkey;
        $category = $server->server_category;
        $serverName = $server->server_name;
        logActivity('**VPN Panel - Server - ' . $serverip . ' Re-config Started.**', 0);
        $createserver = createServer($serverip, $sshport, $sshpass, $systemURL, $api, 1, $category, $pskkey, $serverName);
        sleep(2);
        if ($createserver == 'success') {
            $status = 2;
            $postdata = array('status' => $status);
            $addserver = editlbserver($postdata, $id);
            logActivity('**VPN Panel - Server - ' . $serverip . ' Status Changed to processing.**', 0);
            logModuleCall('VPN Panel', 'Server status', $serverip . ' Re-config LB Start', 'Response: ' . $addserver, '');
        } else {
            logActivity('**VPN Panel - Server - ' . $serverip . ' Re-config Error. (' . $createserver . ')**', 0);
            logModuleCall('VPN Panel', 'Server status', $serverip . ' Re-config LB Error', 'Response: ' . $createserver, '');
        }
    }
    return 1;
}

/* ---------------------------LOAD BALANCER SERVER FUNCTIONS------------------------------------- */
function getServercertfiles($type = "")
{
    $allserversData = Capsule::table('server_list')->where('mainserver', 0)->get();
    $allserver = array();
    $s = 0;
    foreach ($allserversData as $server) {
        if ($server->server_category == 'openvpn-ikev2') {
            $allserver[$s]['file'] = array('ovpn', 'pem');
        }
        if ($server->server_category == 'openvpn') {
            $allserver[$s]['file'] = array('ovpn');
        }
        if ($server->server_category == 'ikev2') {
            $allserver[$s]['file'] = array('pem');
        }
        $allserver[$s]['name'] = $server->server_name;
        $allserver[$s]['ip'] = $server->server_ip;
        $allserver[$s]['id'] = $server->server_id;
        $allserver[$s]['category'] = $server->server_category;
        $allserver[$s]['flag'] = $server->flag;

        $s++;
    }
    return $allserver;
}
function getserverCount($id = '')
{
    $serverCount = Capsule::table('server_list')->where('status', '=', '1')->where('mainserver', 0)->count();
    return $serverCount;
}
function getserver($id = '')
{
    if (!empty($id)) {
        $Servers = Capsule::table('server_list')->where('server_id', $id)->orderBy('server_id', 'ASC')->get();
        return $Servers;
    } else {

        $grouplist = Capsule::table('mod_vpn_groups')->get();
        $i = 0;
        $ServerbyGroups = array();
        $ServerbyGroups['mainserver'] = Capsule::table('server_list')->where('mainserver', 1)->get();
        $ServerbyGroups['nogrpServer'] = $nogrpservers = Capsule::table('server_list')->where('mainserver', 0)->where('server_group', 'All')->get();
        foreach ($nogrpservers as $server) {
            $count = Capsule::table('lb_server_list')->where('relid', $server->server_id)->count();
            $server->lbServer = $count;
            $i++;

            $Onlinecount = Capsule::select("SELECT radacct.Username, radacct.FramedIPAddress, radacct.CallingStationId, radacct.AcctStartTime, radacct.AcctSessionTime, radacct.NASIPAddress, radacct.CalledStationId, radacct.AcctSessionId FROM radacct WHERE (radacct.AcctStopTime IS NULL OR radacct.AcctStopTime = '0000-00-00 00:00:00') AND `nasipaddress` = '" . $server->server_ip . "' ");
            $server->lbServer = $count;

            $server->onlineCount = count($Onlinecount);
        }
        foreach ($grouplist as $group) {
            $ServerbyGroups['servergroup'][$i]['gid'] = $group->id;
            $ServerbyGroups['servergroup'][$i]['gname'] = $group->groupName;

            $ServerbyGroups['servergroup'][$i]['servers'] = $Servers = Capsule::table('server_list')->orderBy('server_id', 'ASC')->where('server_group', $group->id)->get();


            foreach ($Servers as $server) {
                $count = Capsule::table('lb_server_list')->where('relid', $server->server_id)->count();
                $server->lbServer = $count;
                $i++;

                $Onlinecount = Capsule::select("SELECT radacct.Username, radacct.FramedIPAddress, radacct.CallingStationId, radacct.AcctStartTime, radacct.AcctSessionTime, radacct.NASIPAddress, radacct.CalledStationId, radacct.AcctSessionId FROM radacct WHERE (radacct.AcctStopTime IS NULL OR radacct.AcctStopTime = '0000-00-00 00:00:00') AND `nasipaddress` = '" . $server->server_ip . "' ");
                $server->lbServer = $count;

                $server->onlineCount = count($Onlinecount);
            }
            $i++;
        }
    }
    //echo'<pre>';print_r($ServerbyGroups); die();
    return $ServerbyGroups;
}

function vpn_getProducts()
{
    $products = Capsule::table('tblproducts')
        ->select(Capsule::raw('*'))
        ->where('servertype', '=', 'vpnservernoapi')
        ->get();
    return $products;
}

function vpn_getProductbyid($id)
{
    $products = Capsule::table('tblproducts')
        ->select(Capsule::raw('*'))
        ->where('id', '=', $id)
        ->get();
    return $products;
}

function getAllProducts()
{
    $productList = array();
    $productgrouplist = Capsule::table('tblproductgroups')->get();
    $i = 0;
    foreach ($productgrouplist as $productgroup) {
        $products = Capsule::table('tblproducts')
            ->select(Capsule::raw('*'))
            ->where('servertype', '=', 'vpnservernoapi')
            ->where('gid', $productgroup->id)
            ->get();

        foreach ($products as $product) {
            $productList[$productgroup->name][$i]['id'] = $product->id;
            $productList[$productgroup->name][$i]['name'] = $product->name;
            $i++;
        }
    }

    return $productList;
}

function vpn_getClientProducts($userid, $proid)
{
    $command = 'GetClientsProducts';
    $postData = array(
        'clientid' => $userid,
        'pid' => $proid,
    );
    $result_admin = Capsule::table('tbladmins')->where('roleid', '=', '1')->get();
    $adminUsername = $result_admin[0]->username;
    $results = localAPI($command, $postData, $adminUsername);
    return $results;
}

function generateapi($code = '')
{
    Capsule::table('mod_vpn_api')->truncate();
    $createapi = Capsule::table('mod_vpn_api')->insert(['setting' => 'apikey', 'value' => $code]);
    if ($createapi) {
        return 'success';
    } else {
        return 'error';
    }
}

function savesignupproduct($pid = '')
{
    Capsule::table('mod_vpn_settings')->where('settings', 'signupproduct')->delete();
    $savesignupproduct = Capsule::table('mod_vpn_settings')->insert(['settings' => 'signupproduct', 'value' => $pid]);
    if ($savesignupproduct) {
        return 'success';
    } else {
        return 'error';
    }
}

function getsignupproduct()
{
    $savedsignupproduct =  Capsule::table('mod_vpn_settings')->where('settings', 'signupproduct')->get();
    return $savedsignupproduct;
}

function getapi()
{
    $apikey = '';
    $apikeyData = Capsule::table('mod_vpn_api')->select('value')->get();
    if ($apikeyData) {
        $apikey = $apikeyData[0]->value;
    }
    return $apikey;
}

function getResellersList()
{
    $affData = Capsule::table('tblaffiliates')->join('tblclients', 'tblclients.id', '=', 'tblaffiliates.clientid')->where('groupid', 1)
        ->select('tblclients.id as clientid', 'tblclients.firstname as firstname', 'tblclients.lastname as lastname', 'tblclients.email as email', 'tblaffiliates.id as affid', 'tblclients.groupid')->get();
    return $affData;
}
function getSuperResellersList()
{
    $affData = Capsule::table('tblaffiliates')->join('tblclients', 'tblclients.id', '=', 'tblaffiliates.clientid')->where('groupid', 2)
        ->select('tblclients.id as clientid', 'tblclients.firstname as firstname', 'tblclients.lastname as lastname', 'tblclients.email as email', 'tblaffiliates.id as affid', 'tblclients.groupid')->get();
    return $affData;
}

function getusersList($affid)
{
    $affData = Capsule::table('tblaffiliatesaccounts')->where('affiliateid', $affid)->join('tblclients', 'tblclients.id', '=', 'tblaffiliatesaccounts.relid')
        ->select('tblclients.id as clientid', 'tblclients.firstname as firstname', 'tblclients.lastname as lastname', 'tblclients.email as email', 'tblclients.groupid')->get();
    return $affData;
}

function getuserservicesList($userid)
{
    $command = 'GetClientsProducts';
    $postData = array(
        'clientid' => $userid,
        'stats' => true,
    );
    $results = localAPI($command, $postData);
    return $results;
}

function getOwner($userid = '', $getAff = '')
{
    if (!empty($userid)) {
        if (!empty($getAff)) {
            $adminDetails = Capsule::table('tblaffiliates')->where('tblaffiliates.relid', $userid)->join('tblclients', 'tblclients.id', '=', 'tblaffiliates.clientid')->select('tblclients.firstname', 'tblclients.lastname', 'tblclients.email')->get();
            $name = $adminDetails[0]->firstname . ' ' . $adminDetails[0]->lastname . '(' . $adminDetails[0]->email . ')';
            return $name;
        } else {
            $adminDetails = Capsule::table('tblclients')->where('id', $userid)->select('firstname', 'lastname', 'email')->get();
            $name = $adminDetails[0]->firstname . ' ' . $adminDetails[0]->lastname . '(' . $adminDetails[0]->email . ')';
            return $name;
        }
    } else {
        if (!empty($getAff)) {
            $adminDetails = Capsule::table('tblaffiliates')->where('tblaffiliates.id', $getAff)->join('tblclients', 'tblclients.id', '=', 'tblaffiliates.clientid')->select('tblclients.firstname', 'tblclients.lastname', 'tblclients.email')->get();
            $name = $adminDetails[0]->firstname . ' ' . $adminDetails[0]->lastname . '(' . $adminDetails[0]->email . ')';
            return $name;
        } else {

            $uid = $_SESSION['adminid'];
            $adminDetails = Capsule::table('tbladmins')->where('id', $uid)->select('firstname', 'lastname', 'email')->get();
            $name = $adminDetails[0]->firstname . ' ' . $adminDetails[0]->lastname . '(' . $adminDetails[0]->email . ')';
            return $name;
        }
    }
}

function addassignData($post)
{

    $reseller = $post['reseller'];
    $packages = $post['packages'];
    $assigngroup = $post['assigngroup'];
    $assignedDataCount = Capsule::table('mod_vpn_assignpackages')->where('resellerid', $reseller)->where('assigngroup', $assigngroup)->count();
    if ($assignedDataCount > 0) {
        $insertData = Capsule::table('mod_vpn_assignpackages')->where('resellerid', $reseller)->where('assigngroup', $assigngroup)->update(['resellerid' => $reseller, 'products' => rtrim($packages, ',')]);
    } else {
        $insertData = Capsule::table('mod_vpn_assignpackages')->insert(['resellerid' => $reseller, 'products' => rtrim($packages, ','), 'assigngroup' => $assigngroup]);
    }
    if ($insertData) {
        return 'success';
    }
}

function getclients()
{


    $vpnproducts = Capsule::table('tblproducts')->where('servertype', 'vpnservernoapi')->orWhere('servertype', 'resellervpncombination')->select('id')->get();
    $productidsarray = array();
    $totalresults = 0;
    foreach ($vpnproducts as $product) {
        $command = 'GetClientsProducts';
        $postData = array(
            'pid' => $product->id
        );

        $results = localAPI($command, $postData);
        $totalresults += $results['totalresults'];
    }

    return $totalresults;
}

function getresellers()
{
    $command = 'GetClients';
    $results = localAPI($command, '', '');
    return $results['totalresults'];
}

function getpackagename($productids)
{
    $productidarray = explode(',', $productids);
    foreach ($productidarray as $productid) {
        $products = Capsule::table('tblproducts')
            ->select('name')
            ->where('id', '=', $productid)
            ->get();
        $productname[] = $products[0]->name;
    }
    return implode(',', $productname);
}

function getassignedpackages($resellerid = '')
{
    if (!empty($resellerid)) {
        $assignedData = Capsule::table('mod_vpn_assignpackages')->where('resellerid', $resellerid)->join('tblclients', 'tblclients.id', '=', 'mod_vpn_assignpackages.resellerid')->select('mod_vpn_assignpackages.*', 'tblclients.firstname', 'tblclients.lastname', 'tblclients.groupid')->get();
        if (count($assignedData) == 0) {
            $assignedData = Capsule::table('mod_vpn_assignpackages')->get();
        }
        return $assignedData;
    } else {
        $assignedData = Capsule::table('mod_vpn_assignpackages')->join('tblclients', 'tblclients.id', '=', 'mod_vpn_assignpackages.resellerid')->select('mod_vpn_assignpackages.*', 'tblclients.firstname', 'tblclients.lastname', 'tblclients.groupid')->get();
        return $assignedData;
    }
}

function getclientgroupid($name = '')
{
    $groupdata = Capsule::table('tblclientgroups')->where('groupname', $name)->get();
    return $groupdata[0]->id;
}

function getProductGroup()
{
    $productGroup = Capsule::table("tblproductgroups")->select("name")->get();
    return $productGroup;
}

function getallpackagesdata($gid)
{
    $assignedData = Capsule::table('mod_vpn_assignpackages')->where('resellerid', 'all')->where('assigngroup', $gid)->get();
    return $assignedData;
}

function getallserverstatus()
{
    $serversResults = array();
    $serversList = getserver();
    $lbserversList = getlbserver();
    $mainserverList = $serversList['mainserver'];
    $s = 0;
    $lb = 0;
    foreach ($mainserverList as $mainserver) {

        $serverIP = $mainserver->server_ip;
        $serversshport = $mainserver->sshport;
        $serverPass = decryptPass($mainserver->sshpass);
        $serversResults['mainservers'][0]['id'] = $mainserver->server_id;
        $ssh = new Net_SSH2($serverIP, $serversshport);
        if (!$ssh->login('root', $serverPass)) {
            $serversResults['mainservers'][0]['servicestatus'] = 'unabletocheck';
            $serversResults['mainservers'][0]['serverstatus'] = 'invalidpassword';
        } else {
            $freeradiusStatus = $ssh->exec('systemctl is-active freeradius');
            if (trim($freeradiusStatus) !== 'active') {
                $serversResults['mainservers'][0]['serverstatus'] = '';
                $serversResults['mainservers'][0]['servicestatus'] = 'error';
            } else {
                $serversResults['mainservers'][0]['serverstatus'] = '';
                $serversResults['mainservers'][0]['servicestatus'] = '';
            }
        }
    }
    //echo'<pre>'; print_r($serversList); die();
    $nogrpserverList = $serversList['nogrpServer'];
    foreach ($nogrpserverList as $server) {

        $error = '';
        $serversResults['servers'][$s]['id'] = $server->server_id;
        if ($server->status == 1) {
            $pingData = @fsockopen($server->server_ip, $server->sshport, $errno, $errstr, 2);
            if (!$pingData) {
                $serversResults['servers'][$s]['serverstatus'] = 'offline';
                $serversResults['servers'][$s]['servicestatus'] = 'unabletocheck';
            } else {
                $serverIP = $server->server_ip;
                $serversshport = $server->sshport;
                $serverPass = decryptPass($server->sshpass);

                $ssh = new Net_SSH2($serverIP, $serversshport);
                if (!$ssh->login('root', $serverPass)) {
                    $serversResults['servers'][$s]['servicestatus'] = 'unabletocheck';
                    $serversResults['servers'][$s]['serverstatus'] = 'invalidpassword';
                } else {

                    $ovpnStatus = '';
                    $ikevStatus = '';

                    if ($server->server_category == 'openvpn') {
                        $ovpnStatus = $ssh->exec('systemctl is-active openvpn');
                        if (trim($ovpnStatus) !== 'active') {
                            $serversResults['servers'][$s]['serverstatus'] = '';
                            $serversResults['servers'][$s]['servicestatus'] = 'error';
                        } else {
                            $serversResults['servers'][$s]['serverstatus'] = '';
                            $serversResults['servers'][$s]['servicestatus'] = '';
                        }
                    } elseif ($server->server_category == 'openvpn-ikev2') {
                        $ovpnStatus = $ssh->exec('systemctl is-active openvpn');
                        $ikevStatus = $ssh->exec('systemctl is-active ipsec');
                        if (trim($ovpnStatus) !== 'active') {
                            $serversResults['servers'][$s]['serverstatus'] = '';
                            $serversResults['servers'][$s]['servicestatus'] = 'error';
                        }
                    } elseif ($server->server_category == 'ikev2') {
                        $ikevStatus = $ssh->exec('systemctl is-active ipsec');
                        if (trim($ikevStatus) !== 'active') {
                            $serversResults['servers'][$s]['serverstatus'] = '';
                            $serversResults['servers'][$s]['servicestatus'] = '';
                        } else {
                            $serversResults['servers'][$s]['serverstatus'] = '';
                            $serversResults['servers'][$s]['servicestatus'] = '';
                        }
                    }
                }
            }
        } else {
            $serversResults['servers'][$s]['serverstatus'] = 'processing';
            $serversResults['servers'][$s]['servicestatus'] = 'processing';
        }

        $s++;
    }
    $serverList = $serversList['servergroup'];
    foreach ($serverList as $server) {
        foreach ($server['servers'] as $server) {
            $error = '';
            $serversResults['servers'][$s]['id'] = $server->server_id;
            if ($server->status == 1) {
                $pingData = @fsockopen($server->server_ip, $server->sshport, $errno, $errstr, 2);
                if (!$pingData) {
                    $serversResults['servers'][$s]['serverstatus'] = 'offline';
                    $serversResults['servers'][$s]['servicestatus'] = 'unabletocheck';
                } else {
                    $serverIP = $server->server_ip;
                    $serversshport = $server->sshport;
                    $serverPass = decryptPass($server->sshpass);

                    $ssh = new Net_SSH2($serverIP, $serversshport);
                    if (!$ssh->login('root', $serverPass)) {
                        $serversResults['servers'][$s]['servicestatus'] = 'unabletocheck';
                        $serversResults['servers'][$s]['serverstatus'] = 'invalidpassword';
                    } else {

                        $ovpnStatus = '';
                        $ikevStatus = '';

                        if ($server->server_category == 'openvpn') {
                            $ovpnStatus = $ssh->exec('systemctl is-active openvpn');
                            if (trim($ovpnStatus) !== 'active') {
                                $serversResults['servers'][$s]['serverstatus'] = '';
                                $serversResults['servers'][$s]['servicestatus'] = 'error';
                            } else {
                                $serversResults['servers'][$s]['serverstatus'] = '';
                                $serversResults['servers'][$s]['servicestatus'] = '';
                            }
                        } elseif ($server->server_category == 'openvpn-ikev2') {
                            $ovpnStatus = $ssh->exec('systemctl is-active openvpn');
                            $ikevStatus = $ssh->exec('systemctl is-active ipsec');
                            if (trim($ovpnStatus) !== 'active') {
                                $serversResults['servers'][$s]['serverstatus'] = '';
                                $serversResults['servers'][$s]['servicestatus'] = 'error';
                            }
                        } elseif ($server->server_category == 'ikev2') {
                            $ikevStatus = $ssh->exec('systemctl is-active ipsec');
                            if (trim($ikevStatus) !== 'active') {
                                $serversResults['servers'][$s]['serverstatus'] = '';
                                $serversResults['servers'][$s]['servicestatus'] = '';
                            } else {
                                $serversResults['servers'][$s]['serverstatus'] = '';
                                $serversResults['servers'][$s]['servicestatus'] = '';
                            }
                        }
                    }
                }
            } else {
                $serversResults['servers'][$s]['serverstatus'] = 'processing';
                $serversResults['servers'][$s]['servicestatus'] = 'processing';
            }

            $s++;
        }
    }

    $serverList = $lbserversList;
    foreach ($serverList as $server) {
        $error = '';
        $serversResults['lbservers'][$lb]['id'] = $server->server_id;
        if ($server->status == 1) {
            $pingData = @fsockopen($server->server_ip, $server->sshport, $errno, $errstr, 2);
            if (!$pingData) {
                $serversResults['lbservers'][$lb]['serverstatus'] = 'offline';
                $serversResults['lbservers'][$lb]['servicestatus'] = 'unabletocheck';
            } else {
                $serverIP = $server->server_ip;
                $serversshport = $server->sshport;
                $serverPass = decryptPass($server->sshpass);

                $ssh = new Net_SSH2($serverIP, $serversshport);
                if (!$ssh->login('root', $serverPass)) {
                    $serversResults['lbservers'][$lb]['servicestatus'] = 'unabletocheck';
                    $serversResults['lbservers'][$lb]['serverstatus'] = 'invalidpassword';
                } else {

                    $ovpnStatus = '';
                    $ikevStatus = '';

                    if ($server->server_category == 'openvpn') {
                        $ovpnStatus = $ssh->exec('systemctl is-active openvpn');
                        if (trim($ovpnStatus) !== 'active') {
                            $serversResults['lbservers'][$lb]['serverstatus'] = '';
                            $serversResults['lbservers'][$lb]['servicestatus'] = 'error';
                        } else {
                            $serversResults['lbservers'][$lb]['serverstatus'] = '';
                            $serversResults['lbservers'][$lb]['servicestatus'] = '';
                        }
                    }
                }
            }
        } else {
            $serversResults['lbservers'][$lb]['serverstatus'] = 'processing';
            $serversResults['lbservers'][$lb]['servicestatus'] = 'processing';
        }
        $lb++;
    }
    if (!empty($serversResults)) {
        return json_encode($serversResults);
    } else {
        return 'success';
    }
}
