<?php

use Illuminate\Database\Capsule\Manager as DB;

function vpn_getVPNServices() 
{
    try
    {

        $allClients = DB::table('tblclients')
                            ->join('tblhosting', 'tblclients.id', '=', 'tblhosting.userid')
                            ->join('tblproducts', 'tblproducts.id', '=', 'tblhosting.packageid')
                            ->select('tblclients.id','tblclients.firstname','tblclients.lastname','tblclients.updated_at','tblclients.email','tblclients.status','tblclients.notes')
                            ->where('tblproducts.servertype','ownervpncombination')
                            ->orWhere('tblproducts.servertype','vpnservernoapi')
                            ->distinct('tblclients.id')
                            ->get();

        return ['status' => 'success', 'records' => $allClients];

    } 
    catch (\Exception $e)
    {
        return ['status' => 'error', 'message' => "There is error while getting the record.Error :- {$e->getMessage()}"];
    }
    
}


function vpn_getClientServices($clientid)
{
    try
    {
        $records = DB::table('tblhosting')
                ->join('tblproducts', 'tblproducts.id', '=', 'tblhosting.packageid')
                ->join('tblproductgroups', 'tblproducts.gid', '=', 'tblproductgroups.id')
                ->select('tblproductgroups.name as groupname','tblproducts.name','tblhosting.packageid','tblhosting.id as serviceid','tblhosting.billingcycle','tblhosting.nextduedate','tblhosting.domainstatus','tblhosting.username','tblhosting.password','tblhosting.userid','tblhosting.regdate','tblhosting.amount','tblhosting.domainstatus')
                ->where("userid", $clientid)
                //->where('tblproducts.servertype','ownervpncombination')
                ->get();

        if(!empty($records))
        {   
            foreach ($records as $record) 
            {
                if($record->password)
                {
                    $record->password = decrypt($record->password);
                    
                }
                
                if($record->nextduedate)
                {
                    $record->nextduedate = fromMySQLDate($record->nextduedate);
                }
            }
        }

        return $records;
    }
    catch (\Exception $e)
    {
        return 0;
    }
    
}


function vpn_getClientServicesCount($clientid)
{
    try
    {
        $records = DB::table('tblhosting')
                ->join('tblproducts', 'tblproducts.id', '=', 'tblhosting.packageid')
                //->join('tblproductgroups', 'tblproducts.gid', '=', 'tblproductgroups.id')
                ->select('tblhosting.id','tblhosting.domainstatus')
                ->where("userid", $clientid)
                //->where('tblproducts.servertype','ownervpncombination')
                ->get();

        if(!empty($records))
        {   
            $activeCount = 0;
            $Count = 0;
            
            foreach ($records as $record) 
            {
                $Count++;
                
                if($record->domainstatus =='Active' || $record->domainstatus =='Suspended')
                {
                    $activeCount++;
                }
                
            }
        }

        return $activeCount."($Count)";
    }
    catch (\Exception $e)
    {
        return 0;
    }
    
}




function vpn_getServiceUserName($serviceid)
{
    return DB::table('tblhosting')->where("id", $serviceid)->value('username');
    
}


function vpn_getClientNameByUsername($username)
{
    return  DB::table('tblhosting')
            ->join('tblclients', 'tblclients.id', '=', 'tblhosting.userid')
            ->where("username", $username)
            ->select('tblclients.id as userid','tblclients.firstname','tblclients.lastname','tblhosting.id as serviceid')
            ->get();
    
}


function vpn_getDailyUsageDetails($details) 
{
    $serviceid = $details["serviceid"];
    $fromdate = $details["fromdate"]; //"2017-05-20";
    $todate = $details["todate"]. " 23:59:59"; //"2017-05-22";

    $username = vpn_getServiceUserName($serviceid);
    
    return DB::select('SELECT

                        sum(AcctOutputOctets) as downloads,
                        sum(acctinputoctets) as uploads, 
                        date(AcctStartTime) AS day, 
                        SUM(AcctOutputOctets) + SUM(acctinputoctets) AS total 
                        
                        from radacct
                        
                        where UserName="'.$username.'" 
                        AND acctstoptime > 0 
                        AND AcctStartTime > "'.$fromdate.'" 
                        AND AcctStartTime < "'.$todate.'"
                        
                        group by day ORDER BY username asc');
}



function vpn_getMonthlyUsageDetails($details) 
{
    $serviceid = $details["serviceid"];
    $fromdate = $details["fromdate"]; //"2017-05-20";
    $todate = $details["todate"]. " 23:59:59"; //"2017-05-22";

    $username = vpn_getServiceUserName($serviceid);
    
    return DB::select('SELECT

                        sum(AcctOutputOctets) as downloads,
                        sum(acctinputoctets) as uploads, 
                        monthname(AcctStartTime) AS month, 
                        
                        year(AcctStartTime) AS year,
                        
                        SUM(AcctOutputOctets) + SUM(acctinputoctets) AS total
                        
                        from radacct
                        
                        where UserName="'.$username.'" 
                        AND acctstoptime > 0 
                        AND AcctStartTime > "'.$fromdate.'" 
                        AND AcctStartTime < "'.$todate.'"
                        
                        group by month ORDER BY username asc');
}


function vpn_getYearlyUsageDetails($details) 
{
    $serviceid = $details["serviceid"];
    $fromdate = $details["fromdate"]; //"2017-05-20";
    $todate = $details["todate"]. " 23:59:59"; //"2017-05-22";

    $username = vpn_getServiceUserName($serviceid);
    
    return DB::select('SELECT

                        sum(AcctOutputOctets) as downloads,
                        sum(acctinputoctets) as uploads, 
                        year(AcctStartTime) AS year, 
                        SUM(AcctOutputOctets) + SUM(acctinputoctets) AS total 
                        
                        from radacct
                        
                        where UserName="'.$username.'" 
                        AND acctstoptime > 0 
                        AND AcctStartTime > "'.$fromdate.'" 
                        AND AcctStartTime < "'.$todate.'"
                        
                        group by year ORDER BY username asc');
}


function vpn_getOnlineUsers()
{
    return DB::select("SELECT 
            
                        radacct.Username, radacct.FramedIPAddress, radacct.CallingStationId, 
                        radacct.AcctStartTime, radacct.AcctSessionTime, radacct.NASIPAddress,
                        radacct.CalledStationId, radacct.AcctSessionId 
                        
                        FROM radacct 
                        
                        WHERE (radacct.AcctStopTime IS NULL OR radacct.AcctStopTime = '0000-00-00 00:00:00')"
                );
}


function vpn_getOnlineUsersCount()
{
    return DB::table('radacct')
            ->where("AcctStopTime",NULL)
            ->orWhere("AcctStopTime",'0000-00-00 00:00:00')
            ->count();
}


function vpn_formatUsage($details,$m ='d')
{
    $formattedUsage = array();
    
    $formattedUsage['usage']= array();
    $formattedUsage['total']= array();
    
    if(!empty($details))
    {
        $totalUpload = 0;
        $totalDownload = 0;
        $totalUsage = 0;
        
        foreach ($details as $detail)
        {
            $obj = new stdClass();
            
            $obj->uploads = vpn_byteSize($detail->uploads);
            $obj->downloads = vpn_byteSize($detail->downloads);
            $obj->total = vpn_byteSize($detail->total);
            
            if($m =='m')
            {
                $obj->day = $detail->month.','.$detail->year;
            }
            else if($m=='y')
            {
                $obj->day = $detail->year;
            }
            else
            {
                $obj->day = fromMySQLDate($detail->day);
            }
            
            
            
            $totalUpload += $detail->uploads;
            $totalDownload += $detail->downloads;
            $totalUsage += $detail->total;
            
            $formattedUsage['usage'][] = $obj;
            
        }
        
        $totalObj = new stdClass();
        
        $totalObj->uploads = vpn_byteSize($totalUpload);
        $totalObj->downloads = vpn_byteSize($totalDownload);
        $totalObj->total = vpn_byteSize($totalUsage);
        
        $formattedUsage['total']= $totalObj;
    }
    
    
    
    return $formattedUsage;
}



function vpn_byteSize($bytes)
{
    $size = $bytes / 1024;
    
    if ($size < 1024)
    {
        $size = number_format($size, 2);
        $size .= ' KB';
    }
    else
    {
        if ($size / 1024 < 1024) 
        {
            $size = number_format($size / 1024, 2);
            $size .= ' MB';
        }
        else if ($size / 1024 / 1024 < 1024)
        {
            $size = number_format($size / 1024 / 1024, 2);
            $size .= ' GB';
        }
    }
    return $size;
}

/*
 * Only to convert WHMCS gernal setting date format to PHP format
 * 
 */

function vpn_Formatdate($date = NULL, $onlyDate = NULL, $dateformat = NULL) 
{
    global $CONFIG;
        
    if( empty($dateformat) )
    {
        $dateformat = $CONFIG['DateFormat'];
    }
    
    if ($dateformat == 'DD/MM/YYYY') 
    {
        $format = 'd/m/Y H:i:s';
        
        if (!empty($onlyDate))
        {
            $format = 'd/m/Y';
        }
    }
    else if ($dateformat == 'DD.MM.YYYY')
    {
        $format = 'd.m.Y H:i:s';
        
        if(!empty($onlyDate))
        { 
            $format = 'd.m.Y';  
        }
    }
    else if ($dateformat == 'DD-MM-YYYY')
    {
        $format = 'd-m-Y H:i:s';
        
        if (!empty($onlyDate))
        { 
            $format = 'd-m-Y';
        }
    }
    else if ($dateformat == 'MM/DD/YYYY') 
    {
        $format = 'm/d/Y H:i:s';
        
        if (!empty($onlyDate))
        {    
            $format = 'm/d/Y';
        }
    }
    else if ($dateformat == 'YYYY/MM/DD') 
    {
        $format = 'Y/m/d H:i:s';
        
        if (!empty($onlyDate))
        {  
            $format = 'Y/m/d';
        }
    }
    else if ($dateformat == 'YYYY-MM-DD') 
    {
        $format = 'Y-m-d H:i:s';
        
        if (!empty($onlyDate))
        {   
            $format = 'Y-m-d';
        }
    }

    if (empty($date))
    {   
        $date = date('Y-m-d');
        
    }

    $convertdate = strtotime($date);
    
    return date($format, $convertdate);
}


function vpn_FormatdateForMonYr($date = NULL, $onlyDate = NULL, $dateformat = NULL)
{
    global $CONFIG;
        
    if( empty($dateformat) )
    {
        $dateformat = $CONFIG['DateFormat'];
    }
    
    if ($dateformat == 'DD/MM/YYYY') 
    {
        $format = 'd/m/Y H:i:s';
        
        if (!empty($onlyDate))
        {
            $format = 'm/Y';
        }
    }
    else if ($dateformat == 'DD.MM.YYYY')
    {
        $format = 'd.m.Y H:i:s';
        
        if(!empty($onlyDate))
        { 
            $format = 'm.Y';  
        }
    }
    else if ($dateformat == 'DD-MM-YYYY')
    {
        $format = 'd-m-Y H:i:s';
        
        if (!empty($onlyDate))
        { 
            $format = 'm-Y';
        }
    }
    else if ($dateformat == 'MM/DD/YYYY') 
    {
        $format = 'm/d/Y H:i:s';
        
        if (!empty($onlyDate))
        {    
            $format = 'm/Y';
        }
    }
    else if ($dateformat == 'YYYY/MM/DD') 
    {
        $format = 'Y/m/d H:i:s';
        
        if (!empty($onlyDate))
        {  
            $format = 'Y/m';
        }
    }
    else if ($dateformat == 'YYYY-MM-DD') 
    {
        $format = 'Y-m-d H:i:s';
        
        if (!empty($onlyDate))
        {   
            $format = 'Y-m';
        }
    }

    if (empty($date))
    {   
        $date = date('Y-m');
        
    }

    $convertdate = strtotime($date);
    
    return date($format, $convertdate);
}


function vpn_FormatdateForMonYrForSmarty($dateformat = NULL)
{
    global $CONFIG;
        
    if( empty($dateformat) )
    {
        $dateformat = $CONFIG['DateFormat'];
    }
    
    if ($dateformat == 'DD/MM/YYYY') 
    {
        $format = 'mm/yy';
    }
    else if ($dateformat == 'DD.MM.YYYY')
    {
        $format = 'mm.yy';
    }
    else if ($dateformat == 'DD-MM-YYYY')
    {
        $format = 'mm-yy';
    }
    else if ($dateformat == 'MM/DD/YYYY') 
    {
        $format = 'mm/yy';
    }
    else if ($dateformat == 'YYYY/MM/DD') 
    {
        $format = 'yy/mm';
    }
    else if ($dateformat == 'YYYY-MM-DD') 
    {
        $format = 'yy-mm';
    }
    
    return $format;
}



function vpn_FormatdateForMonYrToFull($date = NULL, $mode = 'from',$onlyDate = NULL,$dateformat = NULL)
{
    global $CONFIG;
    
    $d = '01';#from
    
    if($mode =='to')
    {
        $d = date('d');
    }

    
    if( empty($dateformat) )
    {
        $dateformat = $CONFIG['DateFormat'];
    }
    
    if ($dateformat == 'DD/MM/YYYY') 
    {
        $format = 'd/m/Y H:i:s';
        
        $date = $d."/".$date; 
        
        if (!empty($onlyDate))
        {
            $format = "d/m/Y";
        }
    }
    else if ($dateformat == 'DD.MM.YYYY')
    {
        $format = 'd.m.Y H:i:s';
        
        $date = $d.".".$date;
        
        if(!empty($onlyDate))
        { 
            $format = "d.m.Y";  
        }
    }
    else if ($dateformat == 'DD-MM-YYYY')
    {
        $format = 'd-m-Y H:i:s';
        
        $date = $d."-".$date;
        
        if (!empty($onlyDate))
        { 
            $format = "d-m-Y";
        }
    }
    else if ($dateformat == 'MM/DD/YYYY') 
    {
        $format = 'm/d/Y H:i:s';
        
        $datearr = explode("/",$date);
        
        $date = $datearr[0]."/$d"."/".$datearr[1];
        
        if (!empty($onlyDate))
        {    
            $format = "m/d/Y";
        }
    }
    else if ($dateformat == 'YYYY/MM/DD') 
    {
        $format = 'Y/m/d H:i:s';
        
        $date = $date."/".$d;
        
        if (!empty($onlyDate))
        {  
            $format = "Y/m/d";
        }
    }
    else if ($dateformat == 'YYYY-MM-DD') 
    {
        $format = 'Y-m-d H:i:s';
        
        $date = $date."-".$d;
        
        if (!empty($onlyDate))
        {   
            $format = "Y-m-d";
        }
    }

    if (empty($date))
    {   
        $date = date('Y-m-d');
        
    }

    $convertdate = strtotime($date);
    
    return date($format, $convertdate);
}


function vpn_FormatdateForYrToFull($date = NULL, $mode = 'from',$onlyDate = NULL,$dateformat = NULL)
{
    global $CONFIG;
    
    $d = '01';#from
    
    $m = '01';
    
    if($mode =='to')
    {
        $d = date('d');
        
        $m = date('m');
    }

    
    if( empty($dateformat) )
    {
        $dateformat = $CONFIG['DateFormat'];
    }
    
    if ($dateformat == 'DD/MM/YYYY') 
    {
        $format = 'd/m/Y H:i:s';
        
        $date = $d."/"."/$m".$date; 
        
        if (!empty($onlyDate))
        {
            $format = "d/m/Y";
        }
    }
    else if ($dateformat == 'DD.MM.YYYY')
    {
        $format = 'd.m.Y H:i:s';
        
        $date = $d.".".$m.".".$date;
        
        if(!empty($onlyDate))
        { 
            $format = "d.m.Y";  
        }
    }
    else if ($dateformat == 'DD-MM-YYYY')
    {
        $format = 'd-m-Y H:i:s';
        
        $date = $d."-"."$m-".$date;
        
        if (!empty($onlyDate))
        { 
            $format = "d-m-Y";
        }
    }
    else if ($dateformat == 'MM/DD/YYYY') 
    {
        $format = 'm/d/Y H:i:s';
        
        $date = $m."/".$d."/".$date;
        
        if (!empty($onlyDate))
        {    
            $format = "m/d/Y";
        }
    }
    else if ($dateformat == 'YYYY/MM/DD') 
    {
        $format = 'Y/m/d H:i:s';
        
        $date = $date."/$m/".$d;
        
        if (!empty($onlyDate))
        {  
            $format = "Y/m/d";
        }
    }
    else if ($dateformat == 'YYYY-MM-DD') 
    {
        $format = 'Y-m-d H:i:s';
        
        $date = $date."-$m-".$d;
        
        if (!empty($onlyDate))
        {   
            $format = "Y-m-d";
        }
    }

    if (empty($date))
    {   
        $date = date('Y-m-d');
        
    }

    $convertdate = strtotime($date);
    
    return date($format, $convertdate);
}





/*
 * seconds to sec/min/hour/day format
 */
function vpn_time2str($time)
{

    $str = "";				// initialize variable
    $time = floor($time);
    
    if(!$time)
    {   
        return "0 seconds";
    }
    
    $d = $time/86400;
    $d = floor($d);
    
    if($d)
    {
            $str .= "$d days, ";
            $time = $time % 86400;
    }
    
    $h = $time/3600;
    $h = floor($h);
    
    if($h)
    {
        $str .= "$h hours, ";
        $time = $time % 3600;
    }
    
    $m = $time/60;
    $m = floor($m);
    
    if($m)
    {
            $str .= "$m minutes, ";
            $time = $time % 60;
    }
    
    if($time)
    {
        $str .= "$time seconds, ";
    }
    
    $str = preg_replace("/, $/",'',$str);
    
    return $str;
}
