<?php

use WHMCS\Database\Capsule;

function Xtreamtrickadmin_GenerateHash($qtd) {
//Under the string $Caracteres you write all the characters you want to be used to randomly generate the code. 
    $Caracteres = 'ABCDEFGHIJKLMOPQRSTUVXWYZabcdefghijklmnopqrstuvqxyz0123456789';
    $QuantidadeCaracteres = strlen($Caracteres);
    $QuantidadeCaracteres--;

    $Hash = NULL;
    for ($x = 1; $x <= $qtd; $x++) {
        $Posicao = rand(0, $QuantidadeCaracteres);
        $Hash .= substr($Caracteres, $Posicao, 1);
    }

    return $Hash;
}

function GetConfigXtreamDetailsHourDiff() {
    $config = Capsule::table('mod_xtreamConfig')->get();
    foreach ($config as $value) {
        $row[$value->setting] = $value->value;
    }
    return $row['HourDiff'];
}

function WithoutLogin_getCustomFieldID($fieldName, $type) {
    $get_field_id = Capsule::table('tblcustomfields')
            ->where('fieldname', '=', $fieldName)
            ->where('type', '=', $type)
            ->select('tblcustomfields.id')
            ->get();
    $FieldID = $get_field_id[0]->id;
    return $FieldID;
}

function xtream_getProducts() {
    $products = Capsule::table('tblproducts')
            ->select(Capsule::raw('*'))
            ->where('servertype', '=', 'XtreamCode')
            ->get();
    return $products;
}

function xtream_getClientProducts($userid, $proid) {
    $command = 'GetClientsProducts';
    $postData = array(
        'clientid' => $userid,
        'pid' => $proid,
    );
    $result_admin = Capsule::table('tbladmins')->where('roleid', '=', '1')->get();
    $adminUsername = $result_admin[0]->username;
    $results = localAPI($command, $postData, $adminUsername);
    return $results;
}

function xtream_getClientsServicesOfResellersByResellerID($ResellerID = "") {
    $FinalReturnArray = array();
    $clients_detail = array();
    $ClientsAffUserIds = array();
    $affclients = Capsule::table('mod_xtreamAffs_clients')
            ->where('affiliatesid', xtream_getWHMCSaffid($ResellerID))
            ->get();
    if (!empty($affclients)) {
        foreach ($affclients as $clientdetails) {
            $ClientsAffUserIds[] = $clientdetails->clientid;
        }
    }

    if (!empty($ClientsAffUserIds)) {
        $AllServices = Capsule::table('tblhosting')
                ->whereIn('userid', $ClientsAffUserIds)
                ->count();
        $AllActiveServices = Capsule::table('tblhosting')
                ->whereIn('userid', $ClientsAffUserIds)
                ->where('domainstatus', 'Active')
                ->count();
        $AllFreeServices = Capsule::table('tblhosting')
                ->join('tblproducts', 'tblhosting.packageid', '=', 'tblproducts.id')
                ->where('tblproducts.configoption5', 'Yes')
                ->whereIn('tblhosting.userid', $ClientsAffUserIds)
                ->select('tblproducts.*', 'tblhosting.id as hostingid')
                ->count();
        $AllActiveFreeServices = Capsule::table('tblhosting')
                ->join('tblproducts', 'tblhosting.packageid', '=', 'tblproducts.id')
                ->where('tblproducts.configoption5', 'Yes')
                ->where('tblhosting.domainstatus', 'Active')
                ->whereIn('tblhosting.userid', $ClientsAffUserIds)
                ->select('tblproducts.*', 'tblhosting.id as hostingid')
                ->count();
        $FinalReturnArray['TotalServices'] = $AllServices;
        $FinalReturnArray['TotalActiveServices'] = $AllActiveServices;
        $FinalReturnArray['TotalFreeServices'] = $AllFreeServices;
        $FinalReturnArray['TotalActiveFreeServices'] = $AllActiveFreeServices;
    }

    return $FinalReturnArray;
}

function xtream_getWHMCSaffid($XtreamID = "") {
    $command = 'getaffiliates';
    $adminuser = xtream_adminname_forapi();
    $values['userid'] = $XtreamID;
    $affdetails = localAPI($command, $values, $adminuser);
    if ($affdetails['result'] === 'success' && $affdetails['totalresults'] == 1) {
        $affdetails = $affdetails['affiliates']['affiliate'][0];
    }
    return $affdetails['id'];
}

function xtream_adminname_forapi() {
    $result_admin = Capsule::table('tbladmins')->where('roleid', '=', '1')->get();
    $$adminUsername = $result_admin[0]->username;
    return $adminUsername;
}

function xtream_WHMCSClientDetails($clientid) {
    $clients = Capsule::table('tblclients')
            ->select(Capsule::raw('*'))
            ->where('id', '=', $clientid)
            ->select('firstname', 'lastname', 'companyname', 'email', 'id as client_id')
            ->get();
    $customfields = Capsule::table('tblcustomfields')
            ->join('tblcustomfieldsvalues', 'tblcustomfields.id', '=', 'tblcustomfieldsvalues.fieldid')
            ->select('tblcustomfields.fieldname', 'tblcustomfieldsvalues.*')
            ->where('tblcustomfields.type', '=', "client")
            ->where('tblcustomfieldsvalues.relid', '=', $clientid)
            ->where('tblcustomfields.fieldname', '=', 'logincode')
            ->get();
    if (isset($clients[0]) && !empty($clients[0])) {
        if (isset($customfields) && !empty($customfields)) {
            foreach ($customfields as $customfield) {
                if ($customfield->fieldname == 'logincode') {
                    $clients[0] = array_merge((array) $clients[0], array('logincode' => $customfield->value));
                }
            }
            !empty($clients[0]) ? $clients_data = (array) $clients[0] : '';
        } else {
            !empty($clients[0]) ? $clients_data = (array) $clients[0] : '';
        }
    }
    return $clients_data;
}

function xtream_getClientsCreditsOfResellersByResellerID($ResellerID = "") {
    $FinalReturnArray = array();
    $command = 'GetCredits';
    $postData = array(
        'clientid' => $ResellerID,
    );
    $adminUsername = xtream_adminname_forapi(); // Optional for WHMCS 7.2 and later

    $results = localAPI($command, $postData, $adminUsername);
    //echo "<pre>";print_r($results);echo "</pre>";
    if (isset($results['result']) && $results['result'] == "success") {
        $creditBalance = Capsule::table('tblclients')
                ->where('id', '=', $results['clientid'])
                ->select('credit')
                ->get();

        $MainAmmount = $creditBalance[0]->credit;
        $DeductionAmmount = 0;
        foreach ($results['credits']['credit'] as $Crdata) {
            if ($Crdata['amount'] <= 0) {
                $DeductionAmmount += $Crdata['amount'];
            }
        }
        $FinalDeductionAmmount = str_replace("-", "", $DeductionAmmount);

        //echo $FinalDeductionAmmount."   ".$MainAmmount;
        $FinalReturnArray['DeductedAmount'] = $FinalDeductionAmmount;
        $FinalReturnArray['BalanceAmount'] = $MainAmmount;
    }
    return $FinalReturnArray;
}

/* function xtream_getClientsCreditsOfResellersByResellerID2($ResellerID = "")
  {
  $FinalReturnArray = array();
  $command = 'GetCredits';
  $postData = array(
  'clientid' => $ResellerID,
  );
  $adminUsername = xtream_adminname_forapi(); // Optional for WHMCS 7.2 and later

  $results = localAPI($command, $postData, $adminUsername);
  //echo "<pre>";print_r($results);echo "</pre>";
  if(isset($results['result']) && $results['result'] == "success")
  {
  $creditBalance = Capsule::table('tblclients')
  ->where('id', '=', $results['clientid'])
  ->select('credit')
  ->get();

  $MainAmmount = $creditBalance[0]->credit;
  $DeductionAmmount = 0;
  foreach($results['credits']['credit'] as $Crdata)
  {
  if ($Crdata['amount'] <= 0 )
  {
  $DeductionAmmount+=  $Crdata['amount'];
  }
  }
  $FinalDeductionAmmount = str_replace("-","",$DeductionAmmount);

  echo $FinalDeductionAmmount."   ".$MainAmmount;
  $FinalReturnArray['DeductedAmount'] = $FinalDeductionAmmount;
  $FinalReturnArray['BalanceAmount'] = $MainAmmount;
  }
  return $FinalReturnArray;
  } */
?>