<?php

namespace WHMCS\Module\Addon\AddonModule\Admin;

use WHMCS\Database\Capsule;

?>
<div class="alert alert-success fade in alert-dismissable" style="margin-top:18px;display: none;" id="messagebox">
    <a href="#" class="close" data-dismiss="alert" aria-label="close" title="close">&#215;</a>
    Imported Successfully.
</div>
<?php
$userTypes = array("streamline" => "Streaming Line + MAG Device", "streamlineeng" => "Streaming Line + Enigma Device", "streamlineonly" => "Streaming Line", "magdevice" => "MAG Device", "engdevice" => "Enigma Device");
?>
<ul class="nav nav-tabs admin-tabs" role="tablist">
    <li class="active"><a class="tab-top" href="#tab1" role="tab" data-toggle="tab" id="tabLink1" data-tab-id="1">Import</a></li>
</ul>
<div class="tab-content admin-tabs">
    <div class="tab-pane active" id="tab1">
        <form method="post">
            <table class="form" width="100%" border="0" cellspacing="2" cellpadding="3">
                <tbody>
                    <tr>
                        <td class="fieldlabel">Select Import Types</td>
                        <td class="fieldarea">
                            <select name="user_types" class="form-control select-inline" id="userTypes">
                                <option value="">None</option>
                                <?php foreach ($userTypes as $typeKey => $typeName) {
                                    if ($typeKey == "streamlineonly") {
                                ?>
                                        <option value="<?php echo $typeKey; ?>"><?php echo $typeName; ?></option>
                                    <?php
                                    }
                                    ?>
                                <?php } ?>

                            </select>
                        </td>
                    </tr>
                </tbody>
            </table>
            <div class="btn-container"> <input type="submit" class="btn btn-primary" name="import" value="Search"></div>
        </form>

    </div>
</div>

<br><br>
<?php
$controller = new Controller();
$TestConnectionAction = "XtreamDashboard_TestConnection";
$GetStreamLinesAction = "XtremeDashboard_GetStreamLines";
$CheckUserAction = "XtremeDashboard_CheckWHMCSUserStream";
$GetProductsAction = "XtremeDashboard_GetProducts";
//$GetMemberGroups = "XtremeDashboard_GetMemberGroups";

if (isset($_POST['import']) && !empty($_POST['import'])) {
    // Verify requested action is valid and callable
    if (is_callable(array($controller, $TestConnectionAction))) {
        $TestConnectionResult = $controller->$TestConnectionAction();
        if ($TestConnectionResult['status'] == "success") {
            if (isset($_GET['member_id']) && !empty($_GET['member_id'])) {
                $GetStreamLinesResult = $controller->$GetStreamLinesAction($_POST['user_types'], $_GET['member_id']);
            } else {
                $GetStreamLinesResult = $controller->$GetStreamLinesAction($_POST['user_types'], "");
            }

            $UserNotFoundInWHMCSArray = array();
            if ($GetStreamLinesResult['status'] == "success" && count($GetStreamLinesResult['data']) > 0) {
                foreach ($GetStreamLinesResult['data'] as $streamClient) {
                    
                    $UserNotFoundInWHMCS = $controller->$CheckUserAction($streamClient);
                    if (!empty($UserNotFoundInWHMCS)) {
                        $UserNotFoundInWHMCSArray[] = $UserNotFoundInWHMCS[0];
                    }
                }
            }
        }
    }
}
?>
<script type="text/javascript">
    var alreadyReady = false; // The ready function is being called twice on page load.
    jQuery(document).ready(function() {
        var table = jQuery("#tableStream").DataTable({
            "dom": '<"listtable"fit>pl',
            "responsive": true,
            "oLanguage": {
                "sEmptyTable": "No Records Found",
                "sInfo": "Showing _START_ to _END_ of _TOTAL_ entries",
                "sInfoEmpty": "Showing 0 to 0 of 0 entries",
                "sInfoFiltered": "(filtered from _MAX_ total entries)",
                "sInfoPostFix": "",
                "sInfoThousands": ",",
                "sLengthMenu": "Show _MENU_ entries",
                "sLoadingRecords": "Loading...",
                "sProcessing": "Processing...",
                "sSearch": "",
                "sZeroRecords": "No Records Found",
                "oPaginate": {
                    "sFirst": "First",
                    "sLast": "Last",
                    "sNext": "Next",
                    "sPrevious": "Previous"
                }
            },
            "pageLength": 10,
            "order": [
                [0, "asc"]
            ],
            "lengthMenu": [
                [10, 25, 50, -1],
                [10, 25, 50, "All"]
            ],
            "stateSave": true
        });
        jQuery(".dataTables_filter input").attr("placeholder", "Enter search term...");

        // highlight remembered filter on page re-load
        var rememberedFilterTerm = table.state().columns[3].search.search;
        if (rememberedFilterTerm && !alreadyReady) {
            // This should only run on the first "ready" event.
            jQuery(".view-filter-btns a span").each(function(index) {
                if (jQuery(this).text().trim() == rememberedFilterTerm.replace(/\\|s\*/g, '')) {
                    jQuery(this).parent('a').addClass('active');
                    jQuery(this).parent('a').find('i').switchClass('fa-circle-o', 'fa-dot-circle-o', 0);
                }
            });
        }
        alreadyReady = true;

        $('#checkall0').click(function(event) {
            $(event.target).parents('#tableStream').find('input').prop('checked', this.checked);
        });
        $("#userTypes").val("<?php echo $_POST['user_types']; ?>");
    });
</script>



<?php
$getProductsResult = $controller->$GetProductsAction();
?>


<h1 style="float: left;"><?php echo !empty($userTypes[$_POST['user_types']]) ? $userTypes[$_POST['user_types']] . " List" : ""; ?></h1>

<div class="listtable">

    <table id="tableStream" class="table table-list dataTable no-footer dtr-inline" style="width: 100%;">
        <thead>
            <tr role="row">
                <th class="sorting" style="width: 5%"><input type="checkbox" id="checkall0"></th>
                <th class="sorting" style="width: 20%">Username</th>
                <th class="sorting_asc" style="width: 20%">Products <?php
                                                                    if (!empty($UserNotFoundInWHMCSArray)) {
                                                                        if (isset($getProductsResult['result']) && $getProductsResult['result'] == "success" && isset($getProductsResult['totalresults']) && $getProductsResult['totalresults'] > 0) {
                                                                    ?><br><select class="form-control select-inline defaultproduct" onchange="jQuery('.allproducts').val(jQuery('.defaultproduct').val())"><?php
                                                                                                                                                                                                            foreach ($getProductsResult['products']['product'] as $product) {
                                                                                                                                                                                                                if ($product['module'] == "ownervpncombination") {
                                                                                                                                                                                                            ?><option value="<?php echo $product['pid'] ?>"><?php echo $product['name']; ?></option><?php
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                        ?></select><?php
                                                                                                                                    }
                                                                                                                                }
                                                                                                                                        ?></th>
                <th class="sorting_asc" style="width: 20%">Action</th>
            </tr>
        </thead>
        <tbody>
            <?php
            if (!empty($UserNotFoundInWHMCSArray)) {
            ?> <span style="float: right;margin-left: 25px;"><button class="btn btn-primary" id="import_selected_stream" onclick="import_selected_stream()">Import Selected</button></span>
                <?php
                foreach ($UserNotFoundInWHMCSArray as $streamKey => $stream) {
                ?>
                    <tr>
                        <td>
                            <input type="checkbox" name="selectedStreams[]" value="import_stream_<?php echo $streamKey; ?>" class="checkall">
                        </td>
                        <td> <?php echo $stream['username']; ?> </td>

                        <td> <?php
                                if (isset($getProductsResult['result']) && $getProductsResult['result'] == "success" && isset($getProductsResult['totalresults']) && $getProductsResult['totalresults'] > 0) {
                                ?><select class="form-control select-inline allproducts" id="selected_product_<?php echo $streamKey ?>"><?php
                                                                                                                                        foreach ($getProductsResult['products']['product'] as $product) {
                                                                                                                                            if ($product['module'] == "ownervpncombination") {
                                                                                                                                        ?><option value="<?php echo $product['pid'] ?>"><?php echo $product['name']; ?></option><?php
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                                        ?></select><?php
                                                                                                                                    }
                                                                                                                                        ?> </td>
                        <td><input type="hidden" name="streamData_<?php echo $streamKey ?>" value="<?php echo base64_encode(serialize($stream)); ?>"> <button class="btn btn-primary" id="import_stream_<?php echo $streamKey; ?>" onclick="import_stream(<?php echo $streamKey; ?>)">Import</button> </td>
                    </tr>
            <?php
                }
            }
            ?>
        </tbody>

    </table>
</div>
<script>
    function import_selected_stream() {
        jQuery('#import_selected_stream').html('<i class="fa fa-spinner fa-spin fa-fw"></i> Importing');
        jQuery('#import_selected_stream').prop("disabled", true);
        $("input[name='selectedStreams[]']:checkbox:checked").each(function() {
            var selectedId = $(this).val();
            jQuery("#" + selectedId).click();
        });
    }
    $(document).ajaxStop(function() {
        //        jQuery("#messagebox").fadeIn();
        //        jQuery('html, body').animate({scrollTop: 0}, 800);
        jQuery('#import_selected_stream').html('Import Selected');
        jQuery('#import_selected_stream').removeAttr("disabled");
    });

    function import_stream(id) {
        jQuery('#import_stream_' + id).html('<i class="fa fa-spinner fa-spin fa-fw"></i> Importing');
        jQuery('#import_stream_' + id).prop("disabled", true);
        var streamData = jQuery("input[name=streamData_" + id + "]").val();
        var selectedProduct = jQuery("#selected_product_" + id).val();
        var data = {
            action: 'import_stream',
            streamData: streamData,
            selectedProduct: selectedProduct,
            affid: '<?php echo $_GET['affid']; ?>'
        }

        jQuery.post("../modules/addons/nxtdashboard/lib/Admin/ajax.php", data, function(response) {
            if (response == 'Failed') {
                jQuery('#import_stream_' + id).html("Import");
                jQuery('#import_stream_' + id).removeAttr("disabled");
            }
            if (response == 'Success') {
                jQuery("input[name='streamData_" + id + "']").val("");
                jQuery('#import_stream_' + id).html('<i class="fa fa-check" aria-hidden="true"></i> Imported');
            }
            if (response == 'AlreadyImported') {
                jQuery('#import_stream_' + id).html('<i class="fa fa-check" aria-hidden="true"></i> Already Imported');
            }
        })
    }
</script>