<?php

namespace WHMCS\Module\Addon\AddonModule\Client;

use WHMCS\Database\Capsule;

include_once('' . ROOTDIR . '/includes/modulefunctions.php');

class Controller
{
    public function index($vars)
    {
        $checkaffidexists = self::getWHMCSaffid();
        if ($checkaffidexists == 'notfoundaffiliate') {
            return array(
                'pagetitle' => 'Reseller Panel',
                'breadcrumb' => array(
                    'index.php?m=nxtdashboard' => 'Reseller Panel',
                ),
                'templatefile' => 'xtreamerror',
                'requirelogin' => true, // Set true to restrict access to authenticated client users
                'forcessl' => false, // Deprecated as of Version 7.0. Requests will always use SSL if available.
                'vars' => array(
                    'errormessage' => "This Reseller doesn't exists in Panel - Something Went Wrong Please contact Adminstrator!"
                ),
            );
        }
        $clientdata = Capsule::table('tblclients')->where('id', '=', $_SESSION['uid'])->get();
        if (isset($clientdata[0]->groupid) && !empty($clientdata[0]->groupid)) {
            $clientgrop = Capsule::table('tblclientgroups')->where('id', '=', $clientdata[0]->groupid)->get();
            if ($clientgrop[0]->groupname == 'Reseller' || $clientgrop[0]->groupname == 'Super-Reseller') {
                /*
                 * Reseller Clients
                 */
                $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
                $returndata = array();
                if (isset($xtreamConfig) && !empty($xtreamConfig)) {
                    foreach ($xtreamConfig as $config) {
                        $returndata[$config->setting] = $config->value;
                    }
                }
                $con = self::XtreamDashboard_testconnection();
                $email = $clientdata[0]->email;
                # Inserting Now New User into 
                // First checking if user already exist with reqeuest username  
                $result = mysqli_query($con, "SELECT id FROM members WHERE email='$email'");
                if (!$result) {
                    $radiussqlerror = mysqli_error($con);
                    mysqli_close($con);
                    self::NXT_WHMCSReconnect();
                    logModuleCall('NXT', 'Check Reseller Exists', 'Email Address : ' . $email, "NXT Database Query Error: " . $radiussqlerror, '', '');
                    return true;
                }
                $modulelink = $vars['modulelink'];
                $TotalUserCount = array();
                if (mysqli_num_rows($result) > 0) {
                    self::NXT_WHMCSReconnect();
                    $affclients = Capsule::table('mod_xtreamAffs_clients')
                        ->where('affiliatesid', self::getWHMCSaffid())
                        ->get();
                    foreach ($affclients as $clientdetails) {
                        $clientdetail = self::WHMCSClientDetails($clientdetails->clientid);
                        if (isset($clientdetail) && !empty($clientdetail)) {
                            $TotalUserCount[$clientdetails->clientid] = $clientdetails->clientid;
                        }
                        $resellerdata2 = self::WHMCSClientResellerDetails($clientdetails->clientid);
                        if (isset($resellerdata2) && !empty($resellerdata2)) {
                            $ResellerUsers[$clientdetails->clientid] = $clientdetails->clientid;
                        }
                    }
                } else {
                    self::NXT_WHMCSReconnect();
                    return array(
                        'pagetitle' => 'Reseller Panel',
                        'breadcrumb' => array(
                            'index.php?m=nxtdashboard' => 'Reseller Panel',
                        ),
                        'templatefile' => 'xtreamerror',
                        'requirelogin' => true, // Set true to restrict access to authenticated client users
                        'forcessl' => false, // Deprecated as of Version 7.0. Requests will always use SSL if available.
                        'vars' => array(
                            'modulelink' => $modulelink,
                            'errormessage' => "This Reseller doesn't exists in Stream Panel"
                        ),
                    );
                    logModuleCall('NXT', 'Check Reseller Exists', 'Email Address : ' . $email, "This " . $clientgrop[0]->groupname . " doesn't exists in Stream Panel", '', '');
                }
                $TrialServices = $AllFreeServices = Capsule::table('tblhosting')
                    ->join('tblproducts', 'tblhosting.packageid', '=', 'tblproducts.id')
                    ->where('tblproducts.configoption5', 'Yes')
                    ->whereIn('tblhosting.userid', $TotalUserCount)
                    ->select('tblproducts.*', 'tblhosting.id as hostingid')
                    ->count();
                $totalusers = count($TotalUserCount);
                $trialusers = $TrialServices;
                $totalreseller = count($ResellerUsers);

                // Get common module parameters
                self::NXT_WHMCSReconnect();
                if ($clientgrop[0]->groupname == 'Reseller') {
                    return array(
                        'pagetitle' => 'Reseller Panel',
                        'breadcrumb' => array(
                            'index.php?m=nxtdashboard' => 'Reseller Panel',
                        ),
                        'templatefile' => 'resellerpanel',
                        'requirelogin' => true, // Set true to restrict access to authenticated client users
                        'forcessl' => false, // Deprecated as of Version 7.0. Requests will always use SSL if available.
                        'vars' => array(
                            'modulelink' => $modulelink,
                            'totalusers' => $totalusers,
                            'undertrial' => $trialusers,
                            'dashboardactive' => 'class="active"',
                            'topup' => $returndata['rid'],
                        ),
                    );
                } elseif ($clientgrop[0]->groupname == 'Super-Reseller') {
                    return array(
                        'pagetitle' => 'Super Reseller Panel',
                        'breadcrumb' => array(
                            'index.php?m=nxtdashboard' => 'Super Reseller Panel',
                        ),
                        'templatefile' => 'supresellerpanel',
                        'requirelogin' => true, // Set true to restrict access to authenticated client users
                        'forcessl' => false, // Deprecated as of Version 7.0. Requests will always use SSL if available.
                        'vars' => array(
                            'modulelink' => $modulelink,
                            'totalusers' => $totalusers,
                            'undertrial' => $trialusers,
                            'dashboardactive' => 'class="active"',
                            'reseller' => $totalreseller,
                            'topup' => $returndata['srid'],
                        ),
                    );
                }
            }
        }
    }
    public function credits($vars)
    {

        return array(
            'pagetitle' => 'My Credits',
            'breadcrumb' => array(
                'index.php?m=nxtdashboard' => 'Reseller Panel',
                'index.php?m=nxtdashboard&action=credits' => 'My Credits',
            ),
            'templatefile' => 'credits',
            'requirelogin' => true, // Set true to restrict access to authenticated client users
            'forcessl' => false, // Deprecated as of Version 7.0. Requests will always use SSL if available.
            'vars' => $vars,
        );
    }
    //Show all services of users ..
    public function xtreamusersServices($vars)
    {

        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule 
        $con = self::XtreamDashboard_testconnection();
        /*
         * Reseller Clients
         */
        $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        if (isset($_POST['customAction']) && $_POST['customAction'] == 'addMAG') {
            $newmac = $_POST['newMAC'];
            $result = self::XtreamDashboard_AddMAG($_POST, $newmac);
            if ($result == 'success') {
                $response['result'] = "success";
                $response['message'] = "<strong>Success!</strong> MAG Device Added Successfully!";
            } else {
                $response['result'] = "danger";
                $response['message'] = "<strong>Error!</strong> " . $result;
            }
        } elseif (isset($_POST['customAction']) && $_POST['customAction'] == 'changeMAG') {
            $newmac = $_POST['newMAC'];
            $result = self::XtreamDashboard_ChangeMAG($_POST, $newmac);
            if ($result == 'success') {
                $response['result'] = "success";
                $response['message'] = "<strong>Success!</strong> MAG Device Updated Successfully!";
            } else {
                $response['result'] = "danger";
                $response['message'] = "<strong>Error!</strong> " . $result;
            }
        } elseif (isset($_POST['customAction']) && $_POST['customAction'] == 'addENG') {
            $newmac = $_POST['newMAC'];
            $result = self::XtreamDashboard_AddENG($_POST, $newmac);
            if ($result == 'success') {
                $response['result'] = "success";
                $response['message'] = "<strong>Success!</strong> MAG Device Added Successfully!";
            } else {
                $response['result'] = "danger";
                $response['message'] = "<strong>Error!</strong> " . $result;
            }
        } elseif (isset($_POST['customAction']) && $_POST['customAction'] == 'changeENG') {
            $newmac = $_POST['newMAC'];
            $result = self::XtreamDashboard_ChangeENG($_POST, $newmac);
            if ($result == 'success') {
                $response['result'] = "success";
                $response['message'] = "<strong>Success!</strong> MAG Device Updated Successfully!";
            } else {
                $response['result'] = "danger";
                $response['message'] = "<strong>Error!</strong> " . $result;
            }
        } elseif (isset($_POST['customAction']) && $_POST['customAction'] == 'ModuleSuspend') {
            $command = 'ModuleSuspend';
            $postData = array(
                'accountid' => $_POST['serviceid'],
                'suspendreason' => "Suspend by Reseller",
            );
            $admin = Capsule::table('tbladmins')
                ->where('roleid', '=', 1)
                ->get();
            $adminUsername = $admin[0]->username;
            $results = localAPI($command, $postData, $adminUsername);
            if (isset($results) && $results['result'] == 'success') {
                $response['result'] = "success";
                $response['message'] = "<strong>Success!</strong> Service Suspend Successfully!";
            } else {
                $response['result'] = "danger";
                $response['message'] = "<strong>Error!</strong> " . $results['message'];
            }
        } elseif (isset($_POST['customAction']) && $_POST['customAction'] == 'ModuleUnsuspend') {
            $command = 'ModuleUnsuspend';
            $postData = array(
                'accountid' => $_POST['serviceid'],
            );
            $admin = Capsule::table('tbladmins')
                ->where('roleid', '=', 1)
                ->get();
            $adminUsername = $admin[0]->username;
            $results = localAPI($command, $postData, $adminUsername);
            if (isset($results) && $results['result'] == 'success') {
                $response['result'] = "success";
                $response['message'] = "<strong>Success!</strong>Service Unsuspend Successfully!";
            } else {
                $response['result'] = "danger";
                $response['message'] = "<strong>Error!</strong> " . $results['message'];
            }
        } elseif (isset($_POST['customAction']) && $_POST['customAction'] == 'ModuleTerminate') {
            $command = 'ModuleTerminate';
            $postData = array(
                'accountid' => $_POST['serviceid'],
            );
            $admin = Capsule::table('tbladmins')
                ->where('roleid', '=', 1)
                ->get();
            $adminUsername = $admin[0]->username;
            $results = localAPI($command, $postData, $adminUsername);
            if (isset($results) && $results['result'] == 'success') {
                $response['result'] = "success";
                $response['message'] = "<strong>Success!</strong>Service Terminate Successfully!";
            } else {
                $response['result'] = "error";
                $response['message'] = "<strong>Error!</strong> " . $results['message'];
            }
        } elseif (isset($_POST['customAction']) && $_POST['customAction'] == 'ModuleRemove') {
            $affdetails = self::CheckAffCredit();
            $tblhostingdetails = Capsule::table('tblhosting')->where('id', '=', $_POST['serviceid'])->get();
            $admin = Capsule::table('tbladmins')
                ->where('roleid', '=', 1)
                ->get();
            $adminUsername = $admin[0]->username;
            $ModuleTerminate = 'ModuleTerminate';
            $ModuleTerminateData = array(
                'accountid' => $_POST['serviceid'],
            );
            localAPI($ModuleTerminate, $ModuleTerminateData, $adminUsername);
            $PendingOrder = 'PendingOrder';
            $PendingOrderData = array(
                'orderid' => $tblhostingdetails[0]->orderid,
            );
            localAPI($PendingOrder, $PendingOrderData, $adminUsername);
            $command = 'CancelOrder';
            $postData = array(
                'orderid' => $tblhostingdetails[0]->orderid,
            );
            $results = localAPI($command, $postData, $adminUsername);
            if (isset($results) && $results['result'] == 'success') {
                $DeleteOrder = 'DeleteOrder';
                $delete = localAPI($DeleteOrder, $postData, $adminUsername);
                if (isset($delete) && $delete['result'] == 'success') {
                    $response['result'] = "success";
                    $response['message'] = "<strong>Success!</strong> Service Remove Successfully!";
                    logModuleCall('NXT', 'Service Deleted', 'This  Order Id : ' . $tblhostingdetails[0]->orderid . ' has been deleted by reseller' . $affdetails->firstname . ' ' . $affdetails->lastname . "(" . $affdetails->email . ")", $delete, '', '');
                } else {
                    $response['result'] = "danger";
                    logModuleCall('NXT', 'Service Deleted', 'Order Id : ' . $tblhostingdetails[0]->orderid, "<strong>Error!</strong> " . $delete['message'], '', '');
                    $response['message'] = "<strong>Error!</strong> " . $delete['message'];
                }
            } else {
                $response['result'] = "error";
                $response['message'] = "<strong>Error!</strong> " . $results['message'];
            }
        } elseif (isset($_POST['customAction']) && $_POST['customAction'] == 'ModuleRenew') {
            $resellerid = $_SESSION['uid'];
            $configdata = Capsule::table('tblconfiguration')
                ->where('setting', 'Reseller' . $resellerid)
                ->get();
            foreach ($configdata as $configdatavale) {
                $dataconfigp[$configdatavale->setting] = $configdatavale->value;
            }
            if (isset($dataconfigp['Reseller' . $resellerid]) && !empty($dataconfigp['Reseller' . $resellerid])) {
                $checked = $dataconfigp['Reseller' . $resellerid];
            }
            if ($checked == 'Disable') {
                $admin = Capsule::table('tbladmins')
                    ->where('roleid', '=', 1)
                    ->get();
                $adminUsername = $admin[0]->username;
                $invoicesCount = Capsule::table('tblinvoiceitems')
                    ->join('tblinvoices', 'tblinvoiceitems.invoiceid', '=', 'tblinvoices.id')
                    ->where('tblinvoices.status', '=', 'Unpaid')
                    ->where('tblinvoiceitems.type', '=', 'Hosting')
                    ->where('tblinvoiceitems.relid', '=', $_POST['serviceid'])
                    ->count();
                if (isset($invoicesCount) && !empty($invoicesCount)) {
                    $invoices = Capsule::table('tblinvoiceitems')
                        ->join('tblinvoices', 'tblinvoiceitems.invoiceid', '=', 'tblinvoices.id')
                        ->where('tblinvoices.status', '=', 'Unpaid')
                        ->where('tblinvoiceitems.type', '=', 'Hosting')
                        ->where('tblinvoiceitems.relid', '=', $_POST['serviceid'])
                        ->get();
                    foreach ($invoices as $invoice) {
                        $getinvoice = localAPI('GetInvoice', array('invoiceid' => $invoice->invoiceid), $adminUsername);
                        if ($getinvoice['status'] != 'Paid') {
                            //Check if client is related to Reseller 
                            $userid = $getinvoice['userid'];
                            $checkdetials = Capsule::table('mod_xtreamAffs_clients')
                                ->where('clientid', '=', $userid)
                                ->get();
                            if (isset($checkdetials) && !empty($checkdetials)) {
                                //Get Affiliates details  
                                $getAffiliates = Capsule::table('tblaffiliates')
                                    ->where('id', '=', $checkdetials[0]->affiliatesid)
                                    ->count();
                                if (isset($getAffiliates) && !empty($getAffiliates)) {
                                    $getAffiliates = Capsule::table('tblaffiliates')
                                        ->where('id', '=', $checkdetials[0]->affiliatesid)
                                        ->get();
                                    $credit = Capsule::table('tblclients')
                                        ->select('credit', 'firstname', 'lastname', 'email')
                                        ->where('id', '=', $getAffiliates[0]->clientid)
                                        ->get();
                                    $admin = Capsule::table('tbladmins')
                                        ->where('roleid', '=', 1)
                                        ->get();
                                    $adminUsername = $admin[0]->username;
                                    $affdetails = $credit[0];
                                    $add_credit = $getinvoice['total'];
                                    if ($affdetails->credit > $add_credit) {
                                        $AddCredit = 'AddCredit';
                                        $postData = array(
                                            'clientid' => $userid,
                                            'description' => 'Added funds by ' . $affdetails->firstname . ' ' . $affdetails->lastname,
                                            'amount' => $add_credit,
                                        );
                                        $resultsCredit = localAPI($AddCredit, $postData, $adminUsername);
                                        if ($resultsCredit['result'] == 'success') {
                                            Capsule::table('tblcredit')->insert(
                                                ['clientid' => $getAffiliates[0]->clientid, 'date' => date('Y-m-d'), 'description' => 'Add Credit to Client - ' . $userid, 'amount' => -$add_credit]
                                            );
                                            $removeCredit = $affdetails->credit - $add_credit;
                                            Capsule::table('tblclients')
                                                ->where('id', '=', $getAffiliates[0]->clientid)
                                                ->update(
                                                    [
                                                        'credit' => $removeCredit,
                                                    ]
                                                );
                                            $command = 'ApplyCredit';
                                            $postData = array(
                                                'invoiceid' => $invoice->invoiceid,
                                                'amount' => $add_credit,
                                            );
                                            $results = localAPI($command, $postData, $adminUsername);
                                            if ($results['result'] == 'success') {
                                                self::RemoveXtreamCredit($add_credit, $con);
                                            }
                                            logModuleCall('Stalker Dashboard', 'ApplyCredit', $postData, $results, '', '');
                                        }
                                    } else {
                                        $response['result'] = "error";
                                        $response['message'] = "<strong>Error!</strong>You don't have sufficient balance ! Click here to <a href='cart.php?gid=" . (!empty($returndata['gid']) ? $returndata['gid'] : 'addons') . "'> Click here </a> to add credits";
                                    }
                                }
                            }
                        }
                    }
                    if (isset($results) && $results['result'] == 'success') {
                        $response['result'] = "success";
                        $response['message'] = "<strong>Success!</strong> Service Renew Successfully!";
                    } else {
                        $response['result'] = "error";
                        $response['message'] = "<strong>Error!</strong> " . $results['message'];
                    }
                } else {
                    $response['result'] = "info";
                    $response['message'] = "<strong>Info!</strong> It can't be renewed at this stage";
                }
            }
        }
        $clientdata = Capsule::table('tblclients')->where('id', '=', $_SESSION['uid'])->get();
        $con = self::XtreamDashboard_testconnection();
        $email = $clientdata[0]->email;
        $result = mysqli_query($con, "SELECT id FROM members WHERE email='$email'");
        if (!$result) {
            $radiussqlerror = mysqli_error($con);
            self::NXT_WHMCSReconnect();
            logModuleCall('NXT', 'Check Reseller Exists', 'Email Address : ' . $email, "NXT Database Query Error: " . $radiussqlerror, '', '');
            return true;
        }

        $ClientsAffUserIds = array();
        if (mysqli_num_rows($result) > 0) {
            self::NXT_WHMCSReconnect();
            $affclients = Capsule::table('mod_xtreamAffs_clients')
                ->where('affiliatesid', self::getWHMCSaffid())
                ->get();
            foreach ($affclients as $clientdetails) {
                $clientdetail = self::WHMCSClientDetails($clientdetails->clientid);
                if (isset($clientdetail) && !empty($clientdetail)) {
                    $clients_detail[] = $clientdetail;
                    $ClientsAffUserIds[] = $clientdetails->clientid;
                }
            }
        }
        //echo "<pre>";print_r($ClientsAffUserIds);echo "</pre>";

        foreach ($ClientsAffUserIds as $RelUserId) {
            $selectedclientservices = self::WHMCSClientServices($RelUserId);
            if ($selectedclientservices['result'] == 'success') {
                $clientdata = Capsule::table('tblclients')->where('id', '=', $_SESSION['uid'])->get();
                $email = $clientdata[0]->email;
                # Inserting Now New User into 
                // First checking if user already exist with reqeuest username  
                $result = mysqli_query($con, "SELECT id FROM members WHERE email='$email'");
                if (!$result) {
                    $radiussqlerror = mysqli_error($con);
                    self::NXT_WHMCSReconnect();
                    logModuleCall('NXT', 'Check Reseller Exists', 'Email Address : ' . $email, "NXT Database Query Error: " . $radiussqlerror, '', '');
                    return true;
                }
                $response['resellermag'] = '';
                if (mysqli_num_rows($result) > 0) {
                    $resellerdata = mysqli_fetch_assoc($result);
                    if (isset($clientdata[0]->groupid) && !empty($clientdata[0]->groupid)) {
                        $clientgrop = Capsule::table('tblclientgroups')->where('id', '=', $clientdata[0]->groupid)->get();
                        if ($clientgrop[0]->groupname == 'Super-Reseller') {
                            $checkReseller = self::CheckSelectedClientReseller($selectedclientservices['clientid']);
                            if ($checkReseller == 'Reseller' || $checkReseller == 'Super-Reseller') {
                                foreach ($selectedclientservices['products']['product'] as $service) {
                                    $configoption = Capsule::table('tblproducts')->where('id', '=', $service['pid'])->select('configoption13')->get();
                                    $users = mysqli_query($con, "SELECT id as xtreamid,username as xtreamusername,password as xtreampassword FROM `members` WHERE owner_id = '" . $resellerdata['id'] . "' AND member_group_id='" . $configoption[0]->configoption13 . "' AND notes = '" . $returndata['common_identifier'] . "" . $_GET['userid'] . "' AND email='" . $service['username'] . "'");
                                    $totalusers = mysqli_num_rows($users);
                                    if ($totalusers > 0) {
                                        while ($xtremservice = mysqli_fetch_assoc($users)) {
                                            $xtremservices = array_merge($xtremservice, array(
                                                'xtreampassword' => 'amanpreet11', 'mag_device' => '-', 'is_trial' => '-',
                                                'is_mag' => '-'
                                            ));
                                            $servicesdetails[] = array_merge($service, $xtremservices);
                                        }
                                    } else {
                                        $data = array(
                                            'xtreamusername' => '-',
                                            'xtreampassword' => '-',
                                            'is_trial' => '-',
                                            'is_mag' => '-',
                                            'mag_device' => '-'
                                        );
                                        $servicesdetails[] = array_merge($service, $data);
                                    }
                                }
                                $response['resellermag'] = 'reseller';
                            } else {
                                $resultresponse = self::XtreamServices($selectedclientservices, $resellerdata, $con);
                                $response['response'] = $resultresponse['response'];
                                $servicesdetails = $resultresponse['servicesdetails'];
                            }
                        } else {
                            $resultresponse = self::XtreamServices($selectedclientservices, $resellerdata, $con);
                            $response['response'] = $resultresponse['response'];
                            $servicesdetails = $resultresponse['servicesdetails'];
                        }
                    }
                }
            }
            $i = 0;
            foreach ($servicesdetails as $Servicekey) {

                $CheckUpgradePackage = Capsule::table('tblproduct_upgrade_products')->where('product_id', '=', $Servicekey['pid'])->count();
                if ($CheckUpgradePackage > 0) {
                    $servicesdetails[$i]['upgrade'] = 'yes';
                } else {
                    $servicesdetails[$i]['upgrade'] = 'no';
                }

                $invoicesUn = Capsule::table('tblinvoiceitems')
                    ->join('tblinvoices', 'tblinvoiceitems.invoiceid', '=', 'tblinvoices.id')
                    ->where('tblinvoices.status', '=', 'Unpaid')
                    ->where('tblinvoiceitems.type', '=', 'Hosting')
                    ->where('tblinvoiceitems.relid', '=', $Servicekey['id'])
                    ->get();
                if (isset($invoicesUn) && !empty($invoicesUn)) {
                    $servicesdetails[$i]['showrenew'] = 'yes';
                } else {
                    $servicesdetails[$i]['showrenew'] = 'no';
                }


                $clintID = $Servicekey['clientid'];

                $servicesdetails[$i]['clientDetails'] = self::WHMCSClientDetails($clintID);
                $i++;
            }
            $RArray[] = $servicesdetails;
        }
        $FinalArray = array();
        foreach ($RArray as $SerViceArray) {
            foreach ($SerViceArray as $lastArray) {
                $FinalArray[] = $lastArray;
            }
        }
        $servicesdetails['products']['product'] = $FinalArray;




        $resellerid = $_SESSION['uid'];
        $configdata = Capsule::table('tblconfiguration')
            ->where('setting', 'Reseller' . $resellerid)
            ->get();
        foreach ($configdata as $configdatavale) {
            $dataconfigp[$configdatavale->setting] = $configdatavale->value;
        }
        if (isset($dataconfigp['Reseller' . $resellerid]) && !empty($dataconfigp['Reseller' . $resellerid])) {
            $checked = $dataconfigp['Reseller' . $resellerid];
        }
        $response['action'] = '';
        if ($returndata['reseller_susp'] == 'on' || $returndata['reseller_unsusp'] == 'on' || $returndata['reseller_term'] == 'on' || $returndata['reseller_remove'] == 'on' || $checked == 'Disable')
            $response['action'] = 'enable';

        $access_output = mysqli_query($con, "SELECT * FROM access_output");

        while ($output = mysqli_fetch_assoc($access_output)) {
            if ($output['output_name'] == 'MPEGTS') {
                $outputfirst = $output['output_key'];
            }
            $access_outputdata[] = $output;
        }
        if (empty($outputfirst)) {
            $outputfirst = array_values($access_outputdata)[0]['output_key'];
        }
        self::NXT_WHMCSReconnect();
        $xtreamautoscipt = Capsule::table('mod_xtreamautoscript')->get();
        foreach ($xtreamautoscipt as $value) {
            $autoscript[$value->name] = $value->value;
        }

        /* echo "<pre>";print_r($servicesdetails);die(); */
        $response['listallservices'] = 'class="active"';
        $response['modulelink'] = $modulelink;
        $response['userdetails'] = $clients_detail;
        $response['services'] = $servicesdetails;
        $response['CurrentOpen_User'] = $_GET['userid'];
        $response['checked'] = $checked;
        $response['lang'] = $returndata;
        $response['m3ulinkoutput'] = (isset($outputfirst) && !empty($outputfirst) ? $outputfirst : 'xxx');
        $response['accessoutput'] = $access_outputdata;
        $response['topup'] = $returndata['gid'];
        $response['autoscript'] = $autoscript;
        return array(
            'pagetitle' => 'Client Details',
            'breadcrumb' => array(
                'index.php?m=nxtdashboard' => 'Xtream Dashboard Module',
                'index.php?m=nxtdashboard&action=xtreamservices' => 'Xtream Services Page',
            ),
            'templatefile' => 'xtreamusersServices',
            'requirelogin' => true, // Set true to restrict access to authenticated client users
            'forcessl' => false, // Deprecated as of Version 7.0. Requests will always use SSL if available.
            'vars' => $response,
        );
    }

    public function xtreamusers($vars)
    {
        $SearchedMacAddress = "";
        $clientdata = Capsule::table('tblclients')->where('id', '=', $_SESSION['uid'])->get();
        // Get common module parameters
        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
        $response = array(
            'modulelink' => $modulelink,
        );
        /*
         * Reseller Clients
         */
        $xtreamConfig = Capsule::table('mod_xtreamConfig')
            ->where('setting', 'gid')
            ->get();
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        $con = self::XtreamDashboard_testconnection();
        if (isset($_POST['addcredits']) && !empty($_POST['addcredits'])) {
            self::XtreamAddCrdits($_POST['credits'], $_POST['client_id'], $con, 'xtreamusers');
        }
        if (isset($_POST['removeclient'])) {
            $affdetails = self::CheckAffCredit();
            $admin = Capsule::table('tbladmins')
                ->where('roleid', '=', 1)
                ->get();
            $adminUsername = $admin[0]->username;
            $Orders = 'GetClientsProducts';
            $Ordersdata = array(
                'clientid' => $_POST['client_id'],
                'stats' => true,
            );
            $orderdetials = localAPI($Orders, $Ordersdata, $adminUsername);
            if ($orderdetials['result'] == 'success') {
                if (isset($orderdetials['products']['product']) && !empty($orderdetials['products']['product'])) {
                    foreach ($orderdetials['products']['product'] as $orderid) {
                        $ModuleTerminate = 'ModuleTerminate';
                        $ModuleTerminateData = array(
                            'accountid' => $orderid['id'],
                        );
                        localAPI($ModuleTerminate, $ModuleTerminateData, $adminUsername);
                        $PendingOrder = 'PendingOrder';
                        $CancelOrderData = array(
                            'orderid' => $orderid['orderid'],
                        );
                        localAPI($PendingOrder, $CancelOrderData, $adminUsername);
                        $CancelOrder = 'CancelOrder';
                        localAPI($CancelOrder, $CancelOrderData, $adminUsername);
                    }
                }
            }
            $command = 'DeleteClient';
            $postData = array(
                'clientid' => $_POST['client_id'],
            );
            $results = localAPI($command, $postData, $adminUsername);
            if (isset($results['result']) && !empty($results['result'])) {
                if ($results['result'] == 'success') {
                    $response['result'] = "success";
                    $response['message'] = "<strong>Success!</strong> User Deleted Successfully User Id : " . $results['clientid'] . " !";
                    logModuleCall('NXT', 'Remove User', 'This  User Id : ' . $results['clientid'] . ' has been deleted by reseller' . $affdetails->firstname . ' ' . $affdetails->lastname . "(" . $affdetails->email . ")", $results, '', '');
                } else {
                    $response['result'] = "danger";
                    $response['message'] = "<strong>Error!</strong> Unable to Remove User";
                    logModuleCall('NXT', 'Remove User', $postData, $results, '', '');
                }
            }
        }
        $email = $clientdata[0]->email;
        # Inserting Now New User into 
        // First checking if user already exist with reqeuest username  
        $result = mysqli_query($con, "SELECT id FROM members WHERE email='$email'");
        if (!$result) {
            $radiussqlerror = mysqli_error($con);
            self::NXT_WHMCSReconnect();
            logModuleCall('NXT', 'Check Reseller Exists', 'Email Address : ' . $email, "NXT Database Query Error: " . $radiussqlerror, '', '');
            return true;
        }
        $ClientsAffUserIds = array();
        if (mysqli_num_rows($result) > 0) {
            self::NXT_WHMCSReconnect();
            $affclients = Capsule::table('mod_xtreamAffs_clients')
                ->where('affiliatesid', self::getWHMCSaffid())
                ->get();
            foreach ($affclients as $clientdetails) {
                $clientdetail = self::WHMCSClientDetails($clientdetails->clientid);
                if (isset($clientdetail) && !empty($clientdetail)) {
                    $clients_detail[$clientdetails->clientid] = $clientdetail;
                    $ClientsAffUserIds[$clientdetails->clientid] = $clientdetails->clientid;
                }
            }
        }

        if (isset($_POST['Client_search']) && !empty($_POST['Client_search'])) {
            $clients_detail = array();
            $Client_search = $_POST['Client_search'];
            $UserIdByMac = self::NXT_GetUserIdByMacCode($Client_search);
            if ($UserIdByMac) {
                if (in_array($UserIdByMac, $ClientsAffUserIds)) {
                    $clients_detail[0] = self::WHMCSClientDetails($UserIdByMac);
                }
            } else {
                $UserIdsFetchedName = self::NXT_GetUserIdByName($Client_search);
                if ($UserIdsFetchedName) {
                    $FinalIds = array();
                    foreach ($UserIdsFetchedName as $UKey) {
                        if (in_array($UKey->clientid, $ClientsAffUserIds)) {
                            $clients_detail[] = self::WHMCSClientDetails($UKey->clientid);
                        }
                    }
                } else {
                    $PackageIdsGetFromBy = self::NXT_GetUserIdByPackege($Client_search);
                    if ($PackageIdsGetFromBy) {
                        $admin = Capsule::table('tbladmins')
                            ->where('roleid', '=', 1)
                            ->get();
                        foreach ($ClientsAffUserIds as $ClientId) {
                            foreach ($PackageIdsGetFromBy as $PackIdKey) {
                                $adminUsername = $admin[0]->username;
                                $command = 'GetClientsProducts';
                                $postData = array(
                                    'clientid' => $ClientId,
                                    'pid' => $PackIdKey->PackageId,
                                );

                                $results = localAPI($command, $postData, $adminUsername);
                                if ($results['totalresults'] != 0) {
                                    $clients_detail[] = self::WHMCSClientDetails($ClientId);
                                }
                            }
                        }
                    }
                }
            }
        }
        self::NXT_WHMCSReconnect();
        $response['Client_search'] = $Client_search;
        $response['userdetails'] = $clients_detail;
        $response['topup'] = $returndata['gid'];
        if (isset($_GET['result']) && $_GET['result'] == 'emerror') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> Email Address already exists!";
        } elseif (isset($_GET['result']) && $_GET['result'] == 'ccerror') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> You don't have sufficient credits's balance! <a href='cart.php?gid=" . $returndata['gid'] . "'> Click here </a> to Add Credits";
        } elseif (isset($_GET['result']) && $_GET['result'] == 'success') {
            $response['result'] = "success";
            $response['message'] = "<strong>Success!</strong> User Created Successfully!";
        }
        global $CONFIG;
        if (empty($CONFIG['SystemSSLURL']))
            $whmcsurl = $CONFIG['SystemURL'];
        else
            $whmcsurl = $CONFIG['SystemSSLURL'];
        $response['whmcsurl'] = $whmcsurl;
        $response['listactive'] = 'class="active"';
        return array(
            'pagetitle' => 'Users List',
            'breadcrumb' => array(
                'index.php?m=nxtdashboard' => 'nxtdashboard',
                'index.php?m=nxtdashboard&action=xtreamusers' => 'Users list',
            ),
            'templatefile' => 'xtreamusers',
            'requirelogin' => true, // Set true to restrict access to authenticated client users
            'forcessl' => false, // Deprecated as of Version 7.0. Requests will always use SSL if available.
            'vars' => $response,
        );
    }

    public function NXT_GetUserIdByPackege($PackageName = "")
    {
        $PackageData = Capsule::table('tblproducts')
            ->where('name', 'like', '%' . $PackageName . '%')
            ->select('tblproducts.id as PackageId')
            ->get();
        if (!empty($PackageData)) {
            return $PackageData;
        }
    }

    public function NXT_GetUserIdByName($Name = "")
    {
        $UserData = Capsule::table('tblclients')
            ->where('firstname', 'like', $Name)
            ->orWhere('lastname', 'like', $Name)
            ->select('tblclients.id as clientid')
            ->get();
        if (!empty($UserData)) {
            return $UserData;
        }
    }

    public function NXT_GetUserIdByMacCode($MacCode = "")
    {
        self::NXT_WHMCSReconnect();
        $row2 = "";
        $config = Capsule::table('mod_xtreamConfig')->get();                 //Getting the custom field name from custom page.
        foreach ($config as $value) {
            $row2[$value->setting] = $value->value;
        }
        $MacField = (isset($row2['custom_field_mag']) ? $row2['custom_field_mag'] : '');          //Declare variable for mac field .
        $FieldIdQuery = Capsule::table('tblcustomfields')
            ->where('fieldname', $MacField)
            ->select('tblcustomfields.id')
            ->get();                                                 //Query for getting the id of field with field name.
        if (!empty($FieldIdQuery)) {                                             //Check if data not empty ..
            $FieldIdQuery = json_decode(json_encode($FieldIdQuery), true);        //Convert std class array to object array..
            $FieldIdGetdArray = [];
            foreach ($FieldIdQuery as $Data) {                              //Loop for getting data and search in fields value..
                $FieldIdGetdArray[] = $Data['id'];
            }
            //Declare variable for  field id.     
            $FieldValueID = Capsule::table('tblcustomfieldsvalues')      //QUery for check and get relid by maccode and field id.
                ->whereIn('fieldid', $FieldIdGetdArray)
                ->where('value', $MacCode)
                ->select('tblcustomfieldsvalues.relid')
                ->get();
            if (!empty($FieldValueID)) {
                $FieldValueID = json_decode(json_encode($FieldValueID), true);        //Convert std class array to object array..
                $RelId = $FieldValueID[0]['relid'];                                   //RelID as hosting  id..
                $UserIdQuery = Capsule::table('tblhosting')
                    ->join('tblclients', 'tblhosting.userid', '=', 'tblclients.id')
                    ->where('tblhosting.id', $RelId)
                    ->select(
                        'tblclients.id as userid',
                        'tblclients.email as email'
                    )
                    ->get();
                if (!empty($UserIdQuery)) {
                    $UserIdQuery = json_decode(json_encode($UserIdQuery), true);
                    $UserID = $UserIdQuery[0]['userid'];
                    return $UserID;
                }
            }
        }
    }

    public function XtreamDashboard_GetIPTVemailData()
    {
        $returnMessage = "";
        $DefaultEmailData = Capsule::table('tblemailtemplates')->where('name', '=', 'IPTV Service Details')->select('message')->get();
        if (!empty($DefaultEmailData)) {
            $returnMessage = $DefaultEmailData[0]->message;
        }

        $emailtemplate = Capsule::table('tblemailtemplates')->where('name', '=', 'IPTV Service Details Reseller' . $_SESSION['uid'])->select('message')->get();

        if (!empty($emailtemplate)) {
            if ($emailtemplate[0]->message != "") {
                $returnMessage = $emailtemplate[0]->message;
            }
        }

        return $returnMessage;
    }

    public function xtreamautorenew($vars)
    {
        $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        if (isset($_POST['autorenew'])) {
            $resellerid = $_SESSION['uid'];
            $configdata = Capsule::table('tblconfiguration')
                ->where('setting', 'Reseller' . $resellerid)
                ->get();
            foreach ($configdata as $configdatavale) {
                $dataconfigp[$configdatavale->setting] = $configdatavale->value;
            }
            if (isset($dataconfigp['Reseller' . $resellerid]) && !empty($dataconfigp['Reseller' . $resellerid])) {
                Capsule::table('tblconfiguration')
                    ->where('setting', 'Reseller' . $resellerid)
                    ->update(['value' => $_POST['renew']]);
            } else {
                Capsule::table('tblconfiguration')->insert(
                    ['setting' => 'Reseller' . $resellerid, 'value' => $_POST['renew']]
                );
            }
            $response['result'] = "success";
            $response['message'] = "<strong>Success!</strong> Auto Renewal feature is " . $_POST['renew'] . "d!";
        }
        $resellerid = $_SESSION['uid'];
        $configdata = Capsule::table('tblconfiguration')
            ->where('setting', 'Reseller' . $resellerid)
            ->get();
        foreach ($configdata as $configdatavale) {
            $dataconfigp[$configdatavale->setting] = $configdatavale->value;
        }
        if (isset($dataconfigp['Reseller' . $resellerid]) && !empty($dataconfigp['Reseller' . $resellerid])) {
            $response['checked'] = $dataconfigp['Reseller' . $resellerid];
        }
        $modulelink = $vars['modulelink'];
        $response['modulelink'] = $modulelink;
        $response['topup'] = $returndata['gid'];
        $response['optionactive'] = $returndata;
        $response['autorenew'] = 'class="active"';
        return array(
            'pagetitle' => 'Auto Renew',
            'breadcrumb' => array(
                'index.php?m=nxtdashboard' => 'Dashboard',
                'index.php?m=nxtdashboard&action=xtreamrenew' => 'Renew',
            ),
            'templatefile' => 'xtreamrenew',
            'requirelogin' => true, // Set true to restrict access to authenticated client users
            'forcessl' => false, // Deprecated as of Version 7.0. Requests will always use SSL if available.
            'vars' => $response,
        );
    }

    public function xtreaminactiveusers($vars)
    {
        if (isset($_POST['customAction']) && $_POST['customAction'] == 'addMAG') {
            $newmac = $_POST['newMAC'];
            $result = self::XtreamDashboard_AddMAG($_POST, $newmac);
            if ($result == 'success') {
                $response['result'] = "success";
                $response['message'] = "<strong>Success!</strong> MAG Device Added Successfully!";
            } else {
                $response['result'] = "danger";
                $response['message'] = "<strong>Error!</strong> " . $result;
            }
        } elseif (isset($_POST['customAction']) && $_POST['customAction'] == 'changeMAG') {
            $newmac = $_POST['newMAC'];
            $result = self::XtreamDashboard_ChangeMAG($_POST, $newmac);
            if ($result == 'success') {
                $response['result'] = "success";
                $response['message'] = "<strong>Success!</strong> MAG Device Updated Successfully!";
            } else {
                $response['result'] = "danger";
                $response['message'] = "<strong>Error!</strong> " . $result;
            }
        } elseif (isset($_POST['customAction']) && $_POST['customAction'] == 'ModuleSuspend') {
            $command = 'ModuleSuspend';
            $postData = array(
                'accountid' => $_POST['serviceid'],
                'suspendreason' => "Suspend by Reseller",
            );
            $admin = Capsule::table('tbladmins')
                ->where('roleid', '=', 1)
                ->get();
            $adminUsername = $admin[0]->username;
            $results = localAPI($command, $postData, $adminUsername);
            if (isset($results) && $results['result'] == 'success') {
                $response['result'] = "success";
                $response['message'] = "<strong>Success!</strong>Service Suspend Successfully!";
            } else {
                $response['result'] = "danger";
                $response['message'] = "<strong>Error!</strong> " . $results['message'];
            }
        } elseif (isset($_POST['customAction']) && $_POST['customAction'] == 'ModuleUnsuspend') {
            $command = 'ModuleUnsuspend';
            $postData = array(
                'accountid' => $_POST['serviceid'],
            );
            $admin = Capsule::table('tbladmins')
                ->where('roleid', '=', 1)
                ->get();
            $adminUsername = $admin[0]->username;
            $results = localAPI($command, $postData, $adminUsername);
            if (isset($results) && $results['result'] == 'success') {
                $response['result'] = "success";
                $response['message'] = "<strong>Success!</strong>Service Unsuspend Successfully!";
            } else {
                $response['result'] = "danger";
                $response['message'] = "<strong>Error!</strong> " . $results['message'];
            }
        } elseif (isset($_POST['customAction']) && $_POST['customAction'] == 'ModuleTerminate') {
            $command = 'ModuleTerminate';
            $postData = array(
                'accountid' => $_POST['serviceid'],
            );
            $admin = Capsule::table('tbladmins')
                ->where('roleid', '=', 1)
                ->get();
            $adminUsername = $admin[0]->username;
            $results = localAPI($command, $postData, $adminUsername);
            if (isset($results) && $results['result'] == 'success') {
                $response['result'] = "success";
                $response['message'] = "<strong>Success!</strong>Service Terminate Successfully!";
            } else {
                $response['result'] = "error";
                $response['message'] = "<strong>Error!</strong> " . $results['message'];
            }
        } elseif (isset($_POST['customAction']) && $_POST['customAction'] == 'ModuleRemove') {
            $affdetails = self::CheckAffCredit();
            $tblhostingdetails = Capsule::table('tblhosting')->where('id', '=', $_POST['serviceid'])->get();
            $admin = Capsule::table('tbladmins')
                ->where('roleid', '=', 1)
                ->get();
            $adminUsername = $admin[0]->username;
            $ModuleTerminate = 'ModuleTerminate';
            $ModuleTerminateData = array(
                'accountid' => $_POST['serviceid'],
            );
            localAPI($ModuleTerminate, $ModuleTerminateData, $adminUsername);
            $PendingOrder = 'PendingOrder';
            $PendingOrderData = array(
                'orderid' => $tblhostingdetails[0]->orderid,
            );
            localAPI($PendingOrder, $PendingOrderData, $adminUsername);
            $command = 'CancelOrder';
            $postData = array(
                'orderid' => $tblhostingdetails[0]->orderid,
            );
            $results = localAPI($command, $postData, $adminUsername);
            if (isset($results) && $results['result'] == 'success') {
                $DeleteOrder = 'DeleteOrder';
                $delete = localAPI($DeleteOrder, $postData, $adminUsername);
                if (isset($delete) && $delete['result'] == 'success') {
                    $response['result'] = "success";
                    $response['message'] = "<strong>Success!</strong> Service Remove Successfully!";
                    logModuleCall('NXT', 'Service Deleted', 'This  Order Id : ' . $tblhostingdetails[0]->orderid . ' has been deleted by reseller' . $affdetails->firstname . ' ' . $affdetails->lastname . "(" . $affdetails->email . ")", $delete, '', '');
                } else {
                    $response['result'] = "error";
                    logModuleCall('NXT', 'Service Deleted', 'Order Id : ' . $tblhostingdetails[0]->orderid, "<strong>Error!</strong> " . $delete['message'], '', '');
                    $response['message'] = "<strong>Error!</strong> " . $delete['message'];
                }
            } else {
                $response['result'] = "error";
                $response['message'] = "<strong>Error!</strong> " . $results['message'];
            }
        } elseif (isset($_POST['customAction']) && $_POST['customAction'] == 'ModuleRenew') {
            $resellerid = $_SESSION['uid'];
            $configdata = Capsule::table('tblconfiguration')
                ->where('setting', 'Reseller' . $resellerid)
                ->get();
            foreach ($configdata as $configdatavale) {
                $dataconfigp[$configdatavale->setting] = $configdatavale->value;
            }
            if (isset($dataconfigp['Reseller' . $resellerid]) && !empty($dataconfigp['Reseller' . $resellerid])) {
                $checked = $dataconfigp['Reseller' . $resellerid];
            }
            if ($checked == 'Disable') {
                $admin = Capsule::table('tbladmins')
                    ->where('roleid', '=', 1)
                    ->get();
                $adminUsername = $admin[0]->username;
                $invoices = Capsule::table('tblinvoiceitems')
                    ->join('tblinvoices', 'tblinvoiceitems.invoiceid', '=', 'tblinvoices.id')
                    ->where('tblinvoices.status', '=', 'Unpaid')
                    ->where('tblinvoiceitems.type', '=', 'Hosting')
                    ->where('tblinvoiceitems.relid', '=', $_POST['serviceid'])
                    ->get();
                if (isset($invoices) && !empty($invoices)) {
                    foreach ($invoices as $invoice) {
                        $getinvoice = localAPI('GetInvoice', array('invoiceid' => $invoice->invoiceid), $adminUsername);
                        if ($getinvoice['status'] != 'Paid') {
                            //Check if client is related to Reseller 
                            $userid = $getinvoice['userid'];
                            $checkdetials = Capsule::table('mod_xtreamAffs_clients')
                                ->where('clientid', '=', $userid)
                                ->get();
                            if (isset($checkdetials) && !empty($checkdetials)) {
                                //Get Affiliates details  
                                $getAffiliates = Capsule::table('tblaffiliates')
                                    ->where('id', '=', $checkdetials[0]->affiliatesid)
                                    ->get();
                                if (isset($getAffiliates) && !empty($getAffiliates)) {
                                    $credit = Capsule::table('tblclients')
                                        ->select('credit', 'firstname', 'lastname', 'email')
                                        ->where('id', '=', $getAffiliates[0]->clientid)
                                        ->get();
                                    $admin = Capsule::table('tbladmins')
                                        ->where('roleid', '=', 1)
                                        ->get();
                                    $adminUsername = $admin[0]->username;
                                    $affdetails = $credit[0];
                                    $add_credit = $getinvoice['total'];
                                    if ($affdetails->credit > $add_credit) {
                                        $AddCredit = 'AddCredit';
                                        $postData = array(
                                            'clientid' => $userid,
                                            'description' => 'Added funds by ' . $affdetails->firstname . ' ' . $affdetails->lastname,
                                            'amount' => $add_credit,
                                        );
                                        $resultsCredit = localAPI($AddCredit, $postData, $adminUsername);
                                        if ($resultsCredit['result'] == 'success') {
                                            Capsule::table('tblcredit')->insert(
                                                ['clientid' => $getAffiliates[0]->clientid, 'date' => date('Y-m-d'), 'description' => 'Add Credit to Client - ' . $userid, 'amount' => -$add_credit]
                                            );
                                            $removeCredit = $affdetails->credit - $add_credit;
                                            Capsule::table('tblclients')
                                                ->where('id', '=', $getAffiliates[0]->clientid)
                                                ->update(
                                                    [
                                                        'credit' => $removeCredit,
                                                    ]
                                                );
                                            $command = 'ApplyCredit';
                                            $postData = array(
                                                'invoiceid' => $invoice->invoiceid,
                                                'amount' => $add_credit,
                                            );
                                            $results = localAPI($command, $postData, $adminUsername);
                                            if ($results['result'] == 'success') {
                                                self::RemoveXtreamCredit($add_credit, $con);
                                            }
                                            logModuleCall('Stalker Dashboard', 'ApplyCredit', $postData, $results, '', '');
                                        }
                                    } else {
                                        $response['result'] = "error";
                                        $response['message'] = "<strong>Error!</strong>You don't have sufficient balance ! Click here to <a href='cart.php?gid=" . (!empty($returndata['gid']) ? $returndata['gid'] : 'addons') . "'> Click here </a> to add credits";
                                    }
                                }
                            }
                        }
                    }
                    if (isset($results) && $results['result'] == 'success') {
                        $response['result'] = "success";
                        $response['message'] = "<strong>Success!</strong> Service Renew Successfully!";
                    } else {
                        $response['result'] = "error";
                        $response['message'] = "<strong>Error!</strong> " . $results['message'];
                    }
                } else {
                    $response['result'] = "info";
                    $response['message'] = "<strong>Info!</strong> It can't be renewed at this stage";
                }
            }
        }
        $clientdata = Capsule::table('tblclients')->where('id', '=', $_SESSION['uid'])->get();
        // Get common module parameters
        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
        /*
         * Reseller Clients
         */
        $xtreamConfig = Capsule::table('mod_xtreamConfig')
            ->get();
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        $con = self::XtreamDashboard_testconnection();
        $email = $clientdata[0]->email;
        # Inserting Now New User into 
        // First checking if user already exist with reqeuest username  
        $result = mysqli_query($con, "SELECT id FROM members WHERE email='$email'");
        if (!$result) {
            $radiussqlerror = mysqli_error($con);
            self::NXT_WHMCSReconnect();
            logModuleCall('NXT', 'Check Reseller Exists', 'Email Address : ' . $email, "NXT Database Query Error: " . $radiussqlerror, '', '');
            return true;
        }
        if (mysqli_num_rows($result) > 0) {
            $resellerdata = mysqli_fetch_assoc($result);
            $trialusersdetails = mysqli_query($con, "SELECT id as xtreamid,username as xtreamusername,password as xtreampassword,is_trial,is_mag,exp_date FROM `users` WHERE member_id = '" . $resellerdata['id'] . "' AND is_mag='0' AND is_trial ='1' AND reseller_notes LIKE '" . $returndata['common_identifier'] . "%'");
            if (0 != mysqli_num_rows($trialusersdetails)) {
                while ($xtremservice = mysqli_fetch_assoc($trialusersdetails)) {
                    $mag_devices = mysqli_query($con, "SELECT * FROM `users` WHERE member_id = '" . $resellerdata['id'] . "' AND is_mag='1' AND pair_id = '" . $xtremservice['xtreamid'] . "'");
                    if (mysqli_num_rows($mag_devices) != 0) {
                        $mag_device_userid = mysqli_fetch_assoc($mag_devices);
                        $mag_details = mysqli_query($con, "SELECT * FROM `mag_devices` WHERE user_id='" . $mag_device_userid['id'] . "'");
                        if (mysqli_num_rows($mag_details) != 0) {
                            $macaddress = mysqli_fetch_assoc($mag_details);
                            $MAC = base64_decode($macaddress['mac']);
                        } else {
                            $MAC = '-';
                        }
                    } else {
                        $MAC = '-';
                    }
                    $response['iptvdetails'] = 'show';
                    $xtremservices = array_merge($xtremservice, array('mag_device' => $MAC));
                    $servicesdetails[$xtremservice['xtreamusername']] = array_merge(self::WHMCSServiceDetails($xtremservice['xtreamusername']), $xtremservices);
                }
            }
        }
        if (isset($_GET['result']) && $_GET['result'] == 'emerror') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> Email Address already exists!";
        } elseif (isset($_GET['result']) && $_GET['result'] == 'ccerror') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> You don't have sufficient credit's balance! <a href='cart.php?gid=" . $returndata['gid'] . "'> Click here </a> to Add Credits";
        } elseif (isset($_GET['result']) && $_GET['result'] == 'success') {
            $response['result'] = "success";
            $response['message'] = "<strong>Success!</strong> User Created Successfully!";
        } elseif (isset($_GET['result']) && $_GET['result'] == 'macerror') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> MAG Address Required!";
        }
        $response['action'] = '';
        if ($returndata['reseller_susp'] == 'on' || $resellerdata['reseller_unsusp'] == 'on' || $resellerdata['reseller_term'] == 'on' || $checked == 'Disable')
            $response['action'] = 'enable';

        $access_output = mysqli_query($con, "SELECT * FROM access_output");
        while ($output = mysqli_fetch_assoc($access_output)) {
            if ($output['output_name'] == 'MPEGTS') {
                $outputfirst = $output['output_key'];
            }
            $access_outputdata[] = $output;
        }
        if (empty($outputfirst)) {
            $outputfirst = array_values($access_outputdata)[0]['output_key'];
        }
        self::NXT_WHMCSReconnect();
        $xtreamautoscipt = Capsule::table('mod_xtreamautoscript')->get();
        foreach ($xtreamautoscipt as $value) {
            $autoscript[$value->name] = $value->value;
        }

        foreach ($servicesdetails as $serviceDetails) {

            $invoicesUn = Capsule::table('tblinvoiceitems')
                ->join('tblinvoices', 'tblinvoiceitems.invoiceid', '=', 'tblinvoices.id')
                ->where('tblinvoices.status', '=', 'Unpaid')
                ->where('tblinvoiceitems.type', '=', 'Hosting')
                ->where('tblinvoiceitems.relid', '=', $serviceDetails['id'])
                ->get();
            if (isset($invoicesUn) && !empty($invoicesUn)) {
                $servicesdetails[$serviceDetails['xtreamusername']]['showrenew'] = 'yes';
            } else {
                $servicesdetails[$serviceDetails['xtreamusername']]['showrenew'] = 'no';
            }
        }



        $response['listinactive'] = 'class="active"';
        $response['modulelink'] = $modulelink;
        $response['services'] = $servicesdetails;
        $response['lang'] = $returndata;
        $response['m3ulinkoutput'] = (isset($outputfirst) && !empty($outputfirst) ? $outputfirst : 'xxx');
        $response['accessoutput'] = $access_outputdata;
        $response['topup'] = $returndata['gid'];
        $response['$autoscript'] = $autoscript;
        return array(
            'pagetitle' => 'Client Details',
            'breadcrumb' => array(
                'index.php?m=nxtdashboard' => 'Xtream Dashboard Module',
                'index.php?m=nxtdashboard&action=xtreamservices' => 'Xtream Services Page',
            ),
            'templatefile' => 'xtreamservices',
            'requirelogin' => true, // Set true to restrict access to authenticated client users
            'forcessl' => false, // Deprecated as of Version 7.0. Requests will always use SSL if available.
            'vars' => $response,
        );
    }

    public function services($vars)
    {
        if (isset($_POST['tariff_id'])) {
            $iptvusername = $_POST['customfieldidtoupdateonserver'];
            $customfieldidtoupdate = $_POST['customfieldidtoupdate'];
            $customfieldarraytoinsert = "[";
            foreach ($_POST['tariff_id'] as $value) {
                $customfieldarraytoinsert .= $value . ",";
            }
            $newarraynama = rtrim($customfieldarraytoinsert, ",");
            $newarraynama .= "]";
            Capsule::table('tblcustomfieldsvalues')->where('id', $customfieldidtoupdate)->update(['value' => $newarraynama,]);
            $con = self::XtreamDashboard_testconnection();
            mysqli_query($con, "UPDATE users SET  bouquet='" . $newarraynama . "' WHERE username='$iptvusername'");
        }
        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule 
        $con = self::XtreamDashboard_testconnection();
        /*
         * Reseller Clients
         */
        $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        if (isset($_POST['customAction']) && $_POST['customAction'] == 'addMAG') {
            $newmac = $_POST['newMAC'];
            $result = self::XtreamDashboard_AddMAG($_POST, $newmac);
            if ($result == 'success') {
                $response['result'] = "success";
                $response['message'] = "<strong>Success!</strong> MAG Device Added Successfully!";
            } else {
                $response['result'] = "danger";
                $response['message'] = "<strong>Error!</strong> " . $result;
            }
        } elseif (isset($_POST['customAction']) && $_POST['customAction'] == 'changeMAG') {
            $newmac = $_POST['newMAC'];
            $result = self::XtreamDashboard_ChangeMAG($_POST, $newmac);
            if ($result == 'success') {
                $response['result'] = "success";
                $response['message'] = "<strong>Success!</strong> MAG Device Updated Successfully!";
            } else {
                $response['result'] = "danger";
                $response['message'] = "<strong>Error!</strong> " . $result;
            }
        } elseif (isset($_POST['customAction']) && $_POST['customAction'] == 'addENG') {
            $newmac = $_POST['newMAC'];
            $result = self::XtreamDashboard_AddENG($_POST, $newmac);
            if ($result == 'success') {
                $response['result'] = "success";
                $response['message'] = "<strong>Success!</strong> MAG Device Added Successfully!";
            } else {
                $response['result'] = "danger";
                $response['message'] = "<strong>Error!</strong> " . $result;
            }
        } elseif (isset($_POST['customAction']) && $_POST['customAction'] == 'changeENG') {
            $newmac = $_POST['newMAC'];
            $result = self::XtreamDashboard_ChangeENG($_POST, $newmac);
            if ($result == 'success') {
                $response['result'] = "success";
                $response['message'] = "<strong>Success!</strong> MAG Device Updated Successfully!";
            } else {
                $response['result'] = "danger";
                $response['message'] = "<strong>Error!</strong> " . $result;
            }
        } elseif (isset($_POST['customAction']) && $_POST['customAction'] == 'ModuleSuspend') {
            $command = 'ModuleSuspend';
            $postData = array(
                'accountid' => $_POST['serviceid'],
                'suspendreason' => "Suspend by Reseller",
            );
            $admin = Capsule::table('tbladmins')
                ->where('roleid', '=', 1)
                ->get();
            $adminUsername = $admin[0]->username;
            $results = localAPI($command, $postData, $adminUsername);
            if (isset($results) && $results['result'] == 'success') {
                $response['result'] = "success";
                $response['message'] = "<strong>Success!</strong> Service Suspend Successfully!";
            } else {
                $response['result'] = "danger";
                $response['message'] = "<strong>Error!</strong> " . $results['message'];
            }
        } elseif (isset($_POST['customAction']) && $_POST['customAction'] == 'ModuleUnsuspend') {
            $command = 'ModuleUnsuspend';
            $postData = array(
                'accountid' => $_POST['serviceid'],
            );
            $admin = Capsule::table('tbladmins')
                ->where('roleid', '=', 1)
                ->get();
            $adminUsername = $admin[0]->username;
            $results = localAPI($command, $postData, $adminUsername);
            if (isset($results) && $results['result'] == 'success') {
                $response['result'] = "success";
                $response['message'] = "<strong>Success!</strong>Service Unsuspend Successfully!";
            } else {
                $response['result'] = "danger";
                $response['message'] = "<strong>Error!</strong> " . $results['message'];
            }
        } elseif (isset($_POST['customAction']) && $_POST['customAction'] == 'ModuleTerminate') {
            $command = 'ModuleTerminate';
            $postData = array(
                'accountid' => $_POST['serviceid'],
            );
            $admin = Capsule::table('tbladmins')
                ->where('roleid', '=', 1)
                ->get();
            $adminUsername = $admin[0]->username;
            $results = localAPI($command, $postData, $adminUsername);
            if (isset($results) && $results['result'] == 'success') {
                $response['result'] = "success";
                $response['message'] = "<strong>Success!</strong>Service Terminate Successfully!";
            } else {
                $response['result'] = "error";
                $response['message'] = "<strong>Error!</strong> " . $results['message'];
            }
        } elseif (isset($_POST['customAction']) && $_POST['customAction'] == 'ModuleRemove') {
            $affdetails = self::CheckAffCredit();
            $tblhostingdetails = Capsule::table('tblhosting')->where('id', '=', $_POST['serviceid'])->get();
            $admin = Capsule::table('tbladmins')
                ->where('roleid', '=', 1)
                ->get();
            $adminUsername = $admin[0]->username;
            $ModuleTerminate = 'ModuleTerminate';
            $ModuleTerminateData = array(
                'accountid' => $_POST['serviceid'],
            );
            localAPI($ModuleTerminate, $ModuleTerminateData, $adminUsername);
            $PendingOrder = 'PendingOrder';
            $PendingOrderData = array(
                'orderid' => $tblhostingdetails[0]->orderid,
            );
            localAPI($PendingOrder, $PendingOrderData, $adminUsername);
            $command = 'CancelOrder';
            $postData = array(
                'orderid' => $tblhostingdetails[0]->orderid,
            );
            $results = localAPI($command, $postData, $adminUsername);
            if (isset($results) && $results['result'] == 'success') {
                $DeleteOrder = 'DeleteOrder';
                $delete = localAPI($DeleteOrder, $postData, $adminUsername);
                if (isset($delete) && $delete['result'] == 'success') {
                    $response['result'] = "success";
                    $response['message'] = "<strong>Success!</strong> Service Remove Successfully!";
                    logModuleCall('NXT', 'Service Deleted', 'This  Order Id : ' . $tblhostingdetails[0]->orderid . ' has been deleted by reseller' . $affdetails->firstname . ' ' . $affdetails->lastname . "(" . $affdetails->email . ")", $delete, '', '');
                } else {
                    $response['result'] = "danger";
                    logModuleCall('NXT', 'Service Deleted', 'Order Id : ' . $tblhostingdetails[0]->orderid, "<strong>Error!</strong> " . $delete['message'], '', '');
                    $response['message'] = "<strong>Error!</strong> " . $delete['message'];
                }
            } else {
                $response['result'] = "error";
                $response['message'] = "<strong>Error!</strong> " . $results['message'];
            }
        } elseif (isset($_POST['customAction']) && $_POST['customAction'] == 'ModuleRenew') {
            $resellerid = $_SESSION['uid'];
            $configdata = Capsule::table('tblconfiguration')
                ->where('setting', 'Reseller' . $resellerid)
                ->get();
            foreach ($configdata as $configdatavale) {
                $dataconfigp[$configdatavale->setting] = $configdatavale->value;
            }
            if (isset($dataconfigp['Reseller' . $resellerid]) && !empty($dataconfigp['Reseller' . $resellerid])) {
                $checked = $dataconfigp['Reseller' . $resellerid];
            }
            if ($checked == 'Disable') {
                $admin = Capsule::table('tbladmins')
                    ->where('roleid', '=', 1)
                    ->get();
                $adminUsername = $admin[0]->username;
                $invoices = Capsule::table('tblinvoiceitems')
                    ->join('tblinvoices', 'tblinvoiceitems.invoiceid', '=', 'tblinvoices.id')
                    ->where('tblinvoices.status', '=', 'Unpaid')
                    ->where('tblinvoiceitems.type', '=', 'Hosting')
                    ->where('tblinvoiceitems.relid', '=', $_POST['serviceid'])
                    ->get();
                if (isset($invoices) && !empty($invoices)) {
                    foreach ($invoices as $invoice) {
                        $getinvoice = localAPI('GetInvoice', array('invoiceid' => $invoice->invoiceid), $adminUsername);
                        if ($getinvoice['status'] != 'Paid') {
                            //Check if client is related to Reseller 
                            $userid = $getinvoice['userid'];
                            $checkdetials = Capsule::table('mod_xtreamAffs_clients')
                                ->where('clientid', '=', $userid)
                                ->get();
                            if (isset($checkdetials) && !empty($checkdetials)) {
                                //Get Affiliates details  
                                $getAffiliates = Capsule::table('tblaffiliates')
                                    ->where('id', '=', $checkdetials[0]->affiliatesid)
                                    ->get();
                                if (isset($getAffiliates) && !empty($getAffiliates)) {
                                    $credit = Capsule::table('tblclients')
                                        ->select('credit', 'firstname', 'lastname', 'email')
                                        ->where('id', '=', $getAffiliates[0]->clientid)
                                        ->get();
                                    $admin = Capsule::table('tbladmins')
                                        ->where('roleid', '=', 1)
                                        ->get();
                                    $adminUsername = $admin[0]->username;
                                    $affdetails = $credit[0];
                                    $add_credit = $getinvoice['total'];
                                    if ($affdetails->credit > $add_credit) {
                                        $AddCredit = 'AddCredit';
                                        $postData = array(
                                            'clientid' => $userid,
                                            'description' => 'Added funds by ' . $affdetails->firstname . ' ' . $affdetails->lastname,
                                            'amount' => $add_credit,
                                        );
                                        $resultsCredit = localAPI($AddCredit, $postData, $adminUsername);
                                        if ($resultsCredit['result'] == 'success') {
                                            Capsule::table('tblcredit')->insert(
                                                ['clientid' => $getAffiliates[0]->clientid, 'date' => date('Y-m-d'), 'description' => 'Add Credit to Client - ' . $userid, 'amount' => -$add_credit]
                                            );
                                            $removeCredit = $affdetails->credit - $add_credit;
                                            Capsule::table('tblclients')
                                                ->where('id', '=', $getAffiliates[0]->clientid)
                                                ->update(
                                                    [
                                                        'credit' => $removeCredit,
                                                    ]
                                                );
                                            $command = 'ApplyCredit';
                                            $postData = array(
                                                'invoiceid' => $invoice->invoiceid,
                                                'amount' => $add_credit,
                                            );
                                            $results = localAPI($command, $postData, $adminUsername);
                                            if ($results['result'] == 'success') {
                                                self::RemoveXtreamCredit($add_credit, $con);
                                            }
                                            logModuleCall('Stalker Dashboard', 'ApplyCredit', $postData, $results, '', '');
                                        }
                                    } else {
                                        $response['result'] = "error";
                                        $response['message'] = "<strong>Error!</strong>You don't have sufficient balance ! Click here to <a href='cart.php?gid=" . (!empty($returndata['gid']) ? $returndata['gid'] : 'addons') . "'> Click here </a> to add credits";
                                    }
                                }
                            }
                        }
                    }
                    if (isset($results) && $results['result'] == 'success') {
                        $response['result'] = "success";
                        $response['message'] = "<strong>Success!</strong> Service Renew Successfully!";
                    } else {
                        $response['result'] = "error";
                        $response['message'] = "<strong>Error!</strong> " . $results['message'];
                    }
                } else {
                    $response['result'] = "info";
                    $response['message'] = "<strong>Info!</strong> It can't be renewed at this stage";
                }
            }
        }
        $selectedclientservices = self::WHMCSClientServices($_GET['userid']);
        /* echo "<pre>";print_r($selectedclientservices);die(); */
        if ($selectedclientservices['result'] == 'success') {
            $clientdata = Capsule::table('tblclients')->where('id', '=', $_SESSION['uid'])->get();
            $email = $clientdata[0]->email;
            # Inserting Now New User into 
            // First checking if user already exist with reqeuest username  
            $result = mysqli_query($con, "SELECT id FROM members WHERE email='$email'");
            if (!$result) {
                $radiussqlerror = mysqli_error($con);
                self::NXT_WHMCSReconnect();
                logModuleCall('NXT', 'Check Reseller Exists', 'Email Address : ' . $email, "NXT Database Query Error: " . $radiussqlerror, '', '');
                return true;
            }
            $response['resellermag'] = '';
            if (mysqli_num_rows($result) > 0) {
                $resellerdata = mysqli_fetch_assoc($result);
                if (isset($clientdata[0]->groupid) && !empty($clientdata[0]->groupid)) {
                    $clientgrop = Capsule::table('tblclientgroups')->where('id', '=', $clientdata[0]->groupid)->get();
                    if ($clientgrop[0]->groupname == 'Super-Reseller') {
                        $checkReseller = self::CheckSelectedClientReseller($selectedclientservices['clientid']);
                        if ($checkReseller == 'Reseller' || $checkReseller == 'Super-Reseller') {
                            foreach ($selectedclientservices['products']['product'] as $service) {
                                $configoption = Capsule::table('tblproducts')->where('id', '=', $service['pid'])->select('configoption13')->get();
                                $users = mysqli_query($con, "SELECT id as xtreamid,username as xtreamusername,password as xtreampassword FROM `members` WHERE owner_id = '" . $resellerdata['id'] . "' AND member_group_id='" . $configoption[0]->configoption13 . "' AND notes = '" . $returndata['common_identifier'] . "" . $_GET['userid'] . "' AND email='" . $service['username'] . "'");
                                $totalusers = mysqli_num_rows($users);
                                if ($totalusers > 0) {
                                    while ($xtremservice = mysqli_fetch_assoc($users)) {
                                        $xtremservices = array_merge($xtremservice, array(
                                            'xtreampassword' => 'amanpreet11', 'mag_device' => '-', 'is_trial' => '-',
                                            'is_mag' => '-'
                                        ));
                                        $servicesdetails[] = array_merge($service, $xtremservices);
                                    }
                                } else {
                                    $data = array(
                                        'xtreamusername' => '-',
                                        'xtreampassword' => '-',
                                        'is_trial' => '-',
                                        'is_mag' => '-',
                                        'mag_device' => '-'
                                    );
                                    $servicesdetails[] = array_merge($service, $data);
                                }
                            }
                            $response['resellermag'] = 'reseller';
                        } else {
                            $resultresponse = self::XtreamServices($selectedclientservices, $resellerdata, $con);
                            $response['response'] = $resultresponse['response'];
                            $servicesdetails = $resultresponse['servicesdetails'];
                        }
                    } else {
                        $resultresponse = self::XtreamServices($selectedclientservices, $resellerdata, $con);
                        $response['response'] = $resultresponse['response'];
                        $servicesdetails = $resultresponse['servicesdetails'];
                    }
                }
            }
        }
        $i = 0;
        foreach ($servicesdetails as $Servicekey) {
            $CheckUpgradePackage = Capsule::table('tblproduct_upgrade_products')->where('product_id', '=', $Servicekey['pid'])->count();
            if ($CheckUpgradePackage > 0) {
                $servicesdetails[$i]['upgrade'] = 'yes';
            } else {
                $servicesdetails[$i]['upgrade'] = 'no';
            }
            $invoicesUn = Capsule::table('tblinvoiceitems')
                ->join('tblinvoices', 'tblinvoiceitems.invoiceid', '=', 'tblinvoices.id')
                ->where('tblinvoices.status', '=', 'Unpaid')
                ->where('tblinvoiceitems.type', '=', 'Hosting')
                ->where('tblinvoiceitems.relid', '=', $Servicekey['id'])
                ->get();
            if (isset($invoicesUn) && !empty($invoicesUn)) {
                $servicesdetails[$i]['showrenew'] = 'yes';
            } else {
                $servicesdetails[$i]['showrenew'] = 'no';
            }



            $i++;
        }
        $resellerid = $_SESSION['uid'];
        $configdata = Capsule::table('tblconfiguration')
            ->where('setting', 'Reseller' . $resellerid)
            ->get();
        foreach ($configdata as $configdatavale) {
            $dataconfigp[$configdatavale->setting] = $configdatavale->value;
        }
        if (isset($dataconfigp['Reseller' . $resellerid]) && !empty($dataconfigp['Reseller' . $resellerid])) {
            $checked = $dataconfigp['Reseller' . $resellerid];
        }
        $response['action'] = '';
        if ($returndata['reseller_susp'] == 'on' || $returndata['reseller_unsusp'] == 'on' || $returndata['reseller_term'] == 'on' || $returndata['reseller_remove'] == 'on' || $checked == 'Disable')
            $response['action'] = 'enable';

        $access_output = mysqli_query($con, "SELECT * FROM access_output");

        while ($output = mysqli_fetch_assoc($access_output)) {
            if ($output['output_name'] == 'MPEGTS') {
                $outputfirst = $output['output_key'];
            }
            $access_outputdata[] = $output;
        }
        if (empty($outputfirst)) {
            $outputfirst = array_values($access_outputdata)[0]['output_key'];
        }
        self::NXT_WHMCSReconnect();
        $xtreamautoscipt = Capsule::table('mod_xtreamautoscript')->get();
        foreach ($xtreamautoscipt as $value) {
            $autoscript[$value->name] = $value->value;
        }
        $clintID = $servicesdetails[0]['clientid'];

        $clients_detail[] = self::WHMCSClientDetails($clintID);
        /* echo "<pre>";print_r($servicesdetails);die(); */
        $response['listactive'] = 'class="active"';
        $response['modulelink'] = $modulelink;
        $response['userdetails'] = $clients_detail;
        $response['services'] = $servicesdetails;
        $response['CurrentOpen_User'] = $_GET['userid'];
        $response['checked'] = $checked;
        $response['lang'] = $returndata;
        $response['m3ulinkoutput'] = (isset($outputfirst) && !empty($outputfirst) ? $outputfirst : 'xxx');
        $response['accessoutput'] = $access_outputdata;
        $response['topup'] = $returndata['gid'];
        $response['autoscript'] = $autoscript;
        return array(
            'pagetitle' => 'Client Details',
            'breadcrumb' => array(
                'index.php?m=nxtdashboard' => 'Xtream Dashboard Module',
                'index.php?m=nxtdashboard&action=xtreamservices' => 'Xtream Services Page',
            ),
            'templatefile' => 'xtreamservices',
            'requirelogin' => true, // Set true to restrict access to authenticated client users
            'forcessl' => false, // Deprecated as of Version 7.0. Requests will always use SSL if available.
            'vars' => $response,
        );
    }

    public function GetFinalPriceProducts($ProductId = "", $UserId = "")
    {
        $PricingArraySetArray = array('msetupfee', 'qsetupfee', 'ssetupfee', 'asetupfee', 'bsetupfee', 'tsetupfee', 'monthly', 'quarterly', 'semiannually', 'annually', 'biennially', 'triennially');

        $periodtimeArrayInmonth = array(
            'monthly' => '1',
            'quarterly' => '3',
            'semiannually' => '6',
            'annually' => '12',
            'biennially' => '24',
            'triennially' => '36'
        );

        $currencydata = Capsule::table('tblclients')->where('id', '=', $UserId)->select('currency')->get();
        $currency = $currencydata[0]->currency;
        $currencydetails = Capsule::table('tblcurrencies')->where('id', '=', $currency)->get();
        $billingcycle[$ProductId] = self::getProductBillingCycle($ProductId, $currency);
        $Currencyprefix = $currencydetails[0]->prefix;
        $Currencycode = $currencydetails[0]->code;
        $FinalPriceArray = array();
        foreach ($PricingArraySetArray as $SetPriceKey) {
            if ($billingcycle[$ProductId][0]->$SetPriceKey > 0.00) {
                $SetPriceKeyKey = $SetPriceKey;
                $periodtime = "";
                if ($billingcycle[$ProductId][0]->paytype == 'onetime') {
                    $SetPriceKeyKey = "onetime";
                    $periodtime = "onetime";
                } else {
                    $periodtime = $periodtimeArrayInmonth[$SetPriceKey];
                }
                $FinalPriceArray[$SetPriceKeyKey] = array(
                    'prefix' => $Currencyprefix,
                    'code' => $Currencycode,
                    'periodtime' => $periodtime,
                    'Price' => $billingcycle[$ProductId][0]->$SetPriceKey
                );
            }
        }

        return $FinalPriceArray;
    }

    public function GetDayesByDateDiff($strDateFrom, $strDateTo)
    {
        $date1 = date_create($strDateFrom);
        $date2 = date_create($strDateTo);
        $diff = date_diff($date1, $date2);
        return $diff->format("%a");
    }

    public function showorder()
    {

        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule

        $TemplateName = "xtreamshoworder";
        $UpdatedProductDetails = array();
        $ordernum = "";
        $error = "";
        $uid = "";
        if (isset($_GET['pid']) && $_GET['pid'] != "") {
            $UpdatedProductDetails = Capsule::table('tblproducts')
                ->join('tblproductgroups', 'tblproducts.gid', '=', 'tblproductgroups.id')
                ->select('tblproducts.id as product_id', 'tblproducts.name as product_name', 'tblproductgroups.name as group_name')
                ->where('tblproducts.id', $_GET['pid'])
                ->get();
        }

        if (isset($_GET['ordernum']) && $_GET['ordernum'] != "" && isset($_GET['status']) && $_GET['status'] == "success") {
            $ordernum = $_GET['ordernum'];
        }

        if (isset($_GET['status']) && $_GET['status'] == "error") {
            $error = 'Something goes worng during upgrading.';
        }
        if (isset($_GET['uid']) && $_GET['uid'] != "") {
            $uid = $_GET['uid'];
        }

        $response['uid'] = $uid;
        $response['UpdatedProductDetails'] = $UpdatedProductDetails;
        $response['error'] = $error;
        $response['ordernum'] = $ordernum;
        return array(
            'pagetitle' => 'Client Details',
            'breadcrumb' => array(
                'index.php?m=nxtdashboard' => 'Xtream Dashboard Module',
                'index.php?m=nxtdashboard&action=xtreamupgrade' => 'Xtream showorder Page',
            ),
            'templatefile' => $TemplateName,
            'requirelogin' => true, // Set true to restrict access to authenticated client users
            'forcessl' => false, // Deprecated as of Version 7.0. Requests will always use SSL if available.
            'vars' => $response,
        );
    }

    public function xtreamupgrade($vars)
    {
        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule

        $TemplateName = "xtreamupgradepackage";
        if (isset($_GET['service']) && !empty($_GET['service'])) {
            $ServiceId = $_GET['service'];
            $CurrentProductServiceData = Capsule::table('tblhosting')
                ->join('tblproducts', 'tblhosting.packageid', '=', 'tblproducts.id')
                ->join('tblproductgroups', 'tblproducts.gid', '=', 'tblproductgroups.id')
                ->select('tblhosting.*', 'tblproducts.id as product_id', 'tblproducts.name as product_name', 'tblproductgroups.name as group_name')
                ->where('tblhosting.id', $ServiceId)
                ->get();
            if (!empty($CurrentProductServiceData)) {
                $ProductId = $CurrentProductServiceData[0]->product_id;
                $Userid = $CurrentProductServiceData[0]->userid;
                $UgradeProductsPrice = Capsule::table('tblproduct_upgrade_products')
                    ->join('tblproducts', 'tblproduct_upgrade_products.upgrade_product_id', '=', 'tblproducts.id')
                    ->join('tblproductgroups', 'tblproducts.gid', '=', 'tblproductgroups.id')
                    ->select('tblproducts.id as product_id', 'tblproducts.name as product_name', 'tblproducts.description as product_description', 'tblproductgroups.name as group_name')
                    ->where('tblproduct_upgrade_products.product_id', $ProductId)
                    ->get();


                $upgradefinaldetailsarray = array();
                foreach ($UgradeProductsPrice as $upProductdetails) {
                    $ProductIdu = $upProductdetails->product_id;
                    $Productnameu = $upProductdetails->product_name;
                    $Productdescription = $upProductdetails->product_description;
                    if ($Productdescription != "") {
                        $ExplaodedDescription = explode("\n", $Productdescription);
                        if (!empty($ExplaodedDescription)) {
                            $Productdescription = "";
                            foreach ($ExplaodedDescription as $DevValue) {
                                $Productdescription .= $DevValue . "<br>";
                            }
                        }
                    }
                    $groupname = $upProductdetails->group_name;
                    $FinalPriceArrayGet = self::GetFinalPriceProducts($ProductIdu, $Userid);
                    $upgradefinaldetailsarray[$ProductIdu] = array(
                        'groupname' => $groupname,
                        'productname' => $Productnameu,
                        'productdescription' => $Productdescription,
                        'price' => $FinalPriceArrayGet
                    );
                }
                if (isset($_POST['proceedupgrade'])) {
                    $TemplateName = "xtreamupgradepayment";
                    $TodayDate = date('Y-m-d');
                    /* ------------Current Package details ----------------------------------- */

                    $CurrentPackagePrice = $CurrentProductServiceData[0]->amount;
                    if ($CurrentProductServiceData[0]->billingcycle == "One Time") {
                        $CurrentPackagePrice = $CurrentProductServiceData[0]->firstpaymentamount;
                    }

                    $RegDate = $CurrentProductServiceData[0]->regdate;                                   //Start Package Date of Current package .

                    $NextDueDate = $CurrentProductServiceData[0]->nextduedate;                           //Next Due date of current package .

                    $TotalDaysDIff = self::GetDayesByDateDiff($RegDate, $NextDueDate);                    //Get Days between start date and due date(end date) .

                    $PerDaysPriceWithExistingPackage = $CurrentPackagePrice / $TotalDaysDIff;    //Get per days price of current package.

                    $UsedOldPackageDays = self::GetDayesByDateDiff($RegDate, $TodayDate);      //Get the used days of old package .
                    if ($UsedOldPackageDays == 0) {
                        $UsedOldPackageDays = 1;
                    }
                    $UsedAmmountOdOldPackage = $PerDaysPriceWithExistingPackage * $UsedOldPackageDays;  //Get The used ammount of current package. 


                    $Balanceammount = $CurrentPackagePrice - $UsedAmmountOdOldPackage;  //Get The used ammount of current package. 

                    /* --------------------------Selected package details------------------------------ */
                    $SelectedPackage = $_POST['SelectPackage'];                                 //Selected upgrade package .

                    $ExplodedSelected = explode(",", $SelectedPackage);                          //Explode upgrade package details.

                    $UpGradePackagePrice = $ExplodedSelected[0];                                //Get The selected upgrade product price.

                    $UpGradebillingcycle = $ExplodedSelected[1];                                //Get The selected upgrade product billingcycle.    

                    $UpGradePackageId = $ExplodedSelected[2];                                   //Get The selected upgrade product packageid.

                    $UpGradePackageMonths = $ExplodedSelected[3];                                   //Get The selected upgrade product packageid.

                    $prefixCurrency = $ExplodedSelected[4];                                   //Get The selected upgrade product packageid.

                    $codecurrency = $ExplodedSelected[5];                                   //Get The selected upgrade product packageid.

                    $NextDUeDateNewPackahge = date('Y-m-d', strtotime($RegDate . " + " . $UpGradePackageMonths . " months")); // Next expected due date of new selected package .

                    $TotalDaysDIffNewPackage = self::GetDayesByDateDiff($RegDate, $NextDUeDateNewPackahge);   //Get Days between start date and due date(end date) . 

                    $PerDaysAmmountForNewPackage = $UpGradePackagePrice / $TotalDaysDIffNewPackage;             //Get Perday price of new package.

                    $UsedAmmountOdOldPackageForNewPackage = $PerDaysAmmountForNewPackage * $UsedOldPackageDays; //Used days ammount of new package.

                    $ReducedAmount = $UpGradePackagePrice - $Balanceammount;  //ReducedAmount after subtract balance amount of old package after userd from new package ammount .

                    $FinalAmmountofNewPackage = $ReducedAmount - $UsedAmmountOdOldPackageForNewPackage;            //Final ammount of new upgrade package.

                    $newproductdetails = Capsule::table('tblproducts')
                        ->select('tblproducts.*')
                        ->where('id', $UpGradePackageId)
                        ->get();

                    $response['UpgradePeriod'] = $UpGradePackageMonths . " Months";
                    $response['UpGradebillingcycle'] = $UpGradebillingcycle;
                    $response['newproductdetails'] = $newproductdetails;
                    $response['FinalAmmountofNewPackage'] = round($FinalAmmountofNewPackage, 2);
                    $response['prefixCurrency'] = $prefixCurrency;
                    $response['codecurrency'] = $codecurrency;
                }
                if (isset($_POST['upgradenow'])) {
                    /* echo "<pre>";print_r($_POST);die(); */
                    $affdetails = self::CheckAffCredit();
                    $UserDetailsGet = Capsule::table('tblclients')
                        ->where('id', $Userid)
                        ->get();
                    $results = array();
                    $AdminName = self::GetAdminName();
                    $command = 'UpgradeProduct';
                    $postData = array(
                        'serviceid' => $_POST['serviceid'],
                        'paymentmethod' => $_POST['paymentmethod'],
                        'newproductbillingcycle' => $_POST['newproductbillingcycle'],
                        'type' => $_POST['type'],
                        'calconly' => '0',
                        'newproductid' => $_POST['newproductid'],
                    );
                    $results = localAPI($command, $postData, $AdminName);
                    $link = "";
                    logModuleCall('Xtream Dashboard', 'Upgrade package', $postData, $results, '', '');
                    if ($results['result'] == 'success') {
                        $command = 'ModuleChangePackage';
                        $postData = array(
                            'accountid' => $_POST['serviceid'],
                        );

                        $resultsChangePackage = localAPI($command, $postData, self::GetAdminName());
                        logModuleCall('Xtream Dashboard', 'Change package', $postData, $resultsChangePackage, '', '');
                        if ($resultsChangePackage['result'] == 'success') {
                            self::WHMCSdoLogin();
                            $InvoiceId = $results['invoiceid'];
                            $OrderNumber = $results['order_number'];
                            $invoiceTotal = Capsule::table('tblinvoices')->where('id', '=', $InvoiceId)->select('tblinvoices.total')->get();
                            $add_credit = $invoiceTotal[0]->total;
                            self::WHMCSdoLogin();
                            $AddCredit = 'AddCredit';
                            $postData = array(
                                'clientid' => $UserDetailsGet[0]->id,
                                'description' => 'Added funds by ' . $UserDetailsGet[0]->firstname . ' ' . $UserDetailsGet[0]->lastname,
                                'amount' => $add_credit,
                            );
                            $resultsCredit = localAPI($AddCredit, $postData, $AdminName);

                            if ($resultsCredit['result'] == 'success') {
                                Capsule::table('tblcredit')->insert(
                                    ['clientid' => $_SESSION['uid'], 'date' => date('Y-m-d'), 'description' => 'Add Credit to Client - ' . $UserDetailsGet[0]->id, 'amount' => -$add_credit]
                                );
                                $removeCredit = $affdetails->credit - $add_credit;
                                self::RemoveWHMCSCredit($removeCredit);
                                /**
                                 * Remove Credits in X.C
                                 */
                                $con = self::XtreamDashboard_testconnection();
                                self::RemoveXtreamCredit($add_credit, $con);

                                self::WHMCSdoLogin();
                                $command = 'ApplyCredit';
                                $postData = array(
                                    'invoiceid' => $InvoiceId,
                                    'amount' => $invoiceTotal[0]->total,
                                );
                                $results = localAPI($command, $postData, $AdminName);
                                if ($results['result'] == 'success') {
                                    self::WHMCSdoLogin();
                                    $link = "?m=nxtdashboard&action=showorder&pid=" . $_POST['newproductid'] . "&uid=" . $Userid . "&ordernum=" . $OrderNumber . "&status=success";
                                } else {
                                    self::WHMCSdoLogin();
                                    $link = "?m=nxtdashboard&action=showorder&pid=" . $_POST['newproductid'] . "&uid=" . $Userid . "&status=error";
                                }
                                logModuleCall('Xtream Dashboard', 'ApplyCredit', $postData, $results, '', '');
                                self::WHMCSdoLogin();
                            } else {
                                self::WHMCSdoLogin();
                                $link = "?m=nxtdashboard&action=showorder&pid=" . $_POST['newproductid'] . "&uid=" . $Userid . "&status=error";
                            }
                        } else {
                            self::WHMCSdoLogin();
                            $link = "?m=nxtdashboard&action=showorder&pid=" . $_POST['newproductid'] . "&uid=" . $Userid . "&status=error";
                        }
                    } else {
                        self::WHMCSdoLogin();
                        $link = "?m=nxtdashboard&action=showorder&pid=" . $_POST['newproductid'] . "&uid=" . $Userid . "&status=error";
                    }

                    echo '<script type="text/javascript">
                           window.location = "' . $link . '"
                      </script>';

                    die();
                }


                $PaymentCommandcommand = 'GetPaymentMethods';
                $postData = array();
                $adminUsername = self::GetAdminName(); // Optional for WHMCS 7.2 and later

                $GetPaymentsresults = localAPI($PaymentCommandcommand, $postData, $adminUsername);

                $response['DefaultPaymentMethod'] = $GetPaymentsresults['paymentmethods']['paymentmethod'][0]['module'];
                $response['CurrentProductServiceData'] = $CurrentProductServiceData;
                $response['upgradefinaldetailsarray'] = $upgradefinaldetailsarray;
                $response['CurrentUserId'] = $Userid;
                $response['CurrentServiceId'] = $ServiceId;
                $response['listactive'] = 'class="active"';
                $response['modulelink'] = $modulelink;
                $response['services'] = $servicesdetails;
                $response['checked'] = $checked;
                $response['lang'] = $returndata;
                $response['m3ulinkoutput'] = (isset($outputfirst) && !empty($outputfirst) ? $outputfirst : 'xxx');
                $response['accessoutput'] = $access_outputdata;
                $response['topup'] = $returndata['gid'];
                $response['autoscript'] = $autoscript;
                return array(
                    'pagetitle' => 'Client Details',
                    'breadcrumb' => array(
                        'index.php?m=nxtdashboard' => 'Xtream Dashboard Module',
                        'index.php?m=nxtdashboard&action=upgradetest' => 'Xtream upgrade package Page',
                    ),
                    'templatefile' => $TemplateName,
                    'requirelogin' => true, // Set true to restrict access to authenticated client users
                    'forcessl' => false, // Deprecated as of Version 7.0. Requests will always use SSL if available.
                    'vars' => $response,
                );
            }
        }
    }

    public function GetAdminName()
    {
        $admin = Capsule::table('tbladmins')
            ->where('roleid', '=', 1)
            ->get();
        $adminUsername = $admin[0]->username;
        return $adminUsername;
    }

    public function adduser($vars)
    {
        if (isset($_POST['customfields']) && !empty($_POST['customfields'])) {
            $vars['customfields'] = $_POST['customfields'];
            $vars['packageid'] = $_POST['packageid'];
        }
        // $reseller_id = $_SESSION['xtreamuserid'];
        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
        $errormessage = false;
        $successmessage = false;
        if (isset($_POST['add_client'])) {
            $xtreamConfig = Capsule::table('mod_xtreamConfig')
                ->get();
            $returndata = array();
            if (isset($xtreamConfig) && !empty($xtreamConfig)) {
                foreach ($xtreamConfig as $config) {
                    $returndata[$config->setting] = $config->value;
                }
            }
            $productdetils = Capsule::table('tblproducts')->where('id', '=', $_POST['packageid'])->get();
            if ($productdetils[0]->configoption2 == 'magdevice') {
                if (empty($_POST['customfields'][$_POST['packageid']][$returndata['custom_field_mag']])) {
                    echo '<script>window.location.href="index.php?m=nxtdashboard&action=adduser&result=macerror"</script>';
                    exit;
                }
            } elseif ($productdetils[0]->configoption2 == 'engdevice') {
                if (empty($_POST['customfields'][$_POST['packageid']][$returndata['custom_field_eng']])) {
                    echo '<script>window.location.href="index.php?m=nxtdashboard&action=adduser&result=engerror"</script>';
                    exit;
                }
            }
            $checkmagdevice = $_POST['customfields'][$_POST['packageid']][$returndata['checkmagdevice']];
            if (isset($checkmagdevice) && !empty($checkmagdevice)) {
                if ($checkmagdevice == 'on') {
                    if (empty($_POST['customfields'][$_POST['packageid']][$returndata['custom_field_mag']])) {
                        echo '<script>window.location.href="index.php?m=nxtdashboard&action=adduser&result=macerror"</script>';
                        exit;
                    }
                }
            }
            $checkengdevice = $_POST['customfields'][$_POST['packageid']][$returndata['checkengdevice']];
            if (isset($checkengdevice) && !empty($checkengdevice)) {
                if ($checkengdevice == 'on') {
                    if (empty($_POST['customfields'][$_POST['packageid']][$returndata['custom_field_eng']])) {
                        echo '<script>window.location.href="index.php?m=nxtdashboard&action=adduser&result=engerror"</script>';
                        exit;
                    }
                }
            }
            if (isset($_POST['login']) && !empty($_POST['login'])) {
                $clientdetails = Capsule::table('tblclients')
                    ->where('email', '=', $_POST['login'])
                    ->count();
                if (isset($clientdetails) && !empty($clientdetails)) {
                    echo '<script>window.location.href="nxtdashboard&action=xtreamusers&result=emerror"</script>';
                    exit;
                }
            } else {
                if (isset($_POST['customfields'][$_POST['packageid']]['Username']) && !empty($_POST['customfields'][$_POST['packageid']]['Username'])) {
                    /**
                     * check username exists in Stalker or not
                     */
                    $usernameexists = self::checkUserExistsInXtream($_POST['customfields'][$_POST['packageid']]['Username'], $_POST['packageid']);
                    if (isset($usernameexists) && !empty($usernameexists)) {
                        echo '<script>window.location.href="index.php?m=nxtdashboard&action=adduser&result=ucerror"</script>';
                        exit;
                    }
                    $_POST['xtreamusername'] = $_POST['customfields'][$_POST['packageid']]['Username'];
                } else {
                    $_POST['xtreamusername'] = self::NXT_StrongPassword();
                }
            }
            if (isset($_POST['customfields'][$_POST['packageid']]['Password']) && !empty($_POST['customfields'][$_POST['packageid']]['Password'])) {
                $_POST['xtreampassword'] = $_POST['customfields'][$_POST['packageid']]['Password'];
            } else {
                $_POST['xtreampassword'] = self::NXT_StrongPassword();
            }

            $xtreamusername = $_POST['xtreamusername'];
            $xtreampassword = $_POST['xtreampassword'];
            $selected_bouquets = $_POST['customfields'][$_POST['packageid']]['Select Bouquets'];

            if (empty($_POST['packageid'])) {
                echo '<script>window.location.href="index.php?m=nxtdashboard&action=adduser&result=pkerror"</script>';
                exit;
            } elseif (isset($_POST['billingcycle'][$_POST['packageid']]) && empty($_POST['billingcycle'][$_POST['packageid']])) {
                echo '<script>window.location.href="index.php?m=nxtdashboard&action=adduser&result=bcerror"</script>';
                exit;
            }
            if (isset($_POST['customfields'][$_POST['packageid']][$returndata['custom_field_mag']]) && !empty($_POST['customfields'][$_POST['packageid']][$returndata['custom_field_mag']])) {
                if (!preg_match('/([0-9A-Fa-f]{2}[:]){5}([0-9A-Fa-f]{2})/', $_POST['customfields'][$_POST['packageid']][$returndata['custom_field_mag']])) {
                    echo '<script>window.location.href="index.php?m=nxtdashboard&action=adduser&result=macvalid"</script>';
                    exit;
                }
                /* check MAG Exists */
                $macexists = self::checkMagExistsInXtream($_POST['customfields'][$_POST['packageid']][$returndata['custom_field_mag']], $_POST['packageid']);
                if (isset($macexists) && !empty($macexists)) {
                    echo '<script>window.location.href="index.php?m=nxtdashboard&action=adduser&result=macexists"</script>';
                    exit;
                }
            } elseif (isset($_POST['customfields'][$_POST['packageid']][$returndata['custom_field_eng']]) && !empty($_POST['customfields'][$_POST['packageid']][$returndata['custom_field_eng']])) {
                if (!preg_match('/([0-9A-Fa-f]{2}[:]){5}([0-9A-Fa-f]{2})/', $_POST['customfields'][$_POST['packageid']][$returndata['custom_field_eng']])) {
                    echo '<script>window.location.href="index.php?m=nxtdashboard&action=adduser&result=macvalid"</script>';
                    exit;
                }
                /* check MAG Exists */
                $macexists = self::checkMagExistsInXtream($_POST['customfields'][$_POST['packageid']][$returndata['custom_field_eng']], $_POST['packageid']);
                if (isset($macexists) && !empty($macexists)) {
                    echo '<script>window.location.href="index.php?m=nxtdashboard&action=adduser&result=macexists"</script>';
                    exit;
                }
            }

            if (isset($_POST['billingcycle'][$_POST['packageid']]) && !empty($_POST['billingcycle'][$_POST['packageid']])) {
                list($cycle, $currency, $amount) = explode("|", $_POST['billingcycle'][$_POST['packageid']]);
            } else {
                $currencydata = Capsule::table('tblpricing')
                    ->where('relid', '=', $_POST['packageid'])
                    ->where('type', '=', 'product')
                    ->where('monthly', '>', '0')
                    ->get();
                $currency = $currencydata[0]->currency;
                $cycle = '';
                $amount = 0;
            }
            $command = "addclient";
            $admin = Capsule::table('tbladmins')
                ->where('roleid', '=', 1)
                ->get();
            $affdetails = self::CheckAffCredit();
            if (isset($_POST['add_credit']) && !empty($_POST['add_credit'])) {
                $amount += $_POST['add_credit'];
            }
            if ($affdetails->credit < $amount) {
                echo '<script>window.location.href="index.php?m=nxtdashboard&action=xtreamusers&result=ccerror"</script>';
                exit;
            }

            $trial_period = ($productdetils[0]->configoption18 != 0) ? '+' . $productdetils[0]->configoption21 . ' hours' : '+24 hours';
            $billing_months = $productdetils[0]->configoption21;

            $adminuser = $admin[0]->username;
            $userdata = explode(' ', $_POST['clientname']);
            $user['firstname'] = $userdata[0];
            $user['lastname'] = $userdata[1];
            $values["firstname"] = isset($user['firstname']) && !empty($user['firstname']) ? $user['firstname'] : self::NXTgenerateRandomString();
            $values["lastname"] = isset($user['lastname']) && !empty($user['lastname']) ? $user['lastname'] : self::NXTgenerateRandomString();
            $values["companyname"] = isset($_POST['companyname']) ? $_POST['companyname'] : '';
            $values["email"] = isset($_POST['login']) && !empty($_POST['login']) ? $_POST['login'] : $_POST['xtreamusername'] . '@' . $_SERVER['SERVER_NAME'];
            $values["address1"] = isset($_POST['address1']) ? $_POST['address1'] : '';
            $values['address2'] = isset($_POST['address2']) ? $_POST['address2'] : '';
            $values["city"] = isset($_POST['city']) ? $_POST['city'] : '';
            $values["state"] = isset($_POST['state']) ? $_POST['state'] : '';
            $values["postcode"] = isset($_POST['postcode']) ? $_POST['postcode'] : '';
            $values["country"] = "US";
            $values['currency'] = $currency;
            $values["phonenumber"] = isset($_POST['phonenumber']) ? $_POST['phonenumber'] : '';
            $values['customfields'] = base64_encode(serialize(array('Reseller' => $affdetails->firstname . ' ' . $affdetails->lastname . "(" . $affdetails->email . ")")));
            $values["password2"] = isset($_POST['password']) && !empty($_POST['password']) ? $_POST['password'] : $_POST['xtreampassword'];
            $values["notes"] = "Created by " . $affdetails->firstname . ' ' . $affdetails->lastname . "(" . $affdetails->email . ")";
            $values['skipvalidation'] = true;
            $results = localAPI($command, $values, $adminuser);
            if ($results['result'] == 'error') {
                $errormessage = $results['message'];
            } else {
                self::NXT_WHMCSReconnect();
                self::WHMCSdoLogin();
                Capsule::table('mod_xtreamAffs_clients')
                    ->insert(array(
                        'affiliatesid' => self::getWHMCSaffid(),
                        'clientid' => $results['clientid']
                    ));
                //Add Order Variables 
                $vars['client_id'] = $results['clientid'];
                $vars['pid'] = $_POST['packageid'];
                $vars['promocode'] = $_POST['promocode'];
                $vars['billingcycle'] = $cycle;
                if (isset($_POST['ProductAddons']) && !empty($_POST['ProductAddons'])) {
                    $totalAddonIDs = count($_POST['ProductAddons']);
                    $customCounter = 1;
                    foreach ($_POST['ProductAddons'] as $addonIds) {
                        $comma = "";
                        if ($customCounter < $totalAddonIDs) {
                            $comma = ",";
                        }
                        $AddonIds .= $addonIds . $comma;
                        ++$customCounter;
                    }
                    $vars['addonsIds'] = $AddonIds;
                }
                //Setting for config option
                $GetPostPackageId = $_POST['packageid'];
                $productdetials = Capsule::table('tblproducts')
                    ->where('id', '=', $GetPostPackageId)
                    ->get();
                $maxconnection = $productdetials[0]->configoption4;
                $is_restreamer = ($productdetials[0]->configoption7 == 'Yes') ? '1' : '0';
                $is_isplock = ($productdetials[0]->configoption6 == 'Yes') ? '1' : '0';
                $is_trial = ($productdetials[0]->configoption5 == 'Yes') ? '1' : '0';
                if (isset($_POST['ConfigOptionIdNis'][$GetPostPackageId]) && isset($_POST['billingCycleNis'][$GetPostPackageId])) {
                    $ConfigIDsArray = $_POST['ConfigOptionIdNis'][$GetPostPackageId];
                    $billingcycleDataArray = $_POST['billingCycleNis'][$GetPostPackageId];

                    $combinedArray = array_combine($ConfigIDsArray, $billingcycleDataArray);
                    $FinalConfigArrayForAddorder = array();
                    foreach ($combinedArray as $Ckey => $Cvalue) {
                        if ($Cvalue != "") {
                            $ConfigFieldValue = $_POST['configOption_' . $Ckey][$GetPostPackageId][$Ckey][$Cvalue];
                            if ($ConfigFieldValue != "") {
                                $FinalConfigArrayForAddorder[$Ckey] = $ConfigFieldValue;
                            }
                        }
                    }
                    if (!empty($FinalConfigArrayForAddorder)) {
                        $vars["configoptions"] = base64_encode(serialize($FinalConfigArrayForAddorder));
                    }
                }
                //$vars["configoptions"] = base64_encode(serialize(array(1=>4,3=>2,)));
                $data = self::AddOrderWHMCS($vars);
                $serviceid = $data['serviceids'];
                self::WHMCSdoLogin();
                if (isset($data) && $data['result'] == 'success') {
                    $_POST['serviceid'] = $data['productids'];
                    $_POST['orderid'] = $data['orderid'];

                    //update custom field 
                    $customfields = $_POST['customfields'][$_POST['packageid']];
                    foreach ($customfields as $customfieldkey => $customfieldvalue) {
                        $fieldId = mysql_fetch_assoc(mysql_query("SELECT tblcustomfields.id FROM `tblcustomfields` WHERE fieldname='$customfieldkey' AND type='product'   AND relid='" . $_POST['packageid'] . "'"));
                        if (0 != mysql_num_rows(mysql_query("SELECT * FROM`tblcustomfieldsvalues` WHERE `relid`='" . $_POST['serviceid'] . "' AND fieldid=(SELECT tblcustomfields.id FROM `tblcustomfields` WHERE fieldname='$customfieldkey' AND type='product' AND relid='" . $_POST['packageid'] . "')"))) {
                            mysql_query("UPDATE `tblcustomfieldsvalues` SET value='$customfieldvalue' WHERE `relid`='" . $_POST['serviceid'] . "' AND fieldid=(SELECT tblcustomfields.id FROM `tblcustomfields` WHERE fieldname='$customfieldkey' AND type='product'   AND relid='" . $_POST['packageid'] . "')");
                        } else {
                            mysql_query("INSERT INTO `tblcustomfieldsvalues` (`fieldid`, `relid`, `value`) VALUES ('" . $fieldId['id'] . "', '" . $_POST['serviceid'] . "' , '$customfieldvalue')") or die(mysql_error());
                        }
                    }

                    if (isset($_POST[$returndata['configoption_field_name']][$_POST["packageid"]][$cycle])) {
                        $qty = $_POST[$returndata['configoption_field_name']][$_POST["packageid"]][$cycle];
                        $configid = Capsule::table('tblproductconfigoptions')->where('optionname', '=', $returndata['configoption_field_name'])->value('id');
                        Capsule::table('tblhostingconfigoptions')->where('relid', '=', $_POST['serviceid'])->where('configid', '=', $configid)->update(
                            ['qty' => $qty]
                        );
                    }
                    if (isset($data['invoiceid']) && !empty($data['invoiceid'])) {

                        if ($data['result'] == 'success') {
                            $invoiceTotal = Capsule::table('tblinvoices')->where('id', '=', $data['invoiceid'])->select('tblinvoices.total')->get();
                            $add_credit = $invoiceTotal[0]->total;
                            if (isset($_POST['add_credit']) && !empty($_POST['add_credit'])) {
                                $add_credit += $_POST['add_credit'];
                            }
                            self::WHMCSdoLogin();
                            $AddCredit = 'AddCredit';
                            $postData = array(
                                'clientid' => $results['clientid'],
                                'description' => 'Added funds by ' . $affdetails->firstname . ' ' . $affdetails->lastname,
                                'amount' => $add_credit,
                            );
                            $resultsCredit = localAPI($AddCredit, $postData, $adminuser);
                            if ($resultsCredit['result'] == 'success') {
                                Capsule::table('tblcredit')->insert(
                                    ['clientid' => $_SESSION['uid'], 'date' => date('Y-m-d'), 'description' => 'Add Credit to Client - ' . $results['clientid'], 'amount' => -$add_credit]
                                );
                                $removeCredit = $affdetails->credit - $add_credit;
                                self::RemoveWHMCSCredit($removeCredit);
                                /**
                                 * Remove Credits in X.C
                                 */
                                $con = self::XtreamDashboard_testconnection();
                                self::RemoveXtreamCredit($add_credit, $con);
                                $admin = Capsule::table('tbladmins')
                                    ->where('roleid', '=', 1)
                                    ->get();
                                $adminUsername = $admin[0]->username;
                                # Inserting Now New User into 
                                $tblhostingdetails = Capsule::table('tblhosting')->where('id', '=', $serviceid)->get();
                                $nextduedate = $tblhostingdetails[0]->nextduedate;
                                $regdate = $tblhostingdetails[0]->regdate;
                                $clientid = $_SESSION['xtreamuserid'];
                                $member_id = $productdetials[0]->configoption9;
                                $firstname = $values['firstname'];
                                $lastname = $values['lastname'];
                                $Bouquets = $productdetials[0]->configoption10;
                                $syn_expiry = $productdetials[0]->configoption17;
                                $expdate = 'NULL';
                                if ($is_trial == 1 && $nextduedate != '0000-00-00') {
                                    $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
                                } else {
                                    if ($syn_expiry == 'on' && $nextduedate != '0000-00-00') {
                                        $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
                                    } elseif ($is_trial == 1) {
                                        $expdate = strtotime(date("Y-m-d H:i:s", strtotime($trial_period)));
                                    } elseif ($is_trial == 0 && $nextduedate == '0000-00-00' && $billing_months != "" && $billing_months != 0) {
                                        $effectiveDate = date('Y-m-d H:i:s', strtotime("+" . $billing_months . " months", strtotime(date('Y-m-d H:i:s'))));
                                        $expdate = strtotime($effectiveDate);
                                    }
                                }
                                self::WHMCSdoLogin();
                                $command = 'ApplyCredit';
                                $postData = array(
                                    'invoiceid' => $data['invoiceid'],
                                    'amount' => $invoiceTotal[0]->total,
                                );
                                $results = localAPI($command, $postData, $adminUsername);
                                self::WHMCSdoLogin();
                                if ($results['result'] == 'success') {
                                    //{$iptv_client_name} , {$iptv_client_service}, {$iptv_client_email}, {$iptv_client_password}, {$iptv_client_password}{$iptv_service_username} {$iptv_service_password},
                                    $command = 'SendEmail';
                                    $hostingdetials = Capsule::table('tblhosting')
                                        ->where('id', '=', $_POST['serviceid'])
                                        ->select('packageid', 'username', 'password')
                                        ->get();
                                    $productdetials = Capsule::table('tblproducts')
                                        ->where('id', '=', $hostingdetials[0]->packageid)
                                        ->select('name')
                                        ->get();

                                    $postData = array(
                                        'messagename' => 'IPTV Client Details',
                                        'id' => $_SESSION['uid'],
                                        'customvars' => array(
                                            'iptv_client_name' => $_POST['clientname'],
                                            'iptv_client_email' => $values["email"],
                                            'iptv_client_password' => $values["password2"],
                                            'iptv_client_service' => $productdetials[0]->name,
                                            'iptv_service_username' => $hostingdetials[0]->username,
                                            'iptv_service_password' => decrypt($hostingdetials[0]->password),
                                        ),
                                    );
                                    $SendEmail = localAPI($command, $postData, $adminUsername);
                                    self::WHMCSdoLogin();
                                    $CreateSsoTokenpostData = array(
                                        'client_id' => $_SESSION['uid'],
                                        'destination' => 'sso:custom_redirect',
                                        'sso_redirect_path' => "index.php?m=nxtdashboard&action=xtreamusers&result=success",
                                    );
                                    $response = localAPI('CreateSsoToken', $CreateSsoTokenpostData);
                                    if ($response['result'] == 'success') {
                                        $redirect_url = $response['redirect_url'];
                                        echo '<script>window.location.href="' . $redirect_url . '"</script>';
                                        exit;
                                    }
                                } else {
                                    $CreateSsoToken = 'CreateSsoToken';
                                    $CreateSsoTokenpostData = array(
                                        'client_id' => $_SESSION['uid'],
                                        'destination' => 'sso:custom_redirect',
                                        'sso_redirect_path' => "index.php?m=nxtdashboard&action=xtreamusers&result={$results['message']}",
                                    );

                                    $CreateSsoTokenresults = localAPI($CreateSsoToken, $CreateSsoTokenpostData);
                                    if ($CreateSsoTokenresults['result'] == 'success') {
                                        $url = $CreateSsoTokenresults['redirect_url'];
                                        echo '<script>window.location.href="' . $url . '"</script>';
                                        exit;
                                    }
                                    exit;
                                }
                                logModuleCall('Xtream Dashboard', 'ApplyCredit', $postData, $results, '', '');
                                self::WHMCSdoLogin();
                            }
                        } else {
                            $CreateSsoToken = 'CreateSsoToken';
                            $CreateSsoTokenpostData = array(
                                'client_id' => $_SESSION['uid'],
                                'destination' => 'sso:custom_redirect',
                                'sso_redirect_path' => "index.php?m=nxtdashboard&action=xtreamusers&result={$data['message']}",
                            );

                            $CreateSsoTokenresults = localAPI($CreateSsoToken, $CreateSsoTokenpostData);
                            if ($CreateSsoTokenresults['result'] == 'success') {
                                $url = $CreateSsoTokenresults['redirect_url'];
                                echo '<script>window.location.href="' . $url . '"</script>';
                                exit;
                            }
                            exit;
                        }
                    } else {
                        if (isset($_POST['add_credit']) && !empty($_POST['add_credit'])) {
                            $add_credit = $_POST['add_credit'];
                        }
                        self::WHMCSdoLogin();
                        $AddCredit = 'AddCredit';
                        $postData = array(
                            'clientid' => $results['clientid'],
                            'description' => 'Added funds by ' . $affdetails->firstname . ' ' . $affdetails->lastname,
                            'amount' => $add_credit,
                        );
                        $resultsCredit = localAPI($AddCredit, $postData, $adminuser);
                        if ($resultsCredit['result'] == 'success') {
                            Capsule::table('tblcredit')->insert(
                                ['clientid' => $_SESSION['uid'], 'date' => date('Y-m-d'), 'description' => 'Add Credit to Client - ' . $results['clientid'], 'amount' => -$add_credit]
                            );
                            $removeCredit = $affdetails->credit - $add_credit;
                            self::RemoveWHMCSCredit($removeCredit);
                            /**
                             * Remove Credits in X.C
                             */
                            $con = self::XtreamDashboard_testconnection();
                            self::RemoveXtreamCredit($add_credit, $con);
                        }
                        $return = self::AddClientInXtreamm($_POST, 'users');
                        self::WHMCSdoLogin();
                        $CHeckOrderStatus = Capsule::table('tblorders')
                            ->where('id', '=', $_POST['orderid'])
                            ->get();
                        if ($CHeckOrderStatus[0]->status != "Active") {
                            $command = 'AcceptOrder';
                            $postData = array(
                                'orderid' => $_POST['orderid'],
                                'serverid' => $_POST['serviceid'],
                                'autosetup' => '1'
                            );
                            $admin = Capsule::table('tbladmins')
                                ->where('roleid', '=', 1)
                                ->get();
                            $adminUsername = $admin[0]->username;

                            localAPI($command, $postData, $adminUsername);
                            self::WHMCSdoLogin();
                        }
                        /* logModuleCall('Xtream Dashboard', 'AcceptOrder', $postData, $results, '', ''); */
                        if ($results['result'] == 'success') {
                            //{$iptv_client_name} , {$iptv_client_service}, {$iptv_client_email}, {$iptv_client_password}, {$iptv_client_password}{$iptv_service_username} {$iptv_service_password},
                            $command = 'SendEmail';
                            $hostingdetials = Capsule::table('tblhosting')
                                ->where('id', '=', $_POST['serviceid'])
                                ->select('packageid', 'username', 'password')
                                ->get();
                            $productdetials = Capsule::table('tblproducts')
                                ->where('id', '=', $hostingdetials[0]->packageid)
                                ->select('name')
                                ->get();

                            $postData = array(
                                'messagename' => 'IPTV Client Details',
                                'id' => $_SESSION['uid'],
                                'customvars' => array(
                                    'iptv_client_name' => $_POST['clientname'],
                                    'iptv_client_email' => $values["email"],
                                    'iptv_client_password' => $values["password2"],
                                    'iptv_client_service' => $productdetials[0]->name,
                                    'iptv_service_username' => $hostingdetials[0]->username,
                                    'iptv_service_password' => decrypt($hostingdetials[0]->password),
                                ),
                            );
                            $results = localAPI($command, $postData, $adminUsername);
                            $CreateSsoToken = 'CreateSsoToken';
                            $CreateSsoTokenpostData = array(
                                'client_id' => $_SESSION['uid'],
                                'destination' => 'sso:custom_redirect',
                                'sso_redirect_path' => "index.php?m=nxtdashboard&action=xtreamusers&result=success",
                            );

                            $CreateSsoTokenresults = localAPI($CreateSsoToken, $CreateSsoTokenpostData);
                            if ($CreateSsoTokenresults['result'] == 'success') {
                                $url = $CreateSsoTokenresults['redirect_url'];
                                echo '<script>window.location.href="' . $url . '"</script>';
                                exit;
                            }
                            exit;
                        } else {
                            $CreateSsoToken = 'CreateSsoToken';
                            $CreateSsoTokenpostData = array(
                                'client_id' => $_SESSION['uid'],
                                'destination' => 'sso:custom_redirect',
                                'sso_redirect_path' => "index.php?m=nxtdashboard&action=xtreamusers&result=Unable to Create Client",
                            );

                            $CreateSsoTokenresults = localAPI($CreateSsoToken, $CreateSsoTokenpostData);
                            if ($CreateSsoTokenresults['result'] == 'success') {
                                $url = $CreateSsoTokenresults['redirect_url'];
                                echo '<script>window.location.href="' . $url . '"</script>';
                                exit;
                            }
                            exit;
                        }
                    }
                } else {
                    $CreateSsoToken = 'CreateSsoToken';
                    $CreateSsoTokenpostData = array(
                        'client_id' => $_SESSION['uid'],
                        'destination' => 'sso:custom_redirect',
                        'sso_redirect_path' => "index.php?m=nxtdashboard&action=xtreamusers&result={$results['message']}",
                    );

                    $CreateSsoTokenresults = localAPI($CreateSsoToken, $CreateSsoTokenpostData);
                    if ($CreateSsoTokenresults['result'] == 'success') {
                        $url = $CreateSsoTokenresults['redirect_url'];
                        echo '<script>window.location.href="' . $url . '"</script>';
                        exit;
                    }
                    exit;
                }
            }
        }
        $clientdata = Capsule::table('tblclients')->where('id', '=', $_SESSION['uid'])->get();
        $clientgrop = Capsule::table('tblclientgroups')->where('id', '=', $clientdata[0]->groupid)->get();
        if ($clientgrop[0]->groupname == 'Reseller') {
            $product_id_count = Capsule::table('mod_xtreamreseller')->where('client_id', '=', $_SESSION['uid'])->count();
            $product_id = isset($product_id_count) && empty($product_id_count) ? Capsule::table('mod_xtreamresellergrp')->where('client_id', '=', $clientdata[0]->groupid)->get() : Capsule::table('mod_xtreamreseller')->where('client_id', '=', $_SESSION['uid'])->get();
            $products = Capsule::table('tblproducts')
                ->select(Capsule::raw('*'))
                ->where('servertype', '=', 'NXT')
                ->orWhere('servertype', '=', 'ownervpncombination')
                ->whereIn('id', explode(',', $product_id[0]->product_id))
                ->get();
        } elseif ($clientgrop[0]->groupname == 'Super-Reseller') {
            $product_id_count = Capsule::table('mod_xtreamsuper_reseller')->where('client_id', '=', $_SESSION['uid'])->count();
            $product_id = isset($product_id_count) && empty($product_id_count) ? Capsule::table('mod_xtreamresellergrpuser')->where('client_id', '=', $clientdata[0]->groupid)->get() : Capsule::table('mod_xtreamsuper_reseller')->where('client_id', '=', $_SESSION['uid'])->get();
            $products = Capsule::table('tblproducts')
                ->select(Capsule::raw('*'))
                ->where('servertype', '=', 'NXT')
                ->orWhere('servertype', '=', 'ownervpncombination')
                ->whereIn('id', explode(',', $product_id[0]->product_id))
                ->get();
        }
        $currencydata = Capsule::table('tblclients')->where('id', '=', $_SESSION['uid'])->select('currency')
            ->get();
        $currency = $currencydata[0]->currency;
        $currencydetails = Capsule::table('tblcurrencies')->where('id', '=', $currency)->get();
        $CurrencyId = $currencydetails[0]->id;
        //Get Product Customfields
        foreach ($products as $product) {
            $addonpackagearray[$product->id] = self::getProductAddon($product->id, $CurrencyId);
            $customfields[$product->id] = self::getProductCustomFields($product->id);
            $billingcycle[$product->id] = self::getProductBillingCycle($product->id, $currency);
            $configuralOption[$product->id] = self::getProductConfigOption($product->id, $currency);
        }
        $config = Capsule::table('mod_xtreamsetting')->get();
        foreach ($config as $value) {
            $row[$value->setting] = $value->value;
        }
        $userinfo = 'no';
        if (isset($row['login']) || isset($row['password']) || isset($row['confirmpassword']) || isset($row['clientname']) || isset($row['companyname']) || isset($row['address1']) || isset($row['address2']) || isset($row['city']) || isset($row['state']) || isset($row['postcode']) || isset($row['phonenumber'])) {
            $userinfo = 'yes';
        }
        $xtreamConfig = Capsule::table('mod_xtreamConfig')
            ->get();
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        $response = array(
            'modulelink' => $modulelink,
            'optionactive' => $row,
            'customfields' => $customfields,
            'products' => $products,
            'billingcycle' => $billingcycle,
            'addonpackagearray' => $addonpackagearray,
            'configuralOption' => $configuralOption,
            'errormessage' => $errormessage,
            'currency' => $currencydetails[0],
            'successmessage' => $successmessage,
            'maccustomfieldname' => $returndata['custom_field_mag'],
            'e2customfieldname' => $returndata['custom_field_eng'],
            'topup' => $returndata['gid'],
            'userinfo' => $userinfo,
        );
        if (isset($_GET['result']) && $_GET['result'] == 'pkerror') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> Please Choose Plan!";
        } elseif (isset($_GET['result']) && $_GET['result'] == 'bcerror') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> Please select billing cycle!";
        } elseif (isset($_GET['result']) && $_GET['result'] == 'macerror') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> MAG Address Required!";
        } elseif (isset($_GET['result']) && $_GET['result'] == 'macexists') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> MAG Address Already Exists!";
        } elseif (isset($_GET['result']) && $_GET['result'] == 'engerror') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> " . $returndata['custom_field_eng'] . " Required!";
        } elseif (isset($_GET['result']) && $y_GET['result'] == 'macvalid') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> MAG Address is not Valid!";
        } elseif (isset($_GET['result']) && $_GET['result'] == 'ucerror') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> Username already exists!";
        }

        /* echo "<pre>";$billingcycle);die(); */
        $response['selectuser'] = 'User';
        $response['addactive'] = 'class="active"';
        return array(
            'pagetitle' => 'Add New User',
            'breadcrumb' => array(
                'index.php?m=nxtdashboard' => 'Dashboard',
                'index.php?m=nxtdashboard&action=adduser' => 'Add New User'
            ),
            'templatefile' => 'xtreamadduser',
            'requirelogin' => true, # accepts true/false
            'forcessl' => false, # accepts true/false
            'vars' => $response
        );
    }

    public function getProductAddon($pid = "", $CurrencyId = "")
    {
        $ReturnDataArray = array();
        $ReturnDataArray = Capsule::table('tbladdons')
            ->join('tblpricing', 'tbladdons.id', '=', 'tblpricing.relid')
            ->whereRaw("find_in_set('" . $pid . "',tbladdons.packages)")
            ->where("tblpricing.currency", '=', $CurrencyId)
            ->where("tblpricing.type", '=', 'addon')
            ->select(
                'tbladdons.id as addonpackageid',
                'tbladdons.name as addonpackagename',
                'tbladdons.billingcycle as addonpackagebillingcycle',
                'tblpricing.monthly as addonpackagemonthly',
                'tblpricing.quarterly as addonpackagequarterly',
                'tblpricing.semiannually as addonpackagesemiannually',
                'tblpricing.annually as addonpackageannually',
                'tblpricing.biennially as addonpackagebiennially',
                'tblpricing.triennially as addonpackagetriennially',
                'tblpricing.msetupfee as addonpackagemsetupfee',
                'tblpricing.qsetupfee as addonpackageqsetupfee',
                'tblpricing.ssetupfee as addonpackagessetupfee',
                'tblpricing.asetupfee as addonpackageasetupfee',
                'tblpricing.bsetupfee as addonpackagebsetupfee',
                'tblpricing.tsetupfee as addonpackagetsetupfee'
            )
            ->get();
        return $ReturnDataArray;
    }

    public function getProductConfigOption($pid = "", $currency = "")
    {

        $ReturnDataArray = array();
        $productdata = Capsule::table('tblproductconfiglinks')
            ->join('tblproductconfigoptions', 'tblproductconfiglinks.gid', '=', 'tblproductconfigoptions.gid')
            ->join('tblproductconfigoptionssub', 'tblproductconfigoptions.id', '=', 'tblproductconfigoptionssub.configid')
            ->join('tblpricing', 'tblproductconfigoptionssub.id', '=', 'tblpricing.relid')
            ->select(
                'tblproductconfigoptions.*',
                'tblpricing.monthly as monthly',
                'tblpricing.quarterly as quarterly',
                'tblpricing.semiannually as semiannually',
                'tblpricing.annually as annually',
                'tblpricing.biennially as biennially',
                'tblpricing.triennially as triennially'
            )
            ->where('tblproductconfiglinks.pid', '=', $pid)
            ->where('tblpricing.type', '=', 'configoptions')
            ->where('tblpricing.currency', '=', $currency)
            ->get();
        $productdata = json_decode(json_encode($productdata), TRUE);
        $ReturnDataArray = array();
        if (!empty($productdata)) {
            $NewArrayForDervision = array();
            $NewArrayForDervision2 = array();
            foreach ($productdata as $key => $val) {
                $NewArrayForDervision2['id'] = $val['id'];
                $NewArrayForDervision2['gid'] = $val['gid'];
                $NewArrayForDervision2['optionname'] = $val['optionname'];
                $NewArrayForDervision2['optiontype'] = $val['optiontype'];
                $NewArrayForDervision2['qtyminimum'] = $val['qtyminimum'];
                $NewArrayForDervision2['qtymaximum'] = $val['qtymaximum'];
                $NewArrayForDervision2['order'] = $val['order'];
                $NewArrayForDervision2['hidden'] = $val['hidden'];
                $NewArrayForDervision2['pricetype'] = array(
                    'monthly' => $val['monthly'],
                    'quarterly' => $val['quarterly'],
                    'semiannually' => $val['semiannually'],
                    'annually' => $val['annually'],
                    'biennially' => $val['biennially'],
                    'triennially' => $val['triennially'],
                );
                $NewArrayForDervision[] = $NewArrayForDervision2;
            }
        }
        $ReturnDataArray = $NewArrayForDervision;

        return $ReturnDataArray;
    }

    public function checkMagExistsInXtream($newmac, $product_id)
    {
        $servers = Capsule::table('tblproducts')
            ->join('tblservergroupsrel', 'tblproducts.servergroup', '=', 'tblservergroupsrel.groupid')
            ->join('tblservers', 'tblservergroupsrel.serverid', '=', 'tblservers.id')
            ->where('tblproducts.id', '=', $product_id)
            ->select('tblservers.*')
            ->get();
        foreach ($servers as $server) {
            $sqlusername = $server->username;
            $sqlpassword = decrypt($server->password);
            $sqldbname = $server->accesshash;
            $sqlhost = $server->ipaddress;
            list($sqldbname, $sqlport) = explode(':', $sqldbname);
            if (isset($sqlport) && !empty($sqlport))
                $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname, $sqlport);
            else
                $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname);

            // Check connection 
            if (mysqli_connect_errno()) {
                return "Failed to connect to MySQL: " . mysqli_connect_error();
            }

            // First checking if user already exist with reqeuest username  
            $resultmag_devices = mysqli_query($con, "SELECT * FROM mag_devices WHERE mac = '" . base64_encode($newmac) . "'");
            if (!$resultmag_devices) {
                $radiussqlerror = mysqli_error($con);
                self::NXT_WHMCSReconnect();
                return "XtreamDashboard Database Query Error: " . $radiussqlerror;
            }
            if (mysqli_num_rows($resultmag_devices) > 0) {
                return 'macexists';
            }
            $result_devices = mysqli_query($con, "SELECT * FROM enigma2_devices WHERE mac = '" . $newmac . "'");
            if (mysqli_num_rows($result_devices) != 0) {
                return 'macexists';
            }
        }
    }

    public function checkUserExistsInXtream($username, $product_id)
    {
        $servers = Capsule::table('tblproducts')
            ->join('tblservergroupsrel', 'tblproducts.servergroup', '=', 'tblservergroupsrel.groupid')
            ->join('tblservers', 'tblservergroupsrel.serverid', '=', 'tblservers.id')
            ->where('tblproducts.id', '=', $product_id)
            ->select('tblservers.*')
            ->get();
        foreach ($servers as $server) {
            $sqlusername = $server->username;
            $sqlpassword = decrypt($server->password);
            $sqldbname = $server->accesshash;
            $sqlhost = $server->ipaddress;
            list($sqldbname, $sqlport) = explode(':', $sqldbname);

            if (isset($sqlport) && !empty($sqlport))
                $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname, $sqlport);
            else
                $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname);

            // Check connection 
            if (mysqli_connect_errno()) {
                return "Failed to connect to MySQL: " . mysqli_connect_error();
            }

            // First checking if user already exist with reqeuest username  
            $result = mysqli_query($con, "SELECT id FROM users WHERE username='$username'");
            if (!$result) {
                $radiussqlerror = mysqli_error($con);
                self::NXT_WHMCSReconnect();
                return "XtreamDashboard Database Query Error: " . $radiussqlerror;
            }
            if (mysqli_num_rows($result) > 0) {
                return 'userexists';
            }
        }
    }

    public function addreseller($vars)
    {
        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
        $errormessage = false;
        $successmessage = false;
        if (isset($_POST['add_client'])) {
            if (isset($_POST['login']) && !empty($_POST['login'])) {
                $clientdetails = Capsule::table('tblclients')
                    ->where('email', '=', $_POST['login'])
                    ->count();
                if (isset($clientdetails) && !empty($clientdetails)) {
                    echo '<script>window.location.href="index.php?m=nxtdashboard&action=resellers&result=emerror"</script>';
                    exit;
                }
            }
            if (empty($_POST['packageid'])) {
                echo '<script>window.location.href="index.php?m=nxtdashboard&action=adduser&result=pkerror"</script>';
                exit;
            } elseif (isset($_POST['billingcycle'][$_POST['packageid']]) && empty($_POST['billingcycle'][$_POST['packageid']])) {
                echo '<script>window.location.href="index.php?m=nxtdashboard&action=adduser&result=bcerror"</script>';
                exit;
            }
            if (isset($_POST['billingcycle'][$_POST['packageid']]) && !empty($_POST['billingcycle'][$_POST['packageid']])) {
                list($cycle, $currency, $amount) = explode("|", $_POST['billingcycle'][$_POST['packageid']]);
            } else {
                $currencydata = Capsule::table('tblpricing')
                    ->where('relid', '=', $_POST['packageid'])
                    ->where('type', '=', 'product')
                    ->where('monthly', '>', '0')
                    ->get();
                $currency = $currencydata[0]->currency;
                $cycle = '';
                $amount = 0;
            }
            $command = "addclient";
            $admin = Capsule::table('tbladmins')
                ->where('roleid', '=', 1)
                ->get();
            $affdetails = self::CheckAffCredit();
            if (isset($_POST['add_credit']) && !empty($_POST['add_credit'])) {
                $amount += $_POST['add_credit'];
            }

            if ($affdetails->credit < $amount) {
            }
            $adminuser = $admin[0]->username;
            $userdata = explode(' ', $_POST['clientname']);
            $user['firstname'] = $userdata[0];
            $user['lastname'] = $userdata[1];
            $values["firstname"] = isset($user['firstname']) && !empty($user['firstname']) ? $user['firstname'] : self::NXTgenerateRandomString();
            $values["lastname"] = isset($user['lastname']) && !empty($user['lastname']) ? $user['lastname'] : self::NXTgenerateRandomString();
            $values["companyname"] = isset($_POST['companyname']) ? $_POST['companyname'] : '';
            $values["email"] = isset($_POST['login']) && !empty($_POST['login']) ? $_POST['login'] : $_POST['xtreamusername'] . '@' . $_SERVER['SERVER_NAME'];
            $values["address1"] = isset($_POST['address1']) ? $_POST['address1'] : '';
            $values['address2'] = isset($_POST['address2']) ? $_POST['address2'] : '';
            $values["city"] = isset($_POST['city']) ? $_POST['city'] : '';
            $values["state"] = isset($_POST['state']) ? $_POST['state'] : '';
            $values["postcode"] = isset($_POST['postcode']) ? $_POST['postcode'] : '';
            $values["country"] = "US";
            $values['currency'] = $currency;
            $values["phonenumber"] = isset($_POST['phonenumber']) ? $_POST['phonenumber'] : '';
            $values["password2"] = isset($_POST['password']) && !empty($_POST['password']) ? $_POST['password'] : self::NXT_StrongPassword();
            $values['customfields'] = base64_encode(serialize(array('Reseller' => $affdetails->firstname . ' ' . $affdetails->lastname . "(" . $affdetails->email . ")")));
            $values["notes"] = "Created by " . $affdetails->firstname . ' ' . $affdetails->lastname . "(" . $affdetails->email . ")";
            $values['skipvalidation'] = true;
            $results = localAPI($command, $values, $adminuser);
            if ($results['result'] == 'error') {
                $errormessage = $results['message'];
            } else {
                self::NXT_WHMCSReconnect();
                self::WHMCSdoLogin();
                Capsule::table('mod_xtreamAffs_clients')
                    ->insert(array(
                        'affiliatesid' => self::getWHMCSaffid(),
                        'clientid' => $results['clientid']
                    ));
                //Add Order Variables 
                $vars['client_id'] = $results['clientid'];
                $vars['pid'] = $_POST['packageid'];
                $vars['promocode'] = $_POST['promocode'];
                $vars['billingcycle'] = $cycle;

                $data = self::AddOrderWHMCS($vars);
                self::WHMCSdoLogin();
                if (isset($data) && $data['result'] == 'success') {
                    $_POST['serviceid'] = $data['productids'];
                    $_POST['orderid'] = $data['orderid'];
                    if (isset($data['invoiceid']) && !empty($data['invoiceid'])) {
                        if ($data['result'] == 'success') {
                            $invoiceTotal = Capsule::table('tblinvoices')->where('id', '=', $data['invoiceid'])->select('tblinvoices.total')->get();
                            $add_credit = $invoiceTotal[0]->total;
                            if (isset($_POST['add_credit']) && !empty($_POST['add_credit'])) {
                                $add_credit += $_POST['add_credit'];
                            }
                            self::WHMCSdoLogin();
                            $AddCredit = 'AddCredit';
                            $postData = array(
                                'clientid' => $results['clientid'],
                                'description' => 'Added funds by ' . $affdetails->firstname . ' ' . $affdetails->lastname,
                                'amount' => $add_credit,
                            );
                            $resultsCredit = localAPI($AddCredit, $postData, $adminuser);
                            if ($resultsCredit['result'] == 'success') {
                                Capsule::table('tblcredit')->insert(
                                    ['clientid' => $_SESSION['uid'], 'date' => date('Y-m-d'), 'description' => 'Add Credit to Client - ' . $results['clientid'], 'amount' => -$add_credit]
                                );
                                $removeCredit = $affdetails->credit - $add_credit;
                                self::RemoveWHMCSCredit($removeCredit);
                                /**
                                 * Remove Credits in X.C
                                 */
                                $con = self::XtreamDashboard_testconnection();
                                self::RemoveXtreamCredit($add_credit, $con);

                                $admin = Capsule::table('tbladmins')
                                    ->where('roleid', '=', 1)
                                    ->get();
                                $adminUsername = $admin[0]->username;
                                $return = self::AddClientInXtreamm($_POST, 'reseller');
                                self::WHMCSdoLogin();
                                $command = 'ApplyCredit';
                                $postData = array(
                                    'invoiceid' => $data['invoiceid'],
                                    'amount' => $invoiceTotal[0]->total,
                                );
                                $results = localAPI($command, $postData, $adminUsername);
                                if ($results['result'] == 'success') {
                                    $CreateSsoToken = 'CreateSsoToken';
                                    $CreateSsoTokenpostData = array(
                                        'client_id' => $_SESSION['uid'],
                                        'destination' => 'sso:custom_redirect',
                                        'sso_redirect_path' => "index.php?m=nxtdashboard&action=resellers&result=success",
                                    );
                                    $CreateSsoTokenresults = localAPI($CreateSsoToken, $CreateSsoTokenpostData);
                                    if ($CreateSsoTokenresults['result'] == 'success') {
                                        $url = $CreateSsoTokenresults['redirect_url'];
                                        echo '<script>window.location.href="' . $url . '"</script>';
                                        exit;
                                    }
                                    exit;
                                } else {
                                    $CreateSsoToken = 'CreateSsoToken';
                                    $CreateSsoTokenpostData = array(
                                        'client_id' => $_SESSION['uid'],
                                        'destination' => 'sso:custom_redirect',
                                        'sso_redirect_path' => "index.php?m=nxtdashboard&action=resellers&result={$results['message']}",
                                    );
                                    $CreateSsoTokenresults = localAPI($CreateSsoToken, $CreateSsoTokenpostData);
                                    if ($CreateSsoTokenresults['result'] == 'success') {
                                        $url = $CreateSsoTokenresults['redirect_url'];
                                        echo '<script>window.location.href="' . $url . '"</script>';
                                        exit;
                                    }
                                    exit;
                                }
                                logModuleCall('Xtream Dashboard', 'ApplyCredit', $postData, $results, '', '');
                                self::WHMCSdoLogin();
                            }
                        } else {
                            $CreateSsoToken = 'CreateSsoToken';
                            $CreateSsoTokenpostData = array(
                                'client_id' => $_SESSION['uid'],
                                'destination' => 'sso:custom_redirect',
                                'sso_redirect_path' => "index.php?m=nxtdashboard&action=resellers&result={$data['message']}",
                            );
                            $CreateSsoTokenresults = localAPI($CreateSsoToken, $CreateSsoTokenpostData);
                            if ($CreateSsoTokenresults['result'] == 'success') {
                                $url = $CreateSsoTokenresults['redirect_url'];
                                echo '<script>window.location.href="' . $url . '"</script>';
                                exit;
                            }
                            exit;
                        }
                    } else {
                        if (isset($_POST['add_credit']) && !empty($_POST['add_credit'])) {
                            $add_credit = $_POST['add_credit'];
                        }
                        self::WHMCSdoLogin();
                        $AddCredit = 'AddCredit';
                        $postData = array(
                            'clientid' => $results['clientid'],
                            'description' => 'Added funds by ' . $affdetails->firstname . ' ' . $affdetails->lastname,
                            'amount' => $add_credit,
                        );
                        $resultsCredit = localAPI($AddCredit, $postData, $adminuser);
                        if ($resultsCredit['result'] == 'success') {
                            Capsule::table('tblcredit')->insert(
                                ['clientid' => $_SESSION['uid'], 'date' => date('Y-m-d'), 'description' => 'Add Credit to Client - ' . $results['clientid'], 'amount' => -$add_credit]
                            );
                            $removeCredit = $affdetails->credit - $add_credit;
                            self::RemoveWHMCSCredit($removeCredit);
                        }
                        $return = self::AddClientInXtreamm($_POST, 'reseller');
                        self::WHMCSdoLogin();
                        $CHeckOrderStatus = Capsule::table('tblorders')
                            ->where('id', '=', $_POST['orderid'])
                            ->get();
                        if ($CHeckOrderStatus[0]->status != "Active") {
                            $command = 'AcceptOrder';
                            $postData = array(
                                'orderid' => $_POST['orderid'],
                                'serverid' => $_POST['serviceid']
                            );
                            $admin = Capsule::table('tbladmins')
                                ->where('roleid', '=', 1)
                                ->get();
                            $adminUsername = $admin[0]->username;
                            $results = localAPI($command, $postData, $adminUsername);
                            if ($results['result'] == 'success') {
                                echo '<script>window.location.href="index.php?m=nxtdashboard&action=resellers&result=success"</script>';
                                exit;
                            } else {
                                echo '<script>window.location.href="index.php?m=nxtdashboard&action=resellers&result=Unable to Create Client"</script>';
                                exit;
                            }
                        } else {
                            echo '<script>window.location.href="index.php?m=nxtdashboard&action=resellers&result=success"</script>';
                            exit;
                        }
                    }
                } else {
                    echo '<script>window.location.href="index.php?m=nxtdashboard&action=resellers&result=' . $data['message'] . '"</script>';
                    exit;
                }
            }
        }
        $clientdata = Capsule::table('tblclients')->where('id', '=', $_SESSION['uid'])->get();
        $product_id = Capsule::table('mod_xtreamresellergrp')->where('client_id', '=', $clientdata[0]->groupid)->get();
        $products = Capsule::table('tblproducts')
            ->select(Capsule::raw('*'))
            ->where('servertype', '=', 'NXT')
            ->orWhere('servertype', '=', 'ownervpncombination')
            ->whereIn('configoption2', ['reselleraccount', 'superreselleraccount'])
            ->whereIn('id', explode(',', $product_id[0]->product_id))
            ->get();
        $currencydata = Capsule::table('tblclients')->where('id', '=', $_SESSION['uid'])->select('currency')
            ->get();
        $currency = $currencydata[0]->currency;
        $currencydetails = Capsule::table('tblcurrencies')->where('id', '=', $currency)->get();
        //Get Product Customfields
        foreach ($products as $product) {
            $customfields[$product->id] = self::getProductCustomFields($product->id);
            $billingcycle[$product->id] = self::getProductBillingCycle($product->id, $currency);
        }
        $config = Capsule::table('mod_xtreamresellersetting')->get();
        foreach ($config as $value) {
            $row[$value->setting] = $value->value;
        }
        $userinfo = 'no';
        if (isset($row['login']) || isset($row['password']) || isset($row['confirmpassword']) || isset($row['clientname']) || isset($row['companyname']) || isset($row['address1']) || isset($row['address2']) || isset($row['city']) || isset($row['state']) || isset($row['postcode']) || isset($row['phonenumber'])) {
            $userinfo = 'yes';
        }
        return array(
            'pagetitle' => 'Add New Reseller',
            'breadcrumb' => array(
                'index.php?m=nxtdashboard' => 'Dashboard',
                'index.php?m=nxtdashboard&action=adduser' => 'Add New Reseller'
            ),
            'templatefile' => 'xtreamadduser',
            'requirelogin' => true, # accepts true/false
            'forcessl' => false, # accepts true/false
            'vars' => array(
                'modulelink' => $modulelink,
                'optionactive' => $row,
                'customfields' => $customfields,
                'products' => $products,
                'selectuser' => 'Reseller',
                'userinfo' => $userinfo,
                'billingcycle' => $billingcycle,
                'currency' => $currencydetails[0],
                'errormessage' => $errormessage,
                'successmessage' => $successmessage
            ),
        );
    }

    public function resellers($vars)
    {
        $clientdata = Capsule::table('tblclients')->where('id', '=', $_SESSION['uid'])->get();
        // Get common module parameters
        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
        /*
         * Reseller Clients
         */
        $xtreamConfig = Capsule::table('mod_xtreamConfig')
            ->where('setting', 'gid')
            ->get();
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }

        $con = self::XtreamDashboard_testconnection();
        if (isset($_POST['addcredits']) && !empty($_POST['addcredits'])) {
            self::XtreamAddCrdits($_POST['credits'], $_POST['client_id'], $con, 'resellers');
        }
        if (isset($_POST['removeclient'])) {
            $affdetails = self::CheckAffCredit();
            $admin = Capsule::table('tbladmins')
                ->where('roleid', '=', 1)
                ->get();
            $adminUsername = $admin[0]->username;
            $Orders = 'GetClientsProducts';
            $Ordersdata = array(
                'clientid' => $_POST['client_id'],
                'stats' => true,
            );
            $orderdetials = localAPI($Orders, $Ordersdata, $adminUsername);
            if ($orderdetials['result'] == 'success') {
                if (isset($orderdetials['products']['product']) && !empty($orderdetials['products']['product'])) {
                    foreach ($orderdetials['products']['product'] as $orderid) {
                        $ModuleTerminate = 'ModuleTerminate';
                        $ModuleTerminateData = array(
                            'accountid' => $orderid['id'],
                        );
                        localAPI($ModuleTerminate, $ModuleTerminateData, $adminUsername);
                        $PendingOrder = 'PendingOrder';
                        $CancelOrderData = array(
                            'orderid' => $orderid['orderid'],
                        );
                        localAPI($PendingOrder, $CancelOrderData, $adminUsername);
                        $CancelOrder = 'CancelOrder';
                        localAPI($CancelOrder, $CancelOrderData, $adminUsername);
                    }
                }
            }
            $command = 'DeleteClient';
            $postData = array(
                'clientid' => $_POST['client_id'],
            );
            $results = localAPI($command, $postData, $adminUsername);
            if (isset($results['result']) && !empty($results['result'])) {
                if ($results['result'] == 'success') {
                    $response['result'] = "success";
                    $response['message'] = "<strong>Success!</strong> User Deleted Successfully User Id : " . $results['clientid'] . " !";
                    logModuleCall('NXT', 'Remove User', 'This  User Id : ' . $results['clientid'] . ' has been deleted by reseller' . $affdetails->firstname . ' ' . $affdetails->lastname . "(" . $affdetails->email . ")", $results, '', '');
                } else {
                    $response['result'] = "danger";
                    $response['message'] = "<strong>Error!</strong> Unable to Remove User";
                    logModuleCall('NXT', 'Remove User', $postData, $results, '', '');
                }
            }
        }
        $email = $clientdata[0]->email;
        # Inserting Now New User into 
        // First checking if user already exist with reqeuest username  
        $result = mysqli_query($con, "SELECT id FROM members WHERE email='$email'");
        if (!$result) {
            $radiussqlerror = mysqli_error($con);
            self::NXT_WHMCSReconnect();
            logModuleCall('NXT', 'Check Reseller Exists', 'Email Address : ' . $email, "NXT Database Query Error: " . $radiussqlerror, '', '');
            return true;
        }
        if (mysqli_num_rows($result) > 0) {
            self::NXT_WHMCSReconnect();
            self::WHMCSdoLogin();
            $affclients = Capsule::table('mod_xtreamAffs_clients')
                ->where('affiliatesid', self::getWHMCSaffid())
                ->get();
            foreach ($affclients as $clientdetails) {
                $resellerdata = self::WHMCSClientResellerDetails($clientdetails->clientid);
                if (isset($resellerdata) && !empty($resellerdata)) {
                    $clients_detail[] = $resellerdata;
                }
            }
        }
        $affdetails = self::CheckAffCredit();
        self::NXT_WHMCSReconnect();
        $response = array(
            'modulelink' => $modulelink,
            'userdetails' => json_decode(json_encode($clients_detail), true),
            'superresellercredits' => $affdetails->credit,
            'showaddcreditfield' => 'on',
        );
        if (isset($_GET['result']) && $_GET['result'] == 'emerror') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> Email Address already exists!";
        } elseif (isset($_GET['result']) && $_GET['result'] == 'ccerror') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> You don't have sufficient credit's balance! <a href='cart.php?gid=" . $returndata['gid'] . "'> Click here </a> to Add Credits";
        } elseif (isset($_GET['result']) && $_GET['result'] == 'success') {
            $response['result'] = "success";
            $response['message'] = "<strong>Success!</strong> User Created Successfully!";
        } elseif (isset($_GET['result']) && $_GET['result'] == 'macerror') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> MAG Address Required!";
        } elseif (isset($_GET['result']) && $_GET['result'] == 'macexists') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> MAG Address Already Exists!";
        } elseif (isset($_GET['result']) && $_GET['result'] == 'unablefetch') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> Unable to Adding Credits to User";
        } elseif (isset($_GET['result']) && $_GET['result'] == 'ccsuccess') {
            $response['result'] = "success";
            $response['message'] = "<strong>Success!</strong> Credits Added successfully!";
        }
        global $CONFIG;
        if (empty($CONFIG['SystemSSLURL']))
            $whmcsurl = $CONFIG['SystemURL'];
        else
            $whmcsurl = $CONFIG['SystemSSLURL'];
        $response['whmcsurl'] = $whmcsurl;
        return array(
            'pagetitle' => 'Resellers',
            'breadcrumb' => array(
                'index.php?m = nxtdashboard' => 'nxtdashboard',
                'index.php?m = nxtdashboard&action=xtreamusers' => 'Users list',
            ),
            'templatefile' => 'xtreamusers',
            'requirelogin' => true, // Set true to restrict access to authenticated client users
            'forcessl' => false, // Deprecated as of Version 7.0. Requests will always use SSL if available.
            'vars' => $response,
        );
    }

    public function getWHMCSaffid()
    {
        $command = 'getaffiliates';
        $adminuser = Capsule::table('tbladmins')
            ->where('roleid', '=', 1)
            ->get();
        $values['userid'] = $_SESSION['uid'];
        $affdetails = localAPI($command, $values, $adminuser[0]->username);
        if ($affdetails['result'] === 'success' && $affdetails['totalresults'] == 1) {
            $affdetaildata = $affdetails['affiliates']['affiliate'][0];
        }
        if (isset($affdetaildata['id']) && !empty($affdetaildata['id'])) {
            return $affdetaildata['id'];
        } else {
            return 'notfoundaffiliate';
        }
    }

    public function CheckAffCredit()
    {
        $credit = Capsule::table('tblclients')
            ->select('credit', 'firstname', 'lastname', 'email')
            ->where('id', '=', $_SESSION['uid'])
            ->get();
        return $credit[0];
    }

    public function AddClientInXtreamm($params, $action)
    {
        $customfields = $params['customfields'][$params['packageid']];
        foreach ($customfields as $customfieldkey => $customfieldvalue) {
            $fieldId = mysql_fetch_assoc(mysql_query("SELECT tblcustomfields.id FROM `tblcustomfields` WHERE fieldname='$customfieldkey' AND type='product'   AND relid='" . $params['packageid'] . "'"));
            if (0 != mysql_num_rows(mysql_query("SELECT * FROM`tblcustomfieldsvalues` WHERE `relid`='" . $params['serviceid'] . "' AND fieldid=(SELECT tblcustomfields.id FROM `tblcustomfields` WHERE fieldname='$customfieldkey' AND type='product' AND relid='" . $params['packageid'] . "')"))) {
                mysql_query("UPDATE `tblcustomfieldsvalues` SET value='$customfieldvalue' WHERE `relid`='" . $params['serviceid'] . "' AND fieldid=(SELECT tblcustomfields.id FROM `tblcustomfields` WHERE fieldname='$customfieldkey' AND type='product'   AND relid='" . $params['packageid'] . "')");
            } else {
                mysql_query("INSERT INTO `tblcustomfieldsvalues` (`fieldid`, `relid`, `value`) VALUES ('" . $fieldId['id'] . "', '" . $params['serviceid'] . "' , '$customfieldvalue')") or die(mysql_error());
            }
        }
        /*
         * Update User name and Password of the server order
         */
        if ($action == 'users') {
            $admin = Capsule::table('tbladmins')
                ->where('roleid', '=', 1)
                ->get();
            $adminuser = $admin[0]->username;
            $encryptpassword = "encryptpassword";
            $values["password2"] = $params['xtreampassword'];
            $results = localAPI($encryptpassword, $values, $adminuser);
            mysql_query("UPDATE `tblhosting` SET  password='" . $results['password'] . "',username='" . $params['xtreamusername'] . "'  WHERE id=" . $params['serviceid']);
            return $results;
        }
    }

    public function WHMCSdoLogin()
    {
        $_SESSION['uid'] = $_SESSION['xtreamuserid'];
        $_SESSION['upw'] = $_SESSION['xtreampasswordhash'];
    }

    public function NXT_WHMCSReconnect()
    {
        require(ROOTDIR . "/configuration.php");
        $whmcsmysql = mysqli_connect($db_host, $db_username, $db_password, $db_name);
    }

    public function WHMCSClientDetails($clientid)
    {
        $clients = Capsule::table('tblclients')
            ->select(Capsule::raw('*'))
            ->where('id', '=', $clientid)
            ->where('groupid', '=', 0)
            ->select('firstname', 'lastname', 'companyname', 'email', 'id as client_id')
            ->get();
        $customfields = Capsule::table('tblcustomfields')
            ->join('tblcustomfieldsvalues', 'tblcustomfields.id', '=', 'tblcustomfieldsvalues.fieldid')
            ->select('tblcustomfields.fieldname', 'tblcustomfieldsvalues.*')
            ->where('tblcustomfields.type', '=', "client")
            ->where('tblcustomfieldsvalues.relid', '=', $clientid)
            ->where('tblcustomfields.fieldname', '=', 'logincode')
            ->get();
        if (isset($clients[0]) && !empty($clients[0])) {
            if (isset($customfields) && !empty($customfields)) {
                foreach ($customfields as $customfield) {
                    if ($customfield->fieldname == 'logincode') {
                        $clients[0] = array_merge((array) $clients[0], array('logincode' => $customfield->value));
                    }
                }
                !empty($clients[0]) ? $clients_data = (array) $clients[0] : '';
            } else {
                !empty($clients[0]) ? $clients_data = (array) $clients[0] : '';
            }
        }
        return $clients_data;
    }

    public function WHMCSClientResellerDetails($clientid)
    {
        self::NXT_WHMCSReconnect();
        $clientgrop = Capsule::table('tblclientgroups')->whereIN('groupname', ['Reseller', 'Super-Reseller'])->get();
        $clients = Capsule::table('tblclients')->where('id', '=', $clientid)->whereIn('groupid', [$clientgrop[0]->id, $clientgrop[1]->id])->select('firstname', 'lastname', 'companyname', 'email', 'id as client_id', 'groupid')->get();
        if (isset($clients[0]) && !empty($clients[0])) {
            $customfields = Capsule::table('tblcustomfields')
                ->join('tblcustomfieldsvalues', 'tblcustomfields.id', '=', 'tblcustomfieldsvalues.fieldid')
                ->select('tblcustomfields.fieldname', 'tblcustomfieldsvalues.*')
                ->where('tblcustomfields.type', '=', "client")
                ->where('tblcustomfieldsvalues.relid', '=', $clientid)
                ->where('tblcustomfields.fieldname', '=', 'logincode')
                ->get();
            if (isset($customfields) && !empty($customfields)) {
                foreach ($customfields as $customfield) {
                    if ($customfield->fieldname == 'logincode') {
                        $clients[0] = array_merge((array) $clients[0], array('logincode' => $customfield->value));
                    }
                }
                !empty($clients[0]) ? $clients_data = (array) $clients[0] : '';
            } else {
                !empty($clients[0]) ? $clients_data = (array) $clients[0] : '';
            }
        }
        return $clients[0];
    }

    public function WHMCSClientServices($clientid)
    {
        self::NXT_WHMCSReconnect();
        $command = 'GetClientsProducts';
        $postData = array(
            'clientid' => $clientid,
            'stats' => true,
        );
        $results = localAPI($command, $postData, self::XtreamDashboard_whmcsadmin());
        if ($results['result'] == "success") {
            $ProductsLists = $results['products']['product'];
            if (!empty($ProductsLists)) {
                foreach ($ProductsLists as $KeyUH => $ProductKey) {
                    if ($ProductKey['serverhostname'] == "") {
                        $Hostname = Capsule::table('tblproducts')
                            ->join('tblservergroupsrel', 'tblproducts.servergroup', '=', 'tblservergroupsrel.groupid')
                            ->join('tblservers', 'tblservergroupsrel.serverid', '=', 'tblservers.id')
                            ->where('tblproducts.id', $ProductKey['pid'])
                            ->select('tblservers.hostname')
                            ->get();
                        if (!empty($Hostname)) {
                            $results['products']['product'][$KeyUH]['serverhostname'] = $Hostname[0]->hostname;
                        }
                    }
                }
            }
        }
        return $results;
    }

    public function XtreamDashboard_whmcsadmin()
    {
        $whmcsadmin = Capsule::table('tbladmins')
            ->where('id', '1')
            ->get();
        return $whmcsadmin[0]->username;
    }

    public function getProductCustomFields($productid)
    {
        $serverdetails = Capsule::table('tblcustomfields')
            ->select('*')
            ->where('relid', '=', $productid)
            ->where('type', '=', 'product')
            ->orderBy('sortorder', 'asc')
            ->get();
        return $serverdetails;
    }

    public function getProductBillingCycle($productid, $currency)
    {
        $productcycleCount = Capsule::table('tblproducts')
            ->join('tblpricing', 'tblproducts.id', '=', 'tblpricing.relid')
            ->where('tblpricing.relid', '=', $productid)
            ->where('tblpricing.type', '=', 'product')
            ->where('tblpricing.currency', '=', $currency)
            ->where('tblproducts.paytype', '!=', 'free')
            ->select('tblpricing.*', 'tblproducts.paytype')
            ->count();
        if (isset($productcycleCount) && !empty($productcycleCount)) {
            $productcycle = Capsule::table('tblproducts')
                ->join('tblpricing', 'tblproducts.id', '=', 'tblpricing.relid')
                ->where('tblpricing.relid', '=', $productid)
                ->where('tblpricing.type', '=', 'product')
                ->where('tblpricing.currency', '=', $currency)
                ->where('tblproducts.paytype', '!=', 'free')
                ->select('tblpricing.*', 'tblproducts.paytype')
                ->get();
            return $productcycle;
        } else {
            return '';
        }
    }

    public function AddOrderWHMCS($vars)
    {

        $command = "addorder";
        $admin = Capsule::table('tbladmins')
            ->where('roleid', '=', 1)
            ->get();
        $adminuser = $admin[0]->username;
        if (isset($vars['addonsIds']) && $vars['addonsIds'] != "") {
            $values["addons"] = $vars['addonsIds'];
        }

        if (isset($vars['configoptions']) && $vars['configoptions'] != "") {
            $values["configoptions"] = $vars['configoptions'];
        }
        $values["clientid"] = $vars['client_id'];
        $values["pid"] = $vars['pid'];
        $values["billingcycle"] = $vars['billingcycle'];
        $values['promocode'] = $vars['promocode'];
        $payment = self::get_client_payment_gateway($_SESSION['uid']);
        $values["paymentmethod"] = $payment;
        $results = localAPI($command, $values, $adminuser);

        $serviceids = $results['serviceids'];
        $packageid = $vars['packageid'];
        if (isset($vars['customfields']) && !empty($vars['customfields'])) {
            foreach ($vars['customfields'] as $key => $val) {
                foreach ($val as $keyy => $value) {
                    $ss_createMainMenu = Capsule::table('tblcustomfields')->where('type', 'product')->where('relid', $packageid)->where('fieldname', $keyy)->get();
                    Capsule::table('tblcustomfieldsvalues')->where('fieldid', $ss_createMainMenu[0]->id)->where('relid', $serviceids)->update(['value' => $value,]);
                }
            }
        }

        return $results;
    }

    public function get_client_payment_gateway($clientid)
    {
        $gateway = Capsule::table('tblpaymentgateways')->distinct('gateway')->where('order', '=', '1')->limit(1)->get();
        $defaultgateway = $gateway[0]->gateway;
        $res = full_query("SELECT `defaultgateway` FROM `tblclients` WHERE `id`='$clientid'");
        if (mysql_num_rows($res) > 0)
            $row = mysql_fetch_assoc($res);
        if (!empty($row['defaultgateway'])) {
            $defaultgateway = $row['defaultgateway'];
        }
        return $defaultgateway;
    }

    public function RemoveWHMCSCredit($credit)
    {
        $updatedUserCount = Capsule::table('tblclients')
            ->where('id', '=', $_SESSION['uid'])
            ->update(
                [
                    'credit' => $credit,
                ]
            );
        return true;
    }

    public function AddXtreamCredit($amount, $resellerid, $con)
    {
        $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        $tblclients = Capsule::table('tblclients')->where('id', $resellerid)->select('email')->get();
        $email = $tblclients[0]->email;
        $result = mysqli_query($con, "SELECT username,credits FROM members WHERE email='" . $tblclients[0]->email . "'");
        if (mysqli_num_rows($result) > 0) {
            if ($returndata['syncredit'] == 'on') {
                $resellerdata = mysqli_fetch_assoc($result);
                $amount = $amount + $resellerdata['credits'];
                $update = mysqli_query($con, "UPDATE members SET credits ='$amount' WHERE email='$email'");
                if (!$update) {
                    $radiussqlerror = mysqli_error($con);
                    self::NXT_WHMCSReconnect();
                    logModuleCall('NXT', 'Error Add Credits', 'Email Address : ' . $email, "NXT Database Query Error: " . $radiussqlerror, '', '');
                    return "NXT Database Query Error: " . $radiussqlerror;
                }
            }
        }
    }

    public function RemoveXtreamCredit($amount, $con)
    {
        $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        $tblclients = Capsule::table('tblclients')->where('id', $_SESSION['uid'])->select('email')->get();
        $email = $tblclients[0]->email;
        $result = mysqli_query($con, "SELECT username,credits FROM members WHERE email='" . $tblclients[0]->email . "'");
        if (!$result) {
            $radiussqlerror = mysqli_error($con);
            self::NXT_WHMCSReconnect();
            logModuleCall('NXT', 'Check Reseller Exists', 'Email Address : ' . $email, "NXT Database Query Error: " . $radiussqlerror, '', '');
            return "NXT Database Query Error: " . $radiussqlerror;
        }
        if (mysqli_num_rows($result) > 0) {
            if ($returndata['syncredit'] == 'on') {
                $resellerdata = mysqli_fetch_assoc($result);
                $remaningamount = $resellerdata['credits'] - $amount;
                $update = mysqli_query($con, "UPDATE members SET credits ='$remaningamount' WHERE email='$email'");
                if (!$update) {
                    $radiussqlerror = mysqli_error($con);
                    self::NXT_WHMCSReconnect();
                    logModuleCall('NXT', 'Error Add Credits', 'Email Address : ' . $email, "NXT Database Query Error: " . $radiussqlerror, '', '');
                    return "NXT Database Query Error: " . $radiussqlerror;
                }
            }
        }
    }

    public function XtreamcheckAffexists($clientid)
    {
        $data = Capsule::table('mod_xtreamAffs_clients')
            ->where('clientid', $clientid)
            ->get();
        $clientemail = Capsule::table('tblclients')
            ->join('tblaffiliates', 'tblaffiliates.clientid', '=', 'tblclients.id')
            ->where('tblaffiliates.id', '=', $data[0]->affiliatesid)
            ->select('tblclients.email')->get();
        if (isset($clientemail) && !empty($clientemail))
            return $clientemail[0]->email;
        else
            return true;
    }

    public function WHMCSResellerServerId($account)
    {
        $serverid = 0;
        $products = Capsule::table('tblproducts')
            ->select(Capsule::raw('*'))
            ->where('servertype', '=', 'NXT')
            ->orWhere('servertype', '=', 'ownervpncombination')
            ->where('configoption2', '=', $account)
            ->get();
        foreach ($products as $productdb) {
            $productids[] = $productdb->id;
        }
        $command = 'GetClientsProducts';
        $postData = array(
            'clientid' => $_SESSION['uid'],
            'stats' => true,
        );
        $admin = Capsule::table('tbladmins')
            ->where('roleid', '=', 1)
            ->get();
        $adminUsername = $admin[0]->username;
        $results = localAPI($command, $postData, $adminUsername);
        foreach ($results['products']['product'] as $product) {
            if (in_array($product['pid'], $productids)) {
                $serverid = $product['serverid'];
            }
        }
        return $serverid;
    }

    public function XtreamDashboard_testconnection()
    {
        /* CreateConnection */
        $clientdata = Capsule::table('tblclients')->where('id', '=', $_SESSION['uid'])->get();
        // Get common module parameters 
        $clientgrop = Capsule::table('tblclientgroups')->where('id', '=', $clientdata[0]->groupid)->get();
        if ($clientgrop[0]->groupname == 'Reseller') {
            $account = 'reselleraccount';
        } elseif ($clientgrop[0]->groupname == 'Super-Reseller') {
            $account = 'superreselleraccount';
        }
        $serverid = self::WHMCSResellerServerId($account);
        $serverdetails = Capsule::table('tblservers')->where('id', '=', $serverid)->get();
        foreach ($serverdetails as $server) {
            $sqlusername = $server->username;
            $sqlpassword = decrypt($server->password);
            $sqldbname = $server->accesshash;
            $sqlhost = $server->ipaddress;
            list($sqldbname, $sqlport) = explode(':', $sqldbname);
            if (isset($sqlport) && !empty($sqlport))
                $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname, $sqlport);
            else
                $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname);
            // Check connection 
            if (mysqli_connect_errno()) {
                logModuleCall('NXT', 'Check Connection', 'Connection', "Failed to connect to MySQL: " . mysqli_connect_error(), '', '');
                return true;
            }
        }
        return $con;
    }

    public function NXTgenerateRandomString($length = 10)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

    public function NXT_StrongPassword($length = 9, $add_dashes = false, $available_sets = 'lud')
    {
        $sets = array();
        if (strpos($available_sets, 'l') !== false)
            $sets[] = 'abcdefghjkmnpqrstuvwxyz';
        if (strpos($available_sets, 'u') !== false)
            $sets[] = 'ABCDEFGHJKMNPQRSTUVWXYZ';
        if (strpos($available_sets, 'd') !== false)
            $sets[] = '23456789';
        $all = '';
        $password = '';
        foreach ($sets as $set) {
            $password .= $set[array_rand(str_split($set))];
            $all .= $set;
        }
        $all = str_split($all);
        for ($i = 0; $i < $length - count($sets); $i++)
            $password .= $all[array_rand($all)];
        $password = str_shuffle($password);
        if (!$add_dashes)
            return $password;
        $dash_len = floor(sqrt($length));
        $dash_str = '';
        while (strlen($password) > $dash_len) {
            $dash_str .= substr($password, 0, $dash_len) . '-';
            $password = substr($password, $dash_len);
        }
        $dash_str .= $password;
        return $dash_str;
    }

    public function XtreamAddCrdits($credits, $userid, $con, $page)
    {
        $xtreamConfig = Capsule::table('mod_xtreamConfig')
            ->get();
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        $affdetails = self::CheckAffCredit();
        if (isset($credits) && !empty($credits)) {
            if ($affdetails->credit < $credits) {
                echo '<script>window.location.href="index.php?m=nxtdashboard&action=resellers&result=ccerror"</script>';
                exit;
            }
            $AddCredit = 'AddCredit';
            $postData = array(
                'clientid' => $userid,
                'description' => 'Added funds by ' . $affdetails->firstname . ' ' . $affdetails->lastname,
                'amount' => $credits,
            );
            $admin = Capsule::table('tbladmins')
                ->where('roleid', '=', 1)
                ->get();
            $adminUsername = $admin[0]->username;
            $resultsCredit = localAPI($AddCredit, $postData, $adminUsername);
            if ($resultsCredit['result'] == 'success') {
                Capsule::table('tblcredit')->insert(
                    ['clientid' => $_SESSION['uid'], 'date' => date('Y-m-d'), 'description' => 'Add Credit to Client - ' . $userid, 'amount' => -$credits]
                );
                $removeCredit = $affdetails->credit - $credits;
                self::RemoveWHMCSCredit($removeCredit);
                self::AddXtreamCredit($credits, $userid, $con);
                self::RemoveXtreamCredit($credits, $con);
                echo '<script>window.location.href="index.php?m=nxtdashboard&action=' . $page . '&result=ccsuccess"</script>';
                exit;
            }
        } else {
            echo '<script>window.location.href="index.php?m=nxtdashboard&action=' . $page . '&result=unablefetch"</script>';
            exit;
        }
        return $response;
    }

    public function WHMCSServiceDetails($username)
    {
        self::NXT_WHMCSReconnect();
        $clientdata = Capsule::table('tblhosting')
            ->join('tblservers', 'tblhosting.server', '=', 'tblservers.id')
            ->join('tblproducts', 'tblhosting.packageid', '=', 'tblproducts.id')
            ->where('tblhosting.username', '=', $username)
            ->select('tblproducts.name', 'tblhosting.nextduedate', 'tblhosting.userid as clientid', 'tblproducts.id as pid', 'tblhosting.orderid', 'tblhosting.id', 'tblhosting.domainstatus as status', 'tblservers.hostname as serverhostname')
            ->get();
        if (isset($clientdata) && !empty($clientdata)) {
            $returndata = json_decode(json_encode($clientdata), true);
            return $returndata[0];
        } else {
            return true;
        }
    }

    public function XtreamServices($selectedclientservices, $resellerdata, $con)
    {
        $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        foreach ($selectedclientservices['products']['product'] as $service) {
            $reseller_notes = $returndata['common_identifier'] . $service['id'];
            $tblproducts = Capsule::table('tblproducts')->where('id', $service['pid'])->select('configoption19', 'configoption20', 'configoption8')->get();
            if (isset($tblproducts) && !empty($tblproducts)) {
                foreach ($tblproducts as $products) {
                    $service = array_merge($service, array('showm3ulink' => $products->configoption8, 'showautoscript' => $products->configoption19, 'showotherdevice' => $products->configoption20));
                }
            }
            $productdetils = Capsule::table('tblproducts')->where('id', '=', $service['pid'])->select('configoption2')->get();
            # Inserting Now New User into 
            // First checking if user already exist with reqeuest username   
            $engcheck = mysqli_query($con, "SELECT * FROM `users` WHERE reseller_notes='$reseller_notes' AND member_id = '" . $resellerdata['id'] . "' AND is_e2='1'");
            $magcheck = mysqli_query($con, "SELECT * FROM `users` WHERE reseller_notes='$reseller_notes' AND member_id = '" . $resellerdata['id'] . "' AND is_mag='1'");
            $users = mysqli_query($con, "SELECT id as xtreamid,username as xtreamusername,password as xtreampassword,is_trial,is_mag,exp_date FROM `users` WHERE member_id = '" . $resellerdata['id'] . "' AND is_mag='0' AND username='" . $service['username'] . "'");
            if (mysqli_num_rows($users) > 0) {
                while ($xtremservice = mysqli_fetch_assoc($users)) {
                    $ENGMAC = '-';
                    $MAGMAC = '-';
                    $mag_devices = mysqli_query($con, "SELECT * FROM `users` WHERE member_id = '" . $resellerdata['id'] . "' AND is_mag='1' AND pair_id = '" . $xtremservice['xtreamid'] . "'");
                    if (mysqli_num_rows($mag_devices) != 0) {
                        $mag_device_userid = mysqli_fetch_assoc($mag_devices);
                        $mag_details = mysqli_query($con, "SELECT * FROM `mag_devices` WHERE user_id='" . $mag_device_userid['id'] . "'");
                        if (mysqli_num_rows($mag_details) != 0) {
                            $macaddress = mysqli_fetch_assoc($mag_details);
                            $MAGMAC = base64_decode($macaddress['mac']);
                        }
                    }
                    $eng_devices = mysqli_query($con, "SELECT * FROM `users` WHERE member_id = '" . $resellerdata['id'] . "' AND is_e2='1' AND pair_id = '" . $xtremservice['xtreamid'] . "'");
                    if (mysqli_num_rows($eng_devices) != 0) {
                        //Engima 
                        $eng_device_userid = mysqli_fetch_assoc($eng_devices);
                        $eng_details = mysqli_query($con, "SELECT * FROM `enigma2_devices` WHERE user_id='" . $eng_device_userid['id'] . "'");
                        if (mysqli_num_rows($eng_details) != 0) {
                            $engaddress = mysqli_fetch_assoc($eng_details);
                            $ENGMAC = $engaddress['mac'];
                        }
                    }
                    $response['configoption'] = '';
                    if ($productdetils[0]->configoption2 == 'streamlineengmag') {
                        $engima = 'both';
                    } elseif ($productdetils[0]->configoption2 == 'streamlineonly') {
                        $response['configoption'] = 'streammag';
                    } else {
                        $engima = ($productdetils[0]->configoption2 == 'streamlineeng') ? 'yes' : 'no';
                    }
                    $xtremservice['watchingchannel'] = '-';
                    $user_activity_now = mysqli_query($con, "SELECT `stream_id` FROM user_activity_now WHERE user_id = '" . $xtremservice['xtreamid'] . "' ORDER BY `activity_id` DESC LIMIT 1");
                    if (mysqli_num_rows($user_activity_now) != 0) {
                        $user_activity = mysqli_fetch_assoc($user_activity_now);
                        $streams = mysqli_query($con, "SELECT stream_display_name,stream_icon FROM `streams` WHERE id='" . $user_activity['stream_id'] . "'");
                        if (mysqli_num_rows($streams) != 0) {
                            $stream_display_name = mysqli_fetch_assoc($streams);
                            $xtremservice['watchingchannel'] = (isset($stream_display_name['stream_icon']) && !empty($stream_display_name['stream_icon'])) ? "<img style='height:30px' src='" . $stream_display_name['stream_icon'] . "'/>" : $stream_display_name['stream_display_name'];
                        }
                    }
                    $xtremservices = array_merge($xtremservice, array('mag_device' => $MAGMAC, 'eng_device' => $ENGMAC, 'engma' => $engima, 'iptvdetails' => 'show'));
                    $servicesdetails[] = array_merge($service, $xtremservices);
                }
            } elseif (mysqli_num_rows($magcheck) != 0) {
                $magdeviceuserid = mysqli_fetch_assoc($magcheck);
                $mag_details = mysqli_query($con, "SELECT * FROM `mag_devices` WHERE user_id='" . $magdeviceuserid['id'] . "'");
                if (mysqli_num_rows($mag_details) != 0) {
                    $macaddress = mysqli_fetch_assoc($mag_details);
                    $MAC = base64_decode($macaddress['mac']);
                } else {
                    $MAC = '-';
                }
                $watchingchannel = '-';
                $user_activity_now = mysqli_query($con, "SELECT `stream_id` FROM user_activity_now WHERE user_id = '" . $magdeviceuserid['id'] . "' ORDER BY `activity_id` DESC LIMIT 1");
                if (mysqli_num_rows($user_activity_now) != 0) {
                    $user_activity = mysqli_fetch_assoc($user_activity_now);
                    $streams = mysqli_query($con, "SELECT stream_display_name,stream_icon FROM `streams` WHERE id='" . $user_activity['stream_id'] . "'");
                    if (mysqli_num_rows($streams) != 0) {
                        $stream_display_name = mysqli_fetch_assoc($streams);
                        $watchingchannel = (isset($stream_display_name['stream_icon']) && !empty($stream_display_name['stream_icon'])) ? "<img style='height:30px' src='" . $stream_display_name['stream_icon'] . "'/>" : $stream_display_name['stream_display_name'];
                    }
                }
                $data = array(
                    'xtreamusername' => '-',
                    'xtreampassword' => '-',
                    'is_trial' => '-',
                    'is_mag' => '-',
                    'engma' => 'no',
                    'watchingchannel' => $watchingchannel,
                    'iptvdetails' => '',
                    'mag_device' => $MAC,
                    'eng_device' => '-'
                );
                $servicesdetails[] = array_merge($service, $data);
            } elseif (mysqli_num_rows($engcheck) != 0) {
                $engdeviceuserid = mysqli_fetch_assoc($engcheck);
                $eng_details = mysqli_query($con, "SELECT * FROM `enigma2_devices` WHERE user_id='" . $engdeviceuserid['id'] . "'");
                if (mysqli_num_rows($eng_details) != 0) {
                    $macaddress = mysqli_fetch_assoc($eng_details);
                    $MAC = $macaddress['mac'];
                } else {
                    $MAC = '-';
                }
                $watchingchannel = '-';
                $user_activity_now = mysqli_query($con, "SELECT `stream_id` FROM user_activity_now WHERE user_id = '" . $engdeviceuserid['id'] . "' ORDER BY `activity_id` DESC LIMIT 1");
                if (mysqli_num_rows($user_activity_now) != 0) {
                    $user_activity = mysqli_fetch_assoc($user_activity_now);
                    $streams = mysqli_query($con, "SELECT stream_display_name,stream_icon FROM `streams` WHERE id='" . $user_activity['stream_id'] . "'");
                    if (mysqli_num_rows($streams) != 0) {
                        $stream_display_name = mysqli_fetch_assoc($streams);
                        $watchingchannel = (isset($stream_display_name['stream_icon']) && !empty($stream_display_name['stream_icon'])) ? "<img style='height:30px' src='" . $stream_display_name['stream_icon'] . "'/>" : $stream_display_name['stream_display_name'];
                    }
                }
                $data = array(
                    'xtreamusername' => '-',
                    'xtreampassword' => '-',
                    'is_trial' => '-',
                    'is_mag' => '-',
                    'watchingchannel' => $watchingchannel,
                    'engma' => 'yes',
                    'iptvdetails' => '',
                    'mag_device' => '-',
                    'eng_device' => $MAC
                );
                $servicesdetails[] = array_merge($service, $data);
            } else {
                $data = array(
                    'xtreamusername' => '-',
                    'xtreampassword' => '-',
                    'is_trial' => '-',
                    'is_mag' => '-',
                    'watchingchannel' => '-',
                    'iptvdetails' => '',
                    'mag_device' => '-',
                    'eng_device' => '-',
                );
                $servicesdetails[] = array_merge($service, $data);
            }
        }

        $result['response'] = $response;
        $result['servicesdetails'] = $servicesdetails;
        return $result;
    }

    public function CheckSelectedClientReseller($clientId)
    {
        $clientdata = Capsule::table('tblclients')->where('id', '=', $clientId)->get();
        $clientgrop = Capsule::table('tblclientgroups')->where('id', '=', $clientdata[0]->groupid)->get();
        return $clientgrop[0]->groupname;
    }

    public function XtreamDashboard_ChangeMAG(array $params, $newmac)
    {
        $servers = Capsule::table('tblproducts')
            ->join('tblservergroupsrel', 'tblproducts.servergroup', '=', 'tblservergroupsrel.groupid')
            ->join('tblservers', 'tblservergroupsrel.serverid', '=', 'tblservers.id')
            ->where('tblproducts.id', '=', $params['pid'])
            ->select('tblservers.*')
            ->get();
        $serviceid = $params["serviceid"];
        // Collecting parameters
        $iptvusername = $params["username"];
        foreach ($servers as $server) {
            $sqlusername = $server->username;
            $sqlpassword = decrypt($server->password);
            $sqldbname = $server->accesshash;
            $sqlhost = $server->ipaddress;
            list($sqldbname, $sqlport) = explode(':', $sqldbname);
            if (isset($sqlport) && !empty($sqlport))
                $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname, $sqlport);
            else
                $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname);

            // Check connection 
            if (mysqli_connect_errno()) {
                return "Failed to connect to MySQL: " . mysqli_connect_error();
            }
            $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
            $returndata = array();
            if (isset($xtreamConfig) && !empty($xtreamConfig)) {
                foreach ($xtreamConfig as $config) {
                    $returndata[$config->setting] = $config->value;
                }
            }
            $reseller_notes = $returndata['common_identifier'] . $serviceid;
            # Inserting Now New User into 
            // First checking if user already exist with reqeuest username  
            $result = mysqli_query($con, "SELECT id FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1'");

            if (!$result) {
                $radiussqlerror = mysqli_error($con);
                self::NXT_WHMCSReconnect();
                return "XtreamDashboard Database Query Error: " . $radiussqlerror;
            }
            if (mysqli_num_rows($result) > 0) {
                $resultmag_devices = mysqli_query($con, "SELECT * FROM mag_devices WHERE mac='" . base64_encode($newmac) . "'");
                if (mysqli_num_rows($resultmag_devices) == 0) {
                    $userid = mysqli_fetch_assoc($result);
                    $updatepair = mysqli_query($con, "UPDATE mag_devices SET  mac='" . base64_encode($newmac) . "' WHERE user_id='" . $userid['id'] . "'");
                    if (!$updatepair) {
                        $radiussqlerror = mysqli_error($con);
                        self::NXT_WHMCSReconnect();
                        return "NXT Database Query Error: " . $radiussqlerror;
                    }
                    self::NXT_WHMCSReconnect();
                    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
                    $returndata = array();
                    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
                        foreach ($xtreamConfig as $config) {
                            $returndata[$config->setting] = $config->value;
                        }
                    }
                    $fieldid = Capsule::table('tblcustomfields')
                        ->where('fieldname', $returndata['custom_field_mag'])
                        ->where('type', 'product')
                        ->where('relid', $params['pid'])
                        ->get();
                    if (isset($fieldid) && !empty($fieldid)) {
                        $checkExists = Capsule::table('tblcustomfieldsvalues')
                            ->where('relid', $params['serviceid'])
                            ->where('fieldid', $fieldid[0]->id)
                            ->get();
                        if (isset($checkExists) && !empty($checkExists)) {
                            Capsule::table('tblcustomfieldsvalues')
                                ->where('relid', $params['serviceid'])
                                ->where('fieldid', $fieldid[0]->id)
                                ->update(['value' => $newmac]);
                        } else {
                            Capsule::table('tblcustomfieldsvalues')->insert(
                                ['fieldid' => $fieldid[0]->id, 'relid' => $params['serviceid'], 'value' => $newmac]
                            );
                        }
                    }
                    $domainMAC = Capsule::table('tblhosting')
                        ->where('id', $params['serviceid'])
                        ->update(['domain' => $newmac]);
                } else {
                    return "MAC Address already exists.";
                }
            }
        }
        return 'success';
    }

    public function XtreamDashboard_AddMAG(array $params, $newmac)
    {
        $servers = Capsule::table('tblproducts')
            ->join('tblservergroupsrel', 'tblproducts.servergroup', '=', 'tblservergroupsrel.groupid')
            ->join('tblservers', 'tblservergroupsrel.serverid', '=', 'tblservers.id')
            ->where('tblproducts.id', '=', $params['pid'])
            ->select('tblservers.*')
            ->get();
        $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        $tblhostingdetails = Capsule::table('tblhosting')->where('id', '=', $params["serviceid"])->get();
        $nextduedate = $tblhostingdetails[0]->nextduedate;
        $regdate = $tblhostingdetails[0]->regdate;
        $serviceid = $params["serviceid"];
        $product = Capsule::table('tblproducts')->where('id', '=', $params["pid"])->get();
        $is_trial = ($product[0]->configoption5 == 'Yes') ? '1' : '0';
        $member_id = $product[0]->configoption9;
        $Bouquets = $product[0]->configoption10;
        $syn_expiry = $product[0]->configoption17;
        $trial_period = ($product[0]->configoption18 != 0) ? '+' . $product[0]->configoption18 . ' hours' : '+24 hours';
        $expdate = 'NULL';
        if ($is_trial == 1 && $nextduedate != '0000-00-00') {
            $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
        } else {
            if ($syn_expiry == 'on' && $nextduedate != '0000-00-00') {
                $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
            } elseif ($is_trial == 1) {
                $expdate = strtotime(date("Y-m-d H:i:s", strtotime($trial_period)));
            }
        }
        // Collecting parameters
        $iptvusername = $params["username"];
        $password = $params["password"];
        foreach ($servers as $server) {
            $sqlusername = $server->username;
            $sqlpassword = decrypt($server->password);
            $sqldbname = $server->accesshash;
            $sqlhost = $server->ipaddress;
            list($sqldbname, $sqlport) = explode(':', $sqldbname);
            if (isset($sqlport) && !empty($sqlport))
                $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname, $sqlport);
            else
                $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname);
            // Check connection 
            if (mysqli_connect_errno()) {
                return "Failed to connect to MySQL: " . mysqli_connect_error();
            }
            $username = $iptvusername . $returndata['common_identifier'] . $serviceid;
            $reseller_notes = $returndata['common_identifier'] . $serviceid;
            # Inserting Now New User into 
            // First checking if user already exist with reqeuest username  
            $result = mysqli_query($con, "SELECT id FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1'");
            if (!$result) {
                $radiussqlerror = mysqli_error($con);
                NXT_WHMCSReconnect();
                return "NXT Database Query Error: " . $radiussqlerror;
            }
            if (mysqli_num_rows($result) > 0) {
                NXT_WHMCSReconnect();
                return "This {$reseller_notes} User is already exists";
            }
            //Check MAG Already Exists
            $resultmag_devices = mysqli_query($con, "SELECT * FROM mag_devices WHERE mac = '" . base64_encode($newmac) . "'");
            if (mysqli_num_rows($resultmag_devices) != 0) {
                return "MAG Address already exists!";
            }
            $userid = array();
            if ($params['configoption2'] == 'magdevice') {
                $userid['id'] = '';
            } else {
                $checkmagdevice = $params['customfields'][$returndata['checkmagdevice']];
                if (isset($checkmagdevice) && !empty($checkmagdevice) && $checkmagdevice == 'on') {
                    $userid['id'] = '';
                } else {
                    $iptvusernameresult = mysqli_query($con, "SELECT id FROM users WHERE username='$iptvusername'");
                    if (mysqli_num_rows($iptvusernameresult) == 0) {
                        NXT_WHMCSReconnect();
                        return "User Not Found!!";
                    } else {
                        $userid = mysqli_fetch_assoc($iptvusernameresult);
                    }
                }
            }
            $clientemail = self::XtreamcheckAffexists($params['userid']);
            if (!empty($clientemail)) {
                $result = mysqli_query($con, "SELECT id FROM members WHERE email='$clientemail'");
                if (!$result) {
                    $radiussqlerror = mysqli_error($con);
                    self::NXT_WHMCSReconnect();
                    logModuleCall('NXT', 'Check Reseller Exists', 'Email Address : ' . $clientemail, "NXT Database Query Error: " . $radiussqlerror, '', '');
                    return "NXT Database Query Error: " . $radiussqlerror;
                }
                if (mysqli_num_rows($result) > 0) {
                    $resellerdata = mysqli_fetch_assoc($result);
                    $member_id = $resellerdata['id'];
                }
            }
            # Inserting Now New User into 
            $query = "INSERT INTO users (member_id , username , password , admin_enabled , enabled , reseller_notes , bouquet , created_at , created_by , pair_id , is_mag,exp_date,is_trial)  
                         VALUES ('$member_id' , '$username' , '$password' , 1 , 1 , '" . $returndata['common_identifier'] . $serviceid . "' , '$Bouquets' , " . strtotime($regdate) . ", 0 , '" . $userid['id'] . "' , 1,$expdate,$is_trial)";
            $result = mysqli_query($con, $query);
            if (!$result) {
                $radiussqlerror = mysqli_error($con);
                self::NXT_WHMCSReconnect();
                return "NXT Database Query Error: " . $radiussqlerror;
            } else {
                $lastinsertid = mysqli_insert_id($con);
                $updatepair = mysqli_query($con, "UPDATE users SET  pair_id='" . $lastinsertid . "' WHERE username='$iptvusername'");
                if (!$updatepair) {
                    $radiussqlerror = mysqli_error($con);
                    self::NXT_WHMCSReconnect();
                    return "NXT Database Query Error: " . $radiussqlerror;
                }
                # Inserting Now New User into 
                //Access Output Setting in X.C
                $accessoutput = mysqli_query($con, "SELECT * FROM `access_output`");
                if (mysqli_num_rows($accessoutput) > 0) {
                    while ($accessoutputdata = mysqli_fetch_assoc($accessoutput)) {
                        mysqli_query($con, "INSERT INTO user_output(user_id, access_output_id) VALUES('" . $lastinsertid . "', '" . $accessoutputdata['access_output_id'] . "')");
                    }
                }
                //Add MAG Device in X.C  
                $mag_devices = "INSERT INTO mag_devices (user_id , bright , contrast , saturation  , video_out , volume , playback_buffer_bytes , playback_buffer_size , audio_out , mac , locale , city_id , hd , main_notify , fav_itv_on , now_playing_start , now_playing_type , now_playing_content , time_last_play_tv , time_last_play_video , hd_content , image_version , last_change_status , last_start , last_active , keep_alive , playback_limit , screensaver_delay , stb_type , sn , last_watchdog , created , country , plasma_saving , ts_enabled , ts_enable_icon , ts_path , ts_max_length , ts_buffer_use , ts_action_on_exit , ts_delay , video_clock , rtsp_type , rtsp_flags , stb_lang , display_menu_after_loading , record_max_length , plasma_saving_timeout , parent_password , spdif_mode , show_after_loading , play_in_preview_by_ok , hdmi_event_reaction ,play_in_preview_only_by_ok) 
                                 VALUES ('" . $lastinsertid . "' , 200 , 127 , 127 , 'rca' , 50 , 0 , 0 , 1 , '" . base64_encode($newmac) . "' , 'en_GB.utf8' , 0 , 1 , 1 , 0 , NULL , 0 , NULL , NULL , NULL , 1 , NULL , NULL , NULL , NULL , NULL , 3 , 10 ,'' , NULL , NULL , '" . strtotime(date('Y-m-d')) . "' , NULL , 0 , 0 , 1 , NULL , 3600 , 'cyclic' , 'no_save' , 'on_pause' , 'Off' , 4 , 0 , 'en' , 1 , 180 , 600 , '" . (!empty($returndata['parentpassword']) ? $returndata['parentpassword'] : 0) . "' , 1 , 'main_menu' , 1 , 1 ,'true')";
                $mag_devicesresult = mysqli_query($con, $mag_devices);
                if (!$mag_devicesresult) {
                    $radiussqlerror = mysqli_error($con);
                    self::NXT_WHMCSReconnect();
                    return "NXT Database Query Error: " . $radiussqlerror;
                }
                self::NXT_WHMCSReconnect();
                $fieldid = Capsule::table('tblcustomfields')
                    ->where('fieldname', $returndata['custom_field_mag'])
                    ->where('type', 'product')
                    ->where('relid', $params['pid'])
                    ->get();
                if (isset($fieldid) && !empty($fieldid)) {
                    $checkExists = Capsule::table('tblcustomfieldsvalues')
                        ->where('relid', $params['serviceid'])
                        ->where('fieldid', $fieldid[0]->id)
                        ->get();
                    if (isset($checkExists) && !empty($checkExists)) {
                        Capsule::table('tblcustomfieldsvalues')
                            ->where('relid', $params['serviceid'])
                            ->where('fieldid', $fieldid[0]->id)
                            ->update(['value' => $newmac]);
                    } else {
                        Capsule::table('tblcustomfieldsvalues')->insert(
                            ['fieldid' => $fieldid[0]->id, 'relid' => $params['serviceid'], 'value' => $newmac]
                        );
                    }
                }
                $domainMAC = Capsule::table('tblhosting')
                    ->where('id', $params['serviceid'])
                    ->update(['domain' => $newmac]);
            }
        }
        return 'success';
    }

    public function XtreamDashboard_AddENG(array $params, $newmac)
    {
        $servers = Capsule::table('tblproducts')
            ->join('tblservergroupsrel', 'tblproducts.servergroup', '=', 'tblservergroupsrel.groupid')
            ->join('tblservers', 'tblservergroupsrel.serverid', '=', 'tblservers.id')
            ->where('tblproducts.id', '=', $params['pid'])
            ->select('tblservers.*')
            ->get();
        $tblhostingdetails = Capsule::table('tblhosting')->where('id', '=', $params["serviceid"])->get();
        $nextduedate = $tblhostingdetails[0]->nextduedate;
        $regdate = $tblhostingdetails[0]->regdate;
        $serviceid = $params["serviceid"];
        $product = Capsule::table('tblproducts')->where('id', '=', $params["pid"])->get();
        $is_trial = ($product[0]->configoption5 == 'Yes') ? '1' : '0';
        $member_id = $product[0]->configoption9;
        $Bouquets = $product[0]->configoption10;
        $syn_expiry = $product[0]->configoption17;
        $trial_period = ($product[0]->configoption18 != 0) ? '+' . $product[0]->configoption18 . ' hours' : '+24 hours';
        // Collecting parameters
        $iptvusername = $params["username"];
        $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        $username = $iptvusername . $returndata['common_identifier'] . $serviceid;
        $password = $params["password"];
        foreach ($servers as $server) {
            $sqlusername = $server->username;
            $sqlpassword = decrypt($server->password);
            $sqldbname = $server->accesshash;
            $sqlhost = $server->ipaddress;
            list($sqldbname, $sqlport) = explode(':', $sqldbname);
            if (isset($sqlport) && !empty($sqlport))
                $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname, $sqlport);
            else
                $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname);
            // Check connection 
            if (mysqli_connect_errno()) {
                return "Failed to connect to MySQL: " . mysqli_connect_error();
            }
            $iptvusernameresult = mysqli_query($con, "SELECT id FROM users WHERE username='$iptvusername'");
            if (mysqli_num_rows($iptvusernameresult) == 0) {
                self::NXT_WHMCSReconnect();
                return "User Not Found!!";
            } else {
                $userid = mysqli_fetch_assoc($iptvusernameresult);
            }
            $clientemail = self::XtreamcheckAffexists($params['userid']);
            if (!empty($clientemail)) {
                $result = mysqli_query($con, "SELECT id FROM members WHERE email='$clientemail'");
                if (!$result) {
                    $radiussqlerror = mysqli_error($con);
                    self::NXT_WHMCSReconnect();
                    logModuleCall('NXT', 'Check Reseller Exists', 'Email Address : ' . $clientemail, "NXT Database Query Error: " . $radiussqlerror, '', '');
                    return "NXT Database Query Error: " . $radiussqlerror;
                }
                if (mysqli_num_rows($result) > 0) {
                    $resellerdata = mysqli_fetch_assoc($result);
                    $member_id = $resellerdata['id'];
                }
            }
            # Inserting Now New User into   
            $expdate = 'NULL';
            if ($is_trial == 1 && $nextduedate != '0000-00-00') {
                $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
            } else {
                if ($syn_expiry == 'on' && $nextduedate != '0000-00-00') {
                    $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
                } elseif ($is_trial == 1) {
                    $expdate = strtotime(date("Y-m-d H:i:s", strtotime($trial_period)));
                }
            }
            # Inserting Now New User into 
            $query = "INSERT INTO users (member_id , username , password , admin_enabled , enabled , reseller_notes , bouquet , created_at , created_by , pair_id , is_e2,exp_date,is_trial)
                         VALUES ('$member_id' , '$username' , '$password' , 1 , 1 , '" . $returndata['common_identifier'] . $serviceid . "' , '$Bouquets' , " . strtotime($regdate) . ", 0 , '" . $userid['id'] . "' ,'1',$expdate,$is_trial)";

            $result = mysqli_query($con, $query);
            if (!$result) {
                $radiussqlerror = mysqli_error($con);
                self::NXT_WHMCSReconnect();
                return "NXT Database Query Error: " . $radiussqlerror;
            } else {
                $checkengdevice = $params['customfields'][$returndata['checkengdevice']];
                if (isset($checkengdevice) && !empty($checkengdevice)) {
                    $lastinsertid = mysqli_insert_id($con);
                } else {
                    $lastinsertid = mysqli_insert_id($con);
                    $updatepair = mysqli_query($con, "UPDATE users SET pair_id = '" . $lastinsertid . "' WHERE username = '$iptvusername'");
                    if (!$updatepair) {
                        $radiussqlerror = mysqli_error($con);
                        self::NXT_WHMCSReconnect();
                        return "NXT Database Query Error: " . $radiussqlerror;
                    }
                }
                //Access Output Setting in X.C
                $accessoutput = mysqli_query($con, "SELECT * FROM `access_output`");
                if (mysqli_num_rows($accessoutput) > 0) {
                    while ($accessoutputdata = mysqli_fetch_assoc($accessoutput)) {
                        mysqli_query($con, "INSERT INTO user_output(user_id, access_output_id) VALUES('" . $lastinsertid . "', '" . $accessoutputdata['access_output_id'] . "')");
                    }
                }
                # Inserting Now New User into 
                $eng_devices = "INSERT INTO enigma2_devices (mac, user_id, telnet_enable, ftp_enable, ssh_enable, rc)
                                VALUES ('$newmac', '" . $lastinsertid . "', '1', '1', '1', '1')";
                $eng_devicesresult = mysqli_query($con, $eng_devices);
                if (!$eng_devicesresult) {
                    $radiussqlerror = mysqli_error($con);
                    self::NXT_WHMCSReconnect();
                    return "NXT Database Query Error: " . $radiussqlerror;
                }
                $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
                $returndata = array();
                if (isset($xtreamConfig) && !empty($xtreamConfig)) {
                    foreach ($xtreamConfig as $config) {
                        $returndata[$config->setting] = $config->value;
                    }
                }
                self::NXT_WHMCSReconnect();
                $fieldid = Capsule::table('tblcustomfields')
                    ->where('fieldname', $returndata['custom_field_eng'])
                    ->where('type', 'product')
                    ->where('relid', $params['packageid'])
                    ->get();
                if (isset($fieldid) && !empty($fieldid)) {
                    $checkExists = Capsule::table('tblcustomfieldsvalues')
                        ->where('relid', $params['serviceid'])
                        ->where('fieldid', $fieldid[0]->id)
                        ->get();
                    if (isset($checkExists) && !empty($checkExists)) {
                        Capsule::table('tblcustomfieldsvalues')
                            ->where('relid', $params['serviceid'])
                            ->where('fieldid', $fieldid[0]->id)
                            ->update(['value' => $newmac]);
                    } else {
                        Capsule::table('tblcustomfieldsvalues')->insert(
                            ['fieldid' => $fieldid[0]->id, 'relid' => $params['serviceid'], 'value' => $newmac]
                        );
                    }
                }
                $domainMAC = Capsule::table('tblhosting')
                    ->where('id', $params['serviceid'])
                    ->update(['domain' => $newmac]);
            }
        }
        return 'success';
    }

    public function XtreamDashboard_ChangeENG(array $params, $newmac)
    {
        $servers = Capsule::table('tblproducts')
            ->join('tblservergroupsrel', 'tblproducts.servergroup', '=', 'tblservergroupsrel.groupid')
            ->join('tblservers', 'tblservergroupsrel.serverid', '=', 'tblservers.id')
            ->where('tblproducts.id', '=', $params['pid'])
            ->select('tblservers.*')
            ->get();
        $serviceid = $params["serviceid"];
        // Collecting parameters
        $iptvusername = $params["username"];
        foreach ($servers as $server) {
            $sqlusername = $server->username;
            $sqlpassword = decrypt($server->password);
            $sqldbname = $server->accesshash;
            $sqlhost = $server->ipaddress;
            list($sqldbname, $sqlport) = explode(':', $sqldbname);
            if (isset($sqlport) && !empty($sqlport))
                $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname, $sqlport);
            else
                $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname);

            // Check connection 
            if (mysqli_connect_errno()) {
                return "Failed to connect to MySQL: " . mysqli_connect_error();
            }
            $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
            $returndata = array();
            if (isset($xtreamConfig) && !empty($xtreamConfig)) {
                foreach ($xtreamConfig as $config) {
                    $returndata[$config->setting] = $config->value;
                }
            }
            $reseller_notes = $returndata['common_identifier'] . $serviceid;
            # Inserting Now New User into 
            // First checking if user already exist with reqeuest username  
            $result = mysqli_query($con, "SELECT id FROM users WHERE reseller_notes='$reseller_notes'  AND is_e2 = '1'");

            if (!$result) {
                $radiussqlerror = mysqli_error($con);
                self::NXT_WHMCSReconnect();
                return "XtreamDashboard Database Query Error: " . $radiussqlerror;
            }
            if (mysqli_num_rows($result) > 0) {
                $resultmag_devices = mysqli_query($con, "SELECT * FROM enigma2_devices WHERE mac = '" . $newmac . "'");
                if (mysqli_num_rows($resultmag_devices) == 0) {
                    $userid = mysqli_fetch_assoc($result);
                    $updatepair = mysqli_query($con, "UPDATE enigma2_devices SET mac = '" . $newmac . "' WHERE user_id = '" . $userid['id'] . "'");
                    if (!$updatepair) {
                        $radiussqlerror = mysqli_error($con);
                        self::NXT_WHMCSReconnect();
                        return "NXT Database Query Error: " . $radiussqlerror;
                    }
                    self::NXT_WHMCSReconnect();
                    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
                    $returndata = array();
                    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
                        foreach ($xtreamConfig as $config) {
                            $returndata[$config->setting] = $config->value;
                        }
                    }
                    $fieldid = Capsule::table('tblcustomfields')
                        ->where('fieldname', $returndata['custom_field_eng'])
                        ->where('type', 'product')
                        ->where('relid', $params['packageid'])
                        ->get();
                    if (isset($fieldid) && !empty($fieldid)) {
                        $checkExists = Capsule::table('tblcustomfieldsvalues')
                            ->where('relid', $params['serviceid'])
                            ->where('fieldid', $fieldid[0]->id)
                            ->get();
                        if (isset($checkExists) && !empty($checkExists)) {
                            Capsule::table('tblcustomfieldsvalues')
                                ->where('relid', $params['serviceid'])
                                ->where('fieldid', $fieldid[0]->id)
                                ->update(['value' => $newmac]);
                        } else {
                            Capsule::table('tblcustomfieldsvalues')->insert(
                                ['fieldid' => $fieldid[0]->id, 'relid' => $params['serviceid'], 'value' => $newmac]
                            );
                        }
                    }
                    $domainMAC = Capsule::table('tblhosting')
                        ->where('id', $params['serviceid'])
                        ->update(['domain' => $newmac]);
                } else {
                    return "MAC Address already exists.";
                }
            }
        }
        return 'success';
    }
}
