<?php 

use WHMCS\Database\Capsule;

include_once('' . ROOTDIR . '/includes/modulefunctions.php');
include_once('' . ROOTDIR . '/modules/servers/vpnservernoapi/functions.php');


/**
 * Xtream Code Client Area Controller
 */
class VPNController {


    public function index($vars) {
        if(!isset($_SESSION['uid']) || empty($_SESSION['uid']))
        {
            header('location: /login.php');
        }
        $creditsDetails = self::CheckAffCredit();
       $totalCredits = $creditsDetails->credit;
       
               
        
        
        $checkaffidexists = self::getWHMCSaffid();
        if ($checkaffidexists == 'notfoundaffiliate') {
            return array(
                'pagetitle' => 'Reseller Panel',
                'breadcrumb' => array(
                    'index.php?m=vpnpanel' => 'Reseller Panel',
                ),
                'templatefile' => 'xtreamerror',
                'requirelogin' => true, // Set true to restrict access to authenticated client users
                'forcessl' => false, // Deprecated as of Version 7.0. Requests will always use SSL if available.
                'vars' => array(
                    'errormessage' => "This Reseller doesn't exists in Panel - Something Went Wrong Please contact Adminstrator!"
                ),
            );
        }
        
        $clientdata = Capsule::table('tblclients')->where('id', '=', $_SESSION['uid'])->get();
        if (isset($clientdata[0]->groupid) && !empty($clientdata[0]->groupid)) {
            $clientgrop = Capsule::table('tblclientgroups')->where('id', '=', $clientdata[0]->groupid)->get();
            if ($clientgrop[0]->groupname == 'Reseller' || $clientgrop[0]->groupname == 'Super-Reseller') {
                /*
                 * Reseller Clients
                 */
                
                $email = $clientdata[0]->email;
 
                $modulelink = $vars['modulelink'];

                $TotalUserCount = array(); 
                  
                    $affclients = Capsule::table('tblaffiliatesaccounts')
                            ->where('affiliateid', self::getWHMCSaffid())
                            ->get();
                    foreach ($affclients as $clientdetails) {
                        $clientdetail = self::WHMCSClientDetails($clientdetails->relid);
                        if (isset($clientdetail) && !empty($clientdetail)) {
                            $TotalUserCount[$clientdetails->relid] = $clientdetails->relid;
                        }
                        $resellerdata2 = self::WHMCSClientResellerDetails($clientdetails->relid);
                        if (isset($resellerdata2) && !empty($resellerdata2)) {
                            $ResellerUsers[$clientdetails->relid] = $clientdetails->relid;
                        }
                    }
                

                $TrialServices = $AllFreeServices = Capsule::table('tblhosting')
                        ->join('tblproducts', 'tblhosting.packageid', '=', 'tblproducts.id')
                        ->whereIn('tblhosting.userid', $TotalUserCount)
                        ->where('tblhosting.billingcycle', 'Free Account')
                        ->select('tblproducts.*', 'tblhosting.id as hostingid')
                        ->count();
                $totalusers = count($TotalUserCount);
                $trialusers = $TrialServices;
                $totalreseller = count($ResellerUsers);  

                if ($clientgrop[0]->groupname == 'Reseller') {
                    return array(
                        'pagetitle' => 'Reseller Panel',
                        'breadcrumb' => array(
                            'index.php?m=vpnpanel' => 'Reseller Panel',
                        ),
                        'templatefile' => 'resellerpanel',
                        'requirelogin' => true, // Set true to restrict access to authenticated client users
                        'forcessl' => false, // Deprecated as of Version 7.0. Requests will always use SSL if available.
                        'vars' => array(
                            'modulelink' => $vars['modulelink'],
                            'totalusers' => $totalusers,
                            'undertrial' => $trialusers,
                            'dashboardactive' => 'class="active"',
                            'topup' => '12',
                            'totalcredit' => $totalCredits,
                        ),
                    );
                } elseif ($clientgrop[0]->groupname == 'Super-Reseller') {
                    return array(
                        'pagetitle' => 'Super Reseller Panel',
                        'breadcrumb' => array(
                            'index.php?m=vpnpanel' => 'Super Reseller Panel',
                        ),
                        'templatefile' => 'supresellerpanel',
                        'requirelogin' => true, // Set true to restrict access to authenticated client users
                        'forcessl' => false, // Deprecated as of Version 7.0. Requests will always use SSL if available.
                        'vars' => array(
                            'modulelink' => $vars['modulelink'],
                            'totalusers' => $totalusers,
                            'undertrial' => $trialusers,
                            'dashboardactive' => 'class="active"',
                            'reseller' => $totalreseller,
                            'topup' => '12',
                            'totalcredit' => $totalCredits
                        ),
                    );
                }
            }
        }
    }

    //Show all services of users ..
    public function vpnusersServices($vars) {
$message = '';
$result = '';
        if(isset($_POST['createservice']))
        {
            $command = 'ModuleCreate';
            $postData = array(
                'accountid' => $_POST['serviceID'],
            );
            

            $results = localAPI($command, $postData);
            if($results['result'] == 'success')
            {
                $result = 'success';
                $message = 'Success! Service Created Successfully';
            }
            else
            {
                $result = 'danger';
                $message = 'Success! Service Created Successfully';
                $message = $results['message'];
            }
        }
        if(isset($_POST['terminateservice']))
        {
            $command = 'ModuleTerminate';
            $postData = array(
                'accountid' => $_POST['serviceID'],
            );
            

            $results = localAPI($command, $postData);
            if($results['result'] == 'success')
            {
                $result = 'success';
                $message = 'Success! Service Terminated Successfully';
            }
            else
            {
                $result = 'danger';
                $message = $results['message'];
            }
        }
        if(isset($_POST['suspendservice']))
        {
            $command = 'ModuleSuspend';
            $postData = array(
                'accountid' => $_POST['serviceID'],
                'suspendreason' => '',
            );
            

            $results = localAPI($command, $postData);
            if($results['result'] == 'success')
            {
                $result = 'success';
                $message = 'Success! Service Suspended Successfully';
            }
            else
            {
                $result = 'danger';
                $message = $results['message'];
            }
        }
        if(isset($_POST['unsuspendservice']))
        {
            $command = 'ModuleUnsuspend';
            $postData = array(
                'accountid' => $_POST['serviceID'],
            );
            

            $results = localAPI($command, $postData);
            if($results['result'] == 'success')
            {
                $result = 'success';
                $message = 'Success! Service Unsuspended Successfully';
            }
            else
            {
                $result = 'danger';
                $message = $results['message'];
            }
        }
        if(isset($_POST['renewservice']))
        {
            $sid = $_POST['serviceID'];
                $results['result'] = renewservice($sid);
            
            if($results['result'] == 'success')
            {
                $result = 'success';
                $message = 'Success! Service Renew Successfully';
            }
            else
            {
                $result = 'danger';
                $message = 'Error Occoured!';
            }
        }

        

         $reseller_detail = Capsule::table('tblclients')->where('id',$_SESSION['uid'])->select('email')->get();
       $resellerEmail = $reseller_detail[0]->email;
        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule 
        if(isset($_REQUEST['userid']) && !empty($_REQUEST['userid']))
        {
        $clients_detail = Capsule::table('tblclients')->where('tblclients.id', $_REQUEST['userid'])
        ->join('tblhosting','tblhosting.userid','=','tblclients.id')
        ->join('tblproducts','tblproducts.id','=','tblhosting.packageid')
        ->select('tblclients.*','tblclients.id as clientid','tblproducts.*','tblhosting.*')
        ->get();
        }
        else
        {
            $clients_detail = Capsule::table('tblclients')->where('tblclients.notes', 'Created by:'.$resellerEmail)
            ->join('tblhosting','tblhosting.userid','=','tblclients.id')
            ->join('tblproducts','tblproducts.id','=','tblhosting.packageid')
            ->select('tblclients.*','tblproducts.*','tblhosting.*')
            ->get();
        }
        $clientsData1 = array();
        //echo '<pre>';print_r($clients_detail); die(23);
        $i = 0;
        foreach($clients_detail as $client1)
        {
           
            $i++;
            $clientsData1[$i]['client_id'] = $client1->clientid;
            $clientsData1[$i]['service_id'] = $client1->id;
            $clientsData1[$i]['firstname'] = $client1->firstname;
            $clientsData1[$i]['lastname'] = $client1->lastname;
            $clientsData1[$i]['email'] = $client1->email;
            $clientsData1[$i]['nextduedate'] = $client1->nextduedate;
            $clientsData1[$i]['rawstatus'] = $client1->domainstatus;
            $clientsData1[$i]['status'] = ($client1->domainstatus == 'Active')?'<span class="label label-success">Active</span>':'<span class="label label-danger">'.$client1->domainstatus.'<span>';
            $clientsData1[$i]['username'] = $client1->username;
            $clientsData1[$i]['password'] = decrypt($client1->password);
            $clientsData1[$i]['name'] = $client1->name;
            
                
        }
        
$creditsDetails = self::CheckAffCredit();
       $totalCredits = $creditsDetails->credit;
        /* echo "<pre>";print_r($servicesdetails);die(); */
        $response['listallservices'] = 'class="active"';
        $response['modulelink'] = $modulelink;
        $response['servicedetails'] = $clientsData1;
        $response['totalcredit'] = $totalCredits;
        $response['message'] = $message;
        /*$response['services'] = $servicesdetails;
        $response['CurrentOpen_User'] = $_GET['userid'];
        $response['checked'] = $checked;
        $response['lang'] = $returndata;
        $response['m3ulinkoutput'] = (isset($outputfirst) && !empty($outputfirst) ? $outputfirst : 'xxx');
        $response['accessoutput'] = $access_outputdata;
        $response['topup'] = $returndata['gid'];
        $response['autoscript'] = $autoscript;*/
        return array(
            'pagetitle' => 'Client Details',
            'breadcrumb' => array(
                'index.php?m=vpnpanel' => 'VPN Panel',
                'index.php?m=vpnpanel&action=vpnusersServices' => 'VPN Services Page',
            ),
            'templatefile' => 'vpnusersServices',
            'requirelogin' => true, // Set true to restrict access to authenticated client users
            'forcessl' => false, // Deprecated as of Version 7.0. Requests will always use SSL if available.
            'vars' => $response,
        );
    }

    public function vpnusers($vars) {
        $SearchedMacAddress = "";
        $clientdata = Capsule::table('tblclients')->where('id', '=', $_SESSION['uid'])->get();
        $creditsDetails = self::CheckAffCredit();
       $totalCredits = $creditsDetails->credit;
// Get common module parameters
        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
        $response = array(
            'modulelink' => $modulelink,);
        /*
         * Reseller Clients
         */
        $result = '';
        $message = '';
        if(isset($_POST['addCredits']))
        {
            $remainingCredits = $_POST['remainingCredits'];
            $clientid = $_POST['clientid'];
            $creditstoadd = $_POST['credits'];
            $description = $_POST['description'];
            $command = 'AddCredit';
            $postData = array(
                'clientid' => $clientid,
                'description' => (!empty($description))?$description:'',
                'amount' => $creditstoadd,
            );
            
            $results = localAPI($command, $postData);

            if($results['result'] == 'success')
            {
                $update = Capsule::table('tblclients')->where('id',$_SESSION['uid'])->update(['credit' => $remainingCredits]);
                if($update)
                {
                    $result = 'success';
                    $message = 'Credits Added Successfully';
                }
                else
                {
                    $result = 'danger';
                    $message = 'Error Adding Credits';
                }
            }

        }
        $email = $clientdata[0]->email;
        $affiliateid = self::getWHMCSaffid();
        
        $clients1 = Capsule::table('tblaffiliatesaccounts')->where('affiliateid',$affiliateid)->join('tblclients','tblclients.id','=','tblaffiliatesaccounts.relid')->select('tblclients.*')->get();
        $clientsData1 = array();
        //echo '<pre>';print_r($clients1); die(sdf);
        $i = 0;
        foreach($clients1 as $client1)
        {
            if($client1->groupid == 0)
            {
            $clientsData1[$i]['client_id'] = $client1->id;
             $clientsData1[$i]['firstname'] = $client1->firstname;
              $clientsData1[$i]['lastname'] = $client1->lastname;
               $clientsData1[$i]['email'] = $client1->email;
           }
                $i++;
        }
        
        
        
        $response['servicedetails'] = $clientsData1;
        $response['totalcredit'] = $totalCredits;
        $response['listactive'] = 'class="active"';
        $response['userspage'] = 'active';
        $response['result'] = $result;
        $response['message'] = $message;
        return array(
            'pagetitle' => 'Users List',
            'breadcrumb' => array(
                'index.php?m=vpnpanel' => 'vpnpanel',
                'index.php?m=vpnpanel&action=vpnusers' => 'Users list',
            ),
            'templatefile' => 'vpnusers',
            'requirelogin' => true, // Set true to restrict access to authenticated client users
            'forcessl' => false, // Deprecated as of Version 7.0. Requests will always use SSL if available.
            'vars' => $response,
        );
    }

    public function XtreamCode_GetUserIdByPackege($PackageName = "") {
        $PackageData = Capsule::table('tblproducts')
                ->where('name', 'like', '%' . $PackageName . '%')
                ->select('tblproducts.id as PackageId')
                ->get();
        if (!empty($PackageData)) {
            return $PackageData;
        }
    }

    public function XtreamCode_GetUserIdByName($Name = "") {}

    public function XtreamCode_GetUserIdByMacCode($MacCode = "") {}

    public function decryptPassclient($pass)
{
    $salt = 'TeFrg&65TY!23Olk(';
    $qDecoded = rtrim(mcrypt_decrypt(MCRYPT_RIJNDAEL_256, md5($salt), base64_decode($pass), MCRYPT_MODE_CBC, md5(md5($salt))), "\0");
    return( $qDecoded );
}

    public function vpnmyshopingcart($vars) {
        set_include_path(get_include_path() . PATH_SEPARATOR . 'phpseclib');
                require_once __DIR__ . '/../../phpseclib/Crypt/RC4.php';
                require_once __DIR__ . '/../../phpseclib/Crypt/Rijndael.php';
                require_once __DIR__ . '/../../phpseclib/Crypt/Twofish.php';
                require_once __DIR__ . '/../../phpseclib/Crypt/Blowfish.php';
                require_once __DIR__ . '/../../phpseclib/Crypt/TripleDES.php';
                require_once __DIR__ . '/../../phpseclib/Crypt/Random.php';
                require_once __DIR__ . '/../../phpseclib/Crypt/Hash.php';
                require_once __DIR__ . '/../../phpseclib/Math/BigInteger.php';
                require_once __DIR__ . '/../../phpseclib/Net/SSH2.php';

        if(!isset($_SESSION['uid']) || empty($_SESSION['uid']))
        {
            header('location:/login.php');
            exit;
        }
        //$zip = $vars['zip'];

        if (isset($_POST['SortProducts'])) {
            $products2 = implode(',', $_POST['sortproducts']);
            Capsule::table('vpnmywebsite')->where('uid', $_SESSION['uid'])->update(['products' => $products2]);

            $link = "?m=vpnpanel&action=vpnmyshopingcart&sorted=yes";
            echo '<script type="text/javascript">
                   window.location = "' . $link . '"
              </script>';
            die();
        }

        if (isset($_POST['SaveEmailTemplate'])) {
            $successMessgae = "success";
            $resellerEmailMessage = html_entity_decode($_POST['resellerEmail']);
            $TemplateName = 'VPN Service Details super Reseller' . $_SESSION['uid'];
            $emailtemplate = Capsule::table('tblemailtemplates')->where('name', '=', $TemplateName)->select('message')->get();

            if (!empty($emailtemplate)) {
                $updateQuery = Capsule::table('tblemailtemplates')->where('name', $TemplateName)->update(['message' => $resellerEmailMessage]);
                if ($updateQuery) {
                    $successMessgae = "success";
                }
            } else {
                $emailvaluedataoption = array('type' => 'product', 'name' => $TemplateName, 'subject' => 'Your VPN Service Info', 'message' => $resellerEmailMessage, 'disabled' => 0, 'custom' => 1, 'plaintext' => 0);
                if (isset($emailvaluedataoption) && !empty($emailvaluedataoption)) {
                    $INsertQuery = Capsule::table('tblemailtemplates')->insert($emailvaluedataoption);
                    if ($INsertQuery) {
                        $successMessgae = "success";
                    }
                }
            }

            $link = "?m=vpnpanel&action=vpnmyshopingcart&emainsaved=" . $successMessgae;
            echo '<script type="text/javascript">
                   window.location = "' . $link . '"
              </script>';
            die();
        }
        $CONFIG = Capsule::table('tblconfiguration')
                ->where('setting', '=', 'SystemURL')
                ->get();
        $system_url = $CONFIG[0]->value;
        $style = $managegateway = $prodct = $domain = '';
        $command = 'GetClientsDetails';
        $postData = array(
            'clientid' => $_SESSION['uid'],
            'stats' => true,
        );
        $admin = Capsule::table('tbladmins')
                ->where('roleid', '=', 1)
                ->get();
        $adminUsername = $admin[0]->username;

        $results = localAPI($command, $postData, $adminUsername);
        if (!is_dir(ROOTDIR . '/onepagecheckout')) {
            $zipFile = ROOTDIR . '/mywebsite_checkout/checkout.zip';
            /*$extractPath = ROOTDIR . "/" . str_replace(' ', '', strtolower($results['firstname'])) . $_SESSION['uid'] . "";*/
            $extractPath = ROOTDIR . "/onepagecheckout/";
            $serversRootDetails = Capsule::table('server_list')->where('mainserver',1)->get();
            $rootserverip = $serversRootDetails[0]->server_ip;
            $rootserverport = $serversRootDetails[0]->sshport;
            $rootserverpassword = self::decryptPassclient($serversRootDetails[0]->sshpass);
            $ssh = new Net_SSH2($rootserverip, $rootserverport);
            if ($ssh->login('root', $rootserverpassword)) 
            {
                $ssh->exec('mkdir '.$extractPath.'');
                $ssh->exec('cp '.$zipFile.' '.$extractPath.'');
                $ssh->exec('cd '.$extractPath.'/');
                $unzipres = $ssh->exec('unzip '.$extractPath.'/checkout.zip -d '.$extractPath.'');
                logModuleCall('VPN Panel', 'Create Reseller Cart', 'zip path -> '.$zipFile.' |---| extract path -> '.$extractPath.'/checkout.zip', 'Extract successfully', $unzipres, '');
            }
            else
            {
                logModuleCall('VPN Panel', 'Create Reseller Cart', 'zip path -> '.$zipFile.' |---| extract path -> '.$extractPath.'', 'Unable to login', '', '');
            }
            
        }
        $clientwebsitedata = Capsule::table('vpnmywebsite')->where('uid', '=', $_SESSION['uid'])->count();
        $protocol = strtolower(substr($_SERVER["SERVER_PROTOCOL"], 0, strpos($_SERVER["SERVER_PROTOCOL"], '/'))) . '://';

        $checkEmptyProducts = Capsule::table('vpnmywebsite')->where('uid', $_SESSION['uid'])->get();

        if ($checkEmptyProducts[0]->products == '' || empty($checkEmptyProducts[0]->products)) {

            $clientdata = Capsule::table('tblclients')->where('id', '=', $_SESSION['uid'])->get();
            $product_id = Capsule::table('mod_vpn_assignpackages')->where('resellerid', '=', $clientdata[0]->groupid)->get();
            if(empty($product_id[0]->products))
            {
                $product_id = Capsule::table('mod_vpn_assignpackages')->where('resellerid', '=', 'all')->get();
            }
            $products = Capsule::table('tblproducts')
                    ->select(Capsule::raw('*'))
                    ->where('servertype', '=', 'vpnpanel')
                    ->whereIn('id', explode(',', $product_id[0]->products))
                    ->get();
            $all_products = array();
            foreach ($products as $prd) {
                array_push($all_products, $prd->id);
            }
            $products3 = implode(',', $all_products);
            Capsule::table('vpnmywebsite')->where('uid', $_SESSION['uid'])->update(['products' => $products3]);
        }


        if (!$clientwebsitedata >= 1) {
            Capsule::table('vpnmywebsite')->insert(['uid' => $_SESSION['uid'], 'websiteURL' => $system_url .'onepagecheckout/?user='. $_SESSION['uid'] . '']);
        }
        if (isset($_POST['addProducts'])) {
            $products = implode(',', $_POST['products']);
            Capsule::table('vpnmywebsite')->where('uid', $_SESSION['uid'])->update(['products' => $products]);
            $mywebsiteProducts = Capsule::table('vpnmywebsite')
                    ->where('uid', '=', $_SESSION['uid'])
                    ->get();
            $currencydata = Capsule::table('tblclients')->where('id', '=', $_SESSION['uid'])->select('currency')->get();
            $currency = $currencydata[0]->currency;
            $currencydetails = Capsule::table('tblcurrencies')->where('id', '=', $currency)->get();
            $Currencycode = $currencydetails[0]->code;
            foreach ($mywebsiteProducts as $myproducts) {
                if (!empty($myproducts->products)) {
                    $myproductsArray = explode(',', $myproducts->products);
                    foreach ($myproductsArray as $myproduct) {
                        $packagePriceData = Capsule::table('vpnpackageprice')
                                ->where('uid', '=', $_SESSION['uid'])
                                ->where('products', '=', $myproduct)
                                ->get();
                        if (count($packagePriceData) >= 1) {

                            $existingProducts = array();

                            foreach ($packagePriceData as $packagePriceProducts) {
                                array_push($existingProducts, $packagePriceProducts->products);
                            }
                            if (!in_array($myproduct, $existingProducts)) {
                                
                                $results = Capsule::table('tblproducts')
                            ->join('tblpricing','tblproducts.id','=','tblpricing.relid')
                            ->where('tblproducts.id', $myproduct)
                            ->select(
                                    'tblproducts.*',
                                    'tblpricing.currency as clientcurrency',
                                    'tblpricing.monthly',
                                    'tblpricing.quarterly',
                                    'tblpricing.semiannually',
                                    'tblpricing.annually',
                                    'tblpricing.biennially',
                                    'tblpricing.triennially'
                                    )
                            ->get();
                            Capsule::table('vpnpackageprice')->insert(['uid' => $_SESSION['uid'],
                                'products' => $myproduct,
                                'priceMonthly' => $results[0]->monthly,
                                'priceQuarterly' => $results[0]->quarterly,
                                'priceSemiannually' => $results[0]->semiannually,
                                'priceAnnually' => $results[0]->annually,
                                'priceBiennially' => $results[0]->biennially,
                                'priceTriennially' => $results[0]->triennially]);

                            } else {
                                 $results = Capsule::table('tblproducts')
                            ->join('tblpricing','tblproducts.id','=','tblpricing.relid')
                            ->where('tblproducts.id', $myproduct)
                            ->select(
                                    'tblproducts.*',
                                    'tblpricing.currency as clientcurrency',
                                    'tblpricing.monthly',
                                    'tblpricing.quarterly',
                                    'tblpricing.semiannually',
                                    'tblpricing.annually',
                                    'tblpricing.biennially',
                                    'tblpricing.triennially'
                                    )
                            ->get();
                            Capsule::table('vpnpackageprice')->insert(['uid' => $_SESSION['uid'],
                                'products' => $myproduct,
                                'priceMonthly' => $results[0]->monthly,
                                'priceQuarterly' => $results[0]->quarterly,
                                'priceSemiannually' => $results[0]->semiannually,
                                'priceAnnually' => $results[0]->annually,
                                'priceBiennially' => $results[0]->biennially,
                                'priceTriennially' => $results[0]->triennially]);

                            }
                        } else {


                            /*$command = 'GetProducts';
                            $postData = array(
                                'pid' => $myproduct,
                            );
                            $admin = Capsule::table('tbladmins')
                                    ->where('roleid', '=', 1)
                                    ->get();

                            $adminUsername = $admin[0]->username;

                            $results = localAPI($command, $postData, $adminUsername);*/

                            $results = Capsule::table('tblproducts')
                            ->join('tblpricing','tblproducts.id','=','tblpricing.relid')
                            ->where('tblproducts.id', $myproduct)
                            ->select(
                                    'tblproducts.*',
                                    'tblpricing.currency as clientcurrency',
                                    'tblpricing.monthly',
                                    'tblpricing.quarterly',
                                    'tblpricing.semiannually',
                                    'tblpricing.annually',
                                    'tblpricing.biennially',
                                    'tblpricing.triennially'
                                    )
                            ->get();

                            
                            Capsule::table('vpnpackageprice')->insert(['uid' => $_SESSION['uid'],
                                'products' => $myproduct,
                                'priceMonthly' => $results[0]->monthly,
                                'priceQuarterly' => $results[0]->quarterly,
                                'priceSemiannually' => $results[0]->semiannually,
                                'priceAnnually' => $results[0]->annually,
                                'priceBiennially' => $results[0]->biennially,
                                'priceTriennially' => $results[0]->triennially]);

                        }
                    }
                }
            }

            $prodct = 'active';
        }
        if (isset($_POST['saveStyle'])) {
            $headColor = $_POST['headingColor'];
            $textColor = $_POST['headingTextColor'];

            $title = $_POST['title'];
            $tagline = $_POST['tagline'];
            $maindomain = $_POST['domainURL'];
            $tandc = $_POST['tandc'];
            $privacy = $_POST['privacy'];

            Capsule::table('vpnmywebsite')->where('uid', $_SESSION['uid'])->update(['companyName' => $title, 'tagline' => $tagline, 'headColor' => $headColor, 'textColor' => $textColor, 'domainURL' => $maindomain, 'tandc' => $tandc, 'privacy' => $privacy, 'websiteURL' => $system_url .'onepagecheckout/?user='. $_SESSION['uid'] . '']);
            $style = 'active';

        }

        /*if (isset($_POST['create'])) {
            $code = create();
            Capsule::table('vpnDomainVerify')->insert(["uid" => $_SESSION['uid'], "verifyCode" => $code, "status" => "0"]);

            $domain = 'active';
        }
        $VerifyError = '';
        if (isset($_POST['check'])) {
            Capsule::table('vpnmywebsite')->where('uid', $_SESSION['uid'])->update(['websiteURL' => $_POST['domain']]);
            Capsule::table('vpnDomainVerify')->where('uid', $_SESSION['uid'])->update(['status' => '1']);
            $domain = 'active';
        }*/

        if (isset($_POST['addGateways'])) {

            $gateway = $_POST['gateway'];
            $friendlygateway = $_POST['addGateways'];

            $gatewaysList = Capsule::table('tblvpnpaymentgateways')->where("uid", '=', $_SESSION['uid'])->groupby('gateway')->get();

            foreach ($gatewaysList as $list) {

                if ($gateway == 'stripe') {
                    if ($list->gateway == 'authorize') {
                        header("LOCATION:index.php?m=vpnpanel&action=vpnmyshopingcart&err=authorizeActive");
                        exit;
                    }
                } elseif ($gateway == 'authorize') {
                    if ($list->gateway == 'stripe') {
                        header("LOCATION:index.php?m=vpnpanel&action=vpnmyshopingcart&err=stripeActive");
                        exit;
                    }
                }
            }


            Capsule::table('tblvpnpaymentgateways')->where("gateway", $gateway)->where('uid', $_SESSION['uid'])->delete();
            //delete_query("tblvpnpaymentgateways", array("gateway" => $gateway));
            ++$lastorder;
            $type = "Invoices";

            if (isset($_POST['_capture']) && $_POST['_capture'] == 'on') {
                $type = "CC";
            }

            Capsule::table('tblvpnpaymentgateways')->insert(["uid" => $_SESSION['uid'], "gateway" => $gateway, "setting" => "name", "value" => $friendlygateway, "order" => $lastorder]);

            if ($GatewayConfig[$gateway]['RemoteStorage']) {
                Capsule::table('tblvpnpaymentgateways')->insert(["uid" => $_SESSION['uid'], "gateway" => $gateway, "setting" => "remotestorage", "value" => "1"]);
            }
            Capsule::table('tblvpnpaymentgateways')->insert(["uid" => $_SESSION['uid'], "gateway" => $gateway, "setting" => "type", "value" => $type]);
            Capsule::table('tblvpnpaymentgateways')->insert(["uid" => $_SESSION['uid'], "gateway" => $gateway, "setting" => "visible", "value" => "on"]);
            $managegateway = 'active';
        }
        if (isset($_POST["rmImage"])) {
            $imageMsg = 'Logo Removed';
            Capsule::table('vpnmywebsite')->where('uid', $_SESSION['uid'])->update(['logo' => '']);
            $style = 'active';
        }

        if (isset($_POST["uploadImage"])) {
            $target_dir = "downloads/";
            $target_file = $target_dir . basename(uniqid() . $_FILES["logo"]["name"]);
            $uploadOk = 1;
            $imageMsg = '';
            $imageFileType = pathinfo($target_file, PATHINFO_EXTENSION);
            $check = getimagesize($_FILES["logo"]["tmp_name"]);

            if ($check !== false) {
                $imageMsg = "File is an image - " . $check["mime"] . ".";
                $uploadOk = 1;
            } else {
                $imageMsg = "File is not an image.";
                $uploadOk = 0;
            }
// Check if file already exists
            if (file_exists($target_file)) {
                $imageMsg = "Sorry, file already exists.";
                $uploadOk = 0;
            }
// Check file size
            if ($_FILES["logo"]["size"] > 1000000) {
                $imageMsg = "Sorry, your file is too large.";
                $uploadOk = 0;
            }
// Allow certain file formats
            if ($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg" && $imageFileType != "gif") {
                $imageMsg = "Sorry, only JPG, JPEG, PNG & GIF files are allowed.";
                $uploadOk = 0;
            }
// Check if $uploadOk is set to 0 by an error
            if ($uploadOk == 0) {

// if everything is ok, try to upload file
            } else {

                if (move_uploaded_file($_FILES["logo"]["tmp_name"], $target_file)) {
                    $imageMsg = "The file " . basename($_FILES["logo"]["name"]) . " has been uploaded.";
                    Capsule::table('vpnmywebsite')->where('uid', $_SESSION['uid'])->update(['logo' => $target_file]);
                } else {
                    $imageMsg = "Sorry, there was an error uploading your file.";
                }
            }
            $style = 'active';
        }
        $productdetils = Capsule::table('tblproducts')->where('id', '=', $_POST['packageid'])->select('configoption2')->get();
        if ($productdetils[0]->configoption2 == 'magdevice') {
            if (empty($_POST['customfields'][$_POST['packageid']][$returndata['custom_field_mag']])) {
                header("LOCATION:index.php?m=vpnpanel&action=adduser&result=macerror");
            }
        } elseif ($productdetils[0]->configoption2 == 'engdevice') {
            if (empty($_POST['customfields'][$_POST['packageid']][$returndata['custom_field_eng']])) {
                header("LOCATION:index.php?m=vpnpanel&action=adduser&result=engerror");
            }
        }
        $clientdata = Capsule::table('tblclients')->where('id', '=', $_SESSION['uid'])->get();
        $product_id = getassignedpackages($_SESSION['uid']);
        if(empty($product_id[0]->products))
        {
            $groupid = getclientgroupid('Super-Reseller');
            $product_id = Capsule::table('mod_vpn_assignpackages')->where('resellerid','all')->where('assigngroup',$groupid)->get();
        }
        //echo '<pre>'; print_r($product_id); die();
        $products = Capsule::table('tblproducts')
                ->select(Capsule::raw('*'))
                ->whereIn('id', explode(',', $product_id[0]->products))
                ->get();
        /*$xtreamConfig = Capsule::table('mod_xtreamConfig')->get();*/
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        $GatewayValues = $GatewayConfig = $ActiveGateways = $DisabledGateways = array();
        /* $result = select_query("tblvpnpaymentgateways", "", "", "setting", "ASC");

          while ($data = mysql_fetch_array($result)) {
          $gwv_gateway = $data['gateway'];
          $gwv_setting = $data['setting'];
          $gwv_value = $data['value'];
          $GatewayValues[$gwv_gateway][$gwv_setting] = $gwv_value;
          } */
        $result = Capsule::table('tblvpnpaymentgateways')->where('uid', '=', $_SESSION['uid'])->get();
        foreach ($result as $data) {
            $gwv_gateway = $data->gateway;
            $gwv_setting = $data->setting;
            $gwv_value = $data->value;
            $GatewayValues[$gwv_gateway][$gwv_setting] = $gwv_value;
        }
        //print_r($GatewayValues);die();
        $gwdata = Capsule::table('vpnmywebsite')->where('uid', '=', $_SESSION['uid'])->get();
        $gateways = explode(',', $gwdata[0]->gateways);

        foreach ($gateways as $gateway) {
            
        }

        if ($_POST["deactivate"]) {
            $gateway = $_POST['gateway'];
            Capsule::table("tblvpnpaymentgateways")->where("gateway", $gateway)->where("uid", $_SESSION['uid'])->delete();
            $managegateway = 'active';
        }

        if ($_POST['save']) {

            check_token("WHMCS.admin.default");
            $gateway = $_POST['gateway'];
            $module = $_POST['field'];

            $data = Capsule::table("tblvpnpaymentgateways")->where("gateway", $gateway)->where("uid", $_SESSION['uid'])->count();

            if ($data >= 1) {

                foreach ($module as $field => $val) {
                    $data = Capsule::table("tblvpnpaymentgateways")->where("gateway", $gateway)->where("setting", $field)->where('uid', $_SESSION['uid'])->count();
                    // echo $data;die();
                    if ($data >= 1) {
                        Capsule::table('tblvpnpaymentgateways')->where('uid', $_SESSION['uid'])->where('gateway', $gateway)->delete();
                    }

                    Capsule::table('tblvpnpaymentgateways')->insert(['uid' => $_SESSION['uid'], 'gateway' => $gateway, 'setting' => $field, 'value' => $val]);
                }
            }
            header('LOCATION:index.php?m=vpnpanel&action=vpnmywebsite');
            $managegateway = 'active';
        }
        $includedmodules = array();
        $gatewaynames = array();
        $activatedArray = array();
        $dh = opendir("modules/gateways/");

        while (false !== $file = readdir($dh)) {
            $fileext = explode(".", $file, 2);

            if (((trim($file) && $file != "index.php") && $fileext[1] == "php") && !in_array($fileext[0], $includedmodules)) {
                array_push($includedmodules, $fileext[0]);
                $gwv_modulename = $fileext[0];

                if (!isValidforPath($fileext[0])) {
                    exit("Invalid Gateway Module Name");
                }

                require_once ROOTDIR . "/modules/gateways/" . $fileext[0] . ".php";

                if (function_exists($gwv_modulename . "_config")) {

                    $GatewayConfig[$gwv_modulename] = call_user_func($gwv_modulename . "_config");
                    $GatewayFieldDefines = $GatewayConfig[$gwv_modulename];
                    $activatedData = $GatewayConfig[$gwv_modulename];
                    array_push($activatedArray, $activatedData);
                } else {
                    $GatewayFieldDefines = array();
                    $GatewayFieldDefines['FriendlyName'] = array("Type" => "System", "Value" => $GATEWAYMODULE[$gwv_modulename . "visiblename"]);

                    if ($GATEWAYMODULE[$gwv_modulename . "notes"]) {
                        $GatewayFieldDefines['UsageNotes'] = array("Type" => "System", "Value" => $GATEWAYMODULE[$gwv_modulename . "notes"]);
                    }

                    call_user_func($gwv_modulename . "_activate");
                    $GatewayConfig[$gwv_modulename] = $GatewayFieldDefines;
                }
                array_push($gatewaynames, array('displayname' => $GatewayFieldDefines['FriendlyName']['Value'], 'module' => $fileext[0]));
            }
        }

        closedir($dh);

        $paymentDetails = '';
        $count = 1;
        $newgateways = "";
        $data = Capsule::table('tblvpnpaymentgateways')->where('uid', '=', $_SESSION['uid'])->groupby('gateway')->get();


        $numgateways = count(explode(',', $data[0]->gateways));

        $result3 = Capsule::table('tblvpnpaymentgateways')->where('uid', '=', $_SESSION['uid'])->groupby('gateway')->get();

        foreach ($result3 as $data) {
            $module = $data->gateway;
            $order = $data->order;

            $paymentDetails .= "
<form method=\"post\" >
<input type=\"hidden\" name=\"module\" value=\"";
            $paymentDetails .= $module;
            $paymentDetails .= "\">

<p align=\"left\"><b>";
            $paymentDetails .= $count . ". " . $GatewayConfig[$module]['FriendlyName']['Value'];


            $paymentDetails .= " <form method='post' action=''><input type='hidden' name='gateway' value='" . $module . "'><input type='hidden' name='friendlygateway' value='" . $GatewayConfig[$module]['FriendlyName']['Value'] . "'><input type='hidden'name='deactivate' value='deactivate'><input type='submit' value='deactivate'style='border: none;
    background: none;
    color: #f00;'></form>";


            $paymentDetails .= "</b>";
            $paymentDetails .= "</p>
<form method='post' action=''><table class=\"form table-striped table\" width=\"100%\" border=\"0\" cellspacing=\"2\" cellpadding=\"3\">
<input type='hidden' name='gateway' value='" . $module . "'>
<tr><td width=\"200\" class=\"fieldlabel\">";
            $paymentDetails .= "showonorderform";
            $paymentDetails .= "</td><td class=\"fieldarea\"><input type=\"checkbox\" name=\"field[visible]\"";

            if ($GatewayValues[$module]['visible']) {
                $paymentDetails .= " checked";
            }

            $paymentDetails .= " /></td></tr>
<tr><td class=\"fieldlabel\">";
            $paymentDetails .= "displayname";
            $paymentDetails .= "</td><td class=\"fieldarea\"><input type=\"text\" name=\"field[name]\" size=\"30\" value=\"";
            $paymentDetails .= $GatewayValues[$module]['name'];
            $paymentDetails .= "\"></td></tr>
";
            foreach ($GatewayConfig[$module] as $confname => $values) {

                if ($values['Type'] != "System") {
                    $values['Name'] = "field[" . $confname . "]";

                    if (isset($GatewayValues[$module][$confname])) {
                        $values['Value'] = $GatewayValues[$module][$confname];
                    }

                    $paymentDetails .= "<tr><td class=\"fieldlabel\">" . $values['FriendlyName'] . "</td><td class=\"fieldarea\">" . moduleConfigFieldOutput($values) . "</td></tr>";
                    continue;
                }
            }


            if (1 < count($currenciesarray)) {
                $paymentDetails .= "<tr><td class=\"fieldlabel\">" . "currencyconvert" . "</td><td class=\"fieldarea\"><select name=\"field[convertto]\"><option value=\"\">" . "none" . "</option>";
                foreach ($currenciesarray as $currencydata) {
                    $paymentDetails .= "<option value=\"" . $currencydata['id'] . "\"";

                    if ($currencydata['id'] == $GatewayValues[$module]['convertto']) {
                        $paymentDetails .= " selected";
                    }

                    $paymentDetails .= ">" . $currencydata['code'] . "</option>";
                }

                $paymentDetails .= "</select></td></tr>";
            }

            $paymentDetails .= "<tr><td class=\"fieldlabel\"></td><td class=\"fieldarea\"><input type=\"submit\" class=\"btn btn-primary mybtn\" name='save' value=\"";
            $paymentDetails .= "save changes";
            $paymentDetails .= "\">";

            if ($GatewayConfig[$module]['UsageNotes']['Value']) {
                $paymentDetails .= " (" . $GatewayConfig[$module]['UsageNotes']['Value'] . ")";
            }

            $paymentDetails .= "</td></tr>
</table>

<br />

</form>

";

            if ($count != $order) {
                update_query("tblvpnpaymentgateways", array("order" => $count), array("setting" => "name", "gateway" => $module));
            }
            ++$count;
            $newgateways .= "<option value=\"" . $module . "\">" . $GatewayConfig[$module]['FriendlyName']['Value'] . "</option>";
        }

        /* ----------------------------------------------------------------------------- */
        if (isset($_POST['autorenew'])) {
            $resellerid = $_SESSION['uid'];
            $configdata = Capsule::table('tblconfiguration')
                    ->where('setting', 'Reseller' . $resellerid)
                    ->get();
            foreach ($configdata as $configdatavale) {
                $dataconfigp[$configdatavale->setting] = $configdatavale->value;
            }
            if (isset($dataconfigp['Reseller' . $resellerid]) && !empty($dataconfigp['Reseller' . $resellerid])) {
                Capsule::table('tblconfiguration')
                        ->where('setting', 'Reseller' . $resellerid)
                        ->update(['value' => $_POST['renew']]);
            } else {
                Capsule::table('tblconfiguration')->insert(
                        ['setting' => 'Reseller' . $resellerid, 'value' => $_POST['renew']]
                );
            }
            $response['result'] = "success";
            $response['message'] = "<strong>Success!</strong> Auto Renewal feature is " . $_POST['renew'] . "d!";
        }
        $resellerid = $_SESSION['uid'];
        $configdata = Capsule::table('tblconfiguration')
                ->where('setting', 'Reseller' . $resellerid)
                ->get();
        foreach ($configdata as $configdatavale) {
            $dataconfigp[$configdatavale->setting] = $configdatavale->value;
        }
        if (isset($dataconfigp['Reseller' . $resellerid]) && !empty($dataconfigp['Reseller' . $resellerid])) {
            $response['checked'] = $dataconfigp['Reseller' . $resellerid];
        }

        $clientwebsitedata = Capsule::table('vpnmywebsite')->where('uid', '=', $_SESSION['uid'])->get();
        $selectedGateways = array();
        $query1 = Capsule::table('tblvpnpaymentgateways')->where('uid', '=', $_SESSION['uid'])->groupby('gateway')->get();
        foreach ($query1 as $gateways1) {

            array_push($selectedGateways, $gateways1->gateway);
        }
        //$verificationcount = Capsule::table('vpnDomainVerify')->where('uid', '=', $_SESSION['uid'])->count();
        $verificationdata = '';
        /*if ($verificationcount >= 1) {
            $verificationdata = Capsule::table('vpnDomainVerify')->where('uid', '=', $_SESSION['uid'])->get();
        }*/

        if (!empty($clientwebsitedata[0]->products)) {
            $ResellerProductIdsN = explode(',', $clientwebsitedata[0]->products);
            if (!empty($ResellerProductIdsN)) {
                foreach ($ResellerProductIdsN as $Shortedids) {
                    $products12 = Capsule::table('tblproducts')
                            ->where('id', $Shortedids)
                            ->get();
                    $SortedProductsIds[$products12[0]->id] = $products12[0]->name;
                }
            }
        }

        $sortprodct = "";


        if (isset($_GET['sorted'])) {
            $sortprodct = 'active';
        }

        $EmailSettingSection = "";
        $EmailActionResponse = "";


        if (isset($_GET['emainsaved'])) {
            $EmailSettingSection = 'active';
            if ($_GET['emainsaved'] == "success") {
                $EmailActionResponse = "success";
            } else if ($_GET['emainsaved'] == "error") {
                $EmailActionResponse = "error";
            }
        }

        sort($gatewaynames);
        $modulelink = $vars['modulelink'];
        $response['modulelink'] = $modulelink;
        $response['i'] = 0;
        $response['topup'] = $returndata['gid'];
        $response['optionactive'] = $returndata;
        $response['mywebsite'] = 'class="active"';
        $response['products'] = $products;
        $response['gateways'] = $gatewaynames;
        $response['imgmsg'] = $imageMsg;
        $response['clientData'] = $clientwebsitedata;
        $response['paymentDetails'] = $paymentDetails;
        $response['selectedGateways'] = $selectedGateways;
        $response['verifyData'] = $verificationdata;
        $response['verifyerror'] = $VerifyError;
        $response['productsTab'] = $prodct;
        $response['gatewayTab'] = $managegateway;
        $response['styleTab'] = $style;
        $response['SortedProductsIds'] = $SortedProductsIds;
        $response['sortprodctTab'] = $sortprodct;
        $response['EmailSettingSectionTab'] = $EmailSettingSection;
        $response['EmailActionResponse'] = $EmailActionResponse;
        $response['EmailData'] = self::vpnpanel_GetIPTVemailData();
        $response['selectedProducts'] = explode(',', $clientwebsitedata[0]->products);
        $response['shopingcartactive'] = 'class="active"';

        return array(
            'pagetitle' => 'My Shoping Cart',
            'breadcrumb' => array(
                'index.php?m=vpndashboard' => 'Dashboard',
                'index.php?m=vpnpanel&action=vpnmyshopingcart' => 'My Shoping Cart',
            ),
            'templatefile' => 'vpnmywebsite',
            'requirelogin' => true, // Set true to restrict access to authenticated client users
            'forcessl' => false, // Deprecated as of Version 7.0. Requests will always use SSL if available.
            'vars' => $response,
        );
    
       
    }

    public function getclientgroupid($name = '')
{
    $groupdata = Capsule::table('tblclientgroups')->where('groupname',$name)->get();
    return $groupdata[0]->id;
}

    public function vpnmywebsite($vars) {
        set_include_path(get_include_path() . PATH_SEPARATOR . 'phpseclib');
                require_once __DIR__ . '/../../phpseclib/Crypt/RC4.php';
                require_once __DIR__ . '/../../phpseclib/Crypt/Rijndael.php';
                require_once __DIR__ . '/../../phpseclib/Crypt/Twofish.php';
                require_once __DIR__ . '/../../phpseclib/Crypt/Blowfish.php';
                require_once __DIR__ . '/../../phpseclib/Crypt/TripleDES.php';
                require_once __DIR__ . '/../../phpseclib/Crypt/Random.php';
                require_once __DIR__ . '/../../phpseclib/Crypt/Hash.php';
                require_once __DIR__ . '/../../phpseclib/Math/BigInteger.php';
                require_once __DIR__ . '/../../phpseclib/Net/SSH2.php';
        if(!isset($_SESSION['uid']) || empty($_SESSION['uid']))
        {
            header('location:/login.php');
            exit;
        }
        $zip = $vars['zip'];

        if (isset($_POST['SortProducts'])) {
            $products2 = implode(',', $_POST['sortproducts']);
            Capsule::table('vpnmywebsite')->where('uid', $_SESSION['uid'])->update(['products' => $products2]);

            $link = "?m=vpnpanel&action=vpnmywebsite&sorted=yes";
            echo '<script type="text/javascript">
                   window.location = "' . $link . '"
              </script>';
            die();
        }

        if (isset($_POST['SaveEmailTemplate'])) {
            $successMessgae = "success";
            $resellerEmailMessage = html_entity_decode($_POST['resellerEmail']);
            $TemplateName = 'VPN Service Details Reseller' . $_SESSION['uid'];
            $emailtemplate = Capsule::table('tblemailtemplates')->where('name', '=', $TemplateName)->select('message')->get();

            if (!empty($emailtemplate)) {
                $updateQuery = Capsule::table('tblemailtemplates')->where('name', $TemplateName)->update(['message' => $resellerEmailMessage]);
                if ($updateQuery) {
                    $successMessgae = "success";
                }
            } else {
                $emailvaluedataoption = array('type' => 'product', 'name' => $TemplateName, 'subject' => 'Your VPN Service Info', 'message' => $resellerEmailMessage, 'disabled' => 0, 'custom' => 1, 'plaintext' => 0);
                if (isset($emailvaluedataoption) && !empty($emailvaluedataoption)) {
                    $INsertQuery = Capsule::table('tblemailtemplates')->insert($emailvaluedataoption);
                    if ($INsertQuery) {
                        $successMessgae = "success";
                    }
                }
            }

            $link = "?m=vpnpanel&action=vpnmywebsite&emainsaved=" . $successMessgae;
            echo '<script type="text/javascript">
                   window.location = "' . $link . '"
              </script>';
            die();
        }
        $CONFIG = Capsule::table('tblconfiguration')
                ->where('setting', '=', 'SystemURL')
                ->get();
        $system_url = $CONFIG[0]->value;
        $style = $managegateway = $prodct = $domain = '';
        $command = 'GetClientsDetails';
        $postData = array(
            'clientid' => $_SESSION['uid'],
            'stats' => true,
        );
        $admin = Capsule::table('tbladmins')
                ->where('roleid', '=', 1)
                ->get();
        $adminUsername = $admin[0]->username;

        $results = localAPI($command, $postData, $adminUsername);
        if (!is_dir(ROOTDIR . '/' . str_replace(' ', '', strtolower($results['firstname'])) . $_SESSION['uid'] . '')) {
            $zipFile = ROOTDIR . '/mywebsite_checkout/checkout.zip';
            /*$extractPath = ROOTDIR . "/" . str_replace(' ', '', strtolower($results['firstname'])) . $_SESSION['uid'] . "";*/
            $extractPath = ROOTDIR . "/onepagecheckout/";
            $serversRootDetails = Capsule::table('server_list')->where('mainserver',1)->get();
            $rootserverip = $serversRootDetails[0]->server_ip;
            $rootserverport = $serversRootDetails[0]->sshport;
            $rootserverpassword = self::decryptPassclient($serversRootDetails[0]->sshpass);
            $ssh = new Net_SSH2($rootserverip, $rootserverport);
            if ($ssh->login('root', $rootserverpassword)) 
            {
                $ssh->exec('mkdir '.$extractPath.'');
                $ssh->exec('cp '.$zipFile.' '.$extractPath.'');
                $ssh->exec('cd '.$extractPath.'');
               $ssh->exec('cd '.$extractPath.'/');
                $unzipres = $ssh->exec('unzip '.$extractPath.'/checkout.zip -d '.$extractPath.'');
                logModuleCall('VPN Panel', 'Create Reseller Cart', 'zip path -> '.$zipFile.' |---| extract path -> '.$extractPath.'', 'Extract successfully', $unzipres, '');
            }
            else
            {
                logModuleCall('VPN Panel', 'Create Reseller Cart', 'zip path -> '.$zipFile.' |---| extract path -> '.$extractPath.'', 'Unable to login', '', '');
            }
            
        }
        $clientwebsitedata = Capsule::table('vpnmywebsite')->where('uid', '=', $_SESSION['uid'])->count();
        $protocol = strtolower(substr($_SERVER["SERVER_PROTOCOL"], 0, strpos($_SERVER["SERVER_PROTOCOL"], '/'))) . '://';

        $checkEmptyProducts = Capsule::table('vpnmywebsite')->where('uid', $_SESSION['uid'])->get();

        if ($checkEmptyProducts[0]->products == '' || empty($checkEmptyProducts[0]->products)) {

            $clientdata = Capsule::table('tblclients')->where('id', '=', $_SESSION['uid'])->get();
            $product_id = Capsule::table('mod_vpn_assignpackages')->where('resellerid', '=', $clientdata[0]->groupid)->get();
            if(empty($product_id[0]->products))
            {
                $product_id = Capsule::table('mod_vpn_assignpackages')->where('resellerid', '=', 'all')->get();
            }
            $products = Capsule::table('tblproducts')
                    ->select(Capsule::raw('*'))
                    ->where('servertype', '=', 'vpnpanel')
                    ->whereIn('id', explode(',', $product_id[0]->products))
                    ->get();
            $all_products = array();
            foreach ($products as $prd) {
                array_push($all_products, $prd->id);
            }
            $products3 = implode(',', $all_products);
            Capsule::table('vpnmywebsite')->where('uid', $_SESSION['uid'])->update(['products' => $products3]);
        }


        if (!$clientwebsitedata >= 1) {
            Capsule::table('vpnmywebsite')->insert(['uid' => $_SESSION['uid'], 'websiteURL' => $system_url .'onepagecheckout/?user='. $_SESSION['uid'] . '']);
        }
        if (isset($_POST['addProducts'])) {
            $products = implode(',', $_POST['products']);
            Capsule::table('vpnmywebsite')->where('uid', $_SESSION['uid'])->update(['products' => $products]);
            $mywebsiteProducts = Capsule::table('vpnmywebsite')
                    ->where('uid', '=', $_SESSION['uid'])
                    ->get();
            $currencydata = Capsule::table('tblclients')->where('id', '=', $_SESSION['uid'])->select('currency')->get();
            $currency = $currencydata[0]->currency;
            $currencydetails = Capsule::table('tblcurrencies')->where('id', '=', $currency)->get();
            $Currencycode = $currencydetails[0]->code;
            foreach ($mywebsiteProducts as $myproducts) {
                if (!empty($myproducts->products)) {
                    $myproductsArray = explode(',', $myproducts->products);
                    foreach ($myproductsArray as $myproduct) {
                        $packagePriceData = Capsule::table('vpnpackageprice')
                                ->where('uid', '=', $_SESSION['uid'])
                                ->get();
                        if (count($packagePriceData) >= 1) {

                            $existingProducts = array();

                            foreach ($packagePriceData as $packagePriceProducts) {
                                array_push($existingProducts, $packagePriceProducts->products);
                            }
                            if (!in_array($myproduct, $existingProducts)) {
                                $results = Capsule::table('tblproducts')
                            ->join('tblpricing','tblproducts.id','=','tblpricing.relid')
                            ->where('tblproducts.id', $myproduct)
                            ->select(
                                    'tblproducts.*',
                                    'tblpricing.currency as clientcurrency',
                                    'tblpricing.monthly',
                                    'tblpricing.quarterly',
                                    'tblpricing.semiannually',
                                    'tblpricing.annually',
                                    'tblpricing.biennially',
                                    'tblpricing.triennially'
                                    )
                            ->get();
                            Capsule::table('vpnpackageprice')->insert(['uid' => $_SESSION['uid'],
                                'products' => $myproduct,
                                'priceMonthly' => $results[0]->monthly,
                                'priceQuarterly' => $results[0]->quarterly,
                                'priceSemiannually' => $results[0]->semiannually,
                                'priceAnnually' => $results[0]->annually,
                                'priceBiennially' => $results[0]->biennially,
                                'priceTriennially' => $results[0]->triennially]);

                            } else {
                                 $results = Capsule::table('tblproducts')
                            ->join('tblpricing','tblproducts.id','=','tblpricing.relid')
                            ->where('tblproducts.id', $myproduct)
                            ->select(
                                    'tblproducts.*',
                                    'tblpricing.currency as clientcurrency',
                                    'tblpricing.monthly',
                                    'tblpricing.quarterly',
                                    'tblpricing.semiannually',
                                    'tblpricing.annually',
                                    'tblpricing.biennially',
                                    'tblpricing.triennially'
                                    )
                            ->get();
                            Capsule::table('vpnpackageprice')->insert(['uid' => $_SESSION['uid'],
                                'products' => $myproduct,
                                'priceMonthly' => $results[0]->monthly,
                                'priceQuarterly' => $results[0]->quarterly,
                                'priceSemiannually' => $results[0]->semiannually,
                                'priceAnnually' => $results[0]->annually,
                                'priceBiennially' => $results[0]->biennially,
                                'priceTriennially' => $results[0]->triennially]);

                            }
                        } else {


                            /*$command = 'GetProducts';
                            $postData = array(
                                'pid' => $myproduct,
                            );
                            $admin = Capsule::table('tbladmins')
                                    ->where('roleid', '=', 1)
                                    ->get();

                            $adminUsername = $admin[0]->username;

                            $results = localAPI($command, $postData, $adminUsername);*/

                            $results = Capsule::table('tblproducts')
                            ->join('tblpricing','tblproducts.id','=','tblpricing.relid')
                            ->where('tblproducts.id', $myproduct)
                            ->select(
                                    'tblproducts.*',
                                    'tblpricing.currency as clientcurrency',
                                    'tblpricing.monthly',
                                    'tblpricing.quarterly',
                                    'tblpricing.semiannually',
                                    'tblpricing.annually',
                                    'tblpricing.biennially',
                                    'tblpricing.triennially'
                                    )
                            ->get();

                            
                            Capsule::table('vpnpackageprice')->insert(['uid' => $_SESSION['uid'],
                                'products' => $myproduct,
                                'priceMonthly' => $results[0]->monthly,
                                'priceQuarterly' => $results[0]->quarterly,
                                'priceSemiannually' => $results[0]->semiannually,
                                'priceAnnually' => $results[0]->annually,
                                'priceBiennially' => $results[0]->biennially,
                                'priceTriennially' => $results[0]->triennially]);

                        }
                    }
                }
            }

            $prodct = 'active';
        }
        if (isset($_POST['saveStyle'])) {
            $headColor = $_POST['headingColor'];
            $textColor = $_POST['headingTextColor'];

            $title = $_POST['title'];
            $tagline = $_POST['tagline'];
            $maindomain = $_POST['domainURL'];
            $tandc = $_POST['tandc'];
            $privacy = $_POST['privacy'];

            Capsule::table('vpnmywebsite')->where('uid', $_SESSION['uid'])->update(['companyName' => $title, 'tagline' => $tagline, 'headColor' => $headColor, 'textColor' => $textColor, 'domainURL' => $maindomain, 'tandc' => $tandc, 'privacy' => $privacy, 'websiteURL' => $system_url .'onepagecheckout/?user='. $_SESSION['uid'] . '']);
            $style = 'active';
        }

        /*if (isset($_POST['create'])) {
            $code = create();
            Capsule::table('vpnDomainVerify')->insert(["uid" => $_SESSION['uid'], "verifyCode" => $code, "status" => "0"]);

            $domain = 'active';
        }
        $VerifyError = '';
        if (isset($_POST['check'])) {
            Capsule::table('vpnmywebsite')->where('uid', $_SESSION['uid'])->update(['websiteURL' => $_POST['domain']]);
            Capsule::table('vpnDomainVerify')->where('uid', $_SESSION['uid'])->update(['status' => '1']);
            $domain = 'active';
        }*/

        if (isset($_POST['addGateways'])) {

            $gateway = $_POST['gateway'];
            $friendlygateway = $_POST['addGateways'];

            $gatewaysList = Capsule::table('tblvpnpaymentgateways')->where("uid", '=', $_SESSION['uid'])->groupby('gateway')->get();

            foreach ($gatewaysList as $list) {

                if ($gateway == 'stripe') {
                    if ($list->gateway == 'authorize') {
                        header("LOCATION:index.php?m=vpnpanel&action=vpnmywebsite&err=authorizeActive");
                        exit;
                    }
                } elseif ($gateway == 'authorize') {
                    if ($list->gateway == 'stripe') {
                        header("LOCATION:index.php?m=vpnpanel&action=vpnmywebsite&err=stripeActive");
                        exit;
                    }
                }
            }


            Capsule::table('tblvpnpaymentgateways')->where("gateway", $gateway)->where('uid', $_SESSION['uid'])->delete();
            //delete_query("tblvpnpaymentgateways", array("gateway" => $gateway));
            ++$lastorder;
            $type = "Invoices";

            if (isset($_POST['_capture']) && $_POST['_capture'] == 'on') {
                $type = "CC";
            }

            Capsule::table('tblvpnpaymentgateways')->insert(["uid" => $_SESSION['uid'], "gateway" => $gateway, "setting" => "name", "value" => $friendlygateway, "order" => $lastorder]);

            if ($GatewayConfig[$gateway]['RemoteStorage']) {
                Capsule::table('tblvpnpaymentgateways')->insert(["uid" => $_SESSION['uid'], "gateway" => $gateway, "setting" => "remotestorage", "value" => "1"]);
            }
            Capsule::table('tblvpnpaymentgateways')->insert(["uid" => $_SESSION['uid'], "gateway" => $gateway, "setting" => "type", "value" => $type]);
            Capsule::table('tblvpnpaymentgateways')->insert(["uid" => $_SESSION['uid'], "gateway" => $gateway, "setting" => "visible", "value" => "on"]);
            $managegateway = 'active';
        }
        if (isset($_POST["rmImage"])) {
            $imageMsg = 'Logo Removed';
            Capsule::table('vpnmywebsite')->where('uid', $_SESSION['uid'])->update(['logo' => '']);
            $style = 'active';
        }

        if (isset($_POST["uploadImage"])) {
            $target_dir = "downloads/";
            $target_file = $target_dir . basename(uniqid() . $_FILES["logo"]["name"]);
            $uploadOk = 1;
            $imageMsg = '';
            $imageFileType = pathinfo($target_file, PATHINFO_EXTENSION);
            $check = getimagesize($_FILES["logo"]["tmp_name"]);

            if ($check !== false) {
                $imageMsg = "File is an image - " . $check["mime"] . ".";
                $uploadOk = 1;
            } else {
                $imageMsg = "File is not an image.";
                $uploadOk = 0;
            }
// Check if file already exists
            if (file_exists($target_file)) {
                $imageMsg = "Sorry, file already exists.";
                $uploadOk = 0;
            }
// Check file size
            if ($_FILES["logo"]["size"] > 1000000) {
                $imageMsg = "Sorry, your file is too large.";
                $uploadOk = 0;
            }
// Allow certain file formats
            if ($imageFileType != "jpg" && $imageFileType != "png" && $imageFileType != "jpeg" && $imageFileType != "gif") {
                $imageMsg = "Sorry, only JPG, JPEG, PNG & GIF files are allowed.";
                $uploadOk = 0;
            }
// Check if $uploadOk is set to 0 by an error
            if ($uploadOk == 0) {

// if everything is ok, try to upload file
            } else {

                if (move_uploaded_file($_FILES["logo"]["tmp_name"], $target_file)) {
                    $imageMsg = "The file " . basename($_FILES["logo"]["name"]) . " has been uploaded.";
                    Capsule::table('vpnmywebsite')->where('uid', $_SESSION['uid'])->update(['logo' => $target_file]);
                } else {
                    $imageMsg = "Sorry, there was an error uploading your file.";
                }
            }
            $style = 'active';
        }
        $productdetils = Capsule::table('tblproducts')->where('id', '=', $_POST['packageid'])->select('configoption2')->get();
        if ($productdetils[0]->configoption2 == 'magdevice') {
            if (empty($_POST['customfields'][$_POST['packageid']][$returndata['custom_field_mag']])) {
                header("LOCATION:index.php?m=vpnpanel&action=adduser&result=macerror");
            }
        } elseif ($productdetils[0]->configoption2 == 'engdevice') {
            if (empty($_POST['customfields'][$_POST['packageid']][$returndata['custom_field_eng']])) {
                header("LOCATION:index.php?m=vpnpanel&action=adduser&result=engerror");
            }
        }
        $clientdata = Capsule::table('tblclients')->where('id', '=', $_SESSION['uid'])->get();
        $product_id = getassignedpackages($_SESSION['uid']);
if(empty($product_id[0]->products))
        {
            $groupid = getclientgroupid('Super-Reseller');
            $product_id = Capsule::table('mod_vpn_assignpackages')->where('resellerid','all')->where('assigngroup',$groupid)->get();
        }
        $products = Capsule::table('tblproducts')
                ->select(Capsule::raw('*'))
                ->whereIn('id', explode(',', $product_id[0]->products))
                ->get();
        /*$xtreamConfig = Capsule::table('mod_xtreamConfig')->get();*/
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        $GatewayValues = $GatewayConfig = $ActiveGateways = $DisabledGateways = array();
        /* $result = select_query("tblvpnpaymentgateways", "", "", "setting", "ASC");

          while ($data = mysql_fetch_array($result)) {
          $gwv_gateway = $data['gateway'];
          $gwv_setting = $data['setting'];
          $gwv_value = $data['value'];
          $GatewayValues[$gwv_gateway][$gwv_setting] = $gwv_value;
          } */
        $result = Capsule::table('tblvpnpaymentgateways')->where('uid', '=', $_SESSION['uid'])->get();
        foreach ($result as $data) {
            $gwv_gateway = $data->gateway;
            $gwv_setting = $data->setting;
            $gwv_value = $data->value;
            $GatewayValues[$gwv_gateway][$gwv_setting] = $gwv_value;
        }
        //print_r($GatewayValues);die();
        $gwdata = Capsule::table('vpnmywebsite')->where('uid', '=', $_SESSION['uid'])->get();
        $gateways = explode(',', $gwdata[0]->gateways);

        foreach ($gateways as $gateway) {
            
        }

        if ($_POST["deactivate"]) {
            $gateway = $_POST['gateway'];
            Capsule::table("tblvpnpaymentgateways")->where("gateway", $gateway)->where("uid", $_SESSION['uid'])->delete();
            $managegateway = 'active';
        }

        if ($_POST['save']) {

            check_token("WHMCS.admin.default");
            $gateway = $_POST['gateway'];
            $module = $_POST['field'];

            $data = Capsule::table("tblvpnpaymentgateways")->where("gateway", $gateway)->where("uid", $_SESSION['uid'])->count();

            if ($data >= 1) {

                foreach ($module as $field => $val) {
                    $data = Capsule::table("tblvpnpaymentgateways")->where("gateway", $gateway)->where("setting", $field)->where('uid', $_SESSION['uid'])->count();
                    // echo $data;die();
                    if ($data >= 1) {
                        Capsule::table('tblvpnpaymentgateways')->where('uid', $_SESSION['uid'])->where('gateway', $gateway)->delete();
                    }

                    Capsule::table('tblvpnpaymentgateways')->insert(['uid' => $_SESSION['uid'], 'gateway' => $gateway, 'setting' => $field, 'value' => $val]);
                }
            }
            header('LOCATION:index.php?m=vpnpanel&action=vpnmywebsite');
            $managegateway = 'active';
        }
        $includedmodules = array();
        $gatewaynames = array();
        $activatedArray = array();
        $dh = opendir("modules/gateways/");

        while (false !== $file = readdir($dh)) {
            $fileext = explode(".", $file, 2);

            if (((trim($file) && $file != "index.php") && $fileext[1] == "php") && !in_array($fileext[0], $includedmodules)) {
                array_push($includedmodules, $fileext[0]);
                $gwv_modulename = $fileext[0];

                if (!isValidforPath($fileext[0])) {
                    exit("Invalid Gateway Module Name");
                }

                require_once ROOTDIR . "/modules/gateways/" . $fileext[0] . ".php";

                if (function_exists($gwv_modulename . "_config")) {

                    $GatewayConfig[$gwv_modulename] = call_user_func($gwv_modulename . "_config");
                    $GatewayFieldDefines = $GatewayConfig[$gwv_modulename];
                    $activatedData = $GatewayConfig[$gwv_modulename];
                    array_push($activatedArray, $activatedData);
                } else {
                    $GatewayFieldDefines = array();
                    $GatewayFieldDefines['FriendlyName'] = array("Type" => "System", "Value" => $GATEWAYMODULE[$gwv_modulename . "visiblename"]);

                    if ($GATEWAYMODULE[$gwv_modulename . "notes"]) {
                        $GatewayFieldDefines['UsageNotes'] = array("Type" => "System", "Value" => $GATEWAYMODULE[$gwv_modulename . "notes"]);
                    }

                    call_user_func($gwv_modulename . "_activate");
                    $GatewayConfig[$gwv_modulename] = $GatewayFieldDefines;
                }
                array_push($gatewaynames, array('displayname' => $GatewayFieldDefines['FriendlyName']['Value'], 'module' => $fileext[0]));
            }
        }

        closedir($dh);

        $paymentDetails = '';
        $count = 1;
        $newgateways = "";
        $data = Capsule::table('tblvpnpaymentgateways')->where('uid', '=', $_SESSION['uid'])->groupby('gateway')->get();


        $numgateways = count(explode(',', $data[0]->gateways));

        $result3 = Capsule::table('tblvpnpaymentgateways')->where('uid', '=', $_SESSION['uid'])->groupby('gateway')->get();

        foreach ($result3 as $data) {
            $module = $data->gateway;
            $order = $data->order;

            $paymentDetails .= "
<form method=\"post\" >
<input type=\"hidden\" name=\"module\" value=\"";
            $paymentDetails .= $module;
            $paymentDetails .= "\">

<p align=\"left\"><b>";
            $paymentDetails .= $count . ". " . $GatewayConfig[$module]['FriendlyName']['Value'];


            $paymentDetails .= " <form method='post' action=''><input type='hidden' name='gateway' value='" . $module . "'><input type='hidden' name='friendlygateway' value='" . $GatewayConfig[$module]['FriendlyName']['Value'] . "'><input type='hidden'name='deactivate' value='deactivate'><input type='submit' value='deactivate'style='border: none;
    background: none;
    color: #f00;'></form>";


            $paymentDetails .= "</b>";
            $paymentDetails .= "</p>
<form method='post' action=''><table class=\"form table-striped table\" width=\"100%\" border=\"0\" cellspacing=\"2\" cellpadding=\"3\">
<input type='hidden' name='gateway' value='" . $module . "'>
<tr><td width=\"200\" class=\"fieldlabel\">";
            $paymentDetails .= "showonorderform";
            $paymentDetails .= "</td><td class=\"fieldarea\"><input type=\"checkbox\" name=\"field[visible]\"";

            if ($GatewayValues[$module]['visible']) {
                $paymentDetails .= " checked";
            }

            $paymentDetails .= " /></td></tr>
<tr><td class=\"fieldlabel\">";
            $paymentDetails .= "displayname";
            $paymentDetails .= "</td><td class=\"fieldarea\"><input type=\"text\" name=\"field[name]\" size=\"30\" value=\"";
            $paymentDetails .= $GatewayValues[$module]['name'];
            $paymentDetails .= "\"></td></tr>
";
            foreach ($GatewayConfig[$module] as $confname => $values) {

                if ($values['Type'] != "System") {
                    $values['Name'] = "field[" . $confname . "]";

                    if (isset($GatewayValues[$module][$confname])) {
                        $values['Value'] = $GatewayValues[$module][$confname];
                    }

                    $paymentDetails .= "<tr><td class=\"fieldlabel\">" . $values['FriendlyName'] . "</td><td class=\"fieldarea\">" . moduleConfigFieldOutput($values) . "</td></tr>";
                    continue;
                }
            }


            if (1 < count($currenciesarray)) {
                $paymentDetails .= "<tr><td class=\"fieldlabel\">" . "currencyconvert" . "</td><td class=\"fieldarea\"><select name=\"field[convertto]\"><option value=\"\">" . "none" . "</option>";
                foreach ($currenciesarray as $currencydata) {
                    $paymentDetails .= "<option value=\"" . $currencydata['id'] . "\"";

                    if ($currencydata['id'] == $GatewayValues[$module]['convertto']) {
                        $paymentDetails .= " selected";
                    }

                    $paymentDetails .= ">" . $currencydata['code'] . "</option>";
                }

                $paymentDetails .= "</select></td></tr>";
            }

            $paymentDetails .= "<tr><td class=\"fieldlabel\"></td><td class=\"fieldarea\"><input type=\"submit\" class=\"btn btn-primary mybtn\" name='save' value=\"";
            $paymentDetails .= "save changes";
            $paymentDetails .= "\">";

            if ($GatewayConfig[$module]['UsageNotes']['Value']) {
                $paymentDetails .= " (" . $GatewayConfig[$module]['UsageNotes']['Value'] . ")";
            }

            $paymentDetails .= "</td></tr>
</table>

<br />

</form>

";

            if ($count != $order) {
                update_query("tblvpnpaymentgateways", array("order" => $count), array("setting" => "name", "gateway" => $module));
            }
            ++$count;
            $newgateways .= "<option value=\"" . $module . "\">" . $GatewayConfig[$module]['FriendlyName']['Value'] . "</option>";
        }

        /* ----------------------------------------------------------------------------- */
        if (isset($_POST['autorenew'])) {
            $resellerid = $_SESSION['uid'];
            $configdata = Capsule::table('tblconfiguration')
                    ->where('setting', 'Reseller' . $resellerid)
                    ->get();
            foreach ($configdata as $configdatavale) {
                $dataconfigp[$configdatavale->setting] = $configdatavale->value;
            }
            if (isset($dataconfigp['Reseller' . $resellerid]) && !empty($dataconfigp['Reseller' . $resellerid])) {
                Capsule::table('tblconfiguration')
                        ->where('setting', 'Reseller' . $resellerid)
                        ->update(['value' => $_POST['renew']]);
            } else {
                Capsule::table('tblconfiguration')->insert(
                        ['setting' => 'Reseller' . $resellerid, 'value' => $_POST['renew']]
                );
            }
            $response['result'] = "success";
            $response['message'] = "<strong>Success!</strong> Auto Renewal feature is " . $_POST['renew'] . "d!";
        }
        $resellerid = $_SESSION['uid'];
        $configdata = Capsule::table('tblconfiguration')
                ->where('setting', 'Reseller' . $resellerid)
                ->get();
        foreach ($configdata as $configdatavale) {
            $dataconfigp[$configdatavale->setting] = $configdatavale->value;
        }
        if (isset($dataconfigp['Reseller' . $resellerid]) && !empty($dataconfigp['Reseller' . $resellerid])) {
            $response['checked'] = $dataconfigp['Reseller' . $resellerid];
        }

        $clientwebsitedata = Capsule::table('vpnmywebsite')->where('uid', '=', $_SESSION['uid'])->get();
        $selectedGateways = array();
        $query1 = Capsule::table('tblvpnpaymentgateways')->where('uid', '=', $_SESSION['uid'])->groupby('gateway')->get();
        foreach ($query1 as $gateways1) {

            array_push($selectedGateways, $gateways1->gateway);
        }
        //$verificationcount = Capsule::table('vpnDomainVerify')->where('uid', '=', $_SESSION['uid'])->count();
        $verificationdata = '';
        /*if ($verificationcount >= 1) {
            $verificationdata = Capsule::table('vpnDomainVerify')->where('uid', '=', $_SESSION['uid'])->get();
        }
*/
        if (!empty($clientwebsitedata[0]->products)) {
            $ResellerProductIdsN = explode(',', $clientwebsitedata[0]->products);
            if (!empty($ResellerProductIdsN)) {
                foreach ($ResellerProductIdsN as $Shortedids) {
                    $products12 = Capsule::table('tblproducts')
                            ->where('id', $Shortedids)
                            ->get();
                    $SortedProductsIds[$products12[0]->id] = $products12[0]->name;
                }
            }
        }

        $sortprodct = "";


        if (isset($_GET['sorted'])) {
            $sortprodct = 'active';
        }



        $EmailSettingSection = "";
        $EmailActionResponse = "";


        if (isset($_GET['emainsaved'])) {
            $EmailSettingSection = 'active';
            if ($_GET['emainsaved'] == "success") {
                $EmailActionResponse = "success";
            } else if ($_GET['emainsaved'] == "error") {
                $EmailActionResponse = "error";
            }
        }

        sort($gatewaynames);
        $modulelink = $vars['modulelink'];
        $response['modulelink'] = $modulelink;
        $response['i'] = 0;
        $response['topup'] = $returndata['gid'];
        $response['optionactive'] = $returndata;
        $response['mywebsite'] = 'class="active"';
        $response['products'] = $products;
        $response['gateways'] = $gatewaynames;
        $response['imgmsg'] = $imageMsg;
        $response['clientData'] = $clientwebsitedata;
        $response['paymentDetails'] = $paymentDetails;
        $response['selectedGateways'] = $selectedGateways;
        $response['verifyData'] = $verificationdata;
        $response['verifyerror'] = $VerifyError;
        $response['productsTab'] = $prodct;
        $response['gatewayTab'] = $managegateway;
        $response['styleTab'] = $style;
        $response['SortedProductsIds'] = $SortedProductsIds;
        $response['sortprodctTab'] = $sortprodct;
        $response['EmailSettingSectionTab'] = $EmailSettingSection;
        $response['EmailActionResponse'] = $EmailActionResponse;
        $response['EmailData'] = self::vpnpanel_GetIPTVemailData();
        $response['selectedProducts'] = explode(',', $clientwebsitedata[0]->products);
        $response['shopingcartactive'] = 'class="active"';

        return array(
            'pagetitle' => 'My Shoping Cart',
            'breadcrumb' => array(
                'index.php?m=vpndashboard' => 'Dashboard',
                'index.php?m=vpnpanel&action=vpnmywebsite' => 'My Shoping Cart',
            ),
            'templatefile' => 'vpnmywebsite',
            'requirelogin' => true, // Set true to restrict access to authenticated client users
            'forcessl' => false, // Deprecated as of Version 7.0. Requests will always use SSL if available.
            'vars' => $response,
        );
    }

    public function vpnpanel_GetIPTVemailData() {
        $returnMessage = "";
        $DefaultEmailData = Capsule::table('tblemailtemplates')->where('name', '=', 'VPN Service Details')->select('message')->get();
        if (!empty($DefaultEmailData)) {
            $returnMessage = $DefaultEmailData[0]->message;
        }
        $emailtemplate = '';
        $messagecount = Capsule::table('tblemailtemplates')->where('name', '=', 'VPN Service Details Reseller' . $_SESSION['uid'])->count();
        if($messagecount == 0)
        {
            $emailtemplate = Capsule::table('tblemailtemplates')->where('name', '=', 'VPN Service Details super Reseller' . $_SESSION['uid'])->select('message')->get();
        }
        else
        {
            $emailtemplate = Capsule::table('tblemailtemplates')->where('name', '=', 'VPN Service Details Reseller' . $_SESSION['uid'])->select('message')->get();
        }

        

        if (!empty($emailtemplate)) {
            if ($emailtemplate[0]->message != "") {
                $returnMessage = $emailtemplate[0]->message;
            }
        }

        return $returnMessage;
    }

    public function vpnpackageprice($vars) {
        $message = '';
        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
        $response = array(
            'modulelink' => $modulelink,);

        if (isset($_POST['updateProduct'])) {

            $count = Capsule::table('vpnpackageprice')->where('products', '=', $_POST['pid'])->where('uid', '=', $_SESSION['uid'])->count();
            if($count >= 1)
            {
                Capsule::table('vpnpackageprice')->where('products', '=', $_POST['pid'])->where('uid', '=', $_SESSION['uid'])->update([
                'priceMonthly' => number_format($_POST['monthly'], 2),
                'priceQuarterly' => number_format($_POST['quarterly'], 2),
                'priceSemiannually' => number_format($_POST['semiannually'], 2),
                'priceAnnually' => number_format($_POST['annually'], 2),
                'priceBiennially' => number_format($_POST['biennially'], 2),
                'priceTriennially' => number_format($_POST['triennially'], 2)]);
            }
            else
            {
                Capsule::table('vpnpackageprice')->insert([
                'uid' => $_SESSION['uid'],
                'products' => $_GET['productedit'],
                'priceMonthly' => number_format($_POST['monthly'], 2),
                'priceQuarterly' => number_format($_POST['quarterly'], 2),
                'priceSemiannually' => number_format($_POST['semiannually'], 2),
                'priceAnnually' => number_format($_POST['annually'], 2),
                'priceBiennially' => number_format($_POST['biennially'], 2),
                'priceTriennially' => number_format($_POST['triennially'], 2)]);

            }
            
            $message ="Price updated successfully";
        }

        $currencydata = Capsule::table('tblclients')->where('id', '=', $_SESSION['uid'])->select('currency')->get();
        $currency = $currencydata[0]->currency;
        $currencydetails = Capsule::table('tblcurrencies')->where('id', '=', $currency)->get();
        $Currencycode = $currencydetails[0]->code;

        $userData = Capsule::table('vpnmywebsite')
                ->where('uid', '=', $_SESSION['uid'])
                ->get();

        $productName = array();
        $priceMonthly = array();
        $priceQuarterly = array();
        $priceSemiannually = array();
        $priceAnnually = array();
        $priceBiennially = array();
        $priceTriennially = array();

        $priceMonthly_org = array();
        $priceQuarterly_org = array();
        $priceSemiannually_org = array();
        $priceAnnually_org = array();
        $priceBiennially_org = array();
        $priceTriennially_org = array();

        foreach ($userData as $products) {
            $myProductsArray = explode(',', $products->products);
            sort($myProductsArray);

            foreach ($myProductsArray as $myProducts) {

                $packagePriceData = Capsule::table('vpnpackageprice')
                        ->where('uid', '=', $_SESSION['uid'])
                        ->where('products', '=', $myProducts)
                        ->orderBy('products', 'asc')
                        ->get();

                foreach ($packagePriceData as $packageData) {
                    $priceMonthly[$myProducts] = $packageData->priceMonthly;
                    $priceQuarterly[$myProducts] =  $packageData->priceQuarterly;
                    $priceSemiannually[$myProducts] =  $packageData->priceSemiannually;
                    $priceAnnually[$myProducts] =  $packageData->priceAnnually;
                    $priceBiennially[$myProducts] = $packageData->priceBiennially;
                    $priceTriennially[$myProducts] = $packageData->priceTriennially;

                }

                $results = Capsule::table('tblproducts')
                            ->join('tblpricing','tblproducts.id','=','tblpricing.relid')
                            ->where('tblproducts.id', $myProducts)
                            ->select(
                                    'tblproducts.*',
                                    'tblpricing.currency as clientcurrency',
                                    'tblpricing.monthly',
                                    'tblpricing.quarterly',
                                    'tblpricing.semiannually',
                                    'tblpricing.annually',
                                    'tblpricing.biennially',
                                    'tblpricing.triennially'
                                    )
                            ->get();
                            /*echo '<pre>';print_r($results); die();*/
                $productName[$myProducts] =  $results[0]->name;
                $priceMonthly_org[$myProducts] = $results[0]->monthly;
                $priceQuarterly_org[$myProducts] = $results[0]->quarterly;
                $priceSemiannually_org[$myProducts] = $results[0]->semiannually;
                $priceAnnually_org[$myProducts] = $results[0]->annually;
                $priceBiennially_org[$myProducts] =  $results[0]->biennially;
                $priceTriennially_org[$myProducts] =  $results[0]->triennially;
            }
        }
        $response['url'] = 'index.php?m=vpnpanel&action=vpnpackageprice';
        $response['products'] = $myProductsArray;
        $response['productName'] = $productName;
        $response['priceMonthly'] = $priceMonthly;
        $response['priceQuarterly'] = $priceQuarterly;
        $response['priceSemiannually'] = $priceSemiannually;
        $response['priceAnnually'] = $priceAnnually;
        $response['priceBiennially'] = $priceBiennially;
        $response['priceTriennially'] = $priceTriennially;
        $response['productName_org'] = $productName;
        $response['priceMonthly_org'] = $priceMonthly_org;
        $response['priceQuarterly_org'] = $priceQuarterly_org;
        $response['priceSemiannually_org'] = $priceSemiannually_org;
        $response['priceAnnually_org'] = $priceAnnually_org;
        $response['priceBiennially_org'] = $priceBiennially_org;
        $response['priceTriennially_org'] = $priceTriennially_org;
        $response['message'] = $message;
        $response['packpriceactive'] = 'class="active"';
        
        return array(
            'pagetitle' => 'Package Price',
            'breadcrumb' => array(
                'index.php?m=vpnpanel' => 'Dashboard',
                'index.php?m=vpnpanel&action=vpnpackageprice' => 'Package Price',
            ),
            'templatefile' => 'vpnpackageprice',
            'requirelogin' => true, // Set true to restrict access to authenticated client users
            'forcessl' => false, // Deprecated as of Version 7.0. Requests will always use SSL if available.
            'vars' => $response,
        );
    
    }

    public function xtreamautorenew($vars) {}

    public function vpninactiveusers($vars) {
        
        $clientdata = Capsule::table('tblclients')->where('id', '=', $_SESSION['uid'])->get();

        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
        
        $email = $clientdata[0]->email;
        
        $TotalUserCount = array(); 
                  
                    $affclients = Capsule::table('tblaffiliatesaccounts')
                            ->where('affiliateid', self::getWHMCSaffid())
                            ->get();
                    foreach ($affclients as $clientdetails) {
                        $clientdetail = self::WHMCSClientDetails($clientdetails->relid);
                        if (isset($clientdetail) && !empty($clientdetail)) {
                            $TotalUserCount[$clientdetails->relid] = $clientdetails->relid;
                        }
                        $resellerdata2 = self::WHMCSClientResellerDetails($clientdetails->relid);
                        if (isset($resellerdata2) && !empty($resellerdata2)) {
                            $ResellerUsers[$clientdetails->relid] = $clientdetails->relid;
                        }
                    }
                

                $TrialServices = $AllFreeServices = Capsule::table('tblhosting')
                        ->join('tblproducts', 'tblhosting.packageid', '=', 'tblproducts.id')
                        ->join('tblclients', 'tblclients.id', '=', 'tblhosting.userid')
                        ->whereIn('tblhosting.userid', $TotalUserCount)
                        ->select('tblproducts.name', 'tblhosting.id', 'tblhosting.domainstatus', 'tblhosting.nextduedate', 'tblhosting.username', 'tblclients.*')
                        ->get();
                        $clientsData1 = array();
        //echo '<pre>';print_r($TrialServices); die(sdf);
        $i = 0;
        foreach($TrialServices as $client1)
        {
            $i++;
            $clientsData1[$i]['client_id'] = $client1->id;
            $clientsData1[$i]['firstname'] = $client1->firstname;
            $clientsData1[$i]['lastname'] = $client1->lastname;
            $clientsData1[$i]['email'] = $client1->email;
            $clientsData1[$i]['nextduedate'] = $client1->nextduedate;
            $clientsData1[$i]['status'] = ($client1->domainstatus == 'Active')?'<span class="label label-success">Active</span>':'<span class="label label-danger">'.$client1->domainstatus.'<span>';
            $clientsData1[$i]['username'] = $client1->username;
            /*$clientsData1[$i]['password'] = $client1->password;*/
            $clientsData1[$i]['name'] = $client1->name;
                
        }

        $response['listinactive'] = 'class="active"';
        $response['modulelink'] = $modulelink;
        $response['servicedetails'] = $clientsData1;
        return array(
            'pagetitle' => 'Client Details',
            'breadcrumb' => array(
                'index.php?m=vpnpanel' => 'Xtream Dashboard Module',
                'index.php?m=vpnpanel&action=xtreamservices' => 'Xtream Services Page',
            ),
            'templatefile' => 'vpnservices',
            'requirelogin' => true, // Set true to restrict access to authenticated client users
            'forcessl' => false, // Deprecated as of Version 7.0. Requests will always use SSL if available.
            'vars' => $response,
        );
    }

    public function services($vars) {
        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule 
        $con = self::XtreamDashboard_testconnection();
        /*
         * Reseller Clients
         */
        /*$xtreamConfig = Capsule::table('mod_xtreamConfig')->get();*/
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        if (isset($_POST['customAction']) && $_POST['customAction'] == 'addMAG') {
            $newmac = $_POST['newMAC'];
            $result = self::XtreamDashboard_AddMAG($_POST, $newmac);
            if ($result == 'success') {
                $response['result'] = "success";
                $response['message'] = "<strong>Success!</strong> MAG Device Added Successfully!";
            } else {
                $response['result'] = "danger";
                $response['message'] = "<strong>Error!</strong> " . $result;
            }
        } elseif (isset($_POST['customAction']) && $_POST['customAction'] == 'changeMAG') {
            $newmac = $_POST['newMAC'];
            $result = self::XtreamDashboard_ChangeMAG($_POST, $newmac);
            if ($result == 'success') {
                $response['result'] = "success";
                $response['message'] = "<strong>Success!</strong> MAG Device Updated Successfully!";
            } else {
                $response['result'] = "danger";
                $response['message'] = "<strong>Error!</strong> " . $result;
            }
        } elseif (isset($_POST['customAction']) && $_POST['customAction'] == 'addENG') {
            $newmac = $_POST['newMAC'];
            $result = self::XtreamDashboard_AddENG($_POST, $newmac);
            if ($result == 'success') {
                $response['result'] = "success";
                $response['message'] = "<strong>Success!</strong> MAG Device Added Successfully!";
            } else {
                $response['result'] = "danger";
                $response['message'] = "<strong>Error!</strong> " . $result;
            }
        } elseif (isset($_POST['customAction']) && $_POST['customAction'] == 'changeENG') {
            $newmac = $_POST['newMAC'];
            $result = self::XtreamDashboard_ChangeENG($_POST, $newmac);
            if ($result == 'success') {
                $response['result'] = "success";
                $response['message'] = "<strong>Success!</strong> MAG Device Updated Successfully!";
            } else {
                $response['result'] = "danger";
                $response['message'] = "<strong>Error!</strong> " . $result;
            }
        } elseif (isset($_POST['customAction']) && $_POST['customAction'] == 'ModuleSuspend') {
            $command = 'ModuleSuspend';
            $postData = array(
                'accountid' => $_POST['serviceid'],
                'suspendreason' => "Suspend by Reseller",
            );
            $admin = Capsule::table('tbladmins')
                    ->where('roleid', '=', 1)
                    ->get();
            $adminUsername = $admin[0]->username;
            $results = localAPI($command, $postData, $adminUsername);
            if (isset($results) && $results['result'] == 'success') {
                $response['result'] = "success";
                $response['message'] = "<strong>Success!</strong> Service Suspend Successfully!";
            } else {
                $response['result'] = "danger";
                $response['message'] = "<strong>Error!</strong> " . $results['message'];
            }
        } elseif (isset($_POST['customAction']) && $_POST['customAction'] == 'ModuleUnsuspend') {
            $command = 'ModuleUnsuspend';
            $postData = array(
                'accountid' => $_POST['serviceid'],
            );
            $admin = Capsule::table('tbladmins')
                    ->where('roleid', '=', 1)
                    ->get();
            $adminUsername = $admin[0]->username;
            $results = localAPI($command, $postData, $adminUsername);
            if (isset($results) && $results['result'] == 'success') {
                $response['result'] = "success";
                $response['message'] = "<strong>Success!</strong>Service Unsuspend Successfully!";
            } else {
                $response['result'] = "danger";
                $response['message'] = "<strong>Error!</strong> " . $results['message'];
            }
        } elseif (isset($_POST['customAction']) && $_POST['customAction'] == 'ModuleTerminate') {
            $command = 'ModuleTerminate';
            $postData = array(
                'accountid' => $_POST['serviceid'],
            );
            $admin = Capsule::table('tbladmins')
                    ->where('roleid', '=', 1)
                    ->get();
            $adminUsername = $admin[0]->username;
            $results = localAPI($command, $postData, $adminUsername);
            if (isset($results) && $results['result'] == 'success') {
                $response['result'] = "success";
                $response['message'] = "<strong>Success!</strong>Service Terminate Successfully!";
            } else {
                $response['result'] = "error";
                $response['message'] = "<strong>Error!</strong> " . $results['message'];
            }
        } elseif (isset($_POST['customAction']) && $_POST['customAction'] == 'ModuleRemove') {
            $affdetails = self::CheckAffCredit();
            $tblhostingdetails = Capsule::table('tblhosting')->where('id', '=', $_POST['serviceid'])->get();
            $admin = Capsule::table('tbladmins')
                    ->where('roleid', '=', 1)
                    ->get();
            $adminUsername = $admin[0]->username;
            $ModuleTerminate = 'ModuleTerminate';
            $ModuleTerminateData = array(
                'accountid' => $_POST['serviceid'],
            );
            localAPI($ModuleTerminate, $ModuleTerminateData, $adminUsername);
            $PendingOrder = 'PendingOrder';
            $PendingOrderData = array(
                'orderid' => $tblhostingdetails[0]->orderid,
            );
            localAPI($PendingOrder, $PendingOrderData, $adminUsername);
            $command = 'CancelOrder';
            $postData = array(
                'orderid' => $tblhostingdetails[0]->orderid,
            );
            $results = localAPI($command, $postData, $adminUsername);
            if (isset($results) && $results['result'] == 'success') {
                $DeleteOrder = 'DeleteOrder';
                $delete = localAPI($DeleteOrder, $postData, $adminUsername);
                if (isset($delete) && $delete['result'] == 'success') {
                    $response['result'] = "success";
                    $response['message'] = "<strong>Success!</strong> Service Remove Successfully!";
                    logModuleCall('XtreamCode', 'Service Deleted', 'This  Order Id : ' . $tblhostingdetails[0]->orderid . ' has been deleted by reseller' . $affdetails->firstname . ' ' . $affdetails->lastname . "(" . $affdetails->email . ")", $delete, '', '');
                } else {
                    $response['result'] = "danger";
                    logModuleCall('XtreamCode', 'Service Deleted', 'Order Id : ' . $tblhostingdetails[0]->orderid, "<strong>Error!</strong> " . $delete['message'], '', '');
                    $response['message'] = "<strong>Error!</strong> " . $delete['message'];
                }
            } else {
                $response['result'] = "error";
                $response['message'] = "<strong>Error!</strong> " . $results['message'];
            }
        } elseif (isset($_POST['customAction']) && $_POST['customAction'] == 'ModuleRenew') {
            $resellerid = $_SESSION['uid'];
            $configdata = Capsule::table('tblconfiguration')
                    ->where('setting', 'Reseller' . $resellerid)
                    ->get();
            foreach ($configdata as $configdatavale) {
                $dataconfigp[$configdatavale->setting] = $configdatavale->value;
            }
            if (isset($dataconfigp['Reseller' . $resellerid]) && !empty($dataconfigp['Reseller' . $resellerid])) {
                $checked = $dataconfigp['Reseller' . $resellerid];
            }
            if ($checked == 'Disable') {
                $admin = Capsule::table('tbladmins')
                        ->where('roleid', '=', 1)
                        ->get();
                $adminUsername = $admin[0]->username;
                $invoices = Capsule::table('tblinvoiceitems')
                        ->join('tblinvoices', 'tblinvoiceitems.invoiceid', '=', 'tblinvoices.id')
                        ->where('tblinvoices.status', '=', 'Unpaid')
                        ->where('tblinvoiceitems.type', '=', 'Hosting')
                        ->where('tblinvoiceitems.relid', '=', $_POST['serviceid'])
                        ->get();
                if (isset($invoices) && !empty($invoices)) {
                    foreach ($invoices as $invoice) {
                        $getinvoice = localAPI('GetInvoice', array('invoiceid' => $invoice->invoiceid), $adminUsername);
                        if ($getinvoice['status'] != 'Paid') {
                            //Check if client is related to Reseller 
                            $userid = $getinvoice['userid'];
                            $checkdetials = Capsule::table('tblaffiliates')
                                    ->where('clientid', '=', $userid)
                                    ->get();
                            if (isset($checkdetials) && !empty($checkdetials)) {
                                //Get Affiliates details  
                                $getAffiliates = Capsule::table('tblaffiliates')
                                        ->where('id', '=', $checkdetials[0]->affiliatesid)
                                        ->get();
                                if (isset($getAffiliates) && !empty($getAffiliates)) {
                                    $credit = Capsule::table('tblclients')
                                            ->select('credit', 'firstname', 'lastname', 'email')
                                            ->where('id', '=', $getAffiliates[0]->clientid)
                                            ->get();
                                    $admin = Capsule::table('tbladmins')
                                            ->where('roleid', '=', 1)
                                            ->get();
                                    $adminUsername = $admin[0]->username;
                                    $affdetails = $credit[0];
                                    $add_credit = $getinvoice['total'];
                                    if ($affdetails->credit > $add_credit) {
                                        $AddCredit = 'AddCredit';
                                        $postData = array(
                                            'clientid' => $userid,
                                            'description' => 'Added funds by ' . $affdetails->firstname . ' ' . $affdetails->lastname,
                                            'amount' => $add_credit,
                                        );
                                        $resultsCredit = localAPI($AddCredit, $postData, $adminUsername);
                                        if ($resultsCredit['result'] == 'success') {
                                            Capsule::table('tblcredit')->insert(
                                                    ['clientid' => $getAffiliates[0]->clientid, 'date' => date('Y-m-d'), 'description' => 'Add Credit to Client - ' . $userid, 'amount' => -$add_credit]
                                            );
                                            $removeCredit = $affdetails->credit - $add_credit;
                                            Capsule::table('tblclients')
                                                    ->where('id', '=', $getAffiliates[0]->clientid)
                                                    ->update(
                                                            [
                                                                'credit' => $removeCredit,
                                                            ]
                                            );
                                            $command = 'ApplyCredit';
                                            $postData = array(
                                                'invoiceid' => $invoice->invoiceid,
                                                'amount' => $add_credit,
                                            );
                                            $results = localAPI($command, $postData, $adminUsername);
                                            if ($results['result'] == 'success') {
                                                self::RemoveXtreamCredit($add_credit, $con);
                                            }
                                            logModuleCall('Stalker Dashboard', 'ApplyCredit', $postData, $results, '', '');
                                        }
                                    } else {
                                        $response['result'] = "error";
                                        $response['message'] = "<strong>Error!</strong>You don't have sufficient balance ! Click here to <a href='cart.php?gid=" . (!empty($returndata['gid']) ? $returndata['gid'] : 'addons') . "'> Click here </a> to add credits";
                                    }
                                }
                            }
                        }
                    }
                    if (isset($results) && $results['result'] == 'success') {
                        $response['result'] = "success";
                        $response['message'] = "<strong>Success!</strong> Service Renew Successfully!";
                    } else {
                        $response['result'] = "error";
                        $response['message'] = "<strong>Error!</strong> " . $results['message'];
                    }
                } else {
                    $response['result'] = "info";
                    $response['message'] = "<strong>Info!</strong> It can't be renewed at this stage";
                }
            }
        }
        $selectedclientservices = self::WHMCSClientServices($_GET['userid']);
        /* echo "<pre>";print_r($selectedclientservices);die(); */
        if ($selectedclientservices['result'] == 'success') {
            $clientdata = Capsule::table('tblclients')->where('id', '=', $_SESSION['uid'])->get();
            $email = $clientdata[0]->email;
# Inserting Now New User into 
// First checking if user already exist with reqeuest username  
            $result = mysqli_query($con, "SELECT id FROM reg_users WHERE email='$email'");
            if (!$result) {
                $radiussqlerror = mysqli_error($con);
                self::XtreamCode_WHMCSReconnect();
                logModuleCall('XtreamCode', 'Check Reseller Exists', 'Email Address : ' . $email, "XtreamCode Database Query Error: " . $radiussqlerror, '', '');
                return true;
            }
            $response['resellermag'] = '';
            if (mysqli_num_rows($result) > 0) {
                $resellerdata = mysqli_fetch_assoc($result);
                if (isset($clientdata[0]->groupid) && !empty($clientdata[0]->groupid)) {
                    $clientgrop = Capsule::table('tblclientgroups')->where('id', '=', $clientdata[0]->groupid)->get();
                    if ($clientgrop[0]->groupname == 'Super-Reseller') {
                        $checkReseller = self::CheckSelectedClientReseller($selectedclientservices['clientid']);
                        if ($checkReseller == 'Reseller' || $checkReseller == 'Super-Reseller') {
                            foreach ($selectedclientservices['products']['product'] as $service) {
                                $configoption = Capsule::table('tblproducts')->where('id', '=', $service['pid'])->select('configoption13')->get();
                                $users = mysqli_query($con, "SELECT id as xtreamid,username as xtreamusername,password as xtreampassword FROM `reg_users` WHERE owner_id = '" . $resellerdata['id'] . "' AND member_group_id='" . $configoption[0]->configoption13 . "' AND notes = '" . $returndata['common_identifier'] . "" . $_GET['userid'] . "' AND email='" . $service['username'] . "'");
                                $totalusers = mysqli_num_rows($users);
                                if ($totalusers > 0) {
                                    while ($xtremservice = mysqli_fetch_assoc($users)) {
                                        $xtremservices = array_merge($xtremservice, array('xtreampassword' => 'amanpreet11', 'mag_device' => '-', 'is_trial' => '-',
                                            'is_mag' => '-'));
                                        $servicesdetails[] = array_merge($service, $xtremservices);
                                    }
                                } else {
                                    $data = array('xtreamusername' => '-',
                                        'xtreampassword' => '-',
                                        'is_trial' => '-',
                                        'is_mag' => '-',
                                        'mag_device' => '-');
                                    $servicesdetails[] = array_merge($service, $data);
                                }
                            }
                            $response['resellermag'] = 'reseller';
                        } else {
                            $resultresponse = self::XtreamServices($selectedclientservices, $resellerdata, $con);
                            $response['response'] = $resultresponse['response'];
                            $servicesdetails = $resultresponse['servicesdetails'];
                        }
                    } else {
                        $resultresponse = self::XtreamServices($selectedclientservices, $resellerdata, $con);
                        $response['response'] = $resultresponse['response'];
                        $servicesdetails = $resultresponse['servicesdetails'];
                    }
                }
            }
        }
        $i = 0;
        foreach ($servicesdetails as $Servicekey) {
            $CheckUpgradePackage = Capsule::table('tblproduct_upgrade_products')->where('product_id', '=', $Servicekey['pid'])->count();
            if ($CheckUpgradePackage > 0) {
                $servicesdetails[$i]['upgrade'] = 'yes';
            } else {
                $servicesdetails[$i]['upgrade'] = 'no';
            }
            $invoicesUn = Capsule::table('tblinvoiceitems')
                    ->join('tblinvoices', 'tblinvoiceitems.invoiceid', '=', 'tblinvoices.id')
                    ->where('tblinvoices.status', '=', 'Unpaid')
                    ->where('tblinvoiceitems.type', '=', 'Hosting')
                    ->where('tblinvoiceitems.relid', '=', $Servicekey['id'])
                    ->get();
            if (isset($invoicesUn) && !empty($invoicesUn)) {
                $servicesdetails[$i]['showrenew'] = 'yes';
            } else {
                $servicesdetails[$i]['showrenew'] = 'no';
            }



            $i++;
        }
        $resellerid = $_SESSION['uid'];
        $configdata = Capsule::table('tblconfiguration')
                ->where('setting', 'Reseller' . $resellerid)
                ->get();
        foreach ($configdata as $configdatavale) {
            $dataconfigp[$configdatavale->setting] = $configdatavale->value;
        }
        if (isset($dataconfigp['Reseller' . $resellerid]) && !empty($dataconfigp['Reseller' . $resellerid])) {
            $checked = $dataconfigp['Reseller' . $resellerid];
        }
        $response['action'] = '';
        if ($returndata['reseller_susp'] == 'on' || $returndata['reseller_unsusp'] == 'on' || $returndata['reseller_term'] == 'on' || $returndata['reseller_remove'] == 'on' || $checked == 'Disable')
            $response['action'] = 'enable';

        $access_output = mysqli_query($con, "SELECT * FROM access_output");

        while ($output = mysqli_fetch_assoc($access_output)) {
            if ($output['output_name'] == 'MPEGTS') {
                $outputfirst = $output['output_key'];
            }
            $access_outputdata[] = $output;
        }
        if (empty($outputfirst)) {
            $outputfirst = array_values($access_outputdata)[0]['output_key'];
        }
        self::XtreamCode_WHMCSReconnect();
        $xtreamautoscipt = Capsule::table('mod_xtreamautoscript')->get();
        foreach ($xtreamautoscipt as $value) {
            $autoscript[$value->name] = $value->value;
        }
        $clintID = $servicesdetails[0]['clientid'];

        $clients_detail[] = self::WHMCSClientDetails($clintID);
        /* echo "<pre>";print_r($servicesdetails);die(); */
        $response['listactive'] = 'class="active"';
        $response['modulelink'] = $modulelink;
        $response['userdetails'] = $clients_detail;
        $response['services'] = $servicesdetails;
        $response['CurrentOpen_User'] = $_GET['userid'];
        $response['checked'] = $checked;
        $response['lang'] = $returndata;
        $response['m3ulinkoutput'] = (isset($outputfirst) && !empty($outputfirst) ? $outputfirst : 'xxx');
        $response['accessoutput'] = $access_outputdata;
        $response['topup'] = $returndata['gid'];
        $response['autoscript'] = $autoscript;
        return array(
            'pagetitle' => 'Client Details',
            'breadcrumb' => array(
                'index.php?m=xtreamdashboard' => 'Xtream Dashboard Module',
                'index.php?m=xtreamdashboard&action=xtreamservices' => 'Xtream Services Page',
            ),
            'templatefile' => 'xtreamservices',
            'requirelogin' => true, // Set true to restrict access to authenticated client users
            'forcessl' => false, // Deprecated as of Version 7.0. Requests will always use SSL if available.
            'vars' => $response,
        );
    }

    public function GetFinalPriceProducts($ProductId = "", $UserId = "") {
        $PricingArraySetArray = array('msetupfee', 'qsetupfee', 'ssetupfee', 'asetupfee', 'bsetupfee', 'tsetupfee', 'monthly', 'quarterly', 'semiannually', 'annually', 'biennially', 'triennially');

        $periodtimeArrayInmonth = array(
            'monthly' => '1',
            'quarterly' => '3',
            'semiannually' => '6',
            'annually' => '12',
            'biennially' => '24',
            'triennially' => '36'
        );

        $currencydata = Capsule::table('tblclients')->where('id', '=', $UserId)->select('currency')->get();
        $currency = $currencydata[0]->currency;
        $currencydetails = Capsule::table('tblcurrencies')->where('id', '=', $currency)->get();
        $billingcycle[$ProductId] = self::getProductBillingCycle($ProductId, $currency);
        $Currencyprefix = $currencydetails[0]->prefix;
        $Currencycode = $currencydetails[0]->code;
        $FinalPriceArray = array();
        foreach ($PricingArraySetArray as $SetPriceKey) {
            if ($billingcycle[$ProductId][0]->$SetPriceKey > 0.00) {
                $SetPriceKeyKey = $SetPriceKey;
                $periodtime = "";
                if ($billingcycle[$ProductId][0]->paytype == 'onetime') {
                    $SetPriceKeyKey = "onetime";
                    $periodtime = "onetime";
                } else {
                    $periodtime = $periodtimeArrayInmonth[$SetPriceKey];
                }
                $FinalPriceArray[$SetPriceKeyKey] = array(
                    'prefix' => $Currencyprefix,
                    'code' => $Currencycode,
                    'periodtime' => $periodtime,
                    'Price' => $billingcycle[$ProductId][0]->$SetPriceKey
                );
            }
        }

        return $FinalPriceArray;
    }

    public function GetDayesByDateDiff($strDateFrom, $strDateTo) {
        $date1 = date_create($strDateFrom);
        $date2 = date_create($strDateTo);
        $diff = date_diff($date1, $date2);
        return $diff->format("%a");
    }

    public function showorder() {

        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule

        $TemplateName = "xtreamshoworder";
        $UpdatedProductDetails = array();
        $ordernum = "";
        $error = "";
        $uid = "";
        if (isset($_GET['pid']) && $_GET['pid'] != "") {
            $UpdatedProductDetails = Capsule::table('tblproducts')
                    ->join('tblproductgroups', 'tblproducts.gid', '=', 'tblproductgroups.id')
                    ->select('tblproducts.id as product_id', 'tblproducts.name as product_name', 'tblproductgroups.name as group_name')
                    ->where('tblproducts.id', $_GET['pid'])
                    ->get();
        }

        if (isset($_GET['ordernum']) && $_GET['ordernum'] != "" && isset($_GET['status']) && $_GET['status'] == "success") {
            $ordernum = $_GET['ordernum'];
        }

        if (isset($_GET['status']) && $_GET['status'] == "error") {
            $error = 'Something goes worng during upgrading.';
        }
        if (isset($_GET['uid']) && $_GET['uid'] != "") {
            $uid = $_GET['uid'];
        }

        $response['uid'] = $uid;
        $response['UpdatedProductDetails'] = $UpdatedProductDetails;
        $response['error'] = $error;
        $response['ordernum'] = $ordernum;
        return array(
            'pagetitle' => 'Client Details',
            'breadcrumb' => array(
                'index.php?m=xtreamdashboard' => 'Xtream Dashboard Module',
                'index.php?m=xtreamdashboard&action=xtreamupgrade' => 'Xtream showorder Page',
            ),
            'templatefile' => $TemplateName,
            'requirelogin' => true, // Set true to restrict access to authenticated client users
            'forcessl' => false, // Deprecated as of Version 7.0. Requests will always use SSL if available.
            'vars' => $response,
        );
    }

    public function xtreamupgrade($vars) {
        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule

        $TemplateName = "xtreamupgradepackage";
        if (isset($_GET['service']) && !empty($_GET['service'])) {
            $ServiceId = $_GET['service'];
            $CurrentProductServiceData = Capsule::table('tblhosting')
                    ->join('tblproducts', 'tblhosting.packageid', '=', 'tblproducts.id')
                    ->join('tblproductgroups', 'tblproducts.gid', '=', 'tblproductgroups.id')
                    ->select('tblhosting.*', 'tblproducts.id as product_id', 'tblproducts.name as product_name', 'tblproductgroups.name as group_name')
                    ->where('tblhosting.id', $ServiceId)
                    ->get();
            if (!empty($CurrentProductServiceData)) {
                $ProductId = $CurrentProductServiceData[0]->product_id;
                $Userid = $CurrentProductServiceData[0]->userid;
                $UgradeProductsPrice = Capsule::table('tblproduct_upgrade_products')
                        ->join('tblproducts', 'tblproduct_upgrade_products.upgrade_product_id', '=', 'tblproducts.id')
                        ->join('tblproductgroups', 'tblproducts.gid', '=', 'tblproductgroups.id')
                        ->select('tblproducts.id as product_id', 'tblproducts.name as product_name', 'tblproducts.description as product_description', 'tblproductgroups.name as group_name')
                        ->where('tblproduct_upgrade_products.product_id', $ProductId)
                        ->get();


                $upgradefinaldetailsarray = array();
                foreach ($UgradeProductsPrice as $upProductdetails) {
                    $ProductIdu = $upProductdetails->product_id;
                    $Productnameu = $upProductdetails->product_name;
                    $Productdescription = $upProductdetails->product_description;
                    if ($Productdescription != "") {
                        $ExplaodedDescription = explode("\n", $Productdescription);
                        if (!empty($ExplaodedDescription)) {
                            $Productdescription = "";
                            foreach ($ExplaodedDescription as $DevValue) {
                                $Productdescription .= $DevValue . "<br>";
                            }
                        }
                    }
                    $groupname = $upProductdetails->group_name;
                    $FinalPriceArrayGet = self::GetFinalPriceProducts($ProductIdu, $Userid);
                    $upgradefinaldetailsarray[$ProductIdu] = array(
                        'groupname' => $groupname,
                        'productname' => $Productnameu,
                        'productdescription' => $Productdescription,
                        'price' => $FinalPriceArrayGet
                    );
                }
                if (isset($_POST['proceedupgrade'])) {
                    $TemplateName = "xtreamupgradepayment";
                    $TodayDate = date('Y-m-d');
                    /* ------------Current Package details ----------------------------------- */

                    $CurrentPackagePrice = $CurrentProductServiceData[0]->amount;
                    if ($CurrentProductServiceData[0]->billingcycle == "One Time") {
                        $CurrentPackagePrice = $CurrentProductServiceData[0]->firstpaymentamount;
                    }

                    $RegDate = $CurrentProductServiceData[0]->regdate;                                   //Start Package Date of Current package .

                    $NextDueDate = $CurrentProductServiceData[0]->nextduedate;                           //Next Due date of current package .

                    $TotalDaysDIff = self::GetDayesByDateDiff($RegDate, $NextDueDate);                    //Get Days between start date and due date(end date) .

                    $PerDaysPriceWithExistingPackage = $CurrentPackagePrice / $TotalDaysDIff;    //Get per days price of current package.

                    $UsedOldPackageDays = self::GetDayesByDateDiff($RegDate, $TodayDate);      //Get the used days of old package .
                    if ($UsedOldPackageDays == 0) {
                        $UsedOldPackageDays = 1;
                    }
                    $UsedAmmountOdOldPackage = $PerDaysPriceWithExistingPackage * $UsedOldPackageDays;  //Get The used ammount of current package. 


                    $Balanceammount = $CurrentPackagePrice - $UsedAmmountOdOldPackage;  //Get The used ammount of current package. 

                    /* --------------------------Selected package details------------------------------ */
                    $SelectedPackage = $_POST['SelectPackage'];                                 //Selected upgrade package .

                    $ExplodedSelected = explode(",", $SelectedPackage);                          //Explode upgrade package details.

                    $UpGradePackagePrice = $ExplodedSelected[0];                                //Get The selected upgrade product price.

                    $UpGradebillingcycle = $ExplodedSelected[1];                                //Get The selected upgrade product billingcycle.    

                    $UpGradePackageId = $ExplodedSelected[2];                                   //Get The selected upgrade product packageid.

                    $UpGradePackageMonths = $ExplodedSelected[3];                                   //Get The selected upgrade product packageid.

                    $prefixCurrency = $ExplodedSelected[4];                                   //Get The selected upgrade product packageid.

                    $codecurrency = $ExplodedSelected[5];                                   //Get The selected upgrade product packageid.

                    $NextDUeDateNewPackahge = date('Y-m-d', strtotime($RegDate . " + " . $UpGradePackageMonths . " months")); // Next expected due date of new selected package .

                    $TotalDaysDIffNewPackage = self::GetDayesByDateDiff($RegDate, $NextDUeDateNewPackahge);   //Get Days between start date and due date(end date) . 

                    $PerDaysAmmountForNewPackage = $UpGradePackagePrice / $TotalDaysDIffNewPackage;             //Get Perday price of new package.

                    $UsedAmmountOdOldPackageForNewPackage = $PerDaysAmmountForNewPackage * $UsedOldPackageDays; //Used days ammount of new package.

                    $ReducedAmount = $UpGradePackagePrice - $Balanceammount;  //ReducedAmount after subtract balance amount of old package after userd from new package ammount .

                    $FinalAmmountofNewPackage = $ReducedAmount - $UsedAmmountOdOldPackageForNewPackage;            //Final ammount of new upgrade package.

                    $newproductdetails = Capsule::table('tblproducts')
                            ->select('tblproducts.*')
                            ->where('id', $UpGradePackageId)
                            ->get();

                    $response['UpgradePeriod'] = $UpGradePackageMonths . " Months";
                    $response['UpGradebillingcycle'] = $UpGradebillingcycle;
                    $response['newproductdetails'] = $newproductdetails;
                    $response['FinalAmmountofNewPackage'] = round($FinalAmmountofNewPackage, 2);
                    $response['prefixCurrency'] = $prefixCurrency;
                    $response['codecurrency'] = $codecurrency;
                }
                if (isset($_POST['upgradenow'])) {
                    /* echo "<pre>";print_r($_POST);die(); */
                    $affdetails = self::CheckAffCredit();
                    $UserDetailsGet = Capsule::table('tblclients')
                            ->where('id', $Userid)
                            ->get();
                    $results = array();
                    $AdminName = self::GetAdminName();
                    $command = 'UpgradeProduct';
                    $postData = array(
                        'serviceid' => $_POST['serviceid'],
                        'paymentmethod' => $_POST['paymentmethod'],
                        'newproductbillingcycle' => $_POST['newproductbillingcycle'],
                        'type' => $_POST['type'],
                        'calconly' => '0',
                        'newproductid' => $_POST['newproductid'],
                    );
                    $results = localAPI($command, $postData, $AdminName);
                    $link = "";
                    logModuleCall('Xtream Dashboard', 'Upgrade package', $postData, $results, '', '');
                    if ($results['result'] == 'success') {
                        $command = 'ModuleChangePackage';
                        $postData = array(
                            'accountid' => $_POST['serviceid'],
                        );

                        $resultsChangePackage = localAPI($command, $postData, self::GetAdminName());
                        logModuleCall('Xtream Dashboard', 'Change package', $postData, $resultsChangePackage, '', '');
                        if ($resultsChangePackage['result'] == 'success') {
                            self::WHMCSdoLogin();
                            $InvoiceId = $results['invoiceid'];
                            $OrderNumber = $results['order_number'];
                            $invoiceTotal = Capsule::table('tblinvoices')->where('id', '=', $InvoiceId)->select('tblinvoices.total')->get();
                            $add_credit = $invoiceTotal[0]->total;
                            self::WHMCSdoLogin();
                            $AddCredit = 'AddCredit';
                            $postData = array(
                                'clientid' => $UserDetailsGet[0]->id,
                                'description' => 'Added funds by ' . $UserDetailsGet[0]->firstname . ' ' . $UserDetailsGet[0]->lastname,
                                'amount' => $add_credit,
                            );
                            $resultsCredit = localAPI($AddCredit, $postData, $AdminName);

                            if ($resultsCredit['result'] == 'success') {
                                Capsule::table('tblcredit')->insert(
                                        ['clientid' => $_SESSION['uid'], 'date' => date('Y-m-d'), 'description' => 'Add Credit to Client - ' . $UserDetailsGet[0]->id, 'amount' => -$add_credit]
                                );
                                $removeCredit = $affdetails->credit - $add_credit;
                                self::RemoveWHMCSCredit($removeCredit);
                                /**
                                 * Remove Credits in X.C
                                 */
                                $con = self::XtreamDashboard_testconnection();
                                self::RemoveXtreamCredit($add_credit, $con);

                                self::WHMCSdoLogin();
                                $command = 'ApplyCredit';
                                $postData = array(
                                    'invoiceid' => $InvoiceId,
                                    'amount' => $invoiceTotal[0]->total,
                                );
                                $results = localAPI($command, $postData, $AdminName);
                                if ($results['result'] == 'success') {
                                    self::WHMCSdoLogin();
                                    $link = "?m=xtreamdashboard&action=showorder&pid=" . $_POST['newproductid'] . "&uid=" . $Userid . "&ordernum=" . $OrderNumber . "&status=success";
                                } else {
                                    self::WHMCSdoLogin();
                                    $link = "?m=xtreamdashboard&action=showorder&pid=" . $_POST['newproductid'] . "&uid=" . $Userid . "&status=error";
                                }
                                logModuleCall('Xtream Dashboard', 'ApplyCredit', $postData, $results, '', '');
                                self::WHMCSdoLogin();
                            } else {
                                self::WHMCSdoLogin();
                                $link = "?m=xtreamdashboard&action=showorder&pid=" . $_POST['newproductid'] . "&uid=" . $Userid . "&status=error";
                            }
                        } else {
                            self::WHMCSdoLogin();
                            $link = "?m=xtreamdashboard&action=showorder&pid=" . $_POST['newproductid'] . "&uid=" . $Userid . "&status=error";
                        }
                    } else {
                        self::WHMCSdoLogin();
                        $link = "?m=xtreamdashboard&action=showorder&pid=" . $_POST['newproductid'] . "&uid=" . $Userid . "&status=error";
                    }

                    echo '<script type="text/javascript">
                           window.location = "' . $link . '"
                      </script>';

                    die();
                }


                $PaymentCommandcommand = 'GetPaymentMethods';
                $postData = array(
                );
                $adminUsername = self::GetAdminName(); // Optional for WHMCS 7.2 and later

                $GetPaymentsresults = localAPI($PaymentCommandcommand, $postData, $adminUsername);

                $response['DefaultPaymentMethod'] = $GetPaymentsresults['paymentmethods']['paymentmethod'][0]['module'];
                $response['CurrentProductServiceData'] = $CurrentProductServiceData;
                $response['upgradefinaldetailsarray'] = $upgradefinaldetailsarray;
                $response['CurrentUserId'] = $Userid;
                $response['CurrentServiceId'] = $ServiceId;
                $response['listactive'] = 'class="active"';
                $response['modulelink'] = $modulelink;
                $response['services'] = $servicesdetails;
                $response['checked'] = $checked;
                $response['lang'] = $returndata;
                $response['m3ulinkoutput'] = (isset($outputfirst) && !empty($outputfirst) ? $outputfirst : 'xxx');
                $response['accessoutput'] = $access_outputdata;
                $response['topup'] = $returndata['gid'];
                $response['autoscript'] = $autoscript;
                return array(
                    'pagetitle' => 'Client Details',
                    'breadcrumb' => array(
                        'index.php?m=xtreamdashboard' => 'Xtream Dashboard Module',
                        'index.php?m=xtreamdashboard&action=upgradetest' => 'Xtream upgrade package Page',
                    ),
                    'templatefile' => $TemplateName,
                    'requirelogin' => true, // Set true to restrict access to authenticated client users
                    'forcessl' => false, // Deprecated as of Version 7.0. Requests will always use SSL if available.
                    'vars' => $response,
                );
            }
        }
    }

    public function GetAdminName() {
        $admin = Capsule::table('tbladmins')
                ->where('roleid', '=', 1)
                ->get();
        $adminUsername = $admin[0]->username;
        return $adminUsername;
    }

    public function adduser($vars) {
        
        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
        $errormessage = false;
        $successmessage = false;
    $data = Capsule::table('mod_vpn_settings')->get();
    $settings = array();
    foreach($data as $val)
    {
        $settings[$val->settings] = $val->value;
    }
        if (isset($_POST['add_client'])) {
             
            $returndata = array();
            $_SESSION['vpnuserid'] = $_SESSION['uid'];
            $_SESSION['vpn_login_auth_tk'] = $_SESSION['login_auth_tk'];
            
            if (isset($_POST['billingcycle'][$_POST['packageid']]) && !empty($_POST['billingcycle'][$_POST['packageid']])) {
                list($cycle, $currency, $amount) = explode("|", $_POST['billingcycle'][$_POST['packageid']]);
            } else {
                $currencydata = Capsule::table('tblpricing')
                        ->where('relid', '=', $_POST['packageid'])
                        ->where('type', '=', 'product')
                        ->where('monthly', '>', '0')
                        ->get();
                $currency = $currencydata[0]->currency;
                $cycle = '';
                $amount = 0;
            }
            if (isset($_POST['login']) && !empty($_POST['login'])) {
                $clientdetails = Capsule::table('tblclients')
                        ->where('email', '=', $_POST['login'])
                        ->get();
               
                if (isset($clientdetails[0]->email)) {
                    header("LOCATION:index.php?m=vpnpanel&action=vpnusers&result=emerror");
                    exit;
                }
            } else {
                if (isset($_POST['customfields'][$_POST['packageid']]['Username']) && !empty($_POST['customfields'][$_POST['packageid']]['Username'])) {
                    /**
                     * check username exists in Stalker or not
                     */
                    $usernameexists = self::checkUserExistsInVPN($_POST['customfields'][$_POST['packageid']]['Username'], $_POST['packageid']);
                    print_r($usernameexists); die();
                    if (isset($usernameexists) && !empty($usernameexists)) {
                        header("LOCATION:index.php?m=vpnpanel&action=adduser&result=ucerror");
                        exit;
                    }
                    $_POST['vpnusername'] = $_POST['customfields'][$_POST['packageid']]['Username'];
                } else {
                    $_POST['vpnusername'] = self::VPN_StrongPassword();
                }
            }
            if (isset($_POST['customfields'][$_POST['packageid']]['Password']) && !empty($_POST['customfields'][$_POST['packageid']]['Password'])) {
                $_POST['vpnpassword'] = $_POST['customfields'][$_POST['packageid']]['Password'];
            } else {
                $_POST['vpnpassword'] = self::VPN_StrongPassword();
            }
            $command = "addclient";
            $admin = Capsule::table('tbladmins')
                    ->where('roleid', '=', 1)
                    ->get();
            $affdetails = self::CheckAffCredit();
            
            if (isset($_POST['add_credit']) && !empty($_POST['add_credit'])) {
                $amount += $_POST['add_credit'];
            }
            if ($affdetails->credit < $amount) {
                header("LOCATION:index.php?m=vpnpanel&action=vpnusers&result=ccerror");
                exit;
            }
            
            $adminuser = $admin[0]->username;
            $userdata = explode(' ', $_POST['clientname']);
            $user['firstname'] = $userdata[0];
            $user['lastname'] = $userdata[1];
            $values["firstname"] = isset($user['firstname']) ? $user['firstname'] : '';
            $values["lastname"] = isset($user['lastname']) ? $user['lastname'] : '';
            $values["companyname"] = isset($_POST['companyname']) ? $_POST['companyname'] : '';
            $values["email"] = isset($_POST['login']) && !empty($_POST['login']) ? $_POST['login'] : $_POST['vpnusername'] . '@' . $_SERVER['SERVER_NAME'];
            $values["address1"] = isset($_POST['address1']) ? $_POST['address1'] : '';
            $values['address2'] = isset($_POST['address2']) ? $_POST['address2'] : '';
            $values["city"] = isset($_POST['city']) ? $_POST['city'] : '';
            $values["state"] = isset($_POST['state']) ? $_POST['state'] : '';
            $values["postcode"] = isset($_POST['postcode']) ? $_POST['postcode'] : '';
            $values["country"] = "US";
            $values['currency'] = $currency;
            $values["phonenumber"] = isset($_POST['phonenumber']) ? $_POST['phonenumber'] : '';
            $values['customfields'] = base64_encode(serialize(array('Reseller' => $affdetails->firstname . ' ' . $affdetails->lastname . "(" . $affdetails->email . ")")));
            $values["password2"] = isset($_POST['password']) && !empty($_POST['password']) ? $_POST['password'] : $_POST['vpnpassword'];
            $values["notes"] = "Created by:" . $affdetails->email . "";
            $values['skipvalidation'] = true;
            //print_r($values); die();
            $results = localAPI($command, $values);
            //echo '<pre>'; print_r($results); die(sdf);
            if ($results['result'] == 'error') {
                $errormessage = $results['message'];
            } else {
                
                self::WHMCSdoLogin();
                
//Add Order Variables 
                Capsule::table('tblaffiliatesaccounts')
                        ->insert(array(
                            'affiliateid' => self::getWHMCSaffid(),
                            'relid' => $results['clientid']
                ));
                $vars['client_id'] = $results['clientid'];
                $vars['pid'] = $_POST['packageid'];
                $vars['promocode'] = $_POST['promocode'];
                $vars['billingcycle'] = $cycle;
                if (isset($_POST['ProductAddons']) && !empty($_POST['ProductAddons'])) {
                    $totalAddonIDs = count($_POST['ProductAddons']);
                    $customCounter = 1;
                    foreach ($_POST['ProductAddons'] as $addonIds) {
                        $comma = "";
                        if ($customCounter < $totalAddonIDs) {
                            $comma = ",";
                        }
                        $AddonIds .= $addonIds . $comma;
                        ++$customCounter;
                    }
                    $vars['addonsIds'] = $AddonIds;
                }
                //Setting for config option
                $GetPostPackageId = $_POST['packageid'];
                if (isset($_POST['ConfigOptionIdNis'][$GetPostPackageId]) && isset($_POST['billingCycleNis'][$GetPostPackageId])) {
                    $ConfigIDsArray = $_POST['ConfigOptionIdNis'][$GetPostPackageId];
                    $billingcycleDataArray = $_POST['billingCycleNis'][$GetPostPackageId];

                    $combinedArray = array_combine($ConfigIDsArray, $billingcycleDataArray);
                    $FinalConfigArrayForAddorder = array();
                    foreach ($combinedArray as $Ckey => $Cvalue) {
                        if ($Cvalue != "") {
                            $ConfigFieldValue = $_POST['configOption_' . $Ckey][$GetPostPackageId][$Ckey][$Cvalue];
                            if ($ConfigFieldValue != "") {
                                $FinalConfigArrayForAddorder[$Ckey] = $ConfigFieldValue;
                            }
                        }
                    }
                    if (!empty($FinalConfigArrayForAddorder)) {
                        $vars["configoptions"] = base64_encode(serialize($FinalConfigArrayForAddorder));
                    }
                }
                //$vars["configoptions"] = base64_encode(serialize(array(1=>4,3=>2,)));
                $data = self::AddOrderWHMCS($vars);
                
                self::WHMCSdoLogin();
                if (isset($data) && $data['result'] == 'success') {
                    $_POST['serviceid'] = $data['productids'];
                    $_POST['orderid'] = $data['orderid'];

                    if (isset($_POST[$returndata['configoption_field_name']][$_POST["packageid"]][$cycle])) {
                        $qty = $_POST[$returndata['configoption_field_name']][$_POST["packageid"]][$cycle];
                        $configid = Capsule::table('tblproductconfigoptions')->where('optionname', '=', $returndata['configoption_field_name'])->value('id');
                        Capsule::table('tblhostingconfigoptions')->where('relid', '=', $_POST['serviceid'])->where('configid', '=', $configid)->update(
                                ['qty' => $qty]
                        );
                    }
                    if (isset($data['invoiceid']) && !empty($data['invoiceid'])) {
                    
                        if ($data['result'] == 'success') {
                            $invoiceTotal = Capsule::table('tblinvoices')->where('id', '=', $data['invoiceid'])->select('tblinvoices.total')->get();
                            $add_credit = $invoiceTotal[0]->total;
                            if (isset($_POST['add_credit']) && !empty($_POST['add_credit'])) {
                                $add_credit += $_POST['add_credit'];
                            }
                            self::WHMCSdoLogin();
                            
                            $AddCredit = 'AddCredit';
                            $postData = array(
                                'clientid' => $results['clientid'],
                                'description' => 'Added funds by ' . $affdetails->firstname . ' ' . $affdetails->lastname,
                                'amount' => $add_credit,
                            );
                            $resultsCredit = localAPI($AddCredit, $postData, $adminuser);
                            if ($resultsCredit['result'] == 'success') {
                                
                                Capsule::table('tblcredit')->insert(
                                        ['clientid' => $_SESSION['uid'], 'date' => date('Y-m-d'), 'description' => 'Add Credit to Client - ' . $results['clientid'], 'amount' => -$add_credit]
                                );
                                $removeCredit = $affdetails->credit - $add_credit;
                                self::RemoveWHMCSCredit($removeCredit);
                                /**
                                 * Remove Credits in X.C
                                 */
                                
                                
                                $admin = Capsule::table('tbladmins')
                                        ->where('roleid', '=', 1)
                                        ->get();
                                $adminUsername = $admin[0]->username;
                                
                                
                                $command = 'ApplyCredit';
                                $postData = array(
                                    'invoiceid' => $data['invoiceid'],
                                    'amount' => $invoiceTotal[0]->total,
                                );
                                $results = localAPI($command, $postData, $adminUsername);
                                if ($results['result'] == 'success') {
                                    //{$iptv_client_name} , {$iptv_client_service}, {$iptv_client_email}, {$iptv_client_password}, {$iptv_client_password}{$iptv_service_username} {$iptv_service_password},
                                    $command = 'SendEmail';
                                    $hostingdetials = Capsule::table('tblhosting')
                                            ->where('id', '=', $_POST['serviceid'])
                                            ->select('packageid', 'username', 'password')
                                            ->get();
                                    $productdetials = Capsule::table('tblproducts')
                                            ->where('id', '=', $hostingdetials[0]->packageid)
                                            ->select('name')
                                            ->get();

                                    $postData = array(
                                        'messagename' => 'VPN Client Details',
                                        'id' => $_SESSION['uid'],
                                        'customvars' => array(
                                            'vpn_client_name' => $_POST['clientname'],
                                            'vpn_client_email' => $values["email"],
                                            'vpn_client_password' => $values["password2"],
                                            'vpn_client_service' => $productdetials[0]->name,
                                            'vpn_service_username' => $hostingdetials[0]->username,
                                            'vpn_service_password' => decrypt($hostingdetials[0]->password),
                                        ),
                                    );
                                    $results = localAPI($command, $postData, $adminUsername);
                                    header("LOCATION:index.php?m=vpnpanel&action=vpnusers&result=success");
                                    exit;
                                } else {
                                    header("LOCATION:index.php?m=vpnpanel&action=vpnusers&result={$results['message']}");
                                    exit;
                                }
                                logModuleCall('VPN Panel', 'ApplyCredit', $postData, $results, '', '');
                                self::WHMCSdoLogin();
                            }
                        } else {
                            header("LOCATION:index.php?m=vpnpanel&action=vpnusers&result={$data['message']}");
                            exit;
                        }
                    } else {
                        if (isset($_POST['add_credit']) && !empty($_POST['add_credit'])) {
                            $add_credit = $_POST['add_credit'];
                        }
                        self::WHMCSdoLogin();
                        $AddCredit = 'AddCredit';
                        $postData = array(
                            'clientid' => $results['clientid'],
                            'description' => 'Added funds by ' . $affdetails->firstname . ' ' . $affdetails->lastname,
                            'amount' => $add_credit,
                        );
                        $resultsCredit = localAPI($AddCredit, $postData, $adminuser);
                        if ($resultsCredit['result'] == 'success') {
                            Capsule::table('tblcredit')->insert(
                                    ['clientid' => $_SESSION['uid'], 'date' => date('Y-m-d'), 'description' => 'Add Credit to Client - ' . $results['clientid'], 'amount' => -$add_credit]
                            );
                            $removeCredit = $affdetails->credit - $add_credit;
                            self::RemoveWHMCSCredit($removeCredit);
                            /**
                             * Remove Credits in X.C
                             */
                           // $con = self::XtreamDashboard_testconnection();
                            //self::RemoveXtreamCredit($add_credit, $con);
                        }
                        $return = self::AddClientInXtreamm($_POST, 'users');
                        self::WHMCSdoLogin();
                        $CHeckOrderStatus = Capsule::table('tblorders')
                                ->where('id', '=', $_POST['orderid'])
                                ->get();
                        if ($CHeckOrderStatus[0]->status != "Active") {
                            $command = 'AcceptOrder';
                            $postData = array(
                                'orderid' => $_POST['orderid'],
                                'serverid' => $_POST['serviceid'],
                                'autosetup' => '1'
                            );
                            $admin = Capsule::table('tbladmins')
                                    ->where('roleid', '=', 1)
                                    ->get();
                            $adminUsername = $admin[0]->username;

                            $results = localAPI($command, $postData, $adminUsername);
                        }
                        /* logModuleCall('Xtream Dashboard', 'AcceptOrder', $postData, $results, '', ''); */
                        if ($results['result'] == 'success') {
                            //{$iptv_client_name} , {$iptv_client_service}, {$iptv_client_email}, {$iptv_client_password}, {$iptv_client_password}{$iptv_service_username} {$iptv_service_password},
                            $command = 'SendEmail';
                            $hostingdetials = Capsule::table('tblhosting')
                                    ->where('id', '=', $_POST['serviceid'])
                                    ->select('packageid', 'username', 'password')
                                    ->get();
                            $productdetials = Capsule::table('tblproducts')
                                    ->where('id', '=', $hostingdetials[0]->packageid)
                                    ->select('name')
                                    ->get();

                            $postData = array(
                                'messagename' => 'VPN Client Details',
                                'id' => $_SESSION['uid'],
                                'customvars' => array(
                                    'vpn_client_name' => $_POST['clientname'],
                                    'vpn_client_email' => $values["email"],
                                    'vpn_client_password' => $values["password2"],
                                    'vpn_client_service' => $productdetials[0]->name,
                                    'vpn_service_username' => $hostingdetials[0]->username,
                                    'vpn_service_password' => decrypt($hostingdetials[0]->password),
                                ),
                            );
                            $results = localAPI($command, $postData, $adminUsername);
                            header("LOCATION:index.php?m=vpnpanel&action=vpnusers&result=success");
                            exit;
                        } else {
                            header("LOCATION:index.php?m=vpnpanel&action=vpnusers&result=Unable to Create Client");
                            exit;
                        }
                    }
                } else {
                    header("LOCATION:index.php?m=vpnpanel&action=vpnusers&result={$results['message']}");
                    exit;
                }
            }
        }
        $clientdata = Capsule::table('tblclients')->where('id', '=', $_SESSION['uid'])->get();
        $clientgrop = Capsule::table('tblclientgroups')->where('id', '=', $clientdata[0]->groupid)->get();
        //print_r($clientgrop); die(sdf);
        if ($clientgrop[0]->groupname == 'Reseller') {
            
            /*$product_id = Capsule::table('mod_xtreamreseller')->where('client_id', '=', $_SESSION['uid'])->get();
            if (empty($product_id)) {
                $product_id = Capsule::table('mod_xtreamresellergrp')->where('client_id', '=', $clientdata[0]->groupid)->get();
            }*/
            $assignedProducts = Capsule::table('mod_vpn_assignpackages')
            ->where('resellerid',$_SESSION['uid'])->get();
            if(count($assignedProducts) > 0 && !empty($assignedProducts[0]->products))
            {
                
                $products = Capsule::table('tblproducts')
                    ->select(Capsule::raw('*'))
                    ->whereIn('id', explode(',', $assignedProducts[0]->products))
                    //->where('servertype', '=', 'vpnservernoapi')
                    ->where('type', '!=', 'reselleraccount')
                    //->where('configoption1', '=', 'member')
                    //  ->whereIn('id', explode(',', $product_id[0]->product_id))
                    ->get();
            }
            else
            {
                $assignedProducts = Capsule::table('mod_vpn_assignpackages')->where('resellerid','all')->where('assigngroup',$clientdata[0]->groupid)->get();
                if(count($assignedProducts) > 0 && !empty($assignedProducts[0]->products))
            {
                
                $products = Capsule::table('tblproducts')
                    ->select(Capsule::raw('*'))
                    ->whereIn('id', explode(',', $assignedProducts[0]->products))
                    //->where('servertype', '=', 'vpnservernoapi')
                    ->where('type', '!=', 'reselleraccount')
                    //->where('configoption1', '=', 'member')
                    //  ->whereIn('id', explode(',', $product_id[0]->product_id))
                    ->get();
            }
            else
            {
                
                $products = Capsule::table('tblproducts')
                    ->select(Capsule::raw('*'))
                    ->where('servertype', '=', 'vpnservernoapi')
                    ->where('type', '!=', 'reselleraccount')
                    ->where('configoption1', '=', 'member')
                    //  ->whereIn('id', explode(',', $product_id[0]->product_id))
                    ->get();
            }
            }
            
                    
        } elseif ($clientgrop[0]->groupname == 'Super-Reseller') {
            
            /*$product_id = Capsule::table('mod_xtreamreseller')->where('client_id', '=', $_SESSION['uid'])->get();
            if (empty($product_id)) {
                $product_id = Capsule::table('mod_xtreamresellergrp')->where('client_id', '=', $clientdata[0]->groupid)->get();
            }*/
            $assignedProducts = Capsule::table('mod_vpn_assignpackages')
            ->where('resellerid',$_SESSION['uid'])->get();
            if(count($assignedProducts) > 0 && !empty($assignedProducts[0]->products))
            {
                
                $products = Capsule::table('tblproducts')
                    ->select(Capsule::raw('*'))
                    ->whereIn('id', explode(',', $assignedProducts[0]->products))
                    //->where('servertype', '=', 'vpnservernoapi')
                    ->where('type', '!=', 'reselleraccount')
                    //->where('configoption1', '=', 'member')
                    //  ->whereIn('id', explode(',', $product_id[0]->product_id))
                    ->get();
            }
            else
            {
                $assignedProducts = Capsule::table('mod_vpn_assignpackages')->where('resellerid','all')->where('assigngroup',$clientdata[0]->groupid)->get();
                if(count($assignedProducts) > 0 && !empty($assignedProducts[0]->products))
            {
                
                $products = Capsule::table('tblproducts')
                    ->select(Capsule::raw('*'))
                    ->whereIn('id', explode(',', $assignedProducts[0]->products))
                    //->where('servertype', '=', 'vpnservernoapi')
                    ->where('type', '!=', 'reselleraccount')
                    //->where('configoption1', '=', 'member')
                    //  ->whereIn('id', explode(',', $product_id[0]->product_id))
                    ->get();
            }
            else
            {
               
                $products = Capsule::table('tblproducts')
                    ->select(Capsule::raw('*'))
                    ->where('servertype', '=', 'vpnservernoapi')
                    //->where('type', '=', 'reselleraccount')
                    ->whereIn('configoption1', ['member'])
                    //  ->whereIn('id', explode(',', $product_id[0]->product_id))
                    ->get();
            }
            }
            
                    
        }
        $currencydata = Capsule::table('tblclients')->where('id', '=', $_SESSION['uid'])->select('currency')
                ->get();
        $currency = $currencydata[0]->currency;
        $currencydetails = Capsule::table('tblcurrencies')->where('id', '=', $currency)->get();
        $CurrencyId = $currencydetails[0]->id;
//Get Product Customfields
        foreach ($products as $product) {
            $addonpackagearray[$product->id] = self::getProductAddon($product->id, $CurrencyId);
            $customfields[$product->id] = self::getProductCustomFields($product->id);
            $billingcycle[$product->id] = self::getProductBillingCycle($product->id, $currency);
            $configuralOption[$product->id] = self::getProductConfigOption($product->id, $currency);
        }
        /*$config = Capsule::table('mod_xtreamsetting')->get();
        foreach ($config as $value) {
            $row[$value->setting] = $value->value;
        }*/
        $userinfo = 'no';
        if (isset($row['login']) || isset($row['password']) || isset($row['confirmpassword']) || isset($row['clientname']) || isset($row['companyname']) || isset($row['address1']) || isset($row['address2']) || isset($row['city']) || isset($row['state']) || isset($row['postcode']) || isset($row['phonenumber'])) {
            $userinfo = 'yes';
        }
        /*$xtreamConfig = Capsule::table('mod_xtreamConfig')
                ->get();*/
                $creditsDetails = self::CheckAffCredit();
       $totalCredits = $creditsDetails->credit;
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        $creditsDetails = self::CheckAffCredit();
       $totalCredits = $creditsDetails->credit;
        $response = array(
            'totalcredit' => $totalCredits,
            'modulelink' => $modulelink,
            'optionactive' => $row,
            'customfields' => $customfields,
            'products' => $products,
            'billingcycle' => $billingcycle,
            'addonpackagearray' => $addonpackagearray,
            'configuralOption' => $configuralOption,
            'errormessage' => $errormessage,
            'currency' => $currencydetails[0],
            'successmessage' => $successmessage,
            'maccustomfieldname' => $returndata['custom_field_mag'],
            'e2customfieldname' => $returndata['custom_field_eng'],
            'topup' => $returndata['gid'],
            'userinfo' => $userinfo,
            'settings' => $settings,
        );
        //print_r($response); die(sdf);
        if (isset($_GET['result']) && $_GET['result'] == 'pkerror') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> Please Choose Plan!";
        } elseif (isset($_GET['result']) && $_GET['result'] == 'bcerror') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> Please select billing cycle!";
        } elseif (isset($_GET['result']) && $_GET['result'] == 'macerror') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> MAG Address Required!";
        } elseif (isset($_GET['result']) && $_GET['result'] == 'macexists') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> MAG Address Already Exists!";
        } elseif (isset($_GET['result']) && $_GET['result'] == 'engerror') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> " . $returndata['custom_field_eng'] . " Required!";
        } elseif (isset($_GET['result']) && $_GET['result'] == 'macvalid') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> MAG Address is not Valid!";
        } elseif (isset($_GET['result']) && $_GET['result'] == 'ucerror') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> Username already exists!";
        }

        /* echo "<pre>";print_r($billingcycle);die(); */
        $response['selectuser'] = 'User';
        $response['addactive'] = 'class="active"';
        return array(
            'pagetitle' => 'Add New User',
            'breadcrumb' => array(
                'index.php?m=vpnpanel' => 'Dashboard',
                'index.php?m=vpnpanel&action=adduser' => 'Add New User'),
            'templatefile' => 'vpnadduser',
            'requirelogin' => true, # accepts true/false
            'forcessl' => false, # accepts true/false
            'vars' => $response
        );
    }

    public function getProductAddon($pid = "", $CurrencyId = "") {
        $ReturnDataArray = array();
        $ReturnDataArray = Capsule::table('tbladdons')
                ->join('tblpricing', 'tbladdons.id', '=', 'tblpricing.relid')
                ->whereRaw("find_in_set('" . $pid . "',tbladdons.packages)")
                ->where("tblpricing.currency", '=', $CurrencyId)
                ->where("tblpricing.type", '=', 'addon')
                ->select('tbladdons.id as addonpackageid'
                        , 'tbladdons.name as addonpackagename'
                        , 'tbladdons.billingcycle as addonpackagebillingcycle'
                        , 'tblpricing.monthly as addonpackagemonthly'
                        , 'tblpricing.quarterly as addonpackagequarterly'
                        , 'tblpricing.semiannually as addonpackagesemiannually'
                        , 'tblpricing.annually as addonpackageannually'
                        , 'tblpricing.biennially as addonpackagebiennially'
                        , 'tblpricing.triennially as addonpackagetriennially'
                        , 'tblpricing.msetupfee as addonpackagemsetupfee'
                        , 'tblpricing.qsetupfee as addonpackageqsetupfee'
                        , 'tblpricing.ssetupfee as addonpackagessetupfee'
                        , 'tblpricing.asetupfee as addonpackageasetupfee'
                        , 'tblpricing.bsetupfee as addonpackagebsetupfee'
                        , 'tblpricing.tsetupfee as addonpackagetsetupfee'
                )
                ->get();
        return $ReturnDataArray;
    }

    public function getProductConfigOption($pid = "", $currency = "") {

        $ReturnDataArray = array();
        $productdata = Capsule::table('tblproductconfiglinks')
                ->join('tblproductconfigoptions', 'tblproductconfiglinks.gid', '=', 'tblproductconfigoptions.gid')
                ->join('tblproductconfigoptionssub', 'tblproductconfigoptions.id', '=', 'tblproductconfigoptionssub.configid')
                ->join('tblpricing', 'tblproductconfigoptionssub.id', '=', 'tblpricing.relid')
                ->select('tblproductconfigoptions.*'
                        , 'tblpricing.monthly as monthly'
                        , 'tblpricing.quarterly as quarterly'
                        , 'tblpricing.semiannually as semiannually'
                        , 'tblpricing.annually as annually'
                        , 'tblpricing.biennially as biennially'
                        , 'tblpricing.triennially as triennially'
                )
                ->where('tblproductconfiglinks.pid', '=', $pid)
                ->where('tblpricing.type', '=', 'configoptions')
                ->where('tblpricing.currency', '=', $currency)
                ->get();
        $productdata = json_decode(json_encode($productdata), TRUE);
        $ReturnDataArray = array();
        if (!empty($productdata)) {
            $NewArrayForDervision = array();
            $NewArrayForDervision2 = array();
            foreach ($productdata as $key => $val) {
                $NewArrayForDervision2['id'] = $val['id'];
                $NewArrayForDervision2['gid'] = $val['gid'];
                $NewArrayForDervision2['optionname'] = $val['optionname'];
                $NewArrayForDervision2['optiontype'] = $val['optiontype'];
                $NewArrayForDervision2['qtyminimum'] = $val['qtyminimum'];
                $NewArrayForDervision2['qtymaximum'] = $val['qtymaximum'];
                $NewArrayForDervision2['order'] = $val['order'];
                $NewArrayForDervision2['hidden'] = $val['hidden'];
                $NewArrayForDervision2['pricetype'] = array(
                    'monthly' => $val['monthly'],
                    'quarterly' => $val['quarterly'],
                    'semiannually' => $val['semiannually'],
                    'annually' => $val['annually'],
                    'biennially' => $val['biennially'],
                    'triennially' => $val['triennially'],
                );
                $NewArrayForDervision[] = $NewArrayForDervision2;
            }
        }
        $ReturnDataArray = $NewArrayForDervision;

        return $ReturnDataArray;
    }

    public function checkMagExistsInXtream($newmac, $product_id) {
        $servers = Capsule::table('tblproducts')
                ->join('tblservergroupsrel', 'tblproducts.servergroup', '=', 'tblservergroupsrel.groupid')
                ->join('tblservers', 'tblservergroupsrel.serverid', '=', 'tblservers.id')
                ->where('tblproducts.id', '=', $product_id)
                ->select('tblservers.*')
                ->get();
        foreach ($servers as $server) {
            $sqlusername = $server->username;
            $sqlpassword = decrypt($server->password);
            $sqldbname = $server->accesshash;
           $sqlhost=$server->ipaddress;
            list($sqldbname, $sqlport) = explode(':', $sqldbname);
            if (isset($sqlport) && !empty($sqlport))
                $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname, $sqlport);
            else
                $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname);

// Check connection 
            if (mysqli_connect_errno()) {
                return "Failed to connect to MySQL: " . mysqli_connect_error();
            }

// First checking if user already exist with reqeuest username  
            $resultmag_devices = mysqli_query($con, "SELECT * FROM mag_devices WHERE mac = '" . base64_encode($newmac) . "'");
            if (!$resultmag_devices) {
                $radiussqlerror = mysqli_error($con);
                self::XtreamCode_WHMCSReconnect();
                return "vpnpanel Database Query Error: " . $radiussqlerror;
            }
            if (mysqli_num_rows($resultmag_devices) > 0) {
                return 'macexists';
            }
            $result_devices = mysqli_query($con, "SELECT * FROM enigma2_devices WHERE mac = '" . $newmac . "'");
            if (mysqli_num_rows($result_devices) != 0) {
                return 'macexists';
            }
        }
    }

    public function checkUserExistsInVPN($username, $product_id) {
        $radcheckcount = DB::table('radcheck')->where('username', $username)->count();

    if($radcheckcount > 0)
    {
      return "user exists";
    }
    
    }

    public function addreseller($vars) {
        
        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
        $errormessage = false;
        $successmessage = false;
    $data = Capsule::table('mod_vpn_settings')->get();
    $settings = array();
    foreach($data as $val)
    {
        $settings[$val->settings] = $val->value;
    }
        if (isset($_POST['add_client'])) {
             
            $returndata = array();
            $_SESSION['vpnuserid'] = $_SESSION['uid'];
            $_SESSION['vpnpasswordhash'] = $_SESSION['pwd'];
            if (isset($_POST['billingcycle'][$_POST['packageid']]) && !empty($_POST['billingcycle'][$_POST['packageid']])) {
                list($cycle, $currency, $amount) = explode("|", $_POST['billingcycle'][$_POST['packageid']]);
            } else {
                $currencydata = Capsule::table('tblpricing')
                        ->where('relid', '=', $_POST['packageid'])
                        ->where('type', '=', 'product')
                        ->where('monthly', '>', '0')
                        ->get();
                $currency = $currencydata[0]->currency;
                $cycle = '';
                $amount = 0;
            }
            if (isset($_POST['login']) && !empty($_POST['login'])) {
                $clientdetails = Capsule::table('tblclients')
                        ->where('email', '=', $_POST['login'])
                        ->get();
                if (isset($clientdetails) && !empty($clientdetails)) {
                    header("LOCATION:index.php?m=vpnpanel&action=vpnusers&result=emerror");
                    exit;
                }
            } else {
                if (isset($_POST['customfields'][$_POST['packageid']]['Username']) && !empty($_POST['customfields'][$_POST['packageid']]['Username'])) {
                    /**
                     * check username exists in Stalker or not
                     */
                    $usernameexists = self::checkUserExistsInVPN($_POST['customfields'][$_POST['packageid']]['Username'], $_POST['packageid']);
                    if (isset($usernameexists) && !empty($usernameexists)) {
                        header("LOCATION:index.php?m=vpnpanel&action=adduser&result=ucerror");
                        exit;
                    }
                    $_POST['vpnusername'] = $_POST['customfields'][$_POST['packageid']]['Username'];
                } else {
                    $_POST['vpnusername'] = self::VPN_StrongPassword();
                }
            }
            if (isset($_POST['customfields'][$_POST['packageid']]['Password']) && !empty($_POST['customfields'][$_POST['packageid']]['Password'])) {
                $_POST['vpnpassword'] = $_POST['customfields'][$_POST['packageid']]['Password'];
            } else {
                $_POST['vpnpassword'] = self::VPN_StrongPassword();
            }
            $command = "addclient";
            $admin = Capsule::table('tbladmins')
                    ->where('roleid', '=', 1)
                    ->get();
            $affdetails = self::CheckAffCredit();
            if (isset($_POST['add_credit']) && !empty($_POST['add_credit'])) {
                $amount += $_POST['add_credit'];
            }
            if ($affdetails->credit < $amount) {
                header("LOCATION:index.php?m=vpnpanel&action=vpnusers&result=ccerror");
                exit;
            }
            
            $adminuser = $admin[0]->username;
            $userdata = explode(' ', $_POST['clientname']);
            $user['firstname'] = $userdata[0];
            $user['lastname'] = $userdata[1];
            $values["firstname"] = isset($user['firstname']) ? $user['firstname'] : '';
            $values["lastname"] = isset($user['lastname']) ? $user['lastname'] : '';
            $values["companyname"] = isset($_POST['companyname']) ? $_POST['companyname'] : '';
            $values["email"] = isset($_POST['login']) && !empty($_POST['login']) ? $_POST['login'] : $_POST['vpnusername'] . '@' . $_SERVER['SERVER_NAME'];
            $values["address1"] = isset($_POST['address1']) ? $_POST['address1'] : '';
            $values['address2'] = isset($_POST['address2']) ? $_POST['address2'] : '';
            $values["city"] = isset($_POST['city']) ? $_POST['city'] : '';
            $values["state"] = isset($_POST['state']) ? $_POST['state'] : '';
            $values["postcode"] = isset($_POST['postcode']) ? $_POST['postcode'] : '';
            $values["country"] = "US";
            $values['currency'] = $currency;
            $values["phonenumber"] = isset($_POST['phonenumber']) ? $_POST['phonenumber'] : '';
            $values['customfields'] = base64_encode(serialize(array('Reseller' => $affdetails->firstname . ' ' . $affdetails->lastname . "(" . $affdetails->email . ")")));
            $values["password2"] = isset($_POST['password']) && !empty($_POST['password']) ? $_POST['password'] : $_POST['vpnpassword'];
            $values["notes"] = "Created by:" . $affdetails->email . "";
            $values['skipvalidation'] = true;
            $results = localAPI($command, $values, $adminuser);
            //echo '<pre>'; print_r($results); die(sdf);
            if ($results['result'] == 'error') {
                $errormessage = $results['message'];
            } else {
                
                self::WHMCSdoLogin();
                
//Add Order Variables 
                Capsule::table('tblaffiliatesaccounts')
                        ->insert(array(
                            'affiliateid' => self::getWHMCSaffid(),
                            'relid' => $results['clientid']
                ));
                $vars['client_id'] = $results['clientid'];
                $vars['pid'] = $_POST['packageid'];
                $vars['promocode'] = $_POST['promocode'];
                $vars['billingcycle'] = $cycle;
                if (isset($_POST['ProductAddons']) && !empty($_POST['ProductAddons'])) {
                    $totalAddonIDs = count($_POST['ProductAddons']);
                    $customCounter = 1;
                    foreach ($_POST['ProductAddons'] as $addonIds) {
                        $comma = "";
                        if ($customCounter < $totalAddonIDs) {
                            $comma = ",";
                        }
                        $AddonIds .= $addonIds . $comma;
                        ++$customCounter;
                    }
                    $vars['addonsIds'] = $AddonIds;
                }
                //Setting for config option
                $GetPostPackageId = $_POST['packageid'];
                if (isset($_POST['ConfigOptionIdNis'][$GetPostPackageId]) && isset($_POST['billingCycleNis'][$GetPostPackageId])) {
                    $ConfigIDsArray = $_POST['ConfigOptionIdNis'][$GetPostPackageId];
                    $billingcycleDataArray = $_POST['billingCycleNis'][$GetPostPackageId];

                    $combinedArray = array_combine($ConfigIDsArray, $billingcycleDataArray);
                    $FinalConfigArrayForAddorder = array();
                    foreach ($combinedArray as $Ckey => $Cvalue) {
                        if ($Cvalue != "") {
                            $ConfigFieldValue = $_POST['configOption_' . $Ckey][$GetPostPackageId][$Ckey][$Cvalue];
                            if ($ConfigFieldValue != "") {
                                $FinalConfigArrayForAddorder[$Ckey] = $ConfigFieldValue;
                            }
                        }
                    }
                    if (!empty($FinalConfigArrayForAddorder)) {
                        $vars["configoptions"] = base64_encode(serialize($FinalConfigArrayForAddorder));
                    }
                }
                //$vars["configoptions"] = base64_encode(serialize(array(1=>4,3=>2,)));
                $data = self::AddOrderWHMCS($vars);
                
                self::WHMCSdoLogin();
                if (isset($data) && $data['result'] == 'success') {
                    $_POST['serviceid'] = $data['productids'];
                    $_POST['orderid'] = $data['orderid'];

                    if (isset($_POST[$returndata['configoption_field_name']][$_POST["packageid"]][$cycle])) {
                        $qty = $_POST[$returndata['configoption_field_name']][$_POST["packageid"]][$cycle];
                        $configid = Capsule::table('tblproductconfigoptions')->where('optionname', '=', $returndata['configoption_field_name'])->value('id');
                        Capsule::table('tblhostingconfigoptions')->where('relid', '=', $_POST['serviceid'])->where('configid', '=', $configid)->update(
                                ['qty' => $qty]
                        );
                    }
                    if (isset($data['invoiceid']) && !empty($data['invoiceid'])) {
                    
                        if ($data['result'] == 'success') {
                            $invoiceTotal = Capsule::table('tblinvoices')->where('id', '=', $data['invoiceid'])->select('tblinvoices.total')->get();
                            $add_credit = $invoiceTotal[0]->total;
                            if (isset($_POST['add_credit']) && !empty($_POST['add_credit'])) {
                                $add_credit += $_POST['add_credit'];
                            }
                            //self::WHMCSdoLogin();
                            
                            $AddCredit = 'AddCredit';
                            $postData = array(
                                'clientid' => $results['clientid'],
                                'description' => 'Added funds by ' . $affdetails->firstname . ' ' . $affdetails->lastname,
                                'amount' => $add_credit,
                            );
                            $resultsCredit = localAPI($AddCredit, $postData, $adminuser);
                            if ($resultsCredit['result'] == 'success') {
                                
                                Capsule::table('tblcredit')->insert(
                                        ['clientid' => $_SESSION['uid'], 'date' => date('Y-m-d'), 'description' => 'Add Credit to Client - ' . $results['clientid'], 'amount' => -$add_credit]
                                );
                                $removeCredit = $affdetails->credit - $add_credit;
                                self::RemoveWHMCSCredit($removeCredit);
                                /**
                                 * Remove Credits in X.C
                                 */
                                
                                
                                $admin = Capsule::table('tbladmins')
                                        ->where('roleid', '=', 1)
                                        ->get();
                                $adminUsername = $admin[0]->username;
                                
                                
                                $command = 'ApplyCredit';
                                $postData = array(
                                    'invoiceid' => $data['invoiceid'],
                                    'amount' => $invoiceTotal[0]->total,
                                );
                                $results = localAPI($command, $postData, $adminUsername);
                                if ($results['result'] == 'success') {
                                    //{$iptv_client_name} , {$iptv_client_service}, {$iptv_client_email}, {$iptv_client_password}, {$iptv_client_password}{$iptv_service_username} {$iptv_service_password},
                                    $command = 'SendEmail';
                                    $hostingdetials = Capsule::table('tblhosting')
                                            ->where('id', '=', $_POST['serviceid'])
                                            ->select('packageid', 'username', 'password')
                                            ->get();
                                    $productdetials = Capsule::table('tblproducts')
                                            ->where('id', '=', $hostingdetials[0]->packageid)
                                            ->select('name')
                                            ->get();

                                    $postData = array(
                                        'messagename' => 'VPN Client Details',
                                        'id' => $_SESSION['uid'],
                                        'customvars' => array(
                                            'vpn_client_name' => $_POST['clientname'],
                                            'vpn_client_email' => $values["email"],
                                            'vpn_client_password' => $values["password2"],
                                            'vpn_client_service' => $productdetials[0]->name,
                                            'vpn_service_username' => $hostingdetials[0]->username,
                                            'vpn_service_password' => decrypt($hostingdetials[0]->password),
                                        ),
                                    );
                                    $results = localAPI($command, $postData, $adminUsername);
                                    header("LOCATION:index.php?m=vpnpanel&action=vpnusers&result=success");
                                    exit;
                                } else {
                                    header("LOCATION:index.php?m=vpnpanel&action=vpnusers&result={$results['message']}");
                                    exit;
                                }
                                logModuleCall('VPN Panel', 'ApplyCredit', $postData, $results, '', '');
                                self::WHMCSdoLogin();
                            }
                        } else {
                            header("LOCATION:index.php?m=vpnpanel&action=vpnusers&result={$data['message']}");
                            exit;
                        }
                    } else {
                        if (isset($_POST['add_credit']) && !empty($_POST['add_credit'])) {
                            $add_credit = $_POST['add_credit'];
                        }
                        self::WHMCSdoLogin();
                        $AddCredit = 'AddCredit';
                        $postData = array(
                            'clientid' => $results['clientid'],
                            'description' => 'Added funds by ' . $affdetails->firstname . ' ' . $affdetails->lastname,
                            'amount' => $add_credit,
                        );
                        $resultsCredit = localAPI($AddCredit, $postData, $adminuser);
                        if ($resultsCredit['result'] == 'success') {
                            Capsule::table('tblcredit')->insert(
                                    ['clientid' => $_SESSION['uid'], 'date' => date('Y-m-d'), 'description' => 'Add Credit to Client - ' . $results['clientid'], 'amount' => -$add_credit]
                            );
                            $removeCredit = $affdetails->credit - $add_credit;
                            self::RemoveWHMCSCredit($removeCredit);
                            /**
                             * Remove Credits in X.C
                             */
                           // $con = self::XtreamDashboard_testconnection();
                            //self::RemoveXtreamCredit($add_credit, $con);
                        }
                        $return = self::AddClientInXtreamm($_POST, 'users');
                        self::WHMCSdoLogin();
                        $CHeckOrderStatus = Capsule::table('tblorders')
                                ->where('id', '=', $_POST['orderid'])
                                ->get();
                        if ($CHeckOrderStatus[0]->status != "Active") {
                            $command = 'AcceptOrder';
                            $postData = array(
                                'orderid' => $_POST['orderid'],
                                'serverid' => $_POST['serviceid'],
                                'autosetup' => '1'
                            );
                            $admin = Capsule::table('tbladmins')
                                    ->where('roleid', '=', 1)
                                    ->get();
                            $adminUsername = $admin[0]->username;

                            $results = localAPI($command, $postData, $adminUsername);
                        }
                        /* logModuleCall('Xtream Dashboard', 'AcceptOrder', $postData, $results, '', ''); */
                        if ($results['result'] == 'success') {
                            //{$iptv_client_name} , {$iptv_client_service}, {$iptv_client_email}, {$iptv_client_password}, {$iptv_client_password}{$iptv_service_username} {$iptv_service_password},
                            $command = 'SendEmail';
                            $hostingdetials = Capsule::table('tblhosting')
                                    ->where('id', '=', $_POST['serviceid'])
                                    ->select('packageid', 'username', 'password')
                                    ->get();
                            $productdetials = Capsule::table('tblproducts')
                                    ->where('id', '=', $hostingdetials[0]->packageid)
                                    ->select('name')
                                    ->get();

                            $postData = array(
                                'messagename' => 'VPN Client Details',
                                'id' => $_SESSION['uid'],
                                'customvars' => array(
                                    'vpn_client_name' => $_POST['clientname'],
                                    'vpn_client_email' => $values["email"],
                                    'vpn_client_password' => $values["password2"],
                                    'vpn_client_service' => $productdetials[0]->name,
                                    'vpn_service_username' => $hostingdetials[0]->username,
                                    'vpn_service_password' => decrypt($hostingdetials[0]->password),
                                ),
                            );
                            $results = localAPI($command, $postData, $adminUsername);
                            header("LOCATION:index.php?m=vpnpanel&action=vpnusers&result=success");
                            exit;
                        } else {
                            header("LOCATION:index.php?m=vpnpanel&action=vpnusers&result=Unable to Create Client");
                            exit;
                        }
                    }
                } else {
                    header("LOCATION:index.php?m=vpnpanel&action=vpnusers&result={$results['message']}");
                    exit;
                }
            }
        }
        $clientdata = Capsule::table('tblclients')->where('id', '=', $_SESSION['uid'])->get();
        $clientgrop = Capsule::table('tblclientgroups')->where('id', '=', $clientdata[0]->groupid)->get();
        //print_r($clientgrop); die(sdf);
        if ($clientgrop[0]->groupname == 'Super-Reseller') {
            
            /*$product_id = Capsule::table('mod_xtreamreseller')->where('client_id', '=', $_SESSION['uid'])->get();
            if (empty($product_id)) {
                $product_id = Capsule::table('mod_xtreamresellergrp')->where('client_id', '=', $clientdata[0]->groupid)->get();
            }*/
            $assignedProducts = Capsule::table('mod_vpn_assignpackages')
            ->where('resellerid',$_SESSION['uid'])->get();
            if(count($assignedProducts) > 0 && !empty($assignedProducts[0]->products))
            {
               
                $products = Capsule::table('tblproducts')
                    ->select(Capsule::raw('*'))
                    ->whereIn('id', explode(',', $assignedProducts[0]->products))
                    //->where('servertype', '=', 'vpnservernoapi')
                    ->where('type', '=', 'reselleraccount')
                    //->where('configoption1', '=', 'member')
                    //  ->whereIn('id', explode(',', $product_id[0]->product_id))
                    ->get();
            }
            else
            {
                $assignedProducts = Capsule::table('mod_vpn_assignpackages')->where('resellerid','all')->where('assigngroup',$clientdata[0]->groupid)->get();
                if(count($assignedProducts) > 0 && !empty($assignedProducts[0]->products))
            {
                
                $products = Capsule::table('tblproducts')
                    ->select(Capsule::raw('*'))
                    ->whereIn('id', explode(',', $assignedProducts[0]->products))
                    //->where('servertype', '=', 'vpnservernoapi')
                    ->where('type', '!=', 'reselleraccount')
                    //->where('configoption1', '=', 'member')
                    //  ->whereIn('id', explode(',', $product_id[0]->product_id))
                    ->get();
            }
            else
            {
                
                $products = Capsule::table('tblproducts')
                    ->select(Capsule::raw('*'))
                    ->where('servertype', '=', 'vpnservernoapi')
                    //->where('type', '!=', 'reselleraccount')
                    ->whereIn('configoption1', ['reselleraccount', 'resellerCredits'])
                    //  ->whereIn('id', explode(',', $product_id[0]->product_id))
                    ->get();
            }
            }
            
                    
        }
        $currencydata = Capsule::table('tblclients')->where('id', '=', $_SESSION['uid'])->select('currency')
                ->get();
        $currency = $currencydata[0]->currency;
        $currencydetails = Capsule::table('tblcurrencies')->where('id', '=', $currency)->get();
        $CurrencyId = $currencydetails[0]->id;
//Get Product Customfields
        foreach ($products as $product) {
            $addonpackagearray[$product->id] = self::getProductAddon($product->id, $CurrencyId);
            $customfields[$product->id] = self::getProductCustomFields($product->id);
            $billingcycle[$product->id] = self::getProductBillingCycle($product->id, $currency);
            $configuralOption[$product->id] = self::getProductConfigOption($product->id, $currency);
        }
        /*$config = Capsule::table('mod_xtreamsetting')->get();
        foreach ($config as $value) {
            $row[$value->setting] = $value->value;
        }*/
        $userinfo = 'no';
        if (isset($row['login']) || isset($row['password']) || isset($row['confirmpassword']) || isset($row['clientname']) || isset($row['companyname']) || isset($row['address1']) || isset($row['address2']) || isset($row['city']) || isset($row['state']) || isset($row['postcode']) || isset($row['phonenumber'])) {
            $userinfo = 'yes';
        }
        /*$xtreamConfig = Capsule::table('mod_xtreamConfig')
                ->get();*/
                $creditsDetails = self::CheckAffCredit();
       $totalCredits = $creditsDetails->credit;
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        $creditsDetails = self::CheckAffCredit();
       $totalCredits = $creditsDetails->credit;
        $response = array(
            'totalcredit' => $totalCredits,
            'modulelink' => $modulelink,
            'optionactive' => $row,
            'customfields' => $customfields,
            'products' => $products,
            'billingcycle' => $billingcycle,
            'addonpackagearray' => $addonpackagearray,
            'configuralOption' => $configuralOption,
            'errormessage' => $errormessage,
            'currency' => $currencydetails[0],
            'successmessage' => $successmessage,
            'maccustomfieldname' => $returndata['custom_field_mag'],
            'e2customfieldname' => $returndata['custom_field_eng'],
            'topup' => $returndata['gid'],
            'userinfo' => $userinfo,
            'settings' => $settings,
        );
        //print_r($response); die(sdf);
        if (isset($_GET['result']) && $_GET['result'] == 'pkerror') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> Please Choose Plan!";
        } elseif (isset($_GET['result']) && $_GET['result'] == 'bcerror') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> Please select billing cycle!";
        } elseif (isset($_GET['result']) && $_GET['result'] == 'macerror') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> MAG Address Required!";
        } elseif (isset($_GET['result']) && $_GET['result'] == 'macexists') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> MAG Address Already Exists!";
        } elseif (isset($_GET['result']) && $_GET['result'] == 'engerror') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> " . $returndata['custom_field_eng'] . " Required!";
        } elseif (isset($_GET['result']) && $_GET['result'] == 'macvalid') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> MAG Address is not Valid!";
        } elseif (isset($_GET['result']) && $_GET['result'] == 'ucerror') {
            $response['result'] = "danger";
            $response['message'] = "<strong>Error!</strong> Username already exists!";
        }

        /* echo "<pre>";print_r($billingcycle);die(); */
        $response['selectuser'] = 'Reseller';
        $response['addreseller'] = 'class="active"';
        return array(
            'pagetitle' => 'Add New Reseller',
            'breadcrumb' => array(
                'index.php?m=vpnpanel' => 'Dashboard',
                'index.php?m=vpnpanel&action=addreseller' => 'Add New Reseller'),
            'templatefile' => 'vpnadduser',
            'requirelogin' => true, # accepts true/false
            'forcessl' => false, # accepts true/false
            'vars' => $response
        );
    
    }

    public function installpanel($vars)
    {
        $CONFIG = Capsule::table('tblconfiguration')
                ->where('setting', '=', 'SystemURL')
                ->get();

                $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
        $response = array(
            'modulelink' => $modulelink,);
        $system_url = $CONFIG[0]->value;
        $response['deleted'] = '';

        $websitedata = Capsule::table('vpnmywebsite')->where('uid',$_SESSION['uid'])->select('sep_vpn_panel')->get();
            $message = '';
            $result = '';
            //echo '<pre>'; print_r($_POST); die();
            if(isset($_POST['reinstallpanel']))
            {
                Capsule::table('vpnmywebsite')->where('uid',$_SESSION['uid'])->update(['sep_vpn_panel' => '']);
                $response['deleted'] = 'true';
            }
            $response['sep_vpn_panel'] = '';
            $response['installationStarted'] = 'false';
        if(empty($websitedata[0]->sep_vpn_panel))
        {
        if(isset($_POST['server_ip']) && !empty($_POST['server_ip']))
        {
            
            $serverIP = $_POST['server_ip'];
            $license = $_POST['license'];
            $customPath = $_POST['custom_install_path'];
            $customDir = $_POST['install_path'];
            $dirpath = (!empty($_POST['custom_install_path']))?$_POST['custom_install_path']:'/var/www/html/'.$_POST['install_path'];
            $domain = (!empty($_POST['domain']))?$_POST['domain']:'http://'.$serverIP.'/';
            $sshport = $_POST['sshport'];
            $sshpass = $_POST['sshpass'];
            $serviceid = $_SESSION['uid'];
            //$upgrade = (isset($_POST['upgrade']))?1:'';
            $mysqluser = $_POST['mysqluname'];
            $mysqlpass = $_POST['mysqlpass'];
            $mysqldb = $_POST['mysqldb'];
            $mainpanelURL = $system_url;
            $whmcslicense = $_POST['whmcslicense'];
            $fullpath = $domain.(!empty($_POST['custom_install_path']))?$_POST['custom_install_path']:$customDir;

            $installscriptfile = 'install-reseller-smartersvpnpanel.sh';
            set_include_path(get_include_path() . PATH_SEPARATOR . 'phpseclib');
                require_once __DIR__ . '/../../phpseclib/Crypt/RC4.php';
                require_once __DIR__ . '/../../phpseclib/Crypt/Rijndael.php';
                require_once __DIR__ . '/../../phpseclib/Crypt/Twofish.php';
                require_once __DIR__ . '/../../phpseclib/Crypt/Blowfish.php';
                require_once __DIR__ . '/../../phpseclib/Crypt/TripleDES.php';
                require_once __DIR__ . '/../../phpseclib/Crypt/Random.php';
                require_once __DIR__ . '/../../phpseclib/Crypt/Hash.php';
                require_once __DIR__ . '/../../phpseclib/Math/BigInteger.php';
                require_once __DIR__ . '/../../phpseclib/Net/SSH2.php';


                $ssh = new Net_SSH2($serverIP, $sshport);
                //echo '<pre>'; print_r($ssh); die();
            if (!$ssh->login('root', $sshpass)) {
                logActivity('**Server ' . $serverIP . ' - '.$sshpass.' Error - Login Failed.**', 0);
                $result = 'danger';
                $message = 'Login Failed!';
            }
            else
            {

        $ssh->exec('apt-get install curl -y'); //Installing cURL
        //$ssh->exec('sudo lshw -html > lshw.html');//creating server info html
        if(!isset($_POST['upgrade']))
        {
        $ssh->exec('curl -O -H "Authorization: token 194f07247ea811f481b76c7c79f32a88dd3ba399" https://raw.githubusercontent.com/whmcs-smarters/installscripts/master/checkMainServerCompatibility.sh');
        $ssh->exec('chmod +x checkMainServerCompatibility.sh');
        $servercheck = $ssh->exec("./checkMainServerCompatibility.sh -p '".$dirpath."'");
        //echo '<pre>'; print_r($servercheck); die();
        $servercheck = trim($servercheck);
        if (!empty($servercheck)) {
            if($servercheck == "installed")
        {
            $response['alreadyinstalled'] = true;
            $message = 'VPN Panel Already Installed.';
            $response['serverIP'] = $serverIP;
            $response['serverPass'] = $sshpass;
            $response['domain'] = $domain;
            $response['path'] = $_POST['install_path'];
            $response['custompath'] = $_POST['custom_install_path'];
            $response['license'] = $_POST['license'];
            $response['port'] = $_POST['sshport'];
        }
        else
        {
            $message = $servercheck;
            $result = 'danger';
        }
        }
        else
        {
            $ssh->exec('curl -O -H "Authorization: token 194f07247ea811f481b76c7c79f32a88dd3ba399" https://raw.githubusercontent.com/whmcs-smarters/installscripts/master/'.$installscriptfile.''); // get script file on server
        $ssh->exec('chmod +x '.$installscriptfile.''); // set permission to script file
        $upgrade = '';
        if(isset($_POST['upgrade']))
    {
        $upgrade = "-g 'yes' -u '".$mysqluser."' -q '".$mysqlpass."' -b '".$mysqldb."'";
        $tasktype = 'upgraded';
    } 
        $scriptParams = "-l '".$license."' -p '".$dirpath."' -d '".$fullpath."' -s '".$sshport."' -a '".$sshpass."' -i '".$serviceid."' ".$upgrade." -m '".$mainpanelURL."' -w '".$whmcslicense."'";
         
            $process = $ssh->exec("./".$installscriptfile." ".$scriptParams." > /dev/null 2>&1 &");
            
            $serverconfigvars = "./".$installscriptfile." ".$scriptParams." > /dev/null 2>&1 &";
        logModuleCall('VPN Panel', 'Server Config define vars', $serverIP, $serverconfigvars, '', '');
            $username = '';
            $password = '';
        if(isset($_POST['upgrade']))
            {
                $username = 'Existing Username';
                $password = 'Existing Password';
            }
            else
            {
                $username = 'admin';
                $password = 'admin';
            }
        
            $result = 'success';
            $message = 'Installation Started';
            $response['installationStarted'] = 'true';
            $response['domain'] = $domain;
            $response['username'] = $username;
            $response['password'] = $password;
        }
        }
        else
        {
            $ssh->exec('curl -O -H "Authorization: token 194f07247ea811f481b76c7c79f32a88dd3ba399" https://raw.githubusercontent.com/whmcs-smarters/installscripts/master/'.$installscriptfile.''); // get script file on server
        $ssh->exec('chmod +x '.$installscriptfile.''); // set permission to script file
        $upgrade = '';
        if(isset($_POST['upgrade']))
    {
        $upgrade = "-g 'yes' -u '".$mysqluser."' -q '".$mysqlpass."' -b '".$mysqldb."'";
        $tasktype = 'upgraded';
    } 
        $scriptParams = "-l '".$license."' -p '".$dirpath."' -d '".$fullpath."' -s '".$sshport."' -a '".$sshpass."' -i '".$serviceid."' ".$upgrade." -m '".$mainpanelURL."' -w '".$whmcslicense."'";
         
            $process = $ssh->exec("./".$installscriptfile." ".$scriptParams." > /dev/null 2>&1 &");
            
            $serverconfigvars = "./".$installscriptfile." ".$scriptParams." > /dev/null 2>&1 &";
        logModuleCall('VPN Panel', 'Server Config define vars', $serverIP, $serverconfigvars, '', '');
            $username = '';
            $password = '';
        if(isset($_POST['upgrade']))
            {
                $username = 'Existing Username';
                $password = 'Existing Password';
            }
            else
            {
                $username = 'admin';
                $password = 'admin';
            }
        
            $result = 'success';
            $message = 'Installation Started';
            $response['installationStarted'] = 'true';
            $response['domain'] = $domain;
            $response['username'] = $username;
            $response['password'] = $password;
        }
        
        
        
            
        

        
    

        }
        }
}else
{
    $response['sep_vpn_panel'] = $websitedata[0]->sep_vpn_panel;
    $explodedata = explode(',',$websitedata[0]->sep_vpn_panel);
    $response['domain'] = $explodedata[0];
    $response['username'] = $explodedata[1];
    $response['password'] = $explodedata[2];
}

        $response['result'] = $result;
        $response['message'] = $message;
        $response['servicedetails'] = $clientsData1;
        $response['totalcredit'] = $totalCredits;
        $response['installactive'] = 'class="active"';
        return array(
            'pagetitle' => 'Install Separate VPN Panel',
            'breadcrumb' => array(
                'index.php?m=vpnpanel' => 'vpnpanel',
                'index.php?m=vpnpanel&action=vpninstall' => 'Install Separate VPN Panel',
            ),
            'templatefile' => 'vpninstallpanel',
            'requirelogin' => true, // Set true to restrict access to authenticated client users
            'forcessl' => false, // Deprecated as of Version 7.0. Requests will always use SSL if available.
            'vars' => $response,
        );
    
    
    }


    public function vpn_resellerapikey($vars)
    {
        include_once(''.__DIR__ . '/../../../ResellerAutomaticAPI/functions.php');
        $CONFIG = Capsule::table('tblconfiguration')
                ->where('setting', '=', 'SystemURL')
                ->get();

                $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
        $system_url = $CONFIG[0]->value;
        $creditsDetails = self::CheckAffCredit();
       $totalCredits = $creditsDetails->credit;
 $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
        $errormessage = false;
        $successmessage = false;
       $data = Capsule::table('tbladdonmodules')->where('module','ResellerAutomaticAPI')->where('setting','salt')->get();
       $salt = $data[0]->value;
       $resellerid = $_SESSION["uid"];
$apikey = '';
$apipassword = '';
$apiallowedips = '';
$result = '';
$message = '';

$resaellerapidata = Capsule::table('ResellerAutomaticAPI')->where('uid',$resellerid)->get();

if(isset($resaellerapidata[0]->uid))
{
    $apikey = $resaellerapidata[0]->username;
    $apipassword = ResellerAutomatic_decrypt($resaellerapidata[0]->password, $salt);
    $apiallowedips = $resaellerapidata[0]->allowedips;
}

if (isset($_POST['generate'])) {
    
    //echo $resellerid;die();
    $username = whmcsapi_generateRandomString(15);
    $password = whmcsapi_generateRandomString(15);
    $epassword = (!empty($salt)) ? ResellerAutomatic_encrypt($password, $salt) : ResellerAutomatic_encrypt($password);
    $exist = Capsule::table('ResellerAutomaticAPI')->where('uid',$resellerid)->get();
    
    if (!isset($exist[0]->uid)) {
        Capsule::table('ResellerAutomaticAPI')->insert(['username' => $username, 'password' => $epassword,'uid' => $resellerid]);
    } else {
        Capsule::table('ResellerAutomaticAPI')->where('uid',$resellerid)->update(['username' => $username, 'password' => $epassword]);
    }
    return true;
}

if (isset($_POST['addip'])) {
   
    //echo $resellerid;die();
    $allowedips = $_POST['allowedips'];
    $exist = Capsule::table('ResellerAutomaticAPI')->where('uid',$resellerid)->get();
    if (!isset($exist[0]->uid)) {
        Capsule::table('ResellerAutomaticAPI')->insert(['allowedips' => $allowedips]);
    } else {
        Capsule::table('ResellerAutomaticAPI')->where('uid',$resellerid)->update(['allowedips' => $allowedips]);
    }
    return true;
}
if (isset($_POST['delete'])) {
       Capsule::table('ResellerAutomaticAPI')->where('uid',$resellerid)->delete();
       return true;
    }
        $response['result'] = $result;
        $response['allowedips'] = $apiallowedips;
        $response['apikey'] = $apikey;
        $response['apipassword'] = $apipassword;
        $response['message'] = $message;
        $response['totalcredit'] = $totalCredits;
        $response['APIKEYactive'] = 'class="active"';
        $response['topup'] = '12';
        $response['modulelink'] = $modulelink;
        return array(
            'pagetitle' => 'Generate API key',
            'breadcrumb' => array(
                'index.php?m=vpnpanel' => 'vpnpanel',
                'index.php?m=vpnpanel&action=vpn_resellerapikey' => 'Generate API key',
            ),
            'templatefile' => 'vpngenerateresellerapi',
            'requirelogin' => true, // Set true to restrict access to authenticated client users
            'forcessl' => false, // Deprecated as of Version 7.0. Requests will always use SSL if available.
            'vars' => $response,
        );
    }


    public function resellers($vars) {

        $SearchedMacAddress = "";
        $clientdata = Capsule::table('tblclients')->where('id', '=', $_SESSION['uid'])->get();
        $creditsDetails = self::CheckAffCredit();
       $totalCredits = $creditsDetails->credit;
// Get common module parameters
        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
        $response = array(
            'modulelink' => $modulelink,);
        /*
         * Reseller Clients
         */
        if(isset($_POST['addCredits']))
        {
            $resellerid = $_SESSION['uid'];
            $credits = $_POST['credits'];
            $remainingCredits = $_POST['remainingCredits'];
            $description = (!empty($_POST['description']))?$_POST['description']:'Funds Added by Reseller ID- '.$resellerid.'';

            $clientid = $_POST['clientid'];
            $command = 'AddCredit';
            $postData = array(
                'clientid' => $clientid,
                'description' => $description,
                'amount' => $credits,
            );
            

            $results = localAPI($command, $postData);
           if($results['result'] == 'success')
            {
                $resellercreditsupdate = Capsule::table('tblclients')->where('id',$resellerid)->update(['credit' => $remainingCredits]);
                $result = 'success';
                $message = 'Success! Credits Added Successfully';
            }
            else
            {
                $result = 'danger';
                $message = $results['message'];
            }

        }
        
        $email = $clientdata[0]->email;
        $affiliateid = self::getWHMCSaffid();
        
        $clients1 = Capsule::table('tblaffiliatesaccounts')->where('tblaffiliatesaccounts.affiliateid',$affiliateid)->join('tblclients','tblclients.id','=','tblaffiliatesaccounts.relid')->where('tblclients.groupid',1)->select('tblclients.*')->get();
        $clientsData1 = array();
        //echo '<pre>';print_r($clients1); die(sdf);

        $i = 0;
        foreach($clients1 as $client1)
        {
            if($client1->groupid !== 0)
            {
            $clientsData1[$i]['client_id'] = $client1->id;
             $clientsData1[$i]['firstname'] = $client1->firstname;
              $clientsData1[$i]['lastname'] = $client1->lastname;
               $clientsData1[$i]['email'] = $client1->email;
           }
               $i++; 
        }
        
        
        
        $response['servicedetails'] = $clientsData1;
        $response['totalcredit'] = $totalCredits;
        $response['reseller'] = 'class="active"';
        return array(
            'pagetitle' => 'Resellers List',
            'breadcrumb' => array(
                'index.php?m=vpnpanel' => 'vpnpanel',
                'index.php?m=vpnpanel&action=resellers' => 'Resellers list',
            ),
            'templatefile' => 'vpnusers',
            'requirelogin' => true, // Set true to restrict access to authenticated client users
            'forcessl' => false, // Deprecated as of Version 7.0. Requests will always use SSL if available.
            'vars' => $response,
        );
    
    }

    public function getWHMCSaffid() {

        $command = 'getaffiliates';
        $adminuser = Capsule::table('tbladmins')
                ->where('roleid', '=', 1)
                ->get();
        $values['userid'] = $_SESSION['uid'];
        $affdetails = localAPI($command, $values, $adminuser[0]->username);
        if ($affdetails['result'] === 'success' && $affdetails['totalresults'] == 1) {
            $affdetaildata = $affdetails['affiliates']['affiliate'][0];
        }
        if (isset($affdetaildata['id']) && !empty($affdetaildata['id'])) {
            return $affdetaildata['id'];
        } else {
            return 'notfoundaffiliate';
        }
    }

    public function CheckAffCredit() {
        $credit = Capsule::table('tblclients')
                ->select('credit', 'firstname', 'lastname', 'email')
                ->where('id', '=', $_SESSION['uid'])
                ->get();
        return $credit[0];
    }

    public function AddClientInXtreamm($params, $action) {
        $customfields = $params['customfields'][$params['packageid']];
        foreach ($customfields as $customfieldkey => $customfieldvalue) {
            $fieldId = mysql_fetch_assoc(mysql_query("SELECT tblcustomfields.id FROM `tblcustomfields` WHERE fieldname='$customfieldkey' AND type='product'   AND relid='" . $params['packageid'] . "'"));
            if (0 != mysql_num_rows(mysql_query("SELECT * FROM`tblcustomfieldsvalues` WHERE `relid`='" . $params['serviceid'] . "' AND fieldid=(SELECT tblcustomfields.id FROM `tblcustomfields` WHERE fieldname='$customfieldkey' AND type='product' AND relid='" . $params['packageid'] . "')"))) {
                mysql_query("UPDATE `tblcustomfieldsvalues` SET value='$customfieldvalue' WHERE `relid`='" . $params['serviceid'] . "' AND fieldid=(SELECT tblcustomfields.id FROM `tblcustomfields` WHERE fieldname='$customfieldkey' AND type='product'   AND relid='" . $params['packageid'] . "')");
            } else {
                mysql_query("INSERT INTO `tblcustomfieldsvalues` (`fieldid`, `relid`, `value`) VALUES ('" . $fieldId['id'] . "', '" . $params['serviceid'] . "' , '$customfieldvalue')") or die(mysql_error());
            }
        }
        /*
         * Update User name and Password of the server order
         */
        if ($action == 'users') {
            $admin = Capsule::table('tbladmins')
                    ->where('roleid', '=', 1)
                    ->get();
            $adminuser = $admin[0]->username;
            $encryptpassword = "encryptpassword";
            $values["password2"] = $params['xtreampassword'];
            $results = localAPI($encryptpassword, $values, $adminuser);
            mysql_query("UPDATE `tblhosting` SET  password='" . $results['password'] . "',username='" . $params['xtreamusername'] . "'  WHERE id=" . $params['serviceid']);
            return $results;
        }
    }
 
    public function WHMCSdoLogin() {
       
        $_SESSION['login_auth_tk'] = $_SESSION['vpn_login_auth_tk'];
        $_SESSION['uid'] = $_SESSION['vpnuserid'];
        //echo 'We are here <pre>';print_r($_SESSION); die();
    }

    public function XtreamCode_WHMCSReconnect() {
        require( ROOTDIR . "/configuration.php" );
        $whmcsmysql = mysqli_connect($db_host, $db_username, $db_password, $db_name);
    }

    public function WHMCSClientDetails($clientid) {
        $clients = Capsule::table('tblclients')
                ->select(Capsule::raw('*'))
                ->where('id', '=', $clientid)
                ->where('groupid', '=', 0)
                ->select('firstname', 'lastname', 'companyname', 'email', 'id as client_id')
                ->get();
        $customfields = Capsule::table('tblcustomfields')
                ->join('tblcustomfieldsvalues', 'tblcustomfields.id', '=', 'tblcustomfieldsvalues.fieldid')
                ->select('tblcustomfields.fieldname', 'tblcustomfieldsvalues.*')
                ->where('tblcustomfields.type', '=', "client")
                ->where('tblcustomfieldsvalues.relid', '=', $clientid)
                ->where('tblcustomfields.fieldname', '=', 'logincode')
                ->get();
        if (isset($clients[0]) && !empty($clients[0])) {
            if (isset($customfields) && !empty($customfields)) {
                foreach ($customfields as $customfield) {
                    if ($customfield->fieldname == 'logincode') {
                        $clients[0] = array_merge((array) $clients[0], array('logincode' => $customfield->value));
                    }
                }
                !empty($clients[0]) ? $clients_data = (array) $clients[0] : '';
            } else {
                !empty($clients[0]) ? $clients_data = (array) $clients[0] : '';
            }
        }
        return $clients_data;
    }

    public function WHMCSClientResellerDetails($clientid) {
        self::XtreamCode_WHMCSReconnect();
        $clientgrop = Capsule::table('tblclientgroups')->whereIN('groupname', ['Reseller', 'Super-Reseller'])->get();
        $clients = Capsule::table('tblclients')->where('id', '=', $clientid)->whereIn('groupid', [$clientgrop[0]->id, $clientgrop[1]->id])->select('firstname', 'lastname', 'companyname', 'email', 'id as client_id', 'groupid')->get();
        if (isset($clients[0]) && !empty($clients[0])) {
            $customfields = Capsule::table('tblcustomfields')
                    ->join('tblcustomfieldsvalues', 'tblcustomfields.id', '=', 'tblcustomfieldsvalues.fieldid')
                    ->select('tblcustomfields.fieldname', 'tblcustomfieldsvalues.*')
                    ->where('tblcustomfields.type', '=', "client")
                    ->where('tblcustomfieldsvalues.relid', '=', $clientid)
                    ->where('tblcustomfields.fieldname', '=', 'logincode')
                    ->get();
            if (isset($customfields) && !empty($customfields)) {
                foreach ($customfields as $customfield) {
                    if ($customfield->fieldname == 'logincode') {
                        $clients[0] = array_merge((array) $clients[0], array('logincode' => $customfield->value));
                    }
                }
                !empty($clients[0]) ? $clients_data = (array) $clients[0] : '';
            } else {
                !empty($clients[0]) ? $clients_data = (array) $clients[0] : '';
            }
        }
        return $clients[0];
    }

    public function WHMCSClientServices($clientid) {
        self::XtreamCode_WHMCSReconnect();
        $command = 'GetClientsProducts';
        $postData = array(
            'clientid' => $clientid,
            'stats' => true,
        );
        $results = localAPI($command, $postData, self::XtreamDashboard_whmcsadmin());
        if ($results['result'] == "success") {
            $ProductsLists = $results['products']['product'];
            if (!empty($ProductsLists)) {
                foreach ($ProductsLists as $KeyUH => $ProductKey) {
                    if ($ProductKey['serverhostname'] == "") {
                        $Hostname = Capsule::table('tblproducts')
                                ->join('tblservergroupsrel', 'tblproducts.servergroup', '=', 'tblservergroupsrel.groupid')
                                ->join('tblservers', 'tblservergroupsrel.serverid', '=', 'tblservers.id')
                                ->where('tblproducts.id', $ProductKey['pid'])
                                ->select('tblservers.hostname')
                                ->get();
                        if (!empty($Hostname)) {
                            $results['products']['product'][$KeyUH]['serverhostname'] = $Hostname[0]->hostname;
                        }
                    }
                }
            }
        }
        return $results;
    }

    public function XtreamDashboard_whmcsadmin() {
        $whmcsadmin = Capsule::table('tbladmins')
                ->where('id', '1')
                ->get();
        return $whmcsadmin[0]->username;
    }

    public function getProductCustomFields($productid) {
        $serverdetails = Capsule::table('tblcustomfields')
                ->select('*')
                ->where('relid', '=', $productid)
                ->where('type', '=', 'product')
                ->orderBy('sortorder', 'asc')
                ->get();
        return $serverdetails;
    }

    public function getProductBillingCycle($productid, $currency) {
        $productcycle = Capsule::table('tblproducts')
                ->join('tblpricing', 'tblproducts.id', '=', 'tblpricing.relid')
                ->where('tblpricing.relid', '=', $productid)
                ->where('tblpricing.type', '=', 'product')
                ->where('tblpricing.currency', '=', $currency)
                ->where('tblproducts.paytype', '!=', 'free')
                ->select('tblpricing.*', 'tblproducts.paytype')
                ->get();
        if (isset($productcycle) && !empty($productcycle))
            return $productcycle;
        else
            return '';
    }

    public function AddOrderWHMCS($vars) {
        $command = "addorder";
        $admin = Capsule::table('tbladmins')
                ->where('roleid', '=', 1)
                ->get();
        $adminuser = $admin[0]->username;
        if (isset($vars['addonsIds']) && $vars['addonsIds'] != "") {
            $values["addons"] = $vars['addonsIds'];
        }

        if (isset($vars['configoptions']) && $vars['configoptions'] != "") {
            $values["configoptions"] = $vars['configoptions'];
        }
        $values["clientid"] = $vars['client_id'];
        $values["pid"] = $vars['pid'];
        $values["billingcycle"] = $vars['billingcycle'];
        $values['promocode'] = $vars['promocode'];
        $payment = self::get_client_payment_gateway($_SESSION['uid']);
        $values["paymentmethod"] = $payment;
        $results = localAPI($command, $values, $adminuser);
        return $results;
    }

    public function get_client_payment_gateway($clientid) {
        $gateway = Capsule::table('tblpaymentgateways')->distinct('gateway')->where('order', '=', '1')->limit(1)->get();
        $defaultgateway = $gateway[0]->gateway;
        $res = full_query("SELECT `defaultgateway` FROM `tblclients` WHERE `id`='$clientid'");
        if (mysql_num_rows($res) > 0)
            $row = mysql_fetch_assoc($res);
        if (!empty($row['defaultgateway'])) {
            $defaultgateway = $row['defaultgateway'];
        }
        return $defaultgateway;
    }

    public function RemoveWHMCSCredit($credit) {
        $updatedUserCount = Capsule::table('tblclients')
                ->where('id', '=', $_SESSION['uid'])
                ->update(
                [
                    'credit' => $credit,
                ]
        );
        return true;
    }

    public function AddXtreamCredit($amount, $resellerid, $con) {
        /*$xtreamConfig = Capsule::table('mod_xtreamConfig')->get();*/
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        $tblclients = Capsule::table('tblclients')->where('id', $resellerid)->select('email')->get();
        $email = $tblclients[0]->email;
        $result = mysqli_query($con, "SELECT username,credits FROM reg_users WHERE email='" . $tblclients[0]->email . "'");
        if (mysqli_num_rows($result) > 0) {
            if ($returndata['syncredit'] == 'on') {
                $resellerdata = mysqli_fetch_assoc($result);
                $amount = $amount + $resellerdata['credits'];
                $update = mysqli_query($con, "UPDATE reg_users SET credits ='$amount' WHERE email='$email'");
                if (!$update) {
                    $radiussqlerror = mysqli_error($con);
                    self::XtreamCode_WHMCSReconnect();
                    logModuleCall('XtreamCode', 'Error Add Credits', 'Email Address : ' . $email, "XtreamCode Database Query Error: " . $radiussqlerror, '', '');
                    return "XtreamCode Database Query Error: " . $radiussqlerror;
                }
            }
        }
    }

    public function RemoveXtreamCredit($amount, $con) {
        /*$xtreamConfig = Capsule::table('mod_xtreamConfig')->get();*/
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        $tblclients = Capsule::table('tblclients')->where('id', $_SESSION['uid'])->select('email')->get();
        $email = $tblclients[0]->email;
        $result = mysqli_query($con, "SELECT username,credits FROM reg_users WHERE email='" . $tblclients[0]->email . "'");
        if (!$result) {
            $radiussqlerror = mysqli_error($con);
            self::XtreamCode_WHMCSReconnect();
            logModuleCall('VPN Panel', 'Check Reseller Exists', 'Email Address : ' . $email, "VPN Panel Error: " . $radiussqlerror, '', '');
            return "XtreamCode Database Query Error: " . $radiussqlerror;
        }
        if (mysqli_num_rows($result) > 0) {
            if ($returndata['syncredit'] == 'on') {
                $resellerdata = mysqli_fetch_assoc($result);
                $remaningamount = $resellerdata['credits'] - $amount;
                $update = mysqli_query($con, "UPDATE reg_users SET credits ='$remaningamount' WHERE email='$email'");
                if (!$update) {
                    $radiussqlerror = mysqli_error($con);
                    self::XtreamCode_WHMCSReconnect();
                    logModuleCall('XtreamCode', 'Error Add Credits', 'Email Address : ' . $email, "XtreamCode Database Query Error: " . $radiussqlerror, '', '');
                    return "XtreamCode Database Query Error: " . $radiussqlerror;
                }
            }
        }
    }

    public function vpncheckAffexists($clientid) {
        $data = Capsule::table('tblaffiliates')
                ->where('clientid', $clientid)
                ->get();
        $clientemail = Capsule::table('tblclients')
                        ->join('tblaffiliates', 'tblaffiliates.clientid', '=', 'tblclients.id')
                        ->where('tblaffiliates.id', '=', $data[0]->affiliatesid)
                        ->select('tblclients.email')->get();
        if (isset($clientemail) && !empty($clientemail))
            return $clientemail[0]->email;
        else
            return true;
    }

    public function WHMCSResellerServerId($account) {
        $serverid = 0;
        $products = Capsule::table('tblproducts')
                ->select(Capsule::raw('*'))
                ->where('servertype', '=', 'vpnservernoapi')
                ->where('configoption2', '=', $account)
                ->get();
        foreach ($products as $productdb) {
            $productids[] = $productdb->id;
        }
        $command = 'GetClientsProducts';
        $postData = array(
            'clientid' => $_SESSION['uid'],
            'stats' => true,
        );
        $admin = Capsule::table('tbladmins')
                ->where('roleid', '=', 1)
                ->get();
        $adminUsername = $admin[0]->username;
        $results = localAPI($command, $postData, $adminUsername);
        foreach ($results['products']['product'] as $product) {
            if (in_array($product['pid'], $productids)) {
                $serverid = $product['serverid'];
            }
        }
        return $serverid;
    }

    public function XtreamDashboard_testconnection() {
        /* CreateConnection */
        $clientdata = Capsule::table('tblclients')->where('id', '=', $_SESSION['uid'])->get();
// Get common module parameters 
        $clientgrop = Capsule::table('tblclientgroups')->where('id', '=', $clientdata[0]->groupid)->get();
        if ($clientgrop[0]->groupname == 'Reseller') {
            $account = 'reselleraccount';
        } elseif ($clientgrop[0]->groupname == 'Super-Reseller') {
            $account = 'superreselleraccount';
        }
        $serverid = self::WHMCSResellerServerId($account);
        $serverdetails = Capsule::table('tblservers')->where('id', '=', $serverid)->get();
        foreach ($serverdetails as $server) {
            $sqlusername = $server->username;
            $sqlpassword = decrypt($server->password);
            $sqldbname = $server->accesshash;
           $sqlhost = $server->ipaddress;
            list($sqldbname, $sqlport) = explode(':', $sqldbname);
            if (isset($sqlport) && !empty($sqlport))
                $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname, $sqlport);
            else
                $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname);
// Check connection 
            if (mysqli_connect_errno()) {
                logModuleCall('XtreamCode', 'Check Connection', 'Connection', "Failed to connect to MySQL: " . mysqli_connect_error(), '', '');
                return true;
            }
        }
        return $con;
    }

    public function VPN_StrongPassword($length = 9, $add_dashes = false, $available_sets = 'lud') {
        $sets = array();
        if (strpos($available_sets, 'l') !== false)
            $sets[] = 'abcdefghjkmnpqrstuvwxyz';
        if (strpos($available_sets, 'u') !== false)
            $sets[] = 'ABCDEFGHJKMNPQRSTUVWXYZ';
        if (strpos($available_sets, 'd') !== false)
            $sets[] = '23456789';
        $all = '';
        $password = '';
        foreach ($sets as $set) {
            $password .= $set[array_rand(str_split($set))];
            $all .= $set;
        }
        $all = str_split($all);
        for ($i = 0; $i < $length - count($sets); $i++)
            $password .= $all[array_rand($all)];
        $password = str_shuffle($password);
        if (!$add_dashes)
            return $password;
        $dash_len = floor(sqrt($length));
        $dash_str = '';
        while (strlen($password) > $dash_len) {
            $dash_str .= substr($password, 0, $dash_len) . '-';
            $password = substr($password, $dash_len);
        }
        $dash_str .= $password;
        return $dash_str;
    }

    public function XtreamAddCrdits($credits, $userid, $con, $page) {
        /*$xtreamConfig = Capsule::table('mod_xtreamConfig')
                ->get();*/
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        $affdetails = self::CheckAffCredit();
        if (isset($credits) && !empty($credits)) {
            if ($affdetails->credit < $credits) {
                header("LOCATION:index.php?m=vpnpanel&action=resellers&result=ccerror");
                exit;
            }
            $AddCredit = 'AddCredit';
            $postData = array(
                'clientid' => $userid,
                'description' => 'Added funds by ' . $affdetails->firstname . ' ' . $affdetails->lastname,
                'amount' => $credits,
            );
            $admin = Capsule::table('tbladmins')
                    ->where('roleid', '=', 1)
                    ->get();
            $adminUsername = $admin[0]->username;
            $resultsCredit = localAPI($AddCredit, $postData, $adminUsername);
            if ($resultsCredit['result'] == 'success') {
                Capsule::table('tblcredit')->insert(
                        ['clientid' => $_SESSION['uid'], 'date' => date('Y-m-d'), 'description' => 'Add Credit to Client - ' . $userid, 'amount' => -$credits]
                );
                $removeCredit = $affdetails->credit - $credits;
                self::RemoveWHMCSCredit($removeCredit);
                self::AddXtreamCredit($credits, $userid, $con);
                self::RemoveXtreamCredit($credits, $con);
                header("LOCATION:index.php?m=vpnpanel&action=$page&result=ccsuccess");
                exit;
            }
        } else {
            header("LOCATION:index.php?m=vpnpanel&action=$page&result=unablefetch");
            exit;
        }
        return $response;
    }

    public function WHMCSServiceDetails($username) {
        self::XtreamCode_WHMCSReconnect();
        $clientdata = Capsule::table('tblhosting')
                ->join('tblservers', 'tblhosting.server', '=', 'tblservers.id')
                ->join('tblproducts', 'tblhosting.packageid', '=', 'tblproducts.id')
                ->where('tblhosting.username', '=', $username)
                ->select('tblproducts.name', 'tblhosting.nextduedate', 'tblhosting.userid as clientid', 'tblproducts.id as pid', 'tblhosting.orderid', 'tblhosting.id', 'tblhosting.domainstatus as status', 'tblservers.hostname as serverhostname')
                ->get();
        if (isset($clientdata) && !empty($clientdata)) {
            $returndata = json_decode(json_encode($clientdata), true);
            return $returndata[0];
        } else {
            return true;
        }
    }

    public function vpnServices($selectedclientservices, $resellerdata, $con) {
        $reseller_detail = Capsule::table('tblclients')->where('id',$_SESSION['uid'])->select('email')->get();
       $resellerEmail = $reseller_detail[0]->email;
        
        $clients_detail = Capsule::table('tblclients')->where('tblclients.notes', 'Created by:'.$resellerEmail)
        ->join('tblhosting','tblhosting.userid','=','tblclients.id')
        ->join('tblproducts','tblproducts.id','=','tblhosting.packageid')
        ->select('tblclients.*','tblproducts.*','tblhosting.*')
        ->get();
        
        $clientsData1 = array();
        
        $i = 0;
        foreach($clients_detail as $client1)
        {
            $i++;
            $clientsData1[$i]['client_id'] = $client1->id;
            $clientsData1[$i]['firstname'] = $client1->first_name;
            $clientsData1[$i]['lastname'] = $client1->last_name;
            $clientsData1[$i]['email'] = $client1->email;
            $clientsData1[$i]['nextduedate'] = $client1->nextduedate;
            $clientsData1[$i]['status'] = ($client1->domainstatus == 'Active')?'<span class="label label-success">Active</span>':'<span class="label label-danger">'.$client1->domainstatus.'<span>';
            $clientsData1[$i]['username'] = $client1->username;
            $clientsData1[$i]['password'] = $client1->password;
            $clientsData1[$i]['name'] = $client1->name;
            
                
        }
        

        /* echo "<pre>";print_r($servicesdetails);die(); */
        $response['listallservices'] = 'class="active"';
        $response['modulelink'] = $modulelink;
        $response['servicedetails'] = $clientsData1;
        return array(
            'pagetitle' => 'Services',
            'breadcrumb' => array(
                'index.php?m=vpnpanel' => 'VPN Panel',
                'index.php?m=vpnpanel&action=vpnservices' => 'VPN Services Page',
            ),
            'templatefile' => 'vpnServices',
            'requirelogin' => true, // Set true to restrict access to authenticated client users
            'forcessl' => false, // Deprecated as of Version 7.0. Requests will always use SSL if available.
            'vars' => $response,
        );
       
    }

    public function CheckSelectedClientReseller($clientId) {
        $clientdata = Capsule::table('tblclients')->where('id', '=', $clientId)->get();
        $clientgrop = Capsule::table('tblclientgroups')->where('id', '=', $clientdata[0]->groupid)->get();
        return $clientgrop[0]->groupname;
    }

    public function XtreamDashboard_ChangeMAG(array $params, $newmac) {
        $servers = Capsule::table('tblproducts')
                ->join('tblservergroupsrel', 'tblproducts.servergroup', '=', 'tblservergroupsrel.groupid')
                ->join('tblservers', 'tblservergroupsrel.serverid', '=', 'tblservers.id')
                ->where('tblproducts.id', '=', $params['pid'])
                ->select('tblservers.*')
                ->get();
        $serviceid = $params["serviceid"];
// Collecting parameters
        $iptvusername = $params["username"];
        foreach ($servers as $server) {
            $sqlusername = $server->username;
            $sqlpassword = decrypt($server->password);
            $sqldbname = $server->accesshash;
            $sqlhost = $server->ipaddress;
            list($sqldbname, $sqlport) = explode(':', $sqldbname);
            if (isset($sqlport) && !empty($sqlport))
                $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname, $sqlport);
            else
                $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname);

// Check connection 
            if (mysqli_connect_errno()) {
                return "Failed to connect to MySQL: " . mysqli_connect_error();
            }
            /*$xtreamConfig = Capsule::table('mod_xtreamConfig')->get();*/
            $returndata = array();
            if (isset($xtreamConfig) && !empty($xtreamConfig)) {
                foreach ($xtreamConfig as $config) {
                    $returndata[$config->setting] = $config->value;
                }
            }
            $reseller_notes = $returndata['common_identifier'] . $serviceid;
# Inserting Now New User into 
// First checking if user already exist with reqeuest username  
            $result = mysqli_query($con, "SELECT id FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1'");

            if (!$result) {
                $radiussqlerror = mysqli_error($con);
                self::XtreamCode_WHMCSReconnect();
                return "vpnpanel Database Query Error: " . $radiussqlerror;
            }
            if (mysqli_num_rows($result) > 0) {
                $resultmag_devices = mysqli_query($con, "SELECT * FROM mag_devices WHERE mac='" . base64_encode($newmac) . "'");
                if (mysqli_num_rows($resultmag_devices) == 0) {
                    $userid = mysqli_fetch_assoc($result);
                    $updatepair = mysqli_query($con, "UPDATE mag_devices SET  mac='" . base64_encode($newmac) . "' WHERE user_id='" . $userid['id'] . "'");
                    if (!$updatepair) {
                        $radiussqlerror = mysqli_error($con);
                        self::XtreamCode_WHMCSReconnect();
                        return "XtreamCode Database Query Error: " . $radiussqlerror;
                    }
                    self::XtreamCode_WHMCSReconnect();
                    /*$xtreamConfig = Capsule::table('mod_xtreamConfig')->get();*/
                    $returndata = array();
                    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
                        foreach ($xtreamConfig as $config) {
                            $returndata[$config->setting] = $config->value;
                        }
                    }
                    $fieldid = Capsule::table('tblcustomfields')
                            ->where('fieldname', $returndata['custom_field_mag'])
                            ->where('type', 'product')
                            ->where('relid', $params['pid'])
                            ->get();
                    if (isset($fieldid) && !empty($fieldid)) {
                        $checkExists = Capsule::table('tblcustomfieldsvalues')
                                ->where('relid', $params['serviceid'])
                                ->where('fieldid', $fieldid[0]->id)
                                ->get();
                        if (isset($checkExists) && !empty($checkExists)) {
                            Capsule::table('tblcustomfieldsvalues')
                                    ->where('relid', $params['serviceid'])
                                    ->where('fieldid', $fieldid[0]->id)
                                    ->update(['value' => $newmac]);
                        } else {
                            Capsule::table('tblcustomfieldsvalues')->insert(
                                    ['fieldid' => $fieldid[0]->id, 'relid' => $params['serviceid'], 'value' => $newmac]
                            );
                        }
                    }
                    $domainMAC = Capsule::table('tblhosting')
                            ->where('id', $params['serviceid'])
                            ->update(['domain' => $newmac]);
                } else {
                    return "MAC Address already exists.";
                }
            }
        }
        return 'success';
    }

    public function XtreamDashboard_AddMAG(array $params, $newmac) {
        $servers = Capsule::table('tblproducts')
                ->join('tblservergroupsrel', 'tblproducts.servergroup', '=', 'tblservergroupsrel.groupid')
                ->join('tblservers', 'tblservergroupsrel.serverid', '=', 'tblservers.id')
                ->where('tblproducts.id', '=', $params['pid'])
                ->select('tblservers.*')
                ->get();
        /*$xtreamConfig = Capsule::table('mod_xtreamConfig')->get();*/
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        $tblhostingdetails = Capsule::table('tblhosting')->where('id', '=', $params["serviceid"])->get();
        $nextduedate = $tblhostingdetails[0]->nextduedate;
        $regdate = $tblhostingdetails[0]->regdate;
        $serviceid = $params["serviceid"];
        $product = Capsule::table('tblproducts')->where('id', '=', $params["pid"])->get();
        $is_trial = ($product[0]->configoption5 == 'Yes') ? '1' : '0';
        $member_id = $product[0]->configoption9;
        $Bouquets = $product[0]->configoption10;
        $syn_expiry = $product[0]->configoption17;
        $trial_period = ($product[0]->configoption18 != 0) ? '+' . $product[0]->configoption18 . ' hours' : '+24 hours';
        $expdate = 'NULL';
        if ($is_trial == 1 && $nextduedate != '0000-00-00') {
            $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
        } else {
            if ($syn_expiry == 'on' && $nextduedate != '0000-00-00') {
                $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
            } elseif ($is_trial == 1) {
                $expdate = strtotime(date("Y-m-d H:i:s", strtotime($trial_period)));
            }
        }
        // Collecting parameters
        $iptvusername = $params["username"];
        $password = $params["password"];
        foreach ($servers as $server) {
            $sqlusername = $server->username;
            $sqlpassword = decrypt($server->password);
            $sqldbname = $server->accesshash;
            $sqlhost= $server->ipaddress;
             list($sqldbname, $sqlport) = explode(':', $sqldbname);
            if (isset($sqlport) && !empty($sqlport))
                $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname, $sqlport);
            else
                $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname);
            // Check connection 
            if (mysqli_connect_errno()) {
                return "Failed to connect to MySQL: " . mysqli_connect_error();
            }
            $username = $iptvusername . $returndata['common_identifier'] . $serviceid;
            $reseller_notes = $returndata['common_identifier'] . $serviceid;
            # Inserting Now New User into 
            // First checking if user already exist with reqeuest username  
            $result = mysqli_query($con, "SELECT id FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1'");
            if (!$result) {
                $radiussqlerror = mysqli_error($con);
                XtreamCode_WHMCSReconnect();
                return "XtreamCode Database Query Error: " . $radiussqlerror;
            }
            if (mysqli_num_rows($result) > 0) {
                XtreamCode_WHMCSReconnect();
                return "This {$reseller_notes} User is already exists";
            }
            //Check MAG Already Exists
            $resultmag_devices = mysqli_query($con, "SELECT * FROM mag_devices WHERE mac = '" . base64_encode($newmac) . "'");
            if (mysqli_num_rows($resultmag_devices) != 0) {
                return "MAG Address already exists!";
            }
            $userid = array();
            if ($params['configoption2'] == 'magdevice') {
                $userid['id'] = '';
            } else {
                $checkmagdevice = $params['customfields'][$returndata['checkmagdevice']];
                if (isset($checkmagdevice) && !empty($checkmagdevice) && $checkmagdevice == 'on') {
                    $userid['id'] = '';
                } else {
                    $iptvusernameresult = mysqli_query($con, "SELECT id FROM users WHERE username='$iptvusername'");
                    if (mysqli_num_rows($iptvusernameresult) == 0) {
                        XtreamCode_WHMCSReconnect();
                        return "User Not Found!!";
                    } else {
                        $userid = mysqli_fetch_assoc($iptvusernameresult);
                    }
                }
            }
            $clientemail = self::vpncheckAffexists($params['userid']);
            if (!empty($clientemail)) {
                $result = mysqli_query($con, "SELECT id FROM reg_users WHERE email='$clientemail'");
                if (!$result) {
                    $radiussqlerror = mysqli_error($con);
                    self::XtreamCode_WHMCSReconnect();
                    logModuleCall('XtreamCode', 'Check Reseller Exists', 'Email Address : ' . $clientemail, "XtreamCode Database Query Error: " . $radiussqlerror, '', '');
                    return "XtreamCode Database Query Error: " . $radiussqlerror;
                }
                if (mysqli_num_rows($result) > 0) {
                    $resellerdata = mysqli_fetch_assoc($result);
                    $member_id = $resellerdata['id'];
                }
            }
# Inserting Now New User into 
            $query = "INSERT INTO users (member_id , username , password , admin_enabled , enabled , reseller_notes , bouquet , created_at , created_by , pair_id , is_mag,exp_date,is_trial)  
                         VALUES ('$member_id' , '$username' , '$password' , 1 , 1 , '" . $returndata['common_identifier'] . $serviceid . "' , '$Bouquets' , " . strtotime($regdate) . ", 0 , '" . $userid['id'] . "' , 1,$expdate,$is_trial)";
            $result = mysqli_query($con, $query);
            if (!$result) {
                $radiussqlerror = mysqli_error($con);
                self::XtreamCode_WHMCSReconnect();
                return "XtreamCode Database Query Error: " . $radiussqlerror;
            } else {
                $lastinsertid = mysqli_insert_id($con);
                $updatepair = mysqli_query($con, "UPDATE users SET  pair_id='" . $lastinsertid . "' WHERE username='$iptvusername'");
                if (!$updatepair) {
                    $radiussqlerror = mysqli_error($con);
                    self::XtreamCode_WHMCSReconnect();
                    return "XtreamCode Database Query Error: " . $radiussqlerror;
                }
# Inserting Now New User into 
                //Access Output Setting in X.C
                $accessoutput = mysqli_query($con, "SELECT * FROM `access_output`");
                if (mysqli_num_rows($accessoutput) > 0) {
                    while ($accessoutputdata = mysqli_fetch_assoc($accessoutput)) {
                        mysqli_query($con, "INSERT INTO user_output(user_id, access_output_id) VALUES('" . $lastinsertid . "', '" . $accessoutputdata['access_output_id'] . "')");
                    }
                }
                //Add MAG Device in X.C  
                $mag_devices = "INSERT INTO mag_devices (user_id , bright , contrast , saturation  , video_out , volume , playback_buffer_bytes , playback_buffer_size , audio_out , mac , locale , city_id , hd , main_notify , fav_itv_on , now_playing_start , now_playing_type , now_playing_content , time_last_play_tv , time_last_play_video , hd_content , image_version , last_change_status , last_start , last_active , keep_alive , playback_limit , screensaver_delay , stb_type , sn , last_watchdog , created , country , plasma_saving , ts_enabled , ts_enable_icon , ts_path , ts_max_length , ts_buffer_use , ts_action_on_exit , ts_delay , video_clock , rtsp_type , rtsp_flags , stb_lang , display_menu_after_loading , record_max_length , plasma_saving_timeout , parent_password , spdif_mode , show_after_loading , play_in_preview_by_ok , hdmi_event_reaction ,play_in_preview_only_by_ok) 
                                 VALUES ('" . $lastinsertid . "' , 200 , 127 , 127 , 'rca' , 50 , 0 , 0 , 1 , '" . base64_encode($newmac) . "' , 'en_GB.utf8' , 0 , 1 , 1 , 0 , NULL , 0 , NULL , NULL , NULL , 1 , NULL , NULL , NULL , NULL , NULL , 3 , 10 ,'' , NULL , NULL , '" . strtotime(date('Y-m-d')) . "' , NULL , 0 , 0 , 1 , NULL , 3600 , 'cyclic' , 'no_save' , 'on_pause' , 'Off' , 4 , 0 , 'en' , 1 , 180 , 600 , '" . (!empty($returndata['parentpassword']) ? $returndata['parentpassword'] : 0) . "' , 1 , 'main_menu' , 1 , 1 ,'true')";
                $mag_devicesresult = mysqli_query($con, $mag_devices);
                if (!$mag_devicesresult) {
                    $radiussqlerror = mysqli_error($con);
                    self::XtreamCode_WHMCSReconnect();
                    return "XtreamCode Database Query Error: " . $radiussqlerror;
                }
                self::XtreamCode_WHMCSReconnect();
                $fieldid = Capsule::table('tblcustomfields')
                        ->where('fieldname', $returndata['custom_field_mag'])
                        ->where('type', 'product')
                        ->where('relid', $params['pid'])
                        ->get();
                if (isset($fieldid) && !empty($fieldid)) {
                    $checkExists = Capsule::table('tblcustomfieldsvalues')
                            ->where('relid', $params['serviceid'])
                            ->where('fieldid', $fieldid[0]->id)
                            ->get();
                    if (isset($checkExists) && !empty($checkExists)) {
                        Capsule::table('tblcustomfieldsvalues')
                                ->where('relid', $params['serviceid'])
                                ->where('fieldid', $fieldid[0]->id)
                                ->update(['value' => $newmac]);
                    } else {
                        Capsule::table('tblcustomfieldsvalues')->insert(
                                ['fieldid' => $fieldid[0]->id, 'relid' => $params['serviceid'], 'value' => $newmac]
                        );
                    }
                }
                $domainMAC = Capsule::table('tblhosting')
                        ->where('id', $params['serviceid'])
                        ->update(['domain' => $newmac]);
            }
        }
        return 'success';
    }

    public function XtreamDashboard_AddENG(array $params, $newmac) {
        $servers = Capsule::table('tblproducts')
                ->join('tblservergroupsrel', 'tblproducts.servergroup', '=', 'tblservergroupsrel.groupid')
                ->join('tblservers', 'tblservergroupsrel.serverid', '=', 'tblservers.id')
                ->where('tblproducts.id', '=', $params['pid'])
                ->select('tblservers.*')
                ->get();
        $tblhostingdetails = Capsule::table('tblhosting')->where('id', '=', $params["serviceid"])->get();
        $nextduedate = $tblhostingdetails[0]->nextduedate;
        $regdate = $tblhostingdetails[0]->regdate;
        $serviceid = $params["serviceid"];
        $product = Capsule::table('tblproducts')->where('id', '=', $params["pid"])->get();
        $is_trial = ($product[0]->configoption5 == 'Yes') ? '1' : '0';
        $member_id = $product[0]->configoption9;
        $Bouquets = $product[0]->configoption10;
        $syn_expiry = $product[0]->configoption17;
        $trial_period = ($product[0]->configoption18 != 0) ? '+' . $product[0]->configoption18 . ' hours' : '+24 hours';
        // Collecting parameters
        $iptvusername = $params["username"];
        /*$xtreamConfig = Capsule::table('mod_xtreamConfig')->get();*/
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        $username = $iptvusername . $returndata['common_identifier'] . $serviceid;
        $password = $params["password"];
        foreach ($servers as $server) {
            $sqlusername = $server->username;
            $sqlpassword = decrypt($server->password);
            $sqldbname = $server->accesshash;
            $sqlhost = $server->ipaddress;
          list($sqldbname, $sqlport) = explode(':', $sqldbname);
            if (isset($sqlport) && !empty($sqlport))
                $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname, $sqlport);
            else
                $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname);
// Check connection 
            if (mysqli_connect_errno()) {
                return "Failed to connect to MySQL: " . mysqli_connect_error();
            }
            $iptvusernameresult = mysqli_query($con, "SELECT id FROM users WHERE username='$iptvusername'");
            if (mysqli_num_rows($iptvusernameresult) == 0) {
                self::XtreamCode_WHMCSReconnect();
                return "User Not Found!!";
            } else {
                $userid = mysqli_fetch_assoc($iptvusernameresult);
            }
            $clientemail = self::vpncheckAffexists($params['userid']);
            if (!empty($clientemail)) {
                $result = mysqli_query($con, "SELECT id FROM reg_users WHERE email='$clientemail'");
                if (!$result) {
                    $radiussqlerror = mysqli_error($con);
                    self::XtreamCode_WHMCSReconnect();
                    logModuleCall('XtreamCode', 'Check Reseller Exists', 'Email Address : ' . $clientemail, "XtreamCode Database Query Error: " . $radiussqlerror, '', '');
                    return "XtreamCode Database Query Error: " . $radiussqlerror;
                }
                if (mysqli_num_rows($result) > 0) {
                    $resellerdata = mysqli_fetch_assoc($result);
                    $member_id = $resellerdata['id'];
                }
            }
            # Inserting Now New User into   
            $expdate = 'NULL';
            if ($is_trial == 1 && $nextduedate != '0000-00-00') {
                $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
            } else {
                if ($syn_expiry == 'on' && $nextduedate != '0000-00-00') {
                    $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
                } elseif ($is_trial == 1) {
                    $expdate = strtotime(date("Y-m-d H:i:s", strtotime($trial_period)));
                }
            }
# Inserting Now New User into 
            $query = "INSERT INTO users (member_id , username , password , admin_enabled , enabled , reseller_notes , bouquet , created_at , created_by , pair_id , is_e2,exp_date,is_trial)
                         VALUES ('$member_id' , '$username' , '$password' , 1 , 1 , '" . $returndata['common_identifier'] . $serviceid . "' , '$Bouquets' , " . strtotime($regdate) . ", 0 , '" . $userid['id'] . "' ,'1',$expdate,$is_trial)";

            $result = mysqli_query($con, $query);
            if (!$result) {
                $radiussqlerror = mysqli_error($con);
                self::XtreamCode_WHMCSReconnect();
                return "XtreamCode Database Query Error: " . $radiussqlerror;
            } else {
                $checkengdevice = $params['customfields'][$returndata['checkengdevice']];
                if (isset($checkengdevice) && !empty($checkengdevice)) {
                    $lastinsertid = mysqli_insert_id($con);
                } else {
                    $lastinsertid = mysqli_insert_id($con);
                    $updatepair = mysqli_query($con, "UPDATE users SET pair_id = '" . $lastinsertid . "' WHERE username = '$iptvusername'");
                    if (!$updatepair) {
                        $radiussqlerror = mysqli_error($con);
                        self::XtreamCode_WHMCSReconnect();
                        return "XtreamCode Database Query Error: " . $radiussqlerror;
                    }
                }
                //Access Output Setting in X.C
                $accessoutput = mysqli_query($con, "SELECT * FROM `access_output`");
                if (mysqli_num_rows($accessoutput) > 0) {
                    while ($accessoutputdata = mysqli_fetch_assoc($accessoutput)) {
                        mysqli_query($con, "INSERT INTO user_output(user_id, access_output_id) VALUES('" . $lastinsertid . "', '" . $accessoutputdata['access_output_id'] . "')");
                    }
                }
                # Inserting Now New User into 
                $eng_devices = "INSERT INTO enigma2_devices (mac, user_id, telnet_enable, ftp_enable, ssh_enable, rc)
                                VALUES ('$newmac', '" . $lastinsertid . "', '1', '1', '1', '1')";
                $eng_devicesresult = mysqli_query($con, $eng_devices);
                if (!$eng_devicesresult) {
                    $radiussqlerror = mysqli_error($con);
                    self::XtreamCode_WHMCSReconnect();
                    return "XtreamCode Database Query Error: " . $radiussqlerror;
                }
                /*$xtreamConfig = Capsule::table('mod_xtreamConfig')->get();*/
                $returndata = array();
                if (isset($xtreamConfig) && !empty($xtreamConfig)) {
                    foreach ($xtreamConfig as $config) {
                        $returndata[$config->setting] = $config->value;
                    }
                }
                self::XtreamCode_WHMCSReconnect();
                $fieldid = Capsule::table('tblcustomfields')
                        ->where('fieldname', $returndata['custom_field_eng'])
                        ->where('type', 'product')
                        ->where('relid', $params['packageid'])
                        ->get();
                if (isset($fieldid) && !empty($fieldid)) {
                    $checkExists = Capsule::table('tblcustomfieldsvalues')
                            ->where('relid', $params['serviceid'])
                            ->where('fieldid', $fieldid[0]->id)
                            ->get();
                    if (isset($checkExists) && !empty($checkExists)) {
                        Capsule::table('tblcustomfieldsvalues')
                                ->where('relid', $params['serviceid'])
                                ->where('fieldid', $fieldid[0]->id)
                                ->update(['value' => $newmac]);
                    } else {
                        Capsule::table('tblcustomfieldsvalues')->insert(
                                ['fieldid' => $fieldid[0]->id, 'relid' => $params['serviceid'], 'value' => $newmac]
                        );
                    }
                }
                $domainMAC = Capsule::table('tblhosting')
                        ->where('id', $params['serviceid'])
                        ->update(['domain' => $newmac]);
            }
        }
        return 'success';
    }

    public function XtreamDashboard_ChangeENG(array $params, $newmac) {
        $servers = Capsule::table('tblproducts')
                ->join('tblservergroupsrel', 'tblproducts.servergroup', '=', 'tblservergroupsrel.groupid')
                ->join('tblservers', 'tblservergroupsrel.serverid', '=', 'tblservers.id')
                ->where('tblproducts.id', '=', $params['pid'])
                ->select('tblservers.*')
                ->get();
        $serviceid = $params["serviceid"];
// Collecting parameters
        $iptvusername = $params["username"];
        foreach ($servers as $server) {
            $sqlusername = $server->username;
            $sqlpassword = decrypt($server->password);
            $sqldbname = $server->accesshash;
            $sqlhost = $server->ipaddress;
             list($sqldbname, $sqlport) = explode(':', $sqldbname);
            if (isset($sqlport) && !empty($sqlport))
                $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname, $sqlport);
            else
                $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname);

// Check connection 
            if (mysqli_connect_errno()) {
                return "Failed to connect to MySQL: " . mysqli_connect_error();
            }
            /*$xtreamConfig = Capsule::table('mod_xtreamConfig')->get();*/
            $returndata = array();
            if (isset($xtreamConfig) && !empty($xtreamConfig)) {
                foreach ($xtreamConfig as $config) {
                    $returndata[$config->setting] = $config->value;
                }
            }
            $reseller_notes = $returndata['common_identifier'] . $serviceid;
# Inserting Now New User into 
// First checking if user already exist with reqeuest username  
            $result = mysqli_query($con, "SELECT id FROM users WHERE reseller_notes='$reseller_notes'  AND is_e2 = '1'");

            if (!$result) {
                $radiussqlerror = mysqli_error($con);
                self::XtreamCode_WHMCSReconnect();
                return "XtreamDashboard Database Query Error: " . $radiussqlerror;
            }
            if (mysqli_num_rows($result) > 0) {
                $resultmag_devices = mysqli_query($con, "SELECT * FROM enigma2_devices WHERE mac = '" . $newmac . "'");
                if (mysqli_num_rows($resultmag_devices) == 0) {
                    $userid = mysqli_fetch_assoc($result);
                    $updatepair = mysqli_query($con, "UPDATE enigma2_devices SET mac = '" . $newmac . "' WHERE user_id = '" . $userid['id'] . "'");
                    if (!$updatepair) {
                        $radiussqlerror = mysqli_error($con);
                        self::XtreamCode_WHMCSReconnect();
                        return "XtreamCode Database Query Error: " . $radiussqlerror;
                    }
                    self::XtreamCode_WHMCSReconnect();
                    /*$xtreamConfig = Capsule::table('mod_xtreamConfig')->get();*/
                    $returndata = array();
                    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
                        foreach ($xtreamConfig as $config) {
                            $returndata[$config->setting] = $config->value;
                        }
                    }
                    $fieldid = Capsule::table('tblcustomfields')
                            ->where('fieldname', $returndata['custom_field_eng'])
                            ->where('type', 'product')
                            ->where('relid', $params['packageid'])
                            ->get();
                    if (isset($fieldid) && !empty($fieldid)) {
                        $checkExists = Capsule::table('tblcustomfieldsvalues')
                                ->where('relid', $params['serviceid'])
                                ->where('fieldid', $fieldid[0]->id)
                                ->get();
                        if (isset($checkExists) && !empty($checkExists)) {
                            Capsule::table('tblcustomfieldsvalues')
                                    ->where('relid', $params['serviceid'])
                                    ->where('fieldid', $fieldid[0]->id)
                                    ->update(['value' => $newmac]);
                        } else {
                            Capsule::table('tblcustomfieldsvalues')->insert(
                                    ['fieldid' => $fieldid[0]->id, 'relid' => $params['serviceid'], 'value' => $newmac]
                            );
                        }
                    }
                    $domainMAC = Capsule::table('tblhosting')
                            ->where('id', $params['serviceid'])
                            ->update(['domain' => $newmac]);
                } else {
                    return "MAC Address already exists.";
                }
            }
        }
        return 'success';
    }

}
