<?php

//namespace WHMCS\Module\Addon\AddonModule\Admin;
/**
 * Sample Admin Area Controller
 */
class Controller {

    /**
     * Index action.
     *
     * @param array $vars Module configuration parameters
     *
     * @return string
     */
    public function index($vars) {
        include_once __DIR__ . '/../../functions.php';
        // Get common module parameters 
        $moduleLink = $vars['modulelink'];
        $serversCount = getserverCount();
        $totalclients = getclients();
        $applink = count(getAppLinks());
        $totalresellers = count(getResellersList());
        $totalsuperresellers = count(getSuperResellersList());
        $onlineusers = getonlineusers();
        $count = $serversCount;
        $smarty = new Smarty();
        $smarty->assign('count', $count);
        $smarty->assign('totalclients', $totalclients);
        $smarty->assign('applink', $applink);
        $smarty->assign('totalresellers', $totalresellers);
        $smarty->assign('totalsuperresellers', $totalsuperresellers);
        $smarty->assign('modulelink', $moduleLink);
        $smarty->assign('onlineusers', $onlineusers);
        $smarty->display('../modules/addons/vpnpanel/templates/dashboard.tpl');
    }

    public function vpn_api($vars) {
        if (isset($_POST['generateapi'])) {
            $apicode = $_POST['apicode'];
            $createapi = generateapi($apicode);
            echo $createapi;
            exit;
        }

        if (isset($_POST['saveproduct'])) {
            $pid = $_POST['product'];
            $savesignupproduct = savesignupproduct($pid);
            if($savesignupproduct == 'success')
            {
                header('location: addonmodules.php?module=vpnpanel&action=vpn_api&m=success');
            }
            else
            {
                header('location: addonmodules.php?module=vpnpanel&action=vpn_api&m=error');
            }
        }

        /*$allProducts = Capsule::table('tblproducts')->join('tblproductgroups','tblproducts.id','=','tblproductgroups.gid')->where('tblproducts.hidden',0)->select('tblproducts.name as productname','tblproducts.id','tblproductgroups.name as groupname', 'tblproducts.gid', 'tblproducts.hidden')->get();
*/
        $allProducts = getAllProducts();
        $productgroups = getProductGroup();
        $selecteProduct = getsignupproduct();
        $selectedproductval = (!empty($selecteProduct))?$selecteProduct[0]->value:'';
        $allProductshtml = '<select name="product" class="form-control"><option value="">Select Product</option>';

        foreach($productgroups as $group)
        {

            $allProductshtml.='<optgroup label="'.$group->name.'">';
        
            foreach($allProducts[$group->name] as $product)
            {
                $selected = '';
                if($selectedproductval == $product['id'])
                {
                    $selected = 'selected';
                }
                $allProductshtml.='<option value="'.$product['id'].'" '.$selected.'>'.$product['name'].'</option>';
            }
            $allProductshtml.='</optgroup>';
        }
        $allProductshtml.='</select>';

        $moduleLink = $vars['modulelink'];
        $apikey = getapi();
        $smarty = new Smarty();
        $smarty->assign('modulelink', $moduleLink);
        $smarty->assign('apikey', $apikey);
        $smarty->assign('allProductshtml', $allProductshtml);
        $smarty->assign('selecteProduct', $selectedproductval);
        $smarty->display('../modules/addons/vpnpanel/templates/generateapi.tpl');
    }

    public function vpn_settings($vars) {
         include_once __DIR__ . '/../../functions.php';
$message = '';
        if(isset($_POST['saveSetting']))
        {
            $data = array();
            foreach($_POST as $post => $val)
            {
                if($post !== 'token' || $post !== 'saveSetting')
                {
                    $data[]= array('settings' => $post, 'value' => $val);                                               
                }
            }
            $updateSettings = saveSetting($data);
            if($updateSettings)
            {
                $message = '<p class="alert alert-success">Success! Settings Saved.</p>';
            }
            else
            {
                $message = '<p class="alert alert-danger">Error! Settings Not Saved.</p>';
            }
        }

        $saveddata = getSettings();

        $moduleLink = $vars['modulelink'];
        $apikey = getapi();
        $smarty = new Smarty();
        $smarty->assign('modulelink', $moduleLink);
        $smarty->assign('data', $saveddata);
        $smarty->assign('message', $message);
        $smarty->display('../modules/addons/vpnpanel/templates/vpnsettings.tpl');
    }
public function vpn_group($vars) {
        $moduleLink = $vars['modulelink'];
        $systemURL = systemURL();
        $message  = '';
        $api = getapi();
        if (isset($_POST['saveGroup'])) {
            $insertconfig = saveGroup($_POST);
            if ($insertconfig == 'success') {
                $message = 'success';
            }
            elseif($insertconfig == 'GroupExists')
            {
                $message = 'exist';
            }
            else
            {
                $message = 'error';
            }
            header('location:addonmodules.php?module=vpnpanel&action=vpn_servers&m='.$message.'');
        }
        $groupname = '';
        $groupid = '';
        $edit = 'false';
        if(isset($_REQUEST['type']) && $_REQUEST['type'] == 'edit')
        {
            $groupid = $_REQUEST['id'];
            $GetGroupList = grouplist($groupid);
            $groupname = $GetGroupList[0]->groupName;
            $edit = 'true';
        }
        if(isset($_REQUEST['type']) && $_REQUEST['type'] == 'delete')
        {
            $groupid = $_REQUEST['id'];
            $DeleteGroupList = deleteGroup($groupid);
            if($DeleteGroupList == 'success')
            {
                header('location:addonmodules.php?module=vpnpanel&action=vpn_servers&m=success');
            }
            else
            {
                header('location:addonmodules.php?module=vpnpanel&action=vpn_servers&m=error');
            }
        }
        $smarty = new Smarty();
        $smarty->assign('modulelink', $moduleLink);
        $smarty->assign('serverconf', $configdata);
        $smarty->assign('groupname', $groupname);
        $smarty->assign('groupid', $groupid);
        $smarty->assign('edit', $edit);
        $smarty->assign('message', $message);
        $smarty->display('../modules/addons/vpnpanel/templates/vpnGroup.tpl');
        unset($_SESSION['message']);
    }
    public function vpn_serverConfig($vars) {
        $moduleLink = $vars['modulelink'];
        $configdata = getserverconfig();

        $systemURL = systemURL();
        $api = getapi();
        if (isset($_POST['saveconfig'])) {
            $insertconfig = setserverconfig($_POST);
            if ($insertconfig == 'success') {
                $_SESSION['message'] = '<p class="alert alert-success">Server Configuration is Saved Successfully. Please Re-Install All Servers.</p>';
                set_include_path(get_include_path() . PATH_SEPARATOR . 'phpseclib');
                require_once __DIR__ . '/../../phpseclib/Crypt/RC4.php';
                require_once __DIR__ . '/../../phpseclib/Crypt/Rijndael.php';
                require_once __DIR__ . '/../../phpseclib/Crypt/Twofish.php';
                require_once __DIR__ . '/../../phpseclib/Crypt/Blowfish.php';
                require_once __DIR__ . '/../../phpseclib/Crypt/TripleDES.php';
                require_once __DIR__ . '/../../phpseclib/Crypt/Random.php';
                require_once __DIR__ . '/../../phpseclib/Crypt/Hash.php';
                require_once __DIR__ . '/../../phpseclib/Math/BigInteger.php';
                require_once __DIR__ . '/../../phpseclib/Net/SSH2.php';

                $ipv6 = $configdata['ipv6']['value'];
                $port = $configdata['port']['value'];
                $customport = $configdata['customport']['value'];
                $protocol = $configdata['protocol']['value'];
                $dns = $configdata['dns']['value'];
                $compression = $configdata['compression']['value'];
                $encryption = $configdata['encryption']['value'];
                //$recnfigall = reconfigAll();
            }
            header('location:' . $moduleLink . '&action=vpn_serverConfig');
        }
        elseif(isset($_POST['resetserverconfig']))
        {
            $reset = resetserverconfig();
            echo 'success'; exit;
        }

        $smarty = new Smarty();
        $smarty->assign('modulelink', $moduleLink);
        $smarty->assign('serverconf', $configdata);
        $smarty->assign('message', $_SESSION['message']);
        $smarty->display('../modules/addons/vpnpanel/templates/serverConfig.tpl');
        unset($_SESSION['message']);
    }

public function vpn_clientConfig($vars) {
    $smarty = new Smarty();
        $moduleLink = $vars['modulelink'];
        $servers = getServercertfiles();
        $systemURL = systemURL();
        $api = getapi();
        if (isset($_POST['serverid'])) {
           
                set_include_path(get_include_path() . PATH_SEPARATOR . 'phpseclib');
                require_once __DIR__ . '/../../phpseclib/Crypt/RC4.php';
                require_once __DIR__ . '/../../phpseclib/Crypt/Rijndael.php';
                require_once __DIR__ . '/../../phpseclib/Crypt/Twofish.php';
                require_once __DIR__ . '/../../phpseclib/Crypt/Blowfish.php';
                require_once __DIR__ . '/../../phpseclib/Crypt/TripleDES.php';
                require_once __DIR__ . '/../../phpseclib/Crypt/Random.php';
                require_once __DIR__ . '/../../phpseclib/Crypt/Hash.php';
                require_once __DIR__ . '/../../phpseclib/Math/BigInteger.php';
                require_once __DIR__ . '/../../phpseclib/Net/SSH2.php';

           // header('location:' . $moduleLink . '&action=vpn_clientConfig');
                $filedata = '';
                if(isset($_POST['editfile']))
                {
                    $serverDetails = getServer($_POST['serverid']);
                    //echo '<pre>';print_r($serverDetails); die();
                    $server_ip = $serverDetails[0]->server_ip;
                    $sshport = $serverDetails[0]->sshport;
                    $pass = $serverDetails[0]->sshpass;
                    $sshpass = decryptPass($pass);

                    
                    $serverid = $_POST['serverid'];
                    $ssh = new Net_SSH2($server_ip, $sshport);
                    if ($ssh->login('root', $sshpass)) 
                    {
                        $filedata = $ssh->exec('cat client.ovpn');
                        $smarty->assign('filedata',$filedata);
                        $smarty->assign('serverIP',$server_ip);
                        $smarty->assign('editfile','true');
                    }
                    else
                    {
                        $_SESSION['message'] = '<p class="alert alert-danger">Unable to Login.</p>';
                    }
                }

        }

        
        $smarty->assign('modulelink', $moduleLink);
        $smarty->assign('servers', $servers);
        $smarty->assign('message', $_SESSION['message']);

        $smarty->display('../modules/addons/vpnpanel/templates/clientConfig.tpl');
        unset($_SESSION['message']);
    }
    public function vpn_assignPackages($vars) {

        include_once __DIR__ . '/../../functions.php';


        if (isset($_POST['addassignpack'])) {
            $assignData = addassignData($_POST);
            echo $assignData;
            exit;
        }
        if (isset($_POST['editassignpack'])) {
            $id = $_POST['id'];
            if ($id == 'all') {
                $assignData = getallpackagesdata();
            } else {
                $assignData = getassignedpackages($id);
            }
            $List = array();
            foreach ($assignData as $resellerList) {
                foreach ($resellerList as $key => $val) {
                    $List[$key] = $val;
                }
            }
            echo json_encode($List);
            exit;
        }
        if (isset($_POST['updateassignpack'])) {
            
        }

        $packagesdata = getassignedpackages();

        $resellersList = getResellersList();
        $i = 0;
        $resellerList = array();
        foreach ($resellersList as $reseller) {
            foreach ($reseller as $key => $val) {
                $resellerList[$i][$key] = $val;
            }
            $i++;
        }
        $allAssignedPackagsData = getallpackagesdata();
        $datahtml = '';
        $datahtml1 = '';
        foreach ($allAssignedPackagsData as $package) {
            $name = (isset($package->firstname)) ? $package->firstname . ' ' . $package->lastname : 'All Resellers';
            $datahtml1 .= '<tr><td>' . $name . '</td><td>' . $package->products . '</td><td><button class="btn btn-info editbtn" data-id="' . $package->resellerid . '" ><i class="fa fa-edit"></i></button></td></tr>';
        }


        foreach ($packagesdata as $package) {
            $name = (isset($package->firstname)) ? $package->firstname . ' ' . $package->lastname : 'All Resellers';
            $datahtml .= '<tr><td>' . $name . '</td><td>' . $package->products . '</td><td><button class="btn btn-info editbtn" data-id="' . $package->resellerid . '" ><i class="fa fa-edit"></i></button></td></tr>';
        }

        $productsList = getAllProducts();

        //echo '<pre>';print_r($productsList); die();
        $breadcrumb = '<li class="breadcrumb-item"><a href="' . $modulelink . '">Dashboard</a></li><li class="breadcrumb-item active">Assign Packages</li>';
        $moduleLink = $vars['modulelink'];
        $apikey = getapi();
        $smarty = new Smarty();
        $smarty->assign('modulelink', $moduleLink);
        $smarty->assign('packagesdata', $datahtml);
        $smarty->assign('allpackagesdata', $datahtml1);
        $smarty->assign('breadcrumb', $breadcrumb);
        $smarty->assign('resellers', $resellerList);
        $smarty->assign('productsListarray', $productsList);

        $smarty->display('../modules/addons/vpnpanel/templates/assignpackages.tpl');
    }

    /**
     * Show action.
     *
     * @param array $vars Module configuration parameters
     *
     * @return string
     */
    public function vpn_servers($vars) { 
        $api = getapi();
        $configdata = getserverconfig();
        set_include_path(get_include_path() . PATH_SEPARATOR . 'phpseclib');
        require_once __DIR__ . '/../../phpseclib/Crypt/RC4.php';
        require_once __DIR__ . '/../../phpseclib/Crypt/Rijndael.php';
        require_once __DIR__ . '/../../phpseclib/Crypt/Twofish.php';
        require_once __DIR__ . '/../../phpseclib/Crypt/Blowfish.php';
        require_once __DIR__ . '/../../phpseclib/Crypt/TripleDES.php';
        require_once __DIR__ . '/../../phpseclib/Crypt/Random.php';
        require_once __DIR__ . '/../../phpseclib/Crypt/Hash.php';
        require_once __DIR__ . '/../../phpseclib/Math/BigInteger.php';
        require_once __DIR__ . '/../../phpseclib/Net/SSH2.php';
        include_once __DIR__ . '/../../functions.php';


        // Get common module parameters
        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
        $version = $vars['version']; // eg. 1.0
        $LANG = $vars['_lang']; // an array of the currently loaded language variables
        $systemURL = systemURL();

        $checklicense = vpnpanel_doCheckLicense();
        if ($checklicense["status"] != "Active") {
            $smarty = new Smarty();
            $breadcrumb = '<li class="breadcrumb-item active"><a href="' . $modulelink . '">Dashboard</a></li><li class="breadcrumb-item active">Servers</li>';
            $smarty->assign('breadcrumb', $breadcrumb);
            $smarty->assign('systemURL', $systemURL);
            $smarty->assign('license', '
<div class="alert alert-danger" role="alert">
  <h4 class="alert-heading">Your license is expired or Invalid!</h4>
  <p>For more Infomation : <a target="_blank" href="https://www.whmcssmarters.com/clients/index.php?rp=/knowledgebase/149/Issues---License-Expired-Service-Suspended-or-disabled.html" class="alert-link">click here</a></p>
  <hr>
  <p class="mb-0"><a target="_blank" href="configaddonmods.php" class="alert-link">Here you can check your licnese key status</a> (Setup > Addon Modules > VPN Panel )</p>
</div>');
            $smarty->display('../modules/addons/vpnpanel/templates/error.tpl');
        } else {


            // Get module configuration parameters

            $message = '';
            if (isset($_POST['reinstallAllServer'])) {
                $allServerData = '';
            }

            /* ------------manage load balancer servers----------------- */
            if (isset($_REQUEST['serverid'])) {
                $mainserverid = $_REQUEST['serverid'];
                $serverData = getserver($mainserverid);
                $mainServerName = $serverData[0]->server_name . ' (' . $serverData[0]->server_ip . ')';

                $lbserversdata = getlbserver('', $mainserverid);

                if (isset($_POST['createLBserver'])) {
                    set_include_path(get_include_path() . PATH_SEPARATOR . 'phpseclib');
                    require_once __DIR__ . '/../../phpseclib/Crypt/RC4.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Rijndael.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Twofish.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Blowfish.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/TripleDES.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Random.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Hash.php';
                    require_once __DIR__ . '/../../phpseclib/Math/BigInteger.php';
                    require_once __DIR__ . '/../../phpseclib/Net/SSH2.php';
                    //$mysqlpass = $_POST['mysqlpass'];
                    $api = getapi();
                    $sshpass = $_POST['sshpass'];
                    $server_ip = $_POST['server_ip'];
                    $sshport = (isset($_POST['sshport']) && !empty($_POST['sshport'])) ? $_POST['sshport'] : '22';
                    $pskkey = randompsk();
                    $reinstallserver = createServer($server_ip, $sshport, $sshpass, $systemURL, $api, 0, $_POST['server_category'], $pskkey);

                    if ($reinstallserver == 'success') {
                        $status = 2;

                        $postdata = array('relid' => $mainserverid, 'server_name' => $_POST['server_name'], 'server_category' => $_POST['server_category'], 'server_ip' => $_POST['server_ip'], 'status' => $status,
                            'sshport' => $sshport, 'sshpass' => encryptPass($_POST['sshpass']), 'pskkey' => $pskkey, 'flag' => $_POST['flag'], 'createdUploaded' => 'created', 'max_connection' => $_POST['max_connection']);
                        $addserver = addLBserver($postdata);
                        echo $addserver;
                        exit;
                    } else {
                        echo $reinstallserver;
                        exit;
                    }
                }

                if (isset($_POST['editLBserver'])) {

                    $serversdata = getlbserver($_POST['server_id'], '');

                    print_r(json_encode($serversdata));
                    exit;
                }
                if (isset($_POST['deleteLBserver'])) {
                    $id = $_POST['server_id'];
                    $deleteserver = deleteLBserver($id);
                    if ($deleteserver) {
                        $message = 'success';
                    } elseif ($deleteserver == 'noserverid') {
                        $message = 'noserverid';
                    } else {
                        $message = 'error';
                    }
                    echo $message;
                    exit;
                }

                if (isset($_POST['updateLBServer'])) {

                    $server_id = $_POST['server_id'];
                    if (isset($_POST['server_pass']) && !empty($_POST['server_pass'])) {
                        $postdata = array('server_name' => $_POST['server_name'], 'server_category' => $_POST['server_category'],
                            'flag' => $_POST['flag'], 'server_pass' => encryptPass($_POST['server_pass']), 'server_port' => $_POST['server_port']);
                    } else {
                        $postdata = array('server_name' => $_POST['server_name'], 'server_category' => $_POST['server_category'],
                            'flag' => $_POST['flag'], 'max_connection' => $_POST['max_connection']);
                    }
                    $addserver = editLBserver($postdata, $server_id);

                    echo $addserver;
                    exit;
                }
                if ($_POST['checkLBservers']) {

                    $serversdata1 = getlbserver();
                    $responses = array();
                    foreach ($serversdata1 as $server) {

                        if ($server->status == 2 || $server->status == 0) {

                            if ($server->status == 2) {
                                $sshport = $server->sshport;
                                $sshpass = encryptPass($server->sshpass);
                                $server_ip = $server->server_ip;
                                $ssh = new Net_SSH2($server_ip, $sshport);
                                if ($ssh->login('root', $sshpass)) {
                                    $data = $ssh->exec("service openvpn status");
                                    $search = 'could not be found';
                                    if (preg_match("/{$search}/i", $data)) {
                                        logModuleCall('VPN Panel', 'Server status', $server_ip, $data, '', '');
                                        exit;
                                    } else {

                                        $server_id = $server->server_id;
                                        $postdata = array('status' => 1);
                                        $addserver = editLBserver($postdata, $server_id);

                                        if ($addserver == 'success') {
                                            $responses[] = $server->server_id;
                                        }
                                    }
                                }
                            } elseif ($server->status == 0) {
                                $sshport = $server->sshport;
                                $sshpass = encryptPass($server->sshpass);
                                $server_ip = $server->server_ip;
                                $ssh = new Net_SSH2($server_ip, $sshport);
                                if ($ssh->login('root', $sshpass)) {

                                    $data = $ssh->exec("service openvpn status");

                                    $search = 'could not be found';
                                    if (preg_match("/{$search}/i", $data)) {
                                        logModuleCall('VPN Panel', 'Server status', $server_ip, $data, '', '');
                                        exit;
                                    } else {
                                        $server_id = $server->server_id;
                                        $postdata = array('status' => 1);
                                        $addserver = editLBserver($postdata, $server_id);
                                        if ($addserver == 'success') {
                                            $responses[] = $server->server_id;
                                        }
                                    }
                                }
                            }

                            //}
                        }
                    }
                    echo implode(',', $responses);
                    exit;
                }

                if (isset($_POST['reinstallLBserver'])) {

                    $api = getapi();
                    set_include_path(get_include_path() . PATH_SEPARATOR . 'phpseclib');
                    require_once __DIR__ . '/../../phpseclib/Crypt/RC4.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Rijndael.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Twofish.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Blowfish.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/TripleDES.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Random.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Hash.php';
                    require_once __DIR__ . '/../../phpseclib/Math/BigInteger.php';
                    require_once __DIR__ . '/../../phpseclib/Net/SSH2.php';

                    $id = $_POST['server_id'];
                    $serverData = getlbserver($id);

                    $serverIP = $serverData[0]->server_ip;
                    $serverPass = decryptPass($serverData[0]->sshpass);
                    $serversshport = $serverData[0]->sshport;
                    $pskkey = randompsk();
                    $reinstallserver = createServer($serverIP, $serversshport, $serverPass, $systemURL, $api, 1, $serverData[0]->server_category,$pskkey);

                    if ($reinstallserver == 'success') {
                        if ($serverData[0]->status == 2) {
                            echo 'success';
                            exit;
                        }
                        $status = 2;
                        $postdata = array('status' => $status);
                        $addserver = editLBserver($postdata, $id);

                        echo $addserver;
                        exit;
                    } else {
                        echo $reinstallserver;
                        exit;
                    }


                    exit;
                }


                $usersoption = array();

                $script = "document.getElementById('updatebtn').addEventListener('click',updateServer,true);";
                $i = 0;
                $lbserverhtml = '';
                foreach ($lbserversdata as $lbserver) {

                    $i++;
                    if ($lbserver->server_category == 'openvpn') {
                        $lbserverCategory = 'OpenVPN';
                    } else if ($lbserver->server_category == 'ikev2') {
                        $lbserverCategory = 'Ikev2/IPSEC';
                    } else if ($lbserver->server_category == 'openvpn-ikev2') {
                        $lbserverCategory = 'OpenVPN + Ikev2/IPSEC';
                    }

                    $script .= "document.getElementById('editServer" . $i . "').addEventListener('click',editServer,true);
                document.getElementById('deleteServer" . $i . "').addEventListener('click',deleteServer,true);
                document.getElementById('reinstallServer" . $i . "').addEventListener('click',reinstallServer,true);
                document.getElementById('rebootServer" . $i . "').addEventListener('click',rebootServer,true);";


                    $status = '';
                    if ($lbserver->status == 1) {
                        $status = '<span class="badge badge-success" style="background: #24a238;">Server Online</span>';
                    } elseif ($lbserver->status == 2) {
                        $status = '<span class="badge badge-warning" data-serverid="' . $lbserver->server_id . '" style="background: #ffa700;">Processing..</span>';
                    } else {
                        $status = '<span class="badge badge-warning" data-serverid="' . $lbserver->server_id . '" style="background: #ffa700;">Offline</span>';
                    }

                    $lbserverhtml .= '<tr id="tr' . $lbserver->server_id . '">
                <td><img src="' . $lbserver->flag . '" width="30px"> ' . $lbserver->server_name . '</td>
                <td>' . $lbserver->server_ip . '</td>
                <td>' . $lbserverCategory . '</td>
                <td>' . $lbserver->sshport . '</td>
                <td class="status">'.$status.'</td>
                <td>' . $lbserver->created_at . '</td>
                <td>
                <div class="btn-group" role="group">
    <button id="btnGroupDrop1" type="button" class="btn btn-info btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
      Actions <i class="fa fa-sort-down"></i>
    </button>
                <div class="dropdown-menu" aria-labelledby="btnGroupDrop1">
                 <!--a href="' . $modulelink . '&action=vpn_serverInfo&serverid=' . $server->server_id . '" title="View Server Information" class="btn btn-sm btn-info"><i class="fa fa-info-circle"> OS Info</i></a-->
                    <button type="button" data-serverid="' . $lbserver->server_id . '" class="btn btn-info btn-sm editServer dropdown-item" id="editServer' . $i . '"><i class="fa fa-edit"></i> Edit Server  <i class="fa fa-spin fa-spinner loading" style="display: none;"></i></button>
                    <button type="button" id="deleteServer' . $i . '" data-serverid="' . $lbserver->server_id . '" class="btn btn-danger btn-sm deleteServer dropdown-item"><i class="fa fa-trash"></i> Delete Server  <i class="fa fa-spin fa-spinner loading" style="display: none;"></i></button>
                    <!--button type="button" id="repairServer' . $i . '" data-serverid="' . $lbserver->server_id . '" class="btn btn-warning btn-sm repairServer dropdown-item"><i class="fa fa-cogs"></i> Repair Server  <i class="fa fa-spin fa-spinner loading" style="display: none;"></i></button-->
                    <button type="button" id="reinstallServer' . $i . '" data-serverid="' . $lbserver->server_id . '" class="btn btn-warning btn-sm reinstallServer dropdown-item"><i class="fa fa-refresh"></i> Re-Install  <i class="fa fa-spin fa-spinner loading" style="display: none;"></i></button>
                    <button type="button" id="rebootServer' . $i . '" data-serverid="' . $lbserver->server_id . '" class="btn btn-danger btn-sm rebootServer dropdown-item"><i class="fa fa-power-off"></i> Reboot Server  <i class="fa fa-spin fa-spinner loading" style="display: none;"></i></button>

                </div>
                </div>
                
                
                </td></tr>';
                }


                $breadcrumb = '<li class="breadcrumb-item active"><a href="' . $modulelink . '">Dashboard</a></li><li class="breadcrumb-item active">Servers</li>';
                $smarty = new Smarty();
                $smarty->assign('serverhtml', $lbserverhtml);
                $smarty->assign('modulelink', $modulelink);
                $smarty->assign('apikey', $apikey);
                $smarty->assign('mainServerName', $mainServerName);
                $smarty->assign('script1', $script);
                $smarty->assign('message', $message);
                $smarty->assign('systemURL', $systemURL);
                $smarty->assign('breadcrumb', $breadcrumb);
                $smarty->display('../modules/addons/vpnpanel/templates/lbservers.tpl');
            } else {
                /* ----------------------------------MAIN SERVER FUNCTION---------------------------------------------------- */
                if (isset($_POST['restartallservice'])) {
                    set_include_path(get_include_path() . PATH_SEPARATOR . 'phpseclib');
                    require_once __DIR__ . '/../../phpseclib/Crypt/RC4.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Rijndael.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Twofish.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Blowfish.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/TripleDES.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Random.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Hash.php';
                    require_once __DIR__ . '/../../phpseclib/Math/BigInteger.php';
                    require_once __DIR__ . '/../../phpseclib/Net/SSH2.php';
                    $data = restartallservice();
                    echo $data;
                    exit;
                }
                if (isset($_POST['restartservice'])) {

                    $serverid = $_POST['server_id'];
                    set_include_path(get_include_path() . PATH_SEPARATOR . 'phpseclib');
                    require_once __DIR__ . '/../../phpseclib/Crypt/RC4.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Rijndael.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Twofish.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Blowfish.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/TripleDES.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Random.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Hash.php';
                    require_once __DIR__ . '/../../phpseclib/Math/BigInteger.php';
                    require_once __DIR__ . '/../../phpseclib/Net/SSH2.php';
                    $serverinfo = getserver($serverid);
                    $serverIP = $serverinfo[0]->server_ip;
                    $serversshport = $serverinfo[0]->sshport;
                    $serverPass = decryptPass($serverinfo[0]->sshpass);
                    $data = restartService($serverIP, $serversshport, $serverPass);
                    echo $data;
                    exit;
                }
                if (isset($_POST['restartlbservice'])) {

                    $serverid = $_POST['server_id'];
                    set_include_path(get_include_path() . PATH_SEPARATOR . 'phpseclib');
                    require_once __DIR__ . '/../../phpseclib/Crypt/RC4.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Rijndael.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Twofish.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Blowfish.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/TripleDES.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Random.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Hash.php';
                    require_once __DIR__ . '/../../phpseclib/Math/BigInteger.php';
                    require_once __DIR__ . '/../../phpseclib/Net/SSH2.php';
                    $serverinfo = getlbserver($serverid);
                    $serverIP = $serverinfo[0]->server_ip;
                    $serversshport = $serverinfo[0]->sshport;
                    $serverPass = decryptPass($serverinfo[0]->sshpass);
                    $data = restartService($serverIP, $serversshport, $serverPass);
                    echo $data;
                    exit;
                }

                if (isset($_POST['rebootlb'])) {

                    $serverid = $_POST['server_id'];
                    set_include_path(get_include_path() . PATH_SEPARATOR . 'phpseclib');
                    require_once __DIR__ . '/../../phpseclib/Crypt/RC4.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Rijndael.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Twofish.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Blowfish.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/TripleDES.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Random.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Hash.php';
                    require_once __DIR__ . '/../../phpseclib/Math/BigInteger.php';
                    require_once __DIR__ . '/../../phpseclib/Net/SSH2.php';
                    $serverinfo = getlbserver($serverid);
                    $serverIP = $serverinfo[0]->server_ip;
                    $serversshport = $serverinfo[0]->sshport;
                    $serverPass = decryptPass($serverinfo[0]->sshpass);
                    $data = rebootServer($serverIP, $serversshport, $serverPass);
                    echo $data;
                    exit;
                }
                if (isset($_POST['reboot'])) {

                    $serverid = $_POST['server_id'];
                    set_include_path(get_include_path() . PATH_SEPARATOR . 'phpseclib');
                    require_once __DIR__ . '/../../phpseclib/Crypt/RC4.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Rijndael.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Twofish.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Blowfish.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/TripleDES.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Random.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Hash.php';
                    require_once __DIR__ . '/../../phpseclib/Math/BigInteger.php';
                    require_once __DIR__ . '/../../phpseclib/Net/SSH2.php';
                    $serverinfo = getserver($serverid);
                    $serverIP = $serverinfo[0]->server_ip;
                    $serversshport = $serverinfo[0]->sshport;
                    $serverPass = decryptPass($serverinfo[0]->sshpass);
                    $data = rebootServer($serverIP, $serversshport, $serverPass);
                    echo $data;
                    exit;
                }

                if(isset($_POST['viewlogs']))
                {
                    $serverid = $_POST['server_id'];
                    set_include_path(get_include_path() . PATH_SEPARATOR . 'phpseclib');
                    require_once __DIR__ . '/../../phpseclib/Crypt/RC4.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Rijndael.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Twofish.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Blowfish.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/TripleDES.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Random.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Hash.php';
                    require_once __DIR__ . '/../../phpseclib/Math/BigInteger.php';
                    require_once __DIR__ . '/../../phpseclib/Net/SSH2.php';
                    $serverinfo = getserver($serverid);
                    $serverIP = $serverinfo[0]->server_ip;
                    $serversshport = $serverinfo[0]->sshport;
                    $serverPass = decryptPass($serverinfo[0]->sshpass);
                    $data = viewlogs($serverIP, $serversshport, $serverPass);
                    echo $data;
                    exit;
                }


                if (isset($_POST['createserver'])) {
                    $api = getapi();
                    set_include_path(get_include_path() . PATH_SEPARATOR . 'phpseclib');
                    require_once __DIR__ . '/../../phpseclib/Crypt/RC4.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Rijndael.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Twofish.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Blowfish.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/TripleDES.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Random.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Hash.php';
                    require_once __DIR__ . '/../../phpseclib/Math/BigInteger.php';
                    require_once __DIR__ . '/../../phpseclib/Net/SSH2.php';

                    $sshpass = $_POST['sshpass'];
                    $server_ip = $_POST['server_ip'];
                    $sshport = (isset($_POST['sshport']) && !empty($_POST['sshport'])) ? $_POST['sshport'] : '22';
                    $pskkey = randompsk();
                    $reinstallserver = createServer($server_ip, $sshport, $sshpass, $systemURL, $api, 0, $_POST['server_category'], $pskkey);

                    if ($reinstallserver == 'success') {
                        $status = 2;

                        $postdata = array('server_name' => $_POST['server_name'], 'server_category' => $_POST['server_category'], 'server_ip' => $_POST['server_ip'], 'status' => $status,
                            'sshport' => $sshport, 'sshpass' => encryptPass($_POST['sshpass']), 'flag' => $_POST['flag'], 'pskkey' => $pskkey, 'createdUploaded' => 'created','server_group' => $_POST['server_group'], 'max_connection' => $_POST['max_connection']);
                        $addserver = addserver($postdata);
                        echo $addserver;
                        exit;
                    } else {
                        echo $reinstallserver;
                        exit;
                    }
                }

                if (isset($_POST['editserver'])) {
                    $serversdata = getserver($_POST['server_id']);
                    print_r(json_encode($serversdata));
                    exit;
                }
                if (isset($_POST['deleteserver'])) {
                    $id = $_POST['server_id'];
                    $deleteserver = deleteserver($id);
                    if ($deleteserver) {
                        $message = 'success';
                    } elseif ($deleteserver == 'noserverid') {
                        $message = 'noserverid';
                    } else {
                        $message = 'error';
                    }
                    echo $message;
                    exit;
                }

                if (isset($_POST['deleteallserver'])) {
                    $deleteallserver = deleteallserver();
                    echo $deleteallserver;
                    exit;
                }

                if (isset($_POST['updateServer'])) {
                    $server_id = $_POST['server_id'];
                    $sshport = (isset($_POST['sshport']) && !empty($_POST['sshport'])) ? $_POST['sshport'] : '22';
                    if (isset($_POST['server_pass']) && !empty($_POST['server_pass'])) {
                        $postdata = array('server_name' => $_POST['server_name'], 'server_category' => $_POST['server_category'], 'server_id' => $_POST['server_id'], 'sshpass' => encryptPass($_POST['server_pass']),
                            'flag' => $_POST['flag'], 'sshport' => $_POST['server_port'],'server_group' => $_POST['server_group'], 'max_connection' => $_POST['maxcon']);
                    } else {
                        $postdata = array('server_name' => $_POST['server_name'], 'server_category' => $_POST['server_category'], 'server_id' => $_POST['server_id'],
                            'flag' => $_POST['flag'], 'sshport' => $_POST['server_port'],'server_group' => $_POST['server_group'], 'max_connection' => $_POST['maxcon']);
                    }
                    $editserver = editserver($postdata, $server_id);
                    echo $editserver;
                    exit;
                }

                if (isset($_POST['reinstallserver'])) {
                    $api = getapi();
                    set_include_path(get_include_path() . PATH_SEPARATOR . 'phpseclib');
                    require_once __DIR__ . '/../../phpseclib/Crypt/RC4.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Rijndael.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Twofish.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Blowfish.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/TripleDES.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Random.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Hash.php';
                    require_once __DIR__ . '/../../phpseclib/Math/BigInteger.php';
                    require_once __DIR__ . '/../../phpseclib/Net/SSH2.php';


                    $id = $_POST['server_id'];
                    $serverData = getserver($id);

                    $serverIP = $serverData[0]->server_ip;
                    $serverPass = decryptPass($serverData[0]->sshpass);

                    $serversshport = $serverData[0]->sshport;

                    $reinstallserver = createServer($serverIP, $serversshport, $serverPass, $systemURL, $api, 1, $serverData[0]->server_category, $serverData[0]->pskkey);


                    if ($reinstallserver == 'success') {
                        
                        if ($serverData[0]->status == 2) {
                            echo 'success';
                            exit;
                        }
                        $status = 2;
                        $postdata = array('status' => $status);
                        $addserver = editserver($postdata, $id);

                        echo $addserver;
                        exit;
                    } else {
                        echo $reinstallserver;
                        exit;
                    }


                    exit;
                }

                if (isset($_POST['reconfigall'])) {
                    $recnfigall = reconfigAll();
                    if ($recnfigall) {
                        header('location:addonmodules.php?module=vpnpanel&action=vpn_servers');
                    }
                }
                if (isset($_POST['getservermemory'])) {
                    set_include_path(get_include_path() . PATH_SEPARATOR . 'phpseclib');
                    require_once __DIR__ . '/../../phpseclib/Crypt/RC4.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Rijndael.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Twofish.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Blowfish.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/TripleDES.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Random.php';
                    require_once __DIR__ . '/../../phpseclib/Crypt/Hash.php';
                    require_once __DIR__ . '/../../phpseclib/Math/BigInteger.php';
                    require_once __DIR__ . '/../../phpseclib/Net/SSH2.php';
                    include_once __DIR__ . '/../../functions.php';
                    $message = '';

                    // Get common module parameters
                    $allserver = getallserver();
                    $alldata = array();
                    foreach ($allserver['Servers'] as $server) {
                        $serverid = $server->server_id;
                        $getServerInfo = getServerInfo($serverid);
                        $memoryused = $getServerInfo['mem']['used'];
                        $memorytotal = $getServerInfo['mem']['total'];
                        $memoryfree = $getServerInfo['mem']['free'];
                        $cpu = $getServerInfo['cpu'];
                        $memPer = $getServerInfo['mem']['memper'];
                        $alldata[$serverid] = array('memPer' => round($memPer) . '%', 'cpu' => trim($cpu) . '%');
                    }

                    echo json_encode($alldata);
                    exit;
                }

                if ($_POST['getallserverstatus']) {
                    $serversList = getallserverstatus();
                    echo $serversList; exit;
                }

                $serversdatabyGroup = getserver();

                $serverGroups = grouplist();
                $usersoption = array();

                $script = "document.getElementById('updatebtn').addEventListener('click',updateServer,true);";
                $i = 0;
                $j = 0;
                $getMainServer = $serversdatabyGroup['mainserver'];
                $getnogrpServer = $serversdatabyGroup['nogrpServer'];
                $getgrpServer = $serversdatabyGroup['servergroup'];
                //echo '<pre>'; print_r($serversdatabyGroup); die();
                $main_server = 'false';
                $setprimaryOption = '';
                $systemurl = systemURL();
                foreach($getMainServer as $server)
                {
                    if ($server->server_category == 'openvpn') {
                        $serverCategory = ($server->mainserver)?'Main Server':'OpenVPN';
                    } else if ($server->server_category == 'ikev2') {
                        $serverCategory = ($server->mainserver)?'Main Server':'Ikev2/IPSEC';
                    } else if ($server->server_category == 'openvpn-ikev2') {
                        $serverCategory = ($server->mainserver)?'Main Server':'OpenVPN + Ikev2/IPSEC';
                    }
                    $script .= "document.getElementById('editServer" . $i . "').addEventListener('click',editServer,true);
                    document.getElementById('rebootServer" . $i . "').addEventListener('click',rebootServer,true);
                    document.getElementById('viewlogs" . $i . "').addEventListener('click',viewlogs,true);";
                    $script.= ($server->mainserver)?'':"document.getElementById('reinstallServer" . $i . "').addEventListener('click',reinstallServer,true);
                    document.getElementById('restartservices" . $i . "').addEventListener('click',restartservices,true);
                    ";
                    if ($server->status == 1) {
                        $status = '<span class="badge badge-success" style="background: #24a238;">Server Online</span>';
                    } elseif ($server->status == 2) {
                        $status = '<span class="badge badge-warning" data-serverid="' . $server->server_id . '" style="background: #ffa700;">Processing..</span>';
                    } else {
                        $status = '<span class="badge badge-warning" data-serverid="' . $server->server_id . '" style="background: #ffa700;">Offline</span>';
                    }


                    $mainserver = ($server->mainserver) ? ' <i class="fa fa-certificate text-success"></i> (Main Server)' : '';
                    $hide = ($server->mainserver)?'display: none':'';
                    $mainServerInstall = ($server->mainserver)?'<a href="https://www.whmcssmarters.com/clients/clientarea.php?action=productdetails&id='.$server->pskkey.'" target="_blank" id="reinstallServer' . $i . '" class="btn btn-warning btn-sm dropdown-item" title="re-install server"><i class="fa fa-refresh"></i> Re-Install  <i class="fa fa-spin fa-spinner loading" style="display: none;"></i></a>':'<button type="button" id="reinstallServer' . $i . '" data-serverid="' . $server->server_id . '" class="btn btn-warning btn-sm reinstallServer dropdown-item" title="re-install server"><i class="fa fa-refresh"></i> Re-Install  <i class="fa fa-spin fa-spinner loading" style="display: none;"></i></button> <button type="button" id="restartservices' . $i . '" data-serverid="' . $server->server_id . '" class="btn btn-info btn-sm restartservices dropdown-item" style="margin-top: 5px;" title="Restart Services"><i class="fa fa-cogs"></i> Restart Services  <i class="fa fa-spin fa-spinner loading" style="display: none;"></i></button> ';
                    $deleteMainServer = 'data-mainserver="' . $server->mainserver . '"';
                    $serverhtml.= '<tr id="tr' . $server->server_id . '">';
                    $serverhtml .= '<td><img src="' . $server->flag . '" width="30px"> 
                <!--a href="' . $modulelink . '&action=vpn_servers&serverid=' . $server->server_id . '"-->' . $server->server_name . $mainserver . '<!--/a--></td>
                <td>' . $server->server_ip . '</td>
                <td>' . $serverCategory . '</td>
                <td>' . $server->sshport . '</td>
                <!--td class="cpuper"><i class="fa fa-spin fa-circle-o-notch"></i></td>
                <td class="memper"><i class="fa fa-spin fa-circle-o-notch"></i></td-->
                <td class="status">'.$status.'</td>
                <td>n/A</td>
                <td>' . $server->created_at . '</td>
                <td>n/A</td>
                <td>
                <button type="button" id="viewlogs' . $i . '" data-serverid="' . $server->server_id . '" class="btn btn-info rebootServer"><i class="fa fa-file"></i> View Logs  <i class="fa fa-spin fa-spinner loading" style="display: none;"></i></button>
                <div class="btn-group" role="group">
    <button id="btnGroupDrop1" type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
      Actions <i class="fa fa-sort-down"></i>
    </button>
                    <div class="dropdown-menu" aria-labelledby="btnGroupDrop1">
                    <!--a href="' . $modulelink . '&action=vpn_serverInfo&serverid=' . $server->server_id . '" class="btn btn-sm btn-info" title="View Server Information"><i class="fa fa-info-circle"></i> OS Info</a-->

                    <button type="button" data-serverid="' . $server->server_id . '" class="btn btn-info btn-sm editServer dropdown-item" id="editServer' . $i . '" title="edit Server"><i class="fa fa-edit"></i> Edit Server <i class="fa fa-spin fa-spinner loading" style="display: none;"></i></button>
                    <button type="button" id="' . $deleteServerCls . '" data-serverid="' . $server->server_id . '" ' . $deleteMainServer . ' class="btn btn-danger btn-sm deleteServer dropdown-item" style="'.$hide.'" title="delete server"><i class="fa fa-trash"></i> Delete Server <i class="fa fa-spin fa-spinner loading" style="display: none;"></i></button>
                    '.$mainServerInstall.' '.$lbButton.'
                    <button type="button" id="rebootServer' . $i . '" data-serverid="' . $server->server_id . '" class="btn btn-danger btn-sm rebootServer dropdown-item"><i class="fa fa-power-off"></i> Reboot Server  <i class="fa fa-spin fa-spinner loading" style="display: none;"></i></button>
                    <!--button type="button" id="repairServer' . $i . '" data-serverid="' . $server->server_id . '" class="btn btn-warning btn-sm repairServer dropdown-item" title="repair server"><i class="fa fa-cogs"></i> Repair Server  <i class="fa fa-spin fa-spinner loading" style="display: none;"></i></button-->
                    
                   
                </div>
                </div>
                </td></tr>';
                }
                 foreach ($getnogrpServer as $server) {

                    $lbServers = $server->lbServer;
                    $i++;
                    
                    if ($server->server_category == 'openvpn') {
                        $serverCategory = ($server->mainserver)?'Main Server':'OpenVPN';
                    } else if ($server->server_category == 'ikev2') {
                        $serverCategory = ($server->mainserver)?'Main Server':'Ikev2/IPSEC';
                    } else if ($server->server_category == 'openvpn-ikev2') {
                        $serverCategory = ($server->mainserver)?'Main Server':'OpenVPN + Ikev2/IPSEC';
                    }
                    $script .= "document.getElementById('editServer" . $i . "').addEventListener('click',editServer,true);
                    document.getElementById('rebootServer" . $i . "').addEventListener('click',rebootServer,true);";
                    $script.= ($server->mainserver)?'':"document.getElementById('reinstallServer" . $i . "').addEventListener('click',reinstallServer,true);
                    document.getElementById('restartservices" . $i . "').addEventListener('click',restartservices,true);
                    ";
                    if ($server->status == 1) {
                        $status = '<span class="badge badge-success" style="background: #24a238;">Server Online</span>';
                    } elseif ($server->status == 2) {
                        $status = '<span class="badge badge-warning" data-serverid="' . $server->server_id . '" style="background: #ffa700;">Processing..</span>';
                    } else {
                        $status = '<span class="badge badge-warning" data-serverid="' . $server->server_id . '" style="background: #ffa700;">Offline</span>';
                    }


                    $mainserver = ($server->mainserver) ? ' <i class="fa fa-certificate text-success"></i> (Main Server)' : '';
                    $hide = ($server->mainserver)?'display: none':'';
                    $mainServerInstall = ($server->mainserver)?'<a href="https://www.whmcssmarters.com/clients/clientarea.php?action=productdetails&id='.$server->pskkey.'" target="_blank" id="reinstallServer' . $i . '" class="btn btn-warning btn-sm dropdown-item" title="re-install server"><i class="fa fa-refresh"></i> Re-Install  <i class="fa fa-spin fa-spinner loading" style="display: none;"></i></a>':'<button type="button" id="reinstallServer' . $i . '" data-serverid="' . $server->server_id . '" class="btn btn-warning btn-sm reinstallServer dropdown-item" title="re-install server"><i class="fa fa-refresh"></i> Re-Install  <i class="fa fa-spin fa-spinner loading" style="display: none;"></i></button> <button type="button" id="restartservices' . $i . '" data-serverid="' . $server->server_id . '" class="btn btn-info btn-sm restartservices dropdown-item" style="margin-top: 5px;" title="Restart Services"><i class="fa fa-cogs"></i> Restart Services  <i class="fa fa-spin fa-spinner loading" style="display: none;"></i></button> ';
                    $lbButton = '';
                    if(!$server->mainserver && $server->server_category !== 'ikev2')
                    {
                        $lbButton = '<a href="' . $modulelink . '&action=vpn_servers&serverid=' . $server->server_id . '" class="btn btn-info btn-sm dropdown-item" title="Add/Edit/Delete Load Balancer Server"><i class="fa fa-list"></i> Manage LB Server</a>';
                    }
                    $deleteMainServer = 'data-mainserver="' . $server->mainserver . '"';
                    $deleteServerCls = ($lbServers > 0) ? 'deletelbfirst' : 'deleteServer' . $i . '';
                    $script .= ($lbServers > 0) ? "document.getElementById('deletelbfirst').addEventListener('click',deletelbfirst,true);" : "document.getElementById('deleteServer" . $i . "').addEventListener('click',deleteServer,true);";
                    
                
                     $serverhtml.= '<tr id="tr' . $server->server_id . '">';
                    $serverhtml .= '<td><img src="' . $server->flag . '" width="30px"> 
                <!--a href="' . $modulelink . '&action=vpn_servers&serverid=' . $server->server_id . '"-->' . $server->server_name . $mainserver . '<!--/a--></td>
                <td>' . $server->server_ip . '</td>
                <td>' . $serverCategory . '</td>
                <td>' . $server->sshport . '</td>
                <!--td class="cpuper"><i class="fa fa-spin fa-circle-o-notch"></i></td>
                <td class="memper"><i class="fa fa-spin fa-circle-o-notch"></i></td-->
                <td class="status">'.$status.'</td>
                <td>' . $lbServers . '</td>
                <td>' . $server->created_at . '</td>
                <td>' . $server->onlineCount . '</td>
                <td>
                <div class="btn-group" role="group">
    <button id="btnGroupDrop1" type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
      Actions <i class="fa fa-sort-down"></i>
    </button>
                    <div class="dropdown-menu" aria-labelledby="btnGroupDrop1">
                    <!--a href="' . $modulelink . '&action=vpn_serverInfo&serverid=' . $server->server_id . '" class="btn btn-sm btn-info" title="View Server Information"><i class="fa fa-info-circle"></i> OS Info</a-->

                    <button type="button" data-serverid="' . $server->server_id . '" class="btn btn-info btn-sm editServer dropdown-item" id="editServer' . $i . '" title="edit Server"><i class="fa fa-edit"></i> Edit Server <i class="fa fa-spin fa-spinner loading" style="display: none;"></i></button>
                    <button type="button" id="' . $deleteServerCls . '" data-serverid="' . $server->server_id . '" ' . $deleteMainServer . ' class="btn btn-danger btn-sm deleteServer dropdown-item" style="'.$hide.'" title="delete server"><i class="fa fa-trash"></i> Delete Server <i class="fa fa-spin fa-spinner loading" style="display: none;"></i></button>
                    '.$mainServerInstall.' '.$lbButton.'
                    <button type="button" id="rebootServer' . $i . '" data-serverid="' . $server->server_id . '" class="btn btn-danger btn-sm rebootServer dropdown-item"><i class="fa fa-power-off"></i> Reboot Server  <i class="fa fa-spin fa-spinner loading" style="display: none;"></i></button>
                    <!--button type="button" id="repairServer' . $i . '" data-serverid="' . $server->server_id . '" class="btn btn-warning btn-sm repairServer dropdown-item" title="repair server"><i class="fa fa-cogs"></i> Repair Server  <i class="fa fa-spin fa-spinner loading" style="display: none;"></i></button-->
                     <form method="post" action="' . $systemurl . '/includes/downloadcert.php" style="float: left; width: 100%; margin-bottom: 5px; padding-bottom: 5px; border-bottom: solid 1px #efefef;">
<input type="hidden" name="token" value="2d71fa2b09ad870fb9d418db05f0abe730501b4b">

<button name="d" type="submit" value="ovpn" class="btn btn-sm btn-success dropdown-item" style="margin-bottom: 5px; text-align: center;"><i class="fa fa-download"></i> Download ovpn</button>
<button name="d" type="submit" value="pem" class="btn btn-sm btn-success dropdown-item" style="margin-bottom: 5px; text-align: center;"><i class="fa fa-download"></i> Download pem</button>
 
<input type="hidden" name="s" value="' . $server->server_ip . '">
</form>
                    
                </div>
                </div>
                </td></tr>';
                }
                
                foreach ($getgrpServer as $groupdata) {
                    
                   // echo '<pre>'; print_r($groupdata['gid']); 
                    $Delbutton = '<a href="addonmodules.php?module=vpnpanel&action=vpn_group&type=delete&id='.$groupdata['gid'].'" class="pull-right deleteGroupA" style="margin-left: 15px;"><img src="images/delete.gif"></a>';
                   // $script.="document.getElementById('deleteGroupA').addEventListener('click',deleteGroupA,true);";

                    if(!empty($groupdata['servers']))
                    {
                         $Delbutton = '<p class="pull-right" id="deleteGroup'.$j.'" style="margin-left: 15px; margin-bottom: 0px; cursor:pointer;"><img src="images/delete.gif"></p>';
                         $script.="document.getElementById('deleteGroup".$j."').addEventListener('click',deleteGroup,true);";
                         $j++;
                    }

$serverhtmlGroup .= '<tr><td colspan="9" style="background:#f3f3f3;"><strong>Group Name:</strong> '.$groupdata['gname'].' '.$Delbutton.' <a href="addonmodules.php?module=vpnpanel&action=vpn_group&type=edit&id='.$groupdata['gid'].'" class="pull-right"><img src="images/edit.gif"></a>
                    </td></tr>';
    $serverhtml.= $serverhtmlGroup;
    $serverhtmlGroup = '';
    if(!empty($groupdata['servers']))
    {
                foreach ($groupdata['servers'] as $server) {

                    $lbServers = $server->lbServer;
                    $i++;
                    
                    if ($server->server_category == 'openvpn') {
                        $serverCategory = ($server->mainserver)?'Main Server':'OpenVPN';
                    } else if ($server->server_category == 'ikev2') {
                        $serverCategory = ($server->mainserver)?'Main Server':'Ikev2/IPSEC';
                    } else if ($server->server_category == 'openvpn-ikev2') {
                        $serverCategory = ($server->mainserver)?'Main Server':'OpenVPN + Ikev2/IPSEC';
                    }
                    $script .= "document.getElementById('editServer" . $i . "').addEventListener('click',editServer,true);
                    document.getElementById('rebootServer" . $i . "').addEventListener('click',rebootServer,true);";
                    $script.= ($server->mainserver)?'':"document.getElementById('reinstallServer" . $i . "').addEventListener('click',reinstallServer,true);
                    document.getElementById('restartservices" . $i . "').addEventListener('click',restartservices,true);
                    ";
                    if ($server->status == 1) {
                        $status = '<span class="badge badge-success" style="background: #24a238;">Server Online</span>';
                    } elseif ($server->status == 2) {
                        $status = '<span class="badge badge-warning" data-serverid="' . $server->server_id . '" style="background: #ffa700;">Processing..</span>';
                    } else {
                        $status = '<span class="badge badge-warning" data-serverid="' . $server->server_id . '" style="background: #ffa700;">Offline</span>';
                    }


                    $mainserver = ($server->mainserver) ? ' <i class="fa fa-certificate text-success"></i> (Main Server)' : '';
                    $hide = ($server->mainserver)?'display: none':'';
                    $mainServerInstall = ($server->mainserver)?'<a href="https://www.whmcssmarters.com/clients/clientarea.php?action=productdetails&id='.$server->pskkey.'" target="_blank" id="reinstallServer' . $i . '" class="btn btn-warning btn-sm dropdown-item" title="re-install server"><i class="fa fa-refresh"></i> Re-Install  <i class="fa fa-spin fa-spinner loading" style="display: none;"></i></a>':'<button type="button" id="reinstallServer' . $i . '" data-serverid="' . $server->server_id . '" class="btn btn-warning btn-sm reinstallServer dropdown-item" title="re-install server"><i class="fa fa-refresh"></i> Re-Install  <i class="fa fa-spin fa-spinner loading" style="display: none;"></i></button> <button type="button" id="restartservices' . $i . '" data-serverid="' . $server->server_id . '" class="btn btn-info btn-sm restartservices dropdown-item" style="margin-top: 5px;" title="Restart Services"><i class="fa fa-cogs"></i> Restart Services  <i class="fa fa-spin fa-spinner loading" style="display: none;"></i></button> ';
                    $lbButton = '';
                    if(!$server->mainserver && $server->server_category !== 'ikev2')
                    {
                        $lbButton = '<a href="' . $modulelink . '&action=vpn_servers&serverid=' . $server->server_id . '" class="btn btn-info btn-sm dropdown-item" title="Add/Edit/Delete Load Balancer Server"><i class="fa fa-list"></i> Manage LB Server</a>';
                    }
                    $deleteMainServer = 'data-mainserver="' . $server->mainserver . '"';
                    $deleteServerCls = ($lbServers > 0) ? 'deletelbfirst' : 'deleteServer' . $i . '';
                    $script .= ($lbServers > 0) ? "document.getElementById('deletelbfirst').addEventListener('click',deletelbfirst,true);" : "document.getElementById('deleteServer" . $i . "').addEventListener('click',deleteServer,true);";
                    
                
                     $serverhtml.= '<tr id="tr' . $server->server_id . '">';
                    $serverhtml .= '<td><img src="' . $server->flag . '" width="30px"> 
                <!--a href="' . $modulelink . '&action=vpn_servers&serverid=' . $server->server_id . '"-->' . $server->server_name . $mainserver . '<!--/a--></td>
                <td>' . $server->server_ip . '</td>
                <td>' . $serverCategory . '</td>
                <td>' . $server->sshport . '</td>
                <!--td class="cpuper"><i class="fa fa-spin fa-circle-o-notch"></i></td>
                <td class="memper"><i class="fa fa-spin fa-circle-o-notch"></i></td-->
                <td class="status">'.$status.'</td>
                <td>' . $lbServers . '</td>
                <td>' . $server->created_at . '</td>
                <td>' . $server->onlineCount . '</td>
                <td>
                <div class="btn-group" role="group">
    <button id="btnGroupDrop1" type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
      Actions <i class="fa fa-sort-down"></i>
    </button>
                    <div class="dropdown-menu" aria-labelledby="btnGroupDrop1">
                    <!--a href="' . $modulelink . '&action=vpn_serverInfo&serverid=' . $server->server_id . '" class="btn btn-sm btn-info" title="View Server Information"><i class="fa fa-info-circle"></i> OS Info</a-->

                    <button type="button" data-serverid="' . $server->server_id . '" class="btn btn-info btn-sm editServer dropdown-item" id="editServer' . $i . '" title="edit Server"><i class="fa fa-edit"></i> Edit Server <i class="fa fa-spin fa-spinner loading" style="display: none;"></i></button>
                    <button type="button" id="' . $deleteServerCls . '" data-serverid="' . $server->server_id . '" ' . $deleteMainServer . ' class="btn btn-danger btn-sm deleteServer dropdown-item" style="'.$hide.'" title="delete server"><i class="fa fa-trash"></i> Delete Server <i class="fa fa-spin fa-spinner loading" style="display: none;"></i></button>
                    '.$mainServerInstall.' '.$lbButton.'
                    <button type="button" id="rebootServer' . $i . '" data-serverid="' . $server->server_id . '" class="btn btn-danger btn-sm rebootServer dropdown-item"><i class="fa fa-power-off"></i> Reboot Server  <i class="fa fa-spin fa-spinner loading" style="display: none;"></i></button>
                    <!--button type="button" id="repairServer' . $i . '" data-serverid="' . $server->server_id . '" class="btn btn-warning btn-sm repairServer dropdown-item" title="repair server"><i class="fa fa-cogs"></i> Repair Server  <i class="fa fa-spin fa-spinner loading" style="display: none;"></i></button-->
                     <form method="post" action="' . $systemurl . '/includes/downloadcert.php" style="float: left; width: 100%; margin-bottom: 5px; padding-bottom: 5px; border-bottom: solid 1px #efefef;">
<input type="hidden" name="token" value="2d71fa2b09ad870fb9d418db05f0abe730501b4b">

<button name="d" type="submit" value="ovpn" class="btn btn-sm btn-success dropdown-item" style="margin-bottom: 5px; text-align: center;"><i class="fa fa-download"></i> Download ovpn</button>
<button name="d" type="submit" value="pem" class="btn btn-sm btn-success dropdown-item" style="margin-bottom: 5px; text-align: center;"><i class="fa fa-download"></i> Download pem</button>
 
<input type="hidden" name="s" value="' . $server->server_ip . '">
</form>
                    
                </div>
                </div>
                </td></tr>';
                }
            }
            else
            {
                $serverhtml.= '<tr id="tr' . $server->server_id . '"><td colspan="9"><p class="text-center">No Server Added in this group.</p></td></tr>';
            }
            
            }
                $breadcrumb = '<li class="breadcrumb-item active"><a href="' . $modulelink . '">Dashboard</a></li><li class="breadcrumb-item active">Servers</li>';
                $serverGroupsList = array();
                foreach($serverGroups as $group)
                {
                    $serverGroupsList[$group->id] = $group->groupName;
                }
                $smarty = new Smarty();
                $smarty->assign('serverhtml', $serverhtml);
                $smarty->assign('modulelink', $modulelink);
                $smarty->assign('apikey', $apikey);
                $smarty->assign('panelURL', $panelURL);
                $smarty->assign('script1', $script);
                $smarty->assign('message', $message);
                $smarty->assign('lbservers', $lbServers);
                $smarty->assign('serverconf', $configdata);
                $smarty->assign('systemURL', $systemURL);
                $smarty->assign('breadcrumb', $breadcrumb);
                $smarty->assign('serverGroups', $serverGroupsList);
                
                $smarty->display('../modules/addons/vpnpanel/templates/servers.tpl');
            }
        }
    }

    public function vpn_serverInfo($vars) {
        set_include_path(get_include_path() . PATH_SEPARATOR . 'phpseclib');
        require_once __DIR__ . '/../../phpseclib/Crypt/RC4.php';
        require_once __DIR__ . '/../../phpseclib/Crypt/Rijndael.php';
        require_once __DIR__ . '/../../phpseclib/Crypt/Twofish.php';
        require_once __DIR__ . '/../../phpseclib/Crypt/Blowfish.php';
        require_once __DIR__ . '/../../phpseclib/Crypt/TripleDES.php';
        require_once __DIR__ . '/../../phpseclib/Crypt/Random.php';
        require_once __DIR__ . '/../../phpseclib/Crypt/Hash.php';
        require_once __DIR__ . '/../../phpseclib/Math/BigInteger.php';
        require_once __DIR__ . '/../../phpseclib/Net/SSH2.php';
        include_once __DIR__ . '/../../functions.php';
        $message = '';

        // Get common module parameters
        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
        $version = $vars['version']; // eg. 1.0
        $LANG = $vars['_lang']; // an array of the currently loaded language variables
        $serverid = $_REQUEST['serverid'];
        $getServerInfo = getServerInfo($serverid);
        $serverhtml = $getServerInfo['osinfo'];
        $memoryused = $getServerInfo['mem']['used'];
        $memorytotal = $getServerInfo['mem']['total'];
        $memoryfree = $getServerInfo['mem']['free'];
        $name = $getServerInfo['servername'];
        $ip = $getServerInfo['serverip'];
        $cpu = $getServerInfo['cpu'];
        $breadcrumb = '<li class="breadcrumb-item"><a href="' . $modulelink . '">Dashboard</a></li><li class="breadcrumb-item active">Resellers</li>';
        $smarty = new Smarty();
        $smarty->assign('serverhtml', $serverhtml);
        $smarty->assign('memtotal', $memorytotal);
        $smarty->assign('memfree', $memoryfree);
        $smarty->assign('memused', $memoryused);
        $smarty->assign('cpu', $cpu);
        $smarty->assign('breadcrumb', $breadcrumb);
        $smarty->assign('servername', $name);
        $smarty->assign('serverip', $ip);
        $smarty->display('../modules/addons/vpnpanel/templates/serverinfo.tpl');
    }

    public function addproducts($vars) {
        include_once __DIR__ . '/../../functions.php';
        $command = 'GetEmailTemplates';
        $postData = array(
            'type' => 'product',
        );
        $results = localAPI($command, $postData, '');
        $message = '';
        $getproductgroup = getProductGroup();
        $breadcrumb = '<li class="breadcrumb-item"><a href="' . $modulelink . '">Dashboard</a></li><li class="breadcrumb-item">Add Product</li>';
        $smarty = new Smarty();
        $smarty->assign('emailtemplates', $results['emailtemplates']['emailtemplate']);
        $smarty->assign('serverhtml', $serverhtml);
        $smarty->assign('modulelink', $modulelink);
        $smarty->assign('message', $message);
        $smarty->assign('getproductgroup', $getproductgroup);
        $smarty->assign('breadcrumb', $breadcrumb);
        $smarty->display('../modules/addons/vpnpanel/templates/addproducts.tpl');
    }

    public function vpn_resellers($vars) {
        include_once __DIR__ . '/../../functions.php';
        $message = '';
        $groupid = getclientgroupid('Reseller');
        if (isset($_POST['addassignpack'])) {
            $assignData = addassignData($_POST);
            echo $assignData;
            exit;
        }
        if (isset($_POST['editassignpack'])) {
            $id = $_POST['id'];
            if ($id == 'all') {
                $assignData = getallpackagesdata($groupid);
            } else {
                $assignData = getassignedpackages($id);
            }
            $List = array();
            foreach ($assignData as $resellerList) {
                foreach ($resellerList as $key => $val) {
                    $List[$key] = $val;
                }
            }
            echo json_encode($List);
            exit;
        }
        if (isset($_POST['updateassignpack'])) {
            
        }

        $packagesdata = getassignedpackages();

        $resellersList = getResellersList();
        $i = 0;
        $resellerList = array();
        foreach ($resellersList as $reseller) {
            foreach ($reseller as $key => $val) {
                $resellerList[$i][$key] = $val;
            }
            $i++;
        }
        $allAssignedPackagsData = getallpackagesdata($groupid);
        
        $datahtml = '';
        $datahtml1 = '';
        $smarty = new Smarty();
        foreach ($allAssignedPackagsData as $package) {
            $name = (isset($package->firstname)) ? $package->firstname . ' ' . $package->lastname : 'All Resellers';
            $datahtml1 .= '<tr><td>' . $name . '</td><td>' . getpackagename($package->products). '</td><td><button class="btn btn-info editbtn" data-id="' . $package->resellerid . '" ><i class="fa fa-edit"></i></button></td></tr>';
        }


        foreach ($packagesdata as $package) {
            $smarty->assign('packageassing' . $package->resellerid, getpackagename($package->products));
        }

        $productsList = getAllProducts();

        //echo '<pre>';print_r($productsList); die();
        $breadcrumb = '<li class="breadcrumb-item"><a href="' . $modulelink . '">Dashboard</a></li><li class="breadcrumb-item active">Assign Packages</li>';
        $moduleLink = $vars['modulelink'];
        $apikey = getapi();
        $smarty->assign('modulelink', $moduleLink);
        $smarty->assign('packagesdata', $datahtml);

        $smarty->assign('allpackagesdata', $datahtml1);
        $smarty->assign('breadcrumb', $breadcrumb);
        $smarty->assign('resellers', $resellerList);
        $smarty->assign('productsListarray', $productsList);
        // Get common module parameters
        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
        $version = $vars['version']; // eg. 1.0
        $LANG = $vars['_lang']; // an array of the currently loaded language variables

        $getResellersList = getResellersList();
        $affdata = array();
        $i = 0;
        foreach ($getResellersList as $data) {
            foreach ($data as $key => $val) {
                $affdata[$i][$key] = $val;
            }
            $i++;
        }
        $owneremail = getOwner();
        $breadcrumb = '<li class="breadcrumb-item"><a href="' . $modulelink . '">Dashboard</a></li><li class="breadcrumb-item active">Resellers</li>';
        
        $smarty->assign('groupid', $groupid);
        $smarty->assign('serverhtml', $serverhtml);
        $smarty->assign('modulelink', $modulelink);
        $smarty->assign('message', $message);
        $smarty->assign('affdata', $affdata);
        $smarty->assign('owneremail', $owneremail);
        $smarty->assign('breadcrumb', $breadcrumb);
        $smarty->display('../modules/addons/vpnpanel/templates/resellersList.tpl');
    }

    public function vpn_superresellers($vars) {
        include_once __DIR__ . '/../../functions.php';
        $message = '';
        $groupid = getclientgroupid('Super-Reseller');
        if (isset($_POST['addassignpack'])) {
            $assignData = addassignData($_POST);
            echo $assignData;
            exit;
        }
        if (isset($_POST['editassignpack'])) {
            $id = $_POST['id'];
            if ($id == 'all') {
                $assignData = getallpackagesdata($groupid);
            } else {
                $assignData = getassignedpackages($id);
            }
            $List = array();
            foreach ($assignData as $resellerList) {
                foreach ($resellerList as $key => $val) {
                    $List[$key] = $val;
                }
            }
            echo json_encode($List);
            exit;
        }
        if (isset($_POST['updateassignpack'])) {
            
        }

        $packagesdata = getassignedpackages();

        $resellersList = getSuperResellersList();
        $i = 0;
        $resellerList = array();
        foreach ($resellersList as $reseller) {
            foreach ($reseller as $key => $val) {
                $resellerList[$i][$key] = $val;
            }
            $i++;
        }
        $allAssignedPackagsData = getallpackagesdata($groupid);
        
        $datahtml = '';
        $datahtml1 = '';
        $smarty = new Smarty();
        foreach ($allAssignedPackagsData as $package) {
            $name = (isset($package->firstname)) ? $package->firstname . ' ' . $package->lastname : 'All Resellers';
            $datahtml1 .= '<tr><td>' . $name . '</td><td>' . getpackagename($package->products). '</td><td><button class="btn btn-info editbtn" data-id="' . $package->resellerid . '" ><i class="fa fa-edit"></i></button></td></tr>';
        }


        foreach ($packagesdata as $package) {
            $smarty->assign('packageassing' . $package->resellerid, getpackagename($package->products));
        }

        $productsList = getAllProducts();

        //echo '<pre>';print_r($productsList); die();
        $breadcrumb = '<li class="breadcrumb-item"><a href="' . $modulelink . '">Dashboard</a></li><li class="breadcrumb-item active">Assign Packages</li>';
        $moduleLink = $vars['modulelink'];
        $apikey = getapi();
        $smarty->assign('modulelink', $moduleLink);
        $smarty->assign('packagesdata', $datahtml);

        $smarty->assign('allpackagesdata', $datahtml1);
        $smarty->assign('breadcrumb', $breadcrumb);
        $smarty->assign('resellers', $resellerList);
        $smarty->assign('productsListarray', $productsList);
        // Get common module parameters
        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
        $version = $vars['version']; // eg. 1.0
        $LANG = $vars['_lang']; // an array of the currently loaded language variables

        $getSuperResellersList = getSuperResellersList();
        $affdata = array();
        $i = 0;
        foreach ($getSuperResellersList as $data) {
            foreach ($data as $key => $val) {
                $affdata[$i][$key] = $val;
            }
            $i++;
        }
        $owneremail = getOwner();
        $breadcrumb = '<li class="breadcrumb-item"><a href="' . $modulelink . '">Dashboard</a></li><li class="breadcrumb-item active">Resellers</li>';
        
        $smarty->assign('groupid', $groupid);
        $smarty->assign('serverhtml', $serverhtml);
        $smarty->assign('modulelink', $modulelink);
        $smarty->assign('message', $message);
        $smarty->assign('affdata', $affdata);
        $smarty->assign('owneremail', $owneremail);
        $smarty->assign('breadcrumb', $breadcrumb);
        $smarty->display('../modules/addons/vpnpanel/templates/resellersList.tpl');
    }

    public function vpn_listusers($vars) {
        include_once __DIR__ . '/../../functions.php';
        $message = '';
        if (isset($_REQUEST['affid']) && !empty($_REQUEST['affid'])) {
            // Get common module parameters
            $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
            $version = $vars['version']; // eg. 1.0
            $LANG = $vars['_lang']; // an array of the currently loaded language variables

            $getResellersList = getusersList($_REQUEST['affid']);
            $affdata = array();
            $i = 0;
            $owneremail = getOwner($_REQUEST['affid']);
            $i = 0;
            $j = 0;
            $affdata = array();
            $servicedata = array();

            foreach ($getResellersList as $data1) {
                foreach ($data1 as $key => $val) {
                    $affdata[$i][$key] = $val;
                }
                $i++;
                $getuserservicesList = getuserservicesList($data1->clientid);
                foreach ($getuserservicesList['products']['product'] as $data) {
                    foreach ($data as $key => $val) {
                        $servicedata[$data1->clientid][$j][$key] = $val;
                    }
                    $j++;
                }
            }
        }

        $breadcrumb = '<li class="breadcrumb-item"><a href="' . $modulelink . '">Dashboard</a></li><li class="breadcrumb-item"><a href="' . $modulelink . '&action=vpn_resellers">Resellers</a></li><li class="breadcrumb-item active">Users</li>';
        $smarty = new Smarty();
        $smarty->assign('serverhtml', $serverhtml);
        $smarty->assign('modulelink', $modulelink);
        $smarty->assign('message', $message);
        $smarty->assign('affdata', $affdata);
        $smarty->assign('servicedata', $servicedata);
        $smarty->assign('owneremail', $owneremail);
        $smarty->assign('breadcrumb', $breadcrumb);
        $smarty->display('../modules/addons/vpnpanel/templates/listusers.tpl');
    }

    public function vpn_listuserservices($vars) {
        include_once __DIR__ . '/../../functions.php';
        $message = '';
        if (isset($_REQUEST['userid']) && !empty($_REQUEST['userid'])) {
            // Get common module parameters
            $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
            $version = $vars['version']; // eg. 1.0
            $LANG = $vars['_lang']; // an array of the currently loaded language variables

            $getuserservicesList = getuserservicesList($_REQUEST['userid']);
            $affdata = array();
            $i = 0;
            $owneremail = getOwner($_REQUEST['affid'], 'user');
            foreach ($getuserservicesList['products']['product'] as $data) {
                foreach ($data as $key => $val) {
                    $affdata[$i][$key] = $val;
                }
                $i++;
            }
        }
        $breadcrumb = '<li class="breadcrumb-item"><a href="' . $modulelink . '&action=vpn_resellers">Resellers</a></li><li class="breadcrumb-item"><a href="#" class="goback">Users</a></li><li class="breadcrumb-item active">User Services</li>';
        $smarty = new Smarty();
        $smarty->assign('serverhtml', $serverhtml);
        $smarty->assign('modulelink', $modulelink);
        $smarty->assign('message', $message);

        $smarty->assign('owneremail', $owneremail);
        $smarty->assign('breadcrumb', $breadcrumb);
        $smarty->display('../modules/addons/vpnpanel/templates/listuserservices.tpl');
    }

    public function vpn_applinks($vars) {

        //print_r($_POST); die(sadf);

        include_once __DIR__ . '/../../functions.php';
        $message = '';
        if (isset($_POST['addapp'])) {
            $addappresult = addapp($_POST);
            echo $addappresult;
            exit;
        }
        if (isset($_POST['deleteapp'])) {

            $addappresult = deleteapp($_POST);
            echo $addappresult;
            exit;
        }

        // Get common module parameters
        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
        $version = $vars['version']; // eg. 1.0
        $LANG = $vars['_lang']; // an array of the currently loaded language variables
        // Get module configuration parameters

        $applink = getAppLinks();

        $i = 0;
        $script = "document.getElementById('addserverbtn').addEventListener('click',addservermodal,true);";
        foreach ($applink as $app) {
            $i++;
            $script .= "document.getElementById('deleteapp" . $i . "').addEventListener('click',deleteapp,true);";
            $appdata .= '<tr><td>' . $app->appfor . '</td><td>' . $app->appname . '</td><td>' . $app->applink . '</td><td><form method="post" action="addonmodules.php?module=vpnpanel&action=vpn_applinks" id="deleteform' . $i . '"><button type="button" name="deleteapp" data-appid="' . $app->id . '" class="btn btn-danger deleteapp" id="deleteapp' . $i . '"><i class="fa fa-trash"></i></button><input type="hidden" name="appid" value="' . $app->id . '"></form></td></tr>';
        }
        $smarty = new Smarty();
        $breadcrumb = '<li class="breadcrumb-item active"><a href="' . $modulelink . '">Dashboard</a></li><li class="breadcrumb-item active">App Links</li>';
        $smarty->assign('serverhtml', $serverhtml);
        $smarty->assign('modulelink', $modulelink);
        $smarty->assign('appdata', $appdata);
        $smarty->assign('script1', $script);
        $smarty->assign('message', $message);
        $smarty->assign('breadcrumb', $breadcrumb);
        $smarty->display('../modules/addons/vpnpanel/templates/application.tpl');
    }

    public function vpn_accounts($vars) 
    {

        include_once __DIR__ . '/../../radiusFunction.php';
        
        $message = '';
        
        $smarty = new Smarty();
        
        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
        $version = $vars['version']; // eg. 1.0
        $LANG = $vars['_lang']; // an array of the currently loaded language variables
        
        $allClients = vpn_getVPNServices();
        
        $clinetServices = array(); 
        
        foreach($allClients['records'] as $allClient) 
        {
            $owner = "N/A";
            
            if(!empty($allClient->notes))
            {
                $owner = explode(":",$allClient->notes)[1];
            }
            
            $clinetServices[] = array(
                                    'userid' => $allClient->id,
                                    'firstname' => $allClient->firstname,
                                    'lastname' => $allClient->lastname,
                                    'created_at' => fromMySQLDate($allClient->updated_at),
                                    'status' => $allClient->status,
                                    'owner' => $owner,
                                    'email' => $allClient->email,
                                    'services'=> vpn_getClientServicesCount($allClient->id)
                                );
           
        }

        $breadcrumb = '<li class="breadcrumb-item active"><a href="' . $modulelink . '">Dashboard</a></li><li class="breadcrumb-item active">VPN Accounts</li>';
       
        $smarty->assign('breadcrumb', $breadcrumb);
        
        $smarty->assign('radclients', $clinetServices);
        
        $smarty->assign('modulelink', $modulelink);
        
        $smarty->display('../modules/addons/vpnpanel/templates/radaccounts.tpl');
    }
    
    
    public function vpn_userServices($vars) 
    {

        include_once __DIR__ . '/../../radiusFunction.php';
        
        $message = '';
        
        $smarty = new Smarty();
        
        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
        $version = $vars['version']; // eg. 1.0
        $LANG = $vars['_lang']; // an array of the currently loaded language variables
        $configdata = getserverconfig();
        $disablelogs = $configdata['logging']['value'];
        $userid = $_GET['userid'];
        
        $currencyData = getCurrency($userid);
        
        $allClients = vpn_getClientServices($userid);
        
        foreach ($allClients as $allClient) 
        {
            
            if($allClient->amount)
            {
                $allClient->amount = $currencyData['prefix'].$allClient->amount.$currencyData['suffix'];
            }
        }
        
        $breadcrumb = '<li class="breadcrumb-item active"><a href="' . $modulelink . '">Dashboard</a></li><li class="breadcrumb-item active">VPN Services</li>';
       
        $smarty->assign('breadcrumb', $breadcrumb);
        
        $smarty->assign('clientServices', $allClients);
        $smarty->assign('disablelogs',$disablelogs);
        $smarty->assign('modulelink', $modulelink);
        
        $smarty->display('../modules/addons/vpnpanel/templates/vpnuserServices.tpl');
    }
    
    
    public function vpn_usage($vars) 
    {
        global $CONFIG;
        
        $dateformat = $CONFIG['DateFormat'];
        
        include_once __DIR__ . '/../../radiusFunction.php';
        
        $message = '';
        
        $tplfile = '../modules/addons/vpnpanel/templates/';
        
        $smarty = new Smarty();
        
        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
        
        
        $smarty->assign('modulelink', $modulelink);
        
        $breadcrumb = '<li class="breadcrumb-item"><a href="' . $modulelink . '">Dashboard</a></li><li class="breadcrumb-item"><a href="' . $modulelink . '&action=vpn_accounts">VPN Accounts</a></li>';
       
        if (isset($_GET['id'])) 
        {
            $serviceid = $_GET['id'];
        }
        
        
        if(!empty($serviceid))
        {
            #get service details
            $service = array();
            
            $service['serviceid'] = $serviceid;
            $service['username'] = vpn_getServiceUserName($serviceid);
            
            $username = vpn_getClientNameByUsername($service['username']);
            
            if(!empty($username[0]->firstname))
            {
                $name .= $username[0]->firstname;
            }

            if(!empty($username[0]->lastname))
            {
                $name .= " ".$username[0]->lastname;
            }

            $service['name'] = $name;
            $service['userid'] = $username[0]->userid;
            
        }
        
        
        if(!empty($_GET['m']))
        {
            $mode = $_GET['m'];
            
            if($mode=='d')
            {
                $tplfile .= 'vpnusage_d.tpl';
                
                $breadcrumb .= '<li class="breadcrumb-item active">Daily Usage</li>';
                
                $fromdate = vpn_Formatdate(date('Y-m-01'),TRUE);
                $todate = vpn_Formatdate(date('Y-m-d'),TRUE);
        
                if (isset($_POST['filter_record'])) 
                {
                    if(!empty($_POST['fromdate']))
                    {
                        $fromdate = $_POST['fromdate'];
                    }
                    
                    if(!empty($_POST['todate']))
                    {
                        $todate = $_POST['todate'];
                    }
                }
                
                $service['fromdate'] = $fromdate;
                $service['todate'] = $todate;
                
                $details = array(
                                    "serviceid" => $serviceid,
                                    "fromdate" => toMySQLDate($fromdate),//date_format(date_create($fromdate),"Y-m-d"),
                                    "todate" => toMySQLDate($todate)//date_format(date_create($todate),"Y-m-d")
                                );
                
                $usageDetails = vpn_formatUsage(vpn_getDailyUsageDetails($details));
            }
            else if($mode =='m')
            {
                $dateformat = vpn_FormatdateForMonYrForSmarty();
                
                $tplfile .= 'vpnusage_m.tpl';
                
                $breadcrumb .= '<li class="breadcrumb-item active">Monthly Usage</li>';
                
                $fromdate = vpn_FormatdateForMonYr(date('Y-01'),TRUE);
                
                $todate = vpn_FormatdateForMonYr(date('Y-m'),TRUE);
        
                if (isset($_POST['filter_record'])) 
                {
                    if(!empty($_POST['fromdate']))
                    {
                        $fromdate = $_POST['fromdate'];
                    }
                    
                    if(!empty($_POST['todate']))
                    {
                        $todate = $_POST['todate'];
                    }
                }
                
                $service['fromdate'] = $fromdate;
                $service['todate'] = $todate;
                
                $details = array(
                                    "serviceid" => $serviceid,
                                    "fromdate" => toMySQLDate(vpn_FormatdateForMonYrToFull($fromdate,'from',TRUE)),//date_format(date_create($fromdate),"Y-m-d"),
                                    "todate" => toMySQLDate(vpn_FormatdateForMonYrToFull($todate,'to',TRUE))//date_format(date_create($todate),"Y-m-d")
                                );
                
                $usageDetails = vpn_formatUsage(vpn_getMonthlyUsageDetails($details),'m');
                
            }
            else if($mode =='y')
            {
                $tplfile .= 'vpnusage_y.tpl';
                
                $breadcrumb .= '<li class="breadcrumb-item active">Yearly Usage</li>';
                
                
                $fromdate = date('Y');
                
                $todate = date('Y');
        
                if (isset($_POST['filter_record'])) 
                {
                    if(!empty($_POST['fromdate']))
                    {
                        $fromdate = $_POST['fromdate'];
                    }
                    
                    if(!empty($_POST['todate']))
                    {
                        $todate = $_POST['todate'];
                    }
                }
                
                $service['fromdate'] = $fromdate;
                $service['todate'] = $todate;
                
                $details = array(
                                    "serviceid" => $serviceid,
                                    "fromdate" => toMySQLDate(vpn_FormatdateForYrToFull($fromdate,'from',TRUE)),//date_format(date_create($fromdate),"Y-m-d"),
                                    "todate" => toMySQLDate(vpn_FormatdateForYrToFull($todate,'to',TRUE))//date_format(date_create($todate),"Y-m-d")
                                );
                
                $usageDetails = vpn_formatUsage(vpn_getYearlyUsageDetails($details),'y');
                
            }
            /*
            else if($mode =='s')
            {
                $tplfile .= 'vpnusage_s.tpl';
                
                $breadcrumb .= '<li class="breadcrumb-item active">Session Usage</li>';
            }
             * 
             */
            
        }
        
        
        #get service details
        
        $smarty->assign('radclients', $allClients);
        
        $smarty->assign('service', $service);
        
        $smarty->assign('breadcrumb', $breadcrumb);
        
        $smarty->assign('usageDetails', $usageDetails);
        
        $smarty->assign('dateFormat', $dateformat);
        
        $smarty->display($tplfile);
        
        
    }
    
    public function vpn_onlineusers($vars) 
    {

        include_once __DIR__ . '/../../radiusFunction.php';
        
        $message = '';
        
        $smarty = new Smarty();
        
        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
        $version = $vars['version']; // eg. 1.0
        $LANG = $vars['_lang']; // an array of the currently loaded language variables
        
        $allActiveClients = vpn_getOnlineUsers();
        
        $onlineUsers = array();
        
        if(isset($_POST['resetonlineusers']))
        {
            resetonlineusers();
           $smarty->assign('message', '<p class="alert alert-success">Success! All Users are disconnected.</p>');
        }
        
        foreach ($allActiveClients as $allActiveClient) 
        {
            $obj = new stdClass();
            
            $name = '';
            
            if(!empty($allActiveClient->Username))
            {
                $username = vpn_getClientNameByUsername($allActiveClient->Username);
                
                if(!empty($username[0]->firstname))
                {
                    $name .= $username[0]->firstname;
                }
                
                if(!empty($username[0]->lastname))
                {
                    $name .= " ".$username[0]->lastname;
                }
                
                $serviceid = $username[0]->serviceid;
                
                $userid = $username[0]->userid;
            }
            
          
            $obj->Username = $allActiveClient->Username;
            
            $obj->name = $name;
            
            $obj->serviceid = $serviceid;
            
            $obj->userid = $userid;
            
            $obj->FramedIPAddress = $allActiveClient->FramedIPAddress;
            $obj->CallingStationId = $allActiveClient->CallingStationId;
            $obj->AcctStartTime = fromMySQLDate($allActiveClient->AcctStartTime);
            $obj->total = vpn_time2str($allActiveClient->AcctSessionTime);
            $obj->NASIPAddress = $allActiveClient->NASIPAddress;
            
            $onlineUsers[] = $obj;

        }
        
        $breadcrumb = '<li class="breadcrumb-item active"><a href="' . $modulelink . '">Dashboard</a></li><li class="breadcrumb-item active">VPN Online Users</li>';
       
        $smarty->assign('breadcrumb', $breadcrumb);
        
        $smarty->assign('activeclients', $onlineUsers);
        
        $smarty->assign('modulelink', $modulelink);
        
        $smarty->display('../modules/addons/vpnpanel/templates/radonlineusers.tpl');
    }

}
