<?php
namespace WHMCS\Module\Addon\assign_products_to_resellers\Admin;
include_once('../../../../init.php');
use Illuminate\Database\Capsule\Manager as Capsule;
/**
 * Sample Admin Area Controller
 */
class Controller {

    /**
     * Index action.
     *
     * @param array $vars Module configuration parameters
     *
     * @return string
     */
    public function index($vars)
    {
        // Get common module parameters
        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
        $version = $vars['version']; // eg. 1.0
        $LANG = $vars['_lang']; // an array of the currently loaded language variables

        $resellersList = Capsule::table('tblaffiliates')->join('tblclients', 'tblclients.id','=','tblaffiliates.clientid')->select('tblclients.id','tblclients.firstname','tblclients.lastname','tblclients.lastname')->get();
        $groups = Capsule::table('tblproductgroups')->select('id','name')->get();
        $groupshtml = '';
        foreach($groups as $group)
        {
            $groupshtml.= '<label><input type="checkbox" name="group[]" value="'.$group->id.'"> '.$group->name.'</label>';
        }
        $resellerhtml = '';
        foreach($resellersList as $reseller)
        {
            $resellerhtml.= '<tr><td>'.$reseller->firstname.' '.$reseller->lastname.'</td><td><button class="btn btn-info assigngrp" onclick = "openpopup()">Assign Groups</button></td></tr>';
        }
       return array('resellerhtml' => $resellerhtml, 'grouphtml' => $groupshtml);  
    }

    /**
     * Show action.
     *
     * @param array $vars Module configuration parameters
     *
     * @return string
     */
    public function show($vars)
    {
        // Get common module parameters
        $modulelink = $vars['modulelink']; // eg. addonmodules.php?module=addonmodule
        $version = $vars['version']; // eg. 1.0
        $LANG = $vars['_lang']; // an array of the currently loaded language variables

        // Get module configuration parameters
        $configTextField = $vars['Text Field Name'];
        $configPasswordField = $vars['Password Field Name'];
        $configCheckboxField = $vars['Checkbox Field Name'];
        $configDropdownField = $vars['Dropdown Field Name'];
        $configRadioField = $vars['Radio Field Name'];
        $configTextareaField = $vars['Textarea Field Name'];

        return <<<EOF

<h2>Show</h2>

<p>This is the <em>show</em> action output of the sample addon module.</p>

<p>The currently installed version is: <strong>{$version}</strong></p>

<p>
    <a href="{$modulelink}" class="btn btn-info">
        <i class="fa fa-arrow-left"></i>
        Back to home
    </a>
</p>

EOF;
    }
}
