<?php

use Illuminate\Database\Capsule\Manager as Capsule;

if (isset($_POST['add_package'])) {
    try {
        if (isset($_POST['packages']) && !empty($_POST['packages'])) {
            $package_id = implode(',', $_POST['packages']);
            Capsule::table('mod_xtreamresellergrpuser')->insert(
                    ['client_id' => $_GET['id'], 'product_id' => $package_id]
            );
            $response['result'] = 'success';
            $response['message'] = 'Data has been Save successfully.';
        } else {
            $response['result'] = 'error';
            $response['message'] = 'Please Select Package.';
        }
    } catch (\Exception $e) {
        $response['result'] = 'error';
        $response['message'] = $e->getMessage();
    }
}
if (isset($_POST['delete_package'])) {
    try {
        Capsule::table('mod_xtreamresellergrpuser')->where('id', '=', $_POST['id'])->delete();
        $response['result'] = 'success';
        $response['message'] = 'Data has been Deleted successfully.';
    } catch (\Exception $e) {
        $response['result'] = 'error';
        $response['message'] = $e->getMessage();
    }
}
if (isset($_POST['update_package'])) {
    try {
        if (isset($_POST['packages']) && !empty($_POST['packages'])) {
            $package_id = implode(',', $_POST['packages']);
            Capsule::table('mod_xtreamresellergrpuser')->where('id', $_POST['id'])
                    ->update(['product_id' => $package_id]);
            $response['result'] = 'success';
            $response['message'] = 'Data has been Save successfully.';
        } else {
            $response['result'] = 'error';
            $response['message'] = 'Please Select Package.';
        }
    } catch (\Exception $e) {
        $response['result'] = 'error';
        $response['message'] = $e->getMessage();
    }
}
$products = Capsule::table('tblproducts')
        ->select(Capsule::raw('*'))
        ->where('servertype', '=', 'XtreamCode')
        ->where('configoption3', '=', 'on')
        ->where('hidden', '=', '0')
        ->get();
?>
<!-- Latest compiled and minified CSS -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.12.2/css/bootstrap-select.min.css">

<!-- Latest compiled and minified JavaScript -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.12.2/js/bootstrap-select.min.js"></script>
<div id="smartmenumanager">
    <div class="clear-line-20"></div>
    <div class="container-fluid"><div class="row">
            <div class="col-lg-12"><ol class="breadcrumb"><li><a href="addonmodules.php?module=smartmenumanager">User Packages</a></li></ol></div>

        </div> 
        <div class="clear-line-20"></div> 
        <?php
        if (isset($response['result']) && !empty($response['result'])) {
            if ($response['result'] == 'success') {
                ?>
                <div class="alert alert-success fade in">
                    <a href="#" class="close" data-dismiss="alert">&times;</a>
                    <strong>Success!</strong> <?php echo $response['message']; ?>
                </div>
            <?php } elseif ($response['result'] == 'error') {
                ?>
                <div class="alert alert-danger fade in">
                    <a href="#" class="close" data-dismiss="alert">&times;</a>
                    <strong>Error!</strong> <?php echo $response['message']; ?>
                </div>
                <?php
            }
        }
        ?>  

        <?php
        $mod_xtreamresellergrpusercount = Capsule::table('mod_xtreamresellergrpuser')->where('client_id', '=', $_GET['id'])->count();
        if (isset($mod_xtreamresellergrpusercount) && !empty($mod_xtreamresellergrpusercount)) {
             $mod_xtreamresellergrpuser = Capsule::table('mod_xtreamresellergrpuser')->where('client_id', '=', $_GET['id'])->get();
            ?>
            <h1 style="float: left;">Packages</h1>
            <div class="listtable"> 
                <table id="tableReseller" class="table table-list dataTable no-footer dtr-inline" aria-describedby="tableReseller_info" role="grid">
                    <thead>
                        <tr role="row">
                            <th class="sorting_asc" tabindex="0" aria-controls="tableReseller" rowspan="1" colspan="1" style="width: 0px;" aria-sort="ascending">Product ID(s)</th>
                            <th class="sorting" tabindex="0" aria-controls="tableReseller" rowspan="1" colspan="1"  style="width: 0px;">Product/Service</th>    
                            <th class="sorting_asc" tabindex="0" aria-controls="tableReseller" rowspan="1" colspan="1" style="width: 0px;">Action</th> 
                        </tr>
                    </thead>
                    <tbody>  
                        <?php
                        $tableids = array();
                        foreach ($mod_xtreamresellergrpuser as $Xtreamproduct) {
                            $productsdata = explode(',', $Xtreamproduct->product_id);
                            $productname = array();
                            $product_ids = array();
                            foreach ($productsdata as $Xtreamselected) {
                                $productdetails = Capsule::table('tblproducts')->where('id', $Xtreamselected)->get();
                                $productname[] = $productdetails[0]->name;
                                $product_ids[] = $Xtreamselected;
                            }
                            $tableids[] = $Xtreamproduct->id;
                            ?>
                            <tr>
                                <td> <?php echo implode(' , ', $product_ids); ?> </td>
                                <td> <?php echo implode(' , ', $productname); ?> </td>  
                                <td><a href="#UpdateGroup_<?php echo $Xtreamproduct->id; ?>" data-toggle="modal" class="btn btn-sm btn-warning" title="Update Group"><i class="fa fa-pencil"></i></a>
                                    <a href="#DeleteGroup_<?php echo $Xtreamproduct->id; ?>" data-toggle="modal" class="btn btn-sm btn-danger" title="Delete Group"><i class="fa fa-times"></i></a></td> 
                            </tr>

                            <?php
                        }
                        ?>
                    </tbody>
                </table>  
            </div>
            <?php
        } else {
            ?>
            <div class="col-lg-4" style="margin: auto; float: none;">
                <a href="#AddPackage" data-toggle="modal" class="btn btn-sm btn-block btn-primary"><i class="fa fa-plus"></i> Assign Package to Reseller User Group</a>
            </div>
            <?php
        }
        ?>

        <?php
        $mod_xtreamresellergrpuser = Capsule::table('mod_xtreamresellergrpuser')->where('client_id', '=', $_GET['id'])->get();
        foreach ($tableids as $id) {
            ?>
            <div id="DeleteGroup_<?php echo $id; ?>" class="modal fade modal-delete">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <form  method="post"> 
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">x</button>
                                <h4 class="modal-title">Delete "Package"</h4>
                            </div>
                            <div class="modal-body">
                                <p>Are you sure you want to delete this "<b>Package</b>"?</p>
                            </div>
                            <div class="modal-footer">
                                <input type="hidden" name="id" value="<?php echo $id; ?>">
                                <button type="button" class="btn btn-sm btn-default" data-dismiss="modal">Close</button>
                                <button type="submit" name="delete_package" class="btn btn-sm btn-danger">Delete Group</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div id="UpdateGroup_<?php echo $id; ?>" class="modal fade modal-update">
                <div class="modal-dialog">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <form method="post"> 
                                <div class="modal-header">
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">x</span></button>
                                    <h4 class="modal-title">Update Package</h4>
                                </div>
                                <div class="modal-body">
                                    <div class="smartmenumanager-tabs"> 
                                        <div class="tab-content">
                                            <div role="tabpanel" class="tab-pane active" id="groupmain"> 
                                                <div class="form-group">
                                                    <label for="template">Select Packages</label>
                                                    <div class="dropdown cq-dropdown" data-name='statuses'>
                                                        <button class="btn btn-info dropdown-toggle" style="white-space:normal" type="button" id="btndropdown" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                                                            Choose Package(s) for the Reseller
                                                            <span class="caret"></span>
                                                        </button> 
                                                        <ul class="dropdown-menu" aria-labelledby="btndropdown" style="width: 60%;font-size: 16px;left: 40px;">
                                                            <?php
                                                            foreach ($mod_xtreamresellergrpuser as $Xtreamproduct) {
                                                                $productsdata = explode(',', $Xtreamproduct->product_id);
                                                                $product_ids = array();
                                                                foreach ($productsdata as $Xtreamselected) {
                                                                    $product_ids[] = $Xtreamselected;
                                                                }
                                                            }
                                                            foreach (Capsule::table('tblproductgroups')->get() as $groups) {
                                                                ?><li class="nav-header disabled"><b><?php echo $groups->name; ?></b></li>
                                                                <?php
                                                                foreach (Capsule::table('tblproducts')->where('gid', $groups->id)->get() as $products) {
                                                                    $CheckedInput = "";
                                                                    if (in_array($products->id, $product_ids)) {
                                                                        $CheckedInput = "checked";
                                                                    }
                                                                    ?>
                                                                    <li class="list-group-item" style="border: none;padding: 3px 0px 0px 15px;">
                                                                        <label class="dropdown-item">
                                                                            <input type="checkbox" name="packages[]" value='<?php echo $products->id; ?>' <?php echo $CheckedInput; ?> >
                                                                            <?php echo $products->name; ?>
                                                                        </label>
                                                                    </li>
                                                                    <?php
                                                                }
                                                            }
                                                            ?>  
                                                            <li class='text-center'>
                                                                <button type='button' class='btn btn-xs btn-danger clear close-dropdown' value='Clear'>Clear</button>
                                                                <button type='button' class='btn btn-xs btn-success save' value='Save'>Done</button>
                                                            </li>
                                                        </ul>
                                                    </div>  
                                                    <small class="help-block">Choose "Package" if you can't see your package make sure it was Set as Reseller User Package in Product configuration.</small>
                                                </div> 
                                            </div> 
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <input type="hidden" name="id" value="<?php echo $id; ?>">
                                    <button type="button" class="btn btn-sm btn-default" data-dismiss="modal">Close</button>
                                    <button type="submit" name="update_package" class="btn btn-sm btn-primary">Update Package</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
        <div id="AddPackage" class="modal fade modal-create">
            <div class="modal-dialog">
                <div class="modal-content">
                    <form method="post"> 
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">x</span></button>
                            <h4 class="modal-title">Add New Package</h4>
                        </div>
                        <div class="modal-body">
                            <div class="smartmenumanager-tabs"> 
                                <div class="tab-content">
                                    <div role="tabpanel" class="tab-pane active" id="groupmain"> 
                                        <div class="form-group">
                                            <label for="template">Select Packages</label>
                                            <div class="dropdown cq-dropdown" data-name='statuses'>
                                                <button class="btn btn-info dropdown-toggle" style="white-space:normal" type="button" id="btndropdown" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                                                    Choose Package(s) for the Reseller
                                                    <span class="caret"></span>
                                                </button> 
                                                <ul class="dropdown-menu" aria-labelledby="btndropdown" style="width: 60%;font-size: 16px;left: 40px;">
                                                    <?php
                                                    foreach (Capsule::table('tblproductgroups')->get() as $groups) {
                                                        ?><li class="nav-header disabled"><b><?php echo $groups->name; ?></b></li>
                                                        <?php
                                                        foreach (Capsule::table('tblproducts')->where('gid', $groups->id)->get() as $products) {
                                                            ?>
                                                            <li class="list-group-item" style="border: none;padding: 3px 0px 0px 15px;">
                                                                <label class="dropdown-item">
                                                                    <input type="checkbox" name="packages[]" value='<?php echo $products->id; ?>'>
                                                                    <?php echo $products->name; ?>
                                                                </label>
                                                            </li>
                                                            <?php
                                                        }
                                                    }
                                                    ?>  
                                                    <li class='text-center'>
                                                        <button type='button' class='btn btn-xs btn-danger clear close-dropdown' value='Clear'>Clear</button>
                                                        <button type='button' class='btn btn-xs btn-success save' value='Save'>Done</button>
                                                    </li>
                                                </ul>
                                            </div>  
                                            <small class="help-block">Choose "Package" if you can't see your package make sure it was Set as Reseller User Package in Product configuration.</small>
                                        </div> 
                                    </div> 
                                </div>
                            </div>
                        </div> 
                        <div class="modal-footer">
                            <button type="button" class="btn btn-sm btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" name="add_package" class="btn btn-sm btn-primary">Add Package</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="clear-line-20"></div>
    </div>
</div>


<script type="text/javascript" charset="utf8" src="../modules/addons/nxtdashboard/assets/js/dropdownCheckboxes.min.js"></script> 
<link rel="stylesheet" type="text/css" href="../modules/addons/nxtdashboard/assets/css/dropdownCheckboxes.min.css">
<script>
    $(function () {
        $('.cq-dropdown').dropdownCheckboxes();
    });
</script> 

