<?php
require_once(dirname(__FILE__) . '/../../../../../init.php');

use WHMCS\Database\Capsule;

global $CONFIG;
if (file_exists(ROOTDIR . "/modules/addons/AutoBackupV2/lib/Admin/function.php")) {
    include_once(ROOTDIR . "/modules/addons/AutoBackupV2/lib/Admin/function.php");
} else {
    echo '1Please verify that functions file exists';
}

?>
<link rel="stylesheet" href="<?php echo '../modules/addons/AutoBackupV2/lib/Admin/assets/stylelist.css'; ?>">
<style>
    .modal-body-custom {
        min-height: auto;
    }

    div#tableShow {
        padding-top: 12px;
    }

    #tableShow h3 {
        font-weight: bold;
        font-size: 15px;
    }

    .checkbox,
    .radio {
        position: relative;
        display: block;
        margin-top: 4px;
        margin-bottom: 4px;
    }
</style>
<?php
$getAllConfig = AutoBackupV2_getallconfigdata();
$bearer_code = (isset($getAllConfig["access_token"]) && !empty($getAllConfig["access_token"])) ? $getAllConfig["access_token"] : "";
$CheckConnection = check_connection_still_enable($bearer_code);
if ($CheckConnection) {
?>
    <br>
    <div class="alert alert-success alert-dismissable">
        <strong>Your are connected to Dropbox.</strong>
    </div>
    <script type="text/javascript">
        $(document).ready(function() {
            $("#getTables").click(function(e) {
                e.preventDefault();
                $("#modalforconfirm").modal("show");
                $('#loaderimage123').show();
                $('#tableShow2').html('');
                jQuery.ajax({
                    type: "POST",
                    url: "../modules/addons/AutoBackupV2/lib/Admin/db_connection.php",
                    dataType: "text",
                    data: {
                        action: 'getconnectDBTables',
                    },
                    success: function(response) {
                        //console.log(response);                             
                        $('#tableShow2').html(response);
                        $('#loaderimage123').hide();
                        $(".saveselected").click(function(ev) {
                            ev.preventDefault();
                            $("#savetableform").submit();
                        });
                    }
                });
            });
        });
    </script>
    <form method="POST" class="form-horizontal" id="contact-form">
        <table class="form" action="" border="0" cellpadding="3" cellspacing="2" width="100%" style="margin-top: 1%">
            <tbody>
                <tr>
                    <td class="fieldlabel"><b>Select Database Tables for AutoBackup</b></td>
                    <td class="fieldarea">
                        <button type="button" id="getTables" class="btn btn-primary" data-toggle="modal" data-target="#myModal">
                            <i class="fa fa-database" aria-hidden="true"></i> Select Tables for backup
                        </button>
                    </td>
                </tr>
            </tbody>
        </table>
    </form>
    <?php
    $limitnum = 10;
    if (isset($_REQUEST['pageno'])) {
        $nextPage = $_REQUEST['pageno'] + 1;
        $currentPage = $_REQUEST['pageno'];
        $previousPage = $_REQUEST['pageno'] - 1;
        if ($_REQUEST['pageno'] != 1) {
            $limitstart = ($_REQUEST['pageno'] * $limitnum) - $limitnum;
        } else {
            $limitstart = 0;
        }
    } else {
        $currentPage = 1;
        $nextPage = 2;
        $limitstart = 0;
    }
    $totalRecords = Capsule::table('ab_externaldb')->where('type', 'manual')->orderBy('id', 'desc')->count(); //get total number of logs of our module     
    $totalPage = ceil($totalRecords / $limitnum);
    ?>

    <input type="submit" name="manualBackup" class="btn btn-success manualBackup" data-codeid="" value="Take a Backup Now Manually">
    <input type="submit" name="selectedbackdata" class="btn btn-danger selectedbackdata hideonload" data-codeid="" value="Delete Selected">
    <p style="float: left;margin-top: 14px;">
        <?php echo " Total " . $totalRecords . " Records found, Page " . $currentPage . " of " . $totalPage; ?>
    </p>
    <table class="datatable table-striped" style="text-align: center" width="100%">
        <thead>
            <tr>
                <th>
                    <div class="checkbox">
                        <label>
                            <input type="checkbox" id="select_all" value="checkall" class="checkAlldiv">
                            Select All
                        </label>
                    </div>
                </th>
                <th>
                    Backup Date
                </th>
                <th>
                    Backup File Name
                </th>
                <th colspan="2">
                    Actions
                </th>
            </tr>
        </thead>

        <?php
        $backup_list = Capsule::table('ab_externaldb')->where('type', 'manual')->orderBy('id', 'desc')->offset($limitstart)->limit($limitnum)->get();
        if (!empty($backup_list)) {
            foreach ($backup_list as $backup) {
        ?>
                <tbody>
                    <td>
                        <div class="checkbox">
                            <label>
                                <input type="checkbox" class="checkbxdata" name="selectopt" value="<?php echo $backup->backup_file ?>">
                            </label>
                        </div>
                    </td>
                    <td>
                        <?php echo date("d F Y g:i A", strtotime($backup->create_on)); ?>
                    </td>
                    <td>
                        <?php echo $backup->backup_file; ?>
                    </td>
                    <td>
                        <button target='_blank' data-backupfile="<?php echo $backup->backup_file ?>" class='btn btn-success dwnDropbFile'>
                            <i style="color:#fff;" class='fab fa-dropbox' aria-hidden='true'></i>
                            Download
                        </button>
                        <a id="<?php echo $backup->id ?>" data-backuptitle="<?php echo $backup->backup_file ?>" class="deletefilebtn btn btn-danger" data-toggle="modal" data-target="#myModal">
                            <i style="color:#fff;font-size: 12px;" class='fas fa-trash-alt' aria-hidden='true'></i>
                            Delete
                        </a>
                    </td>
                </tbody>
            <?php
            }
        } else {
            ?>
            <tr>
                <td colspan="4">
                    No Records Found
                </td>
            </tr>
        <?php
        }
        ?>

    </table>
    <p align="center">
        <?php
        if (isset($previousPage) && !empty($previousPage) && $previousPage != 0) {
            // this is pagination previous page link
        ?>
            <a href="addonmodules.php?module=AutoBackupV2&action=listbilling_backup&pageno=<?php echo $previousPage; ?>">&#171; Previous Page </a>&nbsp;
        <?php
        } else {
            echo "&#171; Previous Page &nbsp";
        }
        if (isset($nextPage) && !empty($nextPage) && !($nextPage > $totalPage)) {
            // this is pagination next page links
        ?>
            <a href="addonmodules.php?module=AutoBackupV2&action=listbilling_backup&pageno=<?php echo $nextPage; ?>">Next Page &#187; </a>&nbsp;
        <?php
        } else {
            echo "Next Page &#187";
        }
        ?>
    </p>
    <script>
        $(document).ready(function() {
            $(".checkbxdata").click(function() {
                checkboxlenght = $('.checkbxdata:checked').length;
                if (checkboxlenght > 0) {
                    $(".selectedbackdata").removeClass("hideonload");
                } else {
                    $(".selectedbackdata").addClass("hideonload");
                }
            });

            $("#select_all").click(function() {
                if ($(this).prop("checked") == true) {
                    $(".checkbxdata").each(function(index) {
                        $(this).prop("checked", true)
                    });
                    $(".selectedbackdata").removeClass("hideonload");
                } else {
                    $(".checkbxdata").each(function(index) {
                        $(this).prop("checked", false)
                    });
                    $(".selectedbackdata").addClass("hideonload");
                }
            });

            $(".selectedbackdata").click(function(ev) {
                $("#modelconfirm").removeClass("hideonload");
                $("#modelconfirm").data("actionis", "deleteselected");
                $("#modeltitlecustom").text("Confirmation");
                $("#loadingimg").addClass("hideonload");
                $("#tableShow").html("<center><h3>Are you sure to delete?</h3></center>");
                $("#modalcommon").modal("show");
            });

            $(".deletefilebtn").click(function(ev) {
                $("#modelconfirm").removeClass("hideonload");
                $("#modelconfirm").data("actionis", "deleteindiviual");
                $("#modelconfirm").data("valis", $(this).data("backuptitle"));
                $("#modeltitlecustom").text("Confirmation");
                $("#loadingimg").addClass("hideonload");
                $("#tableShow").html("<center><h3>Are you sure to delete?</h3></center>");
                $("#modalcommon").modal("show");
            });

            $("#modelconfirm").click(function(e) {
                e.preventDefault();
                $("#modelconfirm").addClass("hideonload");
                actionis = $(this).data("actionis");
                if (actionis == "deleteselected") {
                    backupDeleteids = [];
                    $(".checkbxdata:checked").each(function(index) {
                        backupDeleteids.push($(this).val());
                    });
                    if (backupDeleteids != "") {
                        deletefilesfunction(backupDeleteids);
                    }
                } else {
                    backupDeleteids = [];
                    backupDeleteids.push($(this).data("valis"));
                    if (backupDeleteids != "") {
                        deletefilesfunction(backupDeleteids);
                    }
                }
            });

            $(".dwnDropbFile").click(function(ev) {
                ev.preventDefault();
                var elntId = $(this).attr("data-backupfile");
                $("#modelconfirm").data("actionis", "takemanualbackup");
                $("#modeltitlecustom").text("Downloading");
                $("#loadingimg").removeClass("hideonload");
                $("#tableShow").html("<center><h3>Please Wait, Processing...</h3></center>");
                $("#modelconfirm").addClass("hideonload");
                $("#modalcommon").modal("show");
                //alert(elmId);
                jQuery.ajax({
                    url: '../modules/addons/AutoBackupV2/lib/Admin/dropbox.php',
                    type: "POST",
                    data: {
                        action: 'downloadDropboxfile',
                        filenameid: elntId
                    },
                    success: function(response) {
                        $("#loadingimg").addClass("hideonload");
                        if (response != "") {
                            returnedData = JSON.parse(response);
                            //alert(returnedData.link);
                            if (returnedData.result == "success") {
                                Texttoprint = "Download successfully completed..";
                                $("#tableShow").html("<center><h3>" + Texttoprint + "</h3></center>");
                                setTimeout(function() {
                                    $("#modalcommon").modal('hide')
                                }, 1500);
                                window.location.href = returnedData.link;
                            } else {
                                Texttoprint = "Sorry not unable to download file..";
                                $("#tableShow").html("<center><h3>" + Texttoprint + "</h3></center>");
                                setTimeout(function() {
                                    $("#modalcommon").modal('hide')
                                }, 1500);
                            }

                        } else {
                            $('.loadingText').html('Sorry! Error in Download file');
                        }
                    },
                    error: function(response) {
                        if (response = "") {
                            alert("Sorry! Error Your Download File Not Exist!!");
                        }

                    }
                });
            });

            $(".manualBackup").click(function(e) {
                $("#modelconfirm").data("actionis", "takemanualbackup");
                $("#modeltitlecustom").text("Backup");
                $("#loadingimg").removeClass("hideonload");
                $("#tableShow").html("<center><h3>Please Wait, Processing...</h3></center>");
                $("#modelconfirm").addClass("hideonload");
                $("#modalcommon").modal("show");
                $.ajax({
                    type: "POST",
                    url: "../modules/addons/AutoBackupV2/lib/Admin/dropbox.php",
                    dataType: "text",
                    data: {
                        action: 'takemanulbackup'
                    },
                    success: function(response) {
                        $("#loadingimg").addClass("hideonload");
                        if (response == "success") {
                            Texttoprint = "Backup successfully completed..";
                            $("#tableShow").html("<center><h3>" + Texttoprint + "</h3></center>");
                            setTimeout(function() {
                                location.reload();
                            }, 1000);
                        } else {
                            $("#tableShow").html("<center><h3>" + response + "</h3></center>");
                        }
                    }
                });
            });
        });

        function deletefilesfunction(deletefilesfunction = "") {


            totalrecords = deletefilesfunction.length;
            filestxt = "File";
            if (totalrecords > 1) {
                filestxt = "Files";
            }
            counter = 0;
            nextcounter = Number(counter) + Number(1);
            txttoshow = "<p id='delsection'>Deleting <span id='nextcounterid'>" + nextcounter + "</span></p><br><span id='deletingcount'>" + counter + "</span> Deleted Successfully" + " From Total " + totalrecords + " " + filestxt;
            $("#tableShow").html("<center><h3>" + txttoshow + "</h3></center>");
            $("#loadingimg").removeClass("hideonload");
            $.each(deletefilesfunction, function(index, value) {
                $.ajax({
                    type: "POST",
                    url: "../modules/addons/AutoBackupV2/lib/Admin/dropbox.php",
                    dataType: "text",
                    data: {
                        action: 'deletefilebackup',
                        filename: value
                    },
                    success: function(response) {
                        if (response == "success") {
                            counter = Number(counter) + Number(1);
                            nextcounter = Number(counter) + Number(1);
                            $("#nextcounterid").text(nextcounter);
                            $("#deletingcount").text(counter);
                            if (counter == totalrecords) {
                                $("#delsection").addClass("hideonload");
                                $("#loadingimg").addClass("hideonload");
                                setTimeout(function() {
                                    location.reload();
                                }, 1000);
                            }
                        }
                    }
                });
            });
        }
    </script>
    <div class="modal fade" id="modalcommon" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title" id="modeltitlecustom">
                        Database Table List
                    </h4>
                </div>
                <div class="modal-body modal-body-custom">
                    <center id="loadingimg">
                        <img src="../modules/addons/AutoBackupV2/lib/Admin/assets/img/loaderimage.gif" style="width:50px;">
                    </center>
                    <div id="tableShow">
                        <!-- <center>
                   Loading Data...
                </center> -->
                    </div>
                </div>
                <div class="modal-footer tablefooter">
                    <a class="btn btn-success saveselected hideonload" id="modelconfirm" data-actionis="" data-valis="" href="#">Confirm</a>
                    <button type="button" class="btn btn-default" data-dismiss="modal">
                        Cancel
                    </button>
                </div>
            </div>
        </div>
    </div>
<?php
} else {
?>
    <center>
        <div class="alert alert-danger alert_dashb">
            <strong>Your are not connected to Dropbox.</strong>
            <p> Click <a href="addonmodules.php?module=AutoBackupV2&action=configuration" style="color:blue;">here</a> to make a connection !</p>
        </div>
    </center>
<?php
}
?>
<style>
    .input-cron {
        background: #f8f8f8;
        border: 1px solid #ccc;
    }

    .hidden1 {
        display: none;
    }

    .form_set {
        width: 100%;
        text-align: center;
        margin-bottom: 10px;
    }

    #dropbox_key,
    .form_set input {
        width: 50%;
        padding: 6px 10px;
    }

    .app_key {
        padding-top: 20px;
        line-height: 30px;
    }

    .fieldarea a {
        color: blue;
        text-decoration: underline;
    }

    h1.custom-h1 {
        margin-top: 20px;
        text-align: left;
        padding-left: 15px;
        margin-bottom: 0px;
    }

    img#loaderimage {
        display: none;
        width: 10%;
        position: absolute;
        top: 132px;
        left: 0;
        right: 0;
        opacity: 0.4;
        margin: 0 auto;
    }

    img#loaderimage123 {
        display: none;
        width: 10%;
        position: absolute;
        top: 15px;
        left: 0;
        right: 0;
        opacity: 0.4;
        margin: 0 auto;
    }

    .custom-row {
        position: relative;
    }

    .redirect_uri {
        width: 100% !important;
    }

    #response_display {
        display: none;
    }

    .makehide {
        display: none;
    }

    td.fieldarea {
        width: 54%;
    }
</style>
<div class="form_set">
    <?php
    if (isset($_POST["tables"])) {
        $tosve = json_encode($_POST["tables"]);

        Capsule::table('tbladdonmodules')
            ->where([
                ['module', '=', 'AutoBackupV2'],
                ['setting', '=', 'selectedtable'],
            ])
            ->delete();
        $db_inssert = Capsule::table('tbladdonmodules')->insert([
            'module' => 'AutoBackupV2',
            'setting' => 'selectedtable',
            'value' => $tosve,
        ]);
        if ($db_inssert) {
    ?>
            <br />
            <div style="scroll-behavior: smooth;" class="alert settalert alert-success " role="alert">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <strong>Success!</strong> Your backup tables saved successfully!
            </div>

        <?php
            // echo "Settings saved successfully";
        } else {
        ?>
            <br />
            <div class="alert settalert alert-danger" role="alert">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <strong>Error!</strong> Please minimum one table selected!
            </div>
    <?php
        }
    }
    ?>
</div>

<div class="modal fade" id="modalforconfirm" role="dialog">
    <div class="modal-dialog">
        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">
                    Database Tables List
                </h4>
            </div>
            <div class="modal-body ">
                <img id="loaderimage123" src="../modules/addons/AutoBackupV2/lib/Admin/assets/img/loaderimage.gif">
                <div id="tableShow2">
                    <!-- <center>
                 Loading Data...
              </center> -->
                </div>
            </div>
            <div class="modal-footer tablefooter">
                <a class="btn btn-success saveselected" data-codeid="" href="#">Save Selected</a>
                <button type="button" class="btn btn-default" data-dismiss="modal">
                    Cancel
                </button>
            </div>
        </div>
    </div>
</div>