<?php

use WHMCS\Database\Capsule;
use WHMCS\Module\Addon\NXTDashboard\Admin\AdminDispatcher;
use WHMCS\Module\Addon\NXTDashboard\Client\ClientDispatcher;

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}
function NXTDashboard_config()
{
    $configarray = array(
        'name' => 'NXT Reseller Dashboard',
        'description' => 'The module provide the NXT Reseller Dashboard User Management with Username/Password',
        'author' => '<a href="https://www.whmcssmarters.com/" target="_blank"><img src="../modules/addons/NXTDashboard/logo.png" style="width: 200px;height: 40px;"></a>',
        'language' => 'english',
        'version' => '1.0',
        "fields" => array(
            "licenseregto" => array(
                "FriendlyName" => "License Registered To",
                "Description" => "Not Available"
            ),
            "licenseregmail" => array(
                "FriendlyName" => "License Registered Email",
                "Description" => "Not Available"
            ),
            "licenseduedate" => array(
                "FriendlyName" => "License Due Date",
                "Description" => "Not Available"
            ),
            "licensestatus" => array(
                "FriendlyName" => "License Status",
                "Description" => "Not Available"
            ),
            "license" => array(
                "FriendlyName" => "License",
                "Type" => "text",
                "Size" => "35"
            ),
        )
    );
    $licenseinfo = NXTDashboard_doCheckLicense();
    if ($licenseinfo['status'] != 'licensekeynotfound') {
        if ($licenseinfo['status'] == 'Active') {
            if (isset($licenseinfo['localkey']) && !empty($licenseinfo['localkey'])) {
                $moduledata = Capsule::table('tbladdonmodules')
                    ->where('module', '=', 'NXTDashboard')
                    ->where('setting', '=', 'localkey')
                    ->count();
                if (isset($moduledata) && !empty($moduledata)) {
                    Capsule::table('tbladdonmodules')
                        ->where('setting', 'localkey')
                        ->where('module', 'NXTDashboard')
                        ->update(['value' => $licenseinfo['localkey']]);
                } else {
                    Capsule::table('tbladdonmodules')->insert(
                        ['setting' => 'localkey', 'value' => $licenseinfo['localkey'], 'module' => 'NXTDashboard']
                    );
                }
            }
        }
        if ($licenseinfo['registeredname']) {
            $configarray['fields']['licenseregto']['Description'] = $licenseinfo['registeredname'];
        }
        if ($licenseinfo['email']) {
            $configarray['fields']['licenseregmail']['Description'] = $licenseinfo['email'];
        }
        if ($licenseinfo['nextduedate']) {
            $configarray['fields']['licenseduedate']['Description'] = $licenseinfo['nextduedate'];
        }
        $configarray['fields']['licensestatus']['Description'] = $licenseinfo['status'];
        $configarray['fields']['license']['Value'] = $licenseinfo['licensekey'];
    }
    return $configarray;
}

function NXTDashboard_doCheckLicense()
{
    $result = Capsule::table('tbladdonmodules')->where('module', '=', 'NXTDashboard')->get();
    foreach ($result as $row) {
        $settings[$row->setting] = $row->value;
    }
    if ($settings['license']) {
        $localkey = $settings['localkey'];
        $result = NXTDashboard_checkLicense($settings['license'], $localkey);
        $result['licensekey'] = $settings['license'];
    } else {
        $result['status'] = 'licensekeynotfound';
    }
    return $result;
}


function NXTDashboard_checkLicense($licensekey, $localkey = '')
{
    $whmcsurl = "https://www.whmcssmarters.com/clients/";
    $licensing_secret_key = "NXTDSHPNL";
    $localkeydays = 14;
    $allowcheckfaildays = 5;
    $check_token = time() . md5(mt_rand(1000000000, 9999999999) . $licensekey);
    $checkdate = date("Ymdhis");
    $domain = $_SERVER['SERVER_NAME'];
    $usersip = isset($_SERVER['SERVER_ADDR']) ? $_SERVER['SERVER_ADDR'] : $_SERVER['LOCAL_ADDR'];
    $dirpath = dirname(__FILE__);
    $verifyfilepath = 'modules/servers/licensing/verify.php';
    $localkeyvalid = false;
    if ($localkey) {
        $localkey = str_replace("\n", '', $localkey); # Remove the line breaks
        $localdata = substr($localkey, 0, strlen($localkey) - 32); # Extract License Data
        $md5hash = substr($localkey, strlen($localkey) - 32); # Extract MD5 Hash
        if ($md5hash == md5($localdata . $licensing_secret_key)) {
            $localdata = strrev($localdata); # Reverse the string
            $md5hash = substr($localdata, 0, 32); # Extract MD5 Hash
            $localdata = substr($localdata, 32); # Extract License Data
            $localdata = base64_decode($localdata);
            $localkeyresults = unserialize($localdata);
            $originalcheckdate = $localkeyresults['checkdate'];
            if ($md5hash == md5($originalcheckdate . $licensing_secret_key)) {
                $localexpiry = date("Ymdhis", mktime(date("h"), date("i"), date("s"), date("m"), date("d") - $localkeydays, date("Y")));
                if ($originalcheckdate > $localexpiry) {
                    $localkeyvalid = true;
                    $results = $localkeyresults;
                    $validdomains = explode(',', $results['validdomain']);
                    if (!in_array($_SERVER['SERVER_NAME'], $validdomains)) {
                        $localkeyvalid = false;
                        $localkeyresults['status'] = "Invalid";
                        $results = array();
                    }
                    $validips = explode(',', $results['validip']);
                    if (!in_array($usersip, $validips)) {
                        $localkeyvalid = false;
                        $localkeyresults['status'] = "Invalid";
                        $results = array();
                    }
                    $validdirs = explode(',', $results['validdirectory']);
                    if (!in_array($dirpath, $validdirs)) {
                        $localkeyvalid = false;
                        $localkeyresults['status'] = "Invalid";
                        $results = array();
                    }
                }
            }
        }
    }
    if (!$localkeyvalid) {
        $responseCode = 0;
        $postfields = array(
            'licensekey' => $licensekey,
            'domain' => $domain,
            'ip' => $usersip,
            'dir' => $dirpath
        );
        if ($check_token)
            $postfields['check_token'] = $check_token;
        $query_string = '';
        foreach ($postfields as $k => $v) {
            $query_string .= $k . '=' . urlencode($v) . '&';
        }
        if (function_exists('curl_exec')) {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $whmcsurl . $verifyfilepath);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $query_string);
            curl_setopt($ch, CURLOPT_TIMEOUT, 30);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            $data = curl_exec($ch);
            $responseCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
        } else {
            $responseCodePattern = '/^HTTP\/\d+\.\d+\s+(\d+)/';
            $fp = @fsockopen($whmcsurl, 80, $errno, $errstr, 5);
            if ($fp) {
                $newlinefeed = "\r\n";
                $header = "POST " . $whmcsurl . $verifyfilepath . " HTTP/1.0" . $newlinefeed;
                $header .= "Host: " . $whmcsurl . $newlinefeed;
                $header .= "Content-type: application/x-www-form-urlencoded" . $newlinefeed;
                $header .= "Content-length: " . @strlen($query_string) . $newlinefeed;
                $header .= "Connection: close" . $newlinefeed . $newlinefeed;
                $header .= $query_string;
                $data = $line = '';
                @stream_set_timeout($fp, 20);
                @fputs($fp, $header);
                $status = @socket_get_status($fp);
                while (!@feof($fp) && $status) {
                    $line = @fgets($fp, 1024);
                    $patternMatches = array();
                    if (!$responseCode && preg_match($responseCodePattern, trim($line), $patternMatches)) {
                        $responseCode = (empty($patternMatches[1])) ? 0 : $patternMatches[1];
                    }
                    $data .= $line;
                    $status = @socket_get_status($fp);
                }
                @fclose($fp);
            }
        }
        if ($responseCode != 200) {
            $localexpiry = date("Ymdhis", mktime(date("h"), date("i"), date("s"), date("m"), date("d") - ($localkeydays + $allowcheckfaildays), date("Y")));
            if ($originalcheckdate > $localexpiry) {
                $results = $localkeyresults;
            } else {
                $results = array();
                $results['status'] = "Invalid";
                $results['description'] = "Remote Check Failed";
                return $results;
            }
        } else {
            preg_match_all('/<(.*?)>([^<]+)<\/\\1>/i', $data, $matches);
            $results = array();
            foreach ($matches[1] as $k => $v) {
                $results[$v] = $matches[2][$k];
            }
        }
        if (!is_array($results)) {
            die("Invalid License Server Response");
        }
        if ($results['md5hash']) {
            if ($results['md5hash'] != md5($licensing_secret_key . $check_token)) {
                $results['status'] = "Invalid";
                $results['description'] = "MD5 Checksum Verification Failed";
                return $results;
            }
        }
        if ($results['status'] == "Active") {
            $results['checkdate'] = $checkdate;
            $data_encoded = serialize($results);
            $data_encoded = base64_encode($data_encoded);
            $data_encoded = md5($checkdate . $licensing_secret_key) . $data_encoded;
            $data_encoded = strrev($data_encoded);
            $data_encoded = $data_encoded . md5($data_encoded . $licensing_secret_key);
            $data_encoded = wordwrap($data_encoded, 80, "\n", true);
            $results['localkey'] = $data_encoded;
        }
        $results['remotecheck'] = true;
    }
    unset($postfields, $data, $matches, $whmcsurl, $licensing_secret_key, $checkdate, $usersip, $localkeydays, $allowcheckfaildays, $md5hash);
    return $results;
}

function NXTDashboard_activate()
{
    try {
        if (!Capsule::schema()->hasTable('nxt_settings')) {
            Capsule::schema()->create(
                'nxt_settings',
                function ($table) {
                    $table->text('setting');
                    $table->text('value');
                }
            );
        }
        if (!Capsule::schema()->hasTable('nxt_paneldetails')) {
            Capsule::schema()->create(
                'nxt_paneldetails',
                function ($table) {
                    $table->increments('id');
                    $table->text('identifier');
                    $table->text('panel_link');
                    $table->text('username');
                    $table->text('password');
                    $table->text('portal_url'); 
                    $table->text('mag_portal'); 
                    $table->text('watchstrmurl'); 
                }
            );
        }
        if (!Capsule::schema()->hasTable('nxt_logs')) {
            Capsule::schema()->create(
                'nxt_logs',
                function ($table) {
                    $table->increments('id');
                    $table->text('date');
                    $table->text('action');
                    $table->longText('request');
                    $table->longText('response');
                }
            );
        }
        if (!Capsule::schema()->hasTable('nxt_cats')) {
            Capsule::schema()->create(
                'nxt_cats',
                function ($table) {
                    $table->increments('id');
                    $table->text('cat_name');
                    $table->text('date');
                    $table->text('hidden');
                    $table->text('order');
                }
            );
        }
        if (!Capsule::schema()->hasTable('nxt_cat_data')) {
            Capsule::schema()->create(
                'nxt_cat_data',
                function ($table) {
                    $table->increments('id');
                    $table->text('productid');
                    $table->longText('packageid');
                    $table->longText('categories_data');
                    $table->longText('cat_data_clientarea');
                }
            );
        }
        $configuration = array(
            'common_identifier' => 'WHMCS:',
            'custom_field_mag' => 'MAG Address',
            'custom_field_username' => 'Username',
            'custom_field_password' => 'Password',
            'checkmagdevice' => 'MAG Device',
            'mac_not_valid' => 'This MAC address is not valid!',
            'mac_change_success' => 'MAG Box network address(MAC) is changed',
            'mac_add_success' => 'Added new MAG box with address:',
            'mac_error' => 'MAC Address already exists! Please contact support!',
            'iptv_service_details' => 'IPTV Service Details',
            'devices' => 'Devices',
            'back_to_overview' => 'Back to overview',
            'product_service' => 'Product/Service',
            'username' => 'Username',
            'password' => 'Password',
            'playlist' => 'M3U Playlist',
            'mag_portal' => 'MAG Portal',
            'devices_desc' => 'You can manage your streaming devices here!',
            'add_mag_button' => 'Add new MAG device',
            'mag_desc' => 'MAG Box',
            'enigma2_devices' => 'Enigma2 Device',
            'current_mag' => 'Current MAG device:',
            'new_mag' => 'New MAG device:',
            'change_mag_button' => 'Change',
            'other_devices' => 'Other Devices',
            'autoscripts' => 'Auto-Scripts',
            'stream_output' => 'Stream output:',
            'dropdown_name' => 'Playlist/Script',
            'dropdown_action' => 'Choose Device',
            'creditapply' => 'on',
        );
        foreach ($configuration as $name => $value) {
            $configurationdata[] = array(
                'setting' => $name,
                'value' => $value
            );
        }
        Capsule::table('nxt_settings')->delete();
        Capsule::table('nxt_settings')->insert($configurationdata);
        return [
            'status' => 'success',
            'description' => 'Module Activated Successfully.',
        ];
    } catch (\Exception $e) {
        return [
            'status' => "error",
            'description' =>  $e->getMessage(),
        ];
    }
}
function NXTDashboard_deactivate()
{
    try {
        Capsule::schema()
            ->dropIfExists('nxt_settings');
        Capsule::schema()
            ->dropIfExists('nxt_paneldetails');
        Capsule::schema()
            ->dropIfExists('nxt_logs');
        Capsule::schema()
            ->dropIfExists('nxt_cats');
        Capsule::schema()
            ->dropIfExists('nxt_cat_data');
        return [
            'status' => 'success',
            'description' => 'Module Deactivated Successfully.',
        ];
    } catch (\Exception $e) {
        return [
            "status" => "error",
            "description" => $e->getMessage(),
        ];
    }
}
function NXTDashboard_output($vars)
{
    $licenseinfo = NXTDashboard_doCheckLicense();
    if ($licenseinfo['status'] != 'licensekeynotfound') {
        if ($licenseinfo['status'] == 'Active') {
            $dispatcher = new AdminDispatcher();
            $response = $dispatcher->dispatch($action, $vars);
            echo $response;
        } else {
            echo "Invalid License Key";
        }
    } else {
        echo "Invalid License Key";
    }
}
