<?php

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

use Illuminate\Database\Capsule\Manager as Capsule;

function NXT_MetaData()
{
    return array(
        'DisplayName' => 'NXT',
        'APIVersion' => '4.1.7',
        'RequiresServer' => true,
    );
}

/* function File */
include_once dirname(__FILE__) . '/lib/function.php';
require_once 'hooks.php';

function NXT_ConfigOptions()
{
    $licenseinfo = NXTXtreamCodeCheckLicenseByKey();
    if ($licenseinfo['status'] == 'Active') {
        $moduledetails = Capsule::table('tbladdonmodules')
            ->where('module', '=', 'nxtdashboard')
            ->where('setting', '=', 'version')
            ->get();
        if (empty($moduledetails)) {
            return array('serverstatus' => array(
                'FriendlyName' => 'Module Status',
                'Description' => "<span style='color:red;'>Addon Module is not Activated Please Active it from Admin Area > Setup > Addon Modules > Xtream Dashboard<span>",
                'Size' => 80
            ));
        }
        $moduleversion = $moduledetails[0]->value;
        if (basename($_SERVER['SCRIPT_NAME']) == "configaddons.php") {
            $serverdetails = Capsule::table('tbladdons')
                ->join('tblservergroupsrel', 'tbladdons.server_group_id', '=', 'tblservergroupsrel.groupid')
                ->join('tblservers', 'tblservergroupsrel.serverid', '=', 'tblservers.id')
                ->where('tbladdons.id', '=', $_REQUEST['id'])
                ->select('tblservers.*')
                ->get();
        } else {
            $serverdetails = Capsule::table('tblproducts')
                ->join('tblservergroupsrel', 'tblproducts.servergroup', '=', 'tblservergroupsrel.groupid')
                ->join('tblservers', 'tblservergroupsrel.serverid', '=', 'tblservers.id')
                ->where('tblproducts.id', '=', $_REQUEST['id'])
                ->select('tblservers.*')
                ->get();
        }
        if (isset($serverdetails) && !empty($serverdetails)) {
            $con = NXTXtreamCodeTestConnection($_REQUEST['id']);
            $result = mysqli_query($con, "SELECT * FROM groups");
            $grps = array();
            $grps[''] = 'Select Group';
            while ($membergrp = mysqli_fetch_assoc($result)) {
                $grps[$membergrp['group_id']] = NXTtransliteratestring(utf8_encode($membergrp['group_name']));
            }
            $regusers = mysqli_query($con, "SELECT * FROM members");
            $members = array();
            while ($reg_usersgrp = mysqli_fetch_assoc($regusers)) {
                $grpsreg[$reg_usersgrp['id']] = NXTtransliteratestring(utf8_encode($reg_usersgrp['username']));
            }
            NXT_WHMCSReconnect();
            $description = '<div class="col-sm-12" ><div class="col-sm-8">Xtream Codes Version v' . $moduleversion . ' </div><div class="col-sm-4" style="margin-top: -5px;margin-left: -25px;
"><div class="progress" style="margin-bottom: 0px; margin-top:5px"><div class="progress-bar progress-bar-success" role="progressbar" aria-valuenow="40" aria-valuemin="0" aria-valuemax="100" style="width: 100%">
              Up to date!
             </div></div></div></div>';
            if ($getlatestmoduleversion > $moduleversion) {
                $description = '<div class="col-sm-12" >Xtream Codes Version v' . $moduleversion . ' 
        <div class="progress" style="margin-bottom: 0px; margin-top:5px">
         <div class="progress-bar progress-bar-danger" role="progressbar" aria-valuenow="40" aria-valuemin="0" aria-valuemax="100" style="width: 100%">
              New Version v' . $getlatestmoduleversion . ' is <a style="color: #ffffff;text-decoration: underline;cursor:pointer" target="_blank" href="https://whmcssmarters.com/clients/" >available to download</a>
            </div>   
        </div>
    </div>';
            }
            return array(
                // a text field type allows for single line text input
                'Module Version' => array(
                    'Description' => $description,
                ),
                'Product' => array(
                    'Type' => 'dropdown',
                    'Options' => array(
                        'streamline' => 'Streaming Line + MAG Device',
                        'streamlineeng' => 'Streaming Line + Enigma Device',
                        'streamlineengmag' => 'Streaming Line + MAG Device + Enigma Device',
                        'streamlineonly' => 'Streaming Line',
                        'magdevice' => 'MAG Device',
                        'engdevice' => 'Enigma Device',
                        'reselleraccount' => 'Reseller Account',
                        'resellercredits' => 'Reseller Credits',
                        'superreselleraccount' => 'Super-Reseller Account',
                        'addonpackage' => 'Package',
                    ),
                    'Description' => 'What type is this product?',
                    'Size' => 80
                ),
                'Fill Credits' => array(
                    'Type' => 'text',
                    'Size' => '20',
                    'Description' => 'How many credits this product gives? ( For "Reseller Credits Products", Leave empty for other product\'s type)',
                ),
                'Max Con.' => array(
                    'Type' => 'text',
                    'Size' => '20',
                    'Default' => '1',
                    'Description' => 'Maximum connections you allow for this product.',
                ),
                'Trial Package' => array(
                    'Type' => 'radio',
                    'Options' => 'Yes,No',
                    'Default' => 'No',
                    'Description' => 'Is this trial package? (For `Yes` see the text box for entering trial period)',
                ),
                'ISP Lock' => array(
                    'Type' => 'radio',
                    'Options' => 'Yes,No',
                    'Default' => 'Yes',
                    'Description' => 'Set ISP lock for streaming lines?',
                ),
                'Restreamer?' => array(
                    'Type' => 'radio',
                    'Options' => 'Yes,No',
                    'Default' => 'No',
                    'Description' => 'Is Reastreamer?',
                ),
                'M3U link' => array(
                    'Type' => 'yesno',
                    'Description' => 'Tick to Show M3U link in clientarea?',
                ),
                'Assign The Account To A Member' => array(
                    'Type' => 'dropdown',
                    'Size' => 80,
                    'Options' => $grpsreg,
                    'Description' => 'Select the specific User in the Xtream Panel who the streamlines belong to',
                ),
                "Bouquets" => array(
                    "Name" => "Bouquets",
                    "Type" => "text",
                    "Size" => "20",
                    "Description" => '<br><a id="load-storm-tariff" onclick="tariffPlan()" href="javascript:;" class="load-configuration">Assign Bouquet to this product here</a>'
                ),
                'Watch Streams!' => array(
                    'Type' => 'yesno',
                    'Default' => 'yes',
                    'Description' => 'Tick to show Xtream Codes’s client area link for watching streams online.',
                ),
                'Select Xtream Reseller Group' => array(
                    'Type' => 'dropdown',
                    'Options' => $grps,
                    'Description' => 'Choose one',
                ),
                'Select Xtream Super-Reseller Group' => array(
                    'Type' => 'dropdown',
                    'Options' => $grps,
                    'Description' => 'Choose one',
                ),
                'Start up Credits for Resellers' => array(
                    'Type' => 'text',
                    'Size' => '20',
                    'Default' => '0',
                    'Description' => 'Enter Number of credits to the reseller/super-reseller account as soon as they get enrolled',
                ),
                'MAG Portal link' => array(
                    'Type' => 'yesno',
                    'Default' => 'yes',
                    'Description' => 'Show MAG Portal link in Client Area',
                ),
                '' => array(
                    "Description" => '<center><a id="load-storm-tariff-custom-field" href="javascript:;" onclick="customfield()" class="load-configuration-custom-field"><span style="color:red">Recommended</span> - Click Here to Create Required Custom Fields</a></center>',
                    'Size' => 80
                ),
                'Expiry date' => array(
                    'Type' => 'yesno',
                    'Default' => 'yes',
                    "Description" => "Tick to sync expiry date in Xtream Panel  ( Leave it unchecked to let our billing panel handles the billing period (Recommend))",
                    'Size' => 80
                ),
                'Trial Hours' => array(
                    'Type' => 'text',
                    'Size' => '20',
                    'Default' => '24',
                    'Description' => 'hour(s) ( Enter the number of hours for the trial period - leave it empty for 24 hours trial Period )',
                ),
                'AutoScript Section' => array(
                    'Type' => 'yesno',
                    'Description' => 'Tick to show <b><a target="_blank" href="https://drive.google.com/file/d/0Bxdm-R-xZmjYalpQY2FuME9PRXc/view?usp=drivesdk">AutoScript Section</a></b> on the Client Area. <a href="addonmodules.php?module=nxtdashboard&action=xtreamautoscript">Edit Section here</a>',
                    'Default' => 'off',
                ),
                'Other Device Section' => array(
                    'Type' => 'yesno',
                    'Description' => 'Tick to show <b><a style="text-decoration:underline" target="_blank" href="https://drive.google.com/file/d/0Bxdm-R-xZmjYX2hfa0RPNDNHaGM/view?usp=drivesdk">Other Device Section</a></b> on the Client Area.',
                    'Default' => 'on',
                ),
                'Billing Months' => array(
                    'Type' => 'text',
                    'Size' => '20',
                    'Default' => '0',
                    'Description' => 'month(s) ( Enter the number of months for the one time Payment - leave it empty for unlimited service )',
                ),
                'Packages' => array(
                    "Name" => "addonpackages",
                    "Type" => "text",
                    "Size" => "20",
                    "Description" => '<br><a id="load-package-addon" onclick="tariffPlanForPcakage()" href="javascript:;" class="load-configuration">Assign Bouquet to this product addon here </a>'
                ),
            );
        } else {
            return array('serverstatus' => array(
                'FriendlyName' => 'Server Status',
                'Description' => "<span style='color:red;'>Please select the Server Group and Click on Save Changes.<span>",
                'Size' => 80
            ));
        }
    } else {
        return array('licenseKeyStatus' => array(
            'FriendlyName' => 'License Key Status',
            'Description' => "<span style='color:red;'>Invalid or Expired license key.<span>",
            'Size' => 80
        ),);
    }
}

function NXTtransliteratestring($txt)
{
    $transliterationTable = array('á' => 'a', 'Á' => 'A', 'à' => 'a', 'À' => 'A', 'ă' => 'a', 'Ă' => 'A', 'â' => 'a', 'Â' => 'A', 'å' => 'a', 'Å' => 'A', 'ã' => 'a', 'Ã' => 'A', 'ą' => 'a', 'Ą' => 'A', 'ā' => 'a', 'Ā' => 'A', 'ä' => 'ae', 'Ä' => 'AE', 'æ' => 'ae', 'Æ' => 'AE', 'ḃ' => 'b', 'Ḃ' => 'B', 'ć' => 'c', 'Ć' => 'C', 'ĉ' => 'c', 'Ĉ' => 'C', 'č' => 'c', 'Č' => 'C', 'ċ' => 'c', 'Ċ' => 'C', 'ç' => 'c', 'Ç' => 'C', 'ď' => 'd', 'Ď' => 'D', 'ḋ' => 'd', 'Ḋ' => 'D', 'đ' => 'd', 'Đ' => 'D', 'ð' => 'dh', 'Ð' => 'Dh', 'é' => 'e', 'É' => 'E', 'è' => 'e', 'È' => 'E', 'ĕ' => 'e', 'Ĕ' => 'E', 'ê' => 'e', 'Ê' => 'E', 'ě' => 'e', 'Ě' => 'E', 'ë' => 'e', 'Ë' => 'E', 'ė' => 'e', 'Ė' => 'E', 'ę' => 'e', 'Ę' => 'E', 'ē' => 'e', 'Ē' => 'E', 'ḟ' => 'f', 'Ḟ' => 'F', 'ƒ' => 'f', 'Ƒ' => 'F', 'ğ' => 'g', 'Ğ' => 'G', 'ĝ' => 'g', 'Ĝ' => 'G', 'ġ' => 'g', 'Ġ' => 'G', 'ģ' => 'g', 'Ģ' => 'G', 'ĥ' => 'h', 'Ĥ' => 'H', 'ħ' => 'h', 'Ħ' => 'H', 'í' => 'i', 'Í' => 'I', 'ì' => 'i', 'Ì' => 'I', 'î' => 'i', 'Î' => 'I', 'ï' => 'i', 'Ï' => 'I', 'ĩ' => 'i', 'Ĩ' => 'I', 'į' => 'i', 'Į' => 'I', 'ī' => 'i', 'Ī' => 'I', 'ĵ' => 'j', 'Ĵ' => 'J', 'ķ' => 'k', 'Ķ' => 'K', 'ĺ' => 'l', 'Ĺ' => 'L', 'ľ' => 'l', 'Ľ' => 'L', 'ļ' => 'l', 'Ļ' => 'L', 'ł' => 'l', 'Ł' => 'L', 'ṁ' => 'm', 'Ṁ' => 'M', 'ń' => 'n', 'Ń' => 'N', 'ň' => 'n', 'Ň' => 'N', 'ñ' => 'n', 'Ñ' => 'N', 'ņ' => 'n', 'Ņ' => 'N', 'ó' => 'o', 'Ó' => 'O', 'ò' => 'o', 'Ò' => 'O', 'ô' => 'o', 'Ô' => 'O', 'ő' => 'o', 'Ő' => 'O', 'õ' => 'o', 'Õ' => 'O', 'ø' => 'oe', 'Ø' => 'OE', 'ō' => 'o', 'Ō' => 'O', 'ơ' => 'o', 'Ơ' => 'O', 'ö' => 'oe', 'Ö' => 'OE', 'ṗ' => 'p', 'Ṗ' => 'P', 'ŕ' => 'r', 'Ŕ' => 'R', 'ř' => 'r', 'Ř' => 'R', 'ŗ' => 'r', 'Ŗ' => 'R', 'ś' => 's', 'Ś' => 'S', 'ŝ' => 's', 'Ŝ' => 'S', 'š' => 's', 'Š' => 'S', 'ṡ' => 's', 'Ṡ' => 'S', 'ş' => 's', 'Ş' => 'S', 'ș' => 's', 'Ș' => 'S', 'ß' => 'SS', 'ť' => 't', 'Ť' => 'T', 'ṫ' => 't', 'Ṫ' => 'T', 'ţ' => 't', 'Ţ' => 'T', 'ț' => 't', 'Ț' => 'T', 'ŧ' => 't', 'Ŧ' => 'T', 'ú' => 'u', 'Ú' => 'U', 'ù' => 'u', 'Ù' => 'U', 'ŭ' => 'u', 'Ŭ' => 'U', 'û' => 'u', 'Û' => 'U', 'ů' => 'u', 'Ů' => 'U', 'ű' => 'u', 'Ű' => 'U', 'ũ' => 'u', 'Ũ' => 'U', 'ų' => 'u', 'Ų' => 'U', 'ū' => 'u', 'Ū' => 'U', 'ư' => 'u', 'Ư' => 'U', 'ü' => 'ue', 'Ü' => 'UE', 'ẃ' => 'w', 'Ẃ' => 'W', 'ẁ' => 'w', 'Ẁ' => 'W', 'ŵ' => 'w', 'Ŵ' => 'W', 'ẅ' => 'w', 'Ẅ' => 'W', 'ý' => 'y', 'Ý' => 'Y', 'ỳ' => 'y', 'Ỳ' => 'Y', 'ŷ' => 'y', 'Ŷ' => 'Y', 'ÿ' => 'y', 'Ÿ' => 'Y', 'ź' => 'z', 'Ź' => 'Z', 'ž' => 'z', 'Ž' => 'Z', 'ż' => 'z', 'Ż' => 'Z', 'þ' => 'th', 'Þ' => 'Th', 'µ' => 'u', 'а' => 'a', 'А' => 'a', 'б' => 'b', 'Б' => 'b', 'в' => 'v', 'В' => 'v', 'г' => 'g', 'Г' => 'g', 'д' => 'd', 'Д' => 'd', 'е' => 'e', 'Е' => 'E', 'ё' => 'e', 'Ё' => 'E', 'ж' => 'zh', 'Ж' => 'zh', 'з' => 'z', 'З' => 'z', 'и' => 'i', 'И' => 'i', 'й' => 'j', 'Й' => 'j', 'к' => 'k', 'К' => 'k', 'л' => 'l', 'Л' => 'l', 'м' => 'm', 'М' => 'm', 'н' => 'n', 'Н' => 'n', 'о' => 'o', 'О' => 'o', 'п' => 'p', 'П' => 'p', 'р' => 'r', 'Р' => 'r', 'с' => 's', 'С' => 's', 'т' => 't', 'Т' => 't', 'у' => 'u', 'У' => 'u', 'ф' => 'f', 'Ф' => 'f', 'х' => 'h', 'Х' => 'h', 'ц' => 'c', 'Ц' => 'c', 'ч' => 'ch', 'Ч' => 'ch', 'ш' => 'sh', 'Ш' => 'sh', 'щ' => 'sch', 'Щ' => 'sch', 'ъ' => '', 'Ъ' => '', 'ы' => 'y', 'Ы' => 'y', 'ь' => '', 'Ь' => '', 'э' => 'e', 'Э' => 'e', 'ю' => 'ju', 'Ю' => 'ju', 'я' => 'ja', 'Я' => 'ja');
    return str_replace(array_keys($transliterationTable), array_values($transliterationTable), $txt);
}

function NXTclean($string)
{
    $string = str_replace(' ', '-', $string); // Replaces all spaces with hyphens. 
    return preg_replace('/[^A-Za-z0-9@.\-]/', '', $string); // Removes special chars.
}

function cryptPassword($password, $salt = "NXTs", $rounds = 20000)
{
    if ($salt == "") {
        $salt = substr(bin2hex(openssl_random_pseudo_bytes(16)), 0, 16);
    }
    $hash = crypt($password, sprintf('$6$rounds=%d$%s$', $rounds, $salt));
    return $hash;
}

function NXTreplaceBraces($text = "")
{
    $Removeleft = str_replace("[", "", $text);
    $Removeright = str_replace("]", "", $Removeleft);
    return $Removeright;
}

function NXT_CreateAccount(array $params)
{
    $licenseinfo = NXTXtreamCodeCheckLicenseByKey();
    if ($licenseinfo['status'] != 'Active')
        return "Invalid or expired license key. - Please check Xtream Dashboard addon configuration";

    $maxconnection = $params['configoption4'];
    $checkresellercredits = $params['configoption14'];
    $is_trial = ($params['configoption5'] == 'Yes') ? '1' : '0';
    $is_isplock = ($params['configoption6'] == 'Yes') ? '1' : '0';
    $is_restreamer = ($params['configoption7'] == 'Yes') ? '1' : '0';
    $member_id = $params['configoption9'];
    $Bouquets = isset($params['customfields']['Select Bouquets']) && !empty($params['customfields']['Select Bouquets']) ? trim($params['customfields']['Select Bouquets']) : $params['configoption10'];


    $CheckBouquets = NXT_ProductAddonsPack($params, $Bouquets);
    if ($CheckBouquets != "") {
        $Bouquets = $CheckBouquets;
    }


    $syn_expiry = $params['configoption17'];

    if ($is_trial == 1) {
        $trial_period = ($params['configoption18'] != 0) ? '+' . $params['configoption18'] . ' hours' : '+24 hours';
    } else {
        $day_period = ($params['configoption18'] != 0) ? '+' . $params['configoption18'] . ' days' : '+24 days';
    }

    $billing_months = $params['configoption21'];
    $tblhostingdetails = Capsule::table('tblhosting')->where('id', '=', $params["serviceid"])->get();
    $nextduedate = $tblhostingdetails[0]->nextduedate;
    $regdate = $tblhostingdetails[0]->regdate;
    $serviceid = $tblhostingdetails[0]->id;
    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    if (!empty($params['customfields'][$returndata['custom_field_mag']])) {
        $params['customfields'][$returndata['custom_field_mag']] = strtoupper($params['customfields'][$returndata['custom_field_mag']]);
    }
    if (!empty($params['customfields'][$returndata['custom_field_eng']])) {
        $params['customfields'][$returndata['custom_field_eng']] = strtoupper($params['customfields'][$returndata['custom_field_eng']]);
    }
    if ($params['configoption2'] == 'streamline') {
        $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
        $returndata = array();

        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        if (isset($returndata['configoption_field_name']) && !empty($returndata['configoption_field_name'])) {
            if (isset($params['configoptions']) && !empty($params['configoptions'])) {
                foreach ($params['configoptions'] as $configname => $configvalue) {
                    if ($configname == $returndata['configoption_field_name']) {
                        $maxconnection += $configvalue;
                    }
                }
            }
        }

        // Collecting parameters
        $username = trim($params["username"]);
        $password = $params["password"];
        $digits = 10;
        if (empty($username)) {
            $username = NXT_generate_ran($digits, false, "d");
        }
        if (empty($password)) {
            $password = NXT_generate_ran($digits, false, "d");
        }

        // Basically vpn username is being generted by my code randomly but admin can supply username itslef  too while creating account from Admin Area 
        // if (isset($returndata['activationcode']) && $returndata['activationcode'] == 'on') {

        //     if (empty($username) || $username != $password) {
        //         if (isset($params['customfields']['Username']) && !empty($params['customfields']['Username']) && isset($params['customfields']['Password']) && !empty($params['customfields']['Password'])) {
        //             $password = $params['customfields']['Password'];
        //             $command = 'EncryptPassword';
        //             $postData = array(
        //                 'password2' => $password,
        //             );
        //             $results = localAPI($command, $postData, NXT_whmcsadmin());
        //             if ($results['result'] == 'success') {
        //                 Capsule::table('tblhosting')
        //                     ->where('id', $params["serviceid"])
        //                     ->update(['password' => $results['password'], 'username' => trim($params['customfields']['Username'])]);
        //             }
        //         } else {
        //             $digits = isset($returndata['activationdigits']) && !empty($returndata['activationdigits']) ? $returndata['activationdigits'] : '8';
        //             $password = $username = NXT_generate_ran($digits, false, "d");
        //             $command = 'EncryptPassword';
        //             $postData = array(
        //                 'password2' => $password,
        //             );
        //             $results = localAPI($command, $postData, NXT_whmcsadmin());
        //             if ($results['result'] == 'success') {
        //                 Capsule::table('tblhosting')
        //                     ->where('id', $params["serviceid"])
        //                     ->update(['password' => $results['password'], 'username' => trim($username)]);
        //             }
        //         }
        //     }
        // } else {

        //     if (isset($params['customfields']['Password']) && !empty($params['customfields']['Password'])) {

        //         $password = $staticpassword = $params['customfields']['Password'];
        //     } elseif ($password != "" && $username != "") {

        //         $password = $staticpassword = $password;
        //     } else {

        //         if ($returndata['passwordformat'] == 'onlydigits') {

        //             $passworddigits = isset($returndata['passworddigits']) && !empty($returndata['passworddigits']) ? $returndata['passworddigits'] : '10';
        //             $password = $staticpassword = NXT_generate_ran($passworddigits, false, "d");
        //         } elseif ($returndata['passwordformat'] == 'static') {
        //             if (isset($returndata['staticPassword']) && !empty($returndata['staticPassword'])) {
        //                 $password = $staticpassword = $returndata['staticPassword'];
        //             }
        //         } elseif ($returndata['passwordformat'] == 'digits_alphabet') {
        //             $passworddigits = isset($returndata['passworddigits']) && !empty($returndata['passworddigits']) ? $returndata['passworddigits'] : '10';
        //             $password = $staticpassword = NXT_generate_ran($passworddigits);
        //         }
        //     }

        //     if (isset($staticpassword) && !empty($staticpassword)) {
        //         $command = 'EncryptPassword';
        //         $postData = array(
        //             'password2' => $staticpassword,
        //         );
        //         $results = localAPI($command, $postData, NXT_whmcsadmin());
        //         if ($results['result'] == 'success') {
        //             Capsule::table('tblhosting')
        //                 ->where('id', $params["serviceid"])
        //                 ->update(['password' => $results['password']]);
        //         }
        //     }
        //     if (empty($username)) {
        //         if (isset($params['customfields']['Username']) && !empty($params['customfields']['Username'])) {
        //             $username = NXTclean($params['customfields']['Username']);
        //         } else {
        //             $usernamedigits = isset($returndata['usernamedigits']) && !empty($returndata['usernamedigits']) ? $returndata['usernamedigits'] : '10';
        //             if ($returndata['usernameformat'] == 'onlydigits') {
        //                 $username = NXT_generate_ran($usernamedigits, false, "d");
        //             } else {
        //                 $username = NXT_generate_ran($usernamedigits);
        //             }
        //         }
        //         Capsule::table('tblhosting')
        //             ->where('id', $params["serviceid"])
        //             ->update(['username' => trim($username)]);
        //     }
        // }
        $params["username"] = trim($username);
        $params["password"] = $password;
        $con = NXTXtreamCodeTestConnection($params['pid']);

        $common_identifier = $returndata['common_identifier'] . $serviceid;
        $acceptorder = mysqli_query($con, "SELECT username FROM users WHERE username='$username' AND reseller_notes='$common_identifier'");
        if (!$acceptorder) {
            $radiussqlerror = mysqli_error($con);
            NXT_WHMCSReconnect();
            return "NXT Database Query Error: " . $radiussqlerror;
        }
        if (mysqli_num_rows($acceptorder) > 0) {
            NXT_WHMCSReconnect();
            return 'Username already exists.';
        }

        // First checking if user already exist with reqeuest username  
        $result = mysqli_query($con, "SELECT username FROM users WHERE username='$username'");
        if (!$result) {
            $radiussqlerror = mysqli_error($con);
            NXT_WHMCSReconnect();
            return "NXT Database Query Error: " . $radiussqlerror;
        }
        if (mysqli_num_rows($result) > 0) {
            NXT_WHMCSReconnect();
            return "This {$username} username is already taken";
        }
        $clientemail = NXTcheckAffexists($params['clientsdetails']['userid']);
        if (!empty($clientemail)) {
            $result = mysqli_query($con, "SELECT id FROM members WHERE email='$clientemail'");
            if (!$result) {
                $radiussqlerror = mysqli_error($con);
                NXT_WHMCSReconnect();
                logModuleCall('NXT', 'Check Reseller Exists', 'Email Address : ' . $clientemail, "NXT Database Query Error: " . $radiussqlerror, '', '');
                return "NXT Database Query Error: " . $radiussqlerror;
            }
            if (mysqli_num_rows($result) > 0) {
                $resellerdata = mysqli_fetch_assoc($result);
                $member_id = $resellerdata['id'];
            }
        }
        $checkmagdevice = $params['customfields'][$returndata['checkmagdevice']];
        if (isset($checkmagdevice) && !empty($checkmagdevice)) {
            if ($checkmagdevice == 'on') {
                if (!empty($params['customfields'][$returndata['custom_field_mag']])) {
                    return NXT_AddMAG($params, $params['customfields'][$returndata['custom_field_mag']]);
                }
            }
        } else {
            $expdate = 'NULL';
            if ($is_trial == 1 && $nextduedate != '0000-00-00') {
                $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
            } else {
                if ($syn_expiry == 'on' && $nextduedate != '0000-00-00') {
                    $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
                } elseif ($is_trial == 1) {
                    $expdate = strtotime(date("Y-m-d H:i:s", strtotime($trial_period)));
                } elseif ($is_trial == 0 && $nextduedate == '0000-00-00' && $billing_months != "" && $billing_months != 0) {
                    $effectiveDate = date('Y-m-d H:i:s', strtotime("+" . $billing_months . " months", strtotime(date('Y-m-d H:i:s'))));
                    $expdate = strtotime($effectiveDate);
                }
            }


            if (GetConfigXtreamDetailsHourDiff() != "" && $expdate != "NULL") {
                $expdate = $expdate + 60 * 60 * GetConfigXtreamDetailsHourDiff();
            }

            $output = json_encode(["m3u8", "ts", "rtmp"]);
            # Inserting Now New User into 
            $query = "INSERT INTO users (member_id , username , password , admin_enabled , enabled , admin_notes ,reseller_notes , bouquet , `output`, `allowed_ips`, `allowed_ua` , max_connections , is_restreamer  , created_at , created_by  , is_mag , is_isplock,exp_date,is_trial) 
                             VALUES ('$member_id' , '$username' , '$password', 1 , 1 , '" . $returndata['common_identifier'] . $serviceid . "', '" . $returndata['common_identifier'] . $serviceid . "' , '$Bouquets' , '$output' , '[]' , '[]' , '$maxconnection' , '$is_restreamer' , " . strtotime($regdate) . ", 0 , 0 , '$is_isplock',$expdate,$is_trial)";
            $result = mysqli_query($con, $query);
            if (!$result) {
                $radiussqlerror = mysqli_error($con);
                NXT_WHMCSReconnect();
                return "NXT Database Query Error: " . $radiussqlerror;
            }
            $userid = mysqli_insert_id($con);
            //Access Output Setting in X.C
            $accessoutput = mysqli_query($con, "SELECT * FROM `access_output`");
            if (mysqli_num_rows($accessoutput) > 0) {
                while ($accessoutputdata = mysqli_fetch_assoc($accessoutput)) {
                    mysqli_query($con, "INSERT INTO user_output(user_id, access_output_id) VALUES('" . $userid . "', '" . $accessoutputdata['access_output_id'] . "')");
                }
            }
            NXT_WHMCSReconnect();
            if (!empty($params['customfields'][$returndata['custom_field_mag']])) {
                return NXT_AddMAG($params, $params['customfields'][$returndata['custom_field_mag']]);
            }
            logModuleCall(
                'NXT',
                __FUNCTION__,
                'Account Created: ' . $username,
                'success'
            );

            return "success";
        }
        return "success";
    } elseif ($params['configoption2'] == 'streamlineeng') {
        $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        if (isset($returndata['configoption_field_name']) && !empty($returndata['configoption_field_name'])) {
            if (isset($params['configoptions']) && !empty($params['configoptions'])) {
                foreach ($params['configoptions'] as $configname => $configvalue) {
                    if ($configname == $returndata['configoption_field_name']) {
                        $maxconnection += $configvalue;
                    }
                }
            }
        }
        // Collecting parameters
        $username = trim($params["username"]);
        $password = $params["password"];
        $digits = 10;
        if (empty($username)) {
            $username = NXT_generate_ran($digits, false, "d");
        }
        if (empty($password)) {
            $password = NXT_generate_ran($digits, false, "d");
        }
        // if (isset($returndata['activationcode']) && $returndata['activationcode'] == 'on') {
        //     if (empty($username) || $username != $password) {
        //         $password = $username = NXT_generate_ran(8, false, "d");
        //         $command = 'EncryptPassword';
        //         $postData = array(
        //             'password2' => $password,
        //         );
        //         $results = localAPI($command, $postData, NXT_whmcsadmin());
        //         if ($results['result'] == 'success') {
        //             Capsule::table('tblhosting')
        //                 ->where('id', $params["serviceid"])
        //                 ->update(['password' => $results['password'], 'username' => trim($username)]);
        //         }
        //     }
        // } else {
        //     if (isset($params['customfields']['Password']) && !empty($params['customfields']['Password'])) {
        //         $password = $staticpassword = $params['customfields']['Password'];
        //     } elseif ($password != "" && $username != "") {
        //         $password = $staticpassword = $password;
        //     } else {
        //         if ($returndata['passwordformat'] == 'onlydigits') {
        //             $passworddigits = isset($returndata['passworddigits']) && !empty($returndata['passworddigits']) ? $returndata['passworddigits'] : '10';
        //             $password = $staticpassword = NXT_generate_ran($passworddigits, false, "d");
        //         } elseif ($returndata['passwordformat'] == 'static') {
        //             if (isset($returndata['staticPassword']) && !empty($returndata['staticPassword'])) {
        //                 $password = $staticpassword = $returndata['staticPassword'];
        //             }
        //         }
        //     }
        //     if (isset($staticpassword) && !empty($staticpassword)) {
        //         $command = 'EncryptPassword';
        //         $postData = array(
        //             'password2' => $staticpassword,
        //         );
        //         $results = localAPI($command, $postData, NXT_whmcsadmin());
        //         if ($results['result'] == 'success') {
        //             Capsule::table('tblhosting')
        //                 ->where('id', $params["serviceid"])
        //                 ->update(['password' => $results['password']]);
        //         }
        //     }
        //     if (empty($username)) {
        //         if (isset($params['customfields']['Username']) && !empty($params['customfields']['Username'])) {
        //             $username = NXTclean($params['customfields']['Username']);
        //         } else {
        //             $usernamedigits = isset($returndata['usernamedigits']) && !empty($returndata['usernamedigits']) ? $returndata['usernamedigits'] : '10';
        //             if ($returndata['usernameformat'] == 'onlydigits') {
        //                 $username = NXT_generate_ran($usernamedigits, false, "d");
        //             } else {
        //                 $username = NXT_generate_ran($usernamedigits);
        //             }
        //         }
        //         Capsule::table('tblhosting')
        //             ->where('id', $params["serviceid"])
        //             ->update(['username' => trim($username)]);
        //     }
        // }
        $params["username"] = trim($username);
        $params["password"] = $password;
        $con = NXTXtreamCodeTestConnection($params['pid']);

        $common_identifier = $returndata['common_identifier'] . $serviceid;
        $acceptorder = mysqli_query($con, "SELECT username FROM users WHERE username='$username' AND reseller_notes='$common_identifier'");
        if (!$acceptorder) {
            $radiussqlerror = mysqli_error($con);
            NXT_WHMCSReconnect();
            return "NXT Database Query Error: " . $radiussqlerror;
        }
        if (mysqli_num_rows($acceptorder) > 0) {
            NXT_WHMCSReconnect();
            return 'Username already exists.';
        }
        // First checking if user already exist with reqeuest username  
        $result = mysqli_query($con, "SELECT username FROM users WHERE username='$username'");
        if (!$result) {
            $radiussqlerror = mysqli_error($con);
            NXT_WHMCSReconnect();
            return "NXT Database Query Error: " . $radiussqlerror;
        }
        if (mysqli_num_rows($result) > 0) {
            NXT_WHMCSReconnect();
            return "This {$username} username is already taken";
        }
        $clientemail = NXTcheckAffexists($params['clientsdetails']['userid']);
        if (!empty($clientemail)) {
            $result = mysqli_query($con, "SELECT id FROM members WHERE email='$clientemail'");
            if (!$result) {
                $radiussqlerror = mysqli_error($con);
                NXT_WHMCSReconnect();
                logModuleCall('NXT', 'Check Reseller Exists', 'Email Address : ' . $clientemail, "NXT Database Query Error: " . $radiussqlerror, '', '');
                return "NXT Database Query Error: " . $radiussqlerror;
            }
            if (mysqli_num_rows($result) > 0) {
                $resellerdata = mysqli_fetch_assoc($result);
                $member_id = $resellerdata['id'];
            }
        }
        $checkmagdevice = $params['customfields'][$returndata['checkengdevice']];
        if (isset($checkmagdevice) && !empty($checkmagdevice)) {
            if ($checkmagdevice == 'on') {
                if (!empty($params['customfields'][$returndata['custom_field_eng']])) {
                    return NXT_AddENG($params, $params['customfields'][$returndata['custom_field_eng']]);
                }
            }
        } else {
            $expdate = 'NULL';
            if ($is_trial == 1 && $nextduedate != '0000-00-00') {
                $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
            } else {
                if ($syn_expiry == 'on' && $nextduedate != '0000-00-00') {
                    $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
                } elseif ($is_trial == 1) {
                    $expdate = strtotime(date("Y-m-d H:i:s", strtotime($trial_period)));
                } elseif ($is_trial == 0 && $nextduedate == '0000-00-00' && $billing_months != "" && $billing_months != 0) {
                    $effectiveDate = date('Y-m-d H:i:s', strtotime("+" . $billing_months . " months", strtotime(date('Y-m-d H:i:s'))));
                    $expdate = strtotime($effectiveDate);
                }
            }
            if (GetConfigXtreamDetailsHourDiff() != "" && $expdate != "NULL") {
                $expdate = $expdate + 60 * 60 * GetConfigXtreamDetailsHourDiff();
            }

            $output = json_encode(["m3u8", "ts", "rtmp"]);
            # Inserting Now New User into 
            $query = "INSERT INTO users (member_id , username , password , admin_enabled , enabled ,admin_notes, reseller_notes , bouquet , `output`, `allowed_ips`, `allowed_ua` , max_connections , is_restreamer  , created_at , created_by  , is_mag , is_isplock,exp_date,is_trial) 
                             VALUES ('$member_id' , '$username' , '$password', 1 , 1 , '" . $returndata['common_identifier'] . $serviceid . "' , '" . $returndata['common_identifier'] . $serviceid . "' , '$Bouquets' , '$output' , '[]' , '[]' , '$maxconnection' , '$is_restreamer' , " . strtotime($regdate) . ", 0 , 0 , '$is_isplock',$expdate,$is_trial)";
            $result = mysqli_query($con, $query);
            if (!$result) {
                $radiussqlerror = mysqli_error($con);
                NXT_WHMCSReconnect();
                return "NXT Database Query Error: " . $radiussqlerror;
            }
            $userid = mysqli_insert_id($con);
            //Access Output Setting in X.C
            $accessoutput = mysqli_query($con, "SELECT * FROM `access_output`");
            if (mysqli_num_rows($accessoutput) > 0) {
                while ($accessoutputdata = mysqli_fetch_assoc($accessoutput)) {
                    mysqli_query($con, "INSERT INTO user_output(user_id, access_output_id) VALUES('" . $userid . "', '" . $accessoutputdata['access_output_id'] . "')");
                }
            }
            NXT_WHMCSReconnect();
            if (!empty($params['customfields'][$returndata['custom_field_eng']])) {
                return NXT_AddENG($params, $params['customfields'][$returndata['custom_field_eng']]);
            }
            logModuleCall(
                'NXT',
                __FUNCTION__,
                'Account Created: ' . $username,
                'success'
            );

            return "success";
        }
        return "success";
    } elseif ($params['configoption2'] == 'engdevice') {
        if (!empty($params['customfields'][$returndata['custom_field_eng']])) {
            return NXT_AddENG($params, $params['customfields'][$returndata['custom_field_eng']]);
        } else {
            return 'Engima MAG Address field is empty!';
        }
    } elseif ($params['configoption2'] == 'streamlineengmag') {
        return NXTxtreamaddmageng($params);
    } elseif ($params['configoption2'] == 'resellercredits') {
        NXTResellerAddCredit($params, 'simple');
    } elseif ($params['configoption2'] == 'reselleraccount') {

        // Collecting parameters
        $username = trim($params["username"]);
        $password = $params["password"];
        $digits = 10;
        if (empty($username)) {
            $username = NXT_generate_ran($digits, false, "d");
        }
        if (empty($password)) {
            $password = NXT_generate_ran($digits, false, "d");
        }

        // Basically vpn username is being generted by my code randomly but admin can supply username itslef  too while creating account from Admin Area  

        // if (isset($params['customfields']['Password']) && !empty($params['customfields']['Password'])) {
        //     $password = $staticpassword = $params['customfields']['Password'];
        // } elseif ($password != "" && $username != "") {
        //     $password = $staticpassword = $password;
        // } else {
        //     if ($returndata['passwordformat'] == 'onlydigits') {
        //         $passworddigits = isset($returndata['passworddigits']) && !empty($returndata['passworddigits']) ? $returndata['passworddigits'] : '10';
        //         $password = $staticpassword = NXT_generate_ran($passworddigits, false, "d");
        //     } elseif ($returndata['passwordformat'] == 'static') {
        //         if (isset($returndata['staticPassword']) && !empty($returndata['staticPassword'])) {
        //             $password = $staticpassword = $returndata['staticPassword'];
        //         }
        //     } elseif ($returndata['passwordformat'] == 'digits_alphabet') {
        //         $passworddigits = isset($returndata['passworddigits']) && !empty($returndata['passworddigits']) ? $returndata['passworddigits'] : '10';
        //         $password = $staticpassword = NXT_generate_ran($passworddigits);
        //     }
        // }

        // if (isset($staticpassword) && !empty($staticpassword)) {
        //     $command = 'EncryptPassword';
        //     $postData = array(
        //         'password2' => $staticpassword,
        //     );
        //     $results = localAPI($command, $postData, NXT_whmcsadmin());
        //     if ($results['result'] == 'success') {
        //         Capsule::table('tblhosting')
        //             ->where('id', $params["serviceid"])
        //             ->update(['password' => $results['password']]);
        //     }
        // }
        // if (empty($username)) {
        //     if (isset($params['customfields']['Username']) && !empty($params['customfields']['Username'])) {
        //         $username = NXTclean($params['customfields']['Username']);
        //     } else {
        //         $usernamedigits = isset($returndata['usernamedigits']) && !empty($returndata['usernamedigits']) ? $returndata['usernamedigits'] : '10';
        //         if ($returndata['usernameformat'] == 'onlydigits') {
        //             $username = NXT_generate_ran($usernamedigits, false, "d");
        //         } else {
        //             $username = NXT_generate_ran($usernamedigits);
        //         }
        //     }
        //     Capsule::table('tblhosting')
        //         ->where('id', $params["serviceid"])
        //         ->update(['username' => trim($username)]);
        // }

        $params["username"] = trim($username);
        $params["password"] = $password;
        $con = NXTXtreamCodeTestConnection($params['pid']);
        $email = $params['clientsdetails']['email'];
        # Inserting Now New User into 
        // First checking if user already exist with reqeuest username  
        $result = mysqli_query($con, "SELECT username FROM members WHERE email='$email'");
        if (!$result) {
            $radiussqlerror = mysqli_error($con);
            NXT_WHMCSReconnect();
            logModuleCall('NXT', 'Check Reseller Exists', 'Email Address : ' . $email, "NXT Database Query Error: " . $radiussqlerror, '', '');
            return "NXT Database Query Error: " . $radiussqlerror;
        }
        if (mysqli_num_rows($result) > 0) {
            NXT_WHMCSReconnect();
            logModuleCall('NXT', 'Check Reseller Exists', 'Email Address : ' . $email, "This {$email} email address is already taken", '', '');
            return "This {$email} email address is already taken";
        }
        $superrel_id = '';
        $clientemail = NXTcheckAffexists($params['clientsdetails']['userid']);
        if (!empty($clientemail)) {

            $result = mysqli_query($con, "SELECT id FROM members WHERE email='$clientemail'");
            if (!$result) {
                $radiussqlerror = mysqli_error($con);
                NXT_WHMCSReconnect();
                logModuleCall('NXT', 'Check Super Reseller Exists', 'Email Address : ' . $clientemail, "NXT Database Query Error: " . $radiussqlerror, '', '');
                return "NXT Database Query Error: " . $radiussqlerror;
            }
            if (mysqli_num_rows($result) > 0) {
                $supresellerdata = mysqli_fetch_assoc($result);
                $superrel_id = ',' . $supresellerdata['id'];
            }
        }

        $password = cryptPassword($params["password"]);
        if (isset($superrel_id) && !empty($superrel_id))
            $ownerid = ',`owner_id`';
        if (empty($params['configoption12'])) {
            return 'Please Select Xtream Reseller Group in Product/Service Module Setting!';
        }
        $reseller = "INSERT INTO `members`  (`username`, `password`,`email`,`ip`,`date_registered`,`verify_key`,`last_login`,`member_group_id`,`verified`,`credits`,`notes`,`status`,`default_lang`" . @$ownerid . ") VALUES ('$username','$password','$email',NULL,'" . strtotime(date('Y-m-d')) . "',NULL,NULL," . $params['configoption12'] . ",1,0,'" . $returndata['common_identifier'] . $params['userid'] . "', 1,'English'" . @$superrel_id . ")";
        $resellersresult = mysqli_query($con, $reseller);
        if (!$resellersresult) {
            $radiussqlerror = mysqli_error($con);
            NXT_WHMCSReconnect();
            logModuleCall('NXT', 'Error in Reseller creation', 'Email Address : ' . $email, "NXT Database Query Error: " . $radiussqlerror, '', '');
            return "NXT Database Query Error: " . $radiussqlerror;
        } else {
            NXT_WHMCSReconnect();
            $command = 'AffiliateActivate';
            $postData = array(
                'userid' => $params['clientsdetails']['userid'],
            );
            $adminUsername = NXT_whmcsadmin(); // Optional for WHMCS 7.2 and later 
            $resultaff = localAPI($command, $postData, $adminUsername);
            if ($resultaff['result'] == 'success') {
                $GetClientGroups = 'GetClientGroups';
                $clientGroups = localAPI($GetClientGroups, array(), $adminUsername);
                if ($clientGroups['result'] == 'success') {
                    foreach ($clientGroups['groups']['group'] as $group) {
                        if ($group['groupname'] == 'Reseller') {
                            Capsule::table('tblclients')
                                ->where('id', $params['clientsdetails']['userid'])
                                ->update(['groupid' => $group['id']]);
                        }
                    }
                    if (isset($checkresellercredits) && !empty($checkresellercredits)) {
                        NXTResellerAddCredit($params, 'reseller');
                    }
                } else {
                    logModuleCall('NXT', 'Error in Creating Reseller(GetClientGroups)', 'Email Address : ' . $email, $clientGroups, '', '');
                }
                logModuleCall('NXT', 'Create Reseller', 'Email Address : ' . $email, "Reseller Created Successfully", '', '');
            } else {
                logModuleCall('NXT', 'Error in Creating Reseller', 'Email Address : ' . $email, $resultaff, '', '');
            }
            return 'success';
        }
    } elseif ($params['configoption2'] == 'superreselleraccount') {
        // Collecting parameters
        $username = trim($params["username"]);
        $password = $params["password"];
        $digits = 10;
        if (empty($username)) {
            $username = NXT_generate_ran($digits, false, "d");
        }
        if (empty($password)) {
            $password = NXT_generate_ran($digits, false, "d");
        }

        // Basically vpn username is being generted by my code randomly but admin can supply username itslef  too while creating account from Admin Area  

        // if (isset($params['customfields']['Password']) && !empty($params['customfields']['Password'])) {
        //     $password = $staticpassword = $params['customfields']['Password'];
        // } elseif ($password != "" && $username != "") {
        //     $password = $staticpassword = $password;
        // } else {
        //     if ($returndata['passwordformat'] == 'onlydigits') {
        //         $passworddigits = isset($returndata['passworddigits']) && !empty($returndata['passworddigits']) ? $returndata['passworddigits'] : '10';
        //         $password = $staticpassword = NXT_generate_ran($passworddigits, false, "d");
        //     } elseif ($returndata['passwordformat'] == 'static') {
        //         if (isset($returndata['staticPassword']) && !empty($returndata['staticPassword'])) {
        //             $password = $staticpassword = $returndata['staticPassword'];
        //         }
        //     } elseif ($returndata['passwordformat'] == 'digits_alphabet') {
        //         $passworddigits = isset($returndata['passworddigits']) && !empty($returndata['passworddigits']) ? $returndata['passworddigits'] : '10';
        //         $password = $staticpassword = NXT_generate_ran($passworddigits);
        //     }
        // }

        // if (isset($staticpassword) && !empty($staticpassword)) {
        //     $command = 'EncryptPassword';
        //     $postData = array(
        //         'password2' => $staticpassword,
        //     );
        //     $results = localAPI($command, $postData, NXT_whmcsadmin());
        //     if ($results['result'] == 'success') {
        //         Capsule::table('tblhosting')
        //             ->where('id', $params["serviceid"])
        //             ->update(['password' => $results['password']]);
        //     }
        // }
        // if (empty($username)) {
        //     if (isset($params['customfields']['Username']) && !empty($params['customfields']['Username'])) {
        //         $username = NXTclean($params['customfields']['Username']);
        //     } else {
        //         $usernamedigits = isset($returndata['usernamedigits']) && !empty($returndata['usernamedigits']) ? $returndata['usernamedigits'] : '10';
        //         if ($returndata['usernameformat'] == 'onlydigits') {
        //             $username = NXT_generate_ran($usernamedigits, false, "d");
        //         } else {
        //             $username = NXT_generate_ran($usernamedigits);
        //         }
        //     }
        //     Capsule::table('tblhosting')
        //         ->where('id', $params["serviceid"])
        //         ->update(['username' => trim($username)]);
        // }

        $params["username"] = trim($username);
        $params["password"] = $password;
        $password = cryptPassword($params["password"]);
        $con = NXTXtreamCodeTestConnection($params['pid']);
        $email = $params['clientsdetails']['email'];
        # Inserting Now New User into 
        // First checking if user already exist with reqeuest username  
        $result = mysqli_query($con, "SELECT username FROM members WHERE email='$email'");
        if (!$result) {
            $radiussqlerror = mysqli_error($con);
            NXT_WHMCSReconnect();
            logModuleCall('NXT', 'Check Super-Reseller Exists', 'Email Address : ' . $email, "NXT Database Query Error: " . $radiussqlerror, '', '');
            return "NXT Database Query Error: " . $radiussqlerror;
        }
        if (mysqli_num_rows($result) > 0) {
            NXT_WHMCSReconnect();
            logModuleCall('NXT', 'Check Super-Reseller Exists', 'Email Address : ' . $email, "This {$email} email address is already taken", '', '');
            return "This {$email} email address is already taken";
        }
        /* $username = $params['clientsdetails']['firstname'] . $params['clientsdetails']['lastname']; */
        $reseller = "INSERT INTO `members`  (`username`, `password`,`email`,`ip`,`date_registered`,`verify_key`,`last_login`,`member_group_id`,`verified`,`credits`,`notes`,`status`,`default_lang`,`reseller_dns`,`owner_id`,`override_packages`) VALUES ('$username','$password','$email',NULL,'" . strtotime(date('Y-m-d')) . "',NULL,NULL," . $params['configoption13'] . ",1,0,'" . $returndata['common_identifier'] . $params['userid'] . "', 1,'English','',0,NULL)";
        $resellersresult = mysqli_query($con, $reseller);
        if (!$resellersresult) {
            $radiussqlerror = mysqli_error($con);
            NXT_WHMCSReconnect();
            logModuleCall('NXT', 'Error in Super-Reseller creation', 'Email Address : ' . $email, "NXT Database Query Error: " . $radiussqlerror, '', '');
            return "NXT Database Query Error: " . $radiussqlerror;
        } else {
            NXT_WHMCSReconnect();
            $command = 'AffiliateActivate';
            $postData = array(
                'userid' => $params['userid'],
            );
            $adminUsername = NXT_whmcsadmin(); // Optional for WHMCS 7.2 and later 
            $resultaff = localAPI($command, $postData, $adminUsername);
            if ($resultaff['result'] == 'success') {
                $GetClientGroups = 'GetClientGroups';
                $clientGroups = localAPI($GetClientGroups, array(), $adminUsername);
                if ($clientGroups['result'] == 'success') {
                    foreach ($clientGroups['groups']['group'] as $group) {
                        if ($group['groupname'] == 'Super-Reseller') {
                            Capsule::table('tblclients')
                                ->where('id', $params['userid'])
                                ->update(['groupid' => $group['id']]);
                        }
                    }
                    if (isset($checkresellercredits) && !empty($checkresellercredits)) {
                        NXTResellerAddCredit($params, 'reseller');
                    }
                } else {
                    logModuleCall('NXT', 'Error in Creating Super-Reseller(GetClientGroups)', 'Email Address : ' . $email, $clientGroups, '', '');
                }
                logModuleCall('NXT', 'Create Super-Reseller', 'Email Address : ' . $email, "Reseller Created Successfully", '', '');
            } else {
                logModuleCall('NXT', 'Error in Creating Super-Reseller', 'Email Address : ' . $email, $resultaff, '', '');
            }
            return 'success';
        }
    } elseif ($params['configoption2'] == 'streamlineonly') {
        $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        if (isset($returndata['configoption_field_name']) && !empty($returndata['configoption_field_name'])) {
            if (isset($params['configoptions']) && !empty($params['configoptions'])) {
                foreach ($params['configoptions'] as $configname => $configvalue) {
                    if ($configname == $returndata['configoption_field_name']) {
                        $maxconnection += $configvalue;
                    }
                }
            }
        }
        // Collecting parameters
        $username = trim($params["username"]);
        $password = $params["password"];
        $digits = 10;
        if (empty($username)) {
            $username = NXT_generate_ran($digits, false, "d");
        }
        if (empty($password)) {
            $password = NXT_generate_ran($digits, false, "d");
        }
        // if (isset($returndata['activationcode']) && $returndata['activationcode'] == 'on') {
        //     if (empty($username) || $username != $password) {
        //         $password = $username = NXT_generate_ran(8, false, "d");
        //         $command = 'EncryptPassword';
        //         $postData = array(
        //             'password2' => $password,
        //         );
        //         $results = localAPI($command, $postData, NXT_whmcsadmin());
        //         if ($results['result'] == 'success') {
        //             Capsule::table('tblhosting')
        //                 ->where('id', $params["serviceid"])
        //                 ->update(['password' => $results['password'], 'username' => trim($username)]);
        //         }
        //     }
        // } else {

        //     if (isset($params['customfields']['Password']) && !empty($params['customfields']['Password'])) {
        //         $password = $staticpassword = $params['customfields']['Password'];
        //     } elseif ($password != "" && $username != "") {
        //         $password = $staticpassword = $password;
        //     } else {
        //         if ($returndata['passwordformat'] == 'onlydigits') {
        //             $passworddigits = isset($returndata['passworddigits']) && !empty($returndata['passworddigits']) ? $returndata['passworddigits'] : '10';
        //             $password = $staticpassword = NXT_generate_ran($passworddigits, false, "d");
        //         } elseif ($returndata['passwordformat'] == 'static') {
        //             if (isset($returndata['staticPassword']) && !empty($returndata['staticPassword'])) {
        //                 $password = $staticpassword = $returndata['staticPassword'];
        //             }
        //         }
        //     }
        //     if (isset($staticpassword) && !empty($staticpassword)) {
        //         $command = 'EncryptPassword';
        //         $postData = array(
        //             'password2' => $staticpassword,
        //         );
        //         $results = localAPI($command, $postData, NXT_whmcsadmin());
        //         if ($results['result'] == 'success') {
        //             Capsule::table('tblhosting')
        //                 ->where('id', $params["serviceid"])
        //                 ->update(['password' => $results['password']]);
        //         }
        //     }
        //     if (empty($username)) {
        //         if (isset($params['customfields']['Username']) && !empty($params['customfields']['Username'])) {
        //             $username = NXTclean($params['customfields']['Username']);
        //         } else {
        //             $usernamedigits = isset($returndata['usernamedigits']) && !empty($returndata['usernamedigits']) ? $returndata['usernamedigits'] : '10';
        //             if ($returndata['usernameformat'] == 'onlydigits') {
        //                 $username = trim(NXT_generate_ran($usernamedigits, false, "d"));
        //             } else {
        //                 $username = trim(NXT_generate_ran($usernamedigits));
        //             }
        //         }
        //         Capsule::table('tblhosting')
        //             ->where('id', $params["serviceid"])
        //             ->update(['username' => $username]);
        //     }
        // }
        $params["username"] = trim($username);
        $params["password"] = $password;
        $con = NXTXtreamCodeTestConnection($params['pid']);
        $common_identifier = $returndata['common_identifier'] . $serviceid;
        $acceptorder = mysqli_query($con, "SELECT username FROM users WHERE username='$username' AND reseller_notes='$common_identifier'");
        if (!$acceptorder) {
            $radiussqlerror = mysqli_error($con);
            NXT_WHMCSReconnect();
            return "NXT Database Query Error: " . $radiussqlerror;
        }
        if (mysqli_num_rows($acceptorder) > 0) {
            NXT_WHMCSReconnect();
            return 'Username already exists.';
        }
        // First checking if user already exist with reqeuest username  
        $result = mysqli_query($con, "SELECT username FROM users WHERE username='$username'");
        if (!$result) {
            $radiussqlerror = mysqli_error($con);
            NXT_WHMCSReconnect();
            return "NXT Database Query Error: " . $radiussqlerror;
        }
        if (mysqli_num_rows($result) > 0) {
            NXT_WHMCSReconnect();
            return "This {$username} username is already taken";
        }
        $clientemail = NXTcheckAffexists($params['clientsdetails']['userid']);
        if (!empty($clientemail)) {
            $result = mysqli_query($con, "SELECT id FROM members WHERE email='$clientemail'");
            if (!$result) {
                $radiussqlerror = mysqli_error($con);
                NXT_WHMCSReconnect();
                logModuleCall('NXT', 'Check Reseller Exists', 'Email Address : ' . $clientemail, "NXT Database Query Error: " . $radiussqlerror, '', '');
                return "NXT Database Query Error: " . $radiussqlerror;
            }
            if (mysqli_num_rows($result) > 0) {
                $resellerdata = mysqli_fetch_assoc($result);
                $member_id = $resellerdata['id'];
            }
        }
        $expdate = 'NULL';
        if ($is_trial == 1 && $nextduedate != '0000-00-00') {
            $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
        } else {
            if ($syn_expiry == 'on' && $nextduedate != '0000-00-00') {
                $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
                if ($is_trial == 0) {
                    $expdate = strtotime(date("Y-m-d H:i:s", strtotime($day_period)));
                }
            } elseif ($is_trial == 1) {
                $expdate = strtotime(date("Y-m-d H:i:s", strtotime($trial_period)));
            } elseif ($is_trial == 0 && $nextduedate == '0000-00-00' && $billing_months != "" && $billing_months != 0) {
                $effectiveDate = date('Y-m-d H:i:s', strtotime("+" . $billing_months . " months", strtotime(date('Y-m-d H:i:s'))));
                $expdate = strtotime($effectiveDate);
            } elseif ($is_trial == 0 && $nextduedate != '0000-00-00') {
                $expdate = strtotime(date("Y-m-d H:i:s", strtotime($day_period)));
            }
        }

        if (GetConfigXtreamDetailsHourDiff() != "" && $expdate != "NULL") {
            $expdate = $expdate + 60 * 60 * GetConfigXtreamDetailsHourDiff();
        }

        $output = json_encode(["m3u8", "ts", "rtmp"]);
        # Inserting Now New User into 
        if ($is_trial == 0 && $params['configoption18'] > 0 && !empty($params['configoption18'])) {
            Capsule::table('tblhosting')->where('id', $serviceid)->update(['nextduedate' => date("Y-m-d", $expdate), 'nextinvoicedate' => date("Y-m-d", $expdate),]);
        }


        $query = "INSERT INTO users (member_id , username , password , admin_enabled , enabled ,admin_notes, reseller_notes , bouquet , `output`, `allowed_ips`, `allowed_ua` , max_connections , is_restreamer  , created_at , created_by  , is_mag , is_isplock,exp_date,is_trial) 
                    VALUES ('$member_id' , '$username' , '$password', 1 , 1, '" . $returndata['common_identifier'] . $serviceid . "', '" . $returndata['common_identifier'] . $serviceid . "' , '$Bouquets' , '$output' , '[]' , '[]' , '$maxconnection' , '$is_restreamer' , " . strtotime($regdate) . ", 0 , 0 , '$is_isplock',$expdate,$is_trial)";
        //  echo $query;
        //  exit;

        $result = mysqli_query($con, $query);
        if (!$result) {
            $radiussqlerror = mysqli_error($con);
            NXT_WHMCSReconnect();
            return "NXT Database Query Error: " . $radiussqlerror;
        }
        NXT_WHMCSReconnect();
        logModuleCall(
            'NXT',
            __FUNCTION__,
            'Account Created: ' . $username,
            'success'
        );
        return "success";
    } elseif ($params['configoption2'] == 'magdevice') {
        $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        if (!empty($params['customfields'][$returndata['custom_field_mag']])) {
            return NXT_AddMAG($params, $params['customfields'][$returndata['custom_field_mag']]);
        } else {
            return 'MAG Address field is empty!';
        }
    } elseif ($params['configoption2'] == "addonpackage") {
        $hostingdata = Capsule::table('tblhosting')->where('id', '=', $params["serviceid"])->get();
        $username = $hostingdata[0]->username;
        $reseller_notes = $returndata['common_identifier'] . $params["serviceid"];
        $con = NXTXtreamCodeTestConnection($params['pid']);
        // First checking if user already exist with reqeuest username  
        $result = mysqli_query($con, "SELECT * FROM users WHERE username='$username' AND reseller_notes='$reseller_notes'");
        if (!$result) {
            $radiussqlerror = mysqli_error($con);
            NXT_WHMCSReconnect();
            return "NXT Database Query Error: " . $radiussqlerror;
        }
        $packagevalue = $params['Packages'];
        while ($row = mysqli_fetch_array($result, MYSQLI_ASSOC)) {
            $fareb = $row['bouquet'];
        }
        $Bouquets = "[" . NXTreplaceBraces($packagevalue) . "," . NXTreplaceBraces($fareb) . "]";
        $result = mysqli_query($con, "UPDATE users SET bouquet='$Bouquets' WHERE reseller_notes='$reseller_notes' AND username='$username'");
        if (!$result) {
            NXT_WHMCSReconnect();
            return "NXT Database Query Error: " . mysql_error();
        }
    }
    $trimusername = Capsule::table('tblhosting')
        ->where('id', $params["serviceid"])
        ->select('username')
        ->get();
    $username = trim($trimusername[0]->username);
    Capsule::table('tblhosting')
        ->where('id', $params["serviceid"])
        ->update(['username' => $username]);
    return 'success';
}

function NXTxtreamaddmageng(array $params)
{
    $maxconnection = $params['configoption4'];
    $is_trial = ($params['configoption5'] == 'Yes') ? '1' : '0';
    $is_isplock = ($params['configoption6'] == 'Yes') ? '1' : '0';
    $is_restreamer = ($params['configoption7'] == 'Yes') ? '1' : '0';
    $member_id = $params['configoption9'];
    $Bouquets = isset($params['customfields']['Select Bouquets']) && !empty($params['customfields']['Select Bouquets']) ? trim($params['customfields']['Select Bouquets']) : $params['configoption10'];
    $CheckBouquets = NXT_ProductAddonsPack($params, $Bouquets);
    if ($CheckBouquets != "") {
        $Bouquets = $CheckBouquets;
    }

    $syn_expiry = $params['configoption17'];
    $trial_period = ($params['configoption18'] != 0) ? '+' . $params['configoption18'] . ' hours' : '+24 hours';
    $billing_months = $params['configoption21'];
    $tblhostingdetails = Capsule::table('tblhosting')->where('id', '=', $params["serviceid"])->get();
    $nextduedate = $tblhostingdetails[0]->nextduedate;
    $regdate = $tblhostingdetails[0]->regdate;
    $serviceid = $tblhostingdetails[0]->id;
    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    if (isset($returndata['configoption_field_name']) && !empty($returndata['configoption_field_name'])) {
        if (isset($params['configoptions']) && !empty($params['configoptions'])) {
            foreach ($params['configoptions'] as $configname => $configvalue) {
                if ($configname == $returndata['configoption_field_name']) {
                    $maxconnection += $configvalue;
                }
            }
        }
    }
    // Collecting parameters
    $username = trim($params["username"]);
    $password = $params["password"];
    $digits = 10;
    if (empty($username)) {
        $username = NXT_generate_ran($digits, false, "d");
    }
    if (empty($password)) {
        $password = NXT_generate_ran($digits, false, "d");
    }
    // Basically vpn username is being generted by my code randomly but admin can supply username itslef  too while creating account from Admin Area 
    // if (isset($returndata['activationcode']) && $returndata['activationcode'] == 'on') {
    //     if (empty($username) || $username != $password) {
    //         if (isset($params['customfields']['Username']) && !empty($params['customfields']['Username']) && isset($params['customfields']['Password']) && !empty($params['customfields']['Password'])) {
    //             $password = $params['customfields']['Password'];
    //             $command = 'EncryptPassword';
    //             $postData = array(
    //                 'password2' => $password,
    //             );
    //             $results = localAPI($command, $postData, NXT_whmcsadmin());
    //             if ($results['result'] == 'success') {
    //                 Capsule::table('tblhosting')
    //                     ->where('id', $params["serviceid"])
    //                     ->update(['password' => $results['password'], 'username' => $params['customfields']['Username']]);
    //             }
    //         } else {
    //             $digits = isset($returndata['activationdigits']) && !empty($returndata['activationdigits']) ? $returndata['activationdigits'] : '8';
    //             $password = $username = NXT_generate_ran($digits, false, "d");
    //             $command = 'EncryptPassword';
    //             $postData = array(
    //                 'password2' => $password,
    //             );
    //             $results = localAPI($command, $postData, NXT_whmcsadmin());
    //             if ($results['result'] == 'success') {
    //                 Capsule::table('tblhosting')
    //                     ->where('id', $params["serviceid"])
    //                     ->update(['password' => $results['password'], 'username' => $username]);
    //             }
    //         }
    //     }
    // } else {
    //     if (isset($params['customfields']['Password']) && !empty($params['customfields']['Password'])) {
    //         $password = $staticpassword = $params['customfields']['Password'];
    //     } elseif ($password != "" && $username != "") {
    //         $password = $staticpassword = $password;
    //     } else {
    //         if ($returndata['passwordformat'] == 'onlydigits') {
    //             $passworddigits = isset($returndata['passworddigits']) && !empty($returndata['passworddigits']) ? $returndata['passworddigits'] : '10';
    //             $password = $staticpassword = NXT_generate_ran($passworddigits, false, "d");
    //         } elseif ($returndata['passwordformat'] == 'static') {
    //             if (isset($returndata['staticPassword']) && !empty($returndata['staticPassword'])) {
    //                 $password = $staticpassword = $returndata['staticPassword'];
    //             }
    //         } elseif ($returndata['passwordformat'] == 'digits_alphabet') {
    //             $passworddigits = isset($returndata['passworddigits']) && !empty($returndata['passworddigits']) ? $returndata['passworddigits'] : '10';
    //             $password = $staticpassword = NXT_generate_ran($passworddigits);
    //         }
    //     }
    //     if (isset($staticpassword) && !empty($staticpassword)) {
    //         $command = 'EncryptPassword';
    //         $postData = array(
    //             'password2' => $staticpassword,
    //         );
    //         $results = localAPI($command, $postData, NXT_whmcsadmin());
    //         if ($results['result'] == 'success') {
    //             Capsule::table('tblhosting')
    //                 ->where('id', $params["serviceid"])
    //                 ->update(['password' => $results['password']]);
    //         }
    //     }
    //     if (empty($username)) {
    //         if (isset($params['customfields']['Username']) && !empty($params['customfields']['Username'])) {
    //             $username = NXTclean($params['customfields']['Username']);
    //         } else {
    //             $usernamedigits = isset($returndata['usernamedigits']) && !empty($returndata['usernamedigits']) ? $returndata['usernamedigits'] : '10';
    //             if ($returndata['usernameformat'] == 'onlydigits') {
    //                 $username = NXT_generate_ran($usernamedigits, false, "d");
    //             } else {
    //                 $username = NXT_generate_ran($usernamedigits);
    //             }
    //         }
    //         Capsule::table('tblhosting')
    //             ->where('id', $params["serviceid"])
    //             ->update(['username' => $username]);
    //     }
    // }
    $params["username"] = $username;
    $params["password"] = $password;
    $con = NXTXtreamCodeTestConnection($params['pid']);
    $common_identifier = $returndata['common_identifier'] . $serviceid;
    $acceptorder = mysqli_query($con, "SELECT username FROM users WHERE username='$username' AND reseller_notes='$common_identifier'");
    if (!$acceptorder) {
        $radiussqlerror = mysqli_error($con);
        NXT_WHMCSReconnect();
        return "NXT Database Query Error: " . $radiussqlerror;
    }
    if (mysqli_num_rows($acceptorder) > 0) {
        NXT_WHMCSReconnect();
        return 'success';
    }
    // First checking if user already exist with reqeuest username  
    $result = mysqli_query($con, "SELECT username FROM users WHERE username='$username'");
    if (!$result) {
        $radiussqlerror = mysqli_error($con);
        NXT_WHMCSReconnect();
        return "NXT Database Query Error: " . $radiussqlerror;
    }
    if (mysqli_num_rows($result) > 0) {
        NXT_WHMCSReconnect();
        return "This {$username} username is already taken";
    }
    $clientemail = NXTcheckAffexists($params['clientsdetails']['userid']);
    if (!empty($clientemail)) {
        $result = mysqli_query($con, "SELECT id FROM members WHERE email='$clientemail'");
        if (!$result) {
            $radiussqlerror = mysqli_error($con);
            NXT_WHMCSReconnect();
            logModuleCall('NXT', 'Check Reseller Exists', 'Email Address : ' . $clientemail, "NXT Database Query Error: " . $radiussqlerror, '', '');
            return "NXT Database Query Error: " . $radiussqlerror;
        }
        if (mysqli_num_rows($result) > 0) {
            $resellerdata = mysqli_fetch_assoc($result);
            $member_id = $resellerdata['id'];
        }
    }
    $checkmagdevice = $params['customfields'][$returndata['checkengdevice']];
    if (isset($checkmagdevice) && !empty($checkmagdevice)) {
        if ($checkmagdevice == 'on') {
            if (!empty($params['customfields'][$returndata['custom_field_eng']])) {
                return NXT_AddENG($params, $params['customfields'][$returndata['custom_field_eng']]);
            }
        }
    } else {
        $expdate = 'NULL';
        if ($is_trial == 1 && $nextduedate != '0000-00-00') {
            $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
        } else {
            if ($syn_expiry == 'on' && $nextduedate != '0000-00-00') {
                $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
            } elseif ($is_trial == 1) {
                $expdate = strtotime(date("Y-m-d H:i:s", strtotime($trial_period)));
            } elseif ($is_trial == 0 && $nextduedate == '0000-00-00' && $billing_months != "" && $billing_months != 0) {
                $effectiveDate = date('Y-m-d H:i:s', strtotime("+" . $billing_months . " months", strtotime(date('Y-m-d H:i:s'))));
                $expdate = strtotime($effectiveDate);
            }
        }
        if (GetConfigXtreamDetailsHourDiff() != "" && $expdate != "NULL") {
            $expdate = $expdate + 60 * 60 * GetConfigXtreamDetailsHourDiff();
        }
        $output = json_encode(["m3u8", "ts", "rtmp"]);
        # Inserting Now New User into 
        $query = "INSERT INTO users (member_id , username , password , admin_enabled , enabled ,admin_notes, reseller_notes , bouquet , `output`, `allowed_ips`, `allowed_ua` , max_connections , is_restreamer  , created_at , created_by  , is_mag , is_isplock,exp_date,is_trial) 
                    VALUES ('$member_id' , '$username' , '$password', 1 , 1 , '" . $returndata['common_identifier'] . $serviceid . "' , '" . $returndata['common_identifier'] . $serviceid . "' , '$Bouquets' , '$output' , '[]' , '[]' , '$maxconnection' , '$is_restreamer' , " . strtotime($regdate) . ", 0 , 0 , '$is_isplock',$expdate,$is_trial)";
        $result = mysqli_query($con, $query);
        if (!$result) {
            $radiussqlerror = mysqli_error($con);
            NXT_WHMCSReconnect();
            return "NXT Database Query Error: " . $radiussqlerror;
        }
        // $userid = mysqli_insert_id($con);
        // //Access Output Setting in X.C
        // $accessoutput = mysqli_query($con, "SELECT * FROM `access_output`");
        // if (mysqli_num_rows($accessoutput) > 0) {
        //     while ($accessoutputdata = mysqli_fetch_assoc($accessoutput)) {
        //         mysqli_query($con, "INSERT INTO user_output(user_id, access_output_id) VALUES('" . $userid . "', '" . $accessoutputdata['access_output_id'] . "')");
        //     }
        // }
        NXT_WHMCSReconnect();
        if (!empty($params['customfields'][$returndata['custom_field_eng']])) {
            NXT_AddENG($params, $params['customfields'][$returndata['custom_field_eng']]);
        }
        if (!empty($params['customfields'][$returndata['custom_field_mag']])) {
            NXT_AddMAG($params, $params['customfields'][$returndata['custom_field_mag']]);
        }
        logModuleCall(
            'NXT',
            __FUNCTION__,
            'Account Created: ' . $username,
            'success'
        );

        return "success";
    }
    return "success";
}

function NXT_SuspendAccount(array $params)
{

    try {
        $con = NXTXtreamCodeTestConnection($params['pid']);
        // First checking if user already exist with reqeuest username  
        $serviceid = $params["serviceid"];
        $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        $reseller_notes = $returndata['common_identifier'] . $serviceid;
        if ($params['configoption2'] == 'streamline') {
            $username = $params["username"];
            $checkmagdevice = $params['customfields'][$returndata['checkmagdevice']];
            if (isset($checkmagdevice) && !empty($checkmagdevice)) {
                if ($checkmagdevice == 'on') {
                    if (!empty($params['customfields'][$returndata['custom_field_mag']])) {
                        $con = NXTXtreamCodeTestConnection($params['pid']);
                        $resellerdetails = mysqli_query($con, "SELECT * FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1'");
                        if (mysqli_num_rows($resellerdetails) == 0) {
                            NXT_WHMCSReconnect();
                            return "MAG Address Not Found in X.C Panel!!";
                        }
                        $result = mysqli_query($con, "UPDATE users SET enabled='0' WHERE reseller_notes='$reseller_notes' AND is_mag='1' AND enabled='1'");
                        if (!$result) {
                            NXT_WHMCSReconnect();
                            return "NXT Database Query Error: " . mysql_error();
                        }
                        NXT_WHMCSReconnect();
                        logModuleCall(
                            'NXT',
                            __FUNCTION__,
                            'Account Suspended: ' . $username,
                            'success'
                        );
                        return 'success';
                    }
                }
            }
            // First checking if user already exist with reqeuest username   
            $result = mysqli_query($con, "SELECT * FROM users WHERE username='$username' AND reseller_notes='$reseller_notes'");
            if (mysqli_num_rows($result) == 0) {
                NXT_WHMCSReconnect();
                logModuleCall(
                    'NXT',
                    __FUNCTION__,
                    'Account Suspended: ' . $username,
                    'User Not Found or Already Suspended!'
                );
                return "User Not Found!!";
            }
            if (mysqli_num_rows($result) != 0) {
                if (isset($params['customfields'][$returndata['custom_field_mag']]) && !empty($params['customfields'][$returndata['custom_field_mag']])) {
                    $result = mysqli_query($con, "UPDATE users SET enabled='0' WHERE reseller_notes='$reseller_notes' AND is_mag='1' AND enabled='1'");
                    if (!$result) {
                        NXT_WHMCSReconnect();
                        return "NXT Database Query Error: " . mysql_error();
                    }
                }
                $result = mysqli_query($con, "UPDATE users SET enabled='0' WHERE username='$username' AND enabled='1' AND reseller_notes ='$reseller_notes'");
                if (!$result) {
                    NXT_WHMCSReconnect();
                    return "NXT Database Query Error: " . mysql_error();
                }
            }

            NXT_WHMCSReconnect();
            logModuleCall(
                'NXT',
                __FUNCTION__,
                'Account Suspended: ' . $username,
                'success'
            );
            return 'success';
        } elseif ($params['configoption2'] == 'streamlineonly') {
            $username = $params["username"];
            $result = mysqli_query($con, "SELECT username FROM users WHERE username='$username' AND enabled='1' AND reseller_notes ='$reseller_notes'");
            if (mysqli_num_rows($result) == 0) {
                NXT_WHMCSReconnect();
                logModuleCall(
                    'NXT',
                    __FUNCTION__,
                    'Account Suspended: ' . $username,
                    'User Not Found or Already Suspended!'
                );
                return "User Not Found!!";
            }
            if (mysqli_num_rows($result) != 0) {
                $query = "UPDATE users SET enabled='0' WHERE username='$username' AND enabled='1' AND reseller_notes ='$reseller_notes' ";
                $result = mysqli_query($con, $query);
                if (!$result) {
                    NXT_WHMCSReconnect();
                    return "NXT Database Query Error: " . mysql_error();
                }
            }
            NXT_WHMCSReconnect();
            logModuleCall(
                'NXT',
                __FUNCTION__,
                'Account Suspended: ' . $username,
                'success'
            );
            return "success";
        } elseif ($params['configoption2'] == 'resellercredits') {
            return 'success';
        } elseif ($params['configoption2'] == 'reselleraccount') {
            return 'success';
        } elseif ($params['configoption2'] == 'superreselleraccount') {
            return 'success';
        } elseif ($params['configoption2'] == 'magdevice') {
            $result = mysqli_query($con, "SELECT id FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1' AND enabled='1'");
            if (mysqli_num_rows($result) == 0) {
                NXT_WHMCSReconnect();
                logModuleCall(
                    'NXT',
                    __FUNCTION__,
                    'Account Suspended: ' . $username,
                    'User Not Found or Already Suspended!'
                );
                return "User Not Found!!";
            }
            if (mysqli_num_rows($result) != 0) {
                $query = "UPDATE users SET enabled='0' WHERE reseller_notes='$reseller_notes' AND is_mag='1' AND enabled='1'";
                $result = mysqli_query($con, $query);
                if (!$result) {
                    NXT_WHMCSReconnect();
                    return "NXT Database Query Error: " . mysql_error();
                }
            }
            NXT_WHMCSReconnect();
            logModuleCall(
                'NXT',
                __FUNCTION__,
                'Account Suspended: ' . $username,
                'success'
            );
            return "success";
        } elseif ($params['configoption2'] == 'engdevice') {
            $result = mysqli_query($con, "SELECT id FROM users WHERE reseller_notes='$reseller_notes' AND is_e2='1' AND enabled='1'");
            if (mysqli_num_rows($result) == 0) {
                NXT_WHMCSReconnect();
                logModuleCall(
                    'NXT',
                    __FUNCTION__,
                    'Account Suspended: ' . $reseller_notes,
                    'User Not Found or Already Suspended!'
                );
                return "User Not Found!!";
            }
            if (mysqli_num_rows($result) != 0) {
                $query = "UPDATE users SET enabled='0' WHERE reseller_notes='$reseller_notes' AND is_e2='1' AND enabled='1'";
                $result = mysqli_query($con, $query);
                if (!$result) {
                    NXT_WHMCSReconnect();
                    return "NXT Database Query Error: " . mysql_error();
                }
            }
            NXT_WHMCSReconnect();
            logModuleCall(
                'NXT',
                __FUNCTION__,
                'Account Suspended: ' . $username,
                'success'
            );
            return "success";
        } elseif ($params['configoption2'] == 'streamlineeng') {
            $username = $params["username"];
            $checkmagdevice = $params['customfields'][$returndata['checkengdevice']];
            if (isset($checkmagdevice) && !empty($checkmagdevice)) {
                if ($checkmagdevice == 'on') {
                    if (!empty($params['customfields'][$returndata['custom_field_eng']])) {
                        $con = NXTXtreamCodeTestConnection($params['pid']);
                        $resellerdetails = mysqli_query($con, "SELECT * FROM users WHERE reseller_notes='$reseller_notes' AND is_e2='1'");
                        if (mysqli_num_rows($resellerdetails) == 0) {
                            NXT_WHMCSReconnect();
                            logModuleCall(
                                'NXT',
                                __FUNCTION__,
                                'Account Suspended: ' . $reseller_notes,
                                'MAG Address Not Found in X.C Panel or Already Suspended!'
                            );
                            return "MAG Address Not Found in X.C Panel!!";
                        }
                        $result = mysqli_query($con, "UPDATE users SET enabled='0' WHERE reseller_notes='$reseller_notes' AND is_e2='1' AND enabled='1'");
                        if (!$result) {
                            NXT_WHMCSReconnect();
                            return "NXT Database Query Error: " . mysql_error();
                        }
                        NXT_WHMCSReconnect();
                        logModuleCall(
                            'NXT',
                            __FUNCTION__,
                            'Account Suspended: ' . $params['customfields'][$returndata['custom_field_eng']],
                            'success'
                        );
                        return 'success';
                    }
                }
            }
            // First checking if user already exist with reqeuest username  
            $result = mysqli_query($con, "SELECT * FROM users WHERE username='$username' AND reseller_notes='$reseller_notes'");
            if (mysqli_num_rows($result) == 0) {
                NXT_WHMCSReconnect();
                logModuleCall(
                    'NXT',
                    __FUNCTION__,
                    'Account Suspended: ' . $reseller_notes,
                    'User Not Found or Already Suspended!'
                );
                return "User Not Found!!";
            }
            if (mysqli_num_rows($result) != 0) {
                if (isset($params['customfields'][$returndata['custom_field_eng']]) && !empty($params['customfields'][$returndata['custom_field_eng']])) {
                    $result = mysqli_query($con, "UPDATE users SET enabled='0' WHERE reseller_notes='$reseller_notes' AND is_e2='1' AND enabled='1'");
                    if (!$result) {
                        NXT_WHMCSReconnect();
                        return "NXT Database Query Error: " . mysql_error();
                    }
                }
                $result = mysqli_query($con, "UPDATE users SET enabled='0' WHERE username='$username' AND enabled='1' AND reseller_notes ='$reseller_notes'");
                if (!$result) {
                    NXT_WHMCSReconnect();
                    return "NXT Database Query Error: " . mysql_error();
                }
            }

            NXT_WHMCSReconnect();
            logModuleCall(
                'NXT',
                __FUNCTION__,
                'Account Suspended: ' . $username,
                'success'
            );
            return 'success';
        } elseif ($params['configoption2'] == 'streamlineengmag') {
            $username = $params["username"];
            $result = mysqli_query($con, "SELECT username FROM users WHERE username='$username' AND enabled='1' AND reseller_notes ='$reseller_notes'");
            if (mysqli_num_rows($result) != 0) {
                $query = "UPDATE users SET enabled='0' WHERE username='$username' AND enabled='1' AND reseller_notes ='$reseller_notes'";
                $result = mysqli_query($con, $query);
                if (!$result) {
                    NXT_WHMCSReconnect();
                    return "NXT Database Query Error: " . mysql_error();
                }
            }
            $magcheck = mysqli_query($con, "SELECT id FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1' AND enabled='1'");
            if (mysqli_num_rows($magcheck) != 0) {
                $query = "UPDATE users SET enabled='0' WHERE reseller_notes='$reseller_notes' AND is_mag='1' AND enabled='1'";
                $result = mysqli_query($con, $query);
                if (!$result) {
                    NXT_WHMCSReconnect();
                    return "NXT Database Query Error: " . mysql_error();
                }
            }
            $engdevice = mysqli_query($con, "SELECT id FROM users WHERE reseller_notes='$reseller_notes' AND is_e2='1' AND enabled='1'");
            if (mysqli_num_rows($engdevice) != 0) {
                $query = "UPDATE users SET enabled='0' WHERE reseller_notes='$reseller_notes' AND is_e2='1' AND enabled='1'";
                $result = mysqli_query($con, $query);
                if (!$result) {
                    NXT_WHMCSReconnect();
                    return "NXT Database Query Error: " . mysql_error();
                }
            }
            NXT_WHMCSReconnect();
            logModuleCall(
                'NXT',
                __FUNCTION__,
                'Account Suspended: ' . $username,
                'success'
            );
            return "success";
        }
    } catch (Exception $e) {
        // Record the error in WHMCS's module log.
        logModuleCall(
            'NXT',
            __FUNCTION__,
            $params,
            $e->getMessage(),
            $e->getTraceAsString()
        );
        return $e->getMessage();
    }
    return 'success';
}

function NXT_UnsuspendAccount(array $params)
{
    try {
        $con = NXTXtreamCodeTestConnection($params['pid']);
        // First checking if user already exist with reqeuest username   
        $serviceid = $params["serviceid"];
        $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        $reseller_notes = $returndata['common_identifier'] . $serviceid;
        if ($params['configoption2'] == 'streamline' || $params['configoption2'] == 'streamlineonly' || $params['configoption2'] == 'streamlineeng') {
            $username = $params["username"];
            $result = mysqli_query($con, "SELECT username FROM users WHERE username='$username' AND enabled='0' AND reseller_notes ='$reseller_notes'");
            if (mysqli_num_rows($result) == 0) {
                NXT_WHMCSReconnect();
                return "User Not Found!!";
            }
            if (mysqli_num_rows($result) != 0) {
                $query = "UPDATE users SET enabled='1' WHERE username='$username' AND enabled='0' AND reseller_notes ='$reseller_notes'";
                $result = mysqli_query($con, $query);
                if (!$result) {
                    NXT_WHMCSReconnect();
                    return "NXT Database Query Error: " . mysql_error();
                }
            }
            NXT_WHMCSReconnect();
            logModuleCall(
                'NXT',
                __FUNCTION__,
                'Account UnSuspended: ' . $username,
                'success'
            );
            return "success";
        } elseif ($params['configoption2'] == 'resellercredits') {
            return 'success';
        } elseif ($params['configoption2'] == 'reselleraccount') {
            return 'success';
        } elseif ($params['configoption2'] == 'superreselleraccount') {
            return 'success';
        } elseif ($params['configoption2'] == 'magdevice') {
            $result = mysqli_query($con, "SELECT id FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1' AND enabled='0'");
            if (mysqli_num_rows($result) == 0) {
                NXT_WHMCSReconnect();
                return "User Not Found!!";
            }
            if (mysqli_num_rows($result) != 0) {
                $query = "UPDATE users SET enabled='1' WHERE reseller_notes='$reseller_notes' AND is_mag='1' AND enabled='0'";
                $result = mysqli_query($con, $query);
                if (!$result) {
                    NXT_WHMCSReconnect();
                    return "NXT Database Query Error: " . mysql_error();
                }
            }
            NXT_WHMCSReconnect();
            logModuleCall(
                'NXT',
                __FUNCTION__,
                'Account UnSuspended: ' . $username,
                'success'
            );
            return "success";
        } elseif ($params['configoption2'] == 'engdevice') {
            $result = mysqli_query($con, "SELECT id FROM users WHERE reseller_notes='$reseller_notes' AND is_e2='1' AND enabled='0'");
            if (mysqli_num_rows($result) == 0) {
                NXT_WHMCSReconnect();
                return "User Not Found!!";
            }
            if (mysqli_num_rows($result) != 0) {
                $query = "UPDATE users SET enabled='1' WHERE reseller_notes='$reseller_notes' AND is_e2='1' AND enabled='0'";
                $result = mysqli_query($con, $query);
                if (!$result) {
                    NXT_WHMCSReconnect();
                    return "NXT Database Query Error: " . mysql_error();
                }
            }
            NXT_WHMCSReconnect();
            logModuleCall(
                'NXT',
                __FUNCTION__,
                'Account UnSuspended: ' . $username,
                'success'
            );
            return "success";
        } elseif ($params['configoption2'] == 'streamlineengmag') {
            $username = $params["username"];
            $result = mysqli_query($con, "SELECT username FROM users WHERE username='$username' AND enabled='0' AND reseller_notes ='$reseller_notes'");
            if (mysqli_num_rows($result) != 0) {
                $query = "UPDATE users SET enabled='1' WHERE username='$username' AND enabled='0' AND reseller_notes ='$reseller_notes'";
                $result = mysqli_query($con, $query);
                if (!$result) {
                    NXT_WHMCSReconnect();
                    return "NXT Database Query Error: " . mysql_error();
                }
            }
            $magcheck = mysqli_query($con, "SELECT id FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1' AND enabled='0'");
            if (mysqli_num_rows($magcheck) != 0) {
                $query = "UPDATE users SET enabled='1' WHERE reseller_notes='$reseller_notes' AND is_mag='1' AND enabled='0'";
                $result = mysqli_query($con, $query);
                if (!$result) {
                    NXT_WHMCSReconnect();
                    return "NXT Database Query Error: " . mysql_error();
                }
            }
            $engdevice = mysqli_query($con, "SELECT id FROM users WHERE reseller_notes='$reseller_notes' AND is_e2='1' AND enabled='0'");
            if (mysqli_num_rows($engdevice) != 0) {
                $query = "UPDATE users SET enabled='1' WHERE reseller_notes='$reseller_notes' AND is_e2='1' AND enabled='0'";
                $result = mysqli_query($con, $query);
                if (!$result) {
                    NXT_WHMCSReconnect();
                    return "NXT Database Query Error: " . mysql_error();
                }
            }
            NXT_WHMCSReconnect();
            logModuleCall(
                'NXT',
                __FUNCTION__,
                'Account UnSuspended: ' . $username,
                'success'
            );
            return "success";
        }
    } catch (Exception $e) {
        // Record the error in WHMCS's module log.
        logModuleCall(
            'NXT',
            __FUNCTION__,
            $params,
            $e->getMessage(),
            $e->getTraceAsString()
        );
        return $e->getMessage();
    }
    return 'success';
}

function NXTResellerAddCredit($params, $creditsto)
{
    // Collecting parameters
    if ($creditsto == 'simple') {
        $desc = 'Top Up Coupon of Amount ' . $params['configoption3'];
        $amount = $params['configoption3'];
    } else {
        $desc = 'StartUp Credits ' . $params['configoption14'];
        $amount = $params['configoption14'];
    }
    $email = $params['clientsdetails']['email'];
    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    if ($returndata['syncredit'] == 'on') {
        $reselleremail = $params['customfields']['Reseller Email'];
        if (isset($reselleremail) && !empty($reselleremail)) {
            $email = $reselleremail;
        }
    }

    if (isset($params['addonId']) && !empty($params['addonId'])) {
        $con = NXTXtreamCodeTestConnection($params['pid'], 'addon');
    } else {
        $con = NXTXtreamCodeTestConnection($params['pid']);
    }
    # Inserting Now New User into 
    // First checking if user already exist with reqeuest username  
    $result = mysqli_query($con, "SELECT username,credits FROM members WHERE email='$email'");
    if (!$result) {
        $radiussqlerror = mysqli_error($con);
        NXT_WHMCSReconnect();
        logModuleCall('NXT', 'Check Reseller Exists', 'Email Address : ' . $email, "NXT Database Query Error: " . $radiussqlerror, '', '');
        return "NXT Database Query Error: " . $radiussqlerror;
    }
    if (mysqli_num_rows($result) > 0) {
        if ($returndata['syncredit'] == 'on') {
            $resellerdata = mysqli_fetch_assoc($result);
            $totalamount = $amount + $resellerdata['credits'];
            $update = mysqli_query($con, "UPDATE members SET credits ='$totalamount' WHERE email='$email'");
            if (!$update) {
                $radiussqlerror = mysqli_error($con);
                NXT_WHMCSReconnect();
                logModuleCall('NXT', 'Error Add Credits', 'Email Address : ' . $email, "NXT Database Query Error: " . $radiussqlerror, '', '');
                return "NXT Database Query Error: " . $radiussqlerror;
            }
            $desc .= " and Reseller Xtream Credits " . $resellerdata['credits'];
        }
        $reselleremail = $params['customfields']['Reseller Email'];
        if (isset($reselleremail) && !empty($reselleremail)) {
            return 'success';
        } else {
            NXT_WHMCSReconnect();
            $AddCredit = 'AddCredit';
            $postData = array(
                'clientid' => $params['clientsdetails']['userid'],
                'description' => $desc,
                'amount' => $amount,
            );
            $resultsCredit = localAPI($AddCredit, $postData, NXT_whmcsadmin());
            if ($resultsCredit['result'] == 'success') {
                logModuleCall('NXT', 'Add Credit', 'Email Address : ' . $email, $resultsCredit, '', '');
            } else {
                logModuleCall('NXT', 'Add Credit', 'Email Address : ' . $email, $resultsCredit, '', '');
            }
        }
    } else {
        logModuleCall('NXT', 'Error Add Credit', 'Email Address : ' . $email, "Reseller didn't exists!", '', '');
    }
    return 'success';
}

function NXT_TerminateAccount(array $params)
{
    $foldername = $params['clientsdetails']['firstname'] . $params['clientsdetails']['userid'];
    if (is_dir(ROOTDIR . "/" . str_replace(' ', '', strtolower($foldername)))) {
        $dir = ROOTDIR . "/" . str_replace(' ', '', strtolower($foldername));

        function XtreamCodedelTree($dir)
        {
            $files = array_diff(scandir($dir), array('.', '..'));
            foreach ($files as $file) {
                (is_dir("$dir/$file")) ? XtreamCodedelTree("$dir/$file") : unlink("$dir/$file");
            }
            return rmdir($dir);
        }

        XtreamCodedelTree($dir);
    }

    try {
        $con = NXTXtreamCodeTestConnection($params['pid']);
        $username = $params["username"];
        $serviceid = $params["serviceid"];
        $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        $reseller_notes = $returndata['common_identifier'] . $serviceid;
        if ($params['configoption2'] == 'streamline') {
            $magdata = 'no';
            $checkmagdevice = $params['customfields'][$returndata['checkmagdevice']];
            if (isset($checkmagdevice) && !empty($checkmagdevice)) {
                if ($checkmagdevice == 'on') {
                    if (!empty($params['customfields'][$returndata['custom_field_mag']])) {
                        $con = NXTXtreamCodeTestConnection($params['pid']);
                        $result = mysqli_query($con, "SELECT * FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1'");
                        $magdata = 'yes';
                    }
                }
            }
            // First checking if user already exist with reqeuest username  
            if ($magdata == 'no') {
                $result = mysqli_query($con, "SELECT * FROM users WHERE username='$username' AND reseller_notes='$reseller_notes'");

                if (mysqli_num_rows($result) == 0) {
                    NXT_WHMCSReconnect();
                    return "User Not Found!!";
                }
            }
            if (mysqli_num_rows($result) != 0) {
                $pairid = mysqli_fetch_assoc($result);
                if (isset($pairid['pair_id']) && !empty($pairid['pair_id'])) {
                    $mag_devices = mysqli_query($con, "DELETE FROM `mag_devices` WHERE user_id='" . $pairid['pair_id'] . "'");
                    $result = mysqli_query($con, "DELETE FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1'");
                }
                if ($magdata == 'no') {
                    $result = mysqli_query($con, "DELETE FROM users WHERE username='$username' AND reseller_notes='$reseller_notes'");
                } else {
                    $result = mysqli_query($con, "DELETE FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1'");
                }
                if (!$result) {
                    NXT_WHMCSReconnect();
                    return "NXT Database Query Error: " . mysqli_error($con);
                }
            }
            NXT_WHMCSReconnect();
            logModuleCall(
                'NXT',
                __FUNCTION__,
                'Account Deleted: ' . $username,
                'success'
            );
            return 'success';
        } elseif ($params['configoption2'] == 'resellercredits') {
            return 'success';
        } elseif ($params['configoption2'] == 'reselleraccount') { // Collecting parameters 
            $email = $params['clientsdetails']['email'];
            # Inserting Now New User into 
            // First checking if user already exist with reqeuest username  
            $result = mysqli_query($con, "SELECT username FROM members WHERE email='$email'");
            if (!$result) {
                $radiussqlerror = mysqli_error($con);
                NXT_WHMCSReconnect();
                return "NXT Database Query Error: " . $radiussqlerror;
            }
            if (mysqli_num_rows($result) > 0) {
                $delete = mysqli_query($con, "DELETE FROM members WHERE email='$email'");
                if (!$delete) {
                    $radiussqlerror = mysqli_error($con);
                    NXT_WHMCSReconnect();
                    return "NXT Database Query Error: " . $radiussqlerror;
                }
            } else {
                logModuleCall('NXT', 'Check Reseller Exists', 'Email Address : ' . $email, "This {$email} email address doesn't exists", '', '');
                return "This {$email} email address doesn't exists";
            }
            logModuleCall('NXT', 'Reseller Account Deleted', 'Email Address : ' . $email, "This {$email} email address doesn't exists", '', '');

            return 'success';
        } elseif ($params['configoption2'] == 'superreselleraccount') {
            // Collecting parameters 
            $email = $params['clientsdetails']['email'];
            # Inserting Now New User into 
            // First checking if user already exist with reqeuest username  
            $result = mysqli_query($con, "SELECT username FROM members WHERE email='$email'");
            if (!$result) {
                $radiussqlerror = mysqli_error($con);
                NXT_WHMCSReconnect();
                return "NXT Database Query Error: " . $radiussqlerror;
            }
            if (mysqli_num_rows($result) > 0) {
                $delete = mysqli_query($con, "DELETE FROM members WHERE email='$email'");
                if (!$delete) {
                    $radiussqlerror = mysqli_error($con);
                    NXT_WHMCSReconnect();
                    return "NXT Database Query Error: " . $radiussqlerror;
                }
            } else {
                logModuleCall('NXT', 'Check Super-Reseller Exists', 'Email Address : ' . $email, "This {$email} email address doesn't exists", '', '');
                return "This {$email} email address doesn't exists";
            }
            logModuleCall('NXT', 'Super-Reseller Account Deleted', 'Email Address : ' . $email, "This {$email} email address doesn't exists", '', '');

            return 'success';
        } elseif ($params['configoption2'] == 'streamlineonly') {

            // First checking if user already exist with reqeuest username  

            $result = mysqli_query($con, "SELECT * FROM users WHERE username='$username' AND reseller_notes='$reseller_notes'");
            if (mysqli_num_rows($result) == 0) {
                NXT_WHMCSReconnect();
                return "User Not Found!";
            }
            if (mysqli_num_rows($result) != 0) {
                $result = mysqli_query($con, "DELETE FROM users WHERE username='$username' AND reseller_notes='$reseller_notes'");
                if (!$result) {
                    NXT_WHMCSReconnect();
                    return "NXT Database Query Error: " . mysqli_error($con);
                }
            }
            NXT_WHMCSReconnect();
            logModuleCall(
                'NXT',
                __FUNCTION__,
                'Account Deleted: ' . $username,
                'success'
            );
            return 'success';
        } elseif ($params['configoption2'] == 'magdevice') {
            if (!empty($params['customfields'][$returndata['custom_field_mag']])) {
                $con = NXTXtreamCodeTestConnection($params['pid']);
                $result = mysqli_query($con, "SELECT * FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1'");
            }
            if (mysqli_num_rows($result) != 0) {
                while ($pairid = mysqli_fetch_assoc($result)) {
                    if (isset($pairid['id']) && !empty($pairid['id'])) {
                        $mag_devices = mysqli_query($con, "DELETE FROM `mag_devices` WHERE user_id='" . $pairid['id'] . "'");
                    }
                    $result = mysqli_query($con, "DELETE FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1'");
                    if (!$result) {
                        NXT_WHMCSReconnect();
                        return "NXT Database Query Error: " . mysqli_error($con);
                    }
                }
            }
            NXT_WHMCSReconnect();
            logModuleCall(
                'NXT',
                __FUNCTION__,
                'Account Deleted: ' . $username,
                'success'
            );
            return 'success';
        } elseif ($params['configoption2'] == 'engdevice') {
            $username = $username . $returndata['common_identifier'] . $serviceid;
            if (!empty($params['customfields'][$returndata['custom_field_eng']])) {
                $con = NXTXtreamCodeTestConnection($params['pid']);
                $reseller_notes = $returndata['common_identifier'] . $serviceid;
                $result = mysqli_query($con, "SELECT * FROM users WHERE reseller_notes='$reseller_notes' AND is_e2='1'");
            }
            if (mysqli_num_rows($result) != 0) {
                $pairid = mysqli_fetch_assoc($result);
                if (isset($pairid['id']) && !empty($pairid['id'])) {
                    $mag_devices = mysqli_query($con, "DELETE FROM `enigma2_devices` WHERE user_id='" . $pairid['id'] . "'");
                }
                $result = mysqli_query($con, "DELETE FROM users WHERE reseller_notes='$reseller_notes' AND is_e2='1' ");

                if (!$result) {
                    NXT_WHMCSReconnect();
                    return "NXT Database Query Error: " . mysqli_error($con);
                }
            }
            NXT_WHMCSReconnect();
            logModuleCall(
                'NXT',
                __FUNCTION__,
                'Account Deleted: ' . $username,
                'success'
            );
            return 'success';
        } elseif ($params['configoption2'] == 'streamlineeng') {
            $magdata = 'no';
            $username = $username . $returndata['common_identifier'] . $serviceid;
            $checkmagdevice = $params['customfields'][$returndata['checkengdevice']];
            if (isset($checkmagdevice) && !empty($checkmagdevice)) {
                if ($checkmagdevice == 'on') {
                    if (!empty($params['customfields'][$returndata['custom_field_eng']])) {
                        $con = NXTXtreamCodeTestConnection($params['pid']);
                        $reseller_notes = $returndata['common_identifier'] . $serviceid;
                        $result = mysqli_query($con, "SELECT * FROM users WHERE reseller_notes='$reseller_notes' AND is_e2='1'");
                        $magdata = 'yes';
                    }
                }
            }
            // First checking if user already exist with reqeuest username  
            if ($magdata == 'no') {
                $result = mysqli_query($con, "SELECT * FROM users WHERE username='$username' AND reseller_notes='$reseller_notes'");
                if (mysqli_num_rows($result) == 0) {
                    NXT_WHMCSReconnect();
                    return "User Not Found!!";
                }
            }
            if (mysqli_num_rows($result) != 0) {
                $pairid = mysqli_fetch_assoc($result);
                if (isset($pairid['pair_id']) && !empty($pairid['pair_id'])) {
                    $mag_devices = mysqli_query($con, "DELETE FROM `enigma2_devices` WHERE user_id='" . $pairid['pair_id'] . "'");
                    $result = mysqli_query($con, "DELETE FROM users WHERE reseller_notes='$reseller_notes' AND is_e2='1'");
                }
                if ($magdata == 'no') {
                    $result = mysqli_query($con, "DELETE FROM users WHERE username='$username' AND reseller_notes='$reseller_notes'");
                } else {
                    $result = mysqli_query($con, "DELETE FROM users WHERE reseller_notes='$reseller_notes' AND is_e2='1'");
                }
                if (!$result) {
                    NXT_WHMCSReconnect();
                    return "NXT Database Query Error: " . mysqli_error($con);
                }
            }
            NXT_WHMCSReconnect();
            logModuleCall(
                'NXT',
                __FUNCTION__,
                'Account Deleted: ' . $username,
                'success'
            );
            return 'success';
        } elseif ($params['configoption2'] == 'streamlineengmag') {
            //Stream Deleted
            $resultusers = mysqli_query($con, "SELECT * FROM users WHERE username='$username' AND reseller_notes='$reseller_notes'");
            if (mysqli_num_rows($resultusers) == 0) {
                NXT_WHMCSReconnect();
                return "User Not Found!";
            }
            if (mysqli_num_rows($resultusers) != 0) {
                $resultdelusers = mysqli_query($con, "DELETE FROM users WHERE username='$username' AND reseller_notes='$reseller_notes'");
                if (!$resultdelusers) {
                    NXT_WHMCSReconnect();
                    return "NXT Database Query Error: " . mysqli_error($con);
                }
            }
            //Engma deleted
            if (!empty($params['customfields'][$returndata['custom_field_eng']])) {
                $con = NXTXtreamCodeTestConnection($params['pid']);
                $reseller_notes = $returndata['common_identifier'] . $serviceid;
                $result = mysqli_query($con, "SELECT * FROM users WHERE reseller_notes='$reseller_notes' AND is_e2='1'");
            }
            if (mysqli_num_rows($result) != 0) {
                $pairid = mysqli_fetch_assoc($result);
                if (isset($pairid['id']) && !empty($pairid['id'])) {
                    $mag_devices = mysqli_query($con, "DELETE FROM `enigma2_devices` WHERE user_id='" . $pairid['id'] . "'");
                }
                $result = mysqli_query($con, "DELETE FROM users WHERE reseller_notes='$reseller_notes' AND is_e2='1' ");

                if (!$result) {
                    NXT_WHMCSReconnect();
                    return "NXT Database Query Error: " . mysqli_error($con);
                }
            }
            //MAG deleted
            if (!empty($params['customfields'][$returndata['custom_field_mag']])) {
                $con = NXTXtreamCodeTestConnection($params['pid']);
                $result = mysqli_query($con, "SELECT * FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1'");
            }
            if (mysqli_num_rows($result) != 0) {
                while ($pairid = mysqli_fetch_assoc($result)) {
                    if (isset($pairid['id']) && !empty($pairid['id'])) {
                        $mag_devices = mysqli_query($con, "DELETE FROM `mag_devices` WHERE user_id='" . $pairid['id'] . "'");
                    }
                    $result = mysqli_query($con, "DELETE FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1'");
                    if (!$result) {
                        NXT_WHMCSReconnect();
                        return "NXT Database Query Error: " . mysqli_error($con);
                    }
                }
            }
            NXT_WHMCSReconnect();
            logModuleCall(
                'NXT',
                __FUNCTION__,
                'Account Deleted: ' . $username,
                'success'
            );
            return 'success';
        }
    } catch (Exception $e) {
        // Record the error in WHMCS's module log.
        logModuleCall(
            'NXT',
            __FUNCTION__,
            $params,
            $e->getMessage(),
            $e->getTraceAsString()
        );

        return $e->getMessage();
    }

    return 'success';
}

function NXT_Renew(array $params)
{
    if ($params['configoption2'] == 'streamline') {
        return NXTStreamlinetoStreamline($params);
    } elseif ($params['configoption2'] == 'streamlineonly') {
        return NXTStreamlineonlytoStreamlineonly($params);
    } elseif ($params['configoption2'] == 'magdevice') {
        return NXTMagdevicetoMagdevice($params);
    } elseif ($params['configoption2'] == 'streamlineeng') {
        return NXTStreamlineengtoStreamlineeng($params);
    } elseif ($params['configoption2'] == 'engdevice') {
        return NXTEngdevicetoEngdevice($params);
    } elseif ($params['configoption2'] == 'streamlineengmag') {
        return NXTStreamlineMAGENGtoStreamlineMAGENG($params);
    }
    return 'success';
}

function NXT_ChangePackage(array $params)
{
    /*
     * Check orginal product before upgrading to new
     */
    $producttype = NXTXtreamCheckOrginalProduct($params['serviceid'], $params['action'], $params['pid']);
    if ($producttype == 'streamline') {
        if ($params['configoption2'] == 'streamline') {
            return NXTStreamlinetoStreamline($params);
        } elseif ($params['configoption2'] == 'streamlineonly') {
            return StreamlinetoStreamlineonly($params);
        } elseif ($params['configoption2'] == 'magdevice') {
            return StreamlinetoMagdevice($params);
        } elseif ($params['configoption2'] == 'streamlineeng') {
            return StreamlinetoStreamlineeng($params);
        } elseif ($params['configoption2'] == 'engdevice') {
            return StreamlinetoEngdevice($params);
        }
    } elseif ($producttype == 'streamlineonly') {
        if ($params['configoption2'] == 'streamline') {
            return StreamlineonlytoStreamline($params);
        } elseif ($params['configoption2'] == 'streamlineonly') {
            return NXTStreamlineonlytoStreamlineonly($params);
        } elseif ($params['configoption2'] == 'magdevice') {
            return StreamlineonlytoMagdevice($params);
        } elseif ($params['configoption2'] == 'streamlineeng') {
            return StreamlineonlytoStreamlineeng($params);
        } elseif ($params['configoption2'] == 'engdevice') {
            return StreamlineonlytoEngdevice($params);
        }
    } elseif ($producttype == 'magdevice') {
        if ($params['configoption2'] == 'streamline') {
            return MagdevicetoStreamline($params);
        } elseif ($params['configoption2'] == 'streamlineonly') {
            return MagdevicetoStreamlineonly($params);
        } elseif ($params['configoption2'] == 'magdevice') {
            return NXTMagdevicetoMagdevice($params);
        } elseif ($params['configoption2'] == 'streamlineeng') {
            return MagdevicetoStreamlineeng($params);
        } elseif ($params['configoption2'] == 'engdevice') {
            return MagdevicetoEngdevice($params);
        }
    } elseif ($producttype == 'streamlineeng') {
        if ($params['configoption2'] == 'streamline') {
            return StreamlineengtoStreamline($params);
        } elseif ($params['configoption2'] == 'streamlineonly') {
            return StreamlineengtoStreamlineonly($params);
        } elseif ($params['configoption2'] == 'magdevice') {
            return StreamlineengtoMagdevice($params);
        } elseif ($params['configoption2'] == 'streamlineeng') {
            return NXTStreamlineengtoStreamlineeng($params);
        } elseif ($params['configoption2'] == 'engdevice') {
            return StreamlineengtoEngdevice($params);
        }
    } elseif ($producttype == 'engdevice') {
        if ($params['configoption2'] == 'streamline') {
            return EngdevicetoStreamline($params);
        } elseif ($params['configoption2'] == 'streamlineonly') {
            return EngdevicetoStreamlineonly($params);
        } elseif ($params['configoption2'] == 'magdevice') {
            return EngdevicetoMagdevice($params);
        } elseif ($params['configoption2'] == 'streamlineeng') {
            return EngdevicetoStreamlineeng($params);
        } elseif ($params['configoption2'] == 'engdevice') {
            return NXTEngdevicetoEngdevice($params);
        }
    } elseif ($producttype == 'streamlineengmag') {
        if ($params['configoption2'] == 'streamlineengmag') {
            return NXTStreamlineMAGENGtoStreamlineMAGENG($params);
        }
    }
    return 'success';
}

function NXT_ManuallyRenew(array $params)
{
    if ($params['configoption2'] == 'streamline') {
        return NXTStreamlinetoStreamline($params);
    } elseif ($params['configoption2'] == 'streamlineonly') {
        return NXTStreamlineonlytoStreamlineonly($params);
    } elseif ($params['configoption2'] == 'magdevice') {
        return NXTMagdevicetoMagdevice($params);
    } elseif ($params['configoption2'] == 'streamlineeng') {
        return NXTStreamlineengtoStreamlineeng($params);
    } elseif ($params['configoption2'] == 'engdevice') {
        return NXTEngdevicetoEngdevice($params);
    } elseif ($params['configoption2'] == 'streamlineengmag') {
        return NXTStreamlineMAGENGtoStreamlineMAGENG($params);
    }
    return 'success';
}
function NXTXtreamCheckOrginalProduct($seriviceid, $action, $pid)
{
    if ($action == 'configupgrade') {
        $productid = $pid;
        $tblproducts = Capsule::table('tblproducts')->where('id', '=', $productid)->select('configoption2')->get();
        if (isset($tblproducts) && !empty($tblproducts)) {
            return $tblproducts[0]->configoption2;
        }
    } else {
        $tblupgrade = Capsule::table('tblupgrades')->where('type', '=', 'package')->where('relid', '=', $seriviceid)->select('originalvalue')->orderBy('id', 'desc')->first();
        if (isset($tblupgrade) && !empty($tblupgrade)) {
            $productid = $tblupgrade->originalvalue;
            $tblproducts = Capsule::table('tblproducts')->where('id', '=', $productid)->select('configoption2')->get();
            if (isset($tblproducts) && !empty($tblproducts)) {
                return $tblproducts[0]->configoption2;
            }
        }
    }
    return '';
}

function NXT_AddENG(array $params, $newmac)
{
    NXT_WHMCSReconnect();
    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    $member_id = $params['configoption9'];
    $Bouquets = isset($params['customfields']['Select Bouquets']) && !empty($params['customfields']['Select Bouquets']) ? trim($params['customfields']['Select Bouquets']) : $params['configoption10'];
    $CheckBouquets = NXT_ProductAddonsPack($params, $Bouquets);
    if ($CheckBouquets != "") {
        $Bouquets = $CheckBouquets;
    }



    $is_trial = ($params['configoption5'] == 'Yes') ? '1' : '0';
    $syn_expiry = $params['configoption17'];
    $trial_period = ($params['configoption18'] != 0) ? '+' . $params['configoption18'] . ' hours' : '+24 hours';
    $billing_months = $params['configoption21'];
    $con = NXTXtreamCodeTestConnection($params['pid']);
    $tblhostingdetails = Capsule::table('tblhosting')->where('id', '=', $params["serviceid"])->get();
    $nextduedate = $tblhostingdetails[0]->nextduedate;
    $regdate = $tblhostingdetails[0]->regdate;
    $serviceid = $tblhostingdetails[0]->id;
    // Collecting parameters
    $iptvusername = $params["username"];
    $password = $params["password"];

    $username = $iptvusername . $returndata['common_identifier'] . $serviceid;
    # Inserting Now New User into 
    // First checking if user already exist with reqeuest username  
    $reseller_notes = $returndata['common_identifier'] . $serviceid;
    $result = mysqli_query($con, "SELECT id,username FROM users WHERE reseller_notes='$reseller_notes' AND is_e2='1'");
    if (!$result) {
        $radiussqlerror = mysqli_error($con);
        NXT_WHMCSReconnect();
        return "NXT Database Query Error: " . $radiussqlerror;
    }
    if (mysqli_num_rows($result) > 0) {
        NXT_WHMCSReconnect();
        return "This {$username} username is already taken";
    }
    $userid = array();
    if ($params['configoption2'] == 'engdevice') {
        $userid['id'] = '';
    } else {
        $checkmagdevice = $params['customfields'][$returndata['checkengdevice']];
        if (isset($checkmagdevice) && !empty($checkmagdevice) && $checkmagdevice == 'on') {
            $userid['id'] = '';
        } else {
            $iptvusernameresult = mysqli_query($con, "SELECT id FROM users WHERE username='$iptvusername'");
            if (mysqli_num_rows($iptvusernameresult) == 0) {
                NXT_WHMCSReconnect();
                return "User Not Found!!";
            } else {
                $userid = mysqli_fetch_assoc($iptvusernameresult);
            }
        }
    }
    $clientemail = NXTcheckAffexists($params['clientsdetails']['userid']);
    if (!empty($clientemail)) {
        $result = mysqli_query($con, "SELECT id FROM members WHERE email='$clientemail'");
        if (!$result) {
            $radiussqlerror = mysqli_error($con);
            NXT_WHMCSReconnect();
            logModuleCall('NXT', 'Check Reseller Exists', 'Email Address : ' . $clientemail, "NXT Database Query Error: " . $radiussqlerror, '', '');
            return "NXT Database Query Error: " . $radiussqlerror;
        }
        if (mysqli_num_rows($result) > 0) {
            $resellerdata = mysqli_fetch_assoc($result);
            $member_id = $resellerdata['id'];
        }
    }
    $expdate = 'NULL';
    if ($is_trial == 1 && $nextduedate != '0000-00-00') {
        $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
    } else {
        if ($syn_expiry == 'on' && $nextduedate != '0000-00-00') {
            $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
        } elseif ($is_trial == 1) {
            $expdate = strtotime(date("Y-m-d H:i:s", strtotime($trial_period)));
        } elseif ($is_trial == 0 && $nextduedate == '0000-00-00' && $billing_months != "" && $billing_months != 0) {
            $effectiveDate = date('Y-m-d H:i:s', strtotime("+" . $billing_months . " months", strtotime(date('Y-m-d H:i:s'))));
            $expdate = strtotime($effectiveDate);
        }
    }
    if (GetConfigXtreamDetailsHourDiff() != "" && $expdate != "NULL") {
        $expdate = $expdate + 60 * 60 * GetConfigXtreamDetailsHourDiff();
    }
    $output = json_encode(["m3u8", "ts", "rtmp"]);
    # Inserting Now New User into 
    $query = "INSERT INTO users (member_id , username , password , admin_enabled , enabled ,admin_notes, reseller_notes , bouquet , `output`, `allowed_ips`, `allowed_ua` , created_at , created_by , pair_id , is_e2,exp_date,is_trial)
                         VALUES ('$member_id' , '$username' , '$password' , 1 , 1 , '" . $returndata['common_identifier'] . $serviceid . "', '" . $returndata['common_identifier'] . $serviceid . "' , '$Bouquets' , '$output' , '[]' , '[]' , " . strtotime($regdate) . ", 0 , '" . $userid['id'] . "' ,'1',$expdate,$is_trial)";

    $result = mysqli_query($con, $query);
    if (!$result) {
        $radiussqlerror = mysqli_error($con);
        NXT_WHMCSReconnect();
        return "NXT Database Query Error: " . $radiussqlerror;
    } else {
        $checkengdevice = $params['customfields'][$returndata['checkengdevice']];
        if (isset($checkengdevice) && !empty($checkengdevice)) {
            $lastinsertid = mysqli_insert_id($con);
        } else {
            $lastinsertid = mysqli_insert_id($con);
            $updatepair = mysqli_query($con, "UPDATE users SET pair_id='" . $lastinsertid . "' WHERE username='$iptvusername'");
            if (!$updatepair) {
                $radiussqlerror = mysqli_error($con);
                NXT_WHMCSReconnect();
                return "NXT Database Query Error: " . $radiussqlerror;
            }
        }
        //Access Output Setting in X.C
        $accessoutput = mysqli_query($con, "SELECT * FROM `access_output`");
        if (mysqli_num_rows($accessoutput) > 0) {
            while ($accessoutputdata = mysqli_fetch_assoc($accessoutput)) {
                mysqli_query($con, "INSERT INTO user_output(user_id, access_output_id) VALUES('" . $lastinsertid . "', '" . $accessoutputdata['access_output_id'] . "')");
            }
        }
        # Inserting Now New User into 
        $eng_devices = "INSERT INTO enigma2_devices (mac, user_id, telnet_enable, ftp_enable, ssh_enable, rc)
    VALUES ('$newmac', '" . $lastinsertid . "', '1', '1', '1', '1')";
        $eng_devicesresult = mysqli_query($con, $eng_devices);
        if (!$eng_devicesresult) {
            $radiussqlerror = mysqli_error($con);
            NXT_WHMCSReconnect();
            return "NXT Database Query Error: " . $radiussqlerror;
        }
        $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        NXT_WHMCSReconnect();
        $fieldid = Capsule::table('tblcustomfields')
            ->where('fieldname', $returndata['custom_field_eng'])
            ->where('type', 'product')
            ->where('relid', $params['packageid'])
            ->get();
        if (isset($fieldid) && !empty($fieldid)) {
            $checkExists = Capsule::table('tblcustomfieldsvalues')
                ->where('relid', $params['serviceid'])
                ->where('fieldid', $fieldid[0]->id)
                ->get();
            if (isset($checkExists) && !empty($checkExists)) {
                Capsule::table('tblcustomfieldsvalues')
                    ->where('relid', $params['serviceid'])
                    ->where('fieldid', $fieldid[0]->id)
                    ->update(['value' => $newmac]);
            } else {
                Capsule::table('tblcustomfieldsvalues')->insert(
                    ['fieldid' => $fieldid[0]->id, 'relid' => $params['serviceid'], 'value' => $newmac]
                );
            }
        }
    }
    return 'success';
}

function NXT_ChangeENG(array $params, $newmac)
{
    $con = NXTXtreamCodeTestConnection($params['pid']);
    $tblhostingdetails = Capsule::table('tblhosting')->where('id', '=', $params["serviceid"])->get();
    $serviceid = $tblhostingdetails[0]->id;
    // Collecting parameters  
    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    $reseller_notes = $returndata['common_identifier'] . $serviceid;
    # Inserting Now New User into 
    // First checking if user already exist with reqeuest username  
    $result = mysqli_query($con, "SELECT id FROM users WHERE reseller_notes='$reseller_notes' AND is_e2='1'");

    if (!$result) {
        $radiussqlerror = mysqli_error($con);
        NXT_WHMCSReconnect();
        return "XtreamDashboard Database Query Error: " . $radiussqlerror;
    }
    if (mysqli_num_rows($result) > 0) {
        $resultmag_devices = mysqli_query($con, "SELECT * FROM enigma2_devices WHERE mac='" . $newmac . "'");
        if (mysqli_num_rows($resultmag_devices) == 0) {
            $userid = mysqli_fetch_assoc($result);
            $updatepair = mysqli_query($con, "UPDATE enigma2_devices SET mac='" . $newmac . "' WHERE user_id='" . $userid['id'] . "'");
            if (!$updatepair) {
                $radiussqlerror = mysqli_error($con);
                NXT_WHMCSReconnect();
                return "NXT Database Query Error: " . $radiussqlerror;
            }
            NXT_WHMCSReconnect();
            $fieldid = Capsule::table('tblcustomfields')
                ->where('fieldname', $returndata['custom_field_eng'])
                ->where('type', 'product')
                ->where('relid', $params['packageid'])
                ->get();

            if (isset($fieldid) && !empty($fieldid)) {
                $checkExists = Capsule::table('tblcustomfieldsvalues')
                    ->where('relid', $params['serviceid'])
                    ->where('fieldid', $fieldid[0]->id)
                    ->get();

                if (isset($checkExists) && !empty($checkExists)) {
                    Capsule::table('tblcustomfieldsvalues')
                        ->where('relid', $params['serviceid'])
                        ->where('fieldid', $fieldid[0]->id)
                        ->update(['value' => $newmac]);
                } else {
                    Capsule::table('tblcustomfieldsvalues')->insert(
                        ['fieldid' => $fieldid[0]->id, 'relid' => $params['serviceid'], 'value' => $newmac]
                    );
                }
            }
        } else {
            return "macexists";
        }
    }
    return 'success';
}

function NXT_PasswordChange(array $params, $newPassword)
{
    $command = 'EncryptPassword';
    $postData = array(
        'password2' => $newPassword,
    );
    $encPassword = localAPI($command, $postData, NXT_whmcsadmin());
    $encPassword = $encPassword['password'];
    $tblhostingpwd = Capsule::table('tblhosting')
        ->where('id', '=', $params["serviceid"])
        ->update(['password' => $encPassword]);

    $con = NXTXtreamCodeTestConnection($params['pid']);
    if ($tblhostingpwd) {
        $resultPass = mysqli_query($con, "UPDATE users SET password='" . $newPassword . "' WHERE reseller_notes='WHMCS:" . $params['serviceid'] . "'");
        if ($resultPass) {
            return 'success';
        } else {
            return 'error';
        }
    } else {
        return 'error';
    }
}

function NXT_ChangeMAGSingle(array $params, $newmac)
{
    $con = NXTXtreamCodeTestConnection($params['pid']);
    $tblhostingdetails = Capsule::table('tblhosting')->where('id', '=', $params["serviceid"])->get();
    $serviceid = $tblhostingdetails[0]->id;
    // Collecting parameters 
    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    $reseller_notes = $returndata['common_identifier'] . $serviceid;
    # Inserting Now New User into 
    // First checking if user already exist with reqeuest username  
    $result = mysqli_query($con, "SELECT id FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1'");

    if (!$result) {
        $radiussqlerror = mysqli_error($con);
        NXT_WHMCSReconnect();
        return "XtreamDashboard Database Query Error: " . $radiussqlerror;
    }
    if (mysqli_num_rows($result) > 0) {
        $resultmag_devices = mysqli_query($con, "SELECT * FROM mag_devices WHERE mac='" . base64_encode($newmac) . "'");
        if (mysqli_num_rows($resultmag_devices) == 0) {
            $userid = mysqli_fetch_assoc($result);
            $updatepair = mysqli_query($con, "UPDATE mag_devices SET mac='" . base64_encode($newmac) . "' WHERE user_id='" . $userid['id'] . "'");
            if (!$updatepair) {
                $radiussqlerror = mysqli_error($con);
                NXT_WHMCSReconnect();
                return "NXT Database Query Error: " . $radiussqlerror;
            }
            NXT_WHMCSReconnect();
            $fieldid = Capsule::table('tblcustomfields')
                ->where('fieldname', $returndata['custom_field_mag'])
                ->where('type', 'product')
                ->where('relid', $params['packageid'])
                ->get();
            if (isset($fieldid) && !empty($fieldid)) {
                $checkExists = Capsule::table('tblcustomfieldsvalues')
                    ->where('relid', $params['serviceid'])
                    ->where('fieldid', $fieldid[0]->id)
                    ->get();
                if (isset($checkExists) && !empty($checkExists)) {
                    Capsule::table('tblcustomfieldsvalues')
                        ->where('relid', $params['serviceid'])
                        ->where('fieldid', $fieldid[0]->id)
                        ->update(['value' => $newmac]);
                } else {
                    Capsule::table('tblcustomfieldsvalues')->insert(
                        ['fieldid' => $fieldid[0]->id, 'relid' => $params['serviceid'], 'value' => $newmac]
                    );
                }
            }
        } else {
            return "macexists";
        }
    }
    return 'success';
}

function NXT_ChangeMAG(array $params, $newmac, $oldmac)
{
    $con = NXTXtreamCodeTestConnection($params['pid']);
    $tblhostingdetails = Capsule::table('tblhosting')->where('id', '=', $params["serviceid"])->get();
    $serviceid = $tblhostingdetails[0]->id;
    // Collecting parameters 
    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    $reseller_notes = $returndata['common_identifier'] . $serviceid;
    # Inserting Now New User into 
    // First checking if user already exist with reqeuest username   
    $result = mysqli_query($con, "SELECT id FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1'");
    if (!$result) {
        $radiussqlerror = mysqli_error($con);
        NXT_WHMCSReconnect();
        return "XtreamDashboard Database Query Error: " . $radiussqlerror;
    }
    if (mysqli_num_rows($result) > 0) {
        while ($userid = mysqli_fetch_assoc($result)) {
            $resultmag_devices = mysqli_query($con, "SELECT * FROM mag_devices WHERE mac='" . base64_encode($newmac) . "'");
            if (mysqli_num_rows($resultmag_devices) == 0) {
                $updatepair = mysqli_query($con, "UPDATE mag_devices SET mac='" . base64_encode($newmac) . "' WHERE user_id='" . $userid['id'] . "' AND mac ='" . base64_encode($oldmac) . "'");
                if (!$updatepair) {
                    $radiussqlerror = mysqli_error($con);
                    NXT_WHMCSReconnect();
                    return "NXT Database Query Error: " . $radiussqlerror;
                }
                NXT_AddUpdateCustomfield($params);
                return 'success';
            } else {
                return 'macexists';
            }
        }
        return 'success';
    }
}

function NXT_AddMAG(array $params, $newmac)
{
    NXT_WHMCSReconnect();
    $is_trial = ($params['configoption5'] == 'Yes') ? '1' : '0';
    $member_id = $params['configoption9'];
    $Bouquets = isset($params['customfields']['Select Bouquets']) && !empty($params['customfields']['Select Bouquets']) ? trim($params['customfields']['Select Bouquets']) : $params['configoption10'];
    $CheckBouquets = NXT_ProductAddonsPack($params, $Bouquets);
    if ($CheckBouquets != "") {
        $Bouquets = $CheckBouquets;
    }
    $syn_expiry = $params['configoption17'];
    if ($is_trial == 1) {
        $trial_period = ($params['configoption18'] != 0) ? '+' . $params['configoption18'] . ' hours' : '+24 hours';
    } else {
        $day_period = ($params['configoption18'] != 0) ? '+' . $params['configoption18'] . ' days' : '+24 days';
    }
    $billing_months = $params['configoption21'];
    $tblhostingdetails = Capsule::table('tblhosting')->where('id', '=', $params["serviceid"])->get();
    $regdate = $tblhostingdetails[0]->regdate;
    $nextduedate = $tblhostingdetails[0]->nextduedate;
    $serviceid = $tblhostingdetails[0]->id;





    $expdate = 'NULL';
    if ($is_trial == 1 && $nextduedate != '0000-00-00') {
        $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
    } else {
        if ($syn_expiry == 'on' && $nextduedate != '0000-00-00') {
            $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
            if ($is_trial == 0) {
                $expdate = strtotime(date("Y-m-d H:i:s", strtotime($day_period)));
            }
        } elseif ($is_trial == 1) {
            $expdate = strtotime(date("Y-m-d H:i:s", strtotime($trial_period)));
        } elseif ($is_trial == 0 && $nextduedate == '0000-00-00' && $billing_months != "" && $billing_months != 0) {
            $effectiveDate = date('Y-m-d H:i:s', strtotime("+" . $billing_months . " months", strtotime(date('Y-m-d H:i:s'))));
            $expdate = strtotime($effectiveDate);
        } elseif ($is_trial == 0 && $nextduedate != '0000-00-00') {
            $expdate = strtotime(date("Y-m-d H:i:s", strtotime($day_period)));
        }
    }
    if (GetConfigXtreamDetailsHourDiff() != "" && $expdate != "NULL") {
        $expdate = $expdate + 60 * 60 * GetConfigXtreamDetailsHourDiff();
    }
    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    $con = NXTXtreamCodeTestConnection($params['pid']);

    // Collecting parameters
    $iptvusername = $params["username"];
    $password = $params["password"]; 
    $digits = 10;
    if (empty($iptvusername)) {
        $iptvusername = NXT_generate_ran($digits, false, "d");
    }
    if (empty($password)) {
        $password = NXT_generate_ran($digits, false, "d");
    }


    $username = $iptvusername . $serviceid;
    # Inserting Now New User into 
    // First checking if user already exist with reqeuest username  

    $reseller_notes = $returndata['common_identifier'] . $serviceid;
    # Inserting Now New User into 
    // First checking if user already exist with reqeuest username   
    $result = mysqli_query($con, "SELECT id FROM users INNER JOIN mag_devices ON users.id=mag_devices.user_id WHERE users.reseller_notes='$reseller_notes' AND users.is_mag='1' AND mag_devices.mac ='" . base64_encode($newmac) . "'");
    if (!$result) {
        $radiussqlerror = mysqli_error($con);
        NXT_WHMCSReconnect();
        return "NXT Database Query Error: " . $radiussqlerror;
    }
    if (mysqli_num_rows($result) > 0) {
        NXT_WHMCSReconnect();
        return "This {$reseller_notes} User is already exists";
    }
    $userid = array();
    if ($params['configoption2'] == 'magdevice') {
        $userid['id'] = '';
    } else {
        $checkmagdevice = $params['customfields'][$returndata['checkmagdevice']];
        if (isset($checkmagdevice) && !empty($checkmagdevice) && $checkmagdevice == 'on') {
            $userid['id'] = '';
        } else {
            $iptvusernameresult = mysqli_query($con, "SELECT id FROM users WHERE username='$iptvusername'");
            if (mysqli_num_rows($iptvusernameresult) == 0) {
                NXT_WHMCSReconnect();
                return "User Not Found!!";
            } else {
                $userid = mysqli_fetch_assoc($iptvusernameresult);
            }
        }
    }
    $clientemail = NXTcheckAffexists($params['clientsdetails']['userid']);
    if (!empty($clientemail)) {
        $result = mysqli_query($con, "SELECT id FROM members WHERE email='$clientemail'");
        if (!$result) {
            $radiussqlerror = mysqli_error($con);
            NXT_WHMCSReconnect();
            logModuleCall('NXT', 'Check Reseller Exists', 'Email Address : ' . $clientemail, "NXT Database Query Error: " . $radiussqlerror, '', '');
            return 'Sorry, but something went wrong. Please contact Administrator';
        }
        if (mysqli_num_rows($result) > 0) {
            $resellerdata = mysqli_fetch_assoc($result);
            $member_id = $resellerdata['id'];
        }
    }
    $output = json_encode(["m3u8", "ts", "rtmp"]);
    # Inserting Now New User into 
    if ($is_trial == 0 && $params['configoption18'] > 0 && !empty($params['configoption18'])) {
        Capsule::table('tblhosting')->where('id', $serviceid)->update(['nextduedate' => date("Y-m-d", $expdate), 'nextinvoicedate' => date("Y-m-d", $expdate),]);
    }
    $query = "INSERT INTO users (member_id , username , password , admin_enabled , enabled ,admin_notes ,reseller_notes , bouquet , `output`, `allowed_ips`, `allowed_ua` , created_at , created_by , pair_id , is_mag,exp_date,is_trial)  
                         VALUES ('$member_id' , '$username' , '$password' , 1 , 1 , '" . $returndata['common_identifier'] . $serviceid . "' , '" . $returndata['common_identifier'] . $serviceid . "' , '$Bouquets' , '$output' , '[]' , '[]' , " . strtotime($regdate) . ", 0 , '" . $userid['id'] . "' , 1,$expdate,$is_trial)";
    $result = mysqli_query($con, $query);
    if (!$result) {
        $radiussqlerror = mysqli_error($con);
        NXT_WHMCSReconnect();
        return "NXT Database Query Error: " . $radiussqlerror;
    } else {
        $checkmagdevice = $params['customfields'][$returndata['checkmagdevice']];
        if (isset($checkmagdevice) && !empty($checkmagdevice)) {
            $lastinsertid = mysqli_insert_id($con);
        } else {
            $lastinsertid = mysqli_insert_id($con);
            $updatepair = mysqli_query($con, "UPDATE users SET  pair_id='" . $lastinsertid . "' WHERE username='$iptvusername'");
            if (!$updatepair) {
                NXT_WHMCSReconnect();
                return 'Sorry,Unable to update user detials!';
            }
        }
        //Access Output Setting in X.C
        $accessoutput = mysqli_query($con, "SELECT * FROM `access_output`");
        if (mysqli_num_rows($accessoutput) > 0) {
            while ($accessoutputdata = mysqli_fetch_assoc($accessoutput)) {
                mysqli_query($con, "INSERT INTO user_output(user_id, access_output_id) VALUES('" . $lastinsertid . "', '" . $accessoutputdata['access_output_id'] . "')");
            }
        }
        //Add MAG Device in X.C  
        $mag_devices = "INSERT INTO mag_devices (user_id , bright , contrast , saturation  , video_out , volume , playback_buffer_bytes , playback_buffer_size , audio_out , mac , locale , city_id , hd , main_notify , fav_itv_on , now_playing_start , now_playing_type , now_playing_content , time_last_play_tv , time_last_play_video , hd_content , image_version , last_change_status , last_start , last_active , keep_alive , playback_limit , screensaver_delay , stb_type , sn , last_watchdog , created , country , plasma_saving , ts_enabled , ts_enable_icon , ts_path , ts_max_length , ts_buffer_use , ts_action_on_exit , ts_delay , video_clock , rtsp_type , rtsp_flags , stb_lang , display_menu_after_loading , record_max_length , plasma_saving_timeout , parent_password , spdif_mode , show_after_loading , play_in_preview_by_ok , hdmi_event_reaction ,play_in_preview_only_by_ok) 
                                 VALUES ('" . $lastinsertid . "' , 200 , 127 , 127 , 'rca' , 50 , 0 , 0 , 1 , '" . base64_encode($newmac) . "' , 'en_GB.utf8' , 0 , 1 , 1 , 0 , NULL , 0 , NULL , NULL , NULL , 1 , NULL , NULL , NULL , NULL , NULL , 3 , 10 ,'' , NULL , NULL , '" . strtotime(date('Y-m-d')) . "' , NULL , 0 , 0 , 1 , NULL , 3600 , 'cyclic' , 'no_save' , 'on_pause' , 'Off' , 4 , 0 , 'en' , 1 , 180 , 600 , '" . (!empty($returndata['parentpassword']) ? $returndata['parentpassword'] : 0) . "' , 1 , 'main_menu' , 1 , 1 ,'true')";
        $mag_devicesresult = mysqli_query($con, $mag_devices);
        if (!$mag_devicesresult) {
            $radiussqlerror = mysqli_error($con);
            NXT_WHMCSReconnect();
            return "NXT Database Query Error: " . $radiussqlerror;
        }
        $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
        $returndata = array();
        if (isset($xtreamConfig) && !empty($xtreamConfig)) {
            foreach ($xtreamConfig as $config) {
                $returndata[$config->setting] = $config->value;
            }
        }
        NXT_AddUpdateCustomfield($params);
    }
    return 'success';
}

function NXT_AddUpdateCustomfield($params)
{
    //Update/Add Custom Field data 
    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    $serviceid = $params["serviceid"];
    # Inserting Now New User into 
    // First checking if user already exist with reqeuest username  

    $reseller_notes = $returndata['common_identifier'] . $serviceid;
    $con = NXTXtreamCodeTestConnection($params['pid']);
    $usersresult = mysqli_query($con, "SELECT id, exp_date FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1'");
    if (!$usersresult) {
        $radiussqlerror = mysqli_error($con);
        NXT_WHMCSReconnect();
        return "NXT Database Query Error: " . $radiussqlerror;
    }

    if (mysqli_num_rows($usersresult) > 0) {
        while ($userid = mysqli_fetch_assoc($usersresult)) {
            $resultmag_devices = mysqli_query($con, "SELECT * FROM mag_devices WHERE user_id='" . $userid['id'] . "'");
            if (mysqli_num_rows($resultmag_devices) != 0) {
                $magdevice = mysqli_fetch_assoc($resultmag_devices);
                $magdevicearray[] = base64_decode($magdevice['mac']);
            }
        }
    }
    $newmac = implode(',', $magdevicearray);
    $fieldid = Capsule::table('tblcustomfields')
        ->where('fieldname', $returndata['custom_field_mag'])
        ->where('type', 'product')
        ->where('relid', $params['packageid'])
        ->get();
    if (isset($fieldid) && !empty($fieldid)) {
        $checkExists = Capsule::table('tblcustomfieldsvalues')
            ->where('relid', $params['serviceid'])
            ->where('fieldid', $fieldid[0]->id)
            ->get();
        if (isset($checkExists) && !empty($checkExists)) {
            Capsule::table('tblcustomfieldsvalues')
                ->where('relid', $params['serviceid'])
                ->where('fieldid', $fieldid[0]->id)
                ->update(['value' => $newmac]);
        } else {
            Capsule::table('tblcustomfieldsvalues')->insert(
                ['fieldid' => $fieldid[0]->id, 'relid' => $params['serviceid'], 'value' => $newmac]
            );
        }
    }
}

function NXT_UpdateMAG(array $params)
{
    $is_trial = ($params['configoption5'] == 'Yes') ? '1' : '0';
    $Bouquets = isset($params['customfields']['Select Bouquets']) && !empty($params['customfields']['Select Bouquets']) ? trim($params['customfields']['Select Bouquets']) : $params['configoption10'];
    $CheckBouquets = NXT_ProductAddonsPack($params, $Bouquets);
    if ($CheckBouquets != "") {
        $Bouquets = $CheckBouquets;
    }
    $syn_expiry = $params['configoption17'];
    if ($is_trial == 1) {
        $trial_period = ($params['configoption18'] != 0) ? '+' . $params['configoption18'] . ' hours' : '+24 hours';
    } else {
        $day_period = ($params['configoption18'] != 0) ? '+' . $params['configoption18'] . ' days' : '+24 days';
    }
    $billing_months = $params['configoption21'];
    $tblhostingdetails = Capsule::table('tblhosting')->where('id', '=', $params["serviceid"])->get();
    $nextduedate = $tblhostingdetails[0]->nextduedate;
    $serviceid = $tblhostingdetails[0]->id;

    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    $con = NXTXtreamCodeTestConnection($params['pid']);
    $username = $params['username'] . $returndata['common_identifier'] . $serviceid;
    $reseller_notes = $returndata['common_identifier'] . $serviceid;
    $result = mysqli_query($con, "SELECT id, exp_date FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1'");

    $expdate = 'NULL';
    if ($is_trial == 1 && $nextduedate != '0000-00-00') {
        $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
    } else {
        if ($syn_expiry == 'on' && $nextduedate != '0000-00-00') {
            $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
            if ($is_trial == 0) {
                $userxtremcode = mysqli_fetch_assoc($result);
                $expdatefromxtreamcode = date('Y-m-d H:i:s', $userxtremcode['exp_date']);
                if (strtotime(date('Y-m-d H:i:s')) > $userxtremcode['exp_date']) {
                    $effectiveDate = date('Y-m-d H:i:s', strtotime($day_period, strtotime(date('Y-m-d H:i:s'))));
                } else {
                    $effectiveDate = date('Y-m-d H:i:s', strtotime($day_period, strtotime($expdatefromxtreamcode)));
                }
                $expdate = strtotime($effectiveDate);
            }
        } elseif ($is_trial == 1) {
            $expdate = strtotime(date("Y-m-d H:i:s", strtotime($trial_period)));
        } elseif ($is_trial == 0 && $nextduedate == '0000-00-00' && $billing_months != "" && $billing_months != 0) {
            $effectiveDate = date('Y-m-d H:i:s', strtotime("+" . $billing_months . " months", strtotime(date('Y-m-d H:i:s'))));
            $expdate = strtotime($effectiveDate);
        } elseif ($is_trial == 0 && $nextduedate != '0000-00-00') {
            $userxtremcode = mysqli_fetch_assoc($result);
            $expdatefromxtreamcode = date('Y-m-d H:i:s', $userxtremcode['exp_date']);
            if (strtotime(date('Y-m-d H:i:s')) > $userxtremcode['exp_date']) {
                $effectiveDate = date('Y-m-d H:i:s', strtotime($day_period, strtotime(date('Y-m-d H:i:s'))));
            } else {
                $effectiveDate = date('Y-m-d H:i:s', strtotime($day_period, strtotime($expdatefromxtreamcode)));
            }
            $expdate = strtotime($effectiveDate);
        }
    }
    if (GetConfigXtreamDetailsHourDiff() != "" && $expdate != "NULL") {
        $expdate = $expdate + 60 * 60 * GetConfigXtreamDetailsHourDiff();
    }


    if (mysqli_num_rows($result) > 0) {
        $xcuser = mysqli_fetch_assoc($result);
        $xtreamuserid = $xcuser['id'];
        if ($is_trial == 0 && $params['configoption18'] > 0 && !empty($params['configoption18'])) {
            Capsule::table('tblhosting')->where('id', $serviceid)->update(['nextduedate' => date("Y-m-d", $expdate), 'nextinvoicedate' => date("Y-m-d", $expdate),]);
        }
        $query = "UPDATE users SET `bouquet`='$Bouquets',`exp_date`=$expdate,`is_trial`='$is_trial' WHERE id='$xtreamuserid'";
        $result = mysqli_query($con, $query);
        if (!$result) {
            $radiussqlerror = mysqli_error($con);
            NXT_WHMCSReconnect();
            return "NXT Database Query Error: " . $radiussqlerror;
        }
        NXT_WHMCSReconnect();
        logModuleCall(
            'NXT',
            __FUNCTION__,
            'Upgrade Account: ' . $username,
            'success'
        );
        return "success";
    }
    return 'success';
}

function NXT_DeleteMAG($params, $deletemag)
{
    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    $reseller_notes = $returndata['common_identifier'] . $params["serviceid"];
    if (!empty($params['customfields'][$returndata['custom_field_mag']])) {
        $con = NXTXtreamCodeTestConnection($params['pid']);
        $result = mysqli_query($con, "SELECT users.id  FROM users INNER JOIN mag_devices ON mag_devices.user_id = users.id WHERE mag_devices.mac = '" . base64_encode($deletemag) . "'
   AND users.reseller_notes = '$reseller_notes' AND users.is_mag = '1'");
    }
    if (mysqli_num_rows($result) != 0) {
        $pairid = mysqli_fetch_assoc($result);
        if (isset($pairid['id']) && !empty($pairid['id'])) {
            $mag_devices = mysqli_query($con, "DELETE FROM `mag_devices` WHERE user_id='" . $pairid['id'] . "'");
            $result = mysqli_query($con, "DELETE FROM users WHERE id='" . $pairid['id'] . "' AND is_mag='1'");
        }
        if (!$result) {
            NXT_WHMCSReconnect();
            return "NXT Database Query Error: " . mysqli_error($con);
        }
    } else {
        return 'macnotexists';
    }
    NXT_WHMCSReconnect();
    logModuleCall(
        'NXT',
        __FUNCTION__,
        'MAG Deleted: ' . $deletemag,
        'success'
    );
    return 'success';
}

function NXT_UpdateENG(array $params)
{
    $is_trial = ($params['configoption5'] == 'Yes') ? '1' : '0';
    $Bouquets = isset($params['customfields']['Select Bouquets']) && !empty($params['customfields']['Select Bouquets']) ? trim($params['customfields']['Select Bouquets']) : $params['configoption10'];
    $CheckBouquets = NXT_ProductAddonsPack($params, $Bouquets);
    if ($CheckBouquets != "") {
        $Bouquets = $CheckBouquets;
    }
    $syn_expiry = $params['configoption17'];
    $trial_period = ($params['configoption18'] != 0) ? '+' . $params['configoption18'] . ' hours' : '+24 hours';
    $billing_months = $params['configoption21'];
    $tblhostingdetails = Capsule::table('tblhosting')->where('id', '=', $params["serviceid"])->get();
    $nextduedate = $tblhostingdetails[0]->nextduedate;
    $serviceid = $tblhostingdetails[0]->id;
    $expdate = 'NULL';
    if ($is_trial == 1 && $nextduedate != '0000-00-00') {
        $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
    } else {
        if ($syn_expiry == 'on' && $nextduedate != '0000-00-00') {
            $expdate = strtotime(date("Y-m-d H:i:s", strtotime($nextduedate)));
        } elseif ($is_trial == 1) {
            $expdate = strtotime(date("Y-m-d H:i:s", strtotime($trial_period)));
        } elseif ($is_trial == 0 && $nextduedate == '0000-00-00' && $billing_months != "" && $billing_months != 0) {
            $effectiveDate = date('Y-m-d H:i:s', strtotime("+" . $billing_months . " months", strtotime(date('Y-m-d H:i:s'))));
            $expdate = strtotime($effectiveDate);
        }
    }
    if (GetConfigXtreamDetailsHourDiff() != "" && $expdate != "NULL") {
        $expdate = $expdate + 60 * 60 * GetConfigXtreamDetailsHourDiff();
    }
    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    $con = NXTXtreamCodeTestConnection($params['pid']);
    $username = $params['username'] . $returndata['common_identifier'] . $serviceid;
    $reseller_notes = $returndata['common_identifier'] . $serviceid;
    $result = mysqli_query($con, "SELECT id FROM users WHERE reseller_notes='$reseller_notes' AND is_e2='1'");
    if (mysqli_num_rows($result) > 0) {
        $xcuser = mysqli_fetch_assoc($result);
        $xtreamuserid = $xcuser['id'];
        $query = "UPDATE users SET `bouquet`='$Bouquets',`exp_date`=$expdate,`is_trial`='$is_trial' WHERE id='$xtreamuserid'";
        $result = mysqli_query($con, $query);
        if (!$result) {
            $radiussqlerror = mysqli_error($con);
            NXT_WHMCSReconnect();
            return "NXT Database Query Error: " . $radiussqlerror;
        }
        NXT_WHMCSReconnect();
        logModuleCall(
            'NXT',
            __FUNCTION__,
            'Upgrade Account: ' . $username,
            'success'
        );
        return "success";
    }
    return 'success';
}

function NXTXtreamAPI_apicall($url, $method, $data = NULL)
{
    $requesturl = $url;
    $curl = curl_init($requesturl);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
    switch ($method) {
        case "POST":
            curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($curl, CURLOPT_POST, true);
            if ($data)
                curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
            break;
        case "PUT":
            curl_setopt($curl, CURLOPT_POST, true);
            curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "PUT"); // note the PUT here 
            curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
            break;
        case "DELETE":
            curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "DELETE");
            break;
    }
    curl_setopt($curl, CURLOPT_TIMEOUT, 100);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($curl, CURLOPT_HTTPHEADER, array(
        "Authorization: Basic " . $header
    ));
    $jsondata = curl_exec($curl);
    if (curl_error($curl)) {
        $error = "Connection Error: " . curl_errno($curl) . ' - ' . curl_error($curl);
        return array(
            'errorCode' => 007,
            'userMessage' => $error
        );
    }
    curl_close($curl);
    $arr = json_decode($jsondata, true); # Decode JSON String 
    return $arr;
}

/**
 * Test connection with the given server parameters. 
 */
function NXT_TestConnection(array $params)
{

    try {

        $sqlusername = $params["serverusername"];
        $sqlpassword = $params["serverpassword"];

        $sqlhost = $params["serverip"];

        list($sqldbname, $sqlport) = explode(':', $params["serveraccesshash"]);
        if (isset($sqlport) && !empty($sqlport))
            $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname, $sqlport);
        else
            $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname);

        // Check connection
        if (mysqli_connect_errno()) {
            $success = false;
            $errorMsg = "Failed to connect to MySQL: " . mysqli_connect_error();
        } else {
            $success = true;
            $errorMsg = '';
        }
    } catch (Exception $e) {
        // Record the error in WHMCS's module log.
        logModuleCall(
            'NXT',
            __FUNCTION__,
            $params,
            $e->getMessage(),
            $e->getTraceAsString()
        );

        $success = false;
        $errorMsg = $e->getMessage();
    }
    NXT_WHMCSReconnect();
    return array(
        'success' => $success,
        'error' => $errorMsg,
    );
}

function NXT_GetServerHostname($ProductId = "")
{
    $returnData = "";
    $Hostname = Capsule::table('tblproducts')
        ->join('tblservergroupsrel', 'tblproducts.servergroup', '=', 'tblservergroupsrel.groupid')
        ->join('tblservers', 'tblservergroupsrel.serverid', '=', 'tblservers.id')
        ->where('tblproducts.id', $ProductId)
        ->select('tblservers.hostname')
        ->get();
    if (!empty($Hostname)) {
        $returnData = $Hostname[0]->hostname;
    }
    return $returnData;
}

function NXT_ClientArea(array $params)
{
    /* $params['ServerHostName'] = $params['templatevars']['moduleParams']['serverhostname'];
      //Condition to check hostname is exists or not
      if ($params['templatevars']['moduleParams']['serverhostname'] == "") {
      $GetPackageID = Capsule::table('tblhosting')
      ->where('id', $params['serviceid'])
      ->select('packageid')
      ->get();
      if (!empty($GetPackageID)) {
      $PackaeID = $GetPackageID[0]->packageid;
      $params['ServerHostName'] = NXT_GetServerHostname($PackaeID);
      }
      } */

    // Determine the requested action and set service call parameters based on
    // the action.

    $response = '';
    $access_outputdata = array();
    $xtreamConfig = Capsule::table('mod_xtreamConfig')->get();
    $returndata = array();
    if (isset($xtreamConfig) && !empty($xtreamConfig)) {
        foreach ($xtreamConfig as $config) {
            $returndata[$config->setting] = $config->value;
        }
    }
    $portURL = $returndata['portalurl'];


    /* $bar = "/";
      echo substr($portURL, -1);

      if(substr($portURL, -1) == "/")
      {
      $bar =  "";
      }
      $portURL = $portURL.$bar; */




    $params['ServerHostName'] = $portURL;
    $removecustomfields = array($returndata['custom_field_mag'], $returndata['checkmagdevice'], $returndata['custom_field_eng'], $returndata['checkengdevice'], 'Username', 'Password');
    $customfieldfrontend = $params['customfields'];
    foreach ($removecustomfields as $removefield) {
        unset($customfieldfrontend[$removefield]);
    }
    $con = NXTXtreamCodeTestConnection($params['pid']);
    $reseller_notes = $returndata['common_identifier'] . $params["serviceid"];
    $requestedAction = isset($_REQUEST['customAction']) ? $_REQUEST['customAction'] : '';
    if ($requestedAction == 'addMAG') {
        if (!preg_match('/([0-9A-Fa-f]{2}[:]){5}([0-9A-Fa-f]{2})/', $_POST['newMAC'])) {
            $response = 'error';
            $result = 'MAC Address is not Valid!';
        } else {
            $macexists = NXT_CheckMAG($_POST['newMAC'], $con);
            if (empty($macexists)) {
                $response = NXT_AddMAG($params, $_POST['newMAC']);
                if ($response == 'success') {
                    $result = $returndata['mac_add_success'] . ' ' . $_POST['newMAC'];
                }
            } elseif ($macexists == 'macexists') {
                $response = 'error';
                $result = $returndata['mac_error'];
            }
        }
    } elseif ($requestedAction == 'changeMAG') {
        if (isset($params['configoptions'][$returndata['configoption_field_name']]) && !empty($params['configoptions'][$returndata['configoption_field_name']])) {
            if (isset($_POST['savechanges']) && !empty($_POST['savechanges'])) {
                if (!preg_match('/([0-9A-Fa-f]{2}[:]){5}([0-9A-Fa-f]{2})/', $_POST['newMAC'])) {
                    $response = 'error';
                    $result = 'MAC Address is not Valid!';
                } else {
                    $response = NXT_ChangeMAG($params, $_POST['newMAC'], $_POST['oldmag']);
                    if ($response == 'success') {
                        $result = $returndata['mac_change_success'];
                    } elseif ($response == 'macexists') {
                        $result = $returndata['mac_error'];
                    }
                }
            } elseif (isset($_POST['delete']) && !empty($_POST['delete'])) {
                $response = NXT_DeleteMAG($params, $_POST['oldmag']);
                if ($response == 'success') {
                    $result = "MAC Address Deleted Successfully!!";
                } elseif ($response == 'macnotexists') {
                    $result = "MAC Address doesn't exist!";
                }
            }
        } else {
            if (!preg_match('/([0-9A-Fa-f]{2}[:]){5}([0-9A-Fa-f]{2})/', $_POST['newMAC'])) {
                $response = 'error';
                $result = 'MAC Address is not Valid!';
            } else {
                $response = NXT_ChangeMAGSingle($params, $_POST['newMAC']);
                if ($response == 'success') {
                    $result = $returndata['mac_change_success'];
                } elseif ($response == 'macexists') {
                    $result = $returndata['mac_error'];
                }
            }
        }
    } elseif ($requestedAction == 'addENG') {
        $response = NXT_AddENG($params, $_POST['newMAC']);
        if ($response == 'success') {
            $magdata = $_POST['newMAC'];
            $result = $returndata['mac_add_success'] . ' ' . $_POST['newMAC'];
        }
    } elseif ($requestedAction == 'changeENG') {
        $response = NXT_ChangeENG($params, $_POST['newMAC']);
        if ($response == 'success') {
            $magdata = $_POST['newMAC'];
            $result = $returndata['mac_change_success'];
        } elseif ($response == 'macexists') {
            $result = $returndata['mac_error'];
        }
    } elseif ($requestedAction == 'changePassword') {
        $response = NXT_PasswordChange($params, $_POST['newPassword']);
        if ($response == 'success') {
            $newPassword = $_POST['newPassword'];
            $result = 'Password Changed successfully';
        } elseif ($response == 'error') {
            $result = 'Error Occurr while updateing password!';
        }
    }
    if ($params['configoption2'] == 'magdevice') {
        $responsedata = NXTXtreamMAGDevice($params, $returndata, $response, $result);
        $templateFile = $responsedata['templateFile'];
        $variabledata = $responsedata['variabledata'];
        if ($requestedAction == "jass") {
            $templateFile = 'templates/custommagtemplate.tpl';
        }
    } elseif ($params['configoption2'] == 'engdevice') {
        $responsedata = NXTXtreamENGDevice($params, $returndata, $magdata, $response, $result);
        $templateFile = $responsedata['templateFile'];
        $variabledata = $responsedata['variabledata'];
    } elseif ($params['configoption2'] == 'streamlineonly') {
        $xtreamautoscipt = Capsule::table('mod_xtreamautoscript')->get();
        foreach ($xtreamautoscipt as $value) {
            $autoscript[$value->name] = $value->value;
        }
        $autoscriptconfig = ($params['configoption19'] == 'on') ? "on" : "";
        $otherdevicesconfig = ($params['configoption20'] == 'on') ? "on" : "";
        if ($requestedAction == 'manage') {
            //Get Access Output Code'
            $access_output = mysqli_query($con, "SELECT * FROM access_output");
            while ($output = mysqli_fetch_assoc($access_output)) {
                if ($output['output_name'] == 'MPEGTS') {
                    $outputfirst = $output['output_key'];
                }
                $access_outputdata[] = $output;
            }
            if (empty($outputfirst)) {
                $outputfirst = array_values($access_outputdata)[0]['output_key'];
            }
            // Collecting parameters 
            $serviceAction = 'get_usage';
            $templateFile = 'templates/manage.tpl';
        } else {
            $iptvusername = $params["username"];
            $con = NXTXtreamCodeTestConnection($params['pid']);
            $usersresult = mysqli_query($con, "SELECT id, exp_date FROM users WHERE username='$iptvusername' AND reseller_notes='$reseller_notes'");
            if (!$usersresult) {
                $radiussqlerror = mysqli_error($con);
                NXT_WHMCSReconnect();
                return "NXT Database Query Error: " . $radiussqlerror;
            }
            if (mysqli_num_rows($usersresult) > 0) {
                $userid = mysqli_fetch_assoc($usersresult);
                $serviceAction = 'get_stats';
                $templateFile = 'templates/overview.tpl';
            } else {
                $error = 'User Not found!';
                $templateFile = 'templates/error.tpl';
            }
        }

        $variabledata = array(
            'iptv_username' => $params['username'],
            'iptv_password' => $params['password'],
            'ServerHostName' => $params['ServerHostName'],
            'response' => $response,
            'message' => isset($result) && !empty($result) ? $result : $response,
            'lang' => $returndata,
            'autoscript' => $autoscript,
            'autoscriptconfig' => $autoscriptconfig,
            'otherdevicesconfig' => $otherdevicesconfig,
            'm3ulink' => $params['configoption8'],
            'watchstream' => $params['configoption11'],
            'mag_portal' => $params['configoption15'],
            'usefulErrorHelper' => isset($error) && !empty($error) ? $error : '',
            'accessoutput' => $access_outputdata,
            'outputfirst' => $outputfirst,
            'm3ulinkoutput' => (isset($outputfirst) && !empty($outputfirst) ? $outputfirst : 'xxx'),
            'status' => $params['status'],
            'exp_date' => isset($userid['exp_date']) && !empty($userid['exp_date']) ? date('Y-m-d H:i:s', $userid['exp_date']) : ''
        );
    } elseif ($params['configoption2'] == 'streamline' || $params['configoption2'] == 'streamlineeng') {
        $xtreamautoscipt = Capsule::table('mod_xtreamautoscript')->get();
        foreach ($xtreamautoscipt as $value) {
            $autoscript[$value->name] = $value->value;
        }
        $autoscriptconfig = ($params['configoption19'] == 'on') ? "on" : "";
        $otherdevicesconfig = ($params['configoption20'] == 'on') ? "on" : "";

        $checkmagdevice = $params['customfields'][$returndata['checkmagdevice']];
        $checkengdevice = $params['customfields'][$returndata['checkengdevice']];
        if (isset($checkmagdevice) && !empty($checkmagdevice)) {
            if ($checkmagdevice == 'on') {
                $responsedata = NXTXtreamMAGDevice($params, $returndata, $response, $result);
                $templateFile = $responsedata['templateFile'];
                $variabledata = $responsedata['variabledata'];
            }
        } elseif (isset($checkengdevice) && !empty($checkengdevice)) {
            if ($checkengdevice == 'on') {
                $responsedata = NXTXtreamENGDevice($params, $returndata, $magdata, $response, $result);
                $templateFile = $responsedata['templateFile'];
                $variabledata = $responsedata['variabledata'];
            }
        } else {
            if ($requestedAction == 'manage') {
                $MAC = 'None';
                $con = NXTXtreamCodeTestConnection($params['pid']);
                //Get Access Output Code'
                $access_output = mysqli_query($con, "SELECT * FROM access_output");

                while ($output = mysqli_fetch_assoc($access_output)) {
                    if ($output['output_name'] == 'MPEGTS') {
                        $outputfirst = $output['output_key'];
                    }
                    $access_outputdata[] = $output;
                }
                if (empty($outputfirst)) {
                    $outputfirst = array_values($access_outputdata)[0]['output_key'];
                }
                // Collecting parameters
                $iptvusername = $params["username"];
                $iptvusernameresult = mysqli_query($con, "SELECT * FROM users WHERE username='$iptvusername' AND reseller_notes='$reseller_notes'");
                // $iptvusernameresult = mysqli_query($con, "SELECT * FROM users WHERE username='$iptvusername'");
                if (mysqli_num_rows($iptvusernameresult) == 0) {
                    NXT_WHMCSReconnect();
                    return "User Not Found!!";
                } else {
                    $pairid = mysqli_fetch_assoc($iptvusernameresult);
                    if (isset($pairid['pair_id']) && !empty($pairid['pair_id'])) {
                        $mag_devices = mysqli_query($con, "SELECT * FROM `mag_devices` WHERE user_id='" . $pairid['pair_id'] . "'");
                        if (mysqli_num_rows($mag_devices) == 0) {
                            $eng_devices = mysqli_query($con, "SELECT * FROM `enigma2_devices` WHERE user_id='" . $pairid['pair_id'] . "'");
                            if (mysqli_num_rows($eng_devices) == 0) {
                                $MAC = 'None';
                            } else {
                                $engdetails = mysqli_fetch_assoc($eng_devices);
                                if (isset($engdetails) && !empty($engdetails)) {
                                    $MAC = $engdetails['mac'];
                                }
                            }
                        } else {
                            $mag_details = mysqli_fetch_assoc($mag_devices);
                            if (isset($mag_details) && !empty($mag_details)) {
                                $MAC = base64_decode($mag_details['mac']);
                            }
                        }
                    } else {
                        $MAC = 'None';
                    }
                }
                $serviceAction = 'get_usage';
                $templateFile = 'templates/manage.tpl';
            } else {
                $iptvusername = $params["username"];
                $con = NXTXtreamCodeTestConnection($params['pid']);
                $usersresult = mysqli_query($con, "SELECT id, exp_date FROM users WHERE username='$iptvusername' AND reseller_notes='$reseller_notes'");
                if (!$usersresult) {
                    $radiussqlerror = mysqli_error($con);
                    NXT_WHMCSReconnect();
                    return "NXT Database Query Error: " . $radiussqlerror;
                }
                if (mysqli_num_rows($usersresult) > 0) {
                    $userid = mysqli_fetch_assoc($usersresult);
                    $serviceAction = 'get_stats';
                    $templateFile = 'templates/overview.tpl';
                } else {
                    $error = 'User Not found!';
                    $templateFile = 'templates/error.tpl';
                }
            }
            $engima = ($params['configoption2'] == 'streamlineeng') ? 'yes' : 'no';
            $variabledata = array(
                'iptv_username' => $params['username'],
                'iptv_password' => $params['password'],
                'ServerHostName' => $params['ServerHostName'],
                'mag' => $MAC,
                'option' => 'streammag',
                'engma' => $engima,
                'response' => $response,
                'message' => isset($result) && !empty($result) ? $result : $response,
                'lang' => $returndata,
                'm3ulink' => $params['configoption8'],
                'watchstream' => $params['configoption11'],
                'mag_portal' => $params['configoption15'],
                'usefulErrorHelper' => isset($error) && !empty($error) ? $error : '',
                'accessoutput' => $access_outputdata,
                'autoscript' => $autoscript,
                'autoscriptconfig' => $autoscriptconfig,
                'otherdevicesconfig' => $otherdevicesconfig,
                'outputfirst' => $outputfirst,
                'm3ulinkoutput' => (isset($outputfirst) && !empty($outputfirst) ? $outputfirst : 'xxx'),
                'status' => $params['status'],
                'exp_date' => isset($userid['exp_date']) && !empty($userid['exp_date']) ? date('Y-m-d H:i:s', $userid['exp_date']) : ''
            );
        }
    } elseif ($params['configoption2'] == 'streamlineengmag') {
        $xtreamautoscipt = Capsule::table('mod_xtreamautoscript')->get();
        foreach ($xtreamautoscipt as $value) {
            $autoscript[$value->name] = $value->value;
        }
        $autoscriptconfig = ($params['configoption19'] == 'on') ? "on" : "";
        $otherdevicesconfig = ($params['configoption20'] == 'on') ? "on" : "";

        $checkmagdevice = $params['customfields'][$returndata['checkmagdevice']];
        $checkengdevice = $params['customfields'][$returndata['checkengdevice']];
        if (isset($checkmagdevice) && !empty($checkmagdevice)) {
            if ($checkmagdevice == 'on') {
                $responsedata = NXTXtreamMAGDevice($params, $returndata, $response, $result);
                $templateFile = $responsedata['templateFile'];
                $variabledata = $responsedata['variabledata'];
            }
        } elseif (isset($checkengdevice) && !empty($checkengdevice)) {
            if ($checkengdevice == 'on') {
                $responsedata = NXTXtreamENGDevice($params, $returndata, $magdata, $response, $result);
                $templateFile = $responsedata['templateFile'];
                $variabledata = $responsedata['variabledata'];
            }
        } else {
            if ($requestedAction == 'manage') {
                $eng_MAC = 'None';
                $mag_MAC = 'None';
                $con = NXTXtreamCodeTestConnection($params['pid']);
                //Get Access Output Code'
                $access_output = mysqli_query($con, "SELECT * FROM access_output");

                while ($output = mysqli_fetch_assoc($access_output)) {
                    if ($output['output_name'] == 'MPEGTS') {
                        $outputfirst = $output['output_key'];
                    }
                    $access_outputdata[] = $output;
                }
                if (empty($outputfirst)) {
                    $outputfirst = array_values($access_outputdata)[0]['output_key'];
                }
                // Collecting parameters
                $iptvusername = $params["username"];
                $iptvusernameresult = mysqli_query($con, "SELECT * FROM users WHERE username='$iptvusername' AND reseller_notes='$reseller_notes'");
                // $iptvusernameresult = mysqli_query($con, "SELECT * FROM users WHERE username='$iptvusername'");
                if (mysqli_num_rows($iptvusernameresult) == 0) {
                    NXT_WHMCSReconnect();
                    return "User Not Found!!";
                } else {
                    $eng_MAC = 'None';
                    $mag_MAC = 'None';
                    $pairid = mysqli_fetch_assoc($iptvusernameresult);
                    if (isset($pairid['pair_id']) && !empty($pairid['pair_id'])) {
                        if (isset($params['customfields'][$returndata['custom_field_mag']]) && !empty($params['customfields'][$returndata['custom_field_mag']])) {
                            $mag_MAC = $params['customfields'][$returndata['custom_field_mag']];
                            $mag_devices = mysqli_query($con, "SELECT * FROM `mag_devices` WHERE mac ='" . base64_encode($mag_MAC) . "'");
                            if (mysqli_num_rows($mag_devices) == 0) {
                                $mag_MAC = 'None';
                            }
                        }
                        if (isset($params['customfields'][$returndata['custom_field_eng']]) && !empty($params['customfields'][$returndata['custom_field_eng']])) {
                            $eng_MAC = $params['customfields'][$returndata['custom_field_eng']];
                            $eng_devices = mysqli_query($con, "SELECT * FROM `enigma2_devices` WHERE mac='" . $eng_MAC . "'");
                            if (mysqli_num_rows($eng_devices) == 0) {
                                $eng_MAC = 'None';
                            }
                        }
                    }
                }
                $serviceAction = 'get_usage';
                $templateFile = 'templates/manage.tpl';
            } else {
                $iptvusername = $params["username"];
                $con = NXTXtreamCodeTestConnection($params['pid']);
                $usersresult = mysqli_query($con, "SELECT id, exp_date FROM users WHERE username='$iptvusername' AND reseller_notes='$reseller_notes'");
                if (!$usersresult) {
                    $radiussqlerror = mysqli_error($con);
                    NXT_WHMCSReconnect();
                    return "NXT Database Query Error: " . $radiussqlerror;
                }
                if (mysqli_num_rows($usersresult) > 0) {
                    $userid = mysqli_fetch_assoc($usersresult);
                    $serviceAction = 'get_stats';
                    $templateFile = 'templates/overview.tpl';
                } else {
                    $error = 'User Not found!';
                    $templateFile = 'templates/error.tpl';
                }
            }
            $engima = ($params['configoption2'] == 'streamlineeng') ? 'yes' : 'no';
            $variabledata = array(
                'iptv_username' => $params['username'],
                'iptv_password' => $params['password'],
                'ServerHostName' => $params['ServerHostName'],
                'engmac' => $eng_MAC,
                'magmac' => $mag_MAC,
                'option' => 'streammageng',
                'engma' => $engima,
                'response' => $response,
                'message' => isset($result) && !empty($result) ? $result : $response,
                'lang' => $returndata,
                'm3ulink' => $params['configoption8'],
                'watchstream' => $params['configoption11'],
                'mag_portal' => $params['configoption15'],
                'usefulErrorHelper' => isset($error) && !empty($error) ? $error : '',
                'accessoutput' => $access_outputdata,
                'autoscript' => $autoscript,
                'autoscriptconfig' => $autoscriptconfig,
                'otherdevicesconfig' => $otherdevicesconfig,
                'outputfirst' => $outputfirst,
                'm3ulinkoutput' => (isset($outputfirst) && !empty($outputfirst) ? $outputfirst : 'xxx'),
                'status' => $params['status'],
                'exp_date' => isset($userid['exp_date']) && !empty($userid['exp_date']) ? date('Y-m-d H:i:s', $userid['exp_date']) : ''
            );
        }
    } else {
        $templateFile = 'templates/overview.tpl';
        $variabledata = array('reseller' => 'yes');
    }

    $checkupgrade = Capsule::table('tblhosting')
        ->join('tblproducts', 'tblhosting.packageid', '=', 'tblproducts.id')
        ->join('tblproduct_upgrade_products', 'tblproducts.id', '=', 'tblproduct_upgrade_products.product_id')
        ->select('tblproduct_upgrade_products.*')
        ->where('tblhosting.id', $params['serviceid'])
        ->count();
    $checkupgrade = ($checkupgrade > 0) ? '1' : '0';
    $is_trial = ($params['configoption5'] == 'Yes') ? '1' : '0';
    $variabledata['is_trial'] = $is_trial;
    $variabledata['checkupgrade'] = $checkupgrade;
    $variabledata['service_id'] = $params['serviceid'];
    $variabledata['extracustomfields'] = $customfieldfrontend;
    try {
        NXT_WHMCSReconnect();
        return array(
            'tabOverviewReplacementTemplate' => $templateFile,
            'templateVariables' => $variabledata,
        );
    } catch (Exception $e) {
        // Record the error in WHMCS's module log.
        logModuleCall(
            'NXT',
            __FUNCTION__,
            $params,
            $e->getMessage(),
            $e->getTraceAsString()
        );

        // In an error condition, display an error page.
        return array(
            'tabOverviewReplacementTemplate' => 'error.tpl',
            'templateVariables' => array(
                'usefulErrorHelper' => $e->getMessage(),
            ),
        );
    }
}

function NXTXtreamMAGDevice($params, $returndata, $response, $result)
{
    $responsedata['variabledata'] = array(
        'usefulErrorHelper' => "User Not found!<br> 
<br>
Raise a Ticket if you this unexpected error - <a href='/submitticket.php' style='text-decoration: underline;'>Raise a Ticket</a>
<br><br>
Your services should not be Pending or Cancelled or Terminated"
    );
    $responsedata['templateFile'] = 'templates/error.tpl';
    if (!empty($params['customfields'][$returndata['custom_field_mag']])) {
        $iptvusername = $params["username"];
        $fieldid = Capsule::table('tblcustomfields')
            ->where('fieldname', $returndata['custom_field_mag'])
            ->where('type', 'product')
            ->where('relid', $params['packageid'])
            ->get();
        if (isset($fieldid) && !empty($fieldid)) {
            $checkExists = Capsule::table('tblcustomfieldsvalues')
                ->where('relid', $params['serviceid'])
                ->where('fieldid', $fieldid[0]->id)
                ->get();
            if (isset($checkExists) && !empty($checkExists)) {
                $magdata = $checkExists[0]->value;
            }
        }
        $magdevice = isset($magdata) && !empty($magdata) ? $magdata : $params['customfields'][$returndata['custom_field_mag']];
        $arraymag = explode(',', $magdevice);
        $con = NXTXtreamCodeTestConnection($params['pid']);
        $reseller_notes = $returndata['common_identifier'] . $params["serviceid"];
        # Inserting Now New User into 
        // First checking if user already exist with reqeuest username  
        $usersresult = mysqli_query($con, "SELECT id, exp_date FROM users WHERE reseller_notes='$reseller_notes' AND is_mag='1'");
        if (!$usersresult) {
            $radiussqlerror = mysqli_error($con);
            NXT_WHMCSReconnect();
            return "NXT Database Query Error: " . $radiussqlerror;
        }

        if (mysqli_num_rows($usersresult) > 0) {
            while ($userid = mysqli_fetch_assoc($usersresult)) {
                foreach ($arraymag as $mag) {
                    $resultmag_devices = mysqli_query($con, "SELECT * FROM mag_devices WHERE user_id='" . $userid['id'] . "' AND mac ='" . base64_encode($mag) . "'");
                    if (mysqli_num_rows($resultmag_devices) != 0) {
                        $magdevicearray[] = $mag;
                    }
                }
            }
            if (isset($params['configoptions'][$returndata['configoption_field_name']]) && !empty($params['configoptions'][$returndata['configoption_field_name']])) {
                $responsedata['templateFile'] = 'templates/magtemplate.tpl';
            } else {
                $responsedata['templateFile'] = 'templates/magtemplateSingle.tpl';
            }


            $responsedata['variabledata'] = array(
                'ServerHostName' => $params['ServerHostName'],
                'mag' => implode(',', $magdevicearray),
                'arraymag' => $magdevicearray,
                'response' => $response,
                'message' => isset($result) && !empty($result) ? $result : $response,
                'lang' => $returndata,
                'engma' => 'no',
                'm3ulink' => $params['configoption8'],
                'watchstream' => $params['configoption11'],
                'mag_portal' => $params['configoption15'],
                'status' => $params['status'],
                'exp_date' => isset($userid['exp_date']) && !empty($userid['exp_date']) ? date('Y-m-d H:i:s', $userid['exp_date']) : ''
            );
        }
        return $responsedata;
    }
}

function NXTXtreamENGDevice($params, $returndata, $magdata, $response, $result)
{
    $responsedata['variabledata'] = array(
        'usefulErrorHelper' => "User Not found!<br> 
<br>
Raise a Ticket if you this unexpected error - <a href='/submitticket.php' style='text-decoration: underline;'>Raise a Ticket</a>
<br><br>
Your services should not be Pending or Cancelled or Terminated"
    );
    $responsedata['templateFile'] = 'templates/error.tpl';
    if (!empty($params['customfields'][$returndata['custom_field_eng']])) {
        $iptvusername = $params["username"];
        $magdevice = isset($magdata) && !empty($magdata) ? $magdata : $params['customfields'][$returndata['custom_field_eng']];
        $con = NXTXtreamCodeTestConnection($params['pid']);
        $reseller_notes = $returndata['common_identifier'] . $params["serviceid"];
        # Inserting Now New User into 
        // First checking if user already exist with reqeuest username  
        $usersresult = mysqli_query($con, "SELECT id, exp_date FROM users WHERE reseller_notes='$reseller_notes' AND is_e2='1'");
        if (!$usersresult) {
            $radiussqlerror = mysqli_error($con);
            NXT_WHMCSReconnect();
            return "NXT Database Query Error: " . $radiussqlerror;
        }
        if (mysqli_num_rows($usersresult) > 0) {
            $userid = mysqli_fetch_assoc($usersresult);
            $resultmag_devices = mysqli_query($con, "SELECT * FROM  enigma2_devices WHERE user_id='" . $userid['id'] . "' AND mac='" . $magdevice . "'");
            if (mysqli_num_rows($resultmag_devices) == 0) {
                $magdevice = '';
            }

            if (isset($params['configoptions'][$returndata['configoption_field_name']]) && !empty($params['configoptions'][$returndata['configoption_field_name']])) {
                $responsedata['templateFile'] = 'templates/magtemplate.tpl';
            } else {
                $responsedata['templateFile'] = 'templates/magtemplateSingle.tpl';
            }

            /* $responsedata['templateFile'] = 'templates/magtemplate.tpl'; */
            $responsedata['variabledata'] = array(
                'ServerHostName' => $params['ServerHostName'],
                'mag' => $magdevice,
                'response' => $response,
                'message' => isset($result) && !empty($result) ? $result : $response,
                'lang' => $returndata,
                'engma' => 'yes',
                'm3ulink' => $params['configoption8'],
                'watchstream' => $params['configoption11'],
                'mag_portal' => $params['configoption15'],
                'status' => $params['status'],
                'exp_date' => isset($userid['exp_date']) && !empty($userid['exp_date']) ? date('Y-m-d H:i:s', $userid['exp_date']) : ''
            );
        }
        return $responsedata;
    }
}

/*
 * Help Function
 */

function NXT_generate_ran($length = 9, $add_dashes = false, $available_sets = 'lud')
{
    $sets = array();
    if (strpos($available_sets, 'l') !== false)
        $sets[] = 'abcdefghjkmnpqrstuvwxyz';
    if (strpos($available_sets, 'u') !== false)
        $sets[] = 'ABCDEFGHJKMNPQRSTUVWXYZ';
    if (strpos($available_sets, 'd') !== false)
        $sets[] = '0123456789';
    $all = '';
    $password = '';
    foreach ($sets as $set) {
        $password .= $set[array_rand(str_split($set))];
        $all .= $set;
    }
    $all = str_split($all);
    for ($i = 0; $i < $length - count($sets); $i++)
        $password .= $all[array_rand($all)];
    $password = str_shuffle($password);
    if (!$add_dashes)
        return $password;
    $dash_len = floor(sqrt($length));
    $dash_str = '';
    while (strlen($password) > $dash_len) {
        $dash_str .= substr($password, 0, $dash_len) . '-';
        $password = substr($password, $dash_len);
    }
    $dash_str .= $password;
    return $dash_str;
}

function NXT_WHMCSReconnect()
{
    require(ROOTDIR . "/configuration.php");
    $whmcsmysql = mysqli_connect($db_host, $db_username, $db_password, $db_name);
}

function NXT_whmcsadmin()
{
    $whmcsadmin = Capsule::table('tbladmins')
        ->where('id', '1')
        ->get();
    return $whmcsadmin[0]->username;
}

function NXTcheckAffexists($clientid)
{
    $data = Capsule::table('mod_xtreamAffs_clients')
        ->where('clientid', $clientid)
        ->get();
    if (isset($data) && !empty($data)) {
        $clientemail = Capsule::table('tblclients')
            ->join('tblaffiliates', 'tblaffiliates.clientid', '=', 'tblclients.id')
            ->where('tblaffiliates.id', '=', $data[0]->affiliatesid)
            ->select('tblclients.email')->get();
        if (isset($clientemail) && !empty($clientemail))
            return $clientemail[0]->email;
        else
            return '';
    }
    return '';
}

//Check Connection 
function NXTXtreamCodeTestConnection($productId, $selected = 'product')
{
    if (basename($_SERVER['SCRIPT_NAME']) == "configaddons.php" || $selected == 'addon') {
        $servers = Capsule::table('tbladdons')
            ->join('tblservergroupsrel', 'tbladdons.server_group_id', '=', 'tblservergroupsrel.groupid')
            ->join('tblservers', 'tblservergroupsrel.serverid', '=', 'tblservers.id')
            ->where('tbladdons.id', '=', $productId)
            ->select('tblservers.*')
            ->get();
    } else {
        $servers = Capsule::table('tblproducts')
            ->join('tblservergroupsrel', 'tblproducts.servergroup', '=', 'tblservergroupsrel.groupid')
            ->join('tblservers', 'tblservergroupsrel.serverid', '=', 'tblservers.id')
            ->where('tblproducts.id', '=', $productId)
            ->select('tblservers.*')
            ->get();
    }
    if (isset($servers) && !empty($servers)) {

        foreach ($servers as $server) {
            $sqlusername = $server->username;
            $sqlpassword = decrypt($server->password);
            $sqldbname = $server->accesshash;
            $sqlhost = $server->ipaddress;
            list($sqldbname, $sqlport) = explode(':', $sqldbname);
            if (isset($sqlport) && !empty($sqlport))
                $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname, $sqlport);
            else
                $con = mysqli_connect($sqlhost, $sqlusername, $sqlpassword, $sqldbname);

            // Check connection 
            if (!$con) {
                NXT_WHMCSReconnect();
                logModuleCall('NXT', 'Check Connection', 'Connection', "Failed to connect to MySQL: " . mysqli_connect_error(), '', '');
                return true;
            }
        }
    }
    return $con;
}

function NXT_CheckMAG($newmac, $con)
{
    // First checking if user already exist with reqeuest username  
    $resultmag_devices = mysqli_query($con, "SELECT * FROM mag_devices WHERE mac = '" . base64_encode($newmac) . "'");
    if (mysqli_num_rows($resultmag_devices) > 0) {
        return 'macexists';
    }
}

function NXT_CheckENG($newmac, $con)
{
    $result_devices = mysqli_query($con, "SELECT * FROM enigma2_devices WHERE mac = '" . $newmac . "'");
    if (mysqli_num_rows($result_devices) != 0) {
        return 'macexists';
    }
}

function NXTXtreamCodeCheckLicenseByKey()
{
    $result = Capsule::table('tbladdonmodules')
        ->where('module', '=', 'nxtdashboard')
        ->get();
    foreach ($result as $row) {
        $settings[$row->setting] = $row->value;
    }
    if ($settings['license']) {
        $localkey = $settings['localkey'];
        $result = NXTXtreamCodeCheckLicense($settings['license'], $localkey);
        $result['licensekey'] = $settings['license'];
    } else {
        $result['status'] = 'licensekeynotfound';
    }
    return $result;
}

function NXTXtreamCodeCheckLicense($licensekey, $localkey = '')
{
    $whmcsurl = "https://www.whmcssmarters.com/clients/";
    $licensing_secret_key = "cloudtvmedia";
    $localkeydays = 14;
    $allowcheckfaildays = 5;
    $check_token = time() . md5(mt_rand(1000000000, 9999999999) . $licensekey);
    $checkdate = date("Ymdhis");
    if (!isset($_SERVER['SERVER_NAME']) && empty($_SERVER['SERVER_NAME'])) {
        $results['status'] = "Active";
        return $results;
    }
    $domain = $_SERVER['SERVER_NAME'];
    $usersip = isset($_SERVER['SERVER_ADDR']) ? $_SERVER['SERVER_ADDR'] : $_SERVER['LOCAL_ADDR'];
    $dirpath = dirname(dirname(__DIR__)) . '/addons/nxtdashboard';
    $verifyfilepath = 'modules/servers/licensing/verify.php';
    $localkeyvalid = false;
    if ($localkey) {
        $localkey = str_replace("\n", '', $localkey); # Remove the line breaks
        $localdata = substr($localkey, 0, strlen($localkey) - 32); # Extract License Data
        $md5hash = substr($localkey, strlen($localkey) - 32); # Extract MD5 Hash
        if ($md5hash == md5($localdata . $licensing_secret_key)) {
            $localdata = strrev($localdata); # Reverse the string
            $md5hash = substr($localdata, 0, 32); # Extract MD5 Hash
            $localdata = substr($localdata, 32); # Extract License Data
            $localdata = base64_decode($localdata);
            $localkeyresults = unserialize($localdata);
            $originalcheckdate = $localkeyresults['checkdate'];
            if ($md5hash == md5($originalcheckdate . $licensing_secret_key)) {
                $localexpiry = date("Ymdhis", mktime(date("h"), date("i"), date("s"), date("m"), date("m"), date("d") - $localkeydays, date("Y")));
                if ($originalcheckdate > $localexpiry) {
                    $localkeyvalid = true;
                    $results = $localkeyresults;
                    $validdomains = explode(',', $results['validdomain']);
                    if (!in_array($_SERVER['SERVER_NAME'], $validdomains)) {
                        $localkeyvalid = false;
                        $localkeyresults['status'] = "Invalid";
                        $results = array();
                    }
                    $validips = explode(',', $results['validip']);
                    if (!in_array($usersip, $validips)) {
                        $localkeyvalid = false;
                        $localkeyresults['status'] = "Invalid";
                        $results = array();
                    }
                    $validdirs = explode(',', $results['validdirectory']);
                    if (!in_array($dirpath, $validdirs)) {
                        $localkeyvalid = false;
                        $localkeyresults['status'] = "Invalid";
                        $results = array();
                    }
                }
            }
        }
    }
    if (!$localkeyvalid) {
        $responseCode = 0;
        $postfields = array(
            'licensekey' => $licensekey,
            'domain' => $domain,
            'ip' => $usersip,
            'dir' => $dirpath,
        );
        if ($check_token)
            $postfields['check_token'] = $check_token;
        $query_string = '';
        foreach ($postfields as $k => $v) {
            $query_string .= $k . '=' . urlencode($v) . '&';
        }
        if (function_exists('curl_exec')) {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $whmcsurl . $verifyfilepath);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $query_string);
            curl_setopt($ch, CURLOPT_TIMEOUT, 30);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            $data = curl_exec($ch);
            $responseCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
        } else {
            $responseCodePattern = '/^HTTP\/\d+\.\d+\s+(\d+)/';
            $fp = @fsockopen($whmcsurl, 80, $errno, $errstr, 5);
            if ($fp) {
                $newlinefeed = "\r\n";
                $header = "POST " . $whmcsurl . $verifyfilepath . " HTTP/1.0" . $newlinefeed;
                $header .= "Host: " . $whmcsurl . $newlinefeed;
                $header .= "Content-type: application/x-www-form-urlencoded" . $newlinefeed;
                $header .= "Content-length: " . @strlen($query_string) . $newlinefeed;
                $header .= "Connection: close" . $newlinefeed . $newlinefeed;
                $header .= $query_string;
                $data = $line = '';
                @stream_set_timeout($fp, 20);
                @fputs($fp, $header);
                $status = @socket_get_status($fp);
                while (!@feof($fp) && $status) {
                    $line = @fgets($fp, 1024);
                    $patternMatches = array();
                    if (
                        !$responseCode && preg_match($responseCodePattern, trim($line), $patternMatches)
                    ) {
                        $responseCode = (empty($patternMatches[1])) ? 0 : $patternMatches[1];
                    }
                    $data .= $line;
                    $status = @socket_get_status($fp);
                }
                @fclose($fp);
            }
        }
        if ($responseCode != 200) {
            $localexpiry = date("Ymdhis", mktime(date("h"), date("i"), date("s"), date("m"), date("m"), date("d") - ($localkeydays + $allowcheckfaildays), date("Y")));
            if ($originalcheckdate > $localexpiry) {
                $results = $localkeyresults;
            } else {
                $results = array();
                $results['status'] = "Invalid";
                $results['description'] = "Remote Check Failed";
                return $results;
            }
        } else {
            preg_match_all('/<(.*?)>([^<]+)<\/\\1>/i', $data, $matches);
            $results = array();
            foreach ($matches[1] as $k => $v) {
                $results[$v] = $matches[2][$k];
            }
        }
        if (!is_array($results)) {
            die("Invalid License Server Response");
        }
        if ($results['md5hash']) {
            if ($results['md5hash'] != md5($licensing_secret_key . $check_token)) {
                $results['status'] = "Invalid";
                $results['description'] = "MD5 Checksum Verification Failed";
                return $results;
            }
        }
        if ($results['status'] == "Active") {
            $results['checkdate'] = $checkdate;
            $data_encoded = serialize($results);
            $data_encoded = base64_encode($data_encoded);
            $data_encoded = md5($checkdate . $licensing_secret_key) . $data_encoded;
            $data_encoded = strrev($data_encoded);
            $data_encoded = $data_encoded . md5($data_encoded . $licensing_secret_key);
            $data_encoded = wordwrap($data_encoded, 80, "\n", true);
            $results['localkey'] = $data_encoded;
        }
        $results['remotecheck'] = true;
    }
    unset($postfields, $data, $matches, $whmcsurl, $licensing_secret_key, $checkdate, $usersip, $localkeydays, $allowcheckfaildays, $md5hash);
    return $results;
}

function NXT_GetClientInfoById($ClientId = "")
{
    $ReturnData = array();
    $clientData = Capsule::table('tblclients')->where('id', '=', $ClientId)->get();
    if (!empty($clientData)) {
        $ReturnData = $clientData;
    }
    return $ReturnData;
}

function NXT_sendemailWithTemplateName($TemplateName = "", $ResellerData = array(), $CLientData = array(), $HostingId = "")
{

    $emailtemplate = Capsule::table('tblemailtemplates')->where('name', '=', $TemplateName)->get();
    if (!empty($emailtemplate)) {

        $DefaultVariabeArray = array(
            'client_name',
            'service_username',
            'service_password',
            'service_payment_method',
            'service_recurring_amount',
            'service_billing_cycle',
            'service_next_due_date',
            'service_product_name',
            'service_server_hostname'
        );
        $FetchedData = NXT_GetVariableDataByhostingId($HostingId);

        $command = 'DecryptPassword';
        $postData = array(
            'password2' => $FetchedData[0]->service_password,
        );


        $results = localAPI($command, $postData, NXT_whmcsadmin());

        if ($results['result'] == "success") {
            $FetchedData[0]->service_password = $results['password'];
        }
        $EmailMessage = $emailtemplate[0]->message;
        foreach ($DefaultVariabeArray as $SKey) {
            $Variablevaule = ($FetchedData[0]->$SKey != "") ? $FetchedData[0]->$SKey : "N/A";
            $EmailMessage = str_replace('{$' . $SKey . '}', $Variablevaule, $EmailMessage);
        }

        $EmailMessage = str_replace('{$signature}', $ResellerData[0]->firstname, $EmailMessage);

        $to = $CLientData[0]->email;
        $subject = $emailtemplate[0]->subject;
        $headers = "From: " . strip_tags($ResellerData[0]->email) . "\r\n";
        $headers .= "Reply-To: " . strip_tags($CLientData[0]->email) . "\r\n";
        $headers = "MIME-Version: 1.0" . "\r\n";
        $headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
        $message = $EmailMessage;
        if (mail($to, $subject, $message, $headers, "-f " . $ResellerData[0]->email)) {
            Capsule::table('tblemails')
                ->insert(array(
                    'userid' => $CLientData[0]->id,
                    'subject' => $emailtemplate[0]->subject,
                    'message' => $message,
                    'date' => date('Y-m-d h:i:s'),
                    'to' => $to
                ));
            logModuleCall('NXT', 'Send Reseller email', 'Successfully Sent', $message, '');
        } else {

            logModuleCall('NXT', 'Send Reseller email', 'Unable to send email', $message, '');
        }
    }
}

function NXT_GetVariableDataByhostingId($HostingId)
{
    $ReturnFetuchedData = array();
    $ServiceData = Capsule::table('tblhosting')
        ->join('tblclients', 'tblhosting.userid', '=', 'tblclients.id')
        ->join('tblproducts', 'tblhosting.packageid', '=', 'tblproducts.id')
        ->where('tblhosting.id', '=', $HostingId)
        ->select(
            'tblclients.firstname as client_name',
            'tblclients.id as userid',
            'tblhosting.username as service_username',
            'tblhosting.password as service_password',
            'tblhosting.paymentmethod as service_payment_method',
            'tblhosting.amount as service_recurring_amount',
            'tblhosting.billingcycle as service_billing_cycle',
            'tblhosting.nextduedate as service_next_due_date',
            'tblproducts.name as service_product_name',
            'tblproducts.id as productId'
        )->get();
    if (!empty($ServiceData)) {
        $ServerData = Capsule::table('tblproducts')
            ->join('tblservergroupsrel', 'tblproducts.servergroup', '=', 'tblservergroupsrel.groupid')
            ->join('tblservers', 'tblservergroupsrel.serverid', '=', 'tblservers.id')
            ->where('tblproducts.id', '=', $ServiceData[0]->productId)
            ->select(
                'tblservers.hostname as service_server_hostname'
            )->get();
        $SerVerHostName = "";
        if (!empty($ServerData)) {
            $SerVerHostName = $ServerData[0]->service_server_hostname;
        }
        $ServiceData[0]->service_server_hostname = $SerVerHostName;
        $ReturnFetuchedData = $ServiceData;
    }
    return $ReturnFetuchedData;
}
